(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    138588,       4849]
NotebookOptionsPosition[    114626,       4009]
NotebookOutlinePosition[    116449,       4052]
CellTagsIndexPosition[    116362,       4047]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Styles and Fonts in Output" :> 
          Documentation`HelpLookup["paclet:tutorial/StylesAndFontsInOutput"], 
          "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Styles and Fonts in Output\"\>", 
       2->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StandardForm" :> 
          Documentation`HelpLookup["paclet:ref/StandardForm"], 
          "TraditionalForm" :> 
          Documentation`HelpLookup["paclet:ref/TraditionalForm"], "Pane" :> 
          Documentation`HelpLookup["paclet:ref/Pane"], "Panel" :> 
          Documentation`HelpLookup["paclet:ref/Panel"], "Inherited" :> 
          Documentation`HelpLookup["paclet:ref/Inherited"], "Magnify" :> 
          Documentation`HelpLookup["paclet:ref/Magnify"], "BaseStyle" :> 
          Documentation`HelpLookup["paclet:ref/BaseStyle"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StandardForm\"\>", 
       2->"\<\"TraditionalForm\"\>", 3->"\<\"Pane\"\>", 4->"\<\"Panel\"\>", 
       5->"\<\"Inherited\"\>", 6->"\<\"Magnify\"\>", 
       7->"\<\"BaseStyle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Cell Styling Options" :> 
          Documentation`HelpLookup["paclet:guide/CellStylingOptions"], 
          "Colors" :> Documentation`HelpLookup["paclet:guide/Colors"], 
          "Controls Options" :> 
          Documentation`HelpLookup["paclet:guide/ControlsOptions"], 
          "Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Font Options" :> 
          Documentation`HelpLookup["paclet:guide/FontOptions"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"], 
          "Mathematical Typesetting" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalTypesetting"], 
          "Math Typesetting Options & Tweaking" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathTypesettingOptionsAndTweaking"], 
          "Notebook Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookFormattingAndStyling"], 
          "Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"], 
          "Palettes" :> Documentation`HelpLookup["paclet:guide/Palettes"], 
          "Text Styling" :> 
          Documentation`HelpLookup["paclet:guide/TextStyling"], 
          "Textual Elements in Notebooks" :> 
          Documentation`HelpLookup["paclet:guide/TextualElementsInNotebooks"],
           "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cell Styling Options\"\>", 2->"\<\"Colors\"\>", 
       3->"\<\"Controls Options\"\>", 4->"\<\"Document Generation\"\>", 
       5->"\<\"Font Options\"\>", 
       6->"\<\"Graphics Annotation & Appearance\"\>", 
       7->"\<\"Graphics Directives\"\>", 
       8->"\<\"Mathematical Typesetting\"\>", 
       9->"\<\"Math Typesetting Options & Tweaking\"\>", 
       10->"\<\"Notebook Formatting & Styling\"\>", 
       11->"\<\"Options & Styling for Interactive Manipulation\"\>", 
       12->"\<\"Palettes\"\>", 13->"\<\"Text Styling\"\>", 
       14->"\<\"Textual Elements in Notebooks\"\>", 
       15->"\<\"New in 6.0: Formatting & Styling\"\>", 
       16->"\<\"New in 6.0: Notebooks & Documents\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Style", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Style",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Style"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["options", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays with ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " formatted using the specified option settings. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Style",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Style"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses the option settings for the specified style in the \
current notebook. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Style",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Style"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["color", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays using the specified color. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Style",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Style"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        ButtonBox["Bold",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Bold"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays with fonts made bold. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Style",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Style"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        ButtonBox["Italic",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Italic"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays with fonts made italic. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Style",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Style"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        ButtonBox["Underlined",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Underlined"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays with fonts underlined. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Style",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Style"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        ButtonBox["Larger",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Larger"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays with fonts made larger. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Style",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Style"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        ButtonBox["Smaller",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Smaller"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays with fonts made smaller. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Style",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Style"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays with font size ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Style",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Style"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        ButtonBox["Tiny",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Tiny"]}], "]"}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Style",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Style"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        ButtonBox["Small",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Small"]}], "]"}]], "InlineFormula"],
     ", etc. display with fonts that are tiny, small, etc. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->19733]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " can be used in both ordinary expressions and graphics. "
}], "Notes",
 CellID->12778],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    SubscriptBox[
     StyleBox["spec", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["spec", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " allows the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " to be any list or sequence of the following:"
}], "Notes",
 CellID->20576],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{
      SubscriptBox[
       StyleBox["opt", "TI"], 
       StyleBox["1", "TR"]], "->", 
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["1", "TR"]]}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], Cell[
    "explicit options ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\"", Cell[
    "a named style from the current stylesheets ", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell["color directive ", "TableText"], 
    Cell[TextData[{
     "color (",
     Cell[BoxData[
      ButtonBox["Red",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Red"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["RGBColor",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/RGBColor"], "[", 
       StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
     ", ",
     StyleBox["\[Ellipsis]", "TR"],
     ")]"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell["graphics directive ", "TableText"], 
    Cell[TextData[{
     "(",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Thickness",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Thickness"], "[", 
       StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
     ", ",
     StyleBox["\[Ellipsis]", "TR"],
     ") "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Bold",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Bold"], Cell[TextData[{
     "text bold (",
     Cell[BoxData[
      RowBox[{"FontWeight", "->", "\"\<Bold\>\""}]], "InlineFormula"],
     ") "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Italic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Italic"], Cell[TextData[{
     "text italic (",
     Cell[BoxData[
      RowBox[{"FontSlant", "->", "\"\<Italic\>\""}]], "InlineFormula"],
     ") "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Underlined",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Underlined"], Cell[
    "text underlined ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Larger",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Larger"], Cell["text larger ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Smaller",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Smaller"], Cell["text smaller ", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " (any number) "
    }], "TableText"], Cell[TextData[{
     "text with font size ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " (",
     Cell[BoxData[
      RowBox[{"FontSize", "->", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     ") "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Tiny",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Tiny"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Small",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Small"]], "InlineFormula"],
     ", etc. "
    }], "TableText"], Cell["text with absolute size ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->28170],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " can use any option listed in the ",
 StyleBox["Option Inspector", "SR"],
 " in the notebook front end. "
}], "Notes",
 CellID->18972],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " can use any graphics directive or list of graphics directives. "
}], "Notes",
 CellID->30244],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    SubscriptBox[
     StyleBox["spec", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["spec", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 "explicit settings given in the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " always override settings defined by named styles in the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["spec", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", regardless of the order in which they occur."
}], "Notes",
 CellID->21255],

Cell["\<\
For explicit settings, the first occurrence of a setting for a given option \
will be the one used. \
\>", "Notes",
 CellID->29791],

Cell[TextData[{
 "Directives such as ",
 Cell[BoxData[
  ButtonBox["Red",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Red"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Bold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bold"]], "InlineFormula"],
 " are treated as equivalent to their corresponding option settings."
}], "Notes",
 CellID->6015],

Cell["A few common explicit options include: ", "Notes",
 CellID->19218],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], Cell[
    "background color ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Editable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Editable"], Cell[
    "whether the contents are editable ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FontFamily",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FontFamily"], Cell[
    "font family ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Hyphenation",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Hyphenation"], Cell[
    "whether to hyphenate in text ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Magnification",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Magnification"], Cell[
    "magnification ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Selectable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Selectable"], Cell[
    "whether the contents are selectable ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->562],

Cell["A few common named styles include: ", "Notes",
 CellID->11575],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Button\>\"", Cell[
    "display like text in a system button ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Graphics\>\"", Cell[
    "display like graphics", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Input\>\"", Cell[TextData[{
     "display like ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " input "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Label\>\"", Cell[
    "display as a sans serif label", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Menu\>\"", Cell[
    "display like a system menu item ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Output\>\"", Cell[TextData[{
     "display like ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " output "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Panel\>\"", Cell[
    "display like text in a system panel ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PopupMenu\>\"", Cell[
    "display like a system popup menu ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Section\>\"", Cell[
    "display as a section heading ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SmallText\>\"", Cell[
    "display like small text ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Subsection\>\"", Cell[
    "display as a subsection heading ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Text\>\"", Cell[
    "display like ordinary text ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Title\>\"", Cell[
    "display like a title ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, {
     None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True}}}},
 CellID->10536],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " objects are nested, the specifications of the innermost one control the \
display of a particular expression. "
}], "Notes",
 CellID->13257]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->686042511],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->234705944],

Cell["Use red font color:", "ExampleText",
 CellID->56657697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "/", "x"}], "]"}], ",", "Red"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11659],

Cell[BoxData[
 StyleBox[
  SqrtBox[
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], "x"]],
  StripOnInput->False,
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Output",
 ImageSize->{70, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->205007106]
}, Open  ]],

Cell["Specify various properties of fonts:", "ExampleText",
 CellID->39986813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "[", 
  RowBox[{"Style", "[", 
   RowBox[{"\"\<AbBbCc\>\"", ",", "Blue", ",", "Italic", ",", "24"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->439867236],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   StyleBox["\<\"AbBbCc\"\>",
    StripOnInput->False,
    FrontFaceColor->RGBColor[0, 0, 1],
    BackFaceColor->RGBColor[0, 0, 1],
    GraphicsColor->RGBColor[0, 0, 1],
    FontSize->24,
    FontSlant->Italic,
    FontColor->RGBColor[0, 0, 1]]], "Text", "TR"],
  Text[
   Style["AbBbCc", 
    RGBColor[0, 0, 1], Italic, 24]]]], "Output",
 ImageSize->{86, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->359846078]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1341670],

Cell["Use predefined style:", "ExampleText",
 CellID->38969484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<AbBbCc\>\"", ",", "\"\<Title\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->364991719],

Cell[BoxData[
 StyleBox["\<\"AbBbCc\"\>", "Title",
  StripOnInput->False]], "Output",
 ImageSize->{89, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->820790916]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->115650530],

Cell["Specify the style of an individual graphic object:", "ExampleText",
 CellID->93023256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"Circle", "[", "]"}], ",", "Pink", ",", "Thick"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33805397],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], Thickness[Large], CircleBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->669396]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"Sphere", "[", "]"}], ",", "Orange"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->175370996],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 0.5, 0], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->5181273,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->964388671],

Cell["Specify the font size in printer's point:", "ExampleText",
 CellID->59840908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Text", "@", 
    RowBox[{"Style", "[", 
     RowBox[{"\"\<AaBbCc\>\"", ",", "s"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "20", ",", "30", ",", "40"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46707443],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[Cell[BoxData[
     StyleBox["\<\"AaBbCc\"\>",
      StripOnInput->False,
      FontSize->10]], "Text", "TR"],
    Text[
     Style["AaBbCc", 10]]], ",", 
   InterpretationBox[Cell[BoxData[
     StyleBox["\<\"AaBbCc\"\>",
      StripOnInput->False,
      FontSize->20]], "Text", "TR"],
    Text[
     Style["AaBbCc", 20]]], ",", 
   InterpretationBox[Cell[BoxData[
     StyleBox["\<\"AaBbCc\"\>",
      StripOnInput->False,
      FontSize->30]], "Text", "TR"],
    Text[
     Style["AaBbCc", 30]]], ",", 
   InterpretationBox[Cell[BoxData[
     StyleBox["\<\"AaBbCc\"\>",
      StripOnInput->False,
      FontSize->40]], "Text", "TR"],
    Text[
     Style["AaBbCc", 40]]]}], "}"}]], "Output",
 ImageSize->{393, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->998082844]
}, Open  ]],

Cell["Specify the font properties:", "ExampleText",
 CellID->272139200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Text", "@", 
    RowBox[{"Style", "[", 
     RowBox[{"\"\<AaBbCc\>\"", ",", "Large", ",", "p"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"Bold", ",", "Italic", ",", "Underlined", ",", "Purple"}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->373302568],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[Cell[BoxData[
     StyleBox["\<\"AaBbCc\"\>",
      StripOnInput->False,
      FontSize->Large,
      FontWeight->Bold]], "Text", "TR"],
    Text[
     Style["AaBbCc", Large, Bold]]], ",", 
   InterpretationBox[Cell[BoxData[
     StyleBox["\<\"AaBbCc\"\>",
      StripOnInput->False,
      FontSize->Large,
      FontSlant->Italic]], "Text", "TR"],
    Text[
     Style["AaBbCc", Large, Italic]]], ",", 
   InterpretationBox[Cell[BoxData[
     StyleBox["\<\"AaBbCc\"\>",
      StripOnInput->False,
      FontSize->Large,
      FontVariations->{"Underline"->True}]], "Text", "TR"],
    Text[
     Style["AaBbCc", Large, Underlined]]], ",", 
   InterpretationBox[Cell[BoxData[
     StyleBox["\<\"AaBbCc\"\>",
      StripOnInput->False,
      FrontFaceColor->RGBColor[0.5, 0, 0.5],
      BackFaceColor->RGBColor[0.5, 0, 0.5],
      GraphicsColor->RGBColor[0.5, 0, 0.5],
      FontSize->Large,
      FontColor->RGBColor[0.5, 0, 0.5]]], "Text", "TR"],
    Text[
     Style["AaBbCc", Large, 
      RGBColor[0.5, 0, 0.5]]]]}], "}"}]], "Output",
 ImageSize->{386, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->163564490]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->631960720],

Cell["Use graphics directives:", "ExampleText",
 CellID->79773026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Style", "[", 
   RowBox[{
    RowBox[{"Rectangle", "[", "]"}], ",", 
    RowBox[{"EdgeForm", "[", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", 
       RowBox[{"Thickness", "[", ".05", "]"}]}], "}"}], "]"}], ",", "Pink"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->116884859],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], EdgeForm[{RGBColor[0, 0, 1], Thickness[0.05]}], 
   RectangleBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->489050249]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->99382743],

Cell["Specify the indentation, spacing, and alignment of text:", "ExampleText",
 CellID->172000602],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"StringJoin", "@@", 
    RowBox[{"Table", "[", 
     RowBox[{"\"\<abcde \>\"", ",", 
      RowBox[{"{", "40", "}"}]}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1986106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"LineIndent", "\[Rule]", "1"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12381354],

Cell[BoxData[
 FrameBox[
  InterpretationBox[Cell[BoxData[
    StyleBox["\<\"abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde \"\>",
     StripOnInput->False,
     LineIndent->1]], "Text", "TR"],
   Text[
    Style[
    "abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde ", LineIndent -> 1]]],
  StripOnInput->False]], "Output",
 ImageSize->{452, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->91370470]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"LineSpacing", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1.5", ",", "0"}], "}"}]}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->492434835],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnN1KwzAYhtOl2yrqmYN6tqtREDwTRTwqQ9gORJm7vYFeWcxPu9aZinS4
Jd1TaJsv+d5n7bqmWV7obbGaP78Uq8WsmF4vi7f5YvY+vXpd6iqZCJF8CCFu
cqHLSpfsapZPveqyzLJMuMWEa70mrkpWmcru1npNXGL0LRO9SU1d6r6EMkEH
g3I/rCrKthEKFEEoTry/6AuzGdWxLVRCuQnFYCv+rd0UB3DhwoW7Z67pF7v3
crYzHW/ymqliDAMGjL0yTlXbKFyKCuWSt/uJ9PunbxLNmGmIHj36zvpMtT5j
h3VccsXPZ7gvNnn2wJoAdxQwYcKE2ZHp760mZb7lpDXHdYqySUybRFMzQosW
ra3xzypeqvruNMUz4qhi//8urmrcsf+q5srdyec93ofoJR5PC64pilgVuKZw
4cLtNxfXFAaMvjBwTdGjD02PawoTJsw4mLimaNHimhL/PcY17WOMa1qftdmE
6jL2rcU8RcLzw1DErnjw/tpicyzgwoW7P+6d2qXXiME1gQHjvxmPqm2kJ0WF
cskxORvo0e+iv1etz5YIZsphwoS5O9PfC1T/ZGOa3UeLtk3rn32xY8tGfOg5
72OL/eNyrkqIV6W6+0JwSLrsn7xnZTahOhHbLXmeu1L95k9bZfLKt4MmX7EG
qJI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->132576072]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"TextAlignment", "\[Rule]", "Right"}]}], "]"}], "]"}]}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->223631662],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnNFOwjAUhjs2YEa9k2Te8SRe6pWJJPoAhJjAhdEgr0eiT1Z72o1NLAaH
Yev4SLr1tOf/GIy1o3+y++lq/vwyXS1m0/Hdcvo2X8zex7evS9MUR0pFH0qp
m0yZujY1W+T1aYqpx2maKveScG1K5JriIlPb3dqUyCUG3zMym0TaEvcl5Akm
6OX7ftGQ9w1QoGiF4sz7i76SzaCMbaUQxptQ9bbi3/ql2oMLFy7cI3NlXKw/
ytnBdLjJq6aqIQwYMI7KONe77sJjVaBc8vY4kXx/902i3DP10aNHX1uf6p1z
bL+Mc676OYf7YsmzB1YFuKOACRMmzJpM/2g1yvMtJyk5blCMq8SkSpSWAVq0
aG2Lf1XxWpdXp1QviIOK/f+7OKthx/6zmml3JV92eN9GL/F/e3AmUYSqwJmE
Cxdut7k4kzBgdIWBM4kefdv0OJMwYcIMg4kziRYtziTx/jHOZBdjnMnyU8um
rS5jnZ6JbqPnhCJ0hX9+f5BNQK4AXLhwm3bh9h01QnAmYMBoxv2SO71YFSiX
HJJ7gB79IXr/eq6dWwJYjYYJE+bhTP8oMNHhraCjRfs3d+VJl1eJVJteVz61
2H9fzllp41l51M27D6ftXmRZ5mrlEyxtk+TlT7mMvgCGwQQW\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->146494897]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(14)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->144918184],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Antialiasing",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->38114515],

Cell["Use antialiasing by default:", "ExampleText",
 CellID->195867228],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Circle", "[", "]"}], "]"}], ",", 
   RowBox[{"Antialiasing", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4666290],

Cell[BoxData[
 StyleBox[
  GraphicsBox[CircleBox[{0, 0}]],
  StripOnInput->False,
  Antialiasing->True]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->151498524]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37963061],

Cell["Turn off the antialiasing:", "ExampleText",
 CellID->73392904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Circle", "[", "]"}], "]"}], ",", 
   RowBox[{"Antialiasing", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->495981589],

Cell[BoxData[
 StyleBox[
  GraphicsBox[CircleBox[{0, 0}]],
  StripOnInput->False,
  Antialiasing->False]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->412648383]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->17117600],

Cell["Specify background colors:", "ExampleText",
 CellID->428806057],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"Sin", "[", "x", "]"}], "/", "x"}], "]"}], ",", 
     RowBox[{"Background", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{
      "LightYellow", ",", "LightBlue", ",", "LightRed", ",", "LightGreen"}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->115899743],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    SqrtBox[
     FractionBox[
      RowBox[{"Sin", "[", "x", "]"}], "x"]],
    StripOnInput->False,
    Background->RGBColor[1, 1, 0.85]], ",", 
   StyleBox[
    SqrtBox[
     FractionBox[
      RowBox[{"Sin", "[", "x", "]"}], "x"]],
    StripOnInput->False,
    Background->RGBColor[0.87, 0.94, 1]], ",", 
   StyleBox[
    SqrtBox[
     FractionBox[
      RowBox[{"Sin", "[", "x", "]"}], "x"]],
    StripOnInput->False,
    Background->RGBColor[1, 0.85, 0.85]], ",", 
   StyleBox[
    SqrtBox[
     FractionBox[
      RowBox[{"Sin", "[", "x", "]"}], "x"]],
    StripOnInput->False,
    Background->RGBColor[0.88, 1, 0.88]]}], "}"}]], "Output",
 ImageSize->{316, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->347467905]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ControlsRendering",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->10486425],

Cell[TextData[{
 "Compare the default and generic appearances of ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->972670439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Slider", "[", "]"}], ",", 
     RowBox[{"ControlsRendering", "\[Rule]", "\"\<Generic\>\""}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1435729129],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[0.5], ",", 
   StyleBox[
    SliderBox[0.5],
    ControlsRendering->"Generic",
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{430, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->111587005]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->826669350],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RadioButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadioButton"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1771134871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RadioButton", "[", 
    RowBox[{"1", ",", "1"}], "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"RadioButton", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", 
     RowBox[{"ControlsRendering", "\[Rule]", "\"\<Generic\>\""}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->112136915],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RadioButtonBox[1, {1}], ",", 
   StyleBox[
    RadioButtonBox[1, {1}],
    ControlsRendering->"Generic",
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{68, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1211594372]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DefaultOptions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->496916371],

Cell[TextData[{
 "Locally set ",
 Cell[BoxData[
  ButtonBox["DefaultOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DefaultOptions"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->105572740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Circle", "[", "]"}], "]"}], ",", 
     RowBox[{"Slider", "[", ".5", "]"}]}], "}"}], ",", 
   RowBox[{"DefaultOptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Graphics", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ImageSize", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"90", ",", "90"}], "}"}]}], ",", 
         RowBox[{"Background", "\[Rule]", "LightBlue"}]}], "}"}]}], ",", 
      RowBox[{"Slider", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Appearance", "\[Rule]", "Small"}], ",", 
         RowBox[{"Background", "\[Rule]", "LightGreen"}]}], "}"}]}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12412063],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    GraphicsBox[CircleBox[{0, 0}]], ",", 
    SliderBox[0.5]}], "}"}],
  StripOnInput->False,
  SliderBoxOptions->{Appearance->Small,
  Background->RGBColor[0.88, 1, 0.88]},
  GraphicsBoxOptions->{Background->RGBColor[0.87, 0.94, 1],
  ImageSize->{90, 90}}]], "Output",
 ImageSize->{320, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78069277]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->256549],

Cell["\<\
Explicit option settings in an object override default options for that type \
of object:\
\>", "ExampleText",
 CellID->807970789],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Circle", "[", "]"}], ",", 
       RowBox[{"Background", "\[Rule]", "Pink"}]}], "]"}], ",", 
     RowBox[{"Slider", "[", 
      RowBox[{".5", ",", 
       RowBox[{"Appearance", "\[Rule]", "Large"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"DefaultOptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Graphics", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"ImageSize", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"90", ",", "90"}], "}"}]}], ",", 
         RowBox[{"Background", "\[Rule]", "LightBlue"}]}], "}"}]}], ",", 
      RowBox[{"Slider", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Appearance", "\[Rule]", "Small"}], ",", 
         RowBox[{"Background", "\[Rule]", "LightGreen"}]}], "}"}]}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->358337721],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    GraphicsBox[CircleBox[{0, 0}],
     Background->RGBColor[1, 0.5, 0.5]], ",", 
    SliderBox[0.5,
     Appearance->Large]}], "}"}],
  StripOnInput->False,
  SliderBoxOptions->{Appearance->Small,
  Background->RGBColor[0.88, 1, 0.88]},
  GraphicsBoxOptions->{Background->RGBColor[0.87, 0.94, 1],
  ImageSize->{90, 90}}]], "Output",
 ImageSize->{320, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73033120]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Deployed",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->12771641],

Cell["\<\
Disable general editing and selection in a cell while preserving interactive \
controls:\
\>", "ExampleText",
 CellID->1972924211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"Disk", "[", "]"}], "]"}], ",", 
     RowBox[{"Slider2D", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Deployed", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23842454],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    GraphicsBox[DiskBox[{0, 0}]], ",", 
    Slider2DBox[{0.425, 0.56}]}], "}"}],
  Deployed->True,
  StripOnInput->False]], "Output",
 ImageSize->{290, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->627201086]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DigitBlock",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->959274925],

Cell[TextData[{
 "Display integer digits in blocks of 3, separated by ",
 Cell[BoxData["\"\<,\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->263067636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"30", "!"}], ",", 
   RowBox[{"DigitBlock", "\[Rule]", "3"}], ",", 
   RowBox[{"NumberSeparator", "\[Rule]", "\"\<,\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172619616],

Cell[BoxData[
 StyleBox["265252859812191058636308480000000",
  StripOnInput->False,
  DigitBlock->3,
  NumberSeparator->","]], "Output",
 ImageSize->{305, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->184413824]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Editable",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->312993344],

Cell["By default, the output cell is editable: ", "ExampleText",
 CellID->196701548],

Cell[BoxData["\"\<abcd xyz\>\""], "Input",
 CellLabel->"In[1]:=",
 CellID->313377804],

Cell[BoxData["\"\<abcd xyz\>\""], "Input",
 CellLabel->"In[2]:=",
 CellID->152698952],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96104557],

Cell["Make the output non-editable:", "ExampleText",
 CellID->64491326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<abcd xyz\>\"", ",", 
   RowBox[{"Editable", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->684264301],

Cell[BoxData[
 StyleBox["\<\"abcd xyz\"\>",
  Editable->False,
  StripOnInput->False]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79555262]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->86180943],

Cell[TextData[{
 "Compare enabled and disabled ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->45274876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Slider", "[", "]"}], ",", 
     RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->188618259],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[0.5], ",", 
   StyleBox[
    SliderBox[0.5],
    Enabled->False,
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{430, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183587834]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RadioButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadioButton"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->309327794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RadioButton", "[", 
    RowBox[{"1", ",", "1"}], "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"RadioButton", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", 
     RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->624206400],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RadioButtonBox[1, {1}], ",", 
   StyleBox[
    RadioButtonBox[1, {1}],
    Enabled->False,
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{68, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->258103884]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FontColor",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->7240849],

Cell["Use red font color:", "ExampleText",
 CellID->516957610],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", "2", "]"}]}], ",", 
   RowBox[{"FontColor", "\[Rule]", "Red"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64068271],

Cell[BoxData[
 StyleBox[
  StyleBox[
   FractionBox["1", 
    SqrtBox["2"]],
   StripOnInput->False,
   FontColor->RGBColor[1, 0, 0]],
  StripOnInput->False,
  FontColor->RGBColor[1, 0, 0]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->679280969]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->426280928],

Cell["Specify the color without using an option:", "ExampleText",
 CellID->352767449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sqrt", "[", "2", "]"}]}], ",", "Red"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->133664627],

Cell[BoxData[
 StyleBox[
  StyleBox[
   FractionBox["1", 
    SqrtBox["2"]],
   StripOnInput->False,
   FrontFaceColor->RGBColor[1, 0, 0],
   BackFaceColor->RGBColor[1, 0, 0],
   GraphicsColor->RGBColor[1, 0, 0],
   FontColor->RGBColor[1, 0, 0]],
  StripOnInput->False,
  FrontFaceColor->RGBColor[1, 0, 0],
  BackFaceColor->RGBColor[1, 0, 0],
  GraphicsColor->RGBColor[1, 0, 0],
  FontColor->RGBColor[1, 0, 0]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227903431]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FontFamily",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->9394985],

Cell[TextData[{
 "Use ",
 Cell[BoxData["\"\<Courier\>\""], "InlineFormula"],
 " font family:"
}], "ExampleText",
 CellID->71723857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<AaBbCcDd\>\"", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Courier\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->427933374],

Cell[BoxData[
 StyleBox["\<\"AaBbCcDd\"\>",
  StripOnInput->False,
  FontFamily->"Courier"]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46850723]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData["\"\<Times\>\""], "InlineFormula"],
 " font family:"
}], "ExampleText",
 CellID->37138760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<AaBbCcDd\>\"", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Times\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->343677596],

Cell[BoxData[
 StyleBox["\<\"AaBbCcDd\"\>",
  StripOnInput->False,
  FontFamily->"Times"]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->281457506]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData["\"\<Helvetica\>\""], "InlineFormula"],
 " font family:"
}], "ExampleText",
 CellID->336261304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<AaBbCcDd\>\"", ",", 
   RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6607165],

Cell[BoxData[
 StyleBox["\<\"AaBbCcDd\"\>",
  StripOnInput->False,
  FontFamily->"Helvetica"]], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->104090770]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FontSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->257008440],

Cell["Specify the font size in printer's point:", "ExampleText",
 CellID->193738469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Text", "[", 
    RowBox[{"Style", "[", 
     RowBox[{"\"\<ABC\>\"", ",", 
      RowBox[{"FontSize", "\[Rule]", "p"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "24", ",", "36"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->162708554],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[Cell[BoxData[
     StyleBox["\<\"ABC\"\>",
      StripOnInput->False,
      FontSize->12]], "Text", "TR"],
    Text[
     Style["ABC", FontSize -> 12]]], ",", 
   InterpretationBox[Cell[BoxData[
     StyleBox["\<\"ABC\"\>",
      StripOnInput->False,
      FontSize->24]], "Text", "TR"],
    Text[
     Style["ABC", FontSize -> 24]]], ",", 
   InterpretationBox[Cell[BoxData[
     StyleBox["\<\"ABC\"\>",
      StripOnInput->False,
      FontSize->36]], "Text", "TR"],
    Text[
     Style["ABC", FontSize -> 36]]]}], "}"}]], "Output",
 ImageSize->{189, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->376568569]
}, Open  ]],

Cell["\<\
Specify the absolute font size using predefined symbolic values:\
\>", "ExampleText",
 CellID->122796288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Text", "[", 
    RowBox[{"Style", "[", 
     RowBox[{"\"\<ABC\>\"", ",", 
      RowBox[{"FontSize", "\[Rule]", "p"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->285828925],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVs1OwzAMTpu0W8vPJsEBAUKDtwDucOIZWDUhtgMCjT0G4r6nLXFqF89x
RzU4MKl17dqfP8eJu4dqNX96qVaLWTW5X1Zv88XsfXL3uvQmmxhj1v66ODH+
ufZP4VrXtZfO31OvfqDMgtXC3YJX+JlPoaf/xGsk9DOhXwr9pjcqrMU5yiuU
t93RWWsNNhPeOXhwaDCtwhBgtS165+a7G9kWP5BNUsTEOLDnShy8HyA+jyv8
VXoVqA/VylJhtciO1YSWHOWgcy0CzdYUWxxHkEwiRBfFyx5ahgeywBXKGGPL
mGcd+RMGH4ytZ7PYjY3uY0S1esUM97B/nbaFj/bFvtCpWt4PXp3sM9hhPECV
idpzWie+cwDpQDCzvHJxlpyJd34q4o9/qGSIkvpaKv2O+yatpwrr7X0aRR5Q
SaZ4Hilry3sgK5CzS59FcqL1OUt8b7W7Rj+Vgn+p8E1RjvvzdTwXn0+7MZM5
5Nnhs4NLWul+zK8V1Jib2DEdGSgzrSHN4d8xgvcZovEzWdfxl5AzKNgE6Jf5
Ua2yqDfPpPtDzN16NpVeCiKxlBND7rImA3lPGdtm6pUduJSPzknzD+oZe0RR
NEf5JKboxhu0PYZhzeb8dq33XDAHrxKjc+X8hG+aWfe4m+QLpLvyYQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{153, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23546868]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->40568201],

Cell["Specify the font size without using an option:", "ExampleText",
 CellID->173172889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Text", "[", 
    RowBox[{"Style", "[", 
     RowBox[{"\"\<ABC\>\"", ",", "s"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "24", ",", "36"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->24262061],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[Cell[BoxData[
     StyleBox["\<\"ABC\"\>",
      StripOnInput->False,
      FontSize->12]], "Text", "TR"],
    Text[
     Style["ABC", 12]]], ",", 
   InterpretationBox[Cell[BoxData[
     StyleBox["\<\"ABC\"\>",
      StripOnInput->False,
      FontSize->24]], "Text", "TR"],
    Text[
     Style["ABC", 24]]], ",", 
   InterpretationBox[Cell[BoxData[
     StyleBox["\<\"ABC\"\>",
      StripOnInput->False,
      FontSize->36]], "Text", "TR"],
    Text[
     Style["ABC", 36]]]}], "}"}]], "Output",
 ImageSize->{189, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->226337190]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FontSlant",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->643679630],

Cell["Plain fonts:", "ExampleText",
 CellID->71764800],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<AaBbCcDd\>\"", ",", 
   RowBox[{"FontSlant", "\[Rule]", "Plain"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->487023725],

Cell[BoxData[
 StyleBox["\<\"AaBbCcDd\"\>",
  StripOnInput->False,
  FontSlant->Plain]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->517749681]
}, Open  ]],

Cell["Italic fonts:", "ExampleText",
 CellID->302010642],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<AaBbCcDd\>\"", ",", 
   RowBox[{"FontSlant", "\[Rule]", "Italic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18250517],

Cell[BoxData[
 StyleBox["\<\"AaBbCcDd\"\>",
  StripOnInput->False,
  FontSlant->Italic]], "Output",
 ImageSize->{60, 16},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->660809052]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->501438774],

Cell["Specify the font slant without using the option:", "ExampleText",
 CellID->111737163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<AaBbCcDd\>\"", ",", "Italic"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219837801],

Cell[BoxData[
 StyleBox["\<\"AaBbCcDd\"\>",
  StripOnInput->False,
  FontSlant->Italic]], "Output",
 ImageSize->{60, 16},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1084663]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FontTracking",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->7658463],

Cell[TextData[{
 "Different settings for ",
 Cell[BoxData[
  ButtonBox["FontTracking",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontTracking"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->91142790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Column", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Style", "[", 
      RowBox[{"\"\<AaBbCcDd\>\"", ",", 
       RowBox[{"FontTracking", "\[Rule]", "t"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Narrow\>\"", ",", "\"\<Condensed\>\"", ",", 
         "\"\<SemiCondensed\>\"", ",", "\"\<Plain\>\"", ",", 
         "\"\<Extended\>\"", ",", "\"\<Wide\>\""}], "}"}]}], "}"}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110547051],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"AaBbCcDd\"\>",
       StripOnInput->False,
       FontTracking->"Narrow"]},
     {
      StyleBox["\<\"AaBbCcDd\"\>",
       StripOnInput->False,
       FontTracking->"Condensed"]},
     {
      StyleBox["\<\"AaBbCcDd\"\>",
       StripOnInput->False,
       FontTracking->"SemiCondensed"]},
     {
      StyleBox["\<\"AaBbCcDd\"\>",
       StripOnInput->False,
       FontTracking->"Plain"]},
     {
      StyleBox["\<\"AaBbCcDd\"\>",
       StripOnInput->False,
       FontTracking->"Extended"]},
     {
      StyleBox["\<\"AaBbCcDd\"\>",
       StripOnInput->False,
       FontTracking->"Wide"]}
    },
    ColumnsEqual->False,
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
    RowsEqual->False],
   "Column"],
  StripOnInput->False]], "Output",
 ImageSize->{77, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20005130]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FontVariations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->35104917],

Cell["Underlined text:", "ExampleText",
 CellID->4608814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<abcd xyz\>\"", ",", 
   RowBox[{"FontVariations", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Underline\>\"", "\[Rule]", "True"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13109641],

Cell[BoxData[
 StyleBox["\<\"abcd xyz\"\>",
  StripOnInput->False,
  FontVariations->{"Underline"->True}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18582837]
}, Open  ]],

Cell["Strike-through text:", "ExampleText",
 CellID->321858622],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<abcd xyz\>\"", ",", 
   RowBox[{"FontVariations", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<StrikeThrough\>\"", "\[Rule]", "True"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->134397311],

Cell[BoxData[
 StyleBox["\<\"abcd xyz\"\>",
  StripOnInput->False,
  FontVariations->{"StrikeThrough"->True}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->479269940]
}, Open  ]],

Cell["Combine both:", "ExampleText",
 CellID->785682462],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<abcd xyz\>\"", ",", 
   RowBox[{"FontVariations", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\"\<Underline\>\"", "\[Rule]", "True"}], ",", 
      RowBox[{"\"\<StrikeThrough\>\"", "\[Rule]", "True"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->353889339],

Cell[BoxData[
 StyleBox["\<\"abcd xyz\"\>",
  StripOnInput->False,
  FontVariations->{"StrikeThrough"->True,
  "Underline"->True}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->561533002]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FontWeight",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->103919133],

Cell["Plain fonts:", "ExampleText",
 CellID->47509944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<AaBbCcDd\>\"", ",", "Large", ",", 
   RowBox[{"FontWeight", "\[Rule]", "Plain"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->946307472],

Cell[BoxData[
 StyleBox["\<\"AaBbCcDd\"\>",
  StripOnInput->False,
  FontSize->Large,
  FontWeight->Plain]], "Output",
 ImageSize->{116, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->249329908]
}, Open  ]],

Cell["Bold fonts:", "ExampleText",
 CellID->44183612],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<AaBbCcDd\>\"", ",", "Large", ",", 
   RowBox[{"FontWeight", "\[Rule]", "Bold"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->120864318],

Cell[BoxData[
 StyleBox["\<\"AaBbCcDd\"\>",
  StripOnInput->False,
  FontSize->Large,
  FontWeight->Bold]], "Output",
 ImageSize->{117, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->129429599]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134605282],

Cell["Specify the font weight without using the option:", "ExampleText",
 CellID->490889040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<AaBbCcDd\>\"", ",", "Large", ",", "Bold"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->417895822],

Cell[BoxData[
 StyleBox["\<\"AaBbCcDd\"\>",
  StripOnInput->False,
  FontSize->Large,
  FontWeight->Bold]], "Output",
 ImageSize->{117, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87387019]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSizeMultipliers",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->38032121],

Cell["The original graphic size:", "ExampleText",
 CellID->87374991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Circle", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68463969],

Cell[BoxData[
 StyleBox[
  GraphicsBox[CircleBox[{0, 0}, {3., 1.}]],
  StripOnInput->False,
  GraphicsBoxOptions->{ImageSize->Automatic}]], "Output",
 ImageSize->{364, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->332343884]
}, Open  ]],

Cell["\<\
Specify that the graphic inside a list is 0.4 times its normal size:\
\>", "ExampleText",
 CellID->670213564],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}]}], "]"}], "]"}], "}"}], ",", 
   RowBox[{"ImageSizeMultipliers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.4", ",", "0.2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28741958],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   GraphicsBox[CircleBox[{0, 0}, {3., 1.}]], "}"}],
  StripOnInput->False,
  ImageSizeMultipliers->{0.4, 0.2},
  GraphicsBoxOptions->{ImageSize->Automatic}]], "Output",
 ImageSize->{162, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->125857169]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->463424180],

Cell["\<\
Specify that the graphic inside a function is 0.2 times its normal size:\
\>", "ExampleText",
 CellID->431845390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Circle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"ImageSizeMultipliers", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0.4", ",", "0.2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->358157864],

Cell[BoxData[
 StyleBox[
  RowBox[{"f", "[", 
   GraphicsBox[CircleBox[{0, 0}, {3., 1.}]], "]"}],
  StripOnInput->False,
  ImageSizeMultipliers->{0.4, 0.2},
  GraphicsBoxOptions->{ImageSize->Automatic}]], "Output",
 ImageSize->{97, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55064882]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "LineIndent",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->959469322],

Cell["Specify the size of indentation:", "ExampleText",
 CellID->358696996],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"StringJoin", "@@", 
    RowBox[{"Table", "[", 
     RowBox[{"\"\<abcde \>\"", ",", 
      RowBox[{"{", "40", "}"}]}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8271777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"LineIndent", "\[Rule]", "1"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->318287936],

Cell[BoxData[
 FrameBox[
  InterpretationBox[Cell[BoxData[
    StyleBox["\<\"abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde \"\>",
     StripOnInput->False,
     LineIndent->1]], "Text", "TR"],
   Text[
    Style[
    "abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde abcde \
abcde abcde ", LineIndent -> 1]]],
  StripOnInput->False]], "Output",
 ImageSize->{452, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->40616788]
}, Open  ]],

Cell["No indentation:", "ExampleText",
 CellID->120976664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"LineIndent", "\[Rule]", "0"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->39576492],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnN1OgzAYhsv4GUY953BX4oFRFw+8CLKYbAdGM3dXS/QSa38osNkZg7q1
+JAA/drvfQYrKx1vwkO9WT4+1ZvVop7N1/XLcrV4nd09r1VVmgiRvAkhriqh
ylKVzKqXd7WqclqWpbCLDrdqTWxV6jKl2W3VmtjE6FtStcl0XWa/hCZBBZNm
n7uKpq1AgSIIxZn3ip7oTdHFpuCEaRvavF78VTtcuHDhnoKrx8Xho5wZTKdt
Xj9VTGHAgHFUxrk8NAtPhUPZ5P1xItv99DZRz5ly9OjRD9aX8uA9Nu/ihis+
38N9sc4zB9YH2KOACRMmzIFM/2jlnpQYTtZxRDu7aIlZn6hrCrRo0Zoa/1NF
M/fvxRfEUcX+/130atyxv1fdr/9yxPsQvcTfbcGZRBGrAmcSLly44+biTMKA
MRYGziR69KHpcSZhwoQZBxNnEi1anEni78c4k2OMcSa7s9abUF3GIS04kyj+
QnHrvdpicwXgwoV7PO61xIWDAeNnjLnE/UKPfld/I3GfYML830z/KICrg3ZM
Wv/TF57Dnzb2z8vplRB7JXZ34957VnoTqhOx31JVlS11b7A0VTqvectl8gHQ
+P+Z\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{430, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->97876273]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "LineSpacing",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->728189816],

Cell["Double spacing:", "ExampleText",
 CellID->49411886],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"StringJoin", "@@", 
    RowBox[{"Table", "[", 
     RowBox[{"\"\<abcde \>\"", ",", 
      RowBox[{"{", "40", "}"}]}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320669149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"LineSpacing", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2", ",", "0"}], "}"}]}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->525120996],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnN1OgzAYhstgG0Y9cwme7Wr0yDPjTzwii8l2YDRzt7dEr6z2hw6cxRiI
s8WHBOjXfu8zGFAKb8JVuVk+PpWb1aKcX67Ll+Vq8Tq/eF6rqjQRInkTQtwV
QpWlKplZT+9qVuU0z3NhJx1u1ZzYqtRlSrPaqjmxidG3zNQi03WZ/ROqBBWM
qvXYVVRtExQoglAcec/oM72Y1LEpOGG6C8VoL/6uXRdHcOHChXtgru4Xu/dy
pjOd7vKaqWIKAwaMgzKOZdsoPBUOZZP3+4ns86/vEvWYaYwePfrO+ly23mPH
dVxxxdd7uC/WeWbDmgC7FTBhwoTZkenvrWZVvuFkNcd2immTmDWJumaCFi1a
U+N/q3gu66tTF0+Io4r9z10c1bhj/1EtpL2STwe8DtFLpCXsFrxeFLEq8Hrh
woU7bC5eLwwYQ2Hg9aJHH5oerxcmTJhxMPF60aLF6yX+eYzXO8QYr7fea70I
1WWkJYQWfe8Lz8VDEbvi1nu2xeazwIUL93Dca9mn14jB64EB47cZ97JtpJcK
h7LJMfkx6NH30d/I1ntLBO/3YcKE2Z/p7wXck2xMngRatG1a/9sXM7ZsxH/9
pv6/xf5xOUclxKPirr4QfJ0u6wfvXulFqE7EfktRFLZUf2XVVOm86kusyQcd
GGiH\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22440470]
}, Open  ]],

Cell["Make the height of each line 10 printer's points: ", "ExampleText",
 CellID->643382238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"LineSpacing", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->125698937],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnM9Og0AQh5cubTHqzSZ46yP4FHryZjTGE2lM2oPR1L5eE32ydf+wBeti
DI0tSz8SYGeZ31coMCwzCbfFav78UqwWs2J6syze5ovZ+/T6dam7ZCJE8iGE
uMqFbivdsrOZPvWs2zLLMuEmY671nLgu6T2VXa31nDjH6LdM9CI1fan7E0oH
bQzK9dB3lNtGKFB0QnESvKIvzGJU2bbhhXJjisGW/dt20xzAhQsX7p65Ji62
j3I2mI43fnVXMYYBA8ZeGaeqaRQuhUc55+04kX7/9Y2jGTMN0aNH31qfqcZn
7LCyS674+QwP2cbP7lgd4PYCJkyYMFsyw9FqUvpbTlpxXFCUdWJaJ5qeEVq0
aG1POKt4qaq70zTPsKOyw+9dnNW47fBZzZW7k897vKbGh+IYFNT44MKF228u
NT4YMPrCoMaHHn3X9NT4YMKEGQeTGh9atNT4sP9uU+Pro02NrzpqswjX+EzM
6171BkXsiofg1RZbfh0uXLj7496pXaJGDDl+GDD+m/GomkZ6UniUc44pD48e
/S76e9X4bIkgrwsTJszdmeEo4N9kY8pFo0XbpA1nX+zYsmYfOkN7bHZ4XM5Z
6eJZ8XdfF/L5bdZPwaMyi65+UXB7S57nrlV9VdF2Gb/yy4vJFwoqRCE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->330881213]
}, Open  ]],

Cell["\<\
Single spacing with 5 printer's point of extra space added to each line:\
\>", "ExampleText",
 CellID->779543827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"LineSpacing", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"1", ",", "5"}], "}"}]}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->105787743],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnF1PwjAUhjs2YEa9k2Te8WOMXnlnNMarhZjABdEgf49Ef1ntx8omdsaM
CO18SLb1tOd9+Bg7K30Tbsv1/HlZrhezcnqzKl/ni9nb9PplpbrSRIjkXQhx
VQjVlqplNv34UJtqp3meC/vQ4UZtie1KXaY0h43aEpsY/chE7TLdl9kPoUpQ
waA6Dl1HNTZCgSIIxYn3G32hd6M6Ng0nTLehGOzEP43r5gAuXLhwD8zVdbF7
lTPFdLzNa6aKMQwYMA7KOJVts/BUOJRN3q0T2ddn3ybqOdMQPXr0nfW5bL3H
Duu44orv93BfrPPMC2sC7KuACRMmzI5Mf7WaVPmGk9UcWxTTJjFrEnXPCC1a
tKbHv6p4KeurUzfPiKOK/b+7OKtxx/6zWkh7JZ/3+BiilxjyCD4nilgV+Jxw
4cLtNxefEwaMvjDwOdGjD02PzwkTJsw4mPicaNHicxL/Psbn7GOMz1m/a70L
1WU8/oiu++E5WChiVzx4v22xeQxw4cI9HPdO7lM1YvA5YMD4a8ajbJvppcKh
bHJMXgR69Pvo72XrvSWCtW2YMGHuz/RXAfdLNqb1eLRo27T+1Rczt2zEx16l
/m+xf17OWQnxrLirLwRPo8vxyfuu9C5UJ2J3pCgK26r/XdN06bzqHziTT4Jo
VlQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{448, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->13098578]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Magnification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->608300505],

Cell["Specify the level of magnification:", "ExampleText",
 CellID->468708893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], ",", 
     RowBox[{"Magnification", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "1", ",", "2", ",", "3"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->686464458],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    SqrtBox["2"],
    StripOnInput->False,
    Magnification->Rational[1, 2]], ",", 
   StyleBox[
    SqrtBox["2"],
    StripOnInput->False,
    Magnification->1], ",", 
   StyleBox[
    SqrtBox["2"],
    StripOnInput->False,
    Magnification->2], ",", 
   StyleBox[
    SqrtBox["2"],
    StripOnInput->False,
    Magnification->3]}], "}"}]], "Output",
 ImageSize->{195, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->501889901]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Circle", "[", "]"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "30"}]}], "]"}], ",", 
     RowBox[{"Magnification", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "1", ",", "2", ",", "3"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->532356367],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->30],
    StripOnInput->False,
    Magnification->Rational[1, 2]], ",", 
   StyleBox[
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->30],
    StripOnInput->False,
    Magnification->1], ",", 
   StyleBox[
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->30],
    StripOnInput->False,
    Magnification->2], ",", 
   StyleBox[
    GraphicsBox[CircleBox[{0, 0}],
     ImageSize->30],
    StripOnInput->False,
    Magnification->3]}], "}"}]], "Output",
 ImageSize->{247, 92},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->189088408]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->104349828],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Magnification",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Magnification"]], "InlineFormula"],
 " affects everything including margins:"
}], "ExampleText",
 CellID->348541635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"Grid", "[", 
   RowBox[{
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{"Range", "[", "9", "]"}], ",", "3"}], "]"}], ",", 
    RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->639918153],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3"},
    {"4", "5", "6"},
    {"7", "8", "9"}
   },
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{53, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->247851121]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"Magnification", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "2"}], ",", "1", ",", "2", ",", "3"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->457015859],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    TagBox[GridBox[{
       {"1", "2", "3"},
       {"4", "5", "6"},
       {"7", "8", "9"}
      },
      GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
     "Grid"],
    StripOnInput->False,
    Magnification->Rational[1, 2]], ",", 
   StyleBox[
    TagBox[GridBox[{
       {"1", "2", "3"},
       {"4", "5", "6"},
       {"7", "8", "9"}
      },
      GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
     "Grid"],
    StripOnInput->False,
    Magnification->1], ",", 
   StyleBox[
    TagBox[GridBox[{
       {"1", "2", "3"},
       {"4", "5", "6"},
       {"7", "8", "9"}
      },
      GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
     "Grid"],
    StripOnInput->False,
    Magnification->2], ",", 
   StyleBox[
    TagBox[GridBox[{
       {"1", "2", "3"},
       {"4", "5", "6"},
       {"7", "8", "9"}
      },
      GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
     "Grid"],
    StripOnInput->False,
    Magnification->3]}], "}"}]], "Output",
 ImageSize->{329, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->546738664]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "NumberSeparator",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->88470207],

Cell[TextData[{
 "Display integer digits in blocks of 3, separated by ",
 Cell[BoxData["\"\<,\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->137646331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"30", "!"}], ",", 
   RowBox[{"DigitBlock", "\[Rule]", "3"}], ",", 
   RowBox[{"NumberSeparator", "\[Rule]", "\"\<.\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119451510],

Cell[BoxData[
 StyleBox["265252859812191058636308480000000",
  StripOnInput->False,
  DigitBlock->3,
  NumberSeparator->"."]], "Output",
 ImageSize->{305, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149546577]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ScriptBaselineShifts",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->79091171],

Cell["Default placement of subscripts and superscripts:", "ExampleText",
 CellID->22309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["x", "a"], ",", 
   SubsuperscriptBox["x", "b", "b"], ",", 
   SuperscriptBox["x", "c"]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->396171734],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["x", "a"], ",", 
   SubsuperscriptBox["x", "b", "b"], ",", 
   SuperscriptBox["x", "c"]}], "}"}]], "Output",
 ImageSize->{78, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135387436]
}, Open  ]],

Cell["Make subscripts be shifted down by 2 x-heights:", "ExampleText",
 CellID->26223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "a"], ",", 
     SubsuperscriptBox["x", "b", "b"], ",", 
     SuperscriptBox["x", "c"]}], "}"}], ",", 
   RowBox[{"ScriptBaselineShifts", "->", 
    RowBox[{"{", 
     RowBox[{"2", ",", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15014],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["x", "a"], ",", 
    SubsuperscriptBox["x", "b", "b"], ",", 
    SuperscriptBox["x", "c"]}], "}"}],
  StripOnInput->False,
  ScriptBaselineShifts->{2, Automatic}]], "Output",
 ImageSize->{78, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->661201631]
}, Open  ]],

Cell["\<\
Subscripts shifted down by 0 x-heights; superscript shifted up by 2 \
x-heights:\
\>", "ExampleText",
 CellID->61],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["x", "a"], ",", 
     SubsuperscriptBox["x", "b", "b"], ",", 
     SuperscriptBox["x", "c"]}], "}"}], ",", 
   RowBox[{"ScriptBaselineShifts", "->", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14906],

Cell[BoxData[
 StyleBox[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["x", "a"], ",", 
    SubsuperscriptBox["x", "b", "b"], ",", 
    SuperscriptBox["x", "c"]}], "}"}],
  StripOnInput->False,
  ScriptBaselineShifts->{0, 2}]], "Output",
 ImageSize->{78, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->21000513]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ScriptMinSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->159132065],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ScriptMinSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScriptMinSize"]], "InlineFormula"],
 " to keep exponents from shrinking below a certain font size:"
}], "ExampleText",
 CellID->279618131],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"m", "^", "n"}]}], ",", 
     RowBox[{"ScriptMinSize", "\[Rule]", "min"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"min", ",", 
     RowBox[{"{", 
      RowBox[{"6", ",", "9", ",", "12"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128184475],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    SuperscriptBox["x", 
     SuperscriptBox["m", "n"]],
    StripOnInput->False,
    ScriptMinSize->6], ",", 
   StyleBox[
    SuperscriptBox["x", 
     SuperscriptBox["m", "n"]],
    StripOnInput->False,
    ScriptMinSize->9], ",", 
   StyleBox[
    SuperscriptBox["x", 
     SuperscriptBox["m", "n"]],
    StripOnInput->False,
    ScriptMinSize->12]}], "}"}]], "Output",
 ImageSize->{100, 26},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->431979238]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ScriptSizeMultipliers",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->69766984],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ScriptSizeMultipliers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScriptSizeMultipliers"]], "InlineFormula"],
 " to set the factor by which font size is reduced for superscripts:"
}], "ExampleText",
 CellID->218579224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"m", "^", "n"}]}], ",", "Large", ",", 
     RowBox[{"ScriptSizeMultipliers", "\[Rule]", "ssm"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ssm", ",", 
     RowBox[{"{", 
      RowBox[{".8", ",", ".9", ",", "1.0"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->19975730],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    SuperscriptBox["x", 
     SuperscriptBox["m", "n"]],
    StripOnInput->False,
    ScriptSizeMultipliers->0.8,
    FontSize->Large], ",", 
   StyleBox[
    SuperscriptBox["x", 
     SuperscriptBox["m", "n"]],
    StripOnInput->False,
    ScriptSizeMultipliers->0.9,
    FontSize->Large], ",", 
   StyleBox[
    SuperscriptBox["x", 
     SuperscriptBox["m", "n"]],
    StripOnInput->False,
    ScriptSizeMultipliers->1.,
    FontSize->Large]}], "}"}]], "Output",
 ImageSize->{158, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63598606]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->679758697],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ScriptSizeMultipliers", "->", 
   StyleBox["list", "TI"]}]], "InlineFormula"],
 " uses different factors for different levels:"
}], "ExampleText",
 CellID->148048739],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"m", "^", 
       RowBox[{"n", "^", "p"}]}]}], ",", "Large", ",", 
     RowBox[{"ScriptSizeMultipliers", "\[Rule]", ".8"}]}], "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{
     RowBox[{"x", "^", 
      RowBox[{"m", "^", 
       RowBox[{"n", "^", "p"}]}]}], ",", "Large", ",", 
     RowBox[{"ScriptSizeMultipliers", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{".8", ",", ".9", ",", ".95"}], "}"}]}]}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21766505],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox[
    SuperscriptBox["x", 
     SuperscriptBox["m", 
      SuperscriptBox["n", "p"]]],
    StripOnInput->False,
    ScriptSizeMultipliers->0.8,
    FontSize->Large], ",", 
   StyleBox[
    SuperscriptBox["x", 
     SuperscriptBox["m", 
      SuperscriptBox["n", "p"]]],
    StripOnInput->False,
    ScriptSizeMultipliers->{0.8, 0.9, 0.95},
    FontSize->Large]}], "}"}]], "Output",
 ImageSize->{119, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3629833]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ShowStringCharacters",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->14172067],

Cell["\<\
By default, quotation marks are shown around strings in input cells, but not \
in output cells:\
\>", "ExampleText",
 CellID->422807826],

Cell[CellGroupData[{

Cell[BoxData["\"\<AaBbCcDd\>\""], "Input",
 CellLabel->"In[1]:=",
 CellID->354065117],

Cell[BoxData["\<\"AaBbCcDd\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183914581]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59396938],

Cell["Show quotation marks around strings in output cells:", "ExampleText",
 CellID->129539285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{"\"\<AaBbCcDd\>\"", ",", 
   RowBox[{"ShowStringCharacters", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->554898832],

Cell[BoxData[
 StyleBox["\"\<AaBbCcDd\>\"",
  StripOnInput->False,
  ShowStringCharacters->True]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->195079449]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "SingleLetterItalics",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->185020904],

Cell["\<\
Make variables with one-letter names appear in an italicized form: \
\>", "ExampleText",
 CellID->574549076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"SingleLetterItalics", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87718655],

Cell[BoxData[
 StyleBox[
  RowBox[{"Sin", "[", 
   RowBox[{"x", " ", "y"}], "]"}],
  StripOnInput->False,
  SingleLetterItalics->True]], "Output",
 ImageSize->{57, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->253259716]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->140295384],

Cell[TextData[{
 "Override single-letter italicization for a particular symbol in a ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " output:"
}], "ExampleText",
 CellID->205213398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{"T", ",", 
     RowBox[{"SingleLetterItalics", "\[Rule]", "False"}]}], "]"}], "+", 
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}]}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->174685336],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"sin", "(", 
    RowBox[{"x", " ", "y"}], ")"}], "+", 
   StyleBox["T",
    StripOnInput->False,
    SingleLetterItalics->False]}], TraditionalForm]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->164614641]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TextAlignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->12800794],

Cell["Align on the left:", "ExampleText",
 CellID->827890818],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"StringJoin", "@@", 
    RowBox[{"Table", "[", 
     RowBox[{"\"\<abcd \>\"", ",", 
      RowBox[{"{", "60", "}"}]}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367642920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"TextAlignment", "\[Rule]", "Left"}]}], "]"}], "]"}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->341845274],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnd1OwjAYQLsfYBd6h8m84wmI8QEEb/TKh1iICVwYDfL+tV3bMUYxMRvS
jbNk0Pb7ztGYWgr9Et6K3fr9o9htVsXsdVt8rTer79nL51YNJZEQ8YMQ4ikX
qi1Vq7zd9ahu1U+yLBPmcilzdUdmOKmICpyrOzLAoKN36iHVY6n5Q9kE1Ynt
88gGySKrD1lL7zyf6ofxvl82LOXyNBI3+vW4bsZ48ODBg6fkFrLNalsu5KMq
rz4KDQ0N3TH9LE+9C0qEkxhFc+Xz+0aQkJCQNdK/xkwPc51RHO+xfP34+Kdh
wIABQ1CG0/urypLuKbO4JjW+vtqmUFBQg6CW0rcu3Mv9KqKbN43+hDjxFvGF
ZNYRD2PW5dKsirf2OaP/a9+/k5T2CquK4nxR6jPIGlaWfydIfQYePHjwdOtZ
SOozoKGh+0FTnwEJCXlOkvoMDBgwXKOB+gwoKKgmtZSclBMP46ScWUf8/2cd
9RnUZ/w9ql9CQzxlJ4usvmRNvP9ZoZ2k4sGDBw+eMD1j2eZVJLyTcGhoaOjw
aP1JgP+dcCKcxCiaa3Y4NQCQkJCQ3ZD+FTE+zHVG0a+KAQwYMGAYtuH0njbs
ug0oKKhrpvynZ5eusSBOvE3c/2n+pX8r4sS7n9V6NKTKriH2w6kY6zqa57lp
HX6zVTns8u23YEU/ZUs/IQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{560, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->281802546]
}, Open  ]],

Cell["Centered:", "ExampleText",
 CellID->90237254],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"TextAlignment", "\[Rule]", "Center"}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->449003041],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnctOwkAUQKcv6EL3XbLEqMT4AS515Uc0xAQWRoP8f53pzJS2DCampUzL
aVLozL3nYMxwKe1NeM/3m4/PfL9d54u3Xf692a5/Fq9fOzkVBUKET0KIl0zI
40IelbvdnuUux1GapkJvNmUl90BPRxVRgSu5BxqYdPROPsRqLtb/KJMgB6F5
TkyQLLLGkPXgXOdL9TA7jMsDQ9k8hYStcT2uDkM8ePDgwVNy90WXalsW8qTK
q89CQ0ND90w/Fqe+BUXCSrSiXfncvgQSEhKyRrprzLKZa43i+BzLNQ6PXw0D
BgwYvDKcPr+qLPGB0sU1qvH1ahtDQUFNgnJflVfVoj6+aY3nxIl3iLuvTrLq
iA+/6lQFVFXx1jynjP8cu88kC7P51UVxvij9GWRNK4v+DDx48OAZwkN/BjQ0
9Fho+jMgISHPSdKfgQEDhms00J8BBQXVpujPIO7LnXJWHfHhVx39GfRn/D+q
PkJ9vMtOFlljyZo731m+3UnFgwcPHjx+emZFl08R/+6EQ0NDQ/tHqysB7m/C
kbASrWjXbH96ACAhISH7Id0VMWzmWqMYV8cABgwYMEzbcPqc1u++DSgoqGum
3HfPLt1jQZx4l7j7av6l/yrixPtf1WrWp86uKY796RjrO5plmT5q/rJVOW3z
za9gBb9iJj8h\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{560, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->197392595]
}, Open  ]],

Cell["Align on the right:", "ExampleText",
 CellID->857286111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"TextAlignment", "\[Rule]", "Right"}]}], "]"}], "]"}]}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->539273144],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnd1KwzAYQNO/rRd638s9wRAfwEu9qqBvUIawXYgy9/41aZr+LRVltU27
M+iW5PvOmUjIsvSDpdlp//aenQ67bPN0zD73h93X5vHjKIcCTwj/TgjxkAjZ
zmWruMzjXl6yH8RxLPTDpGzl5enhoCIqcCsvTwOLjj7Lp1CNhfofVSbIjl++
RmWQLLLmkLW2zvNUPa3qftEoKZOnEL/Tb8ZV08eDBw8ePAW3yi9ZbYuFPKry
mqPQ0NDQA9Nx3vctKBBGohXdlc/uiyAhISEbpH2NSdu5xijO91i2vn/+bhgw
YMDglKF/f1VZwprSi2vQ4JurbQgFBbUIyn4q/5rXq4hq3nT6a+LEL4jbTyeZ
dcTHn3UvuV4Vb/N6p0T/5747dRJTRanPIGtZWdRn4MGDB88YHuozoKGh50JT
nwEJCfmfJPUZGDBguEYD9RlQUFBdivoM4q7cKWfWER9/1lGfQX3G36PqI9TF
u+xkkTWXLPve07U7qXjw4MGDx02PfVf/W7t7d8KhoaGh3aPt3/zN6XLzVLm7
ZrtTAwAJCQk5DGlfEf12rjGKeVUMYMCAAcOyDf17WrfrNqCgoK6Zst89m7rG
gjjxS+L20/yp/yrixIef1Wp06kqupffdqRgbOpokiW61f9mqGDb55a9ged+c
UT8h\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{560, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->36097313]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3139],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StandardForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StandardForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraditionalForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraditionalForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pane",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pane"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Panel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Panel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inherited",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inherited"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Magnify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Magnify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaseStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BaseStyle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16942]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30776],

Cell[TextData[ButtonBox["Styles and Fonts in Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StylesAndFontsInOutput"]], "Tutorials",
 CellID->7906],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->175077611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Style",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Style"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->463805361],

Cell[TextData[ButtonBox["Cell Styling Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CellStylingOptions"]], "MoreAbout",
 CellID->31640496],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->215863874],

Cell[TextData[ButtonBox["Controls Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlsOptions"]], "MoreAbout",
 CellID->161905391],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->829817255],

Cell[TextData[ButtonBox["Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FontOptions"]], "MoreAbout",
 CellID->1879786],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->603088031],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->45574548],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "MoreAbout",
 CellID->96345098],

Cell[TextData[ButtonBox["Math Typesetting Options & Tweaking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathTypesettingOptionsAndTweaking"]], "MoreAbout",
 CellID->37530896],

Cell[TextData[ButtonBox["Notebook Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], "MoreAbout",
 CellID->23218918],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->818861033],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->68160092],

Cell[TextData[ButtonBox["Text Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextStyling"]], "MoreAbout",
 CellID->1410250],

Cell[TextData[ButtonBox["Textual Elements in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextualElementsInNotebooks"]], "MoreAbout",
 CellID->344485726],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->493744943],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->8663767]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Style - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 56.4547378}", "context" -> "System`", 
    "keywords" -> {"display style", "font size", "styles", "text color"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Style[expr, options] displays with expr formatted using the specified \
option settings. Style[expr, \" style\"] uses the option settings for the \
specified style in the current notebook. Style[expr, color] displays using \
the specified color. Style[expr, Bold] displays with fonts made bold. \
Style[expr, Italic] displays with fonts made italic. Style[expr, Underlined] \
displays with fonts underlined. Style[expr, Larger] displays with fonts made \
larger. Style[expr, Smaller] displays with fonts made smaller. Style[expr, n] \
displays with font size n. Style[expr, Tiny], Style[expr, Small], etc. \
display with fonts that are tiny, small, etc. ", "synonyms" -> {}, "title" -> 
    "Style", "type" -> "Symbol", "uri" -> "ref/Style"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[22952, 677, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->686042511]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 116218, 4040}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 5000, 105, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5623, 132, 1570, 37, 70, "ObjectNameGrid"],
Cell[7196, 171, 4603, 147, 70, "Usage",
 CellID->19733]
}, Open  ]],
Cell[CellGroupData[{
Cell[11836, 323, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[12314, 340, 217, 7, 70, "Notes",
 CellID->12778],
Cell[12534, 349, 622, 23, 70, "Notes",
 CellID->20576],
Cell[13159, 374, 3811, 117, 70, "2ColumnTableMod",
 CellID->28170],
Cell[16973, 493, 265, 9, 70, "Notes",
 CellID->18972],
Cell[17241, 504, 225, 7, 70, "Notes",
 CellID->30244],
Cell[17469, 513, 791, 28, 70, "Notes",
 CellID->21255],
Cell[18263, 543, 141, 4, 70, "Notes",
 CellID->29791],
Cell[18407, 549, 366, 13, 70, "Notes",
 CellID->6015],
Cell[18776, 564, 72, 1, 70, "Notes",
 CellID->19218],
Cell[18851, 567, 1545, 40, 70, "2ColumnTableMod",
 CellID->562],
Cell[20399, 609, 68, 1, 70, "Notes",
 CellID->11575],
Cell[20470, 612, 2160, 49, 70, "2ColumnTableMod",
 CellID->10536],
Cell[22633, 663, 282, 9, 70, "Notes",
 CellID->13257]
}, Closed]],
Cell[CellGroupData[{
Cell[22952, 677, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->686042511],
Cell[CellGroupData[{
Cell[23337, 691, 148, 5, 70, "ExampleSection",
 CellID->234705944],
Cell[23488, 698, 61, 1, 70, "ExampleText",
 CellID->56657697],
Cell[CellGroupData[{
Cell[23574, 703, 215, 8, 28, "Input",
 CellID->11659],
Cell[23792, 713, 400, 14, 60, "Output",
 CellID->205007106]
}, Open  ]],
Cell[24207, 730, 78, 1, 70, "ExampleText",
 CellID->39986813],
Cell[CellGroupData[{
Cell[24310, 735, 201, 6, 28, "Input",
 CellID->439867236],
Cell[24514, 743, 515, 17, 50, "Output",
 CellID->359846078]
}, Open  ]],
Cell[25044, 763, 123, 3, 70, "ExampleDelimiter",
 CellID->1341670],
Cell[25170, 768, 63, 1, 70, "ExampleText",
 CellID->38969484],
Cell[CellGroupData[{
Cell[25258, 773, 149, 4, 70, "Input",
 CellID->364991719],
Cell[25410, 779, 215, 7, 46, "Output",
 CellID->820790916]
}, Open  ]],
Cell[25640, 789, 125, 3, 70, "ExampleDelimiter",
 CellID->115650530],
Cell[25768, 794, 92, 1, 70, "ExampleText",
 CellID->93023256],
Cell[CellGroupData[{
Cell[25885, 799, 209, 7, 70, "Input",
 CellID->33805397],
Cell[26097, 808, 284, 8, 121, "Output",
 CellID->669396]
}, Open  ]],
Cell[CellGroupData[{
Cell[26418, 821, 197, 6, 70, "Input",
 CellID->175370996],
Cell[26618, 829, 10554, 178, 129, 88, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->5181273]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37221, 1013, 220, 7, 70, "ExampleSection",
 CellID->964388671],
Cell[37444, 1022, 83, 1, 70, "ExampleText",
 CellID->59840908],
Cell[CellGroupData[{
Cell[37552, 1027, 352, 12, 70, "Input",
 CellID->46707443],
Cell[37907, 1041, 884, 31, 69, "Output",
 CellID->998082844]
}, Open  ]],
Cell[38806, 1075, 71, 1, 70, "ExampleText",
 CellID->272139200],
Cell[CellGroupData[{
Cell[38902, 1080, 389, 12, 70, "Input",
 CellID->373302568],
Cell[39294, 1094, 1229, 39, 51, "Output",
 CellID->163564490]
}, Open  ]],
Cell[40538, 1136, 125, 3, 70, "ExampleDelimiter",
 CellID->631960720],
Cell[40666, 1141, 66, 1, 70, "ExampleText",
 CellID->79773026],
Cell[CellGroupData[{
Cell[40757, 1146, 346, 11, 70, "Input",
 CellID->116884859],
Cell[41106, 1159, 324, 9, 121, "Output",
 CellID->489050249]
}, Open  ]],
Cell[41445, 1171, 124, 3, 70, "ExampleDelimiter",
 CellID->99382743],
Cell[41572, 1176, 99, 1, 70, "ExampleText",
 CellID->172000602],
Cell[41674, 1179, 243, 8, 70, "Input",
 CellID->1986106],
Cell[CellGroupData[{
Cell[41942, 1191, 226, 7, 70, "Input",
 CellID->12381354],
Cell[42171, 1200, 851, 20, 83, "Output",
 CellID->91370470]
}, Open  ]],
Cell[CellGroupData[{
Cell[43059, 1225, 285, 9, 70, "Input",
 CellID->492434835],
Cell[43347, 1236, 887, 19, 70, "Output",
 Evaluatable->False,
 CellID->132576072]
}, Open  ]],
Cell[CellGroupData[{
Cell[44271, 1260, 236, 8, 70, "Input",
 CellID->223631662],
Cell[44510, 1270, 870, 18, 70, "Output",
 Evaluatable->False,
 CellID->146494897]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45429, 1294, 223, 7, 70, "ExampleSection",
 CellID->144918184],
Cell[CellGroupData[{
Cell[45677, 1305, 232, 7, 70, "ExampleSubsection",
 CellID->38114515],
Cell[45912, 1314, 71, 1, 70, "ExampleText",
 CellID->195867228],
Cell[CellGroupData[{
Cell[46008, 1319, 232, 7, 70, "Input",
 CellID->4666290],
Cell[46243, 1328, 299, 10, 121, "Output",
 CellID->151498524]
}, Open  ]],
Cell[46557, 1341, 124, 3, 70, "ExampleDelimiter",
 CellID->37963061],
Cell[46684, 1346, 68, 1, 70, "ExampleText",
 CellID->73392904],
Cell[CellGroupData[{
Cell[46777, 1351, 235, 7, 70, "Input",
 CellID->495981589],
Cell[47015, 1360, 300, 10, 121, "Output",
 CellID->412648383]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[47364, 1376, 230, 7, 70, "ExampleSubsection",
 CellID->17117600],
Cell[47597, 1385, 69, 1, 70, "ExampleText",
 CellID->428806057],
Cell[CellGroupData[{
Cell[47691, 1390, 489, 16, 70, "Input",
 CellID->115899743],
Cell[48183, 1408, 829, 31, 60, "Output",
 CellID->347467905]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[49061, 1445, 237, 7, 70, "ExampleSubsection",
 CellID->10486425],
Cell[49301, 1454, 226, 8, 70, "ExampleText",
 CellID->972670439],
Cell[CellGroupData[{
Cell[49552, 1466, 299, 10, 70, "Input",
 CellID->1435729129],
Cell[49854, 1478, 308, 12, 70, "Output",
 CellID->111587005]
}, Open  ]],
Cell[50177, 1493, 125, 3, 70, "ExampleDelimiter",
 CellID->826669350],
Cell[50305, 1498, 185, 7, 70, "ExampleText",
 CellID->1771134871],
Cell[CellGroupData[{
Cell[50515, 1509, 370, 12, 70, "Input",
 CellID->112136915],
Cell[50888, 1523, 324, 12, 70, "Output",
 CellID->1211594372]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[51261, 1541, 235, 7, 70, "ExampleSubsection",
 CellID->496916371],
Cell[51499, 1550, 208, 8, 70, "ExampleText",
 CellID->105572740],
Cell[CellGroupData[{
Cell[51732, 1562, 836, 25, 70, "Input",
 CellID->12412063],
Cell[52571, 1589, 452, 15, 70, "Output",
 CellID->78069277]
}, Open  ]],
Cell[53038, 1607, 122, 3, 70, "ExampleDelimiter",
 CellID->256549],
Cell[53163, 1612, 140, 4, 70, "ExampleText",
 CellID->807970789],
Cell[CellGroupData[{
Cell[53328, 1620, 985, 29, 70, "Input",
 CellID->358337721],
Cell[54316, 1651, 516, 17, 70, "Output",
 CellID->73033120]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[54881, 1674, 228, 7, 70, "ExampleSubsection",
 CellID->12771641],
Cell[55112, 1683, 140, 4, 70, "ExampleText",
 CellID->1972924211],
Cell[CellGroupData[{
Cell[55277, 1691, 313, 10, 70, "Input",
 CellID->23842454],
Cell[55593, 1703, 318, 12, 70, "Output",
 CellID->627201086]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[55960, 1721, 231, 7, 70, "ExampleSubsection",
 CellID->959274925],
Cell[56194, 1730, 210, 6, 70, "ExampleText",
 CellID->263067636],
Cell[CellGroupData[{
Cell[56429, 1740, 245, 7, 70, "Input",
 CellID->172619616],
Cell[56677, 1749, 267, 9, 36, "Output",
 CellID->184413824]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[56993, 1764, 229, 7, 70, "ExampleSubsection",
 CellID->312993344],
Cell[57225, 1773, 84, 1, 70, "ExampleText",
 CellID->196701548],
Cell[57312, 1776, 85, 2, 70, "Input",
 CellID->313377804],
Cell[57400, 1780, 85, 2, 70, "Input",
 CellID->152698952],
Cell[57488, 1784, 124, 3, 70, "ExampleDelimiter",
 CellID->96104557],
Cell[57615, 1789, 71, 1, 70, "ExampleText",
 CellID->64491326],
Cell[CellGroupData[{
Cell[57711, 1794, 180, 5, 70, "Input",
 CellID->684264301],
Cell[57894, 1801, 276, 10, 36, "Output",
 CellID->79555262]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[58219, 1817, 227, 7, 70, "ExampleSubsection",
 CellID->86180943],
Cell[58449, 1826, 207, 8, 70, "ExampleText",
 CellID->45274876],
Cell[CellGroupData[{
Cell[58681, 1838, 275, 9, 70, "Input",
 CellID->188618259],
Cell[58959, 1849, 294, 12, 70, "Output",
 CellID->183587834]
}, Open  ]],
Cell[59268, 1864, 184, 7, 70, "ExampleText",
 CellID->309327794],
Cell[CellGroupData[{
Cell[59477, 1875, 347, 11, 70, "Input",
 CellID->624206400],
Cell[59827, 1888, 309, 12, 70, "Output",
 CellID->258103884]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60185, 1906, 228, 7, 70, "ExampleSubsection",
 CellID->7240849],
Cell[60416, 1915, 62, 1, 70, "ExampleText",
 CellID->516957610],
Cell[CellGroupData[{
Cell[60503, 1920, 220, 7, 70, "Input",
 CellID->64068271],
Cell[60726, 1929, 331, 13, 55, "Output",
 CellID->679280969]
}, Open  ]],
Cell[61072, 1945, 125, 3, 70, "ExampleDelimiter",
 CellID->426280928],
Cell[61200, 1950, 85, 1, 70, "ExampleText",
 CellID->352767449],
Cell[CellGroupData[{
Cell[61310, 1955, 183, 6, 70, "Input",
 CellID->133664627],
Cell[61496, 1963, 552, 19, 55, "Output",
 CellID->227903431]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[62097, 1988, 229, 7, 70, "ExampleSubsection",
 CellID->9394985],
Cell[62329, 1997, 131, 5, 70, "ExampleText",
 CellID->71723857],
Cell[CellGroupData[{
Cell[62485, 2006, 192, 5, 70, "Input",
 CellID->427933374],
Cell[62680, 2013, 232, 8, 36, "Output",
 CellID->46850723]
}, Open  ]],
Cell[62927, 2024, 129, 5, 70, "ExampleText",
 CellID->37138760],
Cell[CellGroupData[{
Cell[63081, 2033, 190, 5, 70, "Input",
 CellID->343677596],
Cell[63274, 2040, 231, 8, 36, "Output",
 CellID->281457506]
}, Open  ]],
Cell[63520, 2051, 134, 5, 70, "ExampleText",
 CellID->336261304],
Cell[CellGroupData[{
Cell[63679, 2060, 192, 5, 70, "Input",
 CellID->6607165],
Cell[63874, 2067, 235, 8, 36, "Output",
 CellID->104090770]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[64158, 2081, 229, 7, 70, "ExampleSubsection",
 CellID->257008440],
Cell[64390, 2090, 84, 1, 70, "ExampleText",
 CellID->193738469],
Cell[CellGroupData[{
Cell[64499, 2095, 383, 13, 70, "Input",
 CellID->162708554],
Cell[64885, 2110, 727, 25, 64, "Output",
 CellID->376568569]
}, Open  ]],
Cell[65627, 2138, 115, 3, 70, "ExampleText",
 CellID->122796288],
Cell[CellGroupData[{
Cell[65767, 2145, 409, 13, 70, "Input",
 CellID->285828925],
Cell[66179, 2160, 877, 18, 70, "Output",
 Evaluatable->False,
 CellID->23546868]
}, Open  ]],
Cell[67071, 2181, 124, 3, 70, "ExampleDelimiter",
 CellID->40568201],
Cell[67198, 2186, 89, 1, 70, "ExampleText",
 CellID->173172889],
Cell[CellGroupData[{
Cell[67312, 2191, 342, 12, 70, "Input",
 CellID->24262061],
Cell[67657, 2205, 691, 25, 64, "Output",
 CellID->226337190]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[68397, 2236, 230, 7, 70, "ExampleSubsection",
 CellID->643679630],
Cell[68630, 2245, 54, 1, 70, "ExampleText",
 CellID->71764800],
Cell[CellGroupData[{
Cell[68709, 2250, 181, 5, 70, "Input",
 CellID->487023725],
Cell[68893, 2257, 228, 8, 36, "Output",
 CellID->517749681]
}, Open  ]],
Cell[69136, 2268, 56, 1, 70, "ExampleText",
 CellID->302010642],
Cell[CellGroupData[{
Cell[69217, 2273, 181, 5, 70, "Input",
 CellID->18250517],
Cell[69401, 2280, 229, 8, 37, "Output",
 CellID->660809052]
}, Open  ]],
Cell[69645, 2291, 125, 3, 70, "ExampleDelimiter",
 CellID->501438774],
Cell[69773, 2296, 91, 1, 70, "ExampleText",
 CellID->111737163],
Cell[CellGroupData[{
Cell[69889, 2301, 144, 4, 70, "Input",
 CellID->219837801],
Cell[70036, 2307, 227, 8, 37, "Output",
 CellID->1084663]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[70312, 2321, 231, 7, 70, "ExampleSubsection",
 CellID->7658463],
Cell[70546, 2330, 213, 8, 70, "ExampleText",
 CellID->91142790],
Cell[CellGroupData[{
Cell[70784, 2342, 580, 17, 70, "Input",
 CellID->110547051],
Cell[71367, 2361, 1025, 38, 118, "Output",
 CellID->20005130]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[72441, 2405, 234, 7, 70, "ExampleSubsection",
 CellID->35104917],
Cell[72678, 2414, 57, 1, 70, "ExampleText",
 CellID->4608814],
Cell[CellGroupData[{
Cell[72760, 2419, 260, 8, 70, "Input",
 CellID->13109641],
Cell[73023, 2429, 246, 8, 36, "Output",
 CellID->18582837]
}, Open  ]],
Cell[73284, 2440, 63, 1, 70, "ExampleText",
 CellID->321858622],
Cell[CellGroupData[{
Cell[73372, 2445, 265, 8, 70, "Input",
 CellID->134397311],
Cell[73640, 2455, 251, 8, 36, "Output",
 CellID->479269940]
}, Open  ]],
Cell[73906, 2466, 56, 1, 70, "ExampleText",
 CellID->785682462],
Cell[CellGroupData[{
Cell[73987, 2471, 344, 10, 70, "Input",
 CellID->353889339],
Cell[74334, 2483, 272, 9, 36, "Output",
 CellID->561533002]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[74655, 2498, 231, 7, 70, "ExampleSubsection",
 CellID->103919133],
Cell[74889, 2507, 54, 1, 70, "ExampleText",
 CellID->47509944],
Cell[CellGroupData[{
Cell[74968, 2512, 196, 5, 70, "Input",
 CellID->946307472],
Cell[75167, 2519, 249, 9, 48, "Output",
 CellID->249329908]
}, Open  ]],
Cell[75431, 2531, 53, 1, 70, "ExampleText",
 CellID->44183612],
Cell[CellGroupData[{
Cell[75509, 2536, 195, 5, 70, "Input",
 CellID->120864318],
Cell[75707, 2543, 248, 9, 48, "Output",
 CellID->129429599]
}, Open  ]],
Cell[75970, 2555, 125, 3, 70, "ExampleDelimiter",
 CellID->134605282],
Cell[76098, 2560, 92, 1, 70, "ExampleText",
 CellID->490889040],
Cell[CellGroupData[{
Cell[76215, 2565, 156, 4, 70, "Input",
 CellID->417895822],
Cell[76374, 2571, 247, 9, 48, "Output",
 CellID->87387019]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[76670, 2586, 240, 7, 70, "ExampleSubsection",
 CellID->38032121],
Cell[76913, 2595, 68, 1, 70, "ExampleText",
 CellID->87374991],
Cell[CellGroupData[{
Cell[77006, 2600, 262, 9, 70, "Input",
 CellID->68463969],
Cell[77271, 2611, 281, 9, 151, "Output",
 CellID->332343884]
}, Open  ]],
Cell[77567, 2623, 119, 3, 70, "ExampleText",
 CellID->670213564],
Cell[CellGroupData[{
Cell[77711, 2630, 465, 15, 70, "Input",
 CellID->28741958],
Cell[78179, 2647, 340, 11, 75, "Output",
 CellID->125857169]
}, Open  ]],
Cell[78534, 2661, 125, 3, 70, "ExampleDelimiter",
 CellID->463424180],
Cell[78662, 2666, 123, 3, 70, "ExampleText",
 CellID->431845390],
Cell[CellGroupData[{
Cell[78810, 2673, 471, 15, 70, "Input",
 CellID->358157864],
Cell[79284, 2690, 343, 11, 49, "Output",
 CellID->55064882]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[79676, 2707, 231, 7, 70, "ExampleSubsection",
 CellID->959469322],
Cell[79910, 2716, 75, 1, 70, "ExampleText",
 CellID->358696996],
Cell[79988, 2719, 243, 8, 70, "Input",
 CellID->8271777],
Cell[CellGroupData[{
Cell[80256, 2731, 227, 7, 70, "Input",
 CellID->318287936],
Cell[80486, 2740, 851, 20, 83, "Output",
 CellID->40616788]
}, Open  ]],
Cell[81352, 2763, 58, 1, 70, "ExampleText",
 CellID->120976664],
Cell[CellGroupData[{
Cell[81435, 2768, 226, 7, 70, "Input",
 CellID->39576492],
Cell[81664, 2777, 825, 18, 70, "Output",
 Evaluatable->False,
 CellID->97876273]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[82538, 2801, 232, 7, 70, "ExampleSubsection",
 CellID->728189816],
Cell[82773, 2810, 57, 1, 70, "ExampleText",
 CellID->49411886],
Cell[82833, 2813, 245, 8, 70, "Input",
 CellID->320669149],
Cell[CellGroupData[{
Cell[83103, 2825, 283, 9, 70, "Input",
 CellID->525120996],
Cell[83389, 2836, 886, 19, 70, "Output",
 Evaluatable->False,
 CellID->22440470]
}, Open  ]],
Cell[84290, 2858, 93, 1, 70, "ExampleText",
 CellID->643382238],
Cell[CellGroupData[{
Cell[84408, 2863, 284, 9, 70, "Input",
 CellID->125698937],
Cell[84695, 2874, 878, 18, 70, "Output",
 Evaluatable->False,
 CellID->330881213]
}, Open  ]],
Cell[85588, 2895, 123, 3, 70, "ExampleText",
 CellID->779543827],
Cell[CellGroupData[{
Cell[85736, 2902, 283, 9, 70, "Input",
 CellID->105787743],
Cell[86022, 2913, 886, 19, 70, "Output",
 Evaluatable->False,
 CellID->13098578]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[86957, 2938, 234, 7, 70, "ExampleSubsection",
 CellID->608300505],
Cell[87194, 2947, 78, 1, 70, "ExampleText",
 CellID->468708893],
Cell[CellGroupData[{
Cell[87297, 2952, 415, 14, 70, "Input",
 CellID->686464458],
Cell[87715, 2968, 537, 23, 63, "Output",
 CellID->501889901]
}, Open  ]],
Cell[CellGroupData[{
Cell[88289, 2996, 522, 17, 70, "Input",
 CellID->532356367],
Cell[88814, 3015, 689, 27, 113, "Output",
 CellID->189088408]
}, Open  ]],
Cell[89518, 3045, 125, 3, 70, "ExampleDelimiter",
 CellID->104349828],
Cell[89646, 3050, 225, 7, 70, "ExampleText",
 CellID->348541635],
Cell[CellGroupData[{
Cell[89896, 3061, 284, 9, 70, "Input",
 CellID->639918153],
Cell[90183, 3072, 314, 12, 72, "Output",
 CellID->247851121]
}, Open  ]],
Cell[CellGroupData[{
Cell[90534, 3089, 381, 13, 70, "Input",
 CellID->457015859],
Cell[90918, 3104, 1190, 47, 132, "Output",
 CellID->546738664]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[92157, 3157, 235, 7, 70, "ExampleSubsection",
 CellID->88470207],
Cell[92395, 3166, 210, 6, 70, "ExampleText",
 CellID->137646331],
Cell[CellGroupData[{
Cell[92630, 3176, 245, 7, 70, "Input",
 CellID->119451510],
Cell[92878, 3185, 267, 9, 36, "Output",
 CellID->149546577]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[93194, 3200, 240, 7, 70, "ExampleSubsection",
 CellID->79091171],
Cell[93437, 3209, 88, 1, 70, "ExampleText",
 CellID->22309],
Cell[CellGroupData[{
Cell[93550, 3214, 206, 7, 70, "Input",
 CellID->396171734],
Cell[93759, 3223, 294, 10, 39, "Output",
 CellID->135387436]
}, Open  ]],
Cell[94068, 3236, 86, 1, 70, "ExampleText",
 CellID->26223],
Cell[CellGroupData[{
Cell[94179, 3241, 369, 12, 70, "Input",
 CellID->15014],
Cell[94551, 3255, 374, 13, 49, "Output",
 CellID->661201631]
}, Open  ]],
Cell[94940, 3271, 124, 4, 70, "ExampleText",
 CellID->61],
Cell[CellGroupData[{
Cell[95089, 3279, 361, 12, 70, "Input",
 CellID->14906],
Cell[95453, 3293, 365, 13, 49, "Output",
 CellID->21000513]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[95867, 3312, 234, 7, 70, "ExampleSubsection",
 CellID->159132065],
Cell[96104, 3321, 256, 8, 70, "ExampleText",
 CellID->279618131],
Cell[CellGroupData[{
Cell[96385, 3333, 396, 13, 70, "Input",
 CellID->128184475],
Cell[96784, 3348, 557, 22, 47, "Output",
 CellID->431979238]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[97390, 3376, 241, 7, 70, "ExampleSubsection",
 CellID->69766984],
Cell[97634, 3385, 278, 8, 70, "ExampleText",
 CellID->218579224],
Cell[CellGroupData[{
Cell[97937, 3397, 422, 14, 70, "Input",
 CellID->19975730],
Cell[98362, 3413, 647, 25, 60, "Output",
 CellID->63598606]
}, Open  ]],
Cell[99024, 3441, 125, 3, 70, "ExampleDelimiter",
 CellID->679758697],
Cell[99152, 3446, 208, 6, 70, "ExampleText",
 CellID->148048739],
Cell[CellGroupData[{
Cell[99385, 3456, 597, 19, 70, "Input",
 CellID->21766505],
Cell[99985, 3477, 561, 21, 61, "Output",
 CellID->3629833]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[100595, 3504, 240, 7, 70, "ExampleSubsection",
 CellID->14172067],
Cell[100838, 3513, 146, 4, 70, "ExampleText",
 CellID->422807826],
Cell[CellGroupData[{
Cell[101009, 3521, 85, 2, 70, "Input",
 CellID->354065117],
Cell[101097, 3525, 173, 5, 36, "Output",
 CellID->183914581]
}, Open  ]],
Cell[101285, 3533, 124, 3, 70, "ExampleDelimiter",
 CellID->59396938],
Cell[101412, 3538, 95, 1, 70, "ExampleText",
 CellID->129539285],
Cell[CellGroupData[{
Cell[101532, 3543, 191, 5, 70, "Input",
 CellID->554898832],
Cell[101726, 3550, 238, 8, 36, "Output",
 CellID->195079449]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[102013, 3564, 240, 7, 70, "ExampleSubsection",
 CellID->185020904],
Cell[102256, 3573, 118, 3, 70, "ExampleText",
 CellID->574549076],
Cell[CellGroupData[{
Cell[102399, 3580, 230, 7, 70, "Input",
 CellID->87718655],
Cell[102632, 3589, 276, 10, 36, "Output",
 CellID->253259716]
}, Open  ]],
Cell[102923, 3602, 125, 3, 70, "ExampleDelimiter",
 CellID->140295384],
Cell[103051, 3607, 270, 8, 70, "ExampleText",
 CellID->205213398],
Cell[CellGroupData[{
Cell[103346, 3619, 298, 9, 70, "Input",
 CellID->174685336],
Cell[103647, 3630, 353, 12, 50, "Output",
 CellID->164614641]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[104049, 3648, 233, 7, 70, "ExampleSubsection",
 CellID->12800794],
Cell[104285, 3657, 61, 1, 70, "ExampleText",
 CellID->827890818],
Cell[104349, 3660, 244, 8, 70, "Input",
 CellID->367642920],
Cell[CellGroupData[{
Cell[104618, 3672, 235, 8, 70, "Input",
 CellID->341845274],
Cell[104856, 3682, 907, 19, 70, "Output",
 Evaluatable->False,
 CellID->281802546]
}, Open  ]],
Cell[105778, 3704, 51, 1, 70, "ExampleText",
 CellID->90237254],
Cell[CellGroupData[{
Cell[105854, 3709, 239, 8, 70, "Input",
 CellID->449003041],
Cell[106096, 3719, 895, 19, 70, "Output",
 Evaluatable->False,
 CellID->197392595]
}, Open  ]],
Cell[107006, 3741, 62, 1, 70, "ExampleText",
 CellID->857286111],
Cell[CellGroupData[{
Cell[107093, 3746, 236, 8, 70, "Input",
 CellID->539273144],
Cell[107332, 3756, 886, 19, 70, "Output",
 Evaluatable->False,
 CellID->36097313]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[108291, 3783, 310, 9, 70, "SeeAlsoSection",
 CellID->3139],
Cell[108604, 3794, 1686, 62, 70, "SeeAlso",
 CellID->16942]
}, Open  ]],
Cell[CellGroupData[{
Cell[110327, 3861, 314, 9, 70, "TutorialsSection",
 CellID->30776],
Cell[110644, 3872, 158, 3, 70, "Tutorials",
 CellID->7906],
Cell[110805, 3877, 146, 3, 70, "Tutorials",
 CellID->175077611]
}, Open  ]],
Cell[CellGroupData[{
Cell[110988, 3885, 305, 8, 70, "RelatedLinksSection"],
Cell[111296, 3895, 355, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[111688, 3912, 319, 9, 70, "MoreAboutSection",
 CellID->463805361],
Cell[112010, 3923, 149, 3, 70, "MoreAbout",
 CellID->31640496],
Cell[112162, 3928, 124, 3, 70, "MoreAbout",
 CellID->215863874],
Cell[112289, 3933, 143, 3, 70, "MoreAbout",
 CellID->161905391],
Cell[112435, 3938, 149, 3, 70, "MoreAbout",
 CellID->829817255],
Cell[112587, 3943, 133, 3, 70, "MoreAbout",
 CellID->1879786],
Cell[112723, 3948, 175, 3, 70, "MoreAbout",
 CellID->603088031],
Cell[112901, 3953, 148, 3, 70, "MoreAbout",
 CellID->45574548],
Cell[113052, 3958, 158, 3, 70, "MoreAbout",
 CellID->96345098],
Cell[113213, 3963, 179, 3, 70, "MoreAbout",
 CellID->37530896],
Cell[113395, 3968, 168, 3, 70, "MoreAbout",
 CellID->23218918],
Cell[113566, 3973, 204, 4, 70, "MoreAbout",
 CellID->818861033],
Cell[113773, 3979, 127, 3, 70, "MoreAbout",
 CellID->68160092],
Cell[113903, 3984, 133, 3, 70, "MoreAbout",
 CellID->1410250],
Cell[114039, 3989, 167, 3, 70, "MoreAbout",
 CellID->344485726],
Cell[114209, 3994, 171, 3, 70, "MoreAbout",
 CellID->493744943],
Cell[114383, 3999, 171, 3, 70, "MoreAbout",
 CellID->8663767]
}, Open  ]],
Cell[114569, 4005, 27, 0, 70, "History"],
Cell[114599, 4007, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

