(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29656,        985]
NotebookOptionsPosition[     24969,        828]
NotebookOutlinePosition[     26368,        866]
CellTagsIndexPosition[     26283,        861]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Representing Textual Forms by Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RepresentingTextualFormsByBoxes"], 
          "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Representing Textual Forms by Boxes\"\>", 
       2->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Style" :> Documentation`HelpLookup["paclet:ref/Style"], 
          "AdjustmentBox" :> 
          Documentation`HelpLookup["paclet:ref/AdjustmentBox"], "FrameBox" :> 
          Documentation`HelpLookup["paclet:ref/FrameBox"], "Cell" :> 
          Documentation`HelpLookup["paclet:ref/Cell"], "ShowAutoStyles" :> 
          Documentation`HelpLookup["paclet:ref/ShowAutoStyles"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Style\"\>", 
       2->"\<\"AdjustmentBox\"\>", 3->"\<\"FrameBox\"\>", 4->"\<\"Cell\"\>", 
       5->"\<\"ShowAutoStyles\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Structure" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookStructure"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Structure\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["StyleBox", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StyleBox",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StyleBox"], "[", 
       RowBox[{
        StyleBox["boxes", "TI"], ",", 
        StyleBox["options", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a low-level representation of ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " to be shown with the specified option settings. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["StyleBox",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/StyleBox"], "[", 
       RowBox[{
        StyleBox["boxes", "TI"], ",", "\"\<\!\(\*
StyleBox[\"style\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses the option setting for the specified style in the \
current notebook. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->14796]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StyleBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
 " is the low-level representation of ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 ". Except for low-level notebook expression manipulation, ",
 Cell[BoxData[
  ButtonBox["StyleBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
 " should not need to be used directly."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->14861],

Cell[TextData[{
 "You can use font options such as ",
 Cell[BoxData[
  ButtonBox["FontSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontSize"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FontWeight",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontWeight"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FontSlant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontSlant"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FontFamily",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontFamily"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FontColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontColor"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Background",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Background"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["StyleBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9886],

Cell["The following additional options can be given: ", "Notes",
 CellID->4826],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AutoSpacing",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AutoSpacing"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to adjust character spacings automatically ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LineIndent",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LineIndent"], "1.0", Cell[
    "distance in ems to indent for each nesting level ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LineIndentMaxFraction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LineIndentMaxFraction"], "0.5", Cell[
    "maximum fraction of line width to indent ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ScriptMinSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ScriptMinSize"], "4", Cell[
    "the minimum point size to use for subscripts, etc. ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ScriptSizeMultipliers",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ScriptSizeMultipliers"], "0.71", Cell[
    "how much smaller to make each level of subscripts, etc. ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ShowContents",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ShowContents"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to make ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " visible or just leave space for them "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SpanLineThickness",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SpanLineThickness"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
thickness in printer\[CloseCurlyQuote]s points of fraction lines, etc. \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SpanMaxSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SpanMaxSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "maximum size of expandable characters in units of font size ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SpanMinSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SpanMinSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "minimum size of expandable characters in units of font size ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SpanSymmetric",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SpanSymmetric"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether vertically expandable characters should be symmetric about the axis \
of the box they are in \
\>", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->2700],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " input, ",
 Cell[BoxData[
  ButtonBox["StyleBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
 " is by default ignored, so that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["StyleBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StyleBox"], "[", 
   RowBox[{
    StyleBox["box", "TI"], ",", 
    StyleBox["spec", "TI"]}], "]"}]], "InlineFormula"],
 " is interpreted just as ",
 Cell[BoxData[
  StyleBox["box", "TI"]], "InlineFormula"],
 " would be. "
}], "Notes",
 CellID->14267],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["StyleBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
 " objects are nested, the options of the innermost one control the display \
of particular boxes. "
}], "Notes",
 CellID->22286],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", explicit ",
 Cell[BoxData[
  ButtonBox["StyleBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
 " objects are output literally. You can use ",
 Cell[BoxData[
  ButtonBox["DisplayForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayForm"]], "InlineFormula"],
 " to see the display form of such objects. "
}], "Notes",
 CellID->6498]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->208116907],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->389405475],

Cell["Style boxes or text according to a style option:", "ExampleText",
 CellID->718022677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StyleBox", "[", 
   RowBox[{"\"\<red\>\"", ",", 
    RowBox[{"FontColor", "->", "Red"}]}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184418053],

Cell[BoxData[
 TagBox[
  StyleBox["red",
   FontColor->RGBColor[1, 0, 0]],
  DisplayForm]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->4379104]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StyleBox", "[", 
   RowBox[{
    RowBox[{"FractionBox", "[", 
     RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "]"}], ",", 
    RowBox[{"FontSlant", "\[Rule]", "Italic"}]}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->52237288],

Cell[BoxData[
 TagBox[
  StyleBox[
   FractionBox["x", "y"],
   FontSlant->Italic],
  DisplayForm]], "Output",
 ImageSize->{17, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//DisplayForm=",
 CellID->526639339]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->51166457],

Cell["Use a named style: ", "ExampleText",
 CellID->551013023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StyleBox", "[", 
   RowBox[{"\"\<text\>\"", ",", "\"\<Section\>\""}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->147742623],

Cell[BoxData[
 TagBox[
  StyleBox["text", "Section"],
  DisplayForm]], "Output",
 ImageSize->{40, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->68072880]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StyleBox", "[", 
   RowBox[{
    RowBox[{"RadicalBox", "[", 
     RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "]"}], ",", "\"\<Section\>\""}],
    "]"}], "//", "DisplayForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->357172980],

Cell[BoxData[
 TagBox[
  StyleBox[
   RadicalBox["x", "y"], "Section"],
  DisplayForm]], "Output",
 ImageSize->{39, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//DisplayForm=",
 CellID->407997686]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->80306584],

Cell["Display some text that cannot be selected except as a whole:", \
"ExampleText",
 CellID->105373613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StyleBox", "[", 
   RowBox[{"\"\<words not selectable\>\"", ",", 
    RowBox[{"Selectable", "\[Rule]", "False"}]}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->373438594],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"words", " ", "not", " ", "selectable"}],
   Selectable->False],
  DisplayForm]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->169804930]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StyleBox", "[", 
   RowBox[{
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}], "]"}], ",", 
    RowBox[{"Selectable", "\[Rule]", "False"}]}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->160525684],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"x", "y"}],
   Selectable->False],
  DisplayForm]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//DisplayForm=",
 CellID->248658210]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->239967297],

Cell["\<\
By default spanning characters such as braces do not grow arbitrarily large: \
\
\>", "ExampleText",
 CellID->295431151],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowBox", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<{\>\"", ",", 
     RowBox[{"FractionBox", "[", 
      RowBox[{"\"\<x\>\"", ",", 
       RowBox[{"SuperscriptBox", "[", 
        RowBox[{"\"\<y\>\"", ",", "\"\<2\>\""}], "]"}]}], "]"}], ",", 
     "\"\<+\>\"", ",", "\"\<1\>\"", ",", "\"\<}\>\""}], "}"}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->228118131],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   FractionBox["x", 
    SuperscriptBox["y", "2"]], "+", "1", "}"}],
  DisplayForm]], "Output",
 ImageSize->{55, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->97437491]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["SpanMaxSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SpanMaxSize"]], "InlineFormula"],
 " to allow braces to grow to the full size: "
}], "ExampleText",
 CellID->705283069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StyleBox", "[", 
   RowBox[{
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<{\>\"", ",", 
       RowBox[{"FractionBox", "[", 
        RowBox[{"\"\<x\>\"", ",", 
         RowBox[{"SuperscriptBox", "[", 
          RowBox[{"\"\<y\>\"", ",", "\"\<2\>\""}], "]"}]}], "]"}], ",", 
       "\"\<+\>\"", ",", "\"\<1\>\"", ",", "\"\<}\>\""}], "}"}], "]"}], ",", 
    RowBox[{"SpanMaxSize", "\[Rule]", "Infinity"}]}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->125942992],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"{", 
    FractionBox["x", 
     SuperscriptBox["y", "2"]], "+", "1", "}"}],
   SpanMaxSize->DirectedInfinity[1]],
  DisplayForm]], "Output",
 ImageSize->{55, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//DisplayForm=",
 CellID->178007152]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17179],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AdjustmentBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AdjustmentBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cell"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowAutoStyles",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowAutoStyles"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13363],

Cell[BoxData["\\"], "Input",
 CellID->81107463]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29356],

Cell[TextData[ButtonBox["Representing Textual Forms by Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepresentingTextualFormsByBoxes"]], "Tutorials",\

 CellID->17007],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->175077611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookStructure"]], "MoreAbout",
 CellID->27232384]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"StyleBox - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 48.7670410}", "context" -> "System`", 
    "keywords" -> {"StyleBox options", "styles", "box styles"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "StyleBox[boxes, options] is a low-level representation of boxes to be \
shown with the specified option settings. StyleBox[boxes, \" style\"] uses \
the option setting for the specified style in the current notebook. ", 
    "synonyms" -> {"style box"}, "title" -> "StyleBox", "type" -> "Symbol", 
    "uri" -> "ref/StyleBox"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15644, 446, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->208116907]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26139, 854}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2375, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2998, 83, 4192, 83, 70, "ObjectNameGrid"],
Cell[7193, 168, 1075, 32, 70, "Usage",
 CellID->14796]
}, Open  ]],
Cell[CellGroupData[{
Cell[8305, 205, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8783, 222, 669, 20, 70, "Notes",
 CellID->14861],
Cell[9455, 244, 983, 38, 70, "Notes",
 CellID->9886],
Cell[10441, 284, 79, 1, 70, "Notes",
 CellID->4826],
Cell[10523, 287, 3466, 91, 70, "3ColumnTableMod",
 CellID->2700],
Cell[13992, 380, 803, 30, 70, "Notes",
 CellID->14267],
Cell[14798, 412, 274, 9, 70, "Notes",
 CellID->22286],
Cell[15075, 423, 532, 18, 70, "Notes",
 CellID->6498]
}, Closed]],
Cell[CellGroupData[{
Cell[15644, 446, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->208116907],
Cell[CellGroupData[{
Cell[16029, 460, 148, 5, 70, "ExampleSection",
 CellID->389405475],
Cell[16180, 467, 91, 1, 70, "ExampleText",
 CellID->718022677],
Cell[CellGroupData[{
Cell[16296, 472, 211, 7, 28, "Input",
 CellID->184418053],
Cell[16510, 481, 242, 9, 50, "Output",
 CellID->4379104]
}, Open  ]],
Cell[CellGroupData[{
Cell[16789, 495, 290, 9, 28, "Input",
 CellID->52237288],
Cell[17082, 506, 253, 10, 65, "Output",
 CellID->526639339]
}, Open  ]],
Cell[17350, 519, 124, 3, 70, "ExampleDelimiter",
 CellID->51166457],
Cell[17477, 524, 62, 1, 70, "ExampleText",
 CellID->551013023],
Cell[CellGroupData[{
Cell[17564, 529, 190, 6, 70, "Input",
 CellID->147742623],
Cell[17757, 537, 222, 8, 53, "Output",
 CellID->68072880]
}, Open  ]],
Cell[CellGroupData[{
Cell[18016, 550, 261, 8, 70, "Input",
 CellID->357172980],
Cell[18280, 560, 241, 9, 67, "Output",
 CellID->407997686]
}, Open  ]],
Cell[18536, 572, 124, 3, 70, "ExampleDelimiter",
 CellID->80306584],
Cell[18663, 577, 105, 2, 70, "ExampleText",
 CellID->105373613],
Cell[CellGroupData[{
Cell[18793, 583, 236, 7, 70, "Input",
 CellID->373438594],
Cell[19032, 592, 281, 10, 50, "Output",
 CellID->169804930]
}, Open  ]],
Cell[CellGroupData[{
Cell[19350, 607, 313, 10, 70, "Input",
 CellID->160525684],
Cell[19666, 619, 250, 10, 50, "Output",
 CellID->248658210]
}, Open  ]],
Cell[19931, 632, 125, 3, 70, "ExampleDelimiter",
 CellID->239967297],
Cell[20059, 637, 130, 4, 70, "ExampleText",
 CellID->295431151],
Cell[CellGroupData[{
Cell[20214, 645, 423, 12, 70, "Input",
 CellID->228118131],
Cell[20640, 659, 276, 10, 66, "Output",
 CellID->97437491]
}, Open  ]],
Cell[20931, 672, 235, 8, 70, "ExampleText",
 CellID->705283069],
Cell[CellGroupData[{
Cell[21191, 684, 546, 15, 70, "Input",
 CellID->125942992],
Cell[21740, 701, 330, 12, 68, "Output",
 CellID->178007152]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22131, 720, 311, 9, 70, "SeeAlsoSection",
 CellID->17179],
Cell[22445, 731, 1194, 44, 70, "SeeAlso",
 CellID->13363],
Cell[23642, 777, 47, 1, 70, "Input",
 CellID->81107463]
}, Open  ]],
Cell[CellGroupData[{
Cell[23726, 783, 314, 9, 70, "TutorialsSection",
 CellID->29356],
Cell[24043, 794, 179, 4, 70, "Tutorials",
 CellID->17007],
Cell[24225, 800, 146, 3, 70, "Tutorials",
 CellID->175077611]
}, Open  ]],
Cell[CellGroupData[{
Cell[24408, 808, 299, 8, 70, "MoreAboutSection"],
Cell[24710, 818, 164, 3, 70, "MoreAbout",
 CellID->27232384]
}, Open  ]],
Cell[24889, 824, 50, 0, 70, "History"],
Cell[24942, 826, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

