(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16899,        606]
NotebookOptionsPosition[     13191,        481]
NotebookOutlinePosition[     14425,        517]
CellTagsIndexPosition[     14340,        512]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators without Built\[Hyphen]in Meanings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OperatorsWithoutBuiltInMeanings"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators without Built\[Hyphen]in Meanings\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SuperPlus" :> Documentation`HelpLookup["paclet:ref/SuperPlus"],
           "Subscript" :> Documentation`HelpLookup["paclet:ref/Subscript"], 
          "SubMinus" :> Documentation`HelpLookup["paclet:ref/SubMinus"], 
          "SubStar" :> Documentation`HelpLookup["paclet:ref/SubStar"], 
          "Style" :> Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SuperPlus\"\>", 
       2->"\<\"Subscript\"\>", 3->"\<\"SubMinus\"\>", 4->"\<\"SubStar\"\>", 
       5->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Notational Forms" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicNotationalForms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Symbolic Notational Forms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SubPlus", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SubPlus",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SubPlus"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]displays as ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], "+"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SubPlus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubPlus"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " can be entered using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["_", "KeyEvent"],
 " and ",
 StyleBox["+", "KeyEvent"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SubPlus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubPlus"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " remains unchanged by evaluation."
}], "Notes",
 CellID->10989299]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->326575485],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->215601616],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SubPlus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubPlus"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is formatted as ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " with a plus sign subscript: "
}], "ExampleText",
 CellID->35713986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SubPlus", "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->446268635],

Cell[BoxData[
 SubscriptBox["x", "+"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->133874398]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->207778682],

Cell[TextData[{
 "Define a meaning for ",
 Cell[BoxData[
  ButtonBox["SubPlus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SubPlus"]], "InlineFormula"],
 " in a particular case:"
}], "ExampleText",
 CellID->738140116],

Cell[BoxData[
 RowBox[{"SubPlus", "/:", 
  RowBox[{"Power", "[", 
   RowBox[{
    RowBox[{"SubPlus", "[", "0", "]"}], ",", 
    RowBox[{"-", "1"}]}], "]"}], ":=", "Infinity"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->127412283],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  SubscriptBox["0", "+"]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->145368],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10257052]
}, Open  ]],

Cell["Clear definitions: ", "ExampleText",
 CellID->645124259],

Cell[BoxData[
 RowBox[{"Clear", "[", "SubPlus", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->116023783]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["\<\
Define a limit function that takes limit direction as part of the limit \
point: \
\>", "ExampleText",
 CellID->267936426],

Cell[BoxData[
 RowBox[{
  RowBox[{"myLimit", "[", 
   RowBox[{"e_", ",", 
    RowBox[{"x_", "\[Rule]", 
     RowBox[{"SubMinus", "[", "a_", "]"}]}]}], "]"}], ":=", 
  RowBox[{"Limit", "[", 
   RowBox[{"e", ",", 
    RowBox[{"x", "\[Rule]", "a"}], ",", 
    RowBox[{"Direction", "\[Rule]", 
     RowBox[{"+", "1"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9464681],

Cell[BoxData[
 RowBox[{
  RowBox[{"myLimit", "[", 
   RowBox[{"e_", ",", 
    RowBox[{"x_", "\[Rule]", 
     RowBox[{"SubPlus", "[", "a_", "]"}]}]}], "]"}], ":=", 
  RowBox[{"Limit", "[", 
   RowBox[{"e", ",", 
    RowBox[{"x", "\[Rule]", "a"}], ",", 
    RowBox[{"Direction", "\[Rule]", 
     RowBox[{"-", "1"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74690715],

Cell["Use it to compute directional limits: ", "ExampleText",
 CellID->44512431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myLimit", "[", 
  RowBox[{
   RowBox[{"UnitStep", "[", "x", "]"}], ",", 
   RowBox[{"x", "\[Rule]", 
    SubscriptBox["0", "-"]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->459124013],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->317374360]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"myLimit", "[", 
  RowBox[{
   RowBox[{"UnitStep", "[", "x", "]"}], ",", 
   RowBox[{"x", "\[Rule]", 
    SubscriptBox["0", "+"]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->17977416],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->324195413]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SuperPlus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SuperPlus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subscript"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SubMinus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubMinus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SubStar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubStar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Operators without Built\[Hyphen]in Meanings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperatorsWithoutBuiltInMeanings"]], "Tutorials",\

 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Symbolic Notational Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicNotationalForms"]], "MoreAbout",
 CellID->157975648]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SubPlus - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 2.6111454}", "context" -> "System`", 
    "keywords" -> {
     "directed zero", "directed limit", "subscript plus", "subscript +"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SubPlus[expr] displays as expr_+.", "synonyms" -> {"sub plus"}, "title" -> 
    "SubPlus", "type" -> "Symbol", "uri" -> "ref/SubPlus"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6170, 191, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->326575485]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14197, 505}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2211, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2834, 80, 1572, 37, 70, "ObjectNameGrid"],
Cell[4409, 119, 565, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5011, 143, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5489, 160, 386, 15, 70, "Notes",
 CellID->1067943069],
Cell[5878, 177, 255, 9, 70, "Notes",
 CellID->10989299]
}, Closed]],
Cell[CellGroupData[{
Cell[6170, 191, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->326575485],
Cell[CellGroupData[{
Cell[6555, 205, 148, 5, 70, "ExampleSection",
 CellID->215601616],
Cell[6706, 212, 339, 12, 70, "ExampleText",
 CellID->35713986],
Cell[CellGroupData[{
Cell[7070, 228, 103, 3, 28, "Input",
 CellID->446268635],
Cell[7176, 233, 179, 6, 36, "Output",
 CellID->133874398]
}, Open  ]],
Cell[7370, 242, 125, 3, 70, "ExampleDelimiter",
 CellID->207778682],
Cell[7498, 247, 223, 8, 70, "ExampleText",
 CellID->738140116],
Cell[7724, 257, 229, 7, 70, "Input",
 CellID->127412283],
Cell[CellGroupData[{
Cell[7978, 268, 111, 4, 70, "Input",
 CellID->145368],
Cell[8092, 274, 167, 5, 36, "Output",
 CellID->10257052]
}, Open  ]],
Cell[8274, 282, 62, 1, 70, "ExampleText",
 CellID->645124259],
Cell[8339, 285, 107, 3, 70, "Input",
 CellID->116023783]
}, Open  ]],
Cell[CellGroupData[{
Cell[8483, 293, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[8713, 302, 132, 4, 70, "ExampleText",
 CellID->267936426],
Cell[8848, 308, 378, 12, 70, "Input",
 CellID->9464681],
Cell[9229, 322, 378, 12, 70, "Input",
 CellID->74690715],
Cell[9610, 336, 80, 1, 70, "ExampleText",
 CellID->44512431],
Cell[CellGroupData[{
Cell[9715, 341, 216, 7, 70, "Input",
 CellID->459124013],
Cell[9934, 350, 158, 5, 36, "Output",
 CellID->317374360]
}, Open  ]],
Cell[CellGroupData[{
Cell[10129, 360, 215, 7, 70, "Input",
 CellID->17977416],
Cell[10347, 369, 158, 5, 36, "Output",
 CellID->324195413]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10566, 381, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[10885, 392, 1186, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[12108, 441, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[12429, 452, 191, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[12657, 461, 299, 8, 70, "MoreAboutSection"],
Cell[12959, 471, 160, 3, 70, "MoreAbout",
 CellID->157975648]
}, Open  ]],
Cell[13134, 477, 27, 0, 70, "History"],
Cell[13164, 479, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

