(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31185,       1165]
NotebookOptionsPosition[     24210,        917]
NotebookOutlinePosition[     25573,        955]
CellTagsIndexPosition[     25488,        950]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Factorial" :> Documentation`HelpLookup["paclet:ref/Factorial"],
           "Permutations" :> 
          Documentation`HelpLookup["paclet:ref/Permutations"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Factorial\"\>", 
       2->"\<\"Permutations\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup["paclet:guide/CombinatorialFunctions"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Combinatorial Functions\"\>", 
       2->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Subfactorial", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Subfactorial",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Subfactorial"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the number of permutations of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " objects that leave no object fixed."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26394]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For non-integer ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ", the numerical value of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subfactorial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subfactorial"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Gamma",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Gamma"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["n", "TI"], "+", "1"}], ",", 
     RowBox[{"-", "1"}]}], "]"}], "/", 
   ButtonBox["E",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/E"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->382789122],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Subfactorial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subfactorial"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell["\<\
A permutation in which no object appears in its natural place is called a \
derangement.\
\>", "Notes",
 CellID->31008],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Subfactorial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subfactorial"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->269388166],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subfactorial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subfactorial"], "[", "0", "]"}]], 
  "InlineFormula"],
 " gives 1."
}], "Notes",
 CellID->17227]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->369084665],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->367952890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Subfactorial", "[", "n", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->175713479],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "2", ",", "9", ",", "44", ",", "265", ",", "1854", ",", 
   "14833", ",", "133496", ",", "1334961"}], "}"}]], "Output",
 ImageSize->{345, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->512090151]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16977],

Cell["Evaluate for large numbers:", "ExampleText",
 CellID->92404886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Subfactorial", "[", "10000", "]"}], "//", "Short"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87542526],

Cell[BoxData[
 TagBox[
  RowBox[{"104708042084457375134196975503280657", 
   RowBox[{"\[LeftSkeleton]", "35588", "\[RightSkeleton]"}], 
   "200007493660885883881039539696860001"}],
  Short]], "Output",
 ImageSize->{355, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->142276942]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1023748683],

Cell[BoxData["1.04708042084457375134196976`15.954589770191005*^35659"], \
"Output",
 ImageSize->{176, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->202487740]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->450454785],

Cell["Evaluate numerically for non-integer arguments:", "ExampleText",
 CellID->633103008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"Subfactorial", "[", 
   RowBox[{"1", "/", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122670508],

Cell[BoxData[
 RowBox[{"0.3260246660866462`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.4619204930872316`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40149800]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56430517],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->279582254],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subfactorial", "[", 
  RowBox[{"1.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8863226],

Cell[BoxData[
 RowBox[{"0.2811496622267996`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.2483722972785482`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->61277091]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->150561756],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->437852044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Subfactorial", "[", 
    RowBox[{"1", "/", "2"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70484575],

Cell[BoxData[
 RowBox[{"0.\
3260246660866460915295793066235336245925203488097141079039341684155`49.\
91141952599333", "+", 
  RowBox[{
  "0.4619204930872315808636125795924432452080249982460666823707757215356`50.\
06273629734763", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{386, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126313973]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->140263746],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->380016766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subfactorial", "[", "0.50000000000000000000000000000000000", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->289473750],

Cell[BoxData[
 RowBox[{"0.326024666086646091529579306623533624591499277592`34.\
18478190583155", "+", 
  RowBox[{
  "0.46192049308723158086361257959244324520604672998`34.632023214705406", " ",
    "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{532, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116678191]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->58366163],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Subfactorial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subfactorial"]], "InlineFormula"],
 " automatically threads over lists:"
}], "ExampleText",
 CellID->13697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subfactorial", "[", 
  RowBox[{"{", 
   RowBox[{"5", ",", "10", ",", "20"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15370],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"44", ",", "1334961", ",", "895014631192902121"}], "}"}]], "Output",\

 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->394700933]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->617],

Cell["There are 9 derangements of a set of 4 objects:", "ExampleText",
 CellID->18724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subfactorial", "[", "4", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->979],

Cell[BoxData["9"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6190768]
}, Open  ]],

Cell[TextData[{
 "Here are all permutations of the set ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Permutations", "[", 
  RowBox[{"Range", "[", "4", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3171],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "2", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{528, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->144628215]
}, Open  ]],

Cell["Delete all permutations where an object is fixed:", "ExampleText",
 CellID->5844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DeleteCases", "[", 
  RowBox[{
   RowBox[{"Permutations", "[", 
    RowBox[{"Range", "[", "4", "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "__"}], "}"}], "|", 
    RowBox[{"{", 
     RowBox[{"_", ",", "2", ",", "__"}], "}"}], "|", 
    RowBox[{"{", 
     RowBox[{"__", ",", "3", ",", "_"}], "}"}], "|", 
    RowBox[{"{", 
     RowBox[{"__", ",", "4"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17267],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "4", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "2", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{441, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->146978347]
}, Open  ]],

Cell["Check that there are only 9 derangements:", "ExampleText",
 CellID->2410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->11872],

Cell[BoxData["9"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->111311109]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24968],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subfactorial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subfactorial"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n", "TI"], "!", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{
       StyleBox["k", "TI"], "=", "0"}], 
      StyleBox["n", "TI"],
      LimitsPositioning->True], 
     FractionBox[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       StyleBox["k", "TI"]], 
      RowBox[{"k", "!"}]]}]}], TraditionalForm]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->25065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"n", "!"}], 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "0"}], "n"], 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "k"], 
     RowBox[{"k", "!"}]]}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27321],

Cell[BoxData[
 FractionBox[
  RowBox[{"Gamma", "[", 
   RowBox[{
    RowBox[{"1", "+", "n"}], ",", 
    RowBox[{"-", "1"}]}], "]"}], "\[ExponentialE]"]], "Output",
 ImageSize->{110, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94419000]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "/.", 
   RowBox[{"n", "->", 
    RowBox[{"Range", "[", "10", "]"}]}]}], "//", "FullSimplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26914],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "2", ",", "9", ",", "44", ",", "265", ",", "1854", ",", 
   "14833", ",", "133496", ",", "1334961"}], "}"}]], "Output",
 ImageSize->{345, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27523317]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subfactorial", "[", 
  RowBox[{"Range", "[", "10", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2137],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "2", ",", "9", ",", "44", ",", "265", ",", "1854", ",", 
   "14833", ",", "133496", ",", "1334961"}], "}"}]], "Output",
 ImageSize->{345, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->443906240]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26549],

Cell[TextData[{
 "Recurrence relations satisfied by ",
 Cell[BoxData[
  ButtonBox["Subfactorial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subfactorial"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Subfactorial", "[", "n", "]"}], "==", 
   RowBox[{
    RowBox[{"n", " ", 
     RowBox[{"Subfactorial", "[", 
      RowBox[{"n", "-", "1"}], "]"}]}], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "n"]}]}], "/.", 
  RowBox[{"n", "->", 
   RowBox[{"Range", "[", "10", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12882],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46919849]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Subfactorial", "[", 
    RowBox[{"n", "+", "1"}], "]"}], "==", 
   RowBox[{"n", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Subfactorial", "[", "n", "]"}], "+", 
      RowBox[{"Subfactorial", "[", 
       RowBox[{"n", "-", "1"}], "]"}]}], ")"}]}]}], "/.", 
  RowBox[{"n", "->", 
   RowBox[{"Range", "[", "10", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28592],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->135158417]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17520],

Cell["\<\
The only number equal to the sum of subfactorials of its digits:\
\>", "ExampleText",
 CellID->17728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"148349", "==", 
  RowBox[{"Total", "[", 
   RowBox[{"Subfactorial", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "8", ",", "3", ",", "4", ",", "9"}], "}"}], 
    "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29688],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->199156964]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20050],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Factorial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factorial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Permutations",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Permutations"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14642]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->320497097],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombinatorialFunctions"]], "MoreAbout",
 CellID->381434012],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->18453951]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Subfactorial - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 24, 58.3610366}", "context" -> "System`", 
    "keywords" -> {
     "derangement", "rencontres number", "restricted rooks problem", 
      "combinatorial function", "permutation", "permutation cycle"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Subfactorial[n] gives the number of permutations of n objects that leave \
no object fixed.", "synonyms" -> {}, "title" -> "Subfactorial", "type" -> 
    "Symbol", "uri" -> "ref/Subfactorial"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6475, 215, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->369084665]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25345, 943}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1508, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2131, 63, 1577, 37, 70, "ObjectNameGrid"],
Cell[3711, 102, 597, 18, 70, "Usage",
 CellID->26394]
}, Open  ]],
Cell[CellGroupData[{
Cell[4345, 125, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4823, 142, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4946, 148, 694, 27, 70, "Notes",
 CellID->382789122],
Cell[5643, 177, 226, 7, 70, "Notes",
 CellID->31226],
Cell[5872, 186, 129, 4, 70, "Notes",
 CellID->31008],
Cell[6004, 192, 213, 7, 70, "Notes",
 CellID->269388166],
Cell[6220, 201, 218, 9, 70, "Notes",
 CellID->17227]
}, Closed]],
Cell[CellGroupData[{
Cell[6475, 215, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->369084665],
Cell[CellGroupData[{
Cell[6860, 229, 148, 5, 70, "ExampleSection",
 CellID->367952890],
Cell[CellGroupData[{
Cell[7033, 238, 214, 7, 28, "Input",
 CellID->175713479],
Cell[7250, 247, 312, 9, 36, "Output",
 CellID->512090151]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7611, 262, 216, 7, 70, "ExampleSection",
 CellID->16977],
Cell[7830, 271, 69, 1, 70, "ExampleText",
 CellID->92404886],
Cell[CellGroupData[{
Cell[7924, 276, 139, 4, 70, "Input",
 CellID->87542526],
Cell[8066, 282, 339, 10, 54, "Output",
 CellID->142276942]
}, Open  ]],
Cell[CellGroupData[{
Cell[8442, 297, 98, 3, 70, "Input",
 CellID->1023748683],
Cell[8543, 302, 214, 6, 36, "Output",
 CellID->202487740]
}, Open  ]],
Cell[8772, 311, 125, 3, 70, "ExampleDelimiter",
 CellID->450454785],
Cell[8900, 316, 90, 1, 70, "ExampleText",
 CellID->633103008],
Cell[CellGroupData[{
Cell[9015, 321, 160, 5, 70, "Input",
 CellID->122670508],
Cell[9178, 328, 272, 7, 36, "Output",
 CellID->40149800]
}, Open  ]],
Cell[9465, 338, 124, 3, 70, "ExampleDelimiter",
 CellID->56430517],
Cell[9592, 343, 74, 1, 70, "ExampleText",
 CellID->279582254],
Cell[CellGroupData[{
Cell[9691, 348, 131, 4, 70, "Input",
 CellID->8863226],
Cell[9825, 354, 272, 7, 36, "Output",
 CellID->61277091]
}, Open  ]],
Cell[10112, 364, 125, 3, 70, "ExampleDelimiter",
 CellID->150561756],
Cell[10240, 369, 70, 1, 70, "ExampleText",
 CellID->437852044],
Cell[CellGroupData[{
Cell[10335, 374, 185, 6, 70, "Input",
 CellID->70484575],
Cell[10523, 382, 397, 11, 54, "Output",
 CellID->126313973]
}, Open  ]],
Cell[10935, 396, 125, 3, 70, "ExampleDelimiter",
 CellID->140263746],
Cell[11063, 401, 113, 3, 70, "ExampleText",
 CellID->380016766],
Cell[CellGroupData[{
Cell[11201, 408, 147, 4, 70, "Input",
 CellID->289473750],
Cell[11351, 414, 359, 10, 36, "Output",
 CellID->116678191]
}, Open  ]],
Cell[11725, 427, 124, 3, 70, "ExampleDelimiter",
 CellID->58366163],
Cell[11852, 432, 215, 7, 70, "ExampleText",
 CellID->13697],
Cell[CellGroupData[{
Cell[12092, 443, 163, 5, 70, "Input",
 CellID->15370],
Cell[12258, 450, 240, 8, 36, "Output",
 CellID->394700933]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12547, 464, 221, 7, 70, "ExampleSection",
 CellID->617],
Cell[12771, 473, 86, 1, 70, "ExampleText",
 CellID->18724],
Cell[CellGroupData[{
Cell[12882, 478, 102, 3, 70, "Input",
 CellID->979],
Cell[12987, 483, 156, 5, 36, "Output",
 CellID->6190768]
}, Open  ]],
Cell[13158, 491, 202, 7, 70, "ExampleText",
 CellID->14754],
Cell[CellGroupData[{
Cell[13385, 502, 135, 4, 70, "Input",
 CellID->3171],
Cell[13523, 508, 2080, 55, 88, "Output",
 CellID->144628215]
}, Open  ]],
Cell[15618, 566, 87, 1, 70, "ExampleText",
 CellID->5844],
Cell[CellGroupData[{
Cell[15730, 571, 472, 15, 70, "Input",
 CellID->17267],
Cell[16205, 588, 895, 25, 54, "Output",
 CellID->146978347]
}, Open  ]],
Cell[17115, 616, 79, 1, 70, "ExampleText",
 CellID->2410],
Cell[CellGroupData[{
Cell[17219, 621, 98, 3, 70, "Input",
 CellID->11872],
Cell[17320, 626, 158, 5, 36, "Output",
 CellID->111311109]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17527, 637, 233, 7, 70, "ExampleSection",
 CellID->24968],
Cell[17763, 646, 679, 26, 70, "ExampleText",
 CellID->25065],
Cell[CellGroupData[{
Cell[18467, 676, 343, 13, 70, "Input",
 CellID->27321],
Cell[18813, 691, 293, 10, 51, "Output",
 CellID->94419000]
}, Open  ]],
Cell[19121, 704, 45, 1, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[19191, 709, 184, 6, 70, "Input",
 CellID->26914],
Cell[19378, 717, 311, 9, 36, "Output",
 CellID->27523317]
}, Open  ]],
Cell[CellGroupData[{
Cell[19726, 731, 136, 4, 70, "Input",
 CellID->2137],
Cell[19865, 737, 312, 9, 36, "Output",
 CellID->443906240]
}, Open  ]],
Cell[20192, 749, 121, 3, 70, "ExampleDelimiter",
 CellID->26549],
Cell[20316, 754, 220, 8, 70, "ExampleText",
 CellID->1162],
Cell[CellGroupData[{
Cell[20561, 766, 403, 14, 70, "Input",
 CellID->12882],
Cell[20967, 782, 160, 5, 36, "Output",
 CellID->46919849]
}, Open  ]],
Cell[CellGroupData[{
Cell[21164, 792, 420, 14, 70, "Input",
 CellID->28592],
Cell[21587, 808, 161, 5, 36, "Output",
 CellID->135158417]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21797, 819, 224, 7, 70, "ExampleSection",
 CellID->17520],
Cell[22024, 828, 111, 3, 70, "ExampleText",
 CellID->17728],
Cell[CellGroupData[{
Cell[22160, 835, 262, 8, 70, "Input",
 CellID->29688],
Cell[22425, 845, 161, 5, 36, "Output",
 CellID->199156964]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22647, 857, 311, 9, 70, "SeeAlsoSection",
 CellID->20050],
Cell[22961, 868, 461, 17, 70, "SeeAlso",
 CellID->14642]
}, Open  ]],
Cell[CellGroupData[{
Cell[23459, 890, 319, 9, 70, "MoreAboutSection",
 CellID->320497097],
Cell[23781, 901, 157, 3, 70, "MoreAbout",
 CellID->381434012],
Cell[23941, 906, 197, 4, 70, "MoreAbout",
 CellID->18453951]
}, Open  ]],
Cell[24153, 913, 27, 0, 70, "History"],
Cell[24183, 915, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

