(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54422,       1718]
NotebookOptionsPosition[     47802,       1487]
NotebookOutlinePosition[     49223,       1526]
CellTagsIndexPosition[     49137,       1521]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicOperationsOnPolynomials"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Operations on Polynomials\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Resultant" :> Documentation`HelpLookup["paclet:ref/Resultant"],
           "PolynomialGCD" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialGCD"], "Eliminate" :> 
          Documentation`HelpLookup["paclet:ref/Eliminate"], "Minors" :> 
          Documentation`HelpLookup["paclet:ref/Minors"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Resultant\"\>", 2->"\<\"PolynomialGCD\"\>", 
       3->"\<\"Eliminate\"\>", 4->"\<\"Minors\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Polynomial Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Subresultants", "ObjectName",
 CellID->24917],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Subresultants",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Subresultants"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["var", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a list of the principal subresultant \
coefficients of the polynomials ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " with respect to the variable ",
     Cell[BoxData[
      StyleBox["var", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2971]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The first ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " subresultants of two polynomials ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ", both with leading coefficient one, are zero when ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " have ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " common roots. "
}], "Notes",
 CellID->1007],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Subresultants",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subresultants"]], "InlineFormula"],
 " returns a list whose length is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Min",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Min"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Exponent",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Exponent"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["var", "TI"]}], "]"}], ",", 
    RowBox[{
     ButtonBox["Exponent",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Exponent"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["var", "TI"]}], "]"}]}], "]"}]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   RowBox[{"+", "1"}], TraditionalForm]], "InlineMath"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->13540,
  ButtonNote->"13540"]
}], "Notes",
 CellID->17840]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->270631523],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->472070102],

Cell["\<\
The first three PSC's are zero when there are three common roots, \
multiplicities counted:\
\>", "ExampleText",
 CellID->13725609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subresultants", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], "^", "2"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "3"}], ")"}], "^", "3"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], "^", "2"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "4"}], ")"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "5"}], ")"}], "^", "2"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->360375124],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0", ",", 
   RowBox[{"-", "64"}], ",", "44", ",", 
   RowBox[{"-", "5"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->248571512]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120361569],

Cell["\<\
Principal subresultant coefficients (PSC's) of two cubic polynomials:\
\>", "ExampleText",
 CellID->206260048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"psc", "=", 
  RowBox[{"Subresultants", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "a"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "b"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "c"}], ")"}]}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "3"}], ")"}]}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31060],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 156},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68804959]
}, Open  ]],

Cell["\<\
When the polynomials have a pair of equal roots, the first PSC disappears:\
\>", "ExampleText",
 CellID->104197699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"psc", "/.", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", "1"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->779951316],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", 
   RowBox[{"36", "-", 
    RowBox[{"30", " ", "b"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["b", "2"]}], "-", 
    RowBox[{"30", " ", "c"}], "+", 
    RowBox[{"25", " ", "b", " ", "c"}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["b", "2"], " ", "c"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"5", " ", "b", " ", 
     SuperscriptBox["c", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["c", "2"]}]}], ",", 
   RowBox[{
    RowBox[{"-", "5"}], "+", "b", "+", "c"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{455, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->242180366]
}, Open  ]],

Cell["\<\
When two pairs of roots are equal, the first two PSC's disappear:\
\>", "ExampleText",
 CellID->249796175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"psc", "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "1"}], ",", 
    RowBox[{"b", "\[Rule]", "2"}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->50066093],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", 
   RowBox[{
    RowBox[{"-", "3"}], "+", "c"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{107, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->7146558]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21114],

Cell["\<\
Principal subresultant coefficients of univariate polynomials are numbers:\
\>", "ExampleText",
 CellID->953867484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subresultants", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", 
     RowBox[{"x", "^", "7"}]}], "+", 
    RowBox[{"3", 
     RowBox[{"x", "^", "3"}]}], "-", 
    RowBox[{"7", "x"}], "+", "1"}], ",", 
   RowBox[{
    RowBox[{"3", 
     RowBox[{"x", "^", "5"}]}], "-", 
    RowBox[{"17", "x"}], "+", "21"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->761861355],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "273612691817", ",", "68946901", ",", "1299537", ",", "16641", ",", "0", 
   ",", "9"}], "}"}]], "Output",
 ImageSize->{329, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->193601287]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28721149],

Cell["\<\
Principal subresultant coefficients are polynomials in the coefficients of \
input polynomials: \
\>", "ExampleText",
 CellID->768178768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subresultants", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"c", " ", "x"}], "+", "d"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "3"}], "-", 
    RowBox[{"5", "b", " ", "x"}], "-", 
    RowBox[{"7", "a"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7103],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "343"}], " ", 
     SuperscriptBox["a", "6"]}], "+", 
    RowBox[{"245", " ", 
     SuperscriptBox["a", "4"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    RowBox[{"49", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"]}], "+", 
    RowBox[{"147", " ", 
     SuperscriptBox["a", "3"], " ", "b", " ", "c"}], "-", 
    RowBox[{"175", " ", 
     SuperscriptBox["a", "3"], " ", 
     SuperscriptBox["b", "2"], " ", "c"}], "+", 
    RowBox[{"35", " ", "a", " ", 
     SuperscriptBox["b", "3"], " ", "c"}], "-", 
    RowBox[{"70", " ", 
     SuperscriptBox["a", "2"], " ", "b", " ", 
     SuperscriptBox["c", "2"]}], "-", 
    RowBox[{"7", " ", "a", " ", 
     SuperscriptBox["c", "3"]}], "-", 
    RowBox[{"147", " ", 
     SuperscriptBox["a", "4"], " ", "d"}], "-", 
    RowBox[{"35", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"], " ", "d"}], "+", 
    RowBox[{"125", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "3"], " ", "d"}], "-", 
    RowBox[{"25", " ", 
     SuperscriptBox["b", "4"], " ", "d"}], "+", 
    RowBox[{"21", " ", "a", " ", "b", " ", "c", " ", "d"}], "+", 
    RowBox[{"50", " ", "a", " ", 
     SuperscriptBox["b", "2"], " ", "c", " ", "d"}], "+", 
    RowBox[{"5", " ", "b", " ", 
     SuperscriptBox["c", "2"], " ", "d"}], "-", 
    RowBox[{"21", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["d", "2"]}], "-", 
    RowBox[{"10", " ", 
     SuperscriptBox["b", "2"], " ", 
     SuperscriptBox["d", "2"]}], "-", 
    SuperscriptBox["d", "3"]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "7"}], " ", 
     SuperscriptBox["a", "2"], " ", "b"}], "+", 
    RowBox[{"25", " ", 
     SuperscriptBox["a", "2"], " ", 
     SuperscriptBox["b", "2"]}], "-", 
    RowBox[{"5", " ", 
     SuperscriptBox["b", "3"]}], "+", 
    RowBox[{"10", " ", "a", " ", "b", " ", "c"}], "+", 
    SuperscriptBox["c", "2"], "-", 
    RowBox[{"b", " ", "d"}]}], ",", 
   RowBox[{"-", "b"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{565, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124695132]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16220],

Cell["\<\
Find conditions for two polynomials to have exactly two common roots:\
\>", "ExampleText",
 CellID->61136078],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "5"}]}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "-", "b", "+", "1"}], ")"}], 
     RowBox[{"x", "^", "3"}]}], "-", 
    RowBox[{"b", " ", "x"}], "+", "a"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{
    RowBox[{"2", 
     RowBox[{"x", "^", "4"}]}], "-", 
    RowBox[{"3", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"5", 
     RowBox[{"x", "^", "2"}]}], "-", 
    RowBox[{"7", "x"}], "+", "1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"psc", "=", 
   RowBox[{"Subresultants", "[", 
    RowBox[{"f", ",", "g", ",", "x"}], "]"}]}], ";"}], "\n", 
 RowBox[{"cond", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"psc", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{"psc", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{"psc", "[", 
       RowBox[{"[", "3", "]"}], "]"}], "\[NotEqual]", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->362571328],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"a", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"16", "-", 
         RowBox[{"1520", " ", "#1"}], "+", 
         RowBox[{"28984", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"240249", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"1009357", " ", 
          SuperscriptBox["#1", "4"]}], "-", 
         RowBox[{"2116463", " ", 
          SuperscriptBox["#1", "5"]}], "+", 
         RowBox[{"1763273", " ", 
          SuperscriptBox["#1", "6"]}]}], "&"}], ",", "1"}], "]"}]}], "||", 
    RowBox[{"a", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"16", "-", 
         RowBox[{"1520", " ", "#1"}], "+", 
         RowBox[{"28984", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"240249", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"1009357", " ", 
          SuperscriptBox["#1", "4"]}], "-", 
         RowBox[{"2116463", " ", 
          SuperscriptBox["#1", "5"]}], "+", 
         RowBox[{"1763273", " ", 
          SuperscriptBox["#1", "6"]}]}], "&"}], ",", "2"}], "]"}]}], "||", 
    RowBox[{"a", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"16", "-", 
         RowBox[{"1520", " ", "#1"}], "+", 
         RowBox[{"28984", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"240249", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"1009357", " ", 
          SuperscriptBox["#1", "4"]}], "-", 
         RowBox[{"2116463", " ", 
          SuperscriptBox["#1", "5"]}], "+", 
         RowBox[{"1763273", " ", 
          SuperscriptBox["#1", "6"]}]}], "&"}], ",", "3"}], "]"}]}], "||", 
    RowBox[{"a", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"16", "-", 
         RowBox[{"1520", " ", "#1"}], "+", 
         RowBox[{"28984", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"240249", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"1009357", " ", 
          SuperscriptBox["#1", "4"]}], "-", 
         RowBox[{"2116463", " ", 
          SuperscriptBox["#1", "5"]}], "+", 
         RowBox[{"1763273", " ", 
          SuperscriptBox["#1", "6"]}]}], "&"}], ",", "4"}], "]"}]}], "||", 
    RowBox[{"a", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"16", "-", 
         RowBox[{"1520", " ", "#1"}], "+", 
         RowBox[{"28984", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"240249", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"1009357", " ", 
          SuperscriptBox["#1", "4"]}], "-", 
         RowBox[{"2116463", " ", 
          SuperscriptBox["#1", "5"]}], "+", 
         RowBox[{"1763273", " ", 
          SuperscriptBox["#1", "6"]}]}], "&"}], ",", "5"}], "]"}]}], "||", 
    RowBox[{"a", "\[Equal]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"16", "-", 
         RowBox[{"1520", " ", "#1"}], "+", 
         RowBox[{"28984", " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"240249", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"1009357", " ", 
          SuperscriptBox["#1", "4"]}], "-", 
         RowBox[{"2116463", " ", 
          SuperscriptBox["#1", "5"]}], "+", 
         RowBox[{"1763273", " ", 
          SuperscriptBox["#1", "6"]}]}], "&"}], ",", "6"}], "]"}]}]}], ")"}], 
  "&&", 
  RowBox[{"b", "\[Equal]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "614205226104834689520600737161940"}], "+", 
      RowBox[{"112836361080576186025470827531501977", " ", "a"}], "-", 
      RowBox[{"7040832573966300194538428366236355680", " ", 
       SuperscriptBox["a", "2"]}], "+", 
      RowBox[{"183963222067372551874000495068585331392", " ", 
       SuperscriptBox["a", "3"]}], "-", 
      RowBox[{"2635483567632102619407868269341010853800", " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"23439261049651015200586996519356654547078", " ", 
       SuperscriptBox["a", "5"]}], "-", 
      RowBox[{"137204489494187011424493928260059746182191", " ", 
       SuperscriptBox["a", "6"]}], "+", 
      RowBox[{"540243581011571504439429473784054372886523", " ", 
       SuperscriptBox["a", "7"]}], "-", 
      RowBox[{"1421367643747605644224721411682892394756706", " ", 
       SuperscriptBox["a", "8"]}], "+", 
      RowBox[{"2401168859365892324063863062907211909400599", " ", 
       SuperscriptBox["a", "9"]}], "-", 
      RowBox[{"2358814390170832394932123574639969887340943", " ", 
       SuperscriptBox["a", "10"]}], "+", 
      RowBox[{"1025439026145122437589832335941503703783315", " ", 
       SuperscriptBox["a", "11"]}]}], ")"}], "/", 
    "1106211366184479254574215673852"}]}]}]], "Output",
 ImageSize->{580, 378},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->488726025]
}, Open  ]],

Cell[TextData[{
 "Check that for the first solution ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " have indeed exactly two common roots:"
}], "ExampleText",
 CellID->385995121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"f", "//.", 
      RowBox[{"First", "[", 
       RowBox[{"{", 
        RowBox[{"ToRules", "[", "cond", "]"}], "}"}], "]"}]}], ")"}], 
    "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->103412743],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{566, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->69151448]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"g", "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->45946617],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1uEzEQdpPsJm1oGvpD0ghEilTaEzegEhJHuACXPkFUIbUHBCp9DW68
Cy/AiT6UWa/t1Pl2vF7vTxqljpRsxjsztr/xjL37fZ7dXH79Nru5uphNP17P
flxeXfycfvh+nTS1NxhrvWGMHY9Z8p8n/9Kv/pwlX8beJ7+tpPmfun5R11t1
3Z5rsfbcOtU25U8g34Lcb9DLH5CHIHdB7oD8zuHvceFRCLxQu0zvws8u2WtX
3W0ZWkKpDdrib0fdi9QVexY+okREvKJ0mHey9C40cS6x8hxbLQ6cGo+I3iM1
aruFmLucdKqQmX/XmLtPNDprh+82McPq+G5ZcJGrtJfxrWciQdKfdL6RWZOY
wr5oa9vemhNljIi4HxMRxHhEZG82630vbSoPilv3M4gL+5YVY9dM8X52tYSI
urSpzKsjorhSWpQl21TaBxk/NMI50UC8HPVTOOlRepnZUHV/E9rbTsutypYx
tGerKVr2DbTmv5m9HyPjyrL4XmKmkSdHt3Ix63Nj/6ohZgMu84/eyXQW6fNE
ttp1Go4Oril3VDCO/hiPvS2wJpF11ssDnn/L5lKIXL4F7lJYC/0jt0OiR+5v
xEmR3mO9TxBLjZP9nI6WT7hclW5NRNV/R0UPQ9W37zNRdgWEGMkWzB3/HZSK
0aIFnTf4HmDPirJ+MtVPaxHhE2Wsve4qgudvN3b+lapcbaPepfjuJfhWIKCd
h7aZq8y6gqckhpjnrrowIL3YnqmoNzGUnoizEO07mc1KzH/oZaVXzchq5bNS
nwVUF1CdGO32tficy0ydEF503/Q7M10ZRA53cjUo1Oj9SFvgSWzgbTHi5d6C
Pl1TPCaWvuk3+ucgn4D8Us1xCu3IYhT1c1RqVKcgHxsyI7y6Rufy98I6SoHs
OWifgHyq9KZ8kW0qanfETVbqtwNZnMtfT/1XaS9cfc4I6S3PZ8/251qmX1/e
a7dBL8tmzzAnqXpPj7JJdq3YqNaLGWqGeYs5feoNzFs9zFvXgm+xFSw7N7oO
PI5TuylmDt/uBU6uDL6rwcn1rH5K7DI8MHdFLeti7nYc6ATmrnrM6mbuMGak
38LZFniiZTN81P5QJudC5JbN8JHzruEsGnglGu96uL96z5ohVrKlfg6Q5IP8
9zUW+KpifFXV3AjsoA/ae9COXGyx1X1IYvxwea5Dx0wDb+iH59hq5b9Wha91
ZNNGlvaHyi6OOc22lmM87pt9pNmiVWMf70a5TPZRsnq/HMhWZR9fy943/gPX
2wxt\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{566, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->72029536]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->265041855],

Cell["\<\
Find conditions for a quartic to have exactly two distinct roots:\
\>", "ExampleText",
 CellID->20089093],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"x", "^", "4"}]}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"x", "^", "3"}]}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"d", " ", "x"}], "+", "e"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"psc", "=", 
   RowBox[{"Subresultants", "[", 
    RowBox[{"f", ",", 
     RowBox[{"D", "[", 
      RowBox[{"f", ",", "x"}], "]"}], ",", "x"}], "]"}]}], ";"}], "\n", 
 RowBox[{"cond", "=", 
  RowBox[{"Reduce", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"psc", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{"psc", "[", 
       RowBox[{"[", "2", "]"}], "]"}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{"psc", "[", 
       RowBox[{"[", "3", "]"}], "]"}], "\[NotEqual]", "0"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
   "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->170391737],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"d", "\[Equal]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["b", "3"]}], "+", 
       RowBox[{"4", " ", "a", " ", "b", " ", "c"}]}], 
      RowBox[{"8", " ", 
       SuperscriptBox["a", "2"]}]]}], "||", 
    RowBox[{"d", "\[Equal]", 
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "9"}], " ", 
        SuperscriptBox["b", "3"]}], "+", 
       RowBox[{"36", " ", "a", " ", "b", " ", "c"}], "-", 
       RowBox[{
        SqrtBox["3"], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"27", " ", 
           SuperscriptBox["b", "6"]}], "-", 
          RowBox[{"216", " ", "a", " ", 
           SuperscriptBox["b", "4"], " ", "c"}], "+", 
          RowBox[{"576", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"512", " ", 
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["c", "3"]}]}]]}]}], 
      RowBox[{"72", " ", 
       SuperscriptBox["a", "2"]}]]}], "||", 
    RowBox[{"d", "\[Equal]", 
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "9"}], " ", 
        SuperscriptBox["b", "3"]}], "+", 
       RowBox[{"36", " ", "a", " ", "b", " ", "c"}], "+", 
       RowBox[{
        SqrtBox["3"], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{"27", " ", 
           SuperscriptBox["b", "6"]}], "-", 
          RowBox[{"216", " ", "a", " ", 
           SuperscriptBox["b", "4"], " ", "c"}], "+", 
          RowBox[{"576", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox["c", "2"]}], "-", 
          RowBox[{"512", " ", 
           SuperscriptBox["a", "3"], " ", 
           SuperscriptBox["c", "3"]}]}]]}]}], 
      RowBox[{"72", " ", 
       SuperscriptBox["a", "2"]}]]}]}], ")"}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "3"}], " ", 
     SuperscriptBox["b", "2"]}], "+", 
    RowBox[{"8", " ", "a", " ", "c"}]}], "\[NotEqual]", "0"}], "&&", 
  RowBox[{"e", "\[Equal]", 
   FractionBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"]}], "-", 
     RowBox[{"4", " ", "a", " ", 
      SuperscriptBox["c", "3"]}], "-", 
     RowBox[{"3", " ", 
      SuperscriptBox["b", "3"], " ", "d"}], "+", 
     RowBox[{"14", " ", "a", " ", "b", " ", "c", " ", "d"}], "-", 
     RowBox[{"18", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["d", "2"]}]}], 
    RowBox[{
     RowBox[{"6", " ", "a", " ", 
      SuperscriptBox["b", "2"]}], "-", 
     RowBox[{"16", " ", 
      SuperscriptBox["a", "2"], " ", "c"}]}]]}]}]], "Output",
 ImageSize->{570, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->509436260]
}, Open  ]],

Cell[TextData[{
 "Check that for the first solution ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " has indeed exactly two distinct roots:"
}], "ExampleText",
 CellID->485652489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"f", "//.", 
      RowBox[{"First", "[", 
       RowBox[{"{", 
        RowBox[{"ToRules", "[", "cond", "]"}], "}"}], "]"}]}], ")"}], 
    "\[Equal]", "0"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->341217340],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "a"}], " ", "b"}], "-", 
       SqrtBox[
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["a", "3"], " ", "c"}]}]]}], 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}]]}], "||", 
    RowBox[{"x", "\[Equal]", 
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "a"}], " ", "b"}], "+", 
       SqrtBox[
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["a", "3"], " ", "c"}]}]]}], 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{421, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->154249633]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21819],

Cell["\<\
Multiplicity of roots counts in determining the number of zero subresultants:\
\
\>", "ExampleText",
 CellID->20840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subresultants", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "2"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "3"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "4"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "5"}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23989],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "12", ",", 
   RowBox[{"-", "4"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->203589179]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subresultants", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "^", "5"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "2"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "3"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "^", "4"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "4"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "5"}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26758],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "144", ",", "18", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->488428628]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5368],

Cell["The length is determined by the minimum polynomial degree:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->13540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"Subresultants", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "50"}], "+", "a"}], ",", 
    RowBox[{
     RowBox[{"x", "^", "20"}], "+", "b"}], ",", "x"}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->9609],

Cell[BoxData["21"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38284271]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27287040],

Cell[TextData[{
 "The first element of ",
 Cell[BoxData[
  ButtonBox["Subresultants",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subresultants"]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  ButtonBox["Resultant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resultant"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->152264916],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "=", " ", 
   RowBox[{
    RowBox[{"2", 
     RowBox[{"x", "^", "5"}]}], "+", 
    RowBox[{"3", 
     RowBox[{"x", "^", "3"}]}], "-", 
    RowBox[{"7", 
     RowBox[{"x", "^", "2"}]}], "+", 
    RowBox[{"11", "x"}], "+", "21"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "3"}], 
     RowBox[{"x", "^", "4"}]}], "+", 
    RowBox[{"27", 
     RowBox[{"x", "^", "3"}]}], "-", 
    RowBox[{"11", "x"}], "+", "9"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->523694028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subresultants", "[", 
  RowBox[{"f", ",", "g", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->290436583],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "68252080236"}], ",", "265691684", ",", "350853", ",", "1485",
    ",", 
   RowBox[{"-", "3"}]}], "}"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->536215671]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{"f", ",", "g", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->59658466],

Cell[BoxData[
 RowBox[{"-", "68252080236"}]], "Output",
 ImageSize->{96, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->42067140]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->555],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Resultant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Resultant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialGCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eliminate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eliminate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minors"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->769]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4005],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "Tutorials",\

 CellID->5580]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->382475269],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->5100192]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Subresultants - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 3.4549170}", "context" -> "System`", 
    "keywords" -> {
     "principal subresultant coefficients", "subresultants", "common roots", 
      "root multiplicities", "psc"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Subresultants[poly_1, poly_2, var] generates a list of the principal \
subresultant coefficients of the polynomials poly_1 and poly_2 with respect \
to the variable var. ", "synonyms" -> {}, "title" -> "Subresultants", "type" -> 
    "Symbol", "uri" -> "ref/Subresultants"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6048, 206, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->270631523]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 48994, 1514}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2098, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2721, 78, 51, 1, 70, "ObjectName",
 CellID->24917],
Cell[2775, 81, 1108, 36, 70, "Usage",
 CellID->2971]
}, Open  ]],
Cell[CellGroupData[{
Cell[3920, 122, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4398, 139, 545, 21, 70, "Notes",
 CellID->1007],
Cell[4946, 162, 1065, 39, 70, "Notes",
 CellID->17840]
}, Closed]],
Cell[CellGroupData[{
Cell[6048, 206, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->270631523],
Cell[CellGroupData[{
Cell[6433, 220, 148, 5, 70, "ExampleSection",
 CellID->472070102],
Cell[6584, 227, 141, 4, 70, "ExampleText",
 CellID->13725609],
Cell[CellGroupData[{
Cell[6750, 235, 663, 25, 28, "Input",
 CellID->360375124],
Cell[7416, 262, 294, 9, 36, "Output",
 CellID->248571512]
}, Open  ]],
Cell[7725, 274, 125, 3, 70, "ExampleDelimiter",
 CellID->120361569],
Cell[7853, 279, 120, 3, 70, "ExampleText",
 CellID->206260048],
Cell[CellGroupData[{
Cell[7998, 286, 532, 19, 28, "Input",
 CellID->31060],
Cell[8533, 307, 6747, 115, 177, "Output",
 Evaluatable->False,
 CellID->68804959]
}, Open  ]],
Cell[15295, 425, 125, 3, 70, "ExampleText",
 CellID->104197699],
Cell[CellGroupData[{
Cell[15445, 432, 148, 5, 70, "Input",
 CellID->779951316],
Cell[15596, 439, 768, 24, 39, "Output",
 CellID->242180366]
}, Open  ]],
Cell[16379, 466, 116, 3, 70, "ExampleText",
 CellID->249796175],
Cell[CellGroupData[{
Cell[16520, 473, 203, 7, 70, "Input",
 CellID->50066093],
Cell[16726, 482, 266, 9, 36, "Output",
 CellID->7146558]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17041, 497, 216, 7, 70, "ExampleSection",
 CellID->21114],
Cell[17260, 506, 125, 3, 70, "ExampleText",
 CellID->953867484],
Cell[CellGroupData[{
Cell[17410, 513, 400, 14, 70, "Input",
 CellID->761861355],
Cell[17813, 529, 279, 9, 36, "Output",
 CellID->193601287]
}, Open  ]],
Cell[18107, 541, 124, 3, 70, "ExampleDelimiter",
 CellID->28721149],
Cell[18234, 546, 147, 4, 70, "ExampleText",
 CellID->768178768],
Cell[CellGroupData[{
Cell[18406, 554, 417, 14, 70, "Input",
 CellID->7103],
Cell[18826, 570, 2224, 64, 75, "Output",
 CellID->124695132]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21099, 640, 223, 7, 70, "ExampleSection",
 CellID->16220],
Cell[21325, 649, 119, 3, 70, "ExampleText",
 CellID->61136078],
Cell[CellGroupData[{
Cell[21469, 656, 1202, 41, 70, "Input",
 CellID->362571328],
Cell[22674, 699, 5031, 132, 399, "Output",
 CellID->488726025]
}, Open  ]],
Cell[27720, 834, 259, 9, 70, "ExampleText",
 CellID->385995121],
Cell[CellGroupData[{
Cell[28004, 847, 321, 11, 70, "Input",
 CellID->103412743],
Cell[28328, 860, 4787, 83, 70, "Output",
 Evaluatable->False,
 CellID->69151448]
}, Open  ]],
Cell[CellGroupData[{
Cell[33152, 948, 155, 5, 70, "Input",
 CellID->45946617],
Cell[33310, 955, 1496, 29, 70, "Output",
 Evaluatable->False,
 CellID->72029536]
}, Open  ]],
Cell[34821, 987, 125, 3, 70, "ExampleDelimiter",
 CellID->265041855],
Cell[34949, 992, 115, 3, 70, "ExampleText",
 CellID->20089093],
Cell[CellGroupData[{
Cell[35089, 999, 1034, 34, 70, "Input",
 CellID->170391737],
Cell[36126, 1035, 2937, 90, 174, "Output",
 CellID->509436260]
}, Open  ]],
Cell[39078, 1128, 193, 6, 70, "ExampleText",
 CellID->485652489],
Cell[CellGroupData[{
Cell[39296, 1138, 321, 11, 70, "Input",
 CellID->341217340],
Cell[39620, 1151, 1089, 37, 70, "Output",
 CellID->154249633]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40758, 1194, 233, 7, 70, "ExampleSection",
 CellID->21819],
Cell[40994, 1203, 126, 4, 70, "ExampleText",
 CellID->20840],
Cell[CellGroupData[{
Cell[41145, 1211, 492, 18, 70, "Input",
 CellID->23989],
Cell[41640, 1231, 243, 8, 36, "Output",
 CellID->203589179]
}, Open  ]],
Cell[CellGroupData[{
Cell[41920, 1244, 546, 20, 70, "Input",
 CellID->26758],
Cell[42469, 1266, 263, 9, 36, "Output",
 CellID->488428628]
}, Open  ]],
Cell[42747, 1278, 120, 3, 70, "ExampleDelimiter",
 CellID->5368],
Cell[42870, 1283, 147, 3, 70, "ExampleText",
 CellID->13540],
Cell[CellGroupData[{
Cell[43042, 1290, 277, 10, 70, "Input",
 CellID->9609],
Cell[43322, 1302, 158, 5, 36, "Output",
 CellID->38284271]
}, Open  ]],
Cell[43495, 1310, 124, 3, 70, "ExampleDelimiter",
 CellID->27287040],
Cell[43622, 1315, 353, 13, 70, "ExampleText",
 CellID->152264916],
Cell[43978, 1330, 561, 21, 70, "Input",
 CellID->523694028],
Cell[CellGroupData[{
Cell[44564, 1355, 142, 4, 70, "Input",
 CellID->290436583],
Cell[44709, 1361, 302, 10, 36, "Output",
 CellID->536215671]
}, Open  ]],
Cell[CellGroupData[{
Cell[45048, 1376, 137, 4, 70, "Input",
 CellID->59658466],
Cell[45188, 1382, 184, 6, 36, "Output",
 CellID->42067140]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45433, 1395, 309, 9, 70, "SeeAlsoSection",
 CellID->555],
Cell[45745, 1406, 949, 35, 70, "SeeAlso",
 CellID->769]
}, Open  ]],
Cell[CellGroupData[{
Cell[46731, 1446, 313, 9, 70, "TutorialsSection",
 CellID->4005],
Cell[47047, 1457, 179, 4, 70, "Tutorials",
 CellID->5580]
}, Open  ]],
Cell[CellGroupData[{
Cell[47263, 1466, 319, 9, 70, "MoreAboutSection",
 CellID->382475269],
Cell[47585, 1477, 145, 3, 70, "MoreAbout",
 CellID->5100192]
}, Open  ]],
Cell[47745, 1483, 27, 0, 70, "History"],
Cell[47775, 1485, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

