(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13211,        450]
NotebookOptionsPosition[     10522,        360]
NotebookOutlinePosition[     11715,        396]
CellTagsIndexPosition[     11630,        391]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators without Built\[Hyphen]in Meanings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OperatorsWithoutBuiltInMeanings"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators without Built\[Hyphen]in Meanings\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SubsetEqual" :> 
          Documentation`HelpLookup["paclet:ref/SubsetEqual"], "SquareSubset" :> 
          Documentation`HelpLookup["paclet:ref/SquareSubset"], "Element" :> 
          Documentation`HelpLookup["paclet:ref/Element"], "Precedes" :> 
          Documentation`HelpLookup["paclet:ref/Precedes"], "LeftTriangle" :> 
          Documentation`HelpLookup["paclet:ref/LeftTriangle"], "NotSubset" :> 
          Documentation`HelpLookup["paclet:ref/NotSubset"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SubsetEqual\"\>", 
       2->"\<\"SquareSubset\"\>", 3->"\<\"Element\"\>", 4->"\<\"Precedes\"\>",
        5->"\<\"LeftTriangle\"\>", 
       6->"\<\"NotSubset\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     "Subset ",
     StyleBox["(\[Subset])", "OperatorCharacter"]
    }], "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Subset",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Subset"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]displays as ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", "\[Subset]", "y", "\[Subset]", "\[Ellipsis]"}], 
       TraditionalForm]], "InlineMath"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subset"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " has no built-in meaning."
}], "Notes",
 CellID->2101348520],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[Subset]", "y"}], TraditionalForm]], "InlineMath"],
 " is by default interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subset"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1996000725],

Cell[TextData[{
 Cell[BoxData[
  FormBox["\[Subset]", TraditionalForm]], "InlineMath"],
 " can be entered as ",
 Cell[TextData[ButtonBox["\\[Subset]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Subset"]], "InlineCharacterName"],
 " or ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]sub\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 "."
}], "Notes",
 CellID->942135288]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->732633992],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->625298740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subset", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->418967105],

Cell[BoxData[
 RowBox[{"x", "\[Subset]", "y", "\[Subset]", "z"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79958209]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->896294039],

Cell[TextData[{
 "Type ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]sub\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " to enter directly:"
}], "ExampleText",
 CellID->353419946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "\[Subset]", "y"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->354488715],

Cell[BoxData[
 RowBox[{"x", "\[Subset]", "y"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->588211330]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27433],

Cell[TextData[{
 Cell[TextData[StyleBox[ButtonBox["SubsetEqual",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SubsetEqual"],
  FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["SquareSubset",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/SquareSubset"],
  FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["Element",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Element"],
  FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["Precedes",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/Precedes"],
  FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["LeftTriangle",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/LeftTriangle"],
  FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[StyleBox[ButtonBox["NotSubset",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/NotSubset"],
  FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7416]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Operators without Built\[Hyphen]in Meanings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperatorsWithoutBuiltInMeanings"]], "Tutorials",\

 CellID->341631938]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Subset (\[Subset]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 6.9237558}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Subset[x, y, ...] displays as x \\[Subset] y \\[Subset] ....", 
    "synonyms" -> {}, "title" -> "Subset", "type" -> "Symbol", "uri" -> 
    "ref/Subset"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6437, 203, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->732633992]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11487, 384}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1766, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2389, 67, 1646, 40, 70, "ObjectNameGrid"],
Cell[4038, 109, 708, 23, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4783, 137, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5261, 154, 331, 12, 70, "Notes",
 CellID->2101348520],
Cell[5595, 168, 397, 15, 70, "Notes",
 CellID->1996000725],
Cell[5995, 185, 405, 13, 70, "Notes",
 CellID->942135288]
}, Closed]],
Cell[CellGroupData[{
Cell[6437, 203, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->732633992],
Cell[CellGroupData[{
Cell[6822, 217, 148, 5, 70, "ExampleSection",
 CellID->625298740],
Cell[CellGroupData[{
Cell[6995, 226, 135, 4, 28, "Input",
 CellID->418967105],
Cell[7133, 232, 205, 6, 36, "Output",
 CellID->79958209]
}, Open  ]],
Cell[7353, 241, 125, 3, 70, "ExampleDelimiter",
 CellID->896294039],
Cell[7481, 246, 343, 13, 70, "ExampleText",
 CellID->353419946],
Cell[CellGroupData[{
Cell[7849, 263, 100, 3, 28, "Input",
 CellID->354488715],
Cell[7952, 268, 188, 6, 36, "Output",
 CellID->588211330]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8201, 281, 311, 9, 70, "SeeAlsoSection",
 CellID->27433],
Cell[8515, 292, 1386, 41, 70, "SeeAlso",
 CellID->7416]
}, Open  ]],
Cell[CellGroupData[{
Cell[9938, 338, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[10259, 349, 191, 4, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[10465, 356, 27, 0, 70, "History"],
Cell[10495, 358, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

