(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20198,        813]
NotebookOptionsPosition[     14540,        612]
NotebookOutlinePosition[     15870,        650]
CellTagsIndexPosition[     15785,        645]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Forms of Assignment" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialFormsOfAssignment"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Special Forms of Assignment\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Minus" :> Documentation`HelpLookup["paclet:ref/Minus"], 
          "Decrement" :> Documentation`HelpLookup["paclet:ref/Decrement"], 
          "Subtract" :> Documentation`HelpLookup["paclet:ref/Subtract"], 
          "AddTo" :> Documentation`HelpLookup["paclet:ref/AddTo"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Minus\"\>", 2->"\<\"Decrement\"\>", 
       3->"\<\"Subtract\"\>", 4->"\<\"AddTo\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "SubtractFrom ",
 StyleBox["(-=)", "OperatorCharacter"]
}], "ObjectName",
 CellID->1752],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "-=", 
       StyleBox["dx", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]subtracts ",
     Cell[BoxData[
      StyleBox["dx", "TI"]], "InlineFormula"],
     " from ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and returns the new value of ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18443]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SubtractFrom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SubtractFrom"]], "InlineFormula"],
 " has the attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28296],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "-=", 
   StyleBox["dx", "TI"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", 
   RowBox[{
    StyleBox["x", "TI"], "-", 
    StyleBox["dx", "TI"]}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12673]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->80616091],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->24056654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "=", "1"}], ";", 
  RowBox[{"k", "-=", "5"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->501313468],

Cell[BoxData[
 RowBox[{"-", "4"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59733389]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["k"], "Input",
 CellLabel->"In[2]:=",
 CellID->230791865],

Cell[BoxData[
 RowBox[{"-", "4"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5470943]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13169],

Cell["Subtract from a numerical value:", "ExampleText",
 CellID->1113876286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "1.5"}], ";", " ", 
  RowBox[{"x", "-=", "0.75"}], ";", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1774324750],

Cell[BoxData["0.75`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72780679]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->206580424],

Cell["Subtract from a symbolic value:", "ExampleText",
 CellID->838884225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", "a"}], ";", 
  RowBox[{"v", "-=", "b"}], ";", "v"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1698859122],

Cell[BoxData[
 RowBox[{"a", "-", "b"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174336962]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2063940682],

Cell["Subtract from all values in a list:", "ExampleText",
 CellID->822015323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"{", 
   RowBox[{"100", ",", "200", ",", "300"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2332824],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "200", ",", "300"}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->349200360]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "-=", "17"}], ";", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1729906436],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"83", ",", "183", ",", "283"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->155525288]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "-=", 
   RowBox[{"{", 
    RowBox[{"20", ",", "21", ",", "22"}], "}"}]}], ";", "x"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->628970065],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"63", ",", "162", ",", "261"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->5545935]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26488],

Cell["Find the last prime below one million:", "ExampleText",
 CellID->2078680352],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"i", "=", 
   RowBox[{
    RowBox[{"10", "^", "6"}], "+", "1"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"!", 
     RowBox[{"PrimeQ", "[", "i", "]"}]}], ",", 
    RowBox[{"i", "-=", "2"}]}], "]"}], ";"}], "\n", "i"}], "Input",
 CellLabel->"In[1]:=",
 CellID->84768696],

Cell[BoxData["999983"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->266698753]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28685],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SubtractFrom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SubtractFrom"]], "InlineFormula"],
 " is a short form of this assignment:"
}], "ExampleText",
 CellID->2065810971],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "1"}], ";"}], "\n", 
 RowBox[{"k", "=", 
  RowBox[{"k", "-", "5"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1887499219],

Cell[BoxData[
 RowBox[{"-", "4"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->515314709]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->607562233],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PreDecrement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PreDecrement"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["SubtractFrom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SubtractFrom"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1728269985],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "10"}], ";"}], "\n", 
 RowBox[{"k", "-=", "1"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->683214900],

Cell[BoxData["9"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->819752223]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"--", "k"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->304619170],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->905983916]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->160021160],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AddTo",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AddTo"]], "InlineFormula"],
 " is closely related:"
}], "ExampleText",
 CellID->650476513],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"k", "-=", "5"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->169527740],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->130909652]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "+=", 
  RowBox[{"-", "5"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->452459319],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->348612750]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19090],

Cell["A variable to be decremented must have an initial value:", "ExampleText",
 CellID->992262862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "-=", "2"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1397421414],

Cell[BoxData[
 RowBox[{
  RowBox[{"SubtractFrom", "::", "\<\"rvalue\"\>"}], ":", 
  " ", "\<\"\\!\\(x\\) is not a variable with a value, so its value cannot be \
changed.\"\>"}]], "Message", "MSG",
 CellID->27728789],

Cell[BoxData[
 RowBox[{"x", "-=", "2"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145647569]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12818],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Decrement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Decrement"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subtract",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subtract"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AddTo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AddTo"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->610]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10040],

Cell[TextData[ButtonBox["Special Forms of Assignment",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFormsOfAssignment"]], "Tutorials",
 CellID->9313]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SubtractFrom (-=) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 17.1115166}", "context" -> "System`", 
    "keywords" -> {
     "decrement a value", "subtract from value", "decrease value", 
      "subtract from list of values"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "x -= dx subtracts dx from x and returns the new value of x. ", 
    "synonyms" -> {"subtract from", "-="}, "title" -> "SubtractFrom", "type" -> 
    "Symbol", "uri" -> "ref/SubtractFrom"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4033, 144, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->80616091]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15643, 638}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1456, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2079, 61, 105, 4, 70, "ObjectName",
 CellID->1752],
Cell[2187, 67, 645, 22, 70, "Usage",
 CellID->18443]
}, Open  ]],
Cell[CellGroupData[{
Cell[2869, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3347, 111, 322, 12, 70, "Notes",
 CellID->28296],
Cell[3672, 125, 324, 14, 70, "Notes",
 CellID->12673]
}, Closed]],
Cell[CellGroupData[{
Cell[4033, 144, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->80616091],
Cell[CellGroupData[{
Cell[4417, 158, 147, 5, 70, "ExampleSection",
 CellID->24056654],
Cell[CellGroupData[{
Cell[4589, 167, 139, 5, 28, "Input",
 CellID->501313468],
Cell[4731, 174, 174, 6, 36, "Output",
 CellID->59733389]
}, Open  ]],
Cell[CellGroupData[{
Cell[4942, 185, 70, 2, 28, "Input",
 CellID->230791865],
Cell[5015, 189, 173, 6, 36, "Output",
 CellID->5470943]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5237, 201, 216, 7, 70, "ExampleSection",
 CellID->13169],
Cell[5456, 210, 76, 1, 70, "ExampleText",
 CellID->1113876286],
Cell[CellGroupData[{
Cell[5557, 215, 160, 5, 70, "Input",
 CellID->1774324750],
Cell[5720, 222, 161, 5, 36, "Output",
 CellID->72780679]
}, Open  ]],
Cell[5896, 230, 125, 3, 70, "ExampleDelimiter",
 CellID->206580424],
Cell[6024, 235, 74, 1, 70, "ExampleText",
 CellID->838884225],
Cell[CellGroupData[{
Cell[6123, 240, 150, 5, 70, "Input",
 CellID->1698859122],
Cell[6276, 247, 180, 6, 36, "Output",
 CellID->174336962]
}, Open  ]],
Cell[6471, 256, 126, 3, 70, "ExampleDelimiter",
 CellID->2063940682],
Cell[6600, 261, 78, 1, 70, "ExampleText",
 CellID->822015323],
Cell[CellGroupData[{
Cell[6703, 266, 153, 5, 70, "Input",
 CellID->2332824],
Cell[6859, 273, 220, 7, 36, "Output",
 CellID->349200360]
}, Open  ]],
Cell[CellGroupData[{
Cell[7116, 285, 118, 4, 70, "Input",
 CellID->1729906436],
Cell[7237, 291, 218, 7, 36, "Output",
 CellID->155525288]
}, Open  ]],
Cell[CellGroupData[{
Cell[7492, 303, 178, 6, 70, "Input",
 CellID->628970065],
Cell[7673, 311, 216, 7, 36, "Output",
 CellID->5545935]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7938, 324, 223, 7, 70, "ExampleSection",
 CellID->26488],
Cell[8164, 333, 82, 1, 70, "ExampleText",
 CellID->2078680352],
Cell[CellGroupData[{
Cell[8271, 338, 338, 12, 70, "Input",
 CellID->84768696],
Cell[8612, 352, 163, 5, 36, "Output",
 CellID->266698753]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8824, 363, 233, 7, 70, "ExampleSection",
 CellID->28685],
Cell[9060, 372, 222, 7, 70, "ExampleText",
 CellID->2065810971],
Cell[CellGroupData[{
Cell[9307, 383, 169, 6, 70, "Input",
 CellID->1887499219],
Cell[9479, 391, 175, 6, 36, "Output",
 CellID->515314709]
}, Open  ]],
Cell[9669, 400, 125, 3, 70, "ExampleDelimiter",
 CellID->607562233],
Cell[9797, 405, 341, 12, 70, "ExampleText",
 CellID->1728269985],
Cell[CellGroupData[{
Cell[10163, 421, 147, 5, 70, "Input",
 CellID->683214900],
Cell[10313, 428, 158, 5, 36, "Output",
 CellID->819752223]
}, Open  ]],
Cell[CellGroupData[{
Cell[10508, 438, 88, 3, 70, "Input",
 CellID->304619170],
Cell[10599, 443, 158, 5, 36, "Output",
 CellID->905983916]
}, Open  ]],
Cell[10772, 451, 125, 3, 70, "ExampleDelimiter",
 CellID->160021160],
Cell[10900, 456, 191, 7, 70, "ExampleText",
 CellID->650476513],
Cell[CellGroupData[{
Cell[11116, 467, 164, 5, 70, "Input",
 CellID->169527740],
Cell[11283, 474, 158, 5, 36, "Output",
 CellID->130909652]
}, Open  ]],
Cell[CellGroupData[{
Cell[11478, 484, 111, 4, 70, "Input",
 CellID->452459319],
Cell[11592, 490, 158, 5, 36, "Output",
 CellID->348612750]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11799, 501, 226, 7, 70, "ExampleSection",
 CellID->19090],
Cell[12028, 510, 99, 1, 70, "ExampleText",
 CellID->992262862],
Cell[CellGroupData[{
Cell[12152, 515, 94, 3, 70, "Input",
 CellID->1397421414],
Cell[12249, 520, 216, 5, 70, "Message",
 CellID->27728789],
Cell[12468, 527, 181, 6, 36, "Output",
 CellID->145647569]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12710, 540, 311, 9, 70, "SeeAlsoSection",
 CellID->12818],
Cell[13024, 551, 929, 35, 70, "SeeAlso",
 CellID->610]
}, Open  ]],
Cell[CellGroupData[{
Cell[13990, 591, 314, 9, 70, "TutorialsSection",
 CellID->10040],
Cell[14307, 602, 161, 3, 70, "Tutorials",
 CellID->9313]
}, Open  ]],
Cell[14483, 608, 27, 0, 70, "History"],
Cell[14513, 610, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

