(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16303,        595]
NotebookOptionsPosition[     13071,        483]
NotebookOutlinePosition[     14259,        519]
CellTagsIndexPosition[     14174,        514]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators without Built\[Hyphen]in Meanings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OperatorsWithoutBuiltInMeanings"], 
          "Names of Symbols and Mathematical Objects" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NamesOfSymbolsAndMathematicalObjects"], 
          "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Operators without Built\[Hyphen]in Meanings\"\>", 
       2->"\<\"Names of Symbols and Mathematical Objects\"\>", 
       3->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Subscript" :> Documentation`HelpLookup["paclet:ref/Subscript"],
           "Subsuperscript" :> 
          Documentation`HelpLookup["paclet:ref/Subsuperscript"], "Overscript" :> 
          Documentation`HelpLookup["paclet:ref/Overscript"], 
          "ScriptSizeMultipliers" :> 
          Documentation`HelpLookup["paclet:ref/ScriptSizeMultipliers"], 
          "SuperscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/SuperscriptBox"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Subscript\"\>", 
       2->"\<\"Subsuperscript\"\>", 3->"\<\"Overscript\"\>", 
       4->"\<\"ScriptSizeMultipliers\"\>", 
       5->"\<\"SuperscriptBox\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Notational Forms" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicNotationalForms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Symbolic Notational Forms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Superscript", "ObjectName",
 CellID->12723],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Superscript",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Superscript"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is an object that formats as ",
     Cell[BoxData[
      FormBox[
       SuperscriptBox["x", "y"], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17982]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Input of the form ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "y"], TraditionalForm]], "InlineMath"],
 " in a notebook is interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Power",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Power"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ", not as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Superscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Superscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22018],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Superscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Superscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " formats as ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "y"], TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14776],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Superscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Superscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " formats literally as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Superscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Superscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9220],

Cell[TextData[{
 "The baseline of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Superscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Superscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " is taken to be the baseline of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->31111],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Superscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Superscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " is normally output with ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " in a smaller font than ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->32182]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->12391055],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->332773811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Superscript", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->689431461],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw8AIxvwQDkP0fyAJj
3v//gTQyyQQUZgKyQDQ7WISBFUL9BwMgg4EDohKqihMLD1MPM1SeGcMWsAgz
QjEjWAUnVlEOJFEGqBm4RNmh5kOtBANGDP8yMAIA6NF/xA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{13, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6414041]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->245903499],

Cell[TextData[{
 "Entering superscript notation directly, through ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["^", "KeyEvent"],
 " ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " will be interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Power",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Power"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->195329793],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox["x", "y"]], "Input",
 CellLabel->"In[1]:=",
 CellID->155022979],

Cell[BoxData[
 SuperscriptBox["x", "y"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147486505]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5630229],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"x", ",", "y"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->63878837]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6486],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subscript"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subsuperscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsuperscript"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Overscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overscript"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScriptSizeMultipliers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScriptSizeMultipliers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SuperscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SuperscriptBox"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19677]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23856],

Cell[TextData[ButtonBox["Operators without Built\[Hyphen]in Meanings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperatorsWithoutBuiltInMeanings"]], "Tutorials",\

 CellID->14310],

Cell[TextData[ButtonBox["Names of Symbols and Mathematical Objects",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NamesOfSymbolsAndMathematicalObjects"]], "Tutorials",
 CellID->6617],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->444657240]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->153632578],

Cell[TextData[ButtonBox["Symbolic Notational Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicNotationalForms"]], "MoreAbout",
 CellID->175382586]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Superscript - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 28.6430618}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Superscript[x, y] is an object that formats as x^y. ", "synonyms" -> {}, 
    "title" -> "Superscript", "type" -> "Symbol", "uri" -> 
    "ref/Superscript"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7406, 257, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->12391055]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14032, 507}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2712, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3335, 90, 49, 1, 70, "ObjectName",
 CellID->12723],
Cell[3387, 93, 643, 21, 70, "Usage",
 CellID->17982]
}, Open  ]],
Cell[CellGroupData[{
Cell[4067, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4545, 136, 646, 25, 70, "Notes",
 CellID->22018],
Cell[5194, 163, 657, 25, 70, "Notes",
 CellID->14776],
Cell[5854, 190, 656, 26, 70, "Notes",
 CellID->9220],
Cell[6513, 218, 394, 15, 70, "Notes",
 CellID->31111],
Cell[6910, 235, 459, 17, 70, "Notes",
 CellID->32182]
}, Closed]],
Cell[CellGroupData[{
Cell[7406, 257, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->12391055],
Cell[CellGroupData[{
Cell[7790, 271, 148, 5, 70, "ExampleSection",
 CellID->332773811],
Cell[CellGroupData[{
Cell[7963, 280, 130, 4, 28, "Input",
 CellID->689431461],
Cell[8096, 286, 379, 10, 36, "Output",
 Evaluatable->False,
 CellID->6414041]
}, Open  ]],
Cell[8490, 299, 125, 3, 70, "ExampleDelimiter",
 CellID->245903499],
Cell[8618, 304, 573, 22, 70, "ExampleText",
 CellID->195329793],
Cell[CellGroupData[{
Cell[9216, 330, 93, 3, 28, "Input",
 CellID->155022979],
Cell[9312, 335, 181, 6, 36, "Output",
 CellID->147486505]
}, Open  ]],
Cell[CellGroupData[{
Cell[9530, 346, 102, 3, 70, "Input",
 CellID->5630229],
Cell[9635, 351, 346, 13, 50, "Output",
 CellID->63878837]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10042, 371, 310, 9, 70, "SeeAlsoSection",
 CellID->6486],
Cell[10355, 382, 1242, 44, 70, "SeeAlso",
 CellID->19677]
}, Open  ]],
Cell[CellGroupData[{
Cell[11634, 431, 314, 9, 70, "TutorialsSection",
 CellID->23856],
Cell[11951, 442, 187, 4, 70, "Tutorials",
 CellID->14310],
Cell[12141, 448, 190, 4, 70, "Tutorials",
 CellID->6617],
Cell[12334, 454, 146, 3, 70, "Tutorials",
 CellID->444657240]
}, Open  ]],
Cell[CellGroupData[{
Cell[12517, 462, 319, 9, 70, "MoreAboutSection",
 CellID->153632578],
Cell[12839, 473, 160, 3, 70, "MoreAbout",
 CellID->175382586]
}, Open  ]],
Cell[13014, 479, 27, 0, 70, "History"],
Cell[13044, 481, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

