(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17379,        588]
NotebookOptionsPosition[     14405,        499]
NotebookOutlinePosition[     15910,        534]
CellTagsIndexPosition[     15867,        531]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["OBSOLETE MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"The Structure of Graphics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Lighting" :> Documentation`HelpLookup["paclet:ref/Lighting"], 
          "ColorFunction" :> 
          Documentation`HelpLookup["paclet:ref/ColorFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Lighting\"\>", 
       2->"\<\"ColorFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SurfaceColor", "ObjectName",
 CellID->25697],

Cell[TextData[{
 "As of Version 6, ",
 Cell[BoxData["SurfaceColor"], "InlineFormula"],
 " has been superseded by ",
 Cell[BoxData[
  ButtonBox["Specularity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Specularity"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Glow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Glow"]], "InlineFormula"],
 ". "
}], "ObsolescenceNote",
 CellID->4919],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SurfaceColor", "[", 
       StyleBox["dcol", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a three\[Hyphen]dimensional graphics directive which \
specifies that the surfaces which follow should act as diffuse reflectors of \
light with a color given by ",
     Cell[BoxData[
      StyleBox["dcol", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SurfaceColor", "[", 
       RowBox[{
        StyleBox["dcol", "TI"], ",", 
        StyleBox["scol", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies that a specular reflection component should \
be included, with a color given by ",
     Cell[BoxData[
      StyleBox["scol", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SurfaceColor", "[", 
       RowBox[{
        StyleBox["dcol", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["scol", "TI"], ",", 
          StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies that the reflection should occur with \
specular exponent\[NonBreakingSpace]",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SurfaceColor", "[", 
       RowBox[{
        StyleBox["dcol", "TI"], ",", 
        StyleBox["scol", "TI"], ",", 
        StyleBox["gcol", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies that a color ",
     Cell[BoxData[
      StyleBox["gcol", "TI"]], "InlineFormula"],
     " should be added as if there was an intrinsic glow in the polygon. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->17780]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["SurfaceColor"], "InlineFormula"],
 " directives give surface properties which determine the effect of simulated \
illumination on polygons and other surfaces. "
}], "Notes",
 CellID->22578],

Cell[TextData[{
 Cell[BoxData["SurfaceColor"], "InlineFormula"],
 " directives can appear inside ",
 Cell[BoxData[
  ButtonBox["FaceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceForm"]], "InlineFormula"],
 " directives. "
}], "Notes",
 CellID->12931],

Cell[TextData[{
 "Explicit color directives such as ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " override previous ",
 Cell[BoxData["SurfaceColor"], "InlineFormula"],
 " specifications, so that ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{
     ButtonBox["RGBColor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RGBColor"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], ",", 
    RowBox[{
     ButtonBox["Polygon",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Polygon"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}]}], "}"}]], "InlineFormula"],
 " specifies an explicit color for a polygon, independent of lighting. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->32544],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SurfaceColor", "[", "]"}]], "InlineFormula"],
 " will override previous explicit color directives, and specifies that \
subsequent surfaces should be colored using simulated illumination. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->3340],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SurfaceColor", "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"SurfaceColor", "[", 
   RowBox[{
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", "1", "]"}], ",", 
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", "0", "]"}], ",", 
    RowBox[{
     ButtonBox["GrayLevel",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GrayLevel"], "[", "0", "]"}]}], "]"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->13487],

Cell[TextData[{
 "If no ",
 Cell[BoxData["SurfaceColor"], "InlineFormula"],
 " directive is given, surface are assumed to be white diffuse reflectors of \
light, obeying Lambert\[CloseCurlyQuote]s law of reflection, so that the \
intensity of reflected light is ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", 
    RowBox[{"(", "\[Alpha]", ")"}]}], TraditionalForm]], "InlineMath"],
 " times the intensity of incident light, where ",
 Cell[BoxData[
  FormBox["\[Alpha]", TraditionalForm]], "InlineMath"],
 " is the angle between the direction of the incident light and the surface \
normal. When ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Alpha]", ">", 
    SuperscriptBox["90", "\[EmptySmallCircle]"]}], TraditionalForm]], 
  "InlineMath"],
 ", there is no reflected light. "
}], "Notes",
 CellID->899],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SurfaceColor", "[", 
   RowBox[{
    ButtonBox["GrayLevel",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GrayLevel"], "[", 
    StyleBox["a", "TI"], "]"}], "]"}]], "InlineFormula"],
 " specifies that surfaces should act as diffuse reflectors, but with albedo \
",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ". The intensity of reflected light is therefore ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " times the intensity of the incident light, multiplied by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", 
    RowBox[{"(", "\[Alpha]", ")"}]}], TraditionalForm]], "InlineMath"],
 ", and is of the same color. "
}], "Notes",
 CellID->22525],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"SurfaceColor", "[", 
   RowBox[{
    ButtonBox["RGBColor",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RGBColor"], "[", 
    RowBox[{
     StyleBox["r", "TI"], ",", 
     StyleBox["g", "TI"], ",", 
     StyleBox["b", "TI"]}], "]"}], "]"}]], "InlineFormula"],
 " specifies that the red, green and blue components of the reflected light \
should be respectively ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " times those of the incident light, multiplied by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", 
    RowBox[{"(", "\[Alpha]", ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->8483],

Cell[TextData[{
 "The second element in ",
 Cell[BoxData[
  RowBox[{"SurfaceColor", "[", 
   RowBox[{
    StyleBox["dcol", "TI"], ",", 
    StyleBox["scol", "TI"]}], "]"}]], "InlineFormula"],
 " specifies a specular reflection component. ",
 Cell[BoxData[
  StyleBox["scol", "TI"]], "InlineFormula"],
 " must be a ",
 Cell[BoxData[
  ButtonBox["GrayLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GrayLevel"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Hue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hue"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 " specification. The color components of ",
 Cell[BoxData[
  StyleBox["scol", "TI"]], "InlineFormula"],
 " give the fractions of each color component in the incident intensity which \
are reflected in a specular way by the surface. "
}], "Notes",
 CellID->5538],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " gives the specular exponent. The intensity of specularly reflected light \
at angle ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " from the mirror\[Hyphen]reflection direction falls off like ",
 Cell[BoxData[
  FormBox[
   RowBox[{"cos", 
    SuperscriptBox[
     RowBox[{"(", "\[Theta]", ")"}], "n"]}], TraditionalForm]], 
  "InlineMath"],
 " as ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " increases. It is zero when ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Theta]", ">", 
    SuperscriptBox["90", "\[EmptySmallCircle]"]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->7492],

Cell[TextData[{
 "For real materials, ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is typically between about 1 and a few hundred. With a coarse polygonal \
mesh, however, values of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " below 10 are usually most appropriate. The default value for ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData["1"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6193],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " implements a version of the Phong lighting model, in which the intensity \
of reflected light is given schematically by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["I", 
     StyleBox[
      RowBox[{"i", "n"}], "TI"]], 
    RowBox[{"(", 
     RowBox[{"d", "cos", 
      RowBox[{"(", "\[Alpha]", ")"}], "+", "s", "cos", 
      SuperscriptBox[
       RowBox[{"(", "\[Theta]", ")"}], "n"], "+", "g"}], ")"}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->28252],

Cell["\<\
The intensities of light from diffuse and specular reflection, and glow, are \
added linearly for each color component. The final color shown for a \
particular polygon is the sum of contributions from each light source, and \
from ambient light. \
\>", "Notes",
 CellID->25011],

Cell[TextData[{
 Cell[BoxData["SurfaceColor"], "InlineFormula"],
 " does not apply to ",
 Cell[BoxData[
  ButtonBox["Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Line"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Point",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Point"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->1560]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18529],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighting"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31540]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15834],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "Tutorials",
 CellID->659944600]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SurfaceColor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 30.6118622}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Obsolete Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "ObsoleteFlag", "summary" -> 
    "SurfaceColor[dcol] is a three-dimensional graphics directive which \
specifies that the surfaces which follow should act as diffuse reflectors of \
light with a color given by dcol. SurfaceColor[dcol, scol] specifies that a \
specular reflection component should be included, with a color given by scol. \
SurfaceColor[dcol, {scol, n}] specifies that the reflection should occur with \
specular exponent n. SurfaceColor[dcol, scol, gcol] specifies that a color \
gcol should be added as if there was an intrinsic glow in the polygon. ", 
    "synonyms" -> {"surface color"}, "title" -> "SurfaceColor", "type" -> 
    "Symbol", "uri" -> "ref/SurfaceColor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1297, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1920, 60, 50, 1, 70, "ObjectName",
 CellID->25697],
Cell[1973, 63, 406, 15, 70, "ObsolescenceNote",
 CellID->4919],
Cell[2382, 80, 1928, 56, 70, "Usage",
 CellID->17780]
}, Open  ]],
Cell[CellGroupData[{
Cell[4347, 141, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4825, 158, 220, 5, 70, "Notes",
 CellID->22578],
Cell[5048, 165, 264, 9, 70, "Notes",
 CellID->12931],
Cell[5315, 176, 936, 28, 70, "Notes",
 CellID->32544],
Cell[6254, 206, 389, 9, 70, "Notes",
 CellID->3340],
Cell[6646, 217, 625, 22, 70, "Notes",
 CellID->13487],
Cell[7274, 241, 802, 22, 70, "Notes",
 CellID->899],
Cell[8079, 265, 721, 22, 70, "Notes",
 CellID->22525],
Cell[8803, 289, 807, 28, 70, "Notes",
 CellID->8483],
Cell[9613, 319, 944, 31, 70, "Notes",
 CellID->5538],
Cell[10560, 352, 755, 26, 70, "Notes",
 CellID->7492],
Cell[11318, 380, 464, 15, 70, "Notes",
 CellID->6193],
Cell[11785, 397, 562, 19, 70, "Notes",
 CellID->28252],
Cell[12350, 418, 288, 6, 70, "Notes",
 CellID->25011],
Cell[12641, 426, 364, 14, 70, "Notes",
 CellID->1560]
}, Closed]],
Cell[CellGroupData[{
Cell[13042, 445, 311, 9, 70, "SeeAlsoSection",
 CellID->18529],
Cell[13356, 456, 461, 17, 70, "SeeAlso",
 CellID->31540]
}, Open  ]],
Cell[CellGroupData[{
Cell[13854, 478, 314, 9, 70, "TutorialsSection",
 CellID->15834],
Cell[14171, 489, 162, 3, 70, "Tutorials",
 CellID->659944600]
}, Open  ]],
Cell[14348, 495, 27, 0, 70, "History"],
Cell[14378, 497, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

