(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16866,        537]
NotebookOptionsPosition[     11595,        393]
NotebookOutlinePosition[     15541,        496]
CellTagsIndexPosition[     15288,        485]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Representing Textual Forms by Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RepresentingTextualFormsByBoxes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Representing Textual Forms by Boxes\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InterpretationBox" :> 
          Documentation`HelpLookup["paclet:ref/InterpretationBox"], "TagBox" :> 
          Documentation`HelpLookup["paclet:ref/TagBox"], "FormBox" :> 
          Documentation`HelpLookup["paclet:ref/FormBox"], "ToExpression" :> 
          Documentation`HelpLookup["paclet:ref/ToExpression"], "ButtonBox" :> 
          Documentation`HelpLookup["paclet:ref/ButtonBox"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"InterpretationBox\"\>", 
       2->"\<\"TagBox\"\>", 3->"\<\"FormBox\"\>", 4->"\<\"ToExpression\"\>", 
       5->"\<\"ButtonBox\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SyntaxForm", "ObjectName",
 CellID->7679],

Cell[TextData[{
 "This function has not been fully integrated into the long-term ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system, and is subject to change.  "
}], "AwaitingReviewNote",
 CellID->213600863],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["SyntaxForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/SyntaxForm"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["InterpretationBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["TagBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
     " objects that specifies the precedence level to use when the ",
     Cell[BoxData[
      ButtonBox["InterpretationBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      ButtonBox["TagBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
     " is considered as an operator."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23990]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " objects provide a way to store hidden information in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output. They are used for expressions that are to be displayed and \
interpreted in different forms. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InterpretationBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpretationBox"], "[", 
   RowBox[{
    StyleBox["boxes", "TI"], ",", " ", 
    StyleBox["interpretation", "TI"]}], "]"}]], "InlineFormula"],
 " displays as ",
 Cell[BoxData[
  StyleBox["boxes", "TI"]], "InlineFormula"],
 " but is interpreted on input as ",
 Cell[BoxData[
  StyleBox["interpretation", "TI"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TagBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TagBox"], "[", 
   RowBox[{
    StyleBox["boxes", "TI"], ",", " ", 
    StyleBox["tag", "TI"]}], "]"}]], "InlineFormula"],
 " displays as ",
 Cell[BoxData[
  StyleBox["boxes", "TI"]], "InlineFormula"],
 " but maintains ",
 Cell[BoxData[
  StyleBox["tag", "TI"]], "InlineFormula"],
 " to guide the interpretation of ",
 Cell[BoxData[
  StyleBox["boxes", "TI"]], "InlineFormula"],
 " on input. "
}], ". ", "Notes",
 CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
 CellID->1003404480],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SyntaxForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxForm"]], "InlineFormula"],
 " is specified as a string containing an operator whose precedence level is \
the same as that of the contents of the ",
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 ". For example, ",
 Cell[BoxData[
  RowBox[{"SyntaxForm", " ", "->", " ", "\"\<*\>\""}]], "InlineFormula"],
 ". You can also distinguish the infix and prefix form of an operator, for \
example, by setting ",
 Cell[BoxData[
  ButtonBox["SyntaxForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxForm"]], "InlineFormula"],
 " to ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"a\", \"TI\"]\\\  + \\\ \*
StyleBox[\"b\", \"TI\"]\)\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<+ a\>\""], "InlineFormula"],
 ", respectively. "
}], "Notes",
 CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
 CellID->21726],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"SyntaxForm", " ", "->", " ", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " automatically assigns a precedence determined by the contents of the ",
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 "."
}], "Notes",
 CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
 CellID->14771],

Cell[TextData[{
 "For a selected ",
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " object, ",
 Cell[BoxData[
  ButtonBox["SyntaxForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxForm"]], "InlineFormula"],
 " is set as an option for ",
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 ", and applies only to the selection."
}], "Notes",
 CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
 CellID->11538],

Cell[TextData[{
 "At the cell level, ",
 Cell[BoxData[
  ButtonBox["SyntaxForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxForm"]], "InlineFormula"],
 " is set as a suboption of the ",
 Cell[BoxData[
  ButtonBox["InterpretationBoxOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBoxOptions"]], "InlineFormula"],
 " or ",
 Cell[BoxData["TagBoxOptions"], "InlineFormula"],
 " option for cells. It specifies the default setting of ",
 Cell[BoxData[
  ButtonBox["SyntaxForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxForm"]], "InlineFormula"],
 " for any ",
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " object in the cell."
}], "Notes",
 CellTags->{"2.3.5.18.8.4", "2.3.5.18.15", "2.3.5.18.15i"},
 CellID->26299]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28470],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InterpretationBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpretationBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TagBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TagBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FormBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FormBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButtonBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ButtonBox"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20183]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24710],

Cell[TextData[ButtonBox["Representing Textual Forms by Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepresentingTextualFormsByBoxes"]], "Tutorials",\

 CellID->32138]
}, Open  ]],

Cell["New in 3.0", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SyntaxForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 42.8465504}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SyntaxForm is an option for InterpretationBox and TagBox objects that \
specifies the precedence level to use when the InterpretationBox or TagBox is \
considered as an operator.", "synonyms" -> {"syntax form"}, "title" -> 
    "SyntaxForm", "type" -> "Symbol", "uri" -> "ref/SyntaxForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "2.3.5.11.7.4"->{
  Cell[4169, 131, 1545, 50, 70, ". ",
   CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
   CellID->1003404480],
  Cell[5717, 183, 1154, 34, 70, "Notes",
   CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
   CellID->21726],
  Cell[6874, 219, 708, 23, 70, "Notes",
   CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
   CellID->14771],
  Cell[7585, 244, 863, 29, 70, "Notes",
   CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
   CellID->11538]},
 "2.3.5.11"->{
  Cell[4169, 131, 1545, 50, 70, ". ",
   CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
   CellID->1003404480],
  Cell[5717, 183, 1154, 34, 70, "Notes",
   CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
   CellID->21726],
  Cell[6874, 219, 708, 23, 70, "Notes",
   CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
   CellID->14771],
  Cell[7585, 244, 863, 29, 70, "Notes",
   CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
   CellID->11538]},
 "2.3.5.18.8"->{
  Cell[4169, 131, 1545, 50, 70, ". ",
   CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
   CellID->1003404480],
  Cell[5717, 183, 1154, 34, 70, "Notes",
   CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
   CellID->21726],
  Cell[6874, 219, 708, 23, 70, "Notes",
   CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
   CellID->14771],
  Cell[7585, 244, 863, 29, 70, "Notes",
   CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
   CellID->11538]},
 "2.3.5.18.8h"->{
  Cell[4169, 131, 1545, 50, 70, ". ",
   CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
   CellID->1003404480],
  Cell[5717, 183, 1154, 34, 70, "Notes",
   CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
   CellID->21726],
  Cell[6874, 219, 708, 23, 70, "Notes",
   CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
   CellID->14771],
  Cell[7585, 244, 863, 29, 70, "Notes",
   CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
   CellID->11538]},
 "2.3.5.18.8.4"->{
  Cell[8451, 275, 978, 31, 70, "Notes",
   CellTags->{"2.3.5.18.8.4", "2.3.5.18.15", "2.3.5.18.15i"},
   CellID->26299]},
 "2.3.5.18.15"->{
  Cell[8451, 275, 978, 31, 70, "Notes",
   CellTags->{"2.3.5.18.8.4", "2.3.5.18.15", "2.3.5.18.15i"},
   CellID->26299]},
 "2.3.5.18.15i"->{
  Cell[8451, 275, 978, 31, 70, "Notes",
   CellTags->{"2.3.5.18.8.4", "2.3.5.18.15", "2.3.5.18.15i"},
   CellID->26299]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"2.3.5.11.7.4", 12677, 418},
 {"2.3.5.11", 13221, 431},
 {"2.3.5.18.8", 13767, 444},
 {"2.3.5.18.8h", 14314, 457},
 {"2.3.5.18.8.4", 14862, 470},
 {"2.3.5.18.15", 15002, 474},
 {"2.3.5.18.15i", 15143, 478}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1651, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2274, 65, 47, 1, 70, "ObjectName",
 CellID->7679],
Cell[2324, 68, 218, 6, 70, "AwaitingReviewNote",
 CellID->213600863],
Cell[2545, 76, 1109, 33, 70, "Usage",
 CellID->23990]
}, Open  ]],
Cell[CellGroupData[{
Cell[3691, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4169, 131, 1545, 50, 70, ". ",
 CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
 CellID->1003404480],
Cell[5717, 183, 1154, 34, 70, "Notes",
 CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
 CellID->21726],
Cell[6874, 219, 708, 23, 70, "Notes",
 CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
 CellID->14771],
Cell[7585, 244, 863, 29, 70, "Notes",
 CellTags->{"2.3.5.11.7.4", "2.3.5.11", "2.3.5.18.8", "2.3.5.18.8h"},
 CellID->11538],
Cell[8451, 275, 978, 31, 70, "Notes",
 CellTags->{"2.3.5.18.8.4", "2.3.5.18.15", "2.3.5.18.15i"},
 CellID->26299]
}, Closed]],
Cell[CellGroupData[{
Cell[9466, 311, 311, 9, 70, "SeeAlsoSection",
 CellID->28470],
Cell[9780, 322, 1208, 44, 70, "SeeAlso",
 CellID->20183]
}, Open  ]],
Cell[CellGroupData[{
Cell[11025, 371, 314, 9, 70, "TutorialsSection",
 CellID->24710],
Cell[11342, 382, 179, 4, 70, "Tutorials",
 CellID->32138]
}, Open  ]],
Cell[11536, 389, 29, 0, 70, "History"],
Cell[11568, 391, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

