(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14634,        521]
NotebookOptionsPosition[     11173,        406]
NotebookOutlinePosition[     12580,        445]
CellTagsIndexPosition[     12495,        440]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Converting between Strings, Boxes and Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ConvertingBetweenStringsBoxesAndExpressions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Converting between Strings, Boxes and Expressions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ToExpression" :> 
          Documentation`HelpLookup["paclet:ref/ToExpression"], "SyntaxLength" :> 
          Documentation`HelpLookup["paclet:ref/SyntaxLength"], 
          "$SyntaxHandler" :> 
          Documentation`HelpLookup["paclet:ref/$SyntaxHandler"], 
          "DelimiterFlashTime" :> 
          Documentation`HelpLookup["paclet:ref/DelimiterFlashTime"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"ToExpression\"\>", 
       2->"\<\"SyntaxLength\"\>", 3->"\<\"$SyntaxHandler\"\>", 
       4->"\<\"DelimiterFlashTime\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Converting between Expressions & Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/ConvertingBetweenExpressionsAndStrings"], 
          "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Converting between Expressions & Strings\"\>", 
       2->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SyntaxQ", "ObjectName",
 CellID->6135],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SyntaxQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SyntaxQ"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the string corresponds to syntactically correct input for a single \
",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression, and returns ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18008]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["SyntaxQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxQ"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", you can find the position of a syntax error using ",
 Cell[BoxData[
  ButtonBox["SyntaxLength",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxLength"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12361]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->566490994],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->250182451],

Cell[TextData[{
 "Test if a string is valid ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " syntax:"
}], "ExampleText",
 CellID->149164833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SyntaxQ", "[", "\"\<a[b[c,1],2],3]\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81125634],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->418704717]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SyntaxQ", "[", "\"\<a[b[c,1],2]\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->103242292],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->595907285]
}, Open  ]],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["SyntaxQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxQ"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", the string can be converted to an expression:"
}], "ExampleText",
 CellID->8229629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", "\"\<a[b[c,1],2]\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->313435987],

Cell[BoxData[
 RowBox[{"a", "[", 
  RowBox[{
   RowBox[{"b", "[", 
    RowBox[{"c", ",", "1"}], "]"}], ",", "2"}], "]"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->387243740]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->80499147],

Cell["\<\
Request input from a dialog repeatedly until it is syntactically correct:\
\>", "ExampleText",
 CellID->274483799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"!", 
     RowBox[{"SyntaxQ", "[", 
      RowBox[{"input", "=", 
       RowBox[{
       "InputString", "[", "\"\<Please enter a Mathematica expression\>\"", 
        "]"}]}], "]"}]}], ",", 
    RowBox[{"Print", "[", 
     RowBox[{"input", ",", "\"\< is not valid Mathematica syntax.\>\""}], 
     "]"}]}], "]"}], ";", 
  RowBox[{"ToExpression", "[", "input", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52256652],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"a[1]]+b[2]\"\>", 
   "\[InvisibleSpace]", "\<\" is not valid Mathematica syntax.\"\>"}],
  SequenceForm["a[1]]+b[2]", " is not valid Mathematica syntax."],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[5]:=",
 CellID->23147416],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "[", "1", "]"}], "+", 
  RowBox[{"b", "[", "2", "]"}]}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7698427]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20178],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SyntaxLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SyntaxLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$SyntaxHandler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$SyntaxHandler"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DelimiterFlashTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DelimiterFlashTime"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4042]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16742],

Cell[TextData[ButtonBox["Converting between Strings, Boxes and Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConvertingBetweenStringsBoxesAndExpressions"]], "Tutorials",\

 CellID->22194]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Converting between Expressions & Strings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConvertingBetweenExpressionsAndStrings"]], "MoreAbout",
 CellID->15238094],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->265562924]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SyntaxQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 45.4872430}", "context" -> "System`", 
    "keywords" -> {
     "checking grammar in strings", "grammar", "syntax checking", 
      "syntax checking in strings", "test syntax"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SyntaxQ[\"string\"] returns True if the string corresponds to \
syntactically correct input for a single Mathematica expression, and returns \
False otherwise. ", "synonyms" -> {"syntax q"}, "title" -> "SyntaxQ", "type" -> 
    "Symbol", "uri" -> "ref/SyntaxQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5072, 162, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->566490994]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12352, 433}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2446, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3069, 85, 44, 1, 70, "ObjectName",
 CellID->6135],
Cell[3116, 88, 918, 29, 70, "Usage",
 CellID->18008]
}, Open  ]],
Cell[CellGroupData[{
Cell[4071, 122, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4549, 139, 486, 18, 70, "Notes",
 CellID->12361]
}, Closed]],
Cell[CellGroupData[{
Cell[5072, 162, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->566490994],
Cell[CellGroupData[{
Cell[5457, 176, 148, 5, 70, "ExampleSection",
 CellID->250182451],
Cell[5608, 183, 146, 6, 70, "ExampleText",
 CellID->149164833],
Cell[CellGroupData[{
Cell[5779, 193, 123, 3, 28, "Input",
 CellID->81125634],
Cell[5905, 198, 162, 5, 36, "Output",
 CellID->418704717]
}, Open  ]],
Cell[CellGroupData[{
Cell[6104, 208, 121, 3, 28, "Input",
 CellID->103242292],
Cell[6228, 213, 161, 5, 36, "Output",
 CellID->595907285]
}, Open  ]],
Cell[6404, 221, 353, 13, 70, "ExampleText",
 CellID->8229629],
Cell[CellGroupData[{
Cell[6782, 238, 126, 3, 70, "Input",
 CellID->313435987],
Cell[6911, 243, 262, 9, 36, "Output",
 CellID->387243740]
}, Open  ]],
Cell[7188, 255, 124, 3, 70, "ExampleDelimiter",
 CellID->80499147],
Cell[7315, 260, 124, 3, 70, "ExampleText",
 CellID->274483799],
Cell[CellGroupData[{
Cell[7464, 267, 492, 15, 70, "Input",
 CellID->52256652],
Cell[7959, 284, 297, 7, 70, "Print",
 CellID->23147416],
Cell[8259, 293, 234, 8, 36, "Output",
 CellID->7698427]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8554, 308, 311, 9, 70, "SeeAlsoSection",
 CellID->20178],
Cell[8868, 319, 988, 35, 70, "SeeAlso",
 CellID->4042]
}, Open  ]],
Cell[CellGroupData[{
Cell[9893, 359, 314, 9, 70, "TutorialsSection",
 CellID->16742],
Cell[10210, 370, 208, 5, 70, "Tutorials",
 CellID->22194]
}, Open  ]],
Cell[CellGroupData[{
Cell[10455, 380, 299, 8, 70, "MoreAboutSection"],
Cell[10757, 390, 192, 4, 70, "MoreAbout",
 CellID->15238094],
Cell[10952, 396, 149, 3, 70, "MoreAbout",
 CellID->265562924]
}, Open  ]],
Cell[11116, 402, 27, 0, 70, "History"],
Cell[11146, 404, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

