(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    182162,       3463]
NotebookOptionsPosition[    176787,       3286]
NotebookOutlinePosition[    178385,       3327]
CellTagsIndexPosition[    178298,       3322]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ColorSetter" :> 
          Documentation`HelpLookup["paclet:ref/ColorSetter"], 
          "FileNameSetter" :> 
          Documentation`HelpLookup["paclet:ref/FileNameSetter"], 
          "DialogInput" :> 
          Documentation`HelpLookup["paclet:ref/DialogInput"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ColorSetter\"\>", 
       2->"\<\"FileNameSetter\"\>", 
       3->"\<\"DialogInput\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], "Dialog Boxes" :> 
          Documentation`HelpLookup["paclet:guide/DialogBoxes"], 
          "Sound and Sonification" :> 
          Documentation`HelpLookup["paclet:guide/SoundAndSonification"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"Custom Interface Construction\"\>", 3->"\<\"Dialog Boxes\"\>", 
       4->"\<\"Sound and Sonification\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SystemDialogInput", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SystemDialogInput",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SystemDialogInput"], "[", "\"\<\!\(\*
StyleBox[\"type\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]brings up an interactive system dialog and returns the \
value chosen in the dialog. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SystemDialogInput",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SystemDialogInput"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"type\", \"TI\"]\)\>\"", ",", 
        StyleBox["init", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses ",
     Cell[BoxData[
      StyleBox["init", "TI"]], "InlineFormula"],
     " as the initial setting in the dialog."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->25679]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Possible types include:", "Notes",
 CellID->28053],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Color\>\"", Cell[
    "color picker dialog", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Directory\>\"", Cell[
    "directory dialog", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FileOpen\>\"", Cell[
    "file open dialog", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FileSave\>\"", Cell[
    "file save dialog", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<RecordSound\>\"", Cell[
    "record sound dialog", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->13043],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["SystemDialogInput",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SystemDialogInput"]], "InlineFormula"],
 " is evaluated, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " stops until the dialog has been dismissed, and a result returned."
}], "Notes",
 CellID->14522],

Cell[TextData[{
 "If the dialog is canceled, ",
 Cell[BoxData[
  ButtonBox["SystemDialogInput",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SystemDialogInput"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["$Canceled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Canceled"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31088],

Cell[TextData[{
 "Many dialog types allow the option ",
 Cell[BoxData[
  ButtonBox["WindowTitle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowTitle"]], "InlineFormula"],
 " to be given."
}], "Notes",
 CellID->1563],

Cell[TextData[{
 "For ",
 Cell[BoxData["\"\<FileOpen\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<FileSave\>\""], "InlineFormula"],
 ", filters for files can be specified in the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SystemDialogInput",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemDialogInput"], "[", 
   RowBox[{
    StyleBox["\[Ellipsis]", "TR"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["init", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"type\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", "->", 
         RowBox[{"{", 
          RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"patt\", \"TI\"], 
StyleBox[\"11\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"patt\", \"TI\"], 
StyleBox[\"12\", \"TR\"]]\)\>\"", ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], ",", 
        RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"type\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", "->", 
         RowBox[{"{", 
          StyleBox["\[Ellipsis]", "TR"], "}"}]}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 ", analogous to ",
 Cell[BoxData[
  ButtonBox["FileNameSetter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileNameSetter"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->464057776]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->517318415],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->191987748],

Cell["\<\
Put up a system color picker dialog, returning the color picked:\
\>", "ExampleText",
 CellID->635823803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SystemDialogInput", "[", "\"\<Color\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->284006766],

Cell[BoxData[
 RowBox[{"RGBColor", "[", 
  RowBox[{"1", ",", "0", ",", "0.501961`"}], "]"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105759617]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->107893939],

Cell["\<\
Put up a system file open dialog, returning the name of the file chosen:\
\>", "ExampleText",
 CellID->356398019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SystemDialogInput", "[", "\"\<FileOpen\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->341078619],

Cell[BoxData["\<\"C:\\\\Documents\\\\2007\\\\Scratch\\\\Try.nb\"\>"], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->549675212]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->349608669],

Cell["Use the system sound recording dialog:", "ExampleText",
 CellID->110098015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SystemDialogInput", "[", "\"\<RecordSound\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67404566],

Cell[BoxData[
 InterpretationBox[
  GraphicsBox[{
    {GrayLevel[0.9], RectangleBox[{0, 0}, {360, -164}]}, {InsetBox[
      GraphicsBox[InsetBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJzs3Xk4lOH/L3AUUiJKSZSIKJIUSnprl1YltGhBkpStBZWylaREUdKmFNmy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          "],
          ColorFunction->(Blend[{
             RGBColor[1, 1, 1], 
             RGBColor[0, 0, 1]}, #]& )],
         AspectRatio->Full,
         ImageSize->NCache[{
            Rational[2756, 2205]}, {1.2498866213151927`}],
         PlotRangePadding->None], {0, 0}, {0, 0}, 
        NCache[{Rational[2756, 2205], 1}, {1.2498866213151927`, 1}]],
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->NCache[{{0, 
           Rational[2756, 2205]}, {0, 1}}, {{0, 1.2498866213151927`}, {0, 
          1}}],
       PlotRangePadding->{
         Scaled[0.017142857142857144`], 
         Scaled[0.1]}], {180, -35}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]], InsetBox[
      GraphicsBox[InsetBox[
        GraphicsBox[
         {RGBColor[0.325101, 0.364492, 0.820256], LineBox[CompressedData["
1:eJxdW2d0lkUTjVIUQUFAkN6lqIAo0tmIFEWaoBQVUaQJIiAKCIKRovTeO1Kk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           "]]},
         AspectRatio->Full,
         PlotRange->{Automatic, {0, 1}},
         PlotRangePadding->None], {0, 0}, {0, 0}, 
        NCache[{Rational[2756, 2205], 1}, {1.2498866213151927`, 1}]],
       AspectRatio->NCache[
         Rational[6, 35], 0.17142857142857143`],
       Background->GrayLevel[1],
       Frame->True,
       FrameStyle->GrayLevel[0.75],
       FrameTicks->False,
       PlotRange->NCache[{{0, 
           Rational[2756, 2205]}, {0, 1}}, {{0, 1.2498866213151927`}, {0, 
          1}}],
       PlotRangePadding->{
         Scaled[0.017142857142857144`], 
         Scaled[0.1]}], {180, -100}, ImageScaled[{0.5, 0.5}], {350, 60},
      Background->GrayLevel[0.9]]}, InsetBox[
     StyleBox[
      InterpretationBox[
       RowBox[{
        InterpretationBox[
         RowBox[{"\<\"1.25\"\>", "\[InvisibleSpace]", "\<\" s\"\>"}],
         Row[{"1.25", " s"}]], 
        StyleBox["\<\" | \"\>",
         StripOnInput->False,
         FontSize->14,
         FontColor->GrayLevel[0.75]], 
        InterpretationBox[
         RowBox[{"11025", "\[InvisibleSpace]", "\<\" Hz\"\>"}],
         Row[{11025, " Hz"}]]}],
       Row[{
         Row[{"1.25", " s"}], 
         Row[{11025, " Hz"}]}, 
        Style[" | ", FontSize -> 14, FontColor -> GrayLevel[0.75]]]], 
      "DialogStyle",
      StripOnInput->False], {355, -159}, Scaled[{1, 0}]], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{5, -158}, {29, -135}]}, 
        {GrayLevel[0.3], 
         PolygonBox[
          NCache[{{13, -153}, {13, -140}, {21, Rational[-293, 2]}, {
            13, -153}}, {{13, -153}, {13, -140}, {21, -146.5}, {
            13, -153}}]]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{5, -158}, {5, -135}, {29, -135}, {29, -158}, {5, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{"MouseClicked" :> (If[None =!= None, 
            Sound`EmitMIDI[None]]; Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[CompressedData["
1:eJztnUuuFMmShrN7J72IHtddQy+hpR73FnIJDBkyYMCAAUKohBCieHMKikfx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             "], 11025], "Preemptive"]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Play\""],
     Annotation[#, "Play", "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[{
        {GrayLevel[0.9], RectangleBox[{34, -158}, {58, -135}]}, 
        {GrayLevel[0.3], RectangleBox[{42, -150}, {50, -143}]}, 
        {GrayLevel[0.5], 
         StyleBox[
          LineBox[{{34, -158}, {34, -135}, {58, -135}, {58, -158}, {
           34, -158}}],
          Antialiasing->False]}},
       EventHandlerTag[{
        "MouseClicked" :> (Sound`SoundDump`emitSoundThroughFE[
            SampledSoundList[{{0.}}, 8000], "Preemptive"]; 
          Sound`MIDIDump`stopMIDI[]), PassEventsDown -> Automatic, 
         PassEventsUp -> True}]],
      "\"Stop\""],
     Annotation[#, "Stop", "Tooltip"]& ], 
    {GrayLevel[0.75], 
     StyleBox[LineBox[{{0, 0}, {360, 0}, {360, -164}, {0, -164}, {0, 0}}],
      Antialiasing->False]}},
   ContentSelectable->False,
   ImageSize->250,
   PlotRange->{{0, 360}, {0, -164}},
   PlotRangePadding->1],
  Sound[
   SampledSoundList[CompressedData["
1:eJztnUuuFMmShrN7J72IHtddQy+hpR73FnIJDBkyYMCAAUKohBCieHMKikfx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    "], 11025]]]], "Output",
 ImageSize->{254, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->275715629]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->46076243],

Cell["Specify a specific file extension:", "ExampleText",
 CellID->120706219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SystemDialogInput", "[", 
  RowBox[{"\"\<FileSave\>\"", ",", "\"\<.nb\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150848903],

Cell[BoxData["$Canceled"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->649046064]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->110774114],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WindowTitle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->111390343],

Cell["Change the default window title:", "ExampleText",
 CellID->1684379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SystemDialogInput", "[", 
  RowBox[{"\"\<FileSave\>\"", ",", 
   RowBox[{"WindowTitle", "\[Rule]", "\"\<Save your work...\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->624758095],

Cell[BoxData["$Canceled"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1447754535]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->325637341],

Cell[TextData[{
 "Automatically generate a reminder to save every ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " seconds:"
}], "ExampleText",
 CellID->158582298],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "5"}], ";", 
  RowBox[{"count", "=", "0"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Dynamic", "[", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"count", "<", "4"}], ",", 
    RowBox[{"Refresh", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"count", "++"}], ";", 
       RowBox[{"SystemDialogInput", "[", "\"\<FileSave\>\"", "]"}]}], ",", 
      RowBox[{"UpdateInterval", "\[Rule]", "n"}]}], "]"}]}], "]"}], 
  "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->82980740],

Cell[BoxData[
 DynamicBox[ToBoxes[
   If[$CellContext`count < 4, 
    Refresh[
    Increment[$CellContext`count]; SystemDialogInput["FileSave"], 
     UpdateInterval -> $CellContext`n]], StandardForm],
  ImageSizeCache->{540.25, {2., 8.}}]], "Output",
 ImageSize->{545, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1420749235]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->35309874],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FileNameSetter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FileNameSetter"]], "InlineFormula"],
 " also opens and saves files, but waits for a click from the user:"
}], "ExampleText",
 CellID->563150513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SystemDialogInput", "[", "\"\<FileSave\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->615053],

Cell[BoxData["$Canceled"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->310077725]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNameSetter", "[", 
  RowBox[{"\"\<\>\"", ",", "\"\<Save\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->94751382],

Cell[BoxData[
 DynamicModuleBox[{Typeset`var$$ = ""}, 
  InterpretationBox[
   ButtonBox["\<\"Browse\[Ellipsis]\"\>",
    Appearance->"DialogBox",
    ButtonData->"paclet:ref/Browse\[Ellipsis]",
    ButtonFrame->"DialogBox",
    ButtonFunction:>DynamicDump`fnsButtonFunction[
     Typeset`var$$, "Save", Automatic, Automatic],
    Enabled->Automatic,
    Evaluator->Automatic,
    ImageMargins->0,
    ImageSize->Automatic,
    Method->"Queued"],
   FileNameSetter[
    Dynamic[Typeset`var$$], "Save", Automatic]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{58, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->73975395]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21911],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorSetter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorSetter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileNameSetter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileNameSetter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DialogInput",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogInput"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9492]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->710428246],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->78642834],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->516349569],

Cell[TextData[ButtonBox["Dialog Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DialogBoxes"]], "MoreAbout",
 CellID->16673684],

Cell[TextData[ButtonBox["Sound and Sonification",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SoundAndSonification"]], "MoreAbout",
 CellID->32225036]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SystemDialogInput - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 46.0966336}", "context" -> "System`", 
    "keywords" -> {
     "recorded sound", "voice recording", "sound recording", "color picker", 
      "color selector", "system colors", "file browser", "file open dialog", 
      "file dialog", "save dialog", "open dialog", "system dialogs"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SystemDialogInput[\"type\"] brings up an interactive system dialog and \
returns the value chosen in the dialog. SystemDialogInput[\"type\", init] \
uses init as the initial setting in the dialog.", 
    "synonyms" -> {"system dialog input"}, "title" -> "SystemDialogInput", 
    "type" -> "Symbol", "uri" -> "ref/SystemDialogInput"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8788, 268, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->517318415]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 178155, 3315}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1856, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2479, 70, 1582, 37, 70, "ObjectNameGrid"],
Cell[4064, 109, 1034, 30, 70, "Usage",
 CellID->25679]
}, Open  ]],
Cell[CellGroupData[{
Cell[5135, 144, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5613, 161, 56, 1, 70, "Notes",
 CellID->28053],
Cell[5672, 164, 806, 17, 70, "2ColumnTableMod",
 CellID->13043],
Cell[6481, 183, 330, 11, 70, "Notes",
 CellID->14522],
Cell[6814, 196, 353, 13, 70, "Notes",
 CellID->31088],
Cell[7170, 211, 225, 8, 70, "Notes",
 CellID->1563],
Cell[7398, 221, 1353, 42, 70, "Notes",
 CellID->464057776]
}, Closed]],
Cell[CellGroupData[{
Cell[8788, 268, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->517318415],
Cell[CellGroupData[{
Cell[9173, 282, 148, 5, 70, "ExampleSection",
 CellID->191987748],
Cell[9324, 289, 115, 3, 70, "ExampleText",
 CellID->635823803],
Cell[CellGroupData[{
Cell[9464, 296, 125, 3, 28, "Input",
 CellID->284006766],
Cell[9592, 301, 234, 7, 36, "Output",
 CellID->105759617]
}, Open  ]],
Cell[9841, 311, 125, 3, 70, "ExampleDelimiter",
 CellID->107893939],
Cell[9969, 316, 123, 3, 70, "ExampleText",
 CellID->356398019],
Cell[CellGroupData[{
Cell[10117, 323, 128, 3, 70, "Input",
 CellID->341078619],
Cell[10248, 328, 210, 5, 36, "Output",
 CellID->549675212]
}, Open  ]],
Cell[10473, 336, 125, 3, 70, "ExampleDelimiter",
 CellID->349608669],
Cell[10601, 341, 81, 1, 70, "ExampleText",
 CellID->110098015],
Cell[CellGroupData[{
Cell[10707, 346, 130, 3, 70, "Input",
 CellID->67404566],
Cell[10840, 351, 158958, 2652, 70, "Output",
 CellID->275715629]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[169847, 3009, 219, 7, 70, "ExampleSection",
 CellID->46076243],
Cell[170069, 3018, 77, 1, 70, "ExampleText",
 CellID->120706219],
Cell[CellGroupData[{
Cell[170171, 3023, 161, 4, 70, "Input",
 CellID->150848903],
Cell[170335, 3029, 166, 5, 36, "Output",
 CellID->649046064]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[170550, 3040, 222, 7, 70, "ExampleSection",
 CellID->110774114],
Cell[CellGroupData[{
Cell[170797, 3051, 232, 7, 70, "ExampleSubsection",
 CellID->111390343],
Cell[171032, 3060, 73, 1, 70, "ExampleText",
 CellID->1684379],
Cell[CellGroupData[{
Cell[171130, 3065, 218, 6, 70, "Input",
 CellID->624758095],
Cell[171351, 3073, 167, 5, 36, "Output",
 CellID->1447754535]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[171579, 3085, 227, 7, 70, "ExampleSection",
 CellID->325637341],
Cell[171809, 3094, 184, 6, 70, "ExampleText",
 CellID->158582298],
Cell[CellGroupData[{
Cell[172018, 3104, 521, 16, 70, "Input",
 CellID->82980740],
Cell[172542, 3122, 383, 11, 70, "Output",
 CellID->1420749235]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[172974, 3139, 236, 7, 70, "ExampleSection",
 CellID->35309874],
Cell[173213, 3148, 254, 7, 70, "ExampleText",
 CellID->563150513],
Cell[CellGroupData[{
Cell[173492, 3159, 125, 3, 70, "Input",
 CellID->615053],
Cell[173620, 3164, 166, 5, 36, "Output",
 CellID->310077725]
}, Open  ]],
Cell[CellGroupData[{
Cell[173823, 3174, 150, 4, 70, "Input",
 CellID->94751382],
Cell[173976, 3180, 682, 21, 70, "Output",
 CellID->73975395]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[174719, 3208, 311, 9, 70, "SeeAlsoSection",
 CellID->21911],
Cell[175033, 3219, 719, 26, 70, "SeeAlso",
 CellID->9492]
}, Open  ]],
Cell[CellGroupData[{
Cell[175789, 3250, 319, 9, 70, "MoreAboutSection",
 CellID->710428246],
Cell[176111, 3261, 140, 3, 70, "MoreAbout",
 CellID->78642834],
Cell[176254, 3266, 168, 3, 70, "MoreAbout",
 CellID->516349569],
Cell[176425, 3271, 134, 3, 70, "MoreAbout",
 CellID->16673684],
Cell[176562, 3276, 153, 3, 70, "MoreAbout",
 CellID->32225036]
}, Open  ]],
Cell[176730, 3282, 27, 0, 70, "History"],
Cell[176760, 3284, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

