(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    536780,      10875]
NotebookOptionsPosition[    520671,      10324]
NotebookOutlinePosition[    522340,      10365]
CellTagsIndexPosition[    522252,      10360]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Views" :> 
          Documentation`HelpLookup["paclet:tutorial/Views"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Views\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SlideView" :> Documentation`HelpLookup["paclet:ref/SlideView"],
           "MenuView" :> Documentation`HelpLookup["paclet:ref/MenuView"], 
          "FlipView" :> Documentation`HelpLookup["paclet:ref/FlipView"], 
          "PopupView" :> Documentation`HelpLookup["paclet:ref/PopupView"], 
          "OpenerView" :> Documentation`HelpLookup["paclet:ref/OpenerView"], 
          "Manipulate" :> Documentation`HelpLookup["paclet:ref/Manipulate"], 
          "PaneSelector" :> 
          Documentation`HelpLookup["paclet:ref/PaneSelector"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SlideView\"\>", 
       2->"\<\"MenuView\"\>", 3->"\<\"FlipView\"\>", 4->"\<\"PopupView\"\>", 
       5->"\<\"OpenerView\"\>", 6->"\<\"Manipulate\"\>", 
       7->"\<\"PaneSelector\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Click-Interactive Panels" :> 
          Documentation`HelpLookup["paclet:guide/ClickInteractivePanels"], 
          "Creating Inspectors" :> 
          Documentation`HelpLookup["paclet:guide/CreatingInspectors"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], "Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"], 
          "Layout & Tables" :> 
          Documentation`HelpLookup["paclet:guide/LayoutAndTables"], 
          "Notebook Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookFormattingAndStyling"], "Palettes" :> 
          Documentation`HelpLookup["paclet:guide/Palettes"], 
          "Presentations with Mathematica " :> 
          Documentation`HelpLookup[
           "paclet:guide/PresentationsWithMathematica"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"], 
          "Viewers and Annotation" :> 
          Documentation`HelpLookup["paclet:guide/ViewersAndAnnotation"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"], 
          "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Annotating & Combining Graphics\"\>", 
       2->"\<\"Click-Interactive Panels\"\>", 
       3->"\<\"Creating Inspectors\"\>", 
       4->"\<\"Custom Interface Construction\"\>", 
       5->"\<\"Document Generation\"\>", 6->"\<\"Dynamic Visualization\"\>", 
       7->"\<\"Layout & Tables\"\>", 
       8->"\<\"Notebook Formatting & Styling\"\>", 9->"\<\"Palettes\"\>", 
       10->"\<\"Presentations with Mathematica \"\>", 
       11->"\<\"Stand-Alone Interfaces\"\>", 
       12->"\<\"User Interface Structuring & Layout\"\>", 
       13->"\<\"Viewers and Annotation\"\>", 
       14->"\<\"New in 6.0: Dynamic Interactivity\"\>", 
       15->"\<\"New in 6.0: Formatting & Styling\"\>", 
       16->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["TabView", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TabView",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TabView"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["lbl", "TI"], 
           StyleBox["1", "TR"]], "->", 
          SubscriptBox[
           StyleBox["expr", "TI"], 
           StyleBox["1", "TR"]]}], ",", " ", 
         RowBox[{
          SubscriptBox[
           StyleBox["lbl", "TI"], 
           StyleBox["2", "TR"]], "->", 
          SubscriptBox[
           StyleBox["expr", "TI"], 
           StyleBox["2", "TR"]]}], ",", " ", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents an object in which clicking the tab with \
label ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " displays ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TabView",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TabView"], "[", 
       RowBox[{
        StyleBox[
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SubscriptBox[
             StyleBox["lbl", "TI"], 
             StyleBox["1", "TR"]], "->", 
            SubscriptBox[
             StyleBox["expr", "TI"], 
             StyleBox["1", "TR"]]}], ",", " ", 
           RowBox[{
            SubscriptBox[
             StyleBox["lbl", "TI"], 
             StyleBox["2", "TR"]], "->", 
            SubscriptBox[
             StyleBox["expr", "TI"], 
             StyleBox["2", "TR"]]}], ",", " ", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], "TI"], ",", 
        StyleBox["i", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]makes the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " tab be the one currently selected."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TabView",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TabView"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["v", "TI"], 
             StyleBox["1", "TR"]], ",", 
            RowBox[{
             SubscriptBox[
              StyleBox["lbl", "TI"], 
              StyleBox["1", "TR"]], "->", 
             SubscriptBox[
              StyleBox["expr", "TI"], 
              StyleBox["1", "TR"]]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["v", "TI"], 
             StyleBox["2", "TR"]], ",", 
            RowBox[{
             SubscriptBox[
              StyleBox["lbl", "TI"], 
              StyleBox["2", "TR"]], "->", 
             SubscriptBox[
              StyleBox["expr", "TI"], 
              StyleBox["2", "TR"]]}]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]associates values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " with successive tabs, and makes the tab with value ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     " be the one currently selected. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TabView",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TabView"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]takes the tab labels to be successive integers."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->10106]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["TabView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TabView"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{
     ButtonBox["Dynamic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dynamic"], "[", 
     StyleBox["s", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 " takes the selected tab to be specified by the dynamically updated current \
value of ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 ", with the value of ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " being reset if a different tab is selected."
}], "Notes",
 CellID->19271],

Cell["The following options can be given: ", "Notes",
 CellID->12368],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Alignment",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Alignment"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"], ",", 
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]}], "}"}], Cell[
    "how to align objects in the display area ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to align with a surrounding text baseline ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[TextData[{
     "base style specifications for the ",
     Cell[BoxData[
      ButtonBox["TabView",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TabView"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ControlPlacement",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ControlPlacement"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"], ",", 
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"]}], "}"}], Cell[
    "where to place the tabs ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the tabs are enabled, or grayed out ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameMargins"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "margins inside the overall frame ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the display area ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "the overall image size for the display area", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LabelStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LabelStyle"], 
    RowBox[{"{", "}"}], Cell[
    "style specifications for the tab area", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True, True}}}},
 CellID->6421],

Cell[TextData[{
 "With the default option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 " always leaves space for the largest of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " to be displayed, so that its overall size does not change.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->30642317]
}], "Notes",
 CellID->15258],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 " leaves space only for the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " currently being displayed. "
}], "Notes",
 CellID->4157],

Cell[TextData[{
 "If any of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ", the corresponding tabs are left blank. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->26336679,
  ButtonNote->"26336679"]
}], "Notes",
 CellID->9647],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 " by default displays the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in ",
 Cell[BoxData["\"\<TabViewLabel\>\""], "InlineFormula"],
 " style, which typically uses the system button font. "
}], "Notes",
 CellID->18238],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " are appended to the default styles typically given by the ",
 Cell[BoxData["\"\<TabView\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<TabViewLabel\>\""], "InlineFormula"],
 " styles in the current stylesheet. "
}], "Notes",
 CellID->55815475]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->186840660],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->510385226],

Cell["Use default labels for tabs: ", "ExampleText",
 CellID->16825415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->151410181],

Cell[BoxData[
 TabViewBox[{{1,"1"->"a"}, {2,"2"->"b"}, {3,"3"->"c"}, {4,"4"->"d"}}, 
  1]], "Output",
 ImageSize->{94, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->537101427]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->195750396],

Cell["Insert labels for each element:", "ExampleText",
 CellID->525694706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "a"}], ",", 
    RowBox[{"y", "\[Rule]", "b"}], ",", 
    RowBox[{"z", "\[Rule]", "c"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->209729007],

Cell[BoxData[
 TabViewBox[{{1,"x"->"a"}, {2,"y"->"b"}, {3,"z"->"c"}}, 1]], "Output",
 ImageSize->{69, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->212164121]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31550],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TabView Content",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->65322756],

Cell[TextData[{
 "Use graphics as content in ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->65650879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"n", " ", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234501074],

Cell[BoxData[
 TabViewBox[{{1,"1"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt1nc4le//AHAjsjLOMco456CQiqYiH++btpQokqRCUmaiKA0lQjIioyIi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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.9999993680039507, 0.9999995755730018}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {2,"2"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVmnc8Vf8fx+2yN+EaF6kkyjdK6/NOGkbDTGZ2IaMyihaVHamEQkoRUUoL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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.999999941761652, 0.9999995837354044}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {3,"3"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwU23k8VG8XAHB7shuyMyaFStqkUnoOlSIqQiUplBZLtIekUrKUJVsIKb/I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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.9999996187787015, 0.9999994313041395}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {4,"4"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwU23c8ld8fAHB7K5fL5RppShkRTTmflFQkDVoqpLKS0VBpoUGRSArZCl9J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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.9999992328657719, 0.9999997588489247}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {5,"5"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUmnk8lM8fwN33sdaxLAldEkmH+CqfqQilkrNDKiJHhEqSdFBEziRRpFSS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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.9999999574404889, 0.9999976139198089}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}}, 1]], "Output",
 ImageSize->{198, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->434079331]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->469059840],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 " can contain any expression, including ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->348170879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{"i", ",", 
     RowBox[{"i", "->", 
      RowBox[{"Manipulate", "[", 
       RowBox[{
        RowBox[{"Expand", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "+", "i"}], ")"}], "^", "j"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "1", ",", "4", ",", "1"}], "}"}]}], "]"}]}]}], 
    "]"}], "/@", 
   RowBox[{"Range", "[", "5", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->320019421],

Cell[BoxData[
 TabViewBox[{{1,"1"->
  TagBox[
   StyleBox[
    DynamicModuleBox[{$CellContext`j$$ = 1, Typeset`show$$ = True, 
     Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
     Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
     "\"untitled\"", Typeset`specs$$ = {{
       Hold[$CellContext`j$$], 1, 4, 1}}, Typeset`size$$ = {
     27.3125, {0., 8.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
     Typeset`skipInitDone$$ = True, $CellContext`j$887$$ = 0}, 
     DynamicBox[Manipulate`ManipulateBoxes[
      1, StandardForm, "Variables" :> {$CellContext`j$$ = 1}, 
       "ControllerVariables" :> {
         Hold[$CellContext`j$$, $CellContext`j$887$$, 0]}, 
       "OtherVariables" :> {
        Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
         Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
         Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
         Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
       Expand[($CellContext`x + 1)^$CellContext`j$$], 
       "Specifications" :> {{$CellContext`j$$, 1, 4, 1}}, "Options" :> {}, 
       "DefaultOptions" :> {}],
      ImageSizeCache->{247., {48., 53.}},
      SingleEvaluation->True],
     Deinitialization:>None,
     DynamicModuleValues:>{},
     SynchronousInitialization->True,
     UnsavedVariables:>{Typeset`initDone$$},
     UntrackedVariables:>{Typeset`size$$}], "Manipulate",
    Deployed->True,
    StripOnInput->False],
   Manipulate`InterpretManipulate[1]]}, {2,"2"->
  TagBox[
   StyleBox[
    DynamicModuleBox[{$CellContext`j$$ = 1, Typeset`show$$ = True, 
     Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
     Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
     "\"untitled\"", Typeset`specs$$ = {{
       Hold[$CellContext`j$$], 1, 4, 1}}, Typeset`size$$ = {26.625, {0., 8.}},
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
     True, $CellContext`j$904$$ = 0}, 
     DynamicBox[Manipulate`ManipulateBoxes[
      1, StandardForm, "Variables" :> {$CellContext`j$$ = 1}, 
       "ControllerVariables" :> {
         Hold[$CellContext`j$$, $CellContext`j$904$$, 0]}, 
       "OtherVariables" :> {
        Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
         Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
         Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
         Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
       Expand[($CellContext`x + 2)^$CellContext`j$$], 
       "Specifications" :> {{$CellContext`j$$, 1, 4, 1}}, "Options" :> {}, 
       "DefaultOptions" :> {}],
      ImageSizeCache->{247., {48., 53.}},
      SingleEvaluation->True],
     Deinitialization:>None,
     DynamicModuleValues:>{},
     SynchronousInitialization->True,
     UnsavedVariables:>{Typeset`initDone$$},
     UntrackedVariables:>{Typeset`size$$}], "Manipulate",
    Deployed->True,
    StripOnInput->False],
   Manipulate`InterpretManipulate[1]]}, {3,"3"->
  TagBox[
   StyleBox[
    DynamicModuleBox[{$CellContext`j$$ = 1, Typeset`show$$ = True, 
     Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
     Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
     "\"untitled\"", Typeset`specs$$ = {{
       Hold[$CellContext`j$$], 1, 4, 1}}, Typeset`size$$ = {26.625, {0., 8.}},
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
     True, $CellContext`j$921$$ = 0}, 
     DynamicBox[Manipulate`ManipulateBoxes[
      1, StandardForm, "Variables" :> {$CellContext`j$$ = 1}, 
       "ControllerVariables" :> {
         Hold[$CellContext`j$$, $CellContext`j$921$$, 0]}, 
       "OtherVariables" :> {
        Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
         Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
         Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
         Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
       Expand[($CellContext`x + 3)^$CellContext`j$$], 
       "Specifications" :> {{$CellContext`j$$, 1, 4, 1}}, "Options" :> {}, 
       "DefaultOptions" :> {}],
      ImageSizeCache->{247., {48., 53.}},
      SingleEvaluation->True],
     Deinitialization:>None,
     DynamicModuleValues:>{},
     SynchronousInitialization->True,
     UnsavedVariables:>{Typeset`initDone$$},
     UntrackedVariables:>{Typeset`size$$}], "Manipulate",
    Deployed->True,
    StripOnInput->False],
   Manipulate`InterpretManipulate[1]]}, {4,"4"->
  TagBox[
   StyleBox[
    DynamicModuleBox[{$CellContext`j$$ = 1, Typeset`show$$ = True, 
     Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
     Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
     "\"untitled\"", Typeset`specs$$ = {{
       Hold[$CellContext`j$$], 1, 4, 1}}, Typeset`size$$ = {26.625, {0., 8.}},
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
     True, $CellContext`j$938$$ = 0}, 
     DynamicBox[Manipulate`ManipulateBoxes[
      1, StandardForm, "Variables" :> {$CellContext`j$$ = 1}, 
       "ControllerVariables" :> {
         Hold[$CellContext`j$$, $CellContext`j$938$$, 0]}, 
       "OtherVariables" :> {
        Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
         Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
         Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
         Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
       Expand[($CellContext`x + 4)^$CellContext`j$$], 
       "Specifications" :> {{$CellContext`j$$, 1, 4, 1}}, "Options" :> {}, 
       "DefaultOptions" :> {}],
      ImageSizeCache->{247., {48., 53.}},
      SingleEvaluation->True],
     Deinitialization:>None,
     DynamicModuleValues:>{},
     SynchronousInitialization->True,
     UnsavedVariables:>{Typeset`initDone$$},
     UntrackedVariables:>{Typeset`size$$}], "Manipulate",
    Deployed->True,
    StripOnInput->False],
   Manipulate`InterpretManipulate[1]]}, {5,"5"->
  TagBox[
   StyleBox[
    DynamicModuleBox[{$CellContext`j$$ = 1, Typeset`show$$ = True, 
     Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
     Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
     "\"untitled\"", Typeset`specs$$ = {{
       Hold[$CellContext`j$$], 1, 4, 1}}, Typeset`size$$ = {26.625, {0., 8.}},
      Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
     True, $CellContext`j$955$$ = 0}, 
     DynamicBox[Manipulate`ManipulateBoxes[
      1, StandardForm, "Variables" :> {$CellContext`j$$ = 1}, 
       "ControllerVariables" :> {
         Hold[$CellContext`j$$, $CellContext`j$955$$, 0]}, 
       "OtherVariables" :> {
        Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
         Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
         Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
         Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
       Expand[($CellContext`x + 5)^$CellContext`j$$], 
       "Specifications" :> {{$CellContext`j$$, 1, 4, 1}}, "Options" :> {}, 
       "DefaultOptions" :> {}],
      ImageSizeCache->{247., {48., 53.}},
      SingleEvaluation->True],
     Deinitialization:>None,
     DynamicModuleValues:>{},
     SynchronousInitialization->True,
     UnsavedVariables:>{Typeset`initDone$$},
     UntrackedVariables:>{Typeset`size$$}], "Manipulate",
    Deployed->True,
    StripOnInput->False],
   Manipulate`InterpretManipulate[1]]}}, 1]], "Output",
 ImageSize->{265, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100159105]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->180064722],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 " can be nested:"
}], "ExampleText",
 CellID->114039437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"TabView", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}], ",", 
    RowBox[{"TabView", "[", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21436876],

Cell[BoxData[
 TabViewBox[{{1,"1"->
  TabViewBox[{{1,"1"->"a"}, {2,"2"->"b"}, {3,"3"->"c"}}, 1]}, {2,"2"->
  TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}}, 1]}}, 1]], "Output",
 ImageSize->{87, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->175205293]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->781651386],

Cell["Use any expression as a label:", "ExampleText",
 CellID->802119663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "^", "n"}], "]"}], "->", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"x", "^", "n"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10642826],

Cell[BoxData[
 TabViewBox[{{1,
  RowBox[{"Sin", "[", "x", "]"}]->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwt12k4Vd3bAHBCCZWzT4MeMkRINEsD3QtpECqJChWiqKSBPGjCo8icqVJU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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 5}, {-0.999999949169892, 0.9999998405767353}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {2,
  RowBox[{"Sin", "[", 
   SuperscriptBox["x", "2"], "]"}]->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVmnk4VV8Xx13z7A6kXyFFKqSIQmXtTGVKKZWSKWOhUBFKg6QylJKpUAgV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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 5}, {-0.9999996433138382, 0.9999995664999897}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {3,
  RowBox[{"Sin", "[", 
   SuperscriptBox["x", "3"], "]"}]->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUWnc81d8bx+Ve1yipb0NlpyWhUgnPSQmllKxKioZVaEmJZJbsXcmIIqRI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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 5}, {-0.9999999735683098, 0.9999998509371182}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {4,
  RowBox[{"Sin", "[", 
   SuperscriptBox["x", "4"], "]"}]->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUmHc81d8fx6+7Kg2SFiVFFAkNSeV9hFJUiKSEr8xkZCUZSWWXZKWENIQy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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 5}, {-0.9999999919858921, 0.9999997908595613}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {5,
  RowBox[{"Sin", "[", 
   SuperscriptBox["x", "5"], "]"}]->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwUWnc81d8bv0OFhFAkRUYos+Kr4T4fSRFKVipUMkukIqSUlBJlk8yMZGQr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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 5}, {-0.9999993312789788, 0.9999939748798661}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}}, 1]], "Output",
 ImageSize->{254, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114918723]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->659640314],

Cell["Use strings as labels:", "ExampleText",
 CellID->262312057],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\"\<first tab\>\"", "\[Rule]", "x"}], ",", 
    RowBox[{"\"\<second tab\>\"", "\[Rule]", "y"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->563881299],

Cell[BoxData[
 TabViewBox[{{1,"\<\"first tab\"\>"->"x"}, {2,"\<\"second tab\"\>"->"y"}}, 
  1]], "Output",
 ImageSize->{141, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->352757376]
}, Open  ]],

Cell["Put the labels into text style:", "ExampleText",
 CellID->282026514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"Text", "[", "\"\<first tab\>\"", "]"}], "\[Rule]", "x"}], ",", 
    RowBox[{
     RowBox[{"Text", "[", "\"\<second tab\>\"", "]"}], "\[Rule]", "y"}]}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->59021132],

Cell[BoxData[
 TabViewBox[{{1,
  InterpretationBox[Cell[BoxData["\<\"first tab\"\>"], "Text", "TR"],
   Text["first tab"]]->"x"}, {2,
  InterpretationBox[Cell[BoxData["\<\"second tab\"\>"], "Text", "TR"],
   Text["second tab"]]->"y"}}, 1]], "Output",
 ImageSize->{127, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83170510]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->192611516],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " to indicate a blank tab label:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->26336679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Null", "\[Rule]", "a"}], ",", 
    RowBox[{"x", "\[Rule]", "b"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->705204461],

Cell[BoxData[
 TabViewBox[{{1,""->"a"}, {2,"x"->"b"}}, 1]], "Output",
 ImageSize->{48, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87398853]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->893102692],

Cell[TextData[{
 "By default, a ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 " leaves enough space to display without ever resizing:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->30642317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Disk", "[", "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "20", ",", "50", ",", "10"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45283626],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[DiskBox[{0, 0}],
    ImageSize->20], ",", 
   GraphicsBox[DiskBox[{0, 0}],
    ImageSize->30], ",", 
   GraphicsBox[DiskBox[{0, 0}],
    ImageSize->40], ",", 
   GraphicsBox[DiskBox[{0, 0}],
    ImageSize->50]}], "}"}]], "Output",
 ImageSize->{192, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->349450020]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TabView", "[", "d", "]"}], ",", 
   RowBox[{"TabView", "[", 
    RowBox[{"d", ",", "4"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->137908413],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TabViewBox[{{1,"1"->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->20]}, {2,"2"->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->30]}, {3,"3"->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->40]}, {4,"4"->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->50]}}, 1], ",", 
   TabViewBox[{{1,"1"->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->20]}, {2,"2"->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->30]}, {3,"3"->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->40]}, {4,"4"->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->50]}}, 4]}], "}"}]], "Output",
 ImageSize->{210, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->169930293]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImageSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImageSize"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 " resizes for each pane:"
}], "ExampleText",
 CellID->650749372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TabView", "[", 
    RowBox[{"d", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Automatic"}]}], "]"}], ",", 
   RowBox[{"TabView", "[", 
    RowBox[{"d", ",", "4", ",", 
     RowBox[{"ImageSize", "\[Rule]", "Automatic"}]}], "]"}]}], "}"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->908772701],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TabViewBox[{{1,"1"->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->20]}, {2,"2"->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->30]}, {3,"3"->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->40]}, {4,"4"->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->50]}}, 1,
    ImageSize->Automatic], ",", 
   TabViewBox[{{1,"1"->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->20]}, {2,"2"->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->30]}, {3,"3"->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->40]}, {4,"4"->
    GraphicsBox[DiskBox[{0, 0}],
     ImageSize->50]}}, 4,
    ImageSize->Automatic]}], "}"}]], "Output",
 ImageSize->{210, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->226654514]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TabView Control",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->103229521],

Cell["Start with tab 2 selected:", "ExampleText",
 CellID->65388748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11064820],

Cell[BoxData[
 TabViewBox[{{1,"1"->"a"}, {2,"2"->"b"}, {3,"3"->"c"}, {4,"4"->"d"}}, 
  2]], "Output",
 ImageSize->{94, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->133644211]
}, Open  ]],

Cell[TextData[{
 "Select the tab with value ",
 Cell[BoxData["v"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->106918330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{"x", "\[Rule]", "a"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", 
       RowBox[{"y", "\[Rule]", "b"}]}], "}"}]}], "}"}], ",", "v"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->47666740],

Cell[BoxData[
 TabViewBox[{{$CellContext`u,"x"->"a"}, {$CellContext`v,"y"->
  "b"}}, $CellContext`v]], "Output",
 ImageSize->{50, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->287943802]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->615667952],

Cell["By default the setting is based on position:", "ExampleText",
 CellID->990233478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TabView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"Dynamic", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->117265673],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TabViewBox[{{1,"1"->"a"}, {2,"2"->"b"}, {3,"3"->"c"}}, 
    Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{4, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->130483655]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TabView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\"\<a\>\"", "->", "a"}], ",", 
       RowBox[{"\"\<b\>\"", "->", "b"}], ",", 
       RowBox[{"\"\<c\>\"", "->", "c"}]}], "}"}], ",", 
     RowBox[{"Dynamic", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->181962849],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TabViewBox[{{1,"\<\"a\"\>"->"a"}, {2,"\<\"b\"\>"->"b"}, {3,"\<\"c\"\>"->
    "c"}}, Dynamic[$CellContext`x]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{104, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->113165179]
}, Open  ]],

Cell[TextData[{
 "Use the ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    RowBox[{
     StyleBox["lab", "TI"], "->", 
     StyleBox["expr", "TI"]}]}], "}"}]], "InlineFormula"],
 " to have ",
 Cell[BoxData[
  FormBox["u", TraditionalForm]], "InlineMath"],
 " be the setting:"
}], "ExampleText",
 CellID->280573160],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TabView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", 
         RowBox[{"\"\<a\>\"", "->", "a"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"v", ",", 
         RowBox[{"\"\<b\>\"", "->", "b"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"w", ",", 
         RowBox[{"\"\<c\>\"", "->", "c"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"Dynamic", "[", "y", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->703175254],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TabViewBox[{{$CellContext`u,"\<\"a\"\>"->"a"}, {$CellContext`v,"\<\"b\"\>"->
    "b"}, {$CellContext`w,"\<\"c\"\>"->"c"}}, Dynamic[$CellContext`y]], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{4, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->164625343]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19430716],

Cell[TextData[{
 "Connect a ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 " to a slider:"
}], "ExampleText",
 CellID->57496222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TabView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
     RowBox[{"Dynamic", "[", "i", "]"}]}], "]"}], ",", 
   RowBox[{"Slider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "i", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "1"}], "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->573400473],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TabViewBox[{{1,"1"->"a"}, {2,"2"->"b"}, {3,"3"->"c"}, {4,"4"->"d"}}, 
    Dynamic[$CellContext`i]], ",", 
   SliderBox[Dynamic[$CellContext`i], {1, 4, 1}]}], "}"}]], "Output",
 ImageSize->{4, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->241250609]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->117217923],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " to replace dynamically scoped variables: "
}], "ExampleText",
 CellID->265866031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", "j", "}"}], ",", 
   RowBox[{"TabView", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"With", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"i", "=", "i"}], "}"}], ",", 
         RowBox[{
          RowBox[{"Graphics", "[", 
           RowBox[{
            RowBox[{"Dynamic", "[", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{"i", "===", "j"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Disk", "[", "]"}], ",", "White", ",", 
                 RowBox[{"Inset", "[", "i", "]"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Circle", "[", "]"}], ",", 
                 RowBox[{"Inset", "[", "i", "]"}]}], "}"}]}], "]"}], "]"}], 
            ",", 
            RowBox[{"ImageSize", "\[Rule]", "25"}], ",", 
            RowBox[{"PlotRangePadding", "\[Rule]", ".5"}]}], "]"}], "\[Rule]",
           
          RowBox[{"i", "!"}]}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Dynamic", "[", "j", "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70540783],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`j$$ = 1}, 
  TabViewBox[{{1,
   GraphicsBox[
    DynamicBox[Typeset`ToBoxes[
      If[1 === $CellContext`j$$, {
        Disk[], White, 
        Inset[1]}, {
        Circle[], 
        Inset[1]}], StandardForm, Graphics],
     ImageSizeCache->{{4., 20.}, {-11., 5.}}],
    ImageSize->25,
    PlotRangePadding->0.5]->"1"}, {2,
   GraphicsBox[
    DynamicBox[Typeset`ToBoxes[
      If[2 === $CellContext`j$$, {
        Disk[], White, 
        Inset[2]}, {
        Circle[], 
        Inset[2]}], StandardForm, Graphics],
     ImageSizeCache->{{3., 21.}, {-12., 6.}}],
    ImageSize->25,
    PlotRangePadding->0.5]->"2"}, {3,
   GraphicsBox[
    DynamicBox[Typeset`ToBoxes[
      If[3 === $CellContext`j$$, {
        Disk[], White, 
        Inset[3]}, {
        Circle[], 
        Inset[3]}], StandardForm, Graphics],
     ImageSizeCache->{{3., 21.}, {-12., 6.}}],
    ImageSize->25,
    PlotRangePadding->0.5]->"6"}, {4,
   GraphicsBox[
    DynamicBox[Typeset`ToBoxes[
      If[4 === $CellContext`j$$, {
        Disk[], White, 
        Inset[4]}, {
        Circle[], 
        Inset[4]}], StandardForm, Graphics],
     ImageSizeCache->{{3., 21.}, {-12., 6.}}],
    ImageSize->25,
    PlotRangePadding->0.5]->"24"}, {5,
   GraphicsBox[
    DynamicBox[Typeset`ToBoxes[
      If[5 === $CellContext`j$$, {
        Disk[], White, 
        Inset[5]}, {
        Circle[], 
        Inset[5]}], StandardForm, Graphics],
     ImageSizeCache->{{3., 21.}, {-12., 6.}}],
    ImageSize->25,
    PlotRangePadding->0.5]->"120"}}, Dynamic[$CellContext`j$$]],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{205, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18788482]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->874938568],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Alignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->301135293],

Cell["A list of objects:", "ExampleText",
 CellID->31590325],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"Circle", "[", "]"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"s", ",", "20", ",", "50", ",", "10"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->361215],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->20], ",", 
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->30], ",", 
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->40], ",", 
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->50]}], "}"}]], "Output",
 ImageSize->{192, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35428128]
}, Open  ]],

Cell["Default alignments:", "ExampleText",
 CellID->545491469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", "d", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6255894],

Cell[BoxData[
 TabViewBox[{{1,"1"->
  GraphicsBox[CircleBox[{0, 0}],
   ImageSize->20]}, {2,"2"->
  GraphicsBox[CircleBox[{0, 0}],
   ImageSize->30]}, {3,"3"->
  GraphicsBox[CircleBox[{0, 0}],
   ImageSize->40]}, {4,"4"->
  GraphicsBox[CircleBox[{0, 0}],
   ImageSize->50]}}, 1]], "Output",
 ImageSize->{94, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->116411159]
}, Open  ]],

Cell["Control horizontal alignment only:", "ExampleText",
 CellID->262004834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"d", ",", 
   RowBox[{"Alignment", "\[Rule]", "Right"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->248438261],

Cell[BoxData[
 TabViewBox[{{1,"1"->
  GraphicsBox[CircleBox[{0, 0}],
   ImageSize->20]}, {2,"2"->
  GraphicsBox[CircleBox[{0, 0}],
   ImageSize->30]}, {3,"3"->
  GraphicsBox[CircleBox[{0, 0}],
   ImageSize->40]}, {4,"4"->
  GraphicsBox[CircleBox[{0, 0}],
   ImageSize->50]}}, 1,
  Alignment->Right]], "Output",
 ImageSize->{94, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->424167031]
}, Open  ]],

Cell["Control horizontal and vertical alignments:", "ExampleText",
 CellID->110911048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"d", ",", 
   RowBox[{"Alignment", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Center", ",", "Bottom"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->172983550],

Cell[BoxData[
 TabViewBox[{{1,"1"->
  GraphicsBox[CircleBox[{0, 0}],
   ImageSize->20]}, {2,"2"->
  GraphicsBox[CircleBox[{0, 0}],
   ImageSize->30]}, {3,"3"->
  GraphicsBox[CircleBox[{0, 0}],
   ImageSize->40]}, {4,"4"->
  GraphicsBox[CircleBox[{0, 0}],
   ImageSize->50]}}, 1,
  Alignment->{Center, Bottom}]], "Output",
 ImageSize->{94, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->248738850]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->28933812],

Cell["By default, tabs must be clicked to change the view:", "ExampleText",
 CellID->91248922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->357476191],

Cell[BoxData[
 TabViewBox[{{1,"1"->"a"}, {2,"2"->"b"}, {3,"3"->"c"}}, 1]], "Output",
 ImageSize->{73, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26378933]
}, Open  ]],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AutoAction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AutoAction"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", moving the mouse over tabs changes the view:"
}], "ExampleText",
 CellID->195982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"AutoAction", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->174211887],

Cell[BoxData[
 TabViewBox[{{1,"1"->"a"}, {2,"2"->"b"}, {3,"3"->"c"}}, 1,
  AutoAction->True]], "Output",
 ImageSize->{73, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->46101955]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->23597860],

Cell["Align with text:", "ExampleText",
 CellID->4462834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"TabView", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->251898344],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
    BaselinePosition->Top], "xxx", 
   TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
    BaselinePosition->Center], "xxx", 
   TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
    BaselinePosition->Bottom]}],
  Row[{
    TabView[{$CellContext`x, $CellContext`y, $CellContext`z}, 
     BaselinePosition -> Top], 
    TabView[{$CellContext`x, $CellContext`y, $CellContext`z}, 
     BaselinePosition -> Center], 
    TabView[{$CellContext`x, $CellContext`y, $CellContext`z}, 
     BaselinePosition -> Bottom]}, "xxx"]]], "Output",
 ImageSize->{265, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->302500079]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ControlPlacement",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->31338098],

Cell["Position the controls:", "ExampleText",
 CellID->254226910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"TabView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
     RowBox[{"ControlPlacement", "\[Rule]", "p"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"Top", ",", "Bottom", ",", "Left", ",", "Right"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88972026],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
    ControlPlacement->Top], ",", 
   TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
    ControlPlacement->Bottom], ",", 
   TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
    ControlPlacement->Left], ",", 
   TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
    ControlPlacement->Right]}], "}"}]], "Output",
 ImageSize->{272, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->357097848]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->17226113],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 " is enabled:"
}], "ExampleText",
 CellID->200884514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166164811],

Cell[BoxData[
 TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1]], "Output",
 ImageSize->{73, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->386794453]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->354279138],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 " is disabled, but visible in its current state:"
}], "ExampleText",
 CellID->487543105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->597916526],

Cell[BoxData[
 TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
  Enabled->False]], "Output",
 ImageSize->{73, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54256445]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->184605663],

Cell["Add margins within the view:", "ExampleText",
 CellID->61800453],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"TabView", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
     RowBox[{"FrameMargins", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10", ",", "20"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->306973721],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
    FrameMargins->0], ",", 
   TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
    FrameMargins->10], ",", 
   TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
    FrameMargins->20]}], "}"}]], "Output",
 ImageSize->{248, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->909580885]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->255922593],

Cell["Add margins outside the view:", "ExampleText",
 CellID->23083442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"TabView", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"ImageMargins", "\[Rule]", "m"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10", ",", "20"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53301849],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
     ImageMargins->0],
    StripOnInput->False], ",", 
   FrameBox[
    TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
     ImageMargins->10],
    StripOnInput->False], ",", 
   FrameBox[
    TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
     ImageMargins->20],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{338, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->223778969]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->281925],

Cell[TextData[{
 "Control the overall size of ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->559398874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"TabView", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"50", ",", "70", ",", "100"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"50", ",", "70", ",", "100"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->828399965],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
      ImageSize->{50, 50}], 
     TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
      ImageSize->{70, 50}], 
     TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
      ImageSize->{100, 50}]},
    {
     TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
      ImageSize->{50, 70}], 
     TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
      ImageSize->{70, 70}], 
     TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
      ImageSize->{100, 70}]},
    {
     TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
      ImageSize->{50, 100}], 
     TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
      ImageSize->{70, 100}], 
     TabViewBox[{{1,"1"->"x"}, {2,"2"->"y"}, {3,"3"->"z"}}, 1,
      ImageSize->{100, 100}]}
   }],
  "Grid"]], "Output",
 ImageSize->{259, 235},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->506177507]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "LabelStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->25485018],

Cell["Change the style of the labels:", "ExampleText",
 CellID->427831870],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "a"}], ",", 
     RowBox[{"y", "\[Rule]", "b"}], ",", 
     RowBox[{"z", "\[Rule]", "c"}]}], "}"}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Bold"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->509921512],

Cell[BoxData[
 TabViewBox[{{1,"x"->"a"}, {2,"y"->"b"}, {3,"z"->"c"}}, 1,
  LabelStyle->{
    RGBColor[1, 0, 0], Bold}]], "Output",
 ImageSize->{73, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->293279829]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19785],

Cell[TextData[{
 "Make a ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 " with pictures of Bessel functions:"
}], "ExampleText",
 CellID->588000828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"BesselJ", "[", 
       RowBox[{"n", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42918580],

Cell[BoxData[
 TabViewBox[{{1,"1"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1Xk41O/XB3BLZGmxzCCKGWQPlZRU5yglSxERQlJZIlsibfpG1oQSomix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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.3461261180190739, 0.581865061766651}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {2,"2"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c81P8fAHDb2SMZdyfjlBJKi0perxTJqkglFAppqJQRUSFkK6RJRWnQ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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.31353019895394485`, 0.48649847604027}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {3,"3"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VN8bB3B7hZhBUTEziqzxTSLUPKdEtkQlWVIke5uyJFuUkl3KlsgS
iUharNeWfZuxzyBlSUL2tfK7v39mXu/X3Hvuc8/5nOfeEbe5fvoKGwsLixz+
8f/vJF8brv22IVS9vMFbHlVOGjUdFANTiiNUnWRZz8vkoG7UlgdSKHfgaf6o
795MZSpf9Md87t4ACPIli391MaYmVYSROSnBEDP+y67vlS1V/rdt+IZ9BLwr
3Erul71NHeB78e9PTzSkH3Niy3S5R5V4tUVlbf0pmOiNG2u+CaG6HHG7ukyO
h7LZczeiXsVQ33cOpS9oPodc63Avon0Sdc3ZoH/WPhm+/nNzfyibTk1h7Q9e
1noJx1NiktV7sqnHW6Ikl3pSQeDPrwB9l3fU8bgTlQuO6XDp14pq/d6P1FDb
v5bz6xlw+eCu6tDsEup//71fmQ3LBJbE/OlH7JXUjnWHmBnya8gOdGj+kVFD
da8j/ff7XTa0H6Bmk2rqqTufdDZNaebA7WC93vErLdRyq8f2k125wG2XkuKv
S6PayCL2X/Z5cCvnsFKUTCeVbd2rbcE7H4z0/kmxm/ZQO4dMxBa03sFxwRMn
33cxqK9q/3Oe5ysAM9Sv4Pt6kOqZw1M011MAlgpLPBTnb1S96DGuuZT3YPr2
8cOJvGGqqGfl2VnHQsi58cGRV3KMOn3heeqM0geQMil3udU8Tq3Q9Jj5vf4B
hhMVJLZm/aJGy5ym/q75CBdPnV2vLZqm2vLvC50O+wSnR77vqGOdpW5ifpea
IheBnEOBl3faArW3osxtcrwIrL6OEDVSl6jZr+Kqf70rhlv+nn/7Klaohq6G
Fyc0S2Gcc+RqlPVfKuW8TO5P3jLgka5leTa6QZ07wrE+3lUGY7LG915rs8Kz
LcXPfthj8HGQnjomyQGFHnqut0QqYFhUu1+9gBOeT6jumPeugC9ih3zPnd4E
19oF7Oe0KmHUaf+j1jZuMNVk4XPNrgS+kJ38lLe8gD5OFc7yVcHBr4809qTy
gcDzerbZniqQscnkirEjwjrfx9c3DlfDsA9TMiJAAEbupRnNpFSDqNP9fNNs
Qfho7/vit2MNvCO5UrVI2yGZ4ax1vbUGQrKua404CcOjk2aT00pfgE1rsfx4
jQiYH1BWn17/AlAj+urIi12g+Ur829VLtTDRUl1/iiwG8jv4H03V1IKgbHLd
9rck+PfvZ9dkWB1s/uEtzVyjwMvG5Ju/yA2gM+q0PB0vAQtxH2S/hjaAnXH9
pa3ZkqBt3zRMX20ApuLJLLPqvTDJvmxS3NEIK87dudsEZODQEUP14IfNkOFe
8MFQQgFCeGznvReagajq4MIfoAiDfXdybli3QNQa00nE7T+4755BOq/RCqyb
gqnCU/uhPe8Pm9TvNrALv7AthXQQBGCL1VaFduDdmfJNZPUgaOyNUX9o2w4f
haSPm/epQPjC63kvWjtIOYQHB7w5BMpRXVds3tDgRcPgdq+4w2DleelY/zca
ROqXFeukHYGHF3+RzonQQV5p6pt7IRUY+1h7dR/QYUtbgw3JDYFfo7ze/osd
8Jal27WMfgyy3n3a++ZpB3iMjv/IctUEetwxdsnmDtC48I/Jt/04SNifLxVR
64TbBYpXrttrQSP7fQUWwS5QNJ47FnRQBxYm+Hi8dLtA8NTxrbpzOiBGj/8x
79cFHlyFuu0FunAjJS/lx2QX/Peiim4E+rD9CFOgrbYb9nOyeOx8aAhIwu63
zt9uqFy21mC9fAoceWabqg70wOHl8RovcSMo7eN68DGlB0ip/EFPNxmDjbvS
cpJXLxxgibs8PHka3uYFM10UGED6ZlPSSjaFCYGJUD1rBnzWjdPPeGUKUu56
VOkYBsjpB132VTwPKYd5Xg6vMkByk9oj7RNmEN0Qamf+hQmJJlsZ0REW4D4c
MXvCcgC2GfNP7dK8BAXaM6mSEQPAJ8LUuBl7CX6/NjrLXjUAj/K8ZUYmL4HD
DeKncqlBkPQc6pNJtAbzv9HeB+cHwatFWeYK52VI5mkKJGoNQcl5FmMxATug
Hrlr6W81BAvCcc277thB/zW5g789hmDX6oDVmW92IEIPGWvOHoKRv4fu3/5g
D1FxBrqPCN/gptnlmlwXRwiUbOXbYH6D2HduNjdEroI90OInXYfhJ2sBi/Fn
V2BJXSpmhgyDunk1JWTDFeI4RPsb04ch3+J01u0Tt6C+wY70unsY1qYfM873
3QLps39Sr6iPwKMx/r1enG4w7iCVM8g6Co57TjtV+nmAf5NBS8vOUZihZ6Xo
0D1ARMF1uvTAKPw5bV3wWNITdOZL/0u8gv9umLL/WKsnvPY5/cG0YRTeWx5g
j5b2Aqdon/L2yDH4cipB0ZDVB9gWU79ir8fgQcmT8K6LPpBgWs+SVzUGFYcZ
ObsxH2gUFdQMWxiDdVplE8HfF+Qys+p0z/+A/JAjnpmc/jBZ0tFeRR6HlYD4
b7Np9+DaqMxw4dufsOygefCXwgMYsurbXNnwExZ2Wazp3HgAZ3ofKbSM/ART
XaGBvQUP4FDTjzujOydgxNXCw1Y1CNjfZRC2P5wAYeIm3dkTDyHOW5zqcfEX
DLkmSafeC4ZKwR3xaoQpmPoicLjVLByUw+rLteSmgLebPDT4JhxecXmOGGtP
QV3d3QSvf+EQutqt6OQ9BYMGkZFnMyLg3NeY2oTxKaAuPwpr8Y6EiWzCwnrF
NOhl3B42H4wCbvH7Ul8PzQBfGtf7iJ4YqD8cpeirNQNPfDQIalxPIej8C1Wx
0zOQ/4hvbPfBp8AW+fmEhfMMRJpx2Hx+8hTW/k3a9yTNgFDMtOXUmWfwq98k
q41tFpz8JrGYoVhojpOSqWieBceoCLM7conwuFB5/8W+WYiN+R1w0SYRdNqP
qv0bnYUX5Qrzj+IToWaTpe7hjVlY0xqfz9j8HErdIx0/75+Dd5eD73JP4M/9
s6uv85/NgZf3kHBY0QsIJzTJvrw0DzPSIeYL+HO/SFXsg+G1ebA+uMPfxOEl
jFhdhz9354H7HWbw9fFL0MgVPGsaOw8+yn6rLu0vYVzX0mdr6zx8XTvmfPNC
KmgGTrXd0VgA4bx79yT80mBlkd/t9PZFWOEt7TL7lgE2zLMYe/MSCN/pDM0T
fwPcid+u3uxbgj21Wz6HnHwDBebXRL+OLYGAnkxhxJ03wM54eKeYdRk8vE5u
46e/gfTe4gM3VZehntS279f9HBjromQNpi5Dwr/Y1m1zueDUPhlZdGcF/mhE
t3G75cPNL/dtrkutQezvR3lpme/h3Q3eMyK6f+GUQqqBmX0xvLzrPPGfKQsK
NIiq/2tdCQHJf4wXJlkRivdcOZ//BVg6hlCpFzuSSb9UbKLQCHtv23meleVE
sZ9tMhpU2mBkMfYcTxkXqtfyWyAs0EBv1Mkn+uZmxNF+Im/JrhMMRyLlSCRu
FO3U/lk6qRua5UY6LSW4UVbJUulkejfo31L1TZTlRvbOESU5Od2gwzbYLqLK
jdYFg2Iopd1wjCLnLmjEjUKd6+V7GN1w0PJLxeYAbvQ22rDwrnAPiHaumsyP
cqMT2At9/7AemKi28a/P5UHCrdb2V517gRzV6xReyIN+m/HoxLv2wlkrQ5Oz
JTzoXPDUZuxOL5SvqMkO1fMgdRIIrTzsheh9xM7lYR5UIjOQR07vBY1YTEpq
Jy9a3FyzCsxeCHUSbXsQxIv4xz9bJh3vg0rV6CL9MF7keXzo+JpeHyxxbE4n
xvAi2Z0PzIyM++BS8rxn0ktepOcdNffjQh8odzbu/lDKi17dcDKoce+DgSN3
3EfmeJGUzq7f8pl9oEDsFtO8uBUJds/sjGdjwFjYWMDTK1uRiZ/BkcJNDEji
Xv7xw3krsvRMYtbzMoCXQ6Qg1HMr0iim3R3czoCJJTPt7qit6Nq5v73FsgzI
6B+45lizFZU5nAhUNmaAaNYoFiHDh4ZZBgUJ8QzolFiS+K7Ih9iPGHCcSWJA
yEuux8oqfIjFM3s+/CUD1hKkzvYd40MiAxYVs68Z0BvmOL7bkg/VnDmabVPM
gCe3pggfw/lQsV9VxHQfA7hh0bp/ng/JLwZ8eSrIBM+j0ps/rvGhg+W8e9SE
mTCmafE2gpUfJT8JqurYyYQqncq1Y/z8KCTs1sdpcSZ4nQ578lqWH7XMnf9b
rMiEX1ckv7hb8yOUxH7jtS4TzB3OOxs58KP9unv+lhswod4phCh7nR+dy/nz
uOkUE9Kvz14Y8OZH+Rqq8Q0mTLC8U7akGYePp3Ne0MyaCc2hJtLENn70oH5M
tsqdCeoRj1onuvhR1xn3Fa07TMiKKrld08+PlFQdHlfcZcL9Z+KVHhP8SITO
OxXvzwRS+5L8bzYC8qe90R0IZoKJMYHFkouA0kR9ureHMiGULtNRv4WACLcd
eU6EM2Gt0/JOKoGA/IJpF0OimdDdV/XFhERAHvc/nklLYMJWi/64KnEC2qEh
WBX1nAnH+xedFSUJ6IhsRJn7CyYUDEoLbJEnoG0PGw0lUpkQPhxuVapGQK7N
FX5bXzPhi23WfpkjBCS+cflPXjYT/oxWcjxDBHTpgPekTg4TnMYXsq+fICBJ
nuc7rfKYcGLKfHm3CQG9OFZ8ftsHJrwQCuzwO09ADlt2rNh+ZMKCxpu8fgsC
4mMv03/ziQkpj9ftn9kQkO2R9xyixUxYerfn+PwVAtIOuWerXcKEk336FCNH
/Hy5sKv2pfj9Sj3v3XKDgF6mhN4IK2eC0amaQrtbBNR1WfJKNMaEV+6TkdXu
BHTPXGslrIIJZ74c1vXxIaCnp5J+O1QxIXvSVpLhT0AnXdIMdaqZwCIUxqp6
n4DW/jYfJdUwIcdmoGjmMe7PFxm5+HsP22POZyfD8fnwrfCyr2XC+Xf7XLOj
CKhn8UCGcB0T3vaaGG56SkDJy8dMy3FzsvjK2sYRUGXs3XCLejwfUq+4KhMJ
SEb6ps5v3AWGrd/FkgloQb004E4DE6ySSIk9GQS06Nt27WYjEwprtD2UX+Pz
KTu86ytu7slrZ6JyCEjaaBg0m5hwSTBWcTqPgK6OBfQm4f6kjvHovycgzf+8
hqdx89n8+JH5kYCWKoKsVJqZYBvMX8NRTEB7fZ1P3MZdnK+aYl1GQEMvZxKz
cBN6L3qXVxBQe+mwWQduu42H53fVEJD7Z2G/Bdyle/OVPesISKfPdgtvCxME
DHsJXY0E1FmRtbQDt6Mby9T+VgL6db32OAl3xXPphnAaARXovJoVwb29xijj
VycBVRFU1rfgdvnleU+nF6933uHiLD5+lcDLCxlMApoJUBVtwy2i3qDG9pWA
tEqTFdNwX7Oe3XbxOwFd3JQRexV3zaMdcyWjBCSvbnRaAfeu/KOtIj8JyCoh
78Iofv+uPY7ZbpME5Pa1+1M07vp/UUH03wSUo/zVSgU3aW+xjeI8AbFr/DBq
x+f39snv1NAlAjrGIxh6CXfjbe5dP1cJqFY1lO8Hvj6U50rLWn8JKLH1Xvdl
3O7V5h2pLESkbSH9vRtfz5aJgLwNdiLqHi9SRLglBN6EWG4iohh297JkPA9e
ah32RdxEtK3kZfAinp+9j/ZQbhGJaLXPozsQz5d3nv6fNiEiMmatP1OK54/e
fatXXoSIRHQ7Nv/C8+knWRM5RiKitg9pgnJ4fnurbFnN5Yko/gfJ/yCe/5mj
jJ0+ikRUxfo7UKmMCZsqTymnKBGRinrM6l58v6hg6vZjh4jIqDLn4FIRE2JK
CC2uWkTk4SpH24fvzxz1oLGnOkSkJ/pcc+w9E6qL1jc+6xPRFHGa9KyACXOf
xpQ2jIno3M6tvP34/j5VWBoXYkVEBhe401nwfmB3QKngrTURcRxUP3o7iwm+
BZlNNFsien/VEb6+wsfPj/4n7ExEV3r2WiSm4XnOdbBN9yCiDvsPy2/wflSb
IfRfWSQRrenvICiEMWFQ4rHu0BMiUu2JMBMOYcJi2oYNeywRqUv7Ly8/wuc3
deKpbhIRfdivpZB8nwkBLyrWu14T0cuuWPcHeD+lxrrUTVcR0VdR/7V8eyac
2/59iFhLRL6jSTr8V5hw9anpmnIDfj0P/mFbGyY8f3Js3902Iprp811ftMT7
S4TIk039RFTW7P0uz5gJHx7VWFEWiSjdemXZXw3v33pNIg9XiKjGypGXX4UJ
Cbx0+tQ6Ebkl0L9FKzHBP/KrdgmbAMoUkW67K8cEg7g1hXMEAfRe5WYBXZQJ
3zP/2wiRE0AefObpMX8Z0OWoWjSnIIACBZUafPH/XfVy1FtmSgLo/D21fKtF
BuTm6f/YqyaACh///bIxyQDPT3ZtldoCyMG2bkcdkwF8dc+Tl60FUI6jepXT
JwawBqeZWV0RQIbRPmrvChiwoJct+MVBAJk+tPKaymVAX+unh9HXBdCWxjyL
E+kMSO+mX9/nI4BsTvzI949kgPrYZnQ5TgAJ3p2w5LZngB2n21BrK37+t89l
/vj7wE5yQ886TQDF/W3RG+diQOshsTbpLgHU3EDkO8HKABWXL2UBTAFUnTWs
MbHYB1wd2xJVxgXQhZ3T5+oG+yAj5aPJC1ZBVKxCyRl42wcjGiuNV5UFkWnm
9t77On0QZ2JQlaAqiMJSmtu7jvaBwfWUojp1QaSckqtA0uiDwlSdLPGjgvj7
1Fbxp/v64P6W+AddJwXRQYwgKCrQBxI9auiIvSAaE+ejR/T1wmXXux94EwSR
TTDpm6hNL6goDX6QSRJEHjHkkw/Me4F7Dn3UThFEfcUK70dP90L+Ta5P/q8E
Ef/LC+7hmr3w50bU54UCQZT265CIv0QvPLueWdLfJIhOz36mjY70QINLR2XO
X0E0Yc6n1nyxBxTt5VoNrIVQ/bea+4nUbhh0JF/PtRVCrDq8gSeUuyHURZDA
5yCE1h4FD07IdMPPm+vGbdeEUGMYvUx4WzekeTd1GXsLIUVqxBPuX10gHO08
cC5WCN3R179w/mkXbJS+mbzUIoTO7FqIeT/cCW0C8jxuatvQzPNHt285dEDJ
24BEefbtSNMokyFn2g53WWWNmge2ozrVnRyp+g3A3e+lc61QGE2o3ajbHVgJ
o6/EY5K9RVDddbVjl1bfQ4z0Do4ikx1Iin32hpxnKEQm2NVZU3aiB7GVn981
vsLMYy608v7Yib54G3LU6RZhK8czVpPLd6G9piKZWx5WY94lyYE1lbuQJee0
j3RyNcailLD1Z80upOQmWqn+qRrbRI4QV2rahX73brdW+1GNbV/11K3p2YV8
qgZ7k7RrsAO5BvHjM7uQRN2s9hrbF+zatoVD+/eIIt696PKnm7XY8Ogxz6qH
oqjT75Mvt2QDdiy5NVU2RBR1NfvQr2k0YCnnzVuiw0WRvsZ1x0rjBsyq6ebu
y09F0VnR/Ur7fRswRn5KM3uaKGoEzl9q3Q0Y/e4/ila5KHovO7k2GtCIVRGL
G+oWRJGXe0mjeWsTJt6ktaC4Ior6/BoKb35vwvzv00hx66KIO+rQPbelJoy6
PH7LgU0MxVT+jdUkNWPF/cKkLQQxlJ6w/GLFpRkryHRz1ZMTQ7Mmj7XLuFqw
1CP7d7VYiyHLfs4VF7lWrMqQO3DdVgx5pKj2f9doxb5fHJ6QcRBDfCoPtpww
aMX2BDwtDromhownE3YzXFqx9NpVM3RXDInUVQfJ5rZiGaeq4t7HiKEF7fHF
q7JtWJb1me0JdWLIRLlXKounHat3lfetbxRD8K2Eq1KgHRsP5BxbahFD37Ky
k9t3tGPSrz59ONMphp4nP5vvkGrHXk/sMtn6TQwNcSq1O2m2Y9m3Rp74r4kh
Td7c9m7Pdiz3gRvRfh8JcW7aiIzpb8cmD18IePAfCZkHNyZYf2/H5BeOz6cd
IKGBn7N2kuP4+TZCXUNq+PF2x49EzbdjWfA+zlybhAS4w9JWt9Cw9NUZsuFF
EhJZjnflOUjDRvJ7I11sSOhJ+3iipjoN2+NQwRpyhYR8PG5ccQUaltodMVzn
TEK9Zlq097o0LPm9QuZRTxJKK2jq+nKBhiVcdVE4GEVCguysMxL3aRhD4mzy
mRgSmrbrVKt9RMN29GsQXGNJaJOYK5dVGA2L0+OZe5tEQkLIVPzmMxr2VCr7
g3Q2fj2Vr4qSWTQs8tuPw6LVJKQSYWJU3UDD2uPactVrScjylNem5hYaxm/0
iWTWQEL5dhXSTTQaFl4exPKsjYR66hXSc/poWGiiZA1/PwltNdlu9mechj00
uazPvkhCL+5xJrdw0rHUU/2WV1ZISKx9n1nQFjpWqmtyrW6dhG6plxUe2ErH
5o6ciAphIyPXkwl6LkJ0zHKvXI8ggYx8hIOaz+6mYx6U9HE3QTKaLplxKZCk
Y9E7xdZ6tpORMe/9dA4ZOlbHxy/2XIyMDhKDOoMU6ZjS8pyNhBwZ0SliO9gO
07GTs863gxTIqEyh+gwH0DGHXyMPxveTUakwp9j6UTqW9LU7K+cQGeXsjTWt
PUHHNtcXTytr4+Oz8J7tOE3HBuMCvLSsyUi/wbio1o6OrUavh2TakpGfb54X
0ZGOCYXdTtriQEZXFbPLjZzpmO49u4qWa2Q08eFKc851OlboqMd1zpuM5CP/
zTI86Fjb5Wrhz35ktBwqVtJwh45NXDgsszOQjFRKHNlz79Ix8mkFg8FgMuJq
PUMw9qNjj9UFou1iyejIYTch/iA6lqEcklafQEZ8ep1tLx/SsQoFjg+yL8go
bfjVZplgOra4e6lnOp2MCrYZzAmF0jGC2PWfRllkdMWPLe1OGB2TFR5fK3hD
Rk7bF9rp4XTsEg9DzKOAjKS6EtNtouiYF+cZxb4PZNSZ4aIXH03Hnm40IY0i
Mqqdz71a84SONc6XXd7AyCi6mm3fylM6Njql4mZdTUbmtfYNLLF0jGU8L6i6
loxkdIeG/+I+2P/y9cMWMtqrsfakKx6vR8FhJa+djBaeNMy+TKBjk34KJ3o7
yOjxRRc920Q6Vk9beMrSQ0YhTlIvRJ/TsfQ9JSPSDDJSKjw+1Yjb3+3eAeMB
MuK5LnjoehKel7oTAXeGyGiAddx3ywt8PZw7yY1jZBRznI+NkkzHZkoTrs39
JCMtbDc8x93MZ122c4qM8jKq7vCl0LGsS1K8mjP4fFlYFrjjvl8wZe48T0Yv
3S7/7MR9iaPw9ZMlMkosNSLLvKRjh895rZSskhFDOvXsLdwiWejEyB8yqhpl
BL/HvebNrs/FQkGXTwViP3GPZ9i5JrBSUNec9NK2VDrW3doQr8BOQRPhVgqH
cNcsy1dWcVCQGrHUwQh3ASVy/BwXBTHjBzOscKfozvP/2kRBRz0cxmxwh7ue
U/XbQkGp0qxyF3B7JxZZCfLg41uY3D6J26lGNCiTl4JuT2+vPoD7/JRfrgYf
BTlN/hEm4NbePtzZxk9BTyOrb33H61MG7T+XiRT085h8Tzbu3Q6v96wIUNCn
hL/HHHETonj1Q4UoKMmc/bMY7n9F110p2ynoxm0+1Xp8fia/0+MLhSnIlWOx
wgF3H49Kpc4O/H7ORp/bwOe7Vjl+vH8nBVn11a6E4C688If/pigFrRzwzOLD
nRp0UZWTREEExSi7h/j6ReZVWcWTKehuBavyEr6+vr2SQfvEKWh9E0a0wO3C
GpxbuZuCLhlWs3zE86Bz5tSfn5J4/fVp2w3x/Kh4F+zxlaKgz2bhEILnSyJj
m76ADAWZp/X7lOP5Y1lmxqvLU9BM7Sp1Uxwd+5zgoBqiREFhPjlz4jF07FV1
kxVZmYIGv3GN8eN5j5lUCHp/kIJ0YxeX5/H9cYO62Mk8REFFI8HeLyLomPT3
e67yQEEmDQHyPo/p2Hae0fgKREF6AUaHRPH9yKGsU3n2GAUN5MldfYfv16EH
fAQfLfx4jSzT8vt0LE4mMbdFn4LoNOnzNr50bGFeOyPwJAUFT37UCfemY6fK
556rncLruShZ9NaLjnGd0QvNOE1Bwu7PxVvc6Zib96qTjxkFyW3o6/lfo2Pt
2hk2BywoSEGb45aRCx2TJxqb/7TE86OtJb/NiY6NZGTpmlyiIMxZ3cz7Ch07
3WYqvc+egq4q2fVXWtCxt/HslGEHCjIyyKpXMaNjW2zzhOOdKOgXF8M05Rze
b1a4NnFeoyDV6moHY2M6prj742j/bQp6Ua2aIKdNx3jdhNJCAyjo2so936p9
eL+FioRj9ykoQPNRU4AsHave4hK98oCCvHvujqpK4f3mRfU922A8r7cTQvwp
dOxnneulw5EU1GGD5kIE8PzspIlNJlFQvUB7U9gCDds96r0tNZmCVpdoBs9n
aJhPnvTW8y8pyHEquil5koYpH/f/U52Oj5fv2vZgBH+eXlVkJr6hIJ03HIat
HTTMryIsTr+IgkKi5KTO5tOwiYGKmNViCvonw9bQ8IaGnVufj8wspaAqxV72
g5k0TF7FPJi9goKi6H6nJ5NoWO+bvV4ltRSk9Hzj4+BjGqYUi1nIdVKQ78eP
jV02NGzs6iyJ5zcFlW3bWi/FQ8OMQyR2Fc1Q0LYWrypTThpWmmUqbD9HQSKW
2jSfjXbsyXAZf/UiBbF9mj6cg78/ILPHLHf/UJCKfXhNNLMdSzi+5/vEFnHE
qnbE4fHrduzkLpOMRglxZJH9+osmtR2LG1GosNgrjsZcXSc+qbZjI7mbmZNS
4ujvg8jJPfvbMW9USuCXE0erx/rihve0YzlX9nif2Y/7WT8b25Z2jDt/9nT/
EXF0wY3s4JPWhtUdD2eZPieOSN3CytnFrdjRa3UWxGBxNDXlFDlY0oyt9f7U
rnksjiQPnPcJfd2MFWryKnmEiqMb/bLTMrHN2N4dxpsHIsRRoalK+AHXZoy3
hlGY9Uwc7X71Vz5Qqhnr3TG9FaWLo/gPt/eRI5qwG1+EKq5h4sj+sLb9q9ON
WLKojUTzojjSGJALm8mtwySqM58ZWuxGj3c7rYkfqsIi91XJ0st3I53hZx5O
JZ8xu3kOWoPsHpTYEkjornqF2bybowRH7EFamnxn7n+6BfWNmwNL/+xB37tI
CrFiueCi+S2yAbczy02ld5RcIJQWvejGffzqmf+a9uTC+Vyn4hnc7g/rRDZk
cuFHRPOsxN89qKb74nM7lVzgMom8FIb7Z/nkVeVTuaD5VZhq9W8P0vlnpNrk
nwtjpjP6zrj/Zbe6jATmwuP2ejNP3CIWrYl/g3KBXnnHLRp3XIrxmGJYLtik
M3NqcQ9VWeyLic8Ff8fkXYobe9DaoR2BFgW5IPHdQ+Ywbs41P6PbH3Kh3txI
VRd3p4e1cNhnvH4D1jOXce9ZjI4qL8+FZIXLj2Nx39mfpirelAvHMjXi0nET
DDra1Vrx+shCr97hLn/tdfk0LRcUiF8qm3BnL8q7Bfbg9QUntfXinhFRXUhk
5II7m/vAKO6t/h9dCgdyYeddw19zuKMqswebh3KhfH7v6gbut1mCeqPDufA/
jzXZpA==
      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.2911612749174886, 0.4343944236404684}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {4,"4"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13k8VN8bB3BLFLLP2BJmpixZkooi8xyJUhIVpUSokLKVSLYsiciSypYt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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.2743815636982917, 0.3996519085643727}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {5,"5"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8ld8fAHAjIzMU7rVHyYiMUPJ8jtCQUFkVyviSilJ2iqLsjBAyIlkl
igplhOw97rWy994j6/f8/rn39X7d+3rOec5nnHOELO5f+Y+KgoJCAv/4/3f8
UwtaWatAbI3w78K6GShXtAlqGwnawqeO02sctyJO71UWewsKugHDivoFhZsj
p1nCv+cwdD6H2nOdA4cMOVTjS4MFaAT9wUj11HqxmYKq1LzVqz2bEKCtb2Kb
PKir+pclYXebHA4X1RblywwsVUVT9yv+24qEiDXvVP5RR9V7qk526wIxQGMW
Z2Bv5qOa2z6QsqIeBxwFt0dVroer/rur3btokwgKxMV7tgcTVd9R9vqvayZB
XwjhfB9thqpGQ9jhNXIynNu/eN/WIFd1Ivrc7xXbFIiIMS8X7fqlGmS1Y7K8
9QGu1pkoZY9UqB4/nruxGJwGPjMPJqc9G1Tbtm5HLAhkwCVjIaE503ZV5yr+
4/NfMkFGpIl9+3WPKvF1e92s+ifIj1IXyL02pFpsFmAz05EFPTBMXcc4oWoh
gainbbLh++GOA8Yc86pUW+5NKx458GrzwMnA9mXV9gEDvhXNL6Cyeu9wL82m
amrl8bvLLF/BtC9mkhvtqbp+YixYIn8Fo3f/bjzTp8a0wsdol97lwtDR5IXh
PDqM1/W3/qJtHnyzeT0TQWbC5kzjkhfkvsG94I8Nt++wYaXqLgvzW99ghvX0
Pcvhg1i4+BVsvuI7GE5107SOcGNWrMeC5oJ/wHjACzbyEz5McZWue9YwH1gM
45P1bwphdD1DYrMCBVBLvuanYyKKdZYWOc1MFAChwpGRq0QMy0yNLp/+UgiR
7seu+oRJYh5Bj9im3X/Cm4l90fv7ZDCdhzo3p9R/wSOdC/N/jeQwQWPxrEmm
ItiI6DCW3H8CW1LdtzXRUQRDJpN2gvuVsQqR/vMTCcUQdmMr5LyZCha1vzBq
3KYETuTnufqzApbnovXwEXcp8KdW1rKHq2FxU0qEZY9S6Bh6Jtvfoo69MD1c
+nCwFE6H/LCUvHgWs29mt1nS/A1DdrnfJaguYEbqFCwPM39DXEX/K/Wtixj6
Ppu3yFIGlA+Dgg6o6GLscdVUi+Qy+IAEO/kvX8W2WL5nPDhdDt97hW0XbQ2w
kWfv9RbelYOkYb+CVY4R1rASun6fpgI21/hndcWuY99tnibM21YAnX7QaGaL
CZbYfVfzfmMFLO2qZ/h/vYn5Xbo2Myf3B16cE64OsTbHrssrnJrb+gPx2Xzt
dn1WmHqq0KDdrUp4mnltxLveGpMisPrNVlQCwSWPwaPvNnYoaFvaTrwKtPY6
L6tx3sV2dyc7ZoKrgOVD7WSTkx027kD2uLdUBfW8wg9P7N3HmkcqRGYMq2Hn
G0/y+esOWFJtosO0QA1skTgrKA0dsZXobxL9QTVg9sqvvIXPGTtrUzfculkD
+Txpenv7XLGYE4Nxlda1kHvGzESI2R2boV43KGyrhYx9Lnq9Sh4YtDKxfkZ1
UDH29ezQy6dY+Dvh6qSsOrgwPpW4+cQLU1bVOeXvWw/6CQYvimW8sUBGq2WP
lXpwdEpP60v3wfq63D49MG+AU9lSq3XKLzEf5w/8xiqN8CHcV0AsyR8ja/wk
X0xvhP8E5WLzHgdiEhwtoXCoCUavKHzVcQjGmrO3qcTmm2DTQ0dQoCsUY4f9
ZszSzXBtxF9vcy8MUzkSccrXqhlUraPb8xVfY69WMpbdW5qhc1bgtCMpEsvv
UWheoWsBneeSM6XoDTZYVvLJHmsBiVKelIiiaEwhrOM/i48tQCn9JiR58S1m
5nrrTO9gC6R8po7Sy4zHfG9O8xtyt0KsOtnKzjUR6z5G2XnhRSuoiX0Mov2U
hFEfCsor/9kKJ/sPnYn4loxJbXOGqS61Akv0kTmHuveYZ62UluzNNmBeGOhv
4kvF0r/8OPIxsg2Gr9ZGytxIw1qjz1Afrm+DcPX9xxNS0zFRG+Nf3CfbQUvv
n8Zz24+Yjs5wdPj9dnAqijw+PfgJczlh78SU2g6pdffnL9z5jNVS+0hTcHRA
QeQanzMpB1uZYmF0v9ABGZkatLx5XzC+1pjxZc8OSG5PF/oT+xV78C773fhM
ByQkae0o+eRhnKo97E2VJNCzKM1/1ZSPIVHr+fM7JJAt268lv1OA2TIu1pXJ
k0HaI0z/mOJP7FcX7Yvv78igI7vOZF1XhI2VhpkfJ5NhukLAW+toCcaazotl
MneCp9mPfRPnSzELZ7n1ePdOEHqfL8xc+RsLMi1q4/rSCfQ0upbVr8qwbxrn
c8LGO+HWi9f/XpiVY/QcZrYv9LtgU6zJsYzjD/Y527/nnnQ38BI/f/Dprsam
2KeCtMy7IY8rJmqhsQYTc9bCjkZ0w5Tf/YL62lrs3WnGpOHNbrhz/FvPs656
LLwmyPr6nx448Bl73vuxGWuUmuVS3ugBrzLXRtWzLRhj6KWaQ5K9IF1dVc04
2oL5GLJItYT2ApvUDdA53oY5D4csnjP5C3WpJyVEKEjY17MLyYdD/kLuMlN4
fCkJm8/Q06cu+wsJXqr6Oi/J2O0HbD+KxfpglE5JpVioC7u+E+5xYrkP+l7G
OXW/7cWibi0f4zjSD0bM+yTo/f9ibeVX+xeM+yGipZxe26MP0w44eOZTcT88
cPTxqDw1gCUy1nmzaQ6ATrLaS5EbQxim+tjEy2wARMolH/+cHsJ67SVPzLsM
gOsOour2HMa4WwPH6jMHgM3Oj23m6wgWFq19we/AIHxYbJtROjuOHa/dFloX
H4S2gOJu0so41rj16d9/6oNQ+qlgxjttAmO4yfxJ3XkQtuqk1nUJU5j34UaW
vZ5B0Ng5y519fBYTNno6brc6CNsdmaeKKOewUj/p0l6WIZBmtUmxI89h29Ov
HArVhiCfMzD22fkFzOmrbrtT2hCMrlkceCOwhNlAS8zMw2GIztF4WK+9hlEk
rxX2BA5DERff7tneNSx6H29vbcowDJBut8XZr2PVNdb8GaRhmMtauUsTt4Ed
1d9O/u/UCAS4BTzZIW5hpd+FKvSvjoD9T9pan7ItzJhwblT93gjkK4wdRXbb
mF9fmJhwwggoBro6P6vfwSZui33qoxyFv6wUF39dowCvOu2GBuIoqMTUUqwW
UgC39MO5X/KjQOZXcVrno4Tzy7+Ov/1vFAQrGZwfTlJCxpMr34xqRiHDSLF3
MYoa7oQ/KW4OHYObARfH6y7TAdVqcn9Jxhhc9O9eTW2lg1ijaorssjGo4H3q
+c2AHmp5OdSDV8ZAurPZ3N9iP0impVddMB6Hd4IsPKQ3jFCxv3FC2WEcrteG
GHJKMoHJveX9RwPG4fZ/9GoVpUwQJItp0/4ah0ehfy/7LjPDzM+25jKBCVB5
sPuwVOUA+PBvLn5RnoDCW53Xn4ccAN5n/BxJlyeg5dbT/bEjB0D7rK2Bp/cE
CNWalXaHs0FW826XyvgErPQbmnFQcID9qPhw3udJcBaKDKEX4oQBsy763zWT
wOzv2Xk6khOudvpJN4xMwssnLPJXGblAuW7cbZQ4BcjoL63qDhdQf/lwgNN3
CpjsIqbTNgjgLGGgKJw8BT+7ipRDPIgw8X6fiXTRFHiAxAtfKh5ojLJMO7s8
BTd1d83LD/JCtIcQ5nJzGg5z5nsevMoPDGvNlt7u06D5watRZoIfntz38g+J
nIaom1tVwZ4CYGHR355WNw1X5du/RF4XBKnz8Xc7lWag++7z1MsJQvCbgxBz
8sAsKPlSZhwzFwWF4OpiTclZcKyIlDAtEYVUWteRy2dn4SyH48Aw/2EI2iTJ
3PGYhZMWA2I0Q4fBsD+iMnZiFrKWtAW2XcVgKvPAylbpHGRO5DitzUiAiWgp
gb53Dt5kjwbqWUhCU/x9OLg+Bw/a4h6odklCXmhjgNSxedh9ecC4v04KPJ2D
hExj5kH/e2rN1wppYBDyEetXXoCaVx8esfvIQvXpMJmnmgvwjLCWbF8lCy+N
E5T4rixAyPxMYhSjHFCF5p+7cXcBKMqHt/Wi5ODf7owNOX4B9l5YR7/7Jg/T
vQbpTVSLcOSTpKMqnyJkbljk2LMugq7uylMpe0W4ffBBPjPvIsj5S5zbV6oI
IxcDqi+eWAQx/ddvnayVoLeweKLKZhHqZI1SI4qVoT5aTLy0fhF4VfONnONV
ICBPQfZm1yKwNS8adO6owPlmtZO7o4tQdPeI1pmbp6GCzuTC6b1FsD2/Iad4
WBV+OYfa5ssugWfDGRNyEQZZ+psZOVFL0OFVmzLBpgavDtRJJN1aBqWcFCJ5
QgMKlPi+6dgvg6+Yb7CcrCaMmN2H7cfLsHF2H+myuyaoZHHoG71ZBrbLkY2D
LGdh4oLJE+bGZSheGKdxUDsH6t6zTW4qK9Drnrae0HAB7DPhutiFFYg2oOCY
EdaC2JawkXbDFdgR+GNwyE0LFgQUN2UersA52fU4qqMXIeHXU+Gx9BVQ3D4e
4xiqDRurrE5XOFchds8zgT9YF0T4LPb2RFaB5ZMkmlvQBR2NPP8s2VXgKMtY
7ZLQw881xgn0l1ah744F7cEwPbgik1RV7L0Kzs8eajtYXoas23JEycVV+J7A
fitE8CpY9OiXUNevAeycOuhGZQQMbwftHLrWIOvKrIKChhF8vW7P2z+2BlPb
BYzPXhoBdbevWyHlOnxg+HuzjckYUjoL5R2U1mH8aMl/jwSvwViHYHpf8jpo
HvZUsrW6Aa8iswy1c9bh+elD8ZnZN0DR4BRNYdE6iE87cAVt3QDf9qsWkZ3r
0KxktCkXaQJH217yarNsQNhReTOJZlO40zwTWuC2AT/ke6Kq5W4Be6gbiPlu
gHPvXleS6S0o1KWdi4jYgIiJt5mtfreAsUng4oPsDeiK4x04PXALPjVcoREb
3YBas35BtdfmMFeb7xahtwkHWY4JOTNYgsMfH4v7Yv+A8Yu5HKOaNfCPnKVd
k/8HERH6O9yO1lBHtT/TA/2DPeuwRq80aziMghf9r/2Daa4y2VusNtBVGOmV
EvgPbOgyq2yHbUAtJzWha/4fvHrpoEEXbwtsb6u71fO3wEWvJtX+mh0UFwQ8
ra3Ygl4BgQth0XZwt1Nb+HLLFsxezSvj6bSDP4dabM2mtsDyViDVHWN7cAvt
2nDl3QbFOx4yG6b3YfDFFOdnr21Is7/dllj8AL48YLrKfWEHVu87xLbRPYL6
WA63LMMdaM19cCJC9hGMVRATz1jtgNaI8/3YG4+ASBCfvue5A2EGtAuuOY/A
57em9+9vO7DDWuP40tQRDNk9c+8I74LeZN+dI3+c4F/uIkfR1i4cyT5dFlnv
Cgf7Nk5e2b8Hx/L5dhL2XEGanuLWOOceFHXv81yXcwNLE5ZPbHJ78LnbOPxN
rBvU75PUsL69BwcijkTE2blDgoGVI2vHHrT5pYruCXtA0uO7U8eNKFBmoEvK
lQZPOF66f8PXlAI5KFtoW1B7Qem+dJp+Swrkuc5w+IygFwwEjwgGP6BAd6NS
VpyvewH/O1OjSX8KNF1Ll5Tf7AWxFboVSb8o0BBdSld+xTMIZ1ZIYBemRBzx
aR/D67xB+ErrR9ujlKgp+iWVzaw3fIl6UFAqTYnmk5auWLP6QLNAVru9CiWS
jDppNXbVB1jkjjDW6VOiCk264fk+Hwgw5Hb19qVEe9suhzV3XsDzxO3LKzOU
iGhqptB/ww/0juc7SC5TonSFHzaBz/2A//ejMItNSqTXrNhjleEHhUNTzc00
VOj5YZndxHU/WDrcpZvFT4UiVXZen4ryB4tP3y5Z61EhgTd9yzy9AaBWYH+h
M5cKvWxcuGYdGAwsWhK2rIVU6KD3quDaj2Do7R71O1tKhQ6LF2x/HwkG122T
6rx6KrTT8fNuPfYKcuDiubBRKqRftud8YfUVfo4Q09TiokYv2J9dbTsRChRt
A+iXOzUyfZv88mZJGPhMFie5P6NGHryGApQ9YbCfIp7qpB81Ms+iaf69Fgbs
x65VfIukRvcqlCveSYfDYd+Wc9k51KjgTTAVOTEctFTKdJLHqFHxvVcHT/i9
htfv35v4XdmHnPQ3J5UcIuGIo7WrvgQNOk1mL8XSY+DYqf6ricdp0GMya2hd
TQwoUBjLTCnSoKpnL7VcpmPgTNCFMU91GmT8kjlPUiYWzFKk9D+a0KBSlty6
/fmxENW+JEMVQoOElv54pja9BZoTnuPZyzTILXPW7ydnAoysvjFkLKJFWdda
Bp96J0Gymvyjv+W0SH2S9eLB2CS4GdwYkl1Li1Z3TyQX5SRBtyhNzdVO/PfK
DQXtviRoufpQJW6ZFulJxn+4dioZir9oCx6ToEOHbbRvqqwlwxs7yimdN3RI
g+lvkuaTFNAavfMk3IEeFX3dt5RdkwZnn4h80nClR+fue12ZHUmDM4d6u9ee
0iMOnU8ngSIdTmleUr4RRI/utIZ8FFRKB4kPMssiafQot8fLt/tDOjD+t3L7
Wy89Cl6OvnjMNwPqR57od57bjz6zFxywvvYRdEZCJfn5GdBWOa3799PZMFVu
4VWdxYgCnD47emTngjQbiU/9JjMqEGG4z12UDwywat67zIIis4paDemK4dzs
9XVhgwOoR/nxhJZ4GXSWWVFel2JDsy7xmd89/sA3vwozwVU2tP9jg5xHcTVY
0zgNNDayo3zh3WurpvVg+fDxN6ZYDiS/EUM9XdoEMjaSjdrmB1H8gKjBxNMW
aGKXYnQ6eQjJGBdGPxNrg5+fn7+VouZEx1Zqj9wIaQdabQPiG1pONCRnTWKP
bIfLk2IxlAycKNJ8mqIqth3GRRqiSAc4ESe/+A9R/N7JEcMV7sXPiS6u/1H5
9qsd7np/8ms/yYm4JJbUxCbbgceY5OTxgBNJ9adrKkAHWK+mr4w94kTaCU6k
Rxod8CX88aPLLpyIkEtlk43fU881CDocecqJLLuPuhL1O+DRmbv3mgM5EfGs
+ULJ7Q6ok6KwFE3jRAaj6pMaYR3wmFJCr/4vJ7Kbls/j7e+AMQ3GziODnKjr
N99M8XAH6PnN3Hw2womkTcw6TCY6QJQ1+77iNCeaDNrIClzsgHpehZB3G5zo
a5IZ5zdqEvArY42OHFyI7h9DsbwYCcrsr2jzXeBCN6Tvu1TfIYHUV/l2F20u
9KtsQrbbngRRqwdNWnW5UPmTt8fHH5Lgrgf5rq8hF6qjM5tdcifBwQCTwEVL
LnTb0YuuJYAE1h+sa/885UKXS4/2pmSQgKHX/bx9HhfiCiCpRwyTQNElgznk
BxcS1OAZqB8jgTl7Z2t2IRc69UV6H+UUCfLPnzBdLOVC9Tyvu24s4M/7Nu/g
2MCFmBOuPuzZJsHvV1Zv3ce4ULvDlhjFITK4qunMveTmRu+iabUb1ciQ0uuR
m8bDjcz2bjI90iBDk8tH12p+bmT6Io6G4xwZjnymp2Y4zI20DkGMhjYZ2ojl
XMGy3GiubYfK3hC/968oqb3W4kb/Po60kW3JMJoqFJHowY0SiZ1G60FkmPEZ
3KT24kavl74aS4SQYcki6eZtb2509vW6lVEYGSgEhCRlA7jRj8tJEYmRZCC+
ESwre8ONxHmkqSfiyaDnK7Aw+pUb+T+NKDTMIoPRf/0GWt+50R/2p+Li2WQw
U0/8+bmAG/mu2bmu5pDh7h6/r0spNxL27fn4OI8ML134+fc3ciN+QpsA9pMM
v2z4tKUmuZF02LOt6CoylGv+/RI6w41cI/QV6GvIUCsSz7U6z41+JZwUdagl
A7mfd7hojRtd0zUQON6Az9+I1113HwGd6hbFLFrJsHmitz+XjoAmuqumEtrw
9zkYp8nNSEDUvuunOtrJwNzMwzbIRkApNPd+SZPJcPQ8T/pDAQIi3TpPGdlD
BpkjPcxkYQLiP/TXN6GXDIr73j5SOUJALgeEE5P+kkG9lAj7jhGQW8kz54h+
MmgldKfcPo6Pn0Mj5zOAr49HLEODPAGZWTM52Q3i66FMJEWeIiC/7HA/qWEy
/MfZrfJPlYDUbcP0qUbIcG8lJslMjYD6TrIltuB2yyHYiZ0noEM9OakmY2SI
OErYV2BAQGqGHWdEJ8lgYnYkbdiYgGSuaKv8xC0aIa/FYkJAYrGGbtpTZMjb
uxRqaUFAWlfkSkynyeBx4ob8q/8I6FhdSPlf3Bp3b5PybxPQuZRoWuMZMrST
nvOy3Ceg4Du9aiqzZIhjCi1RfkhAJyrzFFNwW52Jt7B0IqAB80eWdHNkkHLN
pHnlSkAb9+9VWuFeyfqRnv+YgEIM10x/4f41XHFx+CkBzefYHmWZJ4MPoXWO
+TkBMV0WEr2OW1u3P0z5BQGlIXfdd7g5XswoWPoR0GJZW/oA7u7CTXJwIAG1
GIRI8yyQIXmB9nH+K3y9cg/06+K+c+Qg/3AYAdW0FuU/xS1nIvSbOZKACqd2
C9Jw/wuTtlKOJqAoB2ywFndZlQqd5VsCChOYlJrAHbBzPjM4gYDK5u3e7uG+
Im94KT8Jj48QJsm2iOe7reXCUAoBrZ5s6ObFPZTw4DVzOgERaMLShXFntj9R
VP6Ix/cN5ev/+yFDYJfFZwIa1omJ/v//T6Foj+AvBFTX3v7jAG4q5w8C+XkE
9Jpffn4XH6/249eyoR8E9Pz+CdVx3OGDJf8x/ySgoms339Xgvs7VQK9cTEDT
JYpcqbiFL3V/tPhNQMok9XceuKeej+sEVxDQlAjbqUu4v+avLP6oIqDHPpLD
XLjd5ygjh2oJiEVcOLYXX88zoqzKzI0ElBDz0vQtbobrvD1KLQRk8H1GUh93
a4j4U4t2AtrOn6Kmwx37R1EomIzH4wRhJBePp8WWesWPbny9+TjqruNesjZj
YB4kII2KgbQoPD8K4+5mKY3g8VJZi5XE/bzVVc9inIByw6+HFOL5xYa9jvox
S0D0z7OcK/H863z07uTQAgEtjC1Yq+N+l5HVy7RCQHaVUlcL8fw9fqha2OIf
AemtXyZG4fm9odXxJ2iHgGr13i/9myBDqdfQ7R8URGSjVPT7Gm69me3PTHRE
dMHkBNCMk4FbmOGKEgMRkWhYpy/j9TNgxLVqzkxEnw+l+0WPkuFBuazKDw4i
Kj4oEcGB11torHWVuSARFb15WFuK16+L8/NHHiJE9G1c134Qr2+zKwkCb44Q
UYukpNJ2H57/DCSXeikiyjLykhfE+0GNm+ZRpZNE9Pp2Wr5QFxlyDMzbL58m
IkVva2uOTjJEyz7xugdEtEiVcXyPRAbrybzOJE0iqhpK5fyD9yOqa6L+TFeI
aNcnhImhmQyTCuiEmAERLc9aPK9vJEPzAZNBNWMi0uxsY/LH+11i9euTLmZE
1NZWdWMB74enlamnBu/g8zl6oNrlDxmcuIa0fngT8X7xkd22AO8XyztrLS+J
SIGN0rr+B17/TYT3M/748+PmSsS/k4Hd9/KWUCgRSaRY+rR+JcPntdKPQXFE
xOS/e7L3IxkmOhKZLL4REQ2v6temOHw/+vIz3yOfiOjkyg+2xZLhezDZ6s1P
IrqVqfmwORqvd03WovrfRFTd9pmnIIIMQt+e2ik1ElGrTirnGXz/uR5h2sg0
TkTkljVxOXcy8OYy8NydIqLjvaOSSS5k6G/5YVMzS0SmbmFM+53w/sPKTvly
hYiQ+web8vtksA+olN+j5EFTdxQdh6zwfPOSiVnk5UEs2Sftay7h75fYO6or
yIMOprIQKrXIQFfsL/dZhAdlGxrE/sT3z6Ct4bo7EjzohWUSfxi+30Y5R+8O
K/GglJ0+kTEFMmTco7QiXeFBt7ZZupWIeH8O/JyjYMiD0ttqyn9z4vtr5o2d
8Gs86JWUqqcGB15/49+idG/xoPjw+DsKTHj/s7hTU23Hg8QunmEt3iFBs3Gb
9E8/HpTPuffYtZ8EGxofNhOLedD8YXHqgHgSePxM9K74zYNE9SyZ3WJIQCEX
yzxZwYPov6d2mkeSgE4gREiujgcx2yjnCgaTgHPT9UIFmQftmed4XvUggXyW
dszEAg96LRGYH3yNBPaHVpRlRXgRzxtM34iVBEuBc2UGR3jR4EcFcU8GEjhR
TWq7i/OiVTOe+nc0+Pjzf2+Vy/CiY/ZcT1u2OiCwpsrP4DQvCuRcfT8x3gHp
T952uhnwooBnHAFzxR0wPHrGtcyXF6Vszs6a4ue9M4mNyRKBvKjjeFDNOYsO
eGd8vSH8FS8aIdG7S5h0gFmdg7BlJC9aqXQz69btgO6cd/XU73nRNL+Q8Yhi
B7Q+3hXULOZFQYfG5JKpO6CMrbCmaoUXsX9Yetz0ph2SVWV5Gsz5kMlHBrlL
H9ugTIfBe8uKDxE4FI123rfB0M3hKfHbfIjzndrbtLg2EHkeWfjSng/tz5H2
nQpug5TKzWvoMR9y4PcSknjQBh90y6JzI/iQdVQPVbh8G6SbX+WMreJDb79U
SrF/b4WsF05sNsf40VjqlvfFzBbwNbC8SL3Kj5+3PaSGSxvhRG9Shm+DABL4
kGGQIV4D0eJvsxouCqKMWG+aCNdy8CwNjr5YIIgqu0d1OfsL4BKPwYdaUSFU
WGu9e1E9A9Tsq26w+QuhGN7MpyrXdSCR10K0flUIRa0ebh2rzCgRLU+L0rkh
jIxV9On+eueXhB4rk2gtFkaSZ5qlaL1/l1gv72upkRBBp2oPhea9qiwxy9Ro
NJESQeoK1h3M7ypLDM196uaPiaCA5tvuN75Ulpxtoq48JCuCIpoIlW1tlSVH
PlL9NFcSQeZ/L79R4q4qGbWg+LCpLoJmIkJq/yRUlVi1brmKm4qguNzR6trk
6hITfxXnX2YiqG/4pEjy1+oSffT4ke4tEWQ/+3LrXll1icbnf3ZOliKoGJNl
/DtYXSIasGnx21YE7bzfnj4sWFMyrLaufc1ZBE0Krczpx9aUWHxZEvQPEUGM
diUb/3xqS6r3P55TDRPB673oqXVEbckxC+pfS+EiyITihEXZ+9qSDfaDRiZR
IsiSe0X4YlltSYjjiWCZeBFkIyfzI3G3tuSXkutmR6YIOrsuk6TjWFdyqHin
RbhSBIWecRoMvVpfUl1L7/1rWwQ96K7jlx5oKLmnPhhag/unSH6dD+4DvwoS
SLhfR39x7MFtnHWncAF3zEhdod9gQ8l4SP2i6I4I8hiO4xoeaiihNQi9FYx7
mjWd481oQ4l6PxdmtiuCHmsIHNqeaigZM1q4eBd3g36C+pXphpKA5uprrrgt
jMXt03G3/nZzCscdKGr5Q3+mocQipedTJe5jCVbErNmGEi/bRB6ZPRHU8z1K
2HShoUR0yEX8NO6yzGa2XNzV1/WULuBW3Dy0Q7+Iz1+b8qol7n2+ZVV5uBOl
LQPe4CZfTD7GtNxQciZNJToFdyuH4o457jGBg6lfcD+ea6/+gVua7c/vOtws
KfL6liv4/Pzjmzr/b7tljgLczlTOf0dxl4sWN7GsNpQQH+tML+H+VPDa1wp3
8fKRzb29/8fXUaUQ9/8AOgOv+w==
      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.2340615072537411, 0.37409273587771136`}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {6,"6"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8Vt8fAHB7hlAqeR6PkU1GSfHcz8leUVaSUXaSyFchopAyCiWyyUpE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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {-0.014458796087596551`, 0.3541406178131037}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {7,"7"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8ld8fAHB7bxok7kV2SIPiPp+TVSKV7BmRFaGvkRShjMhIVkWEkJKo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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {0., 0.33793175130102204`}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {8,"8"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8Ve8fAHB7RDapZNyrQihFCed8nqwiqeyMslIyMkqUUsiKjJDMrJKR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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {0., 0.3243806064889815}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {9,"9"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c00H8XB3B77xn52SUyGrK/n/vJKqIhJDsrMiIShRQikZIkyYiEjMwy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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {0., 0.2918556740030771}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}, {10,"10"->
  GraphicsBox[{{}, {}, 
    {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVVWc40O/7tbP3zqYoO5T1ee7HrqyU9S2UTWQklUopQiIjKyJEISoio8iq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      "]]}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->True,
   AxesOrigin->{0, 0},
   PlotRange->{{0, 10}, {0., 0.1464147858047036}},
   PlotRangeClipping->True,
   PlotRangePadding->{
     Scaled[0.02], 
     Scaled[0.02]}]}}, 1]], "Output",
 ImageSize->{227, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->687541614]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->176205401],

Cell[TextData[{
 "Show some famous cellular automata in a ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->141692444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Row", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<rule \>\"", ",", "r"}], "}"}], "]"}], "\[Rule]", 
     RowBox[{"ArrayPlot", "[", 
      RowBox[{"CellularAutomaton", "[", 
       RowBox[{"r", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "40"}], "]"}], 
      "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"r", ",", 
      RowBox[{"{", 
       RowBox[{"30", ",", "90", ",", "126", ",", "150"}], "}"}]}], "}"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38655598],

Cell[BoxData[
 TabViewBox[{{1,
  InterpretationBox[
   RowBox[{"\<\"rule \"\>", "\[InvisibleSpace]", "30"}],
   Row[{"rule ", 30}]]->
  GraphicsBox[RasterBox[CompressedData["
1:eJytlNF5wyAMhHXdpI8ZJx0hC2T/tyZBJx0YbBzjL3EJhdPPSej38fx7/JjZ
7fW92/sBXh+Uwedd/nDg8+9fMP+Y/As+9VkSi8zny14r87E+pksQToEBwHXk
KYxgbHCz0Pg08iwpRTrqBGNzuIomrMizOADP5cEBYez6KC/UZ3HuMADUS8au
j/EKv7m58JnsV8Wxj+G62s+Uwqr9G8auj4TLAYmZKNR8hz6yGHJA4pBp9Q58
BNAM3BLjs9Hb99HkoGEqmTf+TfgoUSSlmfiu3p6PGkVKORM/Vuz7WEXJTKvF
+4ytj1UUZKa39TfrYwpkpoP7SLHjo9y4THlZf6A38lFuXDgxqr8Ro/poKh+t
doZPGdVHuXHRsub4lFF9jIrMGzLJp4zaWrKNEW9er+djtjEPdIJPGfXGqdA5
PmXUG6dCZ/W2PrK2x/1vlpE+sg7n62/ESB+D9ys+ZczEHvW/WcboMqfrb8QI
Pf0FvcZHfFN/I8a40Rf1Kh8v+ieK9HEBnytG61rzaOtaprjIP1FcyFcU1+qd
4PsHT8oLhg==
    "], {{0, 0}, {81, 41}}, {0, 1}],
   Frame->Automatic,
   FrameLabel->{None, None},
   FrameTicks->{{None, None}, {None, None}},
   PlotRangeClipping->True]}, {2,
  InterpretationBox[
   RowBox[{"\<\"rule \"\>", "\[InvisibleSpace]", "90"}],
   Row[{"rule ", 90}]]->
  GraphicsBox[RasterBox[CompressedData["
1:eJytVcENAzEIo92kz47TjnAL3P6/ntRHG3DiGEiEEA87FrKcx3G+j7uZPa96
XWW38fiZnYj3Vz0R70tn9HhzPaNxxPue0Tjis/ub47P7m+Mr+jC+xofw0ZHa
xW9UCjFiX+72+R6yHWv8f0+dscaVP9mMNVZmrLEyI8a1v/T8ZP7S85P5S89P
5i89P9l+9Pxk+9Hzk72v56fq1x1GNf92NGr5t6Nx1XMaVz3DqOYfZ1TzjzP2
/t+Z/OOMVf9Fxqr/ImPVf5Fx7B2MXfv7MXbq+zL28gn6PvpIDe8=
    "], {{0, 0}, {81, 41}}, {0, 1}],
   Frame->Automatic,
   FrameLabel->{None, None},
   FrameTicks->{{None, None}, {None, None}},
   PlotRangeClipping->True]}, {3,
  InterpretationBox[
   RowBox[{"\<\"rule \"\>", "\[InvisibleSpace]", "126"}],
   Row[{"rule ", 126}]]->
  GraphicsBox[RasterBox[CompressedData["
1:eJytVUEOwyAMo/vJjnvO9oR+oP+/rdWEFmjsgEkkmkbBxopCeO7HZ3+UUl7n
epfLtsb6ODAHXjqb4ts8+PWxa5rxBq+6BH0AXn8kPhcu1o/AxfoR+II+AF/i
c+F9Q00aOISsIM0KAXyQZoUAPkgjjfbALg7SSKPd0MVBGmkkcZBGGkksjM+g
wQb6z9NIGkwYn0GDDfSfJ8L6uTTSSC/AcP2sCHoBhOcxuADC87iSRiKITfOF
81BipPNQ1Gj84vNdxZB5KGok81DUiEONkYUa42r/3RmbPkxhbPowhdG6HMas
+v0ZM/X9GHP5TsbRjV8CgAzI
    "], {{0, 0}, {81, 41}}, {0, 1}],
   Frame->Automatic,
   FrameLabel->{None, None},
   FrameTicks->{{None, None}, {None, None}},
   PlotRangeClipping->True]}, {4,
  InterpretationBox[
   RowBox[{"\<\"rule \"\>", "\[InvisibleSpace]", "150"}],
   Row[{"rule ", 150}]]->
  GraphicsBox[RasterBox[CompressedData["
1:eJytVtsRwjAMs9mET8aBEboA+/9RoDQvK7Idci2JI6PodCLHdXs+touI3Pb3
vr+i39HPCvY5LsfzW/UjjovKcYIM52sKl/MEqz+DS/Wa3wjjb3rLnzwuwJ88
jvzJ4/P+DH4GCTwENs+Q6SfrMBirLFnrGYZ96LNZr2cYYJTy4659QTXLZ8lT
nytUs3xq4421z/osje3c77M+S6OdO1TzgXKHagcjyB2qPRp9OfTy4dyh2qPR
l8MAozOHEY2x2sHYBY/ff1xjmz1+/3GNbfb6vYxG679Lxr+iUQcPc/4VjaOH
K3zjvZf3r2i05wXG8P1HGcP3H2UM33+UUVfzNzAu529g/Jt/J+Nf9X0YvY0v
OikM+w==
    "], {{0, 0}, {81, 41}}, {0, 1}],
   Frame->Automatic,
   FrameLabel->{None, None},
   FrameTicks->{{None, None}, {None, None}},
   PlotRangeClipping->True]}}, 1]], "Output",
 ImageSize->{232, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->154464441]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15480074],

Cell["Tab through a list of formulas:", "ExampleText",
 CellID->8403249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Row", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"n", " ", "x"}], "]"}], ",", "\"\<==\>\"", ",", 
        RowBox[{"TrigExpand", "[", 
         RowBox[{"Sin", "[", 
          RowBox[{"n", " ", "x"}], "]"}], "]"}]}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->418197353],

Cell[BoxData[
 TabViewBox[{{1,"1"->
  InterpretationBox[
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "\[InvisibleSpace]", "\<\"==\"\>", 
    "\[InvisibleSpace]", 
    RowBox[{"Sin", "[", "x", "]"}]}],
   Row[{
     Sin[$CellContext`x], "==", 
     Sin[$CellContext`x]}]]}, {2,"2"->
  InterpretationBox[
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "x"}], "]"}], "\[InvisibleSpace]", "\<\"==\"\>", 
    "\[InvisibleSpace]", 
    RowBox[{"2", " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}]}],
   Row[{
     Sin[2 $CellContext`x], "==", 2 Cos[$CellContext`x] 
     Sin[$CellContext`x]}]]}, {3,"3"->
  InterpretationBox[
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"3", " ", "x"}], "]"}], "\[InvisibleSpace]", "\<\"==\"\>", 
    "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"3", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "-", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "3"]}]}],
   Row[{
     Sin[3 $CellContext`x], "==", 3 Cos[$CellContext`x]^2 Sin[$CellContext`x] - 
     Sin[$CellContext`x]^3}]]}, {4,"4"->
  InterpretationBox[
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"4", " ", "x"}], "]"}], "\[InvisibleSpace]", "\<\"==\"\>", 
    "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "-", 
     RowBox[{"4", " ", 
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "3"]}]}]}],
   Row[{
     Sin[4 $CellContext`x], "==", 4 Cos[$CellContext`x]^3 Sin[$CellContext`x] - 
     4 Cos[$CellContext`x] Sin[$CellContext`x]^3}]]}, {5,"5"->
  InterpretationBox[
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"5", " ", "x"}], "]"}], "\[InvisibleSpace]", "\<\"==\"\>", 
    "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"5", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "4"], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "-", 
     RowBox[{"10", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "3"]}], "+", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "5"]}]}],
   Row[{
     Sin[5 $CellContext`x], "==", 5 Cos[$CellContext`x]^4 Sin[$CellContext`x] - 
     10 Cos[$CellContext`x]^2 Sin[$CellContext`x]^3 + 
     Sin[$CellContext`x]^5}]]}, {6,"6"->
  InterpretationBox[
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"6", " ", "x"}], "]"}], "\[InvisibleSpace]", "\<\"==\"\>", 
    "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"6", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "5"], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "-", 
     RowBox[{"20", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "3"]}], "+", 
     RowBox[{"6", " ", 
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "5"]}]}]}],
   Row[{
     Sin[6 $CellContext`x], "==", 6 Cos[$CellContext`x]^5 Sin[$CellContext`x] - 
     20 Cos[$CellContext`x]^3 Sin[$CellContext`x]^3 + 
     6 Cos[$CellContext`x] Sin[$CellContext`x]^5}]]}, {7,"7"->
  InterpretationBox[
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"7", " ", "x"}], "]"}], "\[InvisibleSpace]", "\<\"==\"\>", 
    "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"7", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "6"], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "-", 
     RowBox[{"35", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "3"]}], "+", 
     RowBox[{"21", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "5"]}], "-", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "7"]}]}],
   Row[{
     Sin[7 $CellContext`x], "==", 7 Cos[$CellContext`x]^6 Sin[$CellContext`x] - 
     35 Cos[$CellContext`x]^4 Sin[$CellContext`x]^3 + 
     21 Cos[$CellContext`x]^2 Sin[$CellContext`x]^5 - 
     Sin[$CellContext`x]^7}]]}, {8,"8"->
  InterpretationBox[
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"8", " ", "x"}], "]"}], "\[InvisibleSpace]", "\<\"==\"\>", 
    "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"8", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "7"], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "-", 
     RowBox[{"56", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "5"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "3"]}], "+", 
     RowBox[{"56", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "5"]}], "-", 
     RowBox[{"8", " ", 
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "7"]}]}]}],
   Row[{
     Sin[8 $CellContext`x], "==", 8 Cos[$CellContext`x]^7 Sin[$CellContext`x] - 
     56 Cos[$CellContext`x]^5 Sin[$CellContext`x]^3 + 
     56 Cos[$CellContext`x]^3 Sin[$CellContext`x]^5 - 8 Cos[$CellContext`x] 
     Sin[$CellContext`x]^7}]]}, {9,"9"->
  InterpretationBox[
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"9", " ", "x"}], "]"}], "\[InvisibleSpace]", "\<\"==\"\>", 
    "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"9", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "8"], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "-", 
     RowBox[{"84", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "6"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "3"]}], "+", 
     RowBox[{"126", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "5"]}], "-", 
     RowBox[{"36", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "7"]}], "+", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "9"]}]}],
   Row[{
     Sin[9 $CellContext`x], "==", 9 Cos[$CellContext`x]^8 Sin[$CellContext`x] - 
     84 Cos[$CellContext`x]^6 Sin[$CellContext`x]^3 + 
     126 Cos[$CellContext`x]^4 Sin[$CellContext`x]^5 - 36 
     Cos[$CellContext`x]^2 Sin[$CellContext`x]^7 + 
     Sin[$CellContext`x]^9}]]}, {10,"10"->
  InterpretationBox[
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"10", " ", "x"}], "]"}], "\[InvisibleSpace]", "\<\"==\"\>", 
    "\[InvisibleSpace]", 
    RowBox[{
     RowBox[{"10", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "9"], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "-", 
     RowBox[{"120", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "7"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "3"]}], "+", 
     RowBox[{"252", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "5"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "5"]}], "-", 
     RowBox[{"120", " ", 
      SuperscriptBox[
       RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "7"]}], "+", 
     RowBox[{"10", " ", 
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", "x", "]"}], "9"]}]}]}],
   Row[{
     Sin[10 $CellContext`x], "==", 
     10 Cos[$CellContext`x]^9 Sin[$CellContext`x] - 120 Cos[$CellContext`x]^7 
     Sin[$CellContext`x]^3 + 252 Cos[$CellContext`x]^5 Sin[$CellContext`x]^5 - 
     120 Cos[$CellContext`x]^3 Sin[$CellContext`x]^7 + 
     10 Cos[$CellContext`x] Sin[$CellContext`x]^9}]]}}, 10]], "Output",
 ImageSize->{578, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4442527]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9227],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Pane",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pane"]], "InlineFormula"],
 " to force linebreaking in the content of ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->115712588],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Pane", "[", 
     RowBox[{
      RowBox[{"Factor", "[", 
       RowBox[{
        RowBox[{"x", "^", "n"}], "-", "1"}], "]"}], ",", "200"}], "]"}], ",", 
    
    RowBox[{"{", 
     RowBox[{"n", ",", "20", ",", "25"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153278506],

Cell[BoxData[
 TabViewBox[{{1,"1"->
  PaneBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "x", "+", 
      SuperscriptBox["x", "2"], "-", 
      SuperscriptBox["x", "3"], "+", 
      SuperscriptBox["x", "4"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["x", "3"], "+", 
      SuperscriptBox["x", "4"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["x", "4"], "-", 
      SuperscriptBox["x", "6"], "+", 
      SuperscriptBox["x", "8"]}], ")"}]}],
   ImageSize->200]}, {2,"2"->
  PaneBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["x", "3"], "+", 
      SuperscriptBox["x", "4"], "+", 
      SuperscriptBox["x", "5"], "+", 
      SuperscriptBox["x", "6"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "x", "+", 
      SuperscriptBox["x", "3"], "-", 
      SuperscriptBox["x", "4"], "+", 
      SuperscriptBox["x", "6"], "-", 
      SuperscriptBox["x", "8"], "+", 
      SuperscriptBox["x", "9"], "-", 
      SuperscriptBox["x", "11"], "+", 
      SuperscriptBox["x", "12"]}], ")"}]}],
   ImageSize->200]}, {3,"3"->
  PaneBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "x", "+", 
      SuperscriptBox["x", "2"], "-", 
      SuperscriptBox["x", "3"], "+", 
      SuperscriptBox["x", "4"], "-", 
      SuperscriptBox["x", "5"], "+", 
      SuperscriptBox["x", "6"], "-", 
      SuperscriptBox["x", "7"], "+", 
      SuperscriptBox["x", "8"], "-", 
      SuperscriptBox["x", "9"], "+", 
      SuperscriptBox["x", "10"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["x", "3"], "+", 
      SuperscriptBox["x", "4"], "+", 
      SuperscriptBox["x", "5"], "+", 
      SuperscriptBox["x", "6"], "+", 
      SuperscriptBox["x", "7"], "+", 
      SuperscriptBox["x", "8"], "+", 
      SuperscriptBox["x", "9"], "+", 
      SuperscriptBox["x", "10"]}], ")"}]}],
   ImageSize->200]}, {4,"4"->
  PaneBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["x", "3"], "+", 
      SuperscriptBox["x", "4"], "+", 
      SuperscriptBox["x", "5"], "+", 
      SuperscriptBox["x", "6"], "+", 
      SuperscriptBox["x", "7"], "+", 
      SuperscriptBox["x", "8"], "+", 
      SuperscriptBox["x", "9"], "+", 
      SuperscriptBox["x", "10"], "+", 
      SuperscriptBox["x", "11"], "+", 
      SuperscriptBox["x", "12"], "+", 
      SuperscriptBox["x", "13"], "+", 
      SuperscriptBox["x", "14"], "+", 
      SuperscriptBox["x", "15"], "+", 
      SuperscriptBox["x", "16"], "+", 
      SuperscriptBox["x", "17"], "+", 
      SuperscriptBox["x", "18"], "+", 
      SuperscriptBox["x", "19"], "+", 
      SuperscriptBox["x", "20"], "+", 
      SuperscriptBox["x", "21"], "+", 
      SuperscriptBox["x", "22"]}], ")"}]}],
   ImageSize->200]}, {5,"5"->
  PaneBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", "x", "+", 
      SuperscriptBox["x", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "4"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["x", "4"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox["x", "4"], "+", 
      SuperscriptBox["x", "8"]}], ")"}]}],
   ImageSize->200]}, {6,"6"->
  PaneBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x", "+", 
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["x", "3"], "+", 
      SuperscriptBox["x", "4"]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["x", "5"], "+", 
      SuperscriptBox["x", "10"], "+", 
      SuperscriptBox["x", "15"], "+", 
      SuperscriptBox["x", "20"]}], ")"}]}],
   ImageSize->200]}}, 1]], "Output",
 ImageSize->{218, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->445726443]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->350219537],

Cell["Dynamic variables will only start updating when displayed: ", \
"ExampleText",
 CellID->235520186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{
       RowBox[{"x", "=", 
        RowBox[{"DateString", "[", "]"}]}], ",", 
       RowBox[{"UpdateInterval", "\[Rule]", "1"}]}], "]"}]}], "}"}], ",", 
   "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->263992853],

Cell[BoxData[
 TabViewBox[{{1,"1"->
  DynamicBox[ToBoxes[$CellContext`x, StandardForm],
   ImageSizeCache->{7., {0., 6.}}]}, {2,"2"->
  DynamicBox[ToBoxes[$CellContext`x = DateString[], StandardForm],
   ImageSizeCache->{168., {2., 8.}},
   UpdateInterval:>1]}}, 1]], "Output",
 ImageSize->{186, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1795149669]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Dynamic", "[", "y", "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{
       RowBox[{"y", "=", 
        RowBox[{"DateString", "[", "]"}]}], ",", 
       RowBox[{"UpdateInterval", "\[Rule]", "1"}]}], "]"}]}], "}"}], ",", 
   "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->319052144],

Cell[BoxData[
 TabViewBox[{{1,"1"->
  DynamicBox[ToBoxes[$CellContext`y, StandardForm],
   ImageSizeCache->{7., {2., 6.}}]}, {2,"2"->
  DynamicBox[ToBoxes[$CellContext`y = DateString[], StandardForm],
   ImageSizeCache->{168., {2., 8.}},
   UpdateInterval:>1]}}, 2]], "Output",
 ImageSize->{186, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1082730180]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8624],

Cell["Rules are used to specify labels for tabs:", "ExampleText",
 CellID->595446344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "x"}], ",", 
    RowBox[{"b", "\[Rule]", "y"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17204],

Cell[BoxData[
 TabViewBox[{{1,"a"->"x"}, {2,"b"->"y"}}, 1]], "Output",
 ImageSize->{51, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->185519556]
}, Open  ]],

Cell["Give labels explicitly to display rules in the content area:", \
"ExampleText",
 CellID->28069516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TabView", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", 
     RowBox[{"a", "\[Rule]", "x"}]}], ",", 
    RowBox[{"2", "\[Rule]", 
     RowBox[{"b", "\[Rule]", "y"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28356],

Cell[BoxData[
 TabViewBox[{{1,"1"->
  RowBox[{"a", "\[Rule]", "x"}]}, {2,"2"->
  RowBox[{"b", "\[Rule]", "y"}]}}, 1]], "Output",
 ImageSize->{48, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->34297911]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6227],

Cell[TextData[{
 "Successively nest ",
 Cell[BoxData[
  ButtonBox["TabView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TabView"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->430065048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"TabView", "[", 
     RowBox[{"{", 
      RowBox[{"#", ",", "#"}], "}"}], "]"}], "&"}], ",", "x", ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44429514],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   TabViewBox[{{1,"1"->"x"}, {2,"2"->"x"}}, 1], ",", 
   TabViewBox[{{1,"1"->
    TabViewBox[{{1,"1"->"x"}, {2,"2"->"x"}}, 1]}, {2,"2"->
    TabViewBox[{{1,"1"->"x"}, {2,"2"->"x"}}, 1]}}, 1], ",", 
   TabViewBox[{{1,"1"->
    TabViewBox[{{1,"1"->
     TabViewBox[{{1,"1"->"x"}, {2,"2"->"x"}}, 1]}, {2,"2"->
     TabViewBox[{{1,"1"->"x"}, {2,"2"->"x"}}, 1]}}, 1]}, {2,"2"->
    TabViewBox[{{1,"1"->
     TabViewBox[{{1,"1"->"x"}, {2,"2"->"x"}}, 1]}, {2,"2"->
     TabViewBox[{{1,"1"->"x"}, {2,"2"->"x"}}, 1]}}, 1]}}, 1], ",", 
   TabViewBox[{{1,"1"->
    TabViewBox[{{1,"1"->
     TabViewBox[{{1,"1"->
      TabViewBox[{{1,"1"->"x"}, {2,"2"->"x"}}, 1]}, {2,"2"->
      TabViewBox[{{1,"1"->"x"}, {2,"2"->"x"}}, 1]}}, 1]}, {2,"2"->
     TabViewBox[{{1,"1"->
      TabViewBox[{{1,"1"->"x"}, {2,"2"->"x"}}, 1]}, {2,"2"->
      TabViewBox[{{1,"1"->"x"}, {2,"2"->"x"}}, 1]}}, 1]}}, 1]}, {2,"2"->
    TabViewBox[{{1,"1"->
     TabViewBox[{{1,"1"->
      TabViewBox[{{1,"1"->"x"}, {2,"2"->"x"}}, 1]}, {2,"2"->
      TabViewBox[{{1,"1"->"x"}, {2,"2"->"x"}}, 1]}}, 1]}, {2,"2"->
     TabViewBox[{{1,"1"->
      TabViewBox[{{1,"1"->"x"}, {2,"2"->"x"}}, 1]}, {2,"2"->
      TabViewBox[{{1,"1"->"x"}, {2,"2"->"x"}}, 1]}}, 1]}}, 1]}}, 1]}], 
  "}"}]], "Output",
 ImageSize->{346, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44846568]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10189],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SlideView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SlideView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MenuView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MenuView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FlipView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FlipView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PopupView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OpenerView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OpenerView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PaneSelector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PaneSelector"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11156]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24122],

Cell[TextData[ButtonBox["Views",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Views"]], "Tutorials",
 CellID->14681]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->429440464],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]], "MoreAbout",
 CellID->838044374],

Cell[TextData[ButtonBox["Click-Interactive Panels",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ClickInteractivePanels"]], "MoreAbout",
 CellID->112997928],

Cell[TextData[ButtonBox["Creating Inspectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingInspectors"]], "MoreAbout",
 CellID->16968198],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->696058049],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->538109851],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "MoreAbout",
 CellID->976556782],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "MoreAbout",
 CellID->505725151],

Cell[TextData[ButtonBox["Notebook Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], "MoreAbout",
 CellID->662328663],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->667354543],

Cell[TextData[ButtonBox["Presentations with Mathematica ",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PresentationsWithMathematica"]], "MoreAbout",
 CellID->58349907],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->802803341],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->152707289],

Cell[TextData[ButtonBox["Viewers and Annotation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ViewersAndAnnotation"]], "MoreAbout",
 CellID->133928006],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->93991825],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->67189823],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->374525596]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TabView - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 2.7533100}", "context" -> "System`", 
    "keywords" -> {"tab selector", "tab view control"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TabView[{lbl_1 -> expr_1, lbl_2 -> expr_2, ...}] represents an object in \
which clicking the tab with label lbl_i displays expr_i. TabView[{lbl 1 -> \
expr 1, lbl 2 -> expr 2, ...}, i] makes the i\\[Null]^th tab be the one \
currently selected. TabView[{{v_1, lbl_1 -> expr_1}, {v_2, lbl_2 -> expr_2}, \
...}, v] associates values v_i with successive tabs, and makes the tab with \
value v be the one currently selected. TabView[{expr_1, expr_2, ...}] takes \
the tab labels to be successive integers.", "synonyms" -> {"tab view"}, 
    "title" -> "TabView", "type" -> "Symbol", "uri" -> "ref/TabView"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[18842, 558, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->186840660]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 522108, 10353}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4912, 103, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5535, 130, 1572, 37, 70, "ObjectNameGrid"],
Cell[7110, 169, 4375, 138, 70, "Usage",
 CellID->10106]
}, Open  ]],
Cell[CellGroupData[{
Cell[11522, 312, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[12000, 329, 658, 22, 70, "Notes",
 CellID->19271],
Cell[12661, 353, 69, 1, 70, "Notes",
 CellID->12368],
Cell[12733, 356, 3348, 92, 70, "3ColumnTableMod",
 CellID->6421],
Cell[16084, 450, 728, 25, 70, "Notes",
 CellID->15258],
Cell[16815, 477, 578, 22, 70, "Notes",
 CellID->4157],
Cell[17396, 501, 442, 17, 70, "Notes",
 CellID->9647],
Cell[17841, 520, 416, 14, 70, "Notes",
 CellID->18238],
Cell[18260, 536, 545, 17, 70, "Notes",
 CellID->55815475]
}, Closed]],
Cell[CellGroupData[{
Cell[18842, 558, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->186840660],
Cell[CellGroupData[{
Cell[19227, 572, 148, 5, 70, "ExampleSection",
 CellID->510385226],
Cell[19378, 579, 71, 1, 70, "ExampleText",
 CellID->16825415],
Cell[CellGroupData[{
Cell[19474, 584, 170, 5, 28, "Input",
 CellID->151410181],
Cell[19647, 591, 231, 7, 70, "Output",
 CellID->537101427]
}, Open  ]],
Cell[19893, 601, 125, 3, 70, "ExampleDelimiter",
 CellID->195750396],
Cell[20021, 606, 74, 1, 70, "ExampleText",
 CellID->525694706],
Cell[CellGroupData[{
Cell[20120, 611, 253, 8, 70, "Input",
 CellID->209729007],
Cell[20376, 621, 214, 6, 70, "Output",
 CellID->212164121]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20639, 633, 217, 7, 70, "ExampleSection",
 CellID->31550],
Cell[CellGroupData[{
Cell[20881, 644, 235, 7, 70, "ExampleSubsection",
 CellID->65322756],
Cell[21119, 653, 207, 8, 70, "ExampleText",
 CellID->65650879],
Cell[CellGroupData[{
Cell[21351, 665, 397, 13, 70, "Input",
 CellID->234501074],
Cell[21751, 680, 118803, 1979, 70, "Output",
 CellID->434079331]
}, Open  ]],
Cell[140569, 2662, 125, 3, 70, "ExampleDelimiter",
 CellID->469059840],
Cell[140697, 2667, 343, 12, 70, "ExampleText",
 CellID->348170879],
Cell[CellGroupData[{
Cell[141065, 2683, 533, 17, 70, "Input",
 CellID->320019421],
Cell[141601, 2702, 7595, 161, 70, "Output",
 CellID->100159105]
}, Open  ]],
Cell[149211, 2866, 125, 3, 70, "ExampleDelimiter",
 CellID->180064722],
Cell[149339, 2871, 190, 7, 70, "ExampleText",
 CellID->114039437],
Cell[CellGroupData[{
Cell[149554, 2882, 337, 11, 70, "Input",
 CellID->21436876],
Cell[149894, 2895, 300, 8, 70, "Output",
 CellID->175205293]
}, Open  ]],
Cell[150209, 2906, 125, 3, 70, "ExampleDelimiter",
 CellID->781651386],
Cell[150337, 2911, 73, 1, 70, "ExampleText",
 CellID->802119663],
Cell[CellGroupData[{
Cell[150435, 2916, 487, 16, 70, "Input",
 CellID->10642826],
Cell[150925, 2934, 175952, 2920, 70, "Output",
 CellID->114918723]
}, Open  ]],
Cell[326892, 5857, 125, 3, 70, "ExampleDelimiter",
 CellID->659640314],
Cell[327020, 5862, 65, 1, 70, "ExampleText",
 CellID->262312057],
Cell[CellGroupData[{
Cell[327110, 5867, 245, 7, 70, "Input",
 CellID->563881299],
Cell[327358, 5876, 237, 7, 70, "Output",
 CellID->352757376]
}, Open  ]],
Cell[327610, 5886, 74, 1, 70, "ExampleText",
 CellID->282026514],
Cell[CellGroupData[{
Cell[327709, 5891, 316, 10, 70, "Input",
 CellID->59021132],
Cell[328028, 5903, 380, 10, 70, "Output",
 CellID->83170510]
}, Open  ]],
Cell[328423, 5916, 125, 3, 70, "ExampleDelimiter",
 CellID->192611516],
Cell[328551, 5921, 256, 9, 70, "ExampleText",
 CellID->26336679],
Cell[CellGroupData[{
Cell[328832, 5934, 215, 7, 70, "Input",
 CellID->705204461],
Cell[329050, 5943, 198, 6, 70, "Output",
 CellID->87398853]
}, Open  ]],
Cell[329263, 5952, 125, 3, 70, "ExampleDelimiter",
 CellID->893102692],
Cell[329391, 5957, 295, 9, 70, "ExampleText",
 CellID->30642317],
Cell[CellGroupData[{
Cell[329711, 5970, 359, 12, 70, "Input",
 CellID->45283626],
Cell[330073, 5984, 416, 15, 73, "Output",
 CellID->349450020]
}, Open  ]],
Cell[CellGroupData[{
Cell[330526, 6004, 210, 7, 70, "Input",
 CellID->137908413],
Cell[330739, 6013, 748, 25, 70, "Output",
 CellID->169930293]
}, Open  ]],
Cell[331502, 6041, 449, 17, 70, "ExampleText",
 CellID->650749372],
Cell[CellGroupData[{
Cell[331976, 6062, 343, 11, 70, "Input",
 CellID->908772701],
Cell[332322, 6075, 800, 27, 70, "Output",
 CellID->226654514]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[333171, 6108, 236, 7, 70, "ExampleSubsection",
 CellID->103229521],
Cell[333410, 6117, 68, 1, 70, "ExampleText",
 CellID->65388748],
Cell[CellGroupData[{
Cell[333503, 6122, 197, 7, 70, "Input",
 CellID->11064820],
Cell[333703, 6131, 231, 7, 70, "Output",
 CellID->133644211]
}, Open  ]],
Cell[333949, 6141, 128, 5, 70, "ExampleText",
 CellID->106918330],
Cell[CellGroupData[{
Cell[334102, 6150, 351, 13, 70, "Input",
 CellID->47666740],
Cell[334456, 6165, 242, 7, 70, "Output",
 CellID->287943802]
}, Open  ]],
Cell[334713, 6175, 125, 3, 70, "ExampleDelimiter",
 CellID->615667952],
Cell[334841, 6180, 87, 1, 70, "ExampleText",
 CellID->990233478],
Cell[CellGroupData[{
Cell[334953, 6185, 310, 10, 70, "Input",
 CellID->117265673],
Cell[335266, 6197, 373, 11, 70, "Output",
 CellID->130483655]
}, Open  ]],
Cell[CellGroupData[{
Cell[335676, 6213, 421, 13, 70, "Input",
 CellID->181962849],
Cell[336100, 6228, 399, 11, 70, "Output",
 CellID->113165179]
}, Open  ]],
Cell[336514, 6242, 346, 14, 70, "ExampleText",
 CellID->280573160],
Cell[CellGroupData[{
Cell[336885, 6260, 598, 19, 70, "Input",
 CellID->703175254],
Cell[337486, 6281, 436, 11, 70, "Output",
 CellID->164625343]
}, Open  ]],
Cell[337937, 6295, 124, 3, 70, "ExampleDelimiter",
 CellID->19430716],
Cell[338064, 6300, 202, 8, 70, "ExampleText",
 CellID->57496222],
Cell[CellGroupData[{
Cell[338291, 6312, 444, 14, 70, "Input",
 CellID->573400473],
Cell[338738, 6328, 347, 10, 70, "Output",
 CellID->241250609]
}, Open  ]],
Cell[339100, 6341, 125, 3, 70, "ExampleDelimiter",
 CellID->117217923],
Cell[339228, 6346, 220, 8, 70, "ExampleText",
 CellID->265866031],
Cell[CellGroupData[{
Cell[339473, 6358, 1276, 36, 70, "Input",
 CellID->70540783],
Cell[340752, 6396, 1751, 58, 70, "Output",
 CellID->18788482]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[342564, 6461, 222, 7, 70, "ExampleSection",
 CellID->874938568],
Cell[CellGroupData[{
Cell[342811, 6472, 230, 7, 70, "ExampleSubsection",
 CellID->301135293],
Cell[343044, 6481, 60, 1, 70, "ExampleText",
 CellID->31590325],
Cell[CellGroupData[{
Cell[343129, 6486, 359, 12, 70, "Input",
 CellID->361215],
Cell[343491, 6500, 423, 15, 73, "Output",
 CellID->35428128]
}, Open  ]],
Cell[343929, 6518, 62, 1, 70, "ExampleText",
 CellID->545491469],
Cell[CellGroupData[{
Cell[344016, 6523, 101, 3, 70, "Input",
 CellID->6255894],
Cell[344120, 6528, 420, 14, 70, "Output",
 CellID->116411159]
}, Open  ]],
Cell[344555, 6545, 77, 1, 70, "ExampleText",
 CellID->262004834],
Cell[CellGroupData[{
Cell[344657, 6550, 168, 5, 70, "Input",
 CellID->248438261],
Cell[344828, 6557, 440, 15, 70, "Output",
 CellID->424167031]
}, Open  ]],
Cell[345283, 6575, 86, 1, 70, "ExampleText",
 CellID->110911048],
Cell[CellGroupData[{
Cell[345394, 6580, 225, 7, 70, "Input",
 CellID->172983550],
Cell[345622, 6589, 451, 15, 70, "Output",
 CellID->248738850]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[346122, 6610, 230, 7, 70, "ExampleSubsection",
 CellID->28933812],
Cell[346355, 6619, 94, 1, 70, "ExampleText",
 CellID->91248922],
Cell[CellGroupData[{
Cell[346474, 6624, 160, 5, 70, "Input",
 CellID->357476191],
Cell[346637, 6631, 213, 6, 70, "Output",
 CellID->26378933]
}, Open  ]],
Cell[346865, 6640, 343, 12, 70, "ExampleText",
 CellID->195982],
Cell[CellGroupData[{
Cell[347233, 6656, 227, 7, 70, "Input",
 CellID->174211887],
Cell[347463, 6665, 233, 7, 70, "Output",
 CellID->46101955]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[347745, 6678, 236, 7, 70, "ExampleSubsection",
 CellID->23597860],
Cell[347984, 6687, 57, 1, 70, "ExampleText",
 CellID->4462834],
Cell[CellGroupData[{
Cell[348066, 6692, 507, 16, 70, "Input",
 CellID->251898344],
Cell[348576, 6710, 785, 20, 70, "Output",
 CellID->302500079]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[349410, 6736, 236, 7, 70, "ExampleSubsection",
 CellID->31338098],
Cell[349649, 6745, 65, 1, 70, "ExampleText",
 CellID->254226910],
Cell[CellGroupData[{
Cell[349739, 6750, 434, 14, 70, "Input",
 CellID->88972026],
Cell[350176, 6766, 570, 15, 70, "Output",
 CellID->357097848]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[350795, 6787, 227, 7, 70, "ExampleSubsection",
 CellID->17226113],
Cell[351025, 6796, 204, 8, 70, "ExampleText",
 CellID->200884514],
Cell[CellGroupData[{
Cell[351254, 6808, 160, 5, 70, "Input",
 CellID->166164811],
Cell[351417, 6815, 214, 6, 70, "Output",
 CellID->386794453]
}, Open  ]],
Cell[351646, 6824, 125, 3, 70, "ExampleDelimiter",
 CellID->354279138],
Cell[351774, 6829, 467, 17, 70, "ExampleText",
 CellID->487543105],
Cell[CellGroupData[{
Cell[352266, 6850, 225, 7, 70, "Input",
 CellID->597916526],
Cell[352494, 6859, 231, 7, 70, "Output",
 CellID->54256445]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[352774, 6872, 233, 7, 70, "ExampleSubsection",
 CellID->184605663],
Cell[353010, 6881, 70, 1, 70, "ExampleText",
 CellID->61800453],
Cell[CellGroupData[{
Cell[353105, 6886, 404, 13, 70, "Input",
 CellID->306973721],
Cell[353512, 6901, 453, 13, 70, "Output",
 CellID->909580885]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[354014, 6920, 233, 7, 70, "ExampleSubsection",
 CellID->255922593],
Cell[354250, 6929, 71, 1, 70, "ExampleText",
 CellID->23083442],
Cell[CellGroupData[{
Cell[354346, 6934, 442, 14, 70, "Input",
 CellID->53301849],
Cell[354791, 6950, 576, 19, 70, "Output",
 CellID->223778969]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[355416, 6975, 227, 7, 70, "ExampleSubsection",
 CellID->281925],
Cell[355646, 6984, 209, 8, 70, "ExampleText",
 CellID->559398874],
Cell[CellGroupData[{
Cell[355880, 6996, 634, 21, 70, "Input",
 CellID->828399965],
Cell[356517, 7019, 1043, 29, 70, "Output",
 CellID->506177507]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[357609, 7054, 230, 7, 70, "ExampleSubsection",
 CellID->25485018],
Cell[357842, 7063, 74, 1, 70, "ExampleText",
 CellID->427831870],
Cell[CellGroupData[{
Cell[357941, 7068, 376, 12, 70, "Input",
 CellID->509921512],
Cell[358320, 7082, 260, 8, 70, "Output",
 CellID->293279829]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[358641, 7097, 223, 7, 70, "ExampleSection",
 CellID->19785],
Cell[358867, 7106, 222, 8, 70, "ExampleText",
 CellID->588000828],
Cell[CellGroupData[{
Cell[359114, 7118, 401, 13, 70, "Input",
 CellID->42918580],
Cell[359518, 7133, 130973, 2207, 70, "Output",
 CellID->687541614]
}, Open  ]],
Cell[490506, 9343, 125, 3, 70, "ExampleDelimiter",
 CellID->176205401],
Cell[490634, 9348, 221, 8, 70, "ExampleText",
 CellID->141692444],
Cell[CellGroupData[{
Cell[490880, 9360, 648, 21, 70, "Input",
 CellID->38655598],
Cell[491531, 9383, 2990, 70, 70, "Output",
 CellID->154464441]
}, Open  ]],
Cell[494536, 9456, 124, 3, 70, "ExampleDelimiter",
 CellID->15480074],
Cell[494663, 9461, 72, 1, 70, "ExampleText",
 CellID->8403249],
Cell[CellGroupData[{
Cell[494760, 9466, 523, 16, 70, "Input",
 CellID->418197353],
Cell[495286, 9484, 8023, 225, 70, "Output",
 CellID->4442527]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[503358, 9715, 232, 7, 70, "ExampleSection",
 CellID->9227],
Cell[503593, 9724, 342, 13, 70, "ExampleText",
 CellID->115712588],
Cell[CellGroupData[{
Cell[503960, 9741, 382, 13, 70, "Input",
 CellID->153278506],
Cell[504345, 9756, 5161, 162, 70, "Output",
 CellID->445726443]
}, Open  ]],
Cell[509521, 9921, 125, 3, 70, "ExampleDelimiter",
 CellID->350219537],
Cell[509649, 9926, 104, 2, 70, "ExampleText",
 CellID->235520186],
Cell[CellGroupData[{
Cell[509778, 9932, 393, 13, 70, "Input",
 CellID->263992853],
Cell[510174, 9947, 409, 11, 70, "Output",
 CellID->1795149669]
}, Open  ]],
Cell[CellGroupData[{
Cell[510620, 9963, 393, 13, 70, "Input",
 CellID->319052144],
Cell[511016, 9978, 409, 11, 70, "Output",
 CellID->1082730180]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[511474, 9995, 225, 7, 70, "ExampleSection",
 CellID->8624],
Cell[511702, 10004, 85, 1, 70, "ExampleText",
 CellID->595446344],
Cell[CellGroupData[{
Cell[511812, 10009, 208, 7, 70, "Input",
 CellID->17204],
Cell[512023, 10018, 200, 6, 70, "Output",
 CellID->185519556]
}, Open  ]],
Cell[512238, 10027, 104, 2, 70, "ExampleText",
 CellID->28069516],
Cell[CellGroupData[{
Cell[512367, 10033, 272, 9, 70, "Input",
 CellID->28356],
Cell[512642, 10044, 257, 8, 70, "Output",
 CellID->34297911]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[512948, 10058, 223, 7, 70, "ExampleSection",
 CellID->6227],
Cell[513174, 10067, 207, 8, 70, "ExampleText",
 CellID->430065048],
Cell[CellGroupData[{
Cell[513406, 10079, 247, 9, 70, "Input",
 CellID->44429514],
Cell[513656, 10090, 1427, 34, 70, "Output",
 CellID->44846568]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[515144, 10131, 311, 9, 70, "SeeAlsoSection",
 CellID->10189],
Cell[515458, 10142, 1696, 62, 70, "SeeAlso",
 CellID->11156]
}, Open  ]],
Cell[CellGroupData[{
Cell[517191, 10209, 314, 9, 70, "TutorialsSection",
 CellID->24122],
Cell[517508, 10220, 121, 3, 70, "Tutorials",
 CellID->14681]
}, Open  ]],
Cell[CellGroupData[{
Cell[517666, 10228, 319, 9, 70, "MoreAboutSection",
 CellID->429440464],
Cell[517988, 10239, 173, 3, 70, "MoreAbout",
 CellID->838044374],
Cell[518164, 10244, 158, 3, 70, "MoreAbout",
 CellID->112997928],
Cell[518325, 10249, 148, 3, 70, "MoreAbout",
 CellID->16968198],
Cell[518476, 10254, 168, 3, 70, "MoreAbout",
 CellID->696058049],
Cell[518647, 10259, 149, 3, 70, "MoreAbout",
 CellID->538109851],
Cell[518799, 10264, 153, 3, 70, "MoreAbout",
 CellID->976556782],
Cell[518955, 10269, 142, 3, 70, "MoreAbout",
 CellID->505725151],
Cell[519100, 10274, 169, 3, 70, "MoreAbout",
 CellID->662328663],
Cell[519272, 10279, 128, 3, 70, "MoreAbout",
 CellID->667354543],
Cell[519403, 10284, 170, 3, 70, "MoreAbout",
 CellID->58349907],
Cell[519576, 10289, 154, 3, 70, "MoreAbout",
 CellID->802803341],
Cell[519733, 10294, 180, 3, 70, "MoreAbout",
 CellID->152707289],
Cell[519916, 10299, 154, 3, 70, "MoreAbout",
 CellID->133928006],
Cell[520073, 10304, 171, 3, 70, "MoreAbout",
 CellID->93991825],
Cell[520247, 10309, 170, 3, 70, "MoreAbout",
 CellID->67189823],
Cell[520420, 10314, 179, 3, 70, "MoreAbout",
 CellID->374525596]
}, Open  ]],
Cell[520614, 10320, 27, 0, 70, "History"],
Cell[520644, 10322, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

