(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    147673,       4476]
NotebookOptionsPosition[    129616,       3828]
NotebookOutlinePosition[    131325,       3871]
CellTagsIndexPosition[    131238,       3866]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Repetitive Operations" :> 
          Documentation`HelpLookup["paclet:tutorial/RepetitiveOperations"], 
          "Making Tables of Values" :> 
          Documentation`HelpLookup["paclet:tutorial/MakingTablesOfValues"], 
          "Evaluation in Iteration Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EvaluationInIterationFunctions"], 
          "Vectors and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/VectorsAndMatrices"], 
          "Tensors" :> 
          Documentation`HelpLookup["paclet:tutorial/Tensors"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Repetitive Operations\"\>", 
       2->"\<\"Making Tables of Values\"\>", 
       3->"\<\"Evaluation in Iteration Functions\"\>", 
       4->"\<\"Vectors and Matrices\"\>", 
       5->"\<\"Tensors\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Range" :> Documentation`HelpLookup["paclet:ref/Range"], 
          "DiagonalMatrix" :> 
          Documentation`HelpLookup["paclet:ref/DiagonalMatrix"], 
          "IdentityMatrix" :> 
          Documentation`HelpLookup["paclet:ref/IdentityMatrix"], "Array" :> 
          Documentation`HelpLookup["paclet:ref/Array"], "Do" :> 
          Documentation`HelpLookup["paclet:ref/Do"], "Sum" :> 
          Documentation`HelpLookup["paclet:ref/Sum"], "Product" :> 
          Documentation`HelpLookup["paclet:ref/Product"], 
          "FunctionInterpolation" :> 
          Documentation`HelpLookup["paclet:ref/FunctionInterpolation"], 
          "NestList" :> Documentation`HelpLookup["paclet:ref/NestList"], 
          "NestWhileList" :> 
          Documentation`HelpLookup["paclet:ref/NestWhileList"], "SparseArray" :> 
          Documentation`HelpLookup["paclet:ref/SparseArray"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Range\"\>", 
       2->"\<\"DiagonalMatrix\"\>", 3->"\<\"IdentityMatrix\"\>", 
       4->"\<\"Array\"\>", 5->"\<\"Do\"\>", 6->"\<\"Sum\"\>", 
       7->"\<\"Product\"\>", 8->"\<\"FunctionInterpolation\"\>", 
       9->"\<\"NestList\"\>", 10->"\<\"NestWhileList\"\>", 
       11->"\<\"SparseArray\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Constructing Matrices" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingMatrices"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Operations on Vectors" :> 
          Documentation`HelpLookup["paclet:guide/OperationsOnVectors"], 
          "Precollege Education" :> 
          Documentation`HelpLookup["paclet:guide/PrecollegeEducation"], 
          "Tensors" :> Documentation`HelpLookup["paclet:guide/Tensors"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"Constructing Matrices\"\>", 
       3->"\<\"Handling Arrays of Data\"\>", 4->"\<\"Language Overview\"\>", 
       5->"\<\"List Manipulation\"\>", 6->"\<\"Operations on Vectors\"\>", 
       7->"\<\"Precollege Education\"\>", 8->"\<\"Tensors\"\>", 
       9->"\<\"New in 6.0: Core Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Table", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Table",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Table"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["max", "TI"]], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a list of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " copies of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Table",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Table"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a list of the values of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " when ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " runs from 1 to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Table",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Table"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]starts with ",
     Cell[BoxData[
      RowBox[{
       StyleBox["i", "TI"], "=", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["min", "TI"]]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Table",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Table"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["di", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses steps ",
     Cell[BoxData[
      StyleBox["di", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Table",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Table"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["i", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["i", "TI"], 
             StyleBox["2", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]uses the successive values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Table",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Table"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["j", "TI"], ",", 
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a nested list. The list associated with ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " is outermost. ",
     ButtonBox[" \[RightGuillemet]",
      BaseStyle->"ExampleLink",
      ButtonData->25318,
      ButtonNote->"25318"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->23775]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " to build up vectors, matrices, tensors and other arrays. "
}], "Notes",
 CellID->13000],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " uses the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " iteration specification. "
}], "Notes",
 CellID->12212],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " evaluates its arguments in a non\[Hyphen]standard way."
}], "Notes",
 CellID->21100],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["spec", "TI"]}], "]"}]], "InlineFormula"],
 " first evaluates ",
 Cell[BoxData[
  StyleBox["spec", "TI"]], "InlineFormula"],
 ", then localizes the variable specified, and successively assigns values to \
it, each time evaluating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7551],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " effectively uses ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 " to localize values or variables."
}], "Notes",
 CellID->25476],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    SubscriptBox[
     StyleBox["spec", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["spec", "TI"], 
     StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
 " is effectively equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"], "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      StyleBox["expr", "TI"], ",", 
      SubscriptBox[
       StyleBox["spec", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], ",", 
    SubscriptBox[
     StyleBox["spec", "TI"], 
     StyleBox["1", "TR"]]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6379]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->855837811],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(6)", "ExampleCount"]
}], "ExampleSection",
 CellID->8183115],

Cell["A table of the first ten squares:", "ExampleText",
 CellID->14504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"i", "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12946],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "4", ",", "9", ",", "16", ",", "25", ",", "36", ",", "49", ",", 
   "64", ",", "81", ",", "100"}], "}"}]], "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23888]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20308],

Cell[TextData[{
 "A table with ",
 Cell[BoxData["i"], "InlineFormula"],
 " running from 0 to 20 in steps of 2:"
}], "ExampleText",
 CellID->12157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"f", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", "20", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1430],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "0", "]"}], ",", 
   RowBox[{"f", "[", "2", "]"}], ",", 
   RowBox[{"f", "[", "4", "]"}], ",", 
   RowBox[{"f", "[", "6", "]"}], ",", 
   RowBox[{"f", "[", "8", "]"}], ",", 
   RowBox[{"f", "[", "10", "]"}], ",", 
   RowBox[{"f", "[", "12", "]"}], ",", 
   RowBox[{"f", "[", "14", "]"}], ",", 
   RowBox[{"f", "[", "16", "]"}], ",", 
   RowBox[{"f", "[", "18", "]"}], ",", 
   RowBox[{"f", "[", "20", "]"}]}], "}"}]], "Output",
 ImageSize->{480, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5123]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6464],

Cell[TextData[{
 "A list of ten ",
 Cell[BoxData["x"], "InlineFormula"],
 "\[CloseCurlyQuote]s:"
}], "ExampleText",
 CellID->4074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", "10", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4346],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", ",", "x", 
   ",", "x", ",", "x"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13837]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1981],

Cell["Make a 4x3 matrix:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->25318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"10", "i"}], "+", "j"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26611],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"11", ",", "12", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "22", ",", "23"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", "32", ",", "33"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"41", ",", "42", ",", "43"}], "}"}]}], "}"}]], "Output",
 ImageSize->{366, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16292]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17591],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\:f3a2", GridBox[{
     {"11", "12", "13"},
     {"21", "22", "23"},
     {"31", "32", "33"},
     {"41", "42", "43"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{
     "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
      "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{82, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->3832]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27123],

Cell["Plot a table:", "ExampleText",
 CellID->6461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Prime", "[", "i", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "50"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16991],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {6., 13.}, {
     7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}, {11., 31.}, {12., 37.}, {13.,
      41.}, {14., 43.}, {15., 47.}, {16., 53.}, {17., 59.}, {18., 61.}, {19., 
     67.}, {20., 71.}, {21., 73.}, {22., 79.}, {23., 83.}, {24., 89.}, {25., 
     97.}, {26., 101.}, {27., 103.}, {28., 107.}, {29., 109.}, {30., 113.}, {
     31., 127.}, {32., 131.}, {33., 137.}, {34., 139.}, {35., 149.}, {36., 
     151.}, {37., 157.}, {38., 163.}, {39., 167.}, {40., 173.}, {41., 179.}, {
     42., 181.}, {43., 191.}, {44., 193.}, {45., 197.}, {46., 199.}, {47., 
     211.}, {48., 223.}, {49., 227.}, {50., 229.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageMargins->0.,
  PlotRange->{{0., 50.}, {0., 229.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{154, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->333607183]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27330],

Cell["Arrange a table in a column:", "ExampleText",
 CellID->28498],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Prime", "[", "i", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17369],

Cell[BoxData[
 TagBox[GridBox[{
    {"2"},
    {"3"},
    {"5"},
    {"7"},
    {"11"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{18, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->332795252]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14179],

Cell["The index in the table can run backwards:", "ExampleText",
 CellID->24117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"f", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "10", ",", 
     RowBox[{"-", "5"}], ",", 
     RowBox[{"-", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2317],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "10", "]"}], ",", 
   RowBox[{"f", "[", "8", "]"}], ",", 
   RowBox[{"f", "[", "6", "]"}], ",", 
   RowBox[{"f", "[", "4", "]"}], ",", 
   RowBox[{"f", "[", "2", "]"}], ",", 
   RowBox[{"f", "[", "0", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"-", "2"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"-", "4"}], "]"}]}], "}"}]], "Output",
 ImageSize->{343, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19914]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1595],

Cell["Make a triangular array:", "ExampleText",
 CellID->1441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"10", "i"}], "+", "j"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "i"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5936],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "11", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "22"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", "32", ",", "33"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"41", ",", "42", ",", "43", ",", "44"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"51", ",", "52", ",", "53", ",", "54", ",", "55"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{455, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21867]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7028],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {"11", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"21", "22", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"},
    {"31", "32", "33", "\<\"\"\>", "\<\"\"\>"},
    {"41", "42", "43", "44", "\<\"\"\>"},
    {"51", "52", "53", "54", "55"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{
    "Columns" -> {0.28, {2.1}, 0.28}, "ColumnsIndexed" -> {}, 
     "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}],
  TableForm[{{11}, {21, 22}, {31, 32, 33}, {41, 42, 43, 44}, {51, 52, 53, 54, 
    55}}]]], "Output",
 ImageSize->{174, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->31453]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27909],

Cell["Make a 3x2x4 array, or tensor:", "ExampleText",
 CellID->13973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"100", "i"}], "+", 
    RowBox[{"10", "j"}], "+", "k"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17981],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"111", ",", "112", ",", "113", ",", "114"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"121", ",", "122", ",", "123", ",", "124"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"211", ",", "212", ",", "213", ",", "214"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"221", ",", "222", ",", "223", ",", "224"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"311", ",", "312", ",", "313", ",", "314"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"321", ",", "322", ",", "323", ",", "324"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{307, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11503]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->66821681],

Cell["Iterate over an existing list:", "ExampleText",
 CellID->38249001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "x", "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "9", ",", "16"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1028220083],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180430132]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->74435587],

Cell["Make an array from existing lists:", "ExampleText",
 CellID->154543735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"j", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "i"}], ")"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"i", ",", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "4"}], "}"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"j", ",", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "9"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126626299],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     SqrtBox["2"], ",", 
     SqrtBox["3"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{247, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73787570]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26569],

Cell["The table index can have symbolic values:", "ExampleText",
 CellID->6816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "^", "x"}], "+", "x"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a", ",", 
     RowBox[{"a", "+", 
      RowBox[{"5", "n"}]}], ",", "n"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1883],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SuperscriptBox["2", "a"], "+", "a"}], ",", 
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{"a", "+", "n"}]], "+", "a", "+", "n"}], ",", 
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{"a", "+", 
      RowBox[{"2", " ", "n"}]}]], "+", "a", "+", 
    RowBox[{"2", " ", "n"}]}], ",", 
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{"a", "+", 
      RowBox[{"3", " ", "n"}]}]], "+", "a", "+", 
    RowBox[{"3", " ", "n"}]}], ",", 
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{"a", "+", 
      RowBox[{"4", " ", "n"}]}]], "+", "a", "+", 
    RowBox[{"4", " ", "n"}]}], ",", 
   RowBox[{
    SuperscriptBox["2", 
     RowBox[{"a", "+", 
      RowBox[{"5", " ", "n"}]}]], "+", "a", "+", 
    RowBox[{"5", " ", "n"}]}]}], "}"}]], "Output",
 ImageSize->{483, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->515284247]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5385],

Cell["The variables need not just be symbols:", "ExampleText",
 CellID->28402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "[", "x", "]"}], "!"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", "x", "]"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5230],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "6", ",", "24", ",", "120", ",", "720"}], 
  "}"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95613470]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", "1", "]"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{"x", "[", "2", "]"}], "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "1", "]"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "2", "]"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28681],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "5", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "8", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "13", ",", "18"}], "}"}]}], "}"}]], "Output",
 ImageSize->{248, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->321454160]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1866],

Cell["Make a table of graphics:", "ExampleText",
 CellID->3687],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"BesselJ", "[", 
      RowBox[{"n", ",", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13171],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 219},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->289027418]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31245],

Cell["Generate the corners of a polygon:", "ExampleText",
 CellID->32764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"2", " ", "n", " ", 
         RowBox[{"Pi", "/", "5"}]}], "]"}], ",", 
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "n", " ", 
         RowBox[{"Pi", "/", "5"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "5"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6238],

Cell[BoxData[
 GraphicsBox[
  PolygonBox[
   NCache[{{0, 
     1}, {(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2], 
      Rational[1, 4] (-1 + 5^Rational[1, 2])}, {(Rational[5, 8] + 
       Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
      Rational[1, 4] (-1 - 5^
       Rational[1, 2])}, {-(Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
      Rational[1, 4] (-1 - 5^
       Rational[1, 2])}, {-(Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^
       Rational[1, 2], Rational[1, 4] (-1 + 5^Rational[1, 2])}, {0, 1}}, {{0, 
     1}, {0.9510565162951535, 0.30901699437494745`}, {
     0.5877852522924731, -0.8090169943749475}, {-0.5877852522924731, \
-0.8090169943749475}, {-0.9510565162951535, 0.30901699437494745`}, {0, 1}}]],
  ImageMargins->0.]], "Output",
 ImageSize->{154, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->86177339]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Sphere", "[", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"i", "^", "2"}], ",", "10"}], "]"}], ",", 
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"i", "^", "3"}], ",", "12"}], "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "40"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26115],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{1, 1, 1}], SphereBox[{2, 4, 8}], 
   SphereBox[{3, 9, 3}], SphereBox[{4, 6, 4}], SphereBox[{5, 5, 5}], 
   SphereBox[{6, 6, 0}], SphereBox[{7, 9, 7}], SphereBox[{8, 4, 8}], 
   SphereBox[{9, 1, 9}], SphereBox[{10, 0, 4}], SphereBox[{11, 1, 11}], 
   SphereBox[{12, 4, 0}], SphereBox[{13, 9, 1}], SphereBox[{14, 6, 8}], 
   SphereBox[{15, 5, 3}], SphereBox[{16, 6, 4}], SphereBox[{17, 9, 5}], 
   SphereBox[{18, 4, 0}], SphereBox[{19, 1, 7}], SphereBox[{20, 0, 8}], 
   SphereBox[{21, 1, 9}], SphereBox[{22, 4, 4}], SphereBox[{23, 9, 11}], 
   SphereBox[{24, 6, 0}], SphereBox[{25, 5, 1}], SphereBox[{26, 6, 8}], 
   SphereBox[{27, 9, 3}], SphereBox[{28, 4, 4}], SphereBox[{29, 1, 5}], 
   SphereBox[{30, 0, 0}], SphereBox[{31, 1, 7}], SphereBox[{32, 4, 8}], 
   SphereBox[{33, 9, 9}], SphereBox[{34, 6, 4}], SphereBox[{35, 5, 11}], 
   SphereBox[{36, 6, 0}], SphereBox[{37, 9, 1}], SphereBox[{38, 4, 8}], 
   SphereBox[{39, 1, 3}], SphereBox[{40, 0, 4}]},
  ImageMargins->0.,
  ViewAngle->All,
  ViewCenter->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 ImageSize->{364, 236},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{Automatic, Automatic}},
 CellLabel->"Out[1]=",
 CellID->166890578,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJycvQdcHEl2P443p7v1nX3nO/vss+/OvnNoUA6bgzZvAwIUUVaTBIgkJECI
LILIAglEziBA5JxzzjnnnIY8M0x/P79/d08PqxvJu/JfH4SmpqurXr169eqF
b5XIyzd0tQwv39C7evlfvzK9bKyrd9XsX780MmW+evlvFBT+RldBQWHpNwrM
5//HfOL+/j8Aesxf5iPz+xDz9xUtLS2l3W/2M39fZr55mfn3JeZfxd0ne/gn
rz3zhOCfvMl+w35g/mV+KxC7Nf6bf+cd9ptXpDWklf5nt85f+FZ+/iN1/p2v
8wv2m1d36/D9/fduvT/w9f7+KYrYjy/Jlf+y+8bv+Td+89yW/2u33u/4ev/0
Ey3/efeN3/Jv/ItcjZflyv+x+8av+Tf+7YXf+Huev3+Sq/GKXPnfd9/4Bd/H
f8jVeFWu/KfdN37Ov/GfL/zG2/wb/yNX4zW58h9333iDf0NJrsbrcuU/7L7x
Kv/Gvhd+4yX+jYNyNd6QK//bD28wXx79idr/ytWm+bbff6HaYr72R3JP35Qr
/56rvc3X/lTu6VtyZU7OFDb42sdeqPYqX/sruadvy5X/mau9zNf+Vu7pO3Ll
33G1F/ja5AvVnuP5rSr39GdyZW79KUzzbavJPf25XPkfudoTfO2TP9G2tPYo
X/vMT7T9W672EF/7nNzTd+XKnH5R6OdrX3yh2j187StyT/9WrvwPXO1OvraW
3NNfyJV/zdVu5/mt+0K1W/i2r8k9/aVc+Vdc7Ua+Nvf0lVMEZURQdgTlTFDf
sN+8ThKUGkEZEJQDQfkRVDhBRRPUMyv37+TKnE5XqOPb5p6+oUJQugRlT1AP
CSqBoLL3UqVKVOle6jNuwqT9GBKUI0ExnzU4QlwIKpigkvdShXupmiNU0/tU
3SFKXpc9v+9qPLW7vMm0qEpQVwnKlqACCN2k/fpF7+s3HtPrVaYUXhpRoxRe
rniP4t//kGuPeeMEQZkwY32J+ajwNlPQYanXDyBMEg/cKPrwZtM3N/rUjcfP
6s2cp8ZPU8/ocfl9jaNToYKni50ractnCYMbxC0vJfvYw675X7g3qLsPXHSb
0XMUGFttmBquGVEcRVzdXzBU6LFTYUCyXNI5Q5jeIGw8CNeow17ZX9yv1fDr
vXx/St9rxcxl09JaaGm4YvTTdHEzr1DK0/VbfjZ0VIlbVwk3270PHh0NS/0u
plIzvksvfupm7JpdpMg1UOLhQXtYiZy0P+CGxpGje5Ywu0nYcp/11Qibq4TX
HaWgB0ejE79NKD6b3Kr7ZNQ8ecnu8bZbtMT7Efzc4XPjBakrwlM7+t9yPdw5
Qfjr741xOZoaQeblXCyuNyodvFO2eK9E9KBAEpqJqHjEBCLCbuku9R4n7txb
BmqEHUV42yoFk8Q1krirQQRe2xPvdCQj6LuC1HOllQaV3berp1yq1v3KxCGF
iM5AfCzi7yPE+Jmd/VfPW40KBfxa/ReeUkuSCNQgkk0OF3p8VxNzoaXAuLPF
vmfUu0cQ0iWJb6NTG5Bdirx05AQj/qaMUoY05xNEkP6eBI5qJ5IIVVdMvX6o
2OXr2jDN1kzDrpo7fX3u/XOBfdvR3fSTNmTVIb8IBUnI9H6G0l/LlTmdpJDL
8/RfeUp9SSLlpGLFjWNt3poDcdcniuxm2nznx8MX1pLn6NwplA2jphP1NahL
R5Evt9f+mqPuLkmEaSilGx8uIQlzkghSJtJPKlYaf97qdmog4tp4tvVsncfC
QNDSQvyiKGOOLppE1SDqW9FQipq4F6M1i6f1jzytMaRi2Zn3Om+ojXvrLcXd
2SjyFraF70w82VkrENPVW2gRoGsavb3oqURzrIxWhrhgZSLz1J4q0y/aScKF
JJJIxYrTRzuNVcfctBYiLNaz3YR1j3YGEiQL2RJRmYhu2ED7EnrH0N+Grjx5
Wv9BrsztDArpeMpqY2jNJJVaT3w5YXpx1dNcHOtGFwTTLUkYK4CgBpJ2GgMS
jG1iagaTHejNkNHKEJdMKlWdeb/bRG2CJPxJIl95b7vGFxNG5wSuJuIwJ0nm
A7o2lu7LwlwZtpuAbhrDYkysYGoEo1XytP5GrsztkAopeMpeZGgtJA8OnFBZ
ua4ncrNDpD9y49CQg6EqLLVDxGyfU8CCBMvrWByWDOfLaPUjiQLlfR0aX00a
X1hleEwSleThoRMqy/raQqfbdLAX0iJQmYbuEkw3Yr0H9BgwS2NJiOU5zDS9
GK1JeMpSZWgtJo+MHz+1pWMCB1cEhSA9FVWl6GnG9AA2piBhLKB1YFOM1YmF
vnQZrY9Iooo8PHxCVWCgK2JWGUnUkx9Mqp7a0jKCrRMeBiDpMUry0VaL0S4s
j0LMWDsCgLHVNgTiuWZ5Wn8rV+bsFIUEPGUjv0sSkeR7E6TmzvlbsPTC/Wgk
ZKOoBs1dGB7DwiI2NyAWYkck2VwdV+Ds0r9n6fpw6vjpbW1j2DqDJGrJT2bJ
c5Lz5vSte/AKQ3QacstQ14K+QczMYG0Fwi1IRBBvCeR16vNpjOM11X6pxj/Q
Q2qK1Cxg4AvnOITkI60BFX1on8LICma3sCTG/Laoob9Syskz3OZIEjXkJ3PK
FyTnb+KWB0NlLPnxFHlBfJJpxxtO0QjKxpNqlHaiZQyDC5hZx7IIAjE9I5iW
p/If5cqc7akQzXPyEPcVqbpI3oCmD27Gw7MAUY3I7EfFNJpX0LWJ7g1UT00c
Br9b/voKQVkT1H2CimUoZei6KNawgoEPnGJB7m8lNbdIC1z0wa1YeOYishYZ
3SifQPMiejcwuI2eVaG8FyRPI2d7K0TwNHLa+03y8grpjAsRuJUNj1qEdSN5
DFmzyJ2DwhFOvBnilAlKk6BuEZQPoRu73yDviCGjicizm6QlzvviZhw880F+
2UcaS1Q9oBUF62z41CCyC6mjKJhD2TKK5iTyVtjzqQvlqfuYLb1KOm2pR0Ev
B1ZVcGyEwlEZt351nLimT9y8S9iFHnTJ+MSjWsWz+5zHpI4LabSj7I6r0bDK
gVctwrtAWmwrP8TlZNwshksj/LoQ2PesRyTvfXNejUIQT40dW/olSWipEGan
CWdzws/7UGjcsZjCkwktWo9HzBKWbWK2XUJ3PO8r++FcIkwL4VAPj3a4NQvl
rfvfyZU5ShQC+J4csGszWCoTPpeJSOuDTx58kZN8uqhcr6zLsmLauXzjfslO
SC6inyAuHDGua+6UvG39j3xrUp7686W7fNsmnBJM0NqXZ/95VdCpprRrndW3
e/vc++YDe4UxXXRKC7KrkZ+L/Gg8sZVv+x/41uTjE9Jx+PJPXfm+3JiO1Ihi
nQ+aHNX6QnTGMqxmat3Z/XUxYVGcNUeXTKCmHw1NaMxHeaB8X3+PHyJEz3i/
Ct68TnDn+wplNLvq/ladb0ccLy+EmK9nuIpqH0kGHtOLObS4QoymTXQton8E
/Y1oS5LvSxa/kJcMaV8e/FNPvq/HJFGn+tGw1slle0PRIwdJmj9dHYe+bMxX
QtgK9NEYE2N6CdP9GMyT70sW+ZD3WKV9ufFPffi+0sk9neRX85cvC+9Y4IEH
ksNRnoauMkw1Y6Mf9CSwCKxsY3lyZ7RQvi9ZzETeE5T25cw/9YNU96eSewaU
ldfO6uGmHbwfIC4BhflorsdID5YnIFpk9yl6m/k9+4wv8zqe8s6e6cmRfxrA
MYDc30eqbR2/Ths4wzkEYanIKEN1G7qHMTUHwRq2hRCJ6NXVCfleXuHbkbdo
pb3Y8U/ZlavwM5IoJ4+vqRjjohusInA/E/HVKOhCwzh6lzC+iVkRprZEUjv+
hwghnorcPdPDHf5pGCf05Md9pD7UXKEXDocsBNQgsRv546hZhMJLLWtgqXxF
69nonrQtK76taO4r8vaOaiCupcC+DH6tiBpE4gQej0n+jm9DPt4nbcOCXwWP
uafq8biaJWE//hI/xF2fibjIzZqCgjlfuxjPX3HPf8v0qbc471uD84qdOLc5
mvOcn4nmPb8lo6daYkej8BbT2nGCus559yEElbqPKjlANbxPtX9M1R+hXmxU
BnKj4owJqXtNEdq2xPUA4kbyAYvST61alS2GTptNX9JfuEpNaFLPRF+f376e
XPscVVLtratOmJsQju6KHlHv+eV+E9BwOnBAO2DO5P6GlbvQ1kZsazBryDrx
zFu/f27b2nJtc3x8l2v7mgphf564b0WE+30Qn0imlFxIb7+eOXE7Y9UlReQT
TweE4JEH/E2eGYX83iPtieJ5LuuJkyt2t2MsTmUihCKSbN/LDSRLUy9VV5nU
99o3znk1bAfVSGLKkJSDlHg88Vn348ciL6PSHi7zLcs847f5Hhj3O1SFyNA5
XO7wTVPwhe4Mk8Fah9EB37HF8FFx0hCd3YPiJpSXojwRGfY/1sMFuR5+zvfw
gFGfGvuq9T7vcjozGmo4l2m3Uue7Nhi5sZSyLikU0NXzaBpDeyfaS1Ad9Pz5
4NaCgqZcD7/ge4gliQqVwz26qtOOOqsht8UZXnRtOD2QgsUiiOuADjEGVjEy
iZEWtD/+sR5O8y3bc1+pENRlgrIiKA+CCiKoCII6iKeiRL/k9oVW1c+mtM5t
2JmKH7nQqUGoSkJvAebqsN0FjNCY3sHCKuYGdvrSfqznE/jB+uDsqzekwa8A
gnqsSOUpUpWH2EVXe5BifQRWF/0DL4055J4+8vuVS1o7t63h74ukGJRmo6Oa
9Q/XR0BL/ZF1xowe/8k1JaVFjaflJlt64yxnuatw8SxbgvIlqFAursfVfYfk
Hl1mLWcdf8Iw4YBx4fsmDV8a96oajJ3SmjpLjZ2i/htPRWPeZb3og0PM1nPG
kDZzgmcQYpKRV4LGZgwNYGEGWwJIGNdESAtXx16QYpWnKWb2HOokQRlzgUEV
ToG5ckSnKlEl+6i6o1TTUar8AMXFPThev6NBXDcmbt8jnCIPuWd/7lWr5tN7
0Xvq2r0VU4fNW7e2La6tGFN/5vv4vbSP/T2kxvZxE+jeg2M4gjKQWoXyTnSM
YXQRC5tYZRxJofiZ2Mrz6Sf59W8h0zAaHNlSBazNRfCCCZPUwzcqPr3RTpoO
nzKcPq81e4EaVOf15LtcBM7yAuF+WzHA/0hE4tdxJWcet+kmjpk/XrGLFbqG
SxhT4r4LvE2WrSkuO7O7x7y+Gz+9S1APODlnY7a/ls6vyjJpjLPuuBEFj2zW
68nqQdUk2pcxsImhbdRNjb7YGL/l+7SUcf33VwkjaVzyJGFmTtj7KN5LeN+n
6Du/lrN+Izq+iyYem5aO4jvmwts6Y9oUV9PmOPFAWynW4XBa8Ld56edKqg3K
e29XzLqWb/oxBnkeolMQH4U4b4SacPmYXV36ljQ+a0pQ9wgqjKDS9vCi0Pwe
VX6Q4iyZN0mtLRVnXAqHVRa8Oe8pbRyF8yhdejYj9vwxfsX3eZst/UEW2bxj
RHiShJ4qYXuF8LVTCgv6KD79eHL15dRe49TZO082XRNo3wj6gT/90FHipUcS
t0giUJl4on+g0PmrmnDNlmzDznqbnkGPvsWgXnFsJ53SzHkHeSiIR5bnP+MH
q3k39qzHmgCczBy6UfbJjdbvTYdOGk6d02ZkZkCdn9tXSS+cjYdJIRzr4dXx
bEZLfq+SjvEY358NW/ojs80ye9Q5IkgaeDxOhFxTSnL5MDdCrTRXq6rJvHbE
qXbFt1ocUo7YAiSl4kk4ElxIwoskkjWIsuuftrid6o/UH8+9M9PouTAcsrj8
eEGSNUuXjKOa8Uqa0ViEmpiFaF0FWc6Vs9h/znWnp0ncuEXY+Si6xb/nXfDN
/abT94con3kjj41bjsLbN7etdIeuUH/4iZnjZlbhU751DW6g6rJ0QiBBxRBU
PMGtfna0TiQRcVEpkwvUMhtnptHRSneV5hiqu/DmQKvL8MTD4bXoQTqlF7lt
KK5GWQ6KI9h4jmKJxqH268pjblqLkZbrue7CxuCd4UTJcu7OToUQTevoXEAf
4xe1oCt7NeeOlKpXzsryK24E9TM8ta++K4tO22sxIrUn5NEHsanKiZUXkrsM
n0xZJa/fjd/xjJD4+dP+jEhdU3gxHnzE93BCtmIYrXCDoLw4HmTvoyoPU80f
Um0fU7WHqT/x/GDENVSVyLlyuI6LCGec3F9r8nWP58XxuBtzRc4r7QGrk3Gr
G5kCumQBtZNo7kdbA1qy2Wgl0XT8szEDTYGLiTj8Lp0dQNcnYDAHi5UQtXDu
2yjjGjDu2xBGK6V69E2pQtciKBsuTsOQlbGHKlSkSvZSCrI88y94/uiThKsG
EWKwJ9Hl/exwlaLsy+V1JlUDdtULnlWiwDI6Mh/xKUgMR7zrC/Lnfb6HU+B3
PnU206XnRphEKd7Kec+y7mvLHg3zifNG81e0569Qw6epP/JcsuDcuvqrXwyS
RBSpWKnxfp/xyVkPw/VYh50if7otFhNZWC+HpEmC7k028jUyiKEaNhi8t0f1
u0UdSuhwG8HeSI9CdQZ6yzHbgi3G8ZwAFmisCLEyg5lG6V7wjtS85vZkNgcX
p6SVd1C79iOq4ytqgKSGlKmWzznrnR0L59v9gpMmZ0a0NfZkmhwpcycboy91
5Jn2NjkMjPgOrIT1Sx5305mtKKhGcS6KovDESkEeyfB8nh3BUxlX6aq9do6w
siZcAg74pH7+sFI9sPtK4NR1f4GFl9Dm7o79TaGNzsS1Xc6VqBzpu6S2wMrL
3ja1L2cML2+5WUqivOj8CDSnY7QMgmbQfcA4jVkh5ucx00kST8h9QyrH1y8Z
wNoRDwKRlIjSQrTXY7wHggmIF4A10FugN5aFs40dn/NZu3fOEHomhKm7klXk
frusjx1rvnPqPuUwfuXOop75qqG+wIAa0qTYffrXPNeMuOh19ql9NaZfdXmc
G4kxni5wWGi5vzwWubKaskTnz6FiAg39aG5EUw7K/aX5iVcYDX2NoG5zWVL5
TPXz+cjGM9mez/F8NDhOuOgSgc4HYyK/TM47k9F0LWvEInPZKW3bKxEPoxD0
AEEOEh9djo972XDwR5Pnzm2xxhdjLqqsauvTjg4IDURmIuoKMdCAhV4IWXEC
VhlzcQPLg+PN4eSBfvKE8KQJbeoG9zBEpSOnHHVt6BvGzBxWVyHchkiErc3l
JV1Dbna1lQmzy4TjnT1eDw4GJB0LKVEPb7scPno9bMkiaMvu/o6zq8TVQuSg
I43aMzy04TIX1ac/6DXVmPa4Joix2S7wkbREYDQFgkJaUitG2wZ6FzA4hIE6
tMRyLiQ3X69fIigLgvLk7NEnilQuQRUqUc9HODzDURkq6jx2PUZ3DSLKeG+G
5xfF8WerSwwbOmyapjyaNh7V70RXIqkQaalIC0Oi04y7dFf5JcvXYwvqV2mT
OyD3DzAW4XkT2uoe/MORnIGySnR0YGIUgnmIGHkTMj+i7ZVBbpX+C6m2oWoK
ygO2UXiYjaQaFHehaRwDS5jcwLyI+aH750fE9h6cH2h1kvC+RoTePZQQ+mVa
xqnsGp3cXvO8WYfcTc9M8YNkBEcj7AFC7UXeUs/gF1yiLZ/c16X+9Yzx5Y17
N3ei7tF5IWhMxnAhluuw0wkM0ZgUYXYB0910X6o0hs7b9JoEZc65PhGclq1g
bKXPqZ6vqf5vqaaPKfkY3fN5LMOXXeJ5bE0SMRqKBeaf1N8/1ZVkOFhhO9bj
PTEbNi5MHKGz+1HcjopqVGajNEycZMZn744tqGhLtB1AEg0Mg9Vv4LoX3GIQ
mYfsetT1oXcKUytY3sKaGIJt4ctS7h5sIQ1wwg3XI+GcjeAaPOlG0TjqFtHO
bLYbqJsXbHunICCe28r9TxHxxvuz7h0rjTpVk6vX2GDZPOTSsujfLA6vl8RX
IqUAGU+QEYzHNr/hx1JBHho5rramr79z1x6h/siMR20u+qsx3wHhMOgZYJnG
6iaWR+bbot/GD76G1jXC0JEwf7Tn9pOjtqXH7FqP2w6duz1L3VjW01/RowbP
UPKW2PO5K8PoXeUp8ieJvLNHm2+qDPnpzCZbr1R6r/eGb8492RQVrNPVS2ie
Qkc/uurRlkmXuHPc/Rl5sIukdk44wiwE5NczpAnOe8EyFr75iGtE/gDqZtAl
gMJLg1sMBfXT4zwFHJd/R96WqAfieiqcyhHQhtghpE4hYwYT7s1rgY07UTXc
srpPEomnlIpufFzvpdEZqztQYDna7DY+GjCxEjNOpw7Teb0obUVlJarSURzw
G37/riA/mFI5I7pqChs3BITiSSobhuhswcQgVmcgXgE2gW2JeHVUYZe7jO93
/SxhfZNw89zjG/1hQO53wfVnQ/p1gmdMA9du3xc7uEruWorsdTgOvvocb5zL
MnHYQPZLbZ6zzJ5dd/KzkRvnl33NRUn36PIQuvsJZgshZMMLNAa2MDaP8X4M
V+w0PPqTlLPfjZG36fOBsEwFeXZB2QmXI2Cdg/t1iOlFxgQKF1C8yFvV/8wx
yo9Vhd7bZ5JgWAjzCpTZjHV5TUyHTGwmjNKZg5xnEEMSxZpHW8yVB72uTsXd
XCp0WW0J2BiN3RBkrEuKBaiZR8s4OrrRWYXmRAUen/HhFHl+54wFzL3hFYOY
HOTVoKEb/eOYWWJldFvE/OyMz7S9zesORuPcUCNcrxIBd5SiHnyUmKiSVnIx
s+169tjtrBXn9G3vJAREI/ghgh3FXtoyJsrn6OTlVspdmSetx3M3jlFSJ79f
NNYVedrR8Q9QnICOPEzVYqMT9AgwQ2NxG0uzmGlZbgrh8uRvkU6S01Ewy4NL
PUiH7ZMxMMqHfR3c22BZvvA6z9ObbOOKZeffb7dSG/HXZRdFued6V+jmTNLm
Vu46XbFMEg5cyr3p7OfDNzQXPY03Yx0lBf50cwxGM7BSip0GGp1cAGl0CqOd
6C+Q8vRn5P52UnNb1RI692Efj8ACJDeghNnqp9EvwMQ2pkUYFKxIdyOpvX6D
8XvUiQg9xVSHD/KDVMpSL9VUmjR02zZOezRuBNbtRFbgcQFSUxV2/dYf8cak
vPwTz0tD6TzvGVBR39A1gbMbIsKQm46mCgy3Y2kY4tndvPTqzmLXEZ5DdmwA
San1/FfjFhdX/MyFSW50WRDdmYjpPGxWg26l0bfNmGHkof6Tyosm2kL324z1
hdwINKRiqASLDRB17wa61rAwhvFKaWbxbfKbUdKMPuEDozi4FCC4AU/6UTiF
mmU0rqFqQby732iTBLPLxRwncgyOVjp/3xx6sTvDeKDGfqTPe3QuZHQ7YYiL
Hb+M8iwUB7Mv/VT2UMqdP/BWkzHPnR7ylOj8TVh742EsUvJRUY+uPkxOQbCb
Dt/emJ9tPSrVbkQZeXTotNqKub7Yx56O90dxHNpyMFGFtTbQg8AkzcID3ptQ
O7mpb4S7TqxBlfEYNfnorcVMFzZHufgbo6rWxVibE0/XcLP4Omm3ox4Kwww4
VsG/AxGDiBnlcQtvct5COEnknjpQZ/hlt8vZ0TDD2SzbpVrvVW6ACq/SZfOo
H0dLL9pr0Zz6jL0jn9eV8kKGhjaT8lxt4/hNGPrC7TEii5DTjNoh9MxhfA3z
QiyKMLm2coTnHsuJavLDaXXNbaMbuHcPUWHIS0NjKYZasDgA0RSwxGzPpeRH
M8rnJFfNcccdD8ORlI7ScrS1YnQISzPY5uJ6jBUk2Vzsbk/ey9LxGuOksb6R
Uu2J9/sM1aeddQTcGN/oS8J8HoRVoFvE6FnD0CxGejFQ8mJjlSG61bmnZwgZ
Vu/fpLrDEKe9YB4PryLEtCBnCFVzaFllrYLWVfoQnsqu/hMr+p/MKV+ita1g
74ugWKTlorIW3d2YHMfqIkQb7JDIDybIC+LTljDzgUcsInORXYvabvSMY2IR
Sxts/HVDRM8JphSkqGaS8CGJQk6o2V9vBzvT6YGoSkBPDmaqsNkK9NMYl2Bm
E3OTmGp4Blsrj9KQjlwWJeHQs28wWucU58N7cFGvZILKVKTSFKl/kz612jkZ
ArMsuNUguBsJo+zunTAiPoCnooO/ZYd2Wax5B+YP4J2I2GLkN6FhAH0zmFrF
0jYb6VzYXCfPbJGWoO7DJh7++UhoQH4f6qbQtYzhTYwLMbAu5MbOjfdd8uCI
suqqtu6O7R0E+CA5CmUZ6CjDRAtWdxOqgh2sLmG+9Rk0r3xeUDp2GcZeA9iN
+N3kItbxBJV/iKr9kOo4RvV+Q3V9KfUvX1YO2zyVxMKqd72Bt6Sa6+wGaQ2t
h7BNwsMSJLaicAj1c+haZbf6vg3+bMBbpBF93BPXYuCQh4d1SOhBzgTKFlAj
QPkiLbN+X+L3uUry/UnlU8ILRrC8C99AxCWioABN9RjqwcI4thYh4TK79Nbq
8kSVPGpBHj0mHfPf4Sn8M+/5GxBG9xQtovfa5H1i36Bs13/2zvTVW8vXrq8a
UPNa1PtSDSTD6TpyMd9IgopjzCdZa7wmMtxR8YJuPOwL8aARcf3InELBAgrm
aWnvr5PGK+RDaKfgdik8mvGoF6GDUFDCX+fLoskPJklN8YkbMHaHazjC0pFR
jso2dA5hfBZLq9gUYluM1Y2l56OlnypzdifnRbNfnpbqdS4WpknYWSt5BR4K
SPs6tPp0eK9O+IxZyNqdh+K7nhJXW4mLocCKOiqTDDUuqXGPcxzT91Cl+6n6
96iWD1i8sAwZwEVGXiW9JCyapAj29XBtkeJfZNFWxgY40Eme3VK5iatesI7C
/WzEVSOvC3VjLM5hZANTQkxu088gr+XnUjoqWYRPk+ebgSrhrqMY5nw4MfLb
zPwLeS1GBWN3CgT3ckX+6QhJQGQIIt3xyLjZgFI4LJt/dTb4q3WXMAwlTNOP
mFd+bt6hbDpy2nDmgvbcJWr0NOe5sfmjg9LxcRrCkIuouTISIMOW/EwqAd+O
kSa0hgf0o+CYzebWH3chdxyVC8wKaFyFPDJAHo0pHdfb/D5ygR+XuzIRf31/
nuc3lfEXG0tN2zodOqZ927fCWumEeqSVIzsbObFI9xSGaXNxD1m09yxhbkE4
+Cm5J37oW0L6tWn6jer6Lpl6bLFpgptCa9256xzamyXg37klcoITcVtuptl5
lUYNrnBJPW9O6lOVqAJFqngPxc0Ry5dfSnWjzc7xIOinwq4c91sRPoD4MUQP
7cjjjZ8/YvkTGed5DaDL+r9EselnLT6a/YnGYxWO0z3+s3PRs6LUKbpgFBU9
qG1EfSGqY+lse9nYrx0nHLQJP8e94aGfxGeqJddeTek3SZmzSd50jeczBwGO
tK++7BTMf8h0vzR76cPlcxgXvliJKttPvS2TFMbHP8fFT7y5Ctn7qKr3qbYv
qL7vqEGSav2ceodvb7/caORxH9Ixv8nP8kV+rFaMN3riUJvp8TGfa0tJthsV
94W90eL5DLGoVEjXr6F9Ab0j6G9Fdz5d/YCTRqnf4aJBhF7f++Tex3nRGqUF
2lUtN2tG79YIfKvEIaWIzUNSCptEeOy6/ZBit5I/y+b1rTOcumdGE7tHN++Q
bt0nOt3fUcPHqVE1NnTxhqzeOycIHUPCyIWwCN17J/0D+8qvHTpP2I9etJ7X
uSEw0BfoU0PnKFk0+bDcWOXnXzp2zlb/q/NtF3lZrzn+2ZjxhVWvWzsJHnRZ
BN2VjtlSDn/bQ2NEjMkVTI9gvE7cFqVwkOecDUlEqCtlm71f6X28JV67u8Ri
oMN1aDJgaCN6gE7pRm4LiqtQlo3iSKTZ7I7/bVVC9xph5kzcCTvomPmJSw3p
2qvpPKVtv3LdcsPUcN1Eeg5D5icbnSNsLRQ9fPf5x3/6qFAltPlC2LB+6MLN
R5s293fuukpcuCidbD3Jn36SX/lP8eHV3W+lrFDg171Si/K3S9d0xW72iA5A
YRLaijDRgLVe0OPAPGMmiyBYwHzHQlv0Li8ekET26QP15t/1+lwef2w+V+q6
3BkomI4TbGYu0yXzqBlHcx/a6tGSjcqHf5ZpC2XC5BThdJPw9TkYlHAsovhE
TJtW7LhptOBOuMg5gD2N4GkldtZ5jZc6RrvcVCfctYgg+32xjz57kqKeUXE1
p8s0d8o2Z/1ehsgvGUFcfC3EXuS96+3Kn/H6EZ489a18RluTp7mZVFm/ZAQ7
NwRHIDMTdVUY6GT9qe0F0NJo9da6aKn3EM8ZxrGtPv3RwI3Tc95G6wmO4tIH
dEccprKwWQ66aQddGxicx8gAhmrRFitDl1McrN3rMhFucyAp8Mus1NMFVdeK
ey1L5lyKt+/nS0Iy2JMQsYGIclh0lZ6d+Tn3iq86EWOglOH8SVGYelWWVn2t
eVO/U/O8b5MwpF4SW4knBUhPYYf1mdz45LFoz+eKfA6Z48rPSHJVzRRmnvCJ
RUI+ihvQ2o+RGSwIsLENoRjr25tDk00KMp6kkfs6NL6ZM6G2PW9L4rzpoki0
ZWC8DGvNUkAgY08LMT+Hmc6dvlQZT65xxni89r5cx2OVoacbs/Tb6627hty7
lx91SWJlZy7y05EXisc3OcvnbY6Tnsxbaor5Ru/Xuqm2RVJ9OebDDXfHhvzH
lyLHOHXADKsyAyWB7Cuf/wRfXnouX+QjKp9w5TNc/gAy++gN0gAXPWETh8BC
pDSjbAitcxhYw0vj20zt7qV5/u0DnLwzrbE+195BZbX1a4a0y11EPEJuMptq
HWrEUi/EfB6A5vIAQ4vdyQoyXjkygqdGFOl+2HRXvTdcdzTn9nSj59xIyLwg
cY7OnkLpCGq60FiLBmbcvq9IqSMMGY1GEvmnDzcaf9N37+JElOlCnpPU03uN
wwAtsJHvjh50VqM5Sf5844txSj5D/wHfN3VJButmNrkUgspiPCCC4iywN5Xt
oRUB+1wENiCxH3lTqFhC9QrypzYUZF7QS9I1cHCIPCW6fAM2HgiMRGoWKqvQ
3YmpUawtQLzG2e1CkVAw/OcfNFe+6v5Wve9GnK8shN9az7nH5nxHknYEeWJJ
1TbrcHbPoL8ffcyYozlOvcpFrNJIxfoTHw0anZqT+oZvNkRiKA1LxRDX0SyY
qX8NI9PscYOBQoUv5EYtb2k+n1fy2EIOif4WYxBc4aylQMZVZIyiw1TDR1Tn
MarnK6rjcynHXiOtt07HwKwQzg243wX/7t3T5TJd0USeEp64CVPGEY5DTD7y
GtDQh/5pTK9gZYsNhKwKhd1jjTI+RZJErepHw9qnlh2NxKFOkuwAuiEBQ3lY
rsZOOzAoYYNpM3OY6kRv6qv8WwVasj/Ot3bC3OmsUNQ9QX8h5usg7AKGaUzt
YH6ddawmqr6UG6/8Kcvnc0keL8/FzFjLSZPQsSCM/RQtEg9Zl3xm06p6Z0jT
cuaq6ZKu3ooeNX1F6mO9dpw7wWjKoZEYC9uSoGRI4DelLX07R5rhkg+s4/Gg
EI+bUDiAhll0r2JoC8NbaJqb+Qs/3nByTxv55fzlK0JbKzzyRloUqrPQV4n5
NgiHQE8DSzTjQWF5eL03RZbdlfrZaus6+rS9PR49QGocKnPRXY2pDqwPg54F
2HMvO1ibF0/XKMifFZb3xp7PJ86yktlK0t3XVI9wctnjHfnBw9zvgho1Qwb1
gudvBGzc8RE7OkvuWood9ZZuUv8jW6EMf8w4jEMQ54YmcpiDl2Xc1uCM+N0P
Tpx8JjAWLUHlKlLpxK7Nz/ksb5GaCyrOoKJgkwv/esT1ImsSxQssiidxYPa/
eBq7SHLtzDXccmAd8cdJKClGexMm+rE6vZta2BGvjr0i0wCMLZfNnso5Lb5g
CktX3A9BQgqKStHSzG6yi9PYXoFkkw0G7WwuKXz9QpyUlzD56NYBvmfL04Sv
uVKE74eJiarp5Veyu0xypm2z1++li/2SEBSF0AcIdcID/Q4jSnqvwW8Zdp3m
Doz4cizNZYz7w1TzRyx6o+4Iu3PsHqCV4RhkKF/GGz5MNX5MdX1B9X5NtX9O
Kex6Ra+RDlunYmFSwCKGPNqZ31vcHL7N5kGV11Wv0waucAlDeAayK1HXib4x
zCyyUskN6nUp748MkWdFjIYw8oRrFMKykFmNqk50jWF8AYtcqGxdRM8IJr+R
44Z8ROT5POTiZG8/bYMq82dxfziQzDBFyidmZV0niYcXiCTr9/IDVSrTKcaw
aR6427Lo1ywO2039pSAzDE9ctoKp/+THy8aWjIhrHoRJzJ6b+e9bNHxzq1fD
bOK84fwVrfkrPJ7g5xSLj2E5fJW4ZkuYBipaPDlsXfr5nVZV66GzFjNXTJZ0
9JZ1qalLFCcvr5NfzpCGOOcGy0g2mJBQi4Je6eAUXp4Uol+wKltvzMrQWCPN
cckLVjHwzUVsHXJ7UDOJjmUMbmJUiL617e/keCMfR3s+B38m46D04JEptxxZ
D1GJqjhINXxANb9PVR+kFGSnABl/PuXS/gq7b1tDLvdlm480uEwMP5xciZmg
U0fo/D6UtaGqilVX5eF0ujWn0aT5LoNLxG1bwjXooE/6sQfVGgG9Vx5OX7+/
ZuGxbeMgg3Dfkvr+aoSFKeHsoeQd88GDvO8CG88GDeo8mjN9sH7bS2R/V+J0
S2yvO29K8euOPL+q7IirYTzvXsmdQMUiagUomRO9LdUSejsqbtCKhE0O/GoR
243McTD+ROUKe1Lq+///fHtHCto0ILTvEddj9pjlv2fe8PWNXnXjcU292UvU
7EVq6CQl0+oRpGLFlU+6Hc5OhJks5txda3y4ORK3JcjclJSusanq1kl09aK7
Du0ZdIWPjHNG6oSbAfHo3qGYmK+TCs+mtepnjFmmC+6mCL0S6IfhDLeUCYeL
bDqY+eB4gfC3Vox8+NHjZJXU8ksZnUaZk9YZayxMPQEBEQj2Q7AD7afHcU6a
X7iQgJtFcGvCwx486uN112ukDy4msg/YI1zdeNgLlZ/g0t/871xi/E/d84SF
LeEcfMAr85hf3YkH/Vf9Zo2812+5bt2x2bE13r6tNWVAKcishBTlve2XyGk7
nfUQG0nWfbohGsOZWC7DThONbgmGN9hQ4kQvhiskLeHcW7/noglep4mYG/sz
fb8qTjpXVX69vtu2ccazYetRzU50GRLzpIeldYgn0g/axBPHD/JCVMsyr9TU
mtX3OzTMe9cLg2okbOVcpCYjLQSJdwX+1C4O0vB5+ucnuSBDMeoeJ+4aEIEe
h2Piv0kqOZfaYZg+dTtt3TlJ7B1LPwzGIy8E3N7x0pbxIYM8PKR5av226U6A
G9JCUZOK/hLMN0EodaPnJFjawtI0ZpvXOmJlfGBWU/zpPYWWn9U/ONOZen2g
2m6033dsQQbxJwljkghRJTK5k2khKkTmtSMVzt83R1zuzjEbbHQaGfYbXY4Y
kSQN0FndKGpCWTkqGPs+RJJiyXkk7A7B+WCvKXNBJTMOS+zHbejyd7LI73E/
wh9m53M+SUSZ78/0/6Yk9WJ1jWn9gEPDok+dOKSaji1BcjZSE5AagMd2K/d5
Wfk5eXRC7YLYzAo+vngch9I8dNRhshtrY5BIwU2bNL2xsrPY9ReeO4EkUXju
vdbbasMB12bTbFZqfNYHIjYWU9d3ClcZ14RDxqVp7K/hTlmnauyrMfii2/Xc
WKTxXJ7jcpPf6kjU2krqqqRgma6aReMo2rpZ+H1LOl3qyd3FwA6Ly6VxuP5L
nCXoxUUfGUekaB9VyfzspeSjbP83PkWeUiq8fazh0bnuTNPBBqfRkQdjgqhR
OmUQed0obUJlKSpTUfJInGwu49OhYeWLEm0b3A1AeDLr4da3oH8Is7NYX4Vo
GzsiCLfW5ubaOT79OyNCpGLj2S/GLC+tPLglSvWgq8Po/hQsFEFcD3RKOJen
TOVIL7OhkkSpyuEefbVpF73VCBtRrg/dGIHhVCwXYYdxYtpF6FvFMOPEdGOw
jG4KZThzkcMb3eVYc49hlMz/ek+mVRnROsuJljuzje/RydinV/GBbuuXWv3K
1Kg6G+eT56B8FPbHOZij+V7rnROjwYbz2Q6Cxgfro7Ebq5nrdIkAdXNoHUUn
Y6JUouUJXeou4yBjO5zZPnEH5o/gk4r4ChR2sPPfv8gjuBZEGFtdFtyV6vs/
s+iOA72nVJfN9cX3HemkAPZQTXcBZuqw1cUiHVhJU2pS/WyKlUnFRtVPJ3XO
bzjd2Al1o7NCUJfMOHxYYPwbKXCL8W/mGP9mEtPNalw8wJE7LpLAbdTFe9i7
Uhj52s3GfCCTwHeOE7q6hIk9YRmw3y75qFPJl84t6neHLjjM6lqvGpltmOgt
GzzDS/l8+4/zsvb0sTGrK4JHt3cyfXhVvcKiW2n07GB4FePTGO/CUImoMWiX
l96aRBxpgnN+uJ0MvzIktCN/lIOzrKJ9A40rEqT6ItqUszr+RB4YVj21ZXgD
7h6IiURhJlqrMNYBwQgk3IkXUrGd/Hb5is4O++GbpctaYps7CPRDaiwqc1gP
aLoDGzxMC1hjPKAlNe6sBWMnPmL8XyWt4sNajZ9S3d9SLw2pUAovtxyTZZH/
E0/d8SSNqWkpE8anCDtTwsN9v3/kR8HZ34fXaUb26UbM3AhdswncuetD33PC
PdNVa0r+Vqvnc1beQ/+ZlLNK7SeVl80Nxf7OSAnhlH8pFpoh6uOgwHM7bKp5
aQLTDcutkdKYzbsc6u7xub2ltl83k7fEp8NgngP3OoT0IH4UyZOIGhShqgiV
j5Hvyb3DWQF/Iff3k2d3LlvC7j6CEpBRiJpG9PZjZhprAoi2wLr6jBNlQLOx
y+/XTuvT5k7wCUL8ExSWoKUJI/1YnML2MuMQcTlygrpA6FsQN3z3WicctC/8
3LFJ1WFA025ay2rFwHTdSE9gSPVr7p6z4Tz9V9Q5uLcFB4I/8gO/b6oS7heJ
IKu9sfc/fpKgkll0Mbflev7I7bxllxyhbzoeJSI8HJHeCL4hL8ny3uuP8JuR
yjZVjQ2DG/DwZi92KZHuJT1Ym4BkkcUQY1OCjUXRQtufeV77kUTxxQ877c6M
MxZd7t215sDN8YTN9ewNulyAhjm0j6C7DV0laIzePYXzilQ7nNhSs4TJA3gk
IaYU+a1oGEH/PCaZNc4yz5j8ZlnZELpu4D7Quq5wCkNIBtIrUdmBzlEWgraw
jjURU1lXlbilR7g47fUNfS8w85vQmjPhPTph06Yhq9YBYidviasj7WYmdNDi
aGB3b278rC9+nkui8JBagspRovIVKVl89QYXKY3WItJtPih8qFyZfKm+3KS5
07Zl0rNl/VGTJLoWSWVIz0FWPNJ9DsjxVF5bPJ/znJf3M1J96/wt2DLGaSIy
S1DLbE3DmJ3D2hqEQg5yvCWYnG5WkPGdsaRbzn07ZaO9HmIryfajm+IwmoPV
KkhaafTvYFSAyQlMtKIv469PBv2ZNMJZX1gkwrcE8a3IG2F1TusquKil1wUi
itSmTzjDNBykDn3SGWZh8MhEVDWyulA1jvZFDKyDgzDZnSH8TJUiPT9Iiv0+
vfBCToth3sjt3GWXbKFvGh49RlgYIrwRarV2j9pF47zx1O52mtsBGdZHEVQW
YxO8xybher+h+r6l6j+UauRfctJ/j8NK5eocqrL/rvXRhd5U4+FKu7Fu74mZ
kHEpVBCFXahoQDWzrOMZn+t5M/E3TJGdgR+dhSP9qmYw8MO9ZDAWcF47GkbR
u4jxDfbc9qwQgysLnLKQrpb9/adPrFmaSgLuIT0cdRkYrMBSG3YGuZtgFnew
IsDS0M5o4e94qXub3xcfkRbiU6G4kc0rpoRRPJlkmOrOGB2XD+TbH6shb9Gn
AnEjFaQlfSYQN1PhWYGIdqSOoHAW5cvg0mZB54lky6N5ft9VJF2sKzNu6rRr
mWIls1ESXYOkUk4yGVX2AHHmuxiht3b3RW4XNXQmzEOVrNLfs6n8yqZT/c7Y
BYt5beOVazrLelSXhlR7/5LLGTBGS86Jg3V6x3oczowFGc6l2a5Uea/1hG7M
Jm1s5a7RDFENM2gbYjGrHfl0he//fRa4OOWbaq4wiYNHMaJakTWM8jk0CNC0
hsoF0TPZpH/nZ2JITVNkbAkvPzxOQFkhuhrZexD4e242gC0x1iYXhgtleKF3
+ZlI1ThQZ/h1v8flqfhbS6Xua10h7HAY+1KFKKY+aHE8MRimP5ljM6/8EFQa
rCqgEoJrWbCpgmcb/HuA2gjG/FMh0i7uK7f+qjngXE8KI5z2Yz0+E7NhE1uJ
o3TWIIqkwlnMHpYt8NrFLMl0LiPhhmeJO7cIN9+99xM+CShSCWq5EDyiH7Ro
/mDLxkvs5ChxNhPaSfPSv+COEtWoHO3TPT7joL36yEqU6k5XBtPdiZjJwyaL
IKPRu4XhJYyNYKSObglXkPdJXvvJmeDi6q+T7tB+ArsK3G9H2AAihuFaP/tM
jobH/xJlpKb48h04BCIsBdnlqO/AwBjmFtmsilDEKDHJsmByF3HxS34GSlTe
6zc4ueButB3nLCl5xGIxZwrAen57W6hvxxyvLodZbuV4ShrDMZICAWNQ1+6g
fRN9ixgawVATejLYyzEUKy991GlzcixQfz7VRlAlhYInb2znrdGVy2icQfsQ
ulrRWYzGqF3k1Ls/7LCmxwk3igi02xfz6NPkNPX0qqtZPabZM7aZm/dSd/we
Iygcob4Itl53k66Jv2WBpPs6jh+bps5t2JqIA+7SyQEoi0dnDiYrsd4Kuh+Y
oDEnxMI8ZjvlM+uv/uQc/PPz+Pw2+f2SqhWMAuGZhtgqFHSjYQJ9yxjfwpQI
o5siDq/AvvYrKYcV61U+n9G5vO18m466j4JYtOZioobhcLHy0aGLJ1ZsjcRB
zpLMINQnYbAQS3XYkSYUpkWYW8bcAEZLSCKPGezFbyetrwoCLEQpjMSF0D3J
mM3HVjXoNhY1i5EljDO7cjN6Urkc1m4cleGVAbO3HCei9BXTnT8pDFevzNau
q7/ZOHi3ael+gzi0lo4rw5NcpCciPQDxFnt5SafYEx17BsjvBZe0xFa3cd8b
CZEoSkdLGUabsdwPsRQ5x1gm6+tY7pPmLOTyiT/OZfnT/RyX3yQvrat5wywJ
XmWI7kDWGMrmWZhb5RK9ixr7DS/B9eS3Kxf0YOOEoGBkpqKuHINtYG8C+Xha
84LQ0hIPfPAkhj3n0VPNSAK2RnZhsttYnRJNVrKVj46cPbFqcV3sx7hKD1GW
gM5cTFZjvZ2H3rIe1uIi5vskw3lcjIql4dc8f+8yW6QakXf9vRo31bYoqi/v
5nCTy+jowzFBNOsV07xXXIaqFBTd3yPbA5g3ExjHmD2dbkCbOsD9ISITkJ2P
ujr0dWNmHOuLEK9zZ3m2twVzbf93/sqfOOA09mukF7RScaeCVaMPenCrZEp2
Gw6HGP4P8puV49dp03vwjsTjHJTUob0X41MgP51Xp2gjO3gEIDaZM7ybMTqI
5RkIBRxoQAjxxlxXZxqLP/xo5sR5oelNeHogNgIF6WguZy9FWBqAmMPwsnKz
sQXB6NJgtgz981ueo0EsJPlQg9E3/e4XJ6PNFgqcBS0P18di11cz1ujiFdTO
oYXzkjvL0RS35weJNVYjnMj93aTGtqoxdF1gH4LAFCSXoqQFrYMYmsHcKgTb
2BBjaXNNmouUQwb8NUflM73yJxFlZw45Tv+KPNBB6uPSPdjGICgfaY2oHETH
LBj5IqmdS46wDcajdKQyVjRD+xjGFrG4iVUR8yMZX+LvTPg5+cmsymVa1xpO
fgiJR0YequvQ04Opp0DAtHBna3XsrafnjZMnxVr1Dwevn5y/Z7gRbS/J96Ob
o9nDBYJS7DTS6GKPCWBsEmPt6MtW+oFvpoz9c4qFQiWSyouMlXrGjbU93TMQ
UYmMdlSMoHWeywVvs7lCab5bLkb943yTP/Uqi7hwK/6XKg7QiYBTLovbT+lH
8TRqV0CeXlexhX4wXNIRXoWMLlROoHWJhcQObqN9ZfNlKbcO9ZOXxJo2uPUQ
PkmIL0ZBMxoH0T+DKQGLGRYwc70tah5peP3pueLim/s71b+e07+y7WwhCfdE
Tjh/0GCpEWLGvBijMStmb9RYGMZYiYxbWpypGH1yb5bZe2WeZAN5eV3ZERdD
YJEGL85OTOPsxIpllC/RSLF6hltPS9mznPqjXFmG7OXj+HclFxJgWQLPFjZe
HsTeBAzyqkDZB4ZJcC5FUBsSh5E9w4Jnn4xtc62/Q2oISCtQD2CXjIASJLZw
GONZdK6ifwt9m6iampRlNv/Ac+cJC9pQXdPSp+0dEPQQaY9RnY/eOsx0Y3MM
9DwX39xgZHdqbaRQxh1LDn2Re2Z/nfnXXV7nh+OMpwrt50h3+kwsTPLgVAvf
TgT0Ac0N3ClVP/5O2+fL0rPckb+h/H94qqVW1olYGBTAooqPx72mzNhQsbAr
gH8DYvuQMYmX8ufB8p/dH/9DKj8HBskTwnMmtIUbfMOQkIbicrS2YXQYS3PY
XoWEDU/S2+vTMj1zj8VN7Kk7+1HfjZPTXvorcTZbhd7i1nDJeAq9WiiR1AjR
uobeOQwOYKAWLVHcaXeFV5/OE7KezPNHyOpoNsMti/xwefLXNKJhkAfrajg0
QJeDWrLPZBnmXFJjS80M+p5wjkZoDjJqUdWNrgmMLbH3gzArYFm40z7eKhuB
L3vU4EDPie9mTa9setzaiblH54fQzckYLcBKLSQdwJAEk0LMzmO6c6frsQJ3
Q99foQ6fT/2fnyPNbFGaHZTiRNmxc2c9Xk4nqLw9VI4iJb17/x3y02FW+XjA
PBpeuYiuR3YvI5toW2aFlBHVmplZzgJk0Y7k0TF1jXVDgx1XB0Q8QHY86nMx
WI2FDoh+OBPJgoqkSKYXoP4vcmWZ58zl6NhMrJbszwMOOlB4mGr4hOr6ihr4
nnWeFXiUgT3OheJWJjyr2SsJn4yx9yvmzePALuUfz6qe29G+Aft7eBSG1DTW
OOhqwdQg1n44bSgWrQwpPH1b+/8uM/J36v8jL+EkT7/C26cIHVPCxFPJMna/
TcGn9k3KdgOad2aomyv611cNqXkdSvq/Lbyi/AhXM2BeDusacFbzz8hPZshL
O5pWuOXLQuPiclFQi6ZuDE5gbglrmyyaflMo5jBnL/2vnP0vubLMC1CWUcga
VVIw5SXC0XaPd9CRgPSvQ2pOh/XqhM2YBa/debBz10PiZiNxNVi2ohR0pLTt
ayUviFStcc0fjoyfUIiURpQOoGUaA9y5OEaE2+enfoK2/5Yry+5SI3kuvszP
G7NPWmgQ3vpK4a5HE6O+yyi4wAYCx6zzBG7ZIr80BMcjIhiRbnh0nbsrjLFk
zekTvjBJgGshQpuQMoCiafZIWv0qFL78Kz0n79cRcuWfP0XTLr7hb7m4kb86
8djkYJ73N5UJFxpKTVo67dumfdo2Q5ol8XVILUV2FnKike4+509xVL1OWguP
h8IgEw5VrHMZOoDgfnDorpf/V3oU5cpvydHzFk+PK0kknSDKzI+13NfsSzIe
rXCY7Lk/PRc5LUyZoPOGUd6NmgbUFaA6Wph2K53n8CvP7VP+f3F4Ta7Pn/F9
BpOKJaePdpqrj9+/tphsu17hu90bJZxPE4qKt+i6VbTNoWcYfc3oyhGXucvu
FX7juX3ukSu/JNfn3/J9xpOKzepfTJpdWvOx2En0oMvD6e5UzJZgu5G77nhE
hMll9j6RseqVmvuJeCoG9Uyfe/mnr0q1h+z6VentI1ZcnsqBoD7BU2dF3mXP
Ce/tVVNZua4v9nBkQbRFiWgvxGSD7BJjKch5ZQ5zLbt3/r773P7lswS7qFNt
Dk9ygSOCvwKF0Xl7qGJFFtzI42iP7554O4Cnbgv7OblvUOXEtpYpnNwRFslK
YUMVhjqxOArhvAxlvLm6Odcag6f81Z+kjuv176VYS5JL01lxx4qSFKniQxSb
RfmGGlKhBpVZzJH0HjE/LgGaxB1KY2rKslT/JNUhjA95SnT6Fix84RePpAKU
NqK9H2MzWBJgk4P+rm2tKkThKa/vJ6nkLPlfc/gMIw71pGtMmHruuR13wL7o
c8fm445D523ndCylRyP0ZYColL1U8X6q/ijV+jHV9glVdWT3PjPOZn2H/Hae
NIf2fVbZhRQjvQWVw4yCw9A6JoQY22YM9a5wPOVLPVfWnqHzN5xus5Kq3wvE
Xdu9vsFHgzK/C687FzlwLWLuZqg0aEwRWg6EQRB3O1j5pzfavjcdOnV9+oLO
/GVq9hLVq/HX+ZRXj8vyKY7c/SPSU4RvkudXVO/BIBbOhQhhdOIgCmdQuYyq
ZXD3Ab8i82dejPbfclfnPiIJE1XC59qeKLf3nsQoZxddzm83LZywK1zzyCUJ
bQ320i87X6V7j9/3Lv7Ot/WM74i296Kx+6aFo+iOhchGf9OS6rokd1fZm9IM
xS1ZAj2VM1YKFNmNXzqWV0m3nQuJsCiFWzOLUFUI4d+X/v8s8jjz58rIb7kQ
ZjpJ+KgQSSaHCn2+r0m60lxh3t5zt3POv4MkdFS4u7zs94SGfBSbeTyx9nJy
v3HynHXihkss7R1O+/sjwAX+Zltu0kj/KzLdxq7gM/xFzuw103kHqJoPqY4v
qP7vqP7vqaZPKYVsvv4f/0/0Jp9g8QkJGkS5+Rdt/hcGU8wmqp1n+gPmFmNn
ScJelQjW35Pk9lFOtHpJgVZFi3nVmFOVwKdCHFyM6Fw8foLkCCR5I/qHuPjb
/EpklqyWIWHkpngrco91zoe2dd/Z9p6ynrx8a0nPeNVAZ0Wf6jtL7d5i/+cX
p/ofSaJI9WgfqVh44nCnucakn+FKiuNW9QNRf9zOYpaYJIJUiEyToxXeqk0J
Wp2lt/o6XQamHg5sRPVKnnQiuxlFlSjNRWkc8ryWI7R/g2eiyNc1Cdvbih4P
D/g/ORZUoRHSdTVk0uiRwMpf7OApcbGnXU2E9pRs7/mv/xPlNcePTZNE3fFj
k6aXN3ytdpJ86MpoujcT0sueTu6rufFNj++lsUTz2XKXxe7A5Zm45a2MRbp4
BtVjaOpFawNaC1AftZ5hIYtPcvvYu1zo1V2HCLl7MD78y9ScM1kN13KGLHKW
7mZue6ciMJ4OC0WEF0ItBPcohce8tBAvTv3v2DPr366QSi3k9yv6+jvuTogL
QvETdJSw9xmTRNmJ93vNTs36XF9LdBSVPaC74jCTha0ymm4UoXMNA3MYHsJw
I3qzBCUuBXvYDKE0D6Gyu+/IkM6yeCczG97Hidjr+7LdvyiNPVtbZNjYdqd5
wr15PVCWnMnIZv2FTD/EmcXxb+99oVFxz/9Afr3CXvKvsn7RBPYeCI1Cdg4a
ajHYDVKpSe2LaaMrW55WknhvujgS7RmYLMN6M9BLY1R6KmQBc30YK236jOr+
mt0BLnG7mBd3cjqB26oipLde7saSmXHdIYk4daLI9OMG71Pdj/WHSm3GOr0m
pkMnth6PsamO4i5UNqCmGNWJKPSI4mfrwAuNi9O1/6CsD/KrRTUTmHrDJx4J
hShpYuNmLK6BFOjqS5wdEfkIecloKsJIA5Z7sSM9TyWgsb4FwQSL7JaekKO4
PPpDgnqsROUrUdWHqaYPqdYPqVoOEsxSJrvdxock8k8daTFTGfbRnk28vVLm
ucFem5G8uZ2/QVetoGkWncPoaUN3MRojZPvbkRcaF7cT/UrVgU2oanrAOg4P
i5DcgpIhVviYGTxnDOt7CIxAaiaLHO3pwPQo1ubZYxZgj1nQ4o056YjeuMBu
Y7r+xPXHB0yKPjBp+tq4T81g/IzO0xG4YHahfjpqcm7Zy0yU4EqXBtGdSZgu
wGYNaPZ/1BBhbAWTYxhvQk9KMM+J919oLNyu9E+kM02a7WgG43Y2e79LbC8y
J9lZUzXGdU+4xyA6D3n13DmIKfYcxLL0HIRIMrkyyZkbRkaEtTtxN/qwe94X
Xg0a3jxudcvSQnTbcMuSGtejfifVDns61L5dNNAW3rOlY/xRGMdmL8arsdYB
ehiYprEoxvIyFvuEg1kKgfy8cJGCZ3KFz0VG/JqNWO5p1kyGSQluVaLoPk1S
O6fdcCsavnmIb0B+P+qm0bnCXwDaKdjmAnCW5wiP24qBD49EcrS/PnkrYc0h
RnwvVOLjD39X+N0UuWtJbzFhtHO3yvF16jocXRAaiqw01JdhsBULgxDOcIkA
NkW5LRGMPORH8NmLj+Dv2DjZ4cGLp1YdzMTh7nR+OFrTQRrvnAoE4914V3P/
L8IY8uf+v8auPCrK64rbc2KtMUmbpOnJ6WnanqTpOf1jEq2axTaprc1JYzpg
xKIIBqODskT2hCiICIqK7KJAlEUWAUEFDCPIKlAYFhl2hFH2fUAGZoBh5vu1
nfe+70voGzwJ/8Aw97vv3rd999137++iRI38IUPD2UHqJLvI9/q6AvuyOrcK
lf899fly/aUSLkmO9BvIuoqsKKT5TobJeC2ele6ct/aCTxip0HFdjvJatHSi
fxBTU5jXkfC5Jf3ShLpnVbQwoz74QTqs5cd5y+Aee/0xP5K0kZ+FOj41qxuG
YdjlwKsMJxQItB1K9JySB8/xcj/nsrn03HZF6qfKIo92UjQosmvmSocxo4XL
a0ShaSQLUZqFohh9pjuV/xnptmFLdxwKR9A1XLmLvAZU9aB1FL0ajCyQC/6+
OR3t9zV8joYHNYkvfYsWIKKdfrSiXuxKEZAV3u61OMi5BiLsMjLzUF6N1naC
pDGjNq39XIuNbXze3PP16abP163euOe6rfn8XlW662DJybHmqMnBZL6+0Aju
9UHRhcZGNJWiPpO7G8zfDz4ttZ3ZeQZHUnG2EIn1yO1G2QgU07g/i5opjvhu
6M6xdjeNJeTxzfIkBNq89l1Z4xZZ9Vsy6uF5SvQxfa9m6/g+slvcG4jjiYgv
QK4C1Q9ISSF+ZF6ytdH6ehnjQgh8XE2uSbPiTza1uu4YPO84le6nK4nQk2pE
N42zxUvGmgUSfNI5jp5HUDWhq4hTxPJ3Rj+WhsEhG/4ViFIioRspvfibqM06
ayGFwzHhzc/zNrtWbnVt2e7y0OrQ0F7ZiB3FfH1PGK0dP0gnPorZdLA5EI/A
fEGPl+unCRafaW5a2Rs8fRF5AVkZKC8i5WZ2bO13sdOc8zak8iWLctBfjBni
t+RoCtciQZoae4jBGp0y+TC+tdGc7CVevpLjMRtOZ28JKfsoVLn7fO/Bs5NH
gua+OKY/6jbvI+t1oJFfZDysfrDsVN5fflWM8EYkPEBqL2I7FqV/7LSwN8hO
4FQcEm+goML0Em2Ufjgpc1gK8kfCBRRcQ52c+CvVvL9yhM+qWsDMGDehPMyv
TBqfYCU56SyJOL0xPvG95G8s0xX2Gd1Hro0fTdMFJRlDYxEVimjfpZBDq0TE
8N0rSs7f/VnQM5kfDf2Jo9GHbKTUWizLG/u59F/ancfhGY/wXFyrosA722f2
uuDYaVy8jBs3UVmO9vsY6qHJTDTeg2Qn6h7PTjRTHXgf1bk9kiueGzPD3s9P
/6So+GBpk2d5f0DZTFjJUuwdJJtYpyPzEtJOPAyUbRDa37uiFq/x644mFLmL
qBoktHmDrHojyRQxmYisf2+1MKLUWn9B6mS0jsKX2YisQFoLpB9MWn5OconO
JSHlNu5Uo47mEo2oMTMHnR7zS9y09rGjoMtZqeSqzfrbPn8uj7ZUXD+orPBu
azvVMRzdrk1qNWbdJ573whKU3ERR3FKmh0Roed+KurzK74w0J+oI0cXh6gZH
+Wbn2q1ObdsdHu6UDVjL+q1lrR/L2JOw6JV6kR+jC3DOo868Vkhlxj3B8ElG
FJ/S04m6QXROo1dHlkXvPFfZ/+AwPY4HU/tMJuiVYCGR222qPba9PWb/oxyv
ocpTYx0x46Mp4wu3RrmiAVSqUNdMEL7qb3Il50TMus+oXtRw4YXjx4dfbYcO
SDwCJH6XNwfl/4UABHTanhk+FPTY1Vfn7an70lHjKeuy/7/KDg7CvQD1yzwv
/YKzjcPRXERXI72NRAGUTcBkDVZOg/dIRdFEIdN2encDweUl1ScOCNrclK5X
7NvafcxmJMb1cc5JXeUFfUfq0lje0kKpnlPwhdMGoWpHdzlX//XvhVGSPVEb
JytJgLskMpwm+JdZp7U4pA96pWr8k/Rn4oxhEVxkICLc50/LxHHh69ZZxsL5
Nk5UI5yGK/HOqqMSWYzJJhbvDkzmv0pKoHLr/yr7TJC+WLqp00Y67uOgi/Y1
XA+nUA65GCmDrp73LRowPIuxIdMJal6ZLPosHFeW3nSqPmMrSTi2KTv2g4Jc
m7s1LqXdvmWTZ0sWY4qMCflIzUJGAjJC+V132dNiZJFpdh52k3iEkquDE+Tq
wDJAZXt8zMFn5nO3WTeHKRdZ0y7Zqv3CfnVP+m6/tbXW080YfhrX4lGSDWUx
Buqg6aBeSRJ6YYDmMdQd9C6dtOpiJvmr/PubGEpX7TfIT26rSrBplB9pafRv
7wvvmLncZsxQIreOl3k17oRrU534pUH+8TtxDlpI3PdJgvzXR8S/E5v/jyu1
NkkPHBPHvC/P+V80BIdyIQFciKv2pEyU/Y70/dEd+wzOPggOR1IKcVnWVaOn
FRO9mB+HUWOyE8HN6xamOun7n8wZ15VlN1kx0RaSwgPvNpyyepDsPFDkP9oU
McHbG6uh6CBITPeLoEhbuhOw8r5AzuY7JBFObyaffSc79ePbxfZ3lG5FA/6F
mpAC/cVcJGQg5QpSzyPBqzdA6P9npX8akO43fOoH3xhczCIwsuUNaO5G3wjU
FMZgYQmzCzqKYEca9FxZ+qcIjtL6uoMf9p46oKZ9vNZkMcwVG7jaBTRr0DUG
lYoYiV0Fi9WRT5Q/0lKS5b65KHx7VZZ9wz1PZUdQy1h080LifS5LgbxyyL9B
YTq+iVhIcaI1QwgW1rylH1wuITgHCWXIV1L/5jhUsxhYIP5NikFAevGLlSX/
GYkYFn8Sgjn511xjDvpM1oECXDuHR0YCkzSuxlgPBqrU9XFPkj1zl6TC++/K
aLvuHI/+6lPDD2JGJ1NHlnIHubuPUNUBRT3qi1F7jbsTyO86a6Vuxp1RcM/C
uVIkNuGWCiWjxKlZNf3dbddRM6nF+GASx9C3x9Z0CCMQZXlpqJWjpwaTbdD3
0tRp0zlldgGaUcNYw4rvxJ9K3yje9Xart9VAtMvUjQBt9YXF7jS9+rbeUD6P
eg1axwmQck8TOgu52ou0Csyq1RYxJBLIrxKhSpJnRxFnSO/6mcn5iiCnEHOx
SWVpz7n6IywWGTkoK0NLEwZUJtMFejESyKCbGh+pf4KsEsWObYMe++fI5Uk4
V3mV68rHRAUWBSfJEkamMdqLwVptU9K3dZMCBKm+4yZWPlvDv0n3LtqdgP/X
iM8lger/bkMHhcRTa0mgukbPjWgm2TO2sMO/qZT+c9rZ2RAShPR4lOagtRTD
jdDyuQ6TwIyJwQQmW74SWgwyk+UXWHbH8zRx08fi9C0kVtHIlQESudKlJXfY
rRoD+z4X3zNVUkutvTsCzlOXUgHqa/CwA+oBLKph5C2r+VnNRIu30FawmRRi
fBz17/1EGsDJ0hBQjNj7yFAhfxjycWT3G1aMqnhG+tH0Tk/B9ZNFXT/NKvSN
EajN2UUSMqXWasQaUCFmLYs4ab9leL/O94cj7EIJ+EBsCW40ofwR7k+ga5Yc
6h9o4SboE2bGVcQpY6NiBNwpb4PtFfjKcaGOxHfcHkLRBApGuSPCU1Fm/MR7
S7ZuPX8/LSuA8NlZkCjGjIMYRcTeuYt19+LMnhDjTdg69mL1vMvmT5j+ZG8i
wwQutBIZ/YI9zYcI/FLM+LGUwQKvdLDrnKUU67jRemN0pycWGnsTc1KgyqFU
33d3fFxo/RalZucie/Mtrv7blJqNcGT79EuBt5xSrxHkZam8BJ53KRWbFcWO
rDg7Syk1m+nHxoyIVcjuUWo2s5KNjxFrilVTajafl52lDoIktZT6WUE7luqA
wLOBUrFoEOxK+lTg2USpWbQSNm5PrIvVSqlZBBg2OnK3wLuDUrPYOuxOsUvg
3U2pXxS0Y2NYxYpRDykViw/HIhdbCBL0UWoWQY9F8v1Y4D1EqVnkRBb/9UOB
9yilflmQl6USc7cnKRX7LduGWBtmmlKz8rHyvydIQKEazHRn+2aLwFtHqV9h
vmXR5t4SeC9S6l8L2rFUIiIPLUJoNqLs/BDrif2HUrOzhZ17Ymzff8lv+gQ7
G9m5/YdlT/AVhF4T5GYpXxckIZR8LdPXGQp25b62jDdfpZhdd+zO8JtlbfC1
wtnVz+48v1rWBu1ps92FzSh8eVkbdC7RPiAas5QvLeNN55VZ3BO7E7+w7Aka
qW+227I7/XPLpKGja7abs/bXumVt0BEwe1uwFuSaZW3Q3qGzimjMUj61jDeV
/P8iCByE465IQaONqH9vtfAf6utbtepH/wM6U3Di\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27311],

Cell["Make Pascal\[CloseCurlyQuote]s triangle:", "ExampleText",
 CellID->32657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"i", ",", "j"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", "i"}], "}"}]}], "]"}], ",", "Center"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1405],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"{", "1", "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "1"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "3", ",", "1"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "6", ",", "4", ",", "1"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "10", ",", "10", ",", "5", ",", "1"}], 
      "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "1", ",", "6", ",", "15", ",", "20", ",", "15", ",", "6", ",", "1"}], 
      "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "1", ",", "7", ",", "21", ",", "35", ",", "35", ",", "21", ",", "7", 
       ",", "1"}], "}"}]},
    {
     RowBox[{"{", 
      RowBox[{
      "1", ",", "8", ",", "28", ",", "56", ",", "70", ",", "56", ",", "28", 
       ",", "8", ",", "1"}], "}"}]}
   },
   GridBoxAlignment->{"Columns" -> {{Center}}}],
  "Column"]], "Output",
 ImageSize->{206, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->552106926]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{"\"\<text\>\"", ",", " ", "s"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"s", ",", " ", "10", ",", " ", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20580],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->10], ",", 
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->11], ",", 
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->12], ",", 
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->13], ",", 
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->14], ",", 
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->15], ",", 
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->16], ",", 
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->17], ",", 
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->18], ",", 
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->19], ",", 
   StyleBox["\<\"text\"\>",
    StripOnInput->False,
    FontSize->20]}], "}"}]], "Output",
 ImageSize->{526, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->490478798]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22530],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Display of Tables",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->13675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"DigitCount", "[", 
     RowBox[{"n", ",", "2", ",", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "128"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24320],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdlUtOQkEQRV8cOXTgwIEDNcYYY4z/v9IioiKigICAfGLi2C3U0mpJLEGN
fQd1SEzneOr27X4vhNXP79bXXFEU9vv3t/5/ZqW4FinyfIr/X4BfhF8CL6e4
zwrya5hfB28gvwm/Bb8N3sG5d9G/h/32wQfY7xD+CP4YfIL+U+TPMH8OvkD+
Ev4K/hpcyqveU8prvr+JdZ6byCZWXxm+DH8b2cQ6TwX5Spwv7pAXK1+Fr8Lf
Rzax7v+AfrH6H7G/WPvX4GvwT+gXq7+OfD3OF8/Ii5VvwDfgXyKbWN/L17zm
95/Eeh5gF+v5NKNPzegN7GLdr4V8K84b2MXKt6NP7egN7GI9nzf0i9UPdrH6
O+jvRG9gF6u/i3w3zhvYxcr3ok+96A3sYr3/97zq/mLdH+xi3b+P8/ejN7CL
df4B8oM4b2AXKz+MPg2jN7CLdf8P9IvVD3ax+kfoH0VvYBerf4z8OM4b2MXK
T6JPk+gN7GL9Dk/zOiv9AOXFlIU=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 1.},
  PlotRange->{{0., 128.}, {1., 7.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14840166]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Prime", "[", "i", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10998],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2"},
    {"2", "3"},
    {"3", "5"},
    {"4", "7"},
    {"5", "11"},
    {"6", "13"},
    {"7", "17"},
    {"8", "19"},
    {"9", "23"},
    {"10", "29"}
   }],
  "Grid"]], "Output",
 ImageSize->{40, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->512146452]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"GCD", "[", 
     RowBox[{"i", ",", "j"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4489],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmU0KgkAUx0dsrduEAtdtXXWB2tiyA4gkuojC2nuDFi0Cz+E15hxzjXpP
GtEIcSDI4j8wvs+fq3nOPGcTndPdPjpnceSv8+iYZvHJXx1yctmWEOLGcypI
v5NWT3bRsFmvh7jSwzL3ThovDUcp5UgpWbosi6Jg2235HX4VePDgP87POF5V
1bwtPc9jDgyYX2U6dVGWpbbrugiCQNvgwYMfH79lLgzDRU+NI+f/cpp1Q995
V59fkiRxW/5B6w48ePDG/JLzqIfQEnnI68vr3edbNnjw4MfHv+2teY9Qhv04
GDAjYjp1oc9B8uW/6NC6Ag8evBF/6alNxL4WM7infd73Wg8jhZkY\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->125166789]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29744],

Cell["\<\
Print the values of the table index while the table is being generated:\
\>", "ExampleText",
 CellID->8388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Print", "[", "i", "]"}], ";", 
    RowBox[{"i", "^", 
     RowBox[{"i", "^", "i"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26610],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->418866746],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->91382881],

Cell[BoxData["3"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->763995336]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "16", ",", "7625597484987"}], "}"}]], "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->228243353]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47400043],

Cell["Monitor the values by showing them in a temporary cell:", "ExampleText",
 CellID->622989007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Monitor", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Pause", "[", "1", "]"}], ";", 
      RowBox[{"i", "^", 
       RowBox[{"i", "^", "i"}]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "3"}], "}"}]}], "]"}], ",", "i"}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->198921070],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "16", ",", "7625597484987"}], "}"}]], "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->355551270]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Relations to Other Functions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->21479],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Range",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Range"]], "InlineFormula"],
 " gives the sequence of values of a table iterator:"
}], "ExampleText",
 CellID->22716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Range", "[", 
  RowBox[{"1", ",", "10", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6300],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3", ",", "5", ",", "7", ",", "9"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21396]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"i", ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "1", ",", "10", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16853],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "3", ",", "5", ",", "7", ",", "9"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11458]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20830],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 " evaluates the same sequence of expressions as ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ", but does not return them:"
}], "ExampleText",
 CellID->24593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"i", "^", "i"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30806],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[88]:=",
 CellID->29849],

Cell[BoxData["4"], "Print",
 CellLabel->"During evaluation of In[88]:=",
 CellID->14854],

Cell[BoxData["27"], "Print",
 CellLabel->"During evaluation of In[88]:=",
 CellID->24272]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"i", "^", "i"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26160],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "27"}], "}"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12294]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12054],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Sum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sum"]], "InlineFormula"],
 " effectively applies ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " to results from ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->26333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"x", "^", "i"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146],

Cell[BoxData[
 RowBox[{"x", "+", 
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["x", "3"]}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4229]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"x", "^", "i"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10471],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   SuperscriptBox["x", "2"], ",", 
   SuperscriptBox["x", "3"]}], "}"}]], "Output",
 ImageSize->{73, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10428]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10559],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Array",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Array"]], "InlineFormula"],
 " iterates over successive integers:"
}], "ExampleText",
 CellID->22241],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"#1", "^", "#2"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "8", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "9", ",", "27", ",", "81"}], "}"}]}], "}"}]], "Output",
 ImageSize->{289, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22688]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Array", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{"x", "^", "y"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16366],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "8", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "9", ",", "27", ",", "81"}], "}"}]}], "}"}]], "Output",
 ImageSize->{289, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12033]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"x", "^", "y"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->26685],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "8", ",", "16"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "9", ",", "27", ",", "81"}], "}"}]}], "}"}]], "Output",
 ImageSize->{289, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2270]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->128619277],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " applies a function to successive elements in a list:"
}], "ExampleText",
 CellID->84895798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"list", " ", "=", " ", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"9", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->665105309],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "6", ",", "1", ",", "0", ",", "0", ",", "7", ",", "4", ",", "7", 
   ",", "9", ",", "8"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->56451580]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Last", "[", 
     RowBox[{"IntegerDigits", "[", 
      RowBox[{"#", ",", "2"}], "]"}], "]"}], "&"}], ",", " ", "list"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->129933737],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", 
   ",", "1", ",", "0"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->110624928]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " can substitute successive elements in a list into an expression:"
}], "ExampleText",
 CellID->68446400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Last", "[", 
    RowBox[{"IntegerDigits", "[", 
     RowBox[{"x", ",", "2"}], "]"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "list"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->268498511],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", 
   ",", "1", ",", "0"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->307782157]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Nested Tables",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->25329],

Cell[TextData[{
 "Using multiple iteration specifications is equivalent to nesting ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " functions: "
}], "ExampleText",
 CellID->32261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"i", "+", "j"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "i"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22860],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2208]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "+", "j"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "i"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8982],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->22162]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Programmatic Table Construction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->32506],

Cell["Feed in parameters for tables:", "ExampleText",
 CellID->6878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "-", "j"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "#1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "#2"}], "}"}]}], "]"}], "&"}], "@@", 
  RowBox[{"{", 
   RowBox[{"4", ",", "5"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11979],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "0", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{504, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1897]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "-", "j"}], ",", "##"}], "]"}], "&"}], "@@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "5"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7887],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "3"}], ",", 
     RowBox[{"-", "4"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "2"}], ",", 
     RowBox[{"-", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "0", ",", 
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{504, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6538]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14469],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 " to splice a complete iterator specification into ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->30783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"i", "[", "j", "]"}], ",", 
     RowBox[{"j", "+", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17540],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"i", "[", "1", "]"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"i", "[", "2", "]"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"i", "[", "3", "]"}], ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22795]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{"x", ",", "##"}], "]"}], "&"}], ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7266],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWEtPwzAMTtOxF2xtOXHcEe1P8DjAiR9RTZO2wwQa+/8lYQugT0GOmzm0
olKbOIntz3bqPF7qw2a9qw/bVb143tdvm+3qffH0ujdNeaaUvlVKFTfK1BtT
+3zdszSvUgP7zb/aSXoCdMGkUd6UKb8Ulk/po/yD+qT9dyksXzo+SOf2c/wy
va4NWUJZeaTbdrQK+atIfldeB1jrkxdrH86KVP6h4qTDozv4mausLn0qcfSF
cD/S47OiG3YaXSz6ILS9ifyk0+i6PS8jMgFyfdtoKg7H6Gw9qN+OxFWvDY4x
k0cKBxchFR8frq7EDdex/zx/6L9RM7mcdbircOUIxs8I/iqSH+UgP+L3yYux
b/7H/qHilTVtcq7bE/5mxRDG444f+dEKLj/KQX7ET51AuPbhCSe1f1KtrPNW
LZh50NoQPUUiPSGaqUxKzS4pv+Is7Hv8Upwcr5i0N9bB0mei0iltlD+981bM
c2WP4yKTbx+IeDwy+7l5CfVjPuHiC/MS17d3QON90z2zH+VT91eoH+/zuPjC
bj+b07NkUir7ABS8SXU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{552, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->707616511]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " can insert the specification for a single iterator:"
}], "ExampleText",
 CellID->13509],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"s", "=", 
     RowBox[{"{", 
      RowBox[{"i", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "^", "2"}], ",", "s"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->24557],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "9", ",", "16", ",", "25"}], "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->26134]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32053],

Cell[TextData[{
 "For some step sizes, output from ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " may not include the upper limit given:"
}], "ExampleText",
 CellID->959781159],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->251244227],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "3", ",", "6", ",", "9"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->297627270]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12258],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " requires iterator specifications to be given explicitly:"
}], "ExampleText",
 CellID->2593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", "=", 
     RowBox[{"{", 
      RowBox[{"x", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", "p"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17843],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "::", "\<\"itform\"\>"}], ":", 
  " ", "\<\"Argument \\!\\(p\\) at position \\!\\(2\\) does not have the \
correct form for an iterator. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/itform\\\", ButtonNote -> \
\\\"Table::itform\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->49835271],

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "::", "\<\"itform\"\>"}], ":", 
  " ", "\<\"Argument \\!\\(p\\) at position \\!\\(2\\) does not have the \
correct form for an iterator. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/itform\\\", ButtonNote -> \
\\\"Table::itform\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->246606661],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", "p"}], "]"}]], "Output",
 ImageSize->{84, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37169377]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", "=", 
     RowBox[{"{", 
      RowBox[{"x", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"Evaluate", "[", "p", "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18140],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "9", ",", "16", ",", "25"}], "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->582398595]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"p", "=", 
     RowBox[{"{", 
      RowBox[{"x", ",", "5"}], "}"}]}], "}"}], ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", "p"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12937],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "9", ",", "16", ",", "25"}], "}"}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->129626145]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2512],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " normally re-evaluates at each step:"
}], "ExampleText",
 CellID->6097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", "]"}], ",", 
   RowBox[{"{", "5", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9551],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.6432003266490787`", ",", "0.14989972440585064`", ",", 
   "0.042008231914755445`", ",", "0.6962446381483789`", ",", 
   "0.9045175519737887`"}], "}"}]], "Output",
 ImageSize->{322, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->453727676]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
   RowBox[{"{", "5", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21817],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.5029144646890689`", ",", "0.5029144646890689`", ",", 
   "0.5029144646890689`", ",", "0.5029144646890689`", ",", 
   "0.5029144646890689`"}], "}"}]], "Output",
 ImageSize->{343, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->59738100]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21292],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Evaluate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Evaluate"]], "InlineFormula"],
 " is needed to force evaluation of the table before it is fed to ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->20237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"BesselJ", "[", 
       RowBox[{"n", ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "5"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "15"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27530],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->276843348]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25296],

Cell[TextData[{
 "Values of ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " variables do not get substituted inside held expressions:"
}], "ExampleText",
 CellID->21710],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Hold", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32389],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Hold", "[", "i", "]"}], ",", 
   RowBox[{"Hold", "[", "i", "]"}], ",", 
   RowBox[{"Hold", "[", "i", "]"}], ",", 
   RowBox[{"Hold", "[", "i", "]"}], ",", 
   RowBox[{"Hold", "[", "i", "]"}]}], "}"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5628]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["With",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/With"]], "InlineFormula"],
 " to insert values:"
}], "ExampleText",
 CellID->5809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", "=", "i"}], "}"}], ",", 
     RowBox[{"Hold", "[", "i", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28786],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Hold", "[", "1", "]"}], ",", 
   RowBox[{"Hold", "[", "2", "]"}], ",", 
   RowBox[{"Hold", "[", "3", "]"}], ",", 
   RowBox[{"Hold", "[", "4", "]"}], ",", 
   RowBox[{"Hold", "[", "5", "]"}]}], "}"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31744]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18840],

Cell[TextData[{
 "Formatting wrappers such as ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " give expressions that are no longer lists:"
}], "ExampleText",
 CellID->8182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", " ", "j"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28569],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "2", "3", "4"},
    {"2", "4", "6", "8"},
    {"3", "6", "9", "12"},
    {"4", "8", "12", "16"}
   }],
  "Grid"]], "Output",
 ImageSize->{70, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6120]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "+", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27393],

Cell[BoxData[
 RowBox[{"x", "+", 
  TagBox[GridBox[{
     {"1", "2", "3", "4"},
     {"2", "4", "6", "8"},
     {"3", "6", "9", "12"},
     {"4", "8", "12", "16"}
    }],
   "Grid"]}]], "Output",
 ImageSize->{93, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6292]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14962],

Cell["\<\
x + Grid[{{1, 2, 3, 4}, {2, 4, 6, 8}, {3, 6, 9, 12}, {4, 8, 12, 16}}]\
\>", "Output",
 ImageSize->{483, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//InputForm=",
 CellID->14214]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8272],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Range",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Range"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiagonalMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiagonalMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IdentityMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IdentityMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Array",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Array"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Do",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Do"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Product",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Product"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FunctionInterpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FunctionInterpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NestList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NestWhileList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhileList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11434]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10943],

Cell[TextData[ButtonBox["Repetitive Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepetitiveOperations"]], "Tutorials",
 CellID->17877],

Cell[TextData[ButtonBox["Making Tables of Values",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MakingTablesOfValues"]], "Tutorials",
 CellID->3789],

Cell[TextData[ButtonBox["Evaluation in Iteration Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/EvaluationInIterationFunctions"]], "Tutorials",
 CellID->531660691],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "Tutorials",
 CellID->39801072],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Tensors"]], "Tutorials",
 CellID->493403696]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->507443541],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->29774558],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingMatrices"]], "MoreAbout",
 CellID->32104545],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->710397952],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->99154164],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->39635064],

Cell[TextData[ButtonBox["Operations on Vectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnVectors"]], "MoreAbout",
 CellID->134603858],

Cell[TextData[ButtonBox["Precollege Education",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecollegeEducation"]], "MoreAbout",
 CellID->128708736],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Tensors"]], "MoreAbout",
 CellID->75880587],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->379084853]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Table"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Table - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 59.3313474}", "context" -> "System`", 
    "keywords" -> {
     "arrays", "copying", "lists", "repeating expressions", 
      "replicating expressions", "tables", "tabulation of values"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Table[expr, {i_max}] generates a list of i_max copies of expr. \
Table[expr, {i, i_max}] generates a list of the values of expr when i runs \
from 1 to i_max. Table[expr, {i, i_min, i_max}] starts with i = i_min. \
Table[expr, {i, i_min, i_max, di}] uses steps di. Table[expr, {i, {i_1, i_2, \
...}}] uses the successive values i_1, i_2, .... Table[expr, {i, i_min, \
i_max}, {j, j_min, j_max}, ...] gives a nested list. The list associated with \
i is outermost. >", "synonyms" -> {}, "title" -> "Table", "type" -> "Symbol", 
    "uri" -> "ref/Table"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[17587, 506, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->855837811]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 131094, 3859}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4594, 94, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5217, 121, 4189, 83, 70, "ObjectNameGrid"],
Cell[9409, 206, 5226, 176, 70, "Usage",
 CellID->23775]
}, Open  ]],
Cell[CellGroupData[{
Cell[14672, 387, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[15150, 404, 236, 8, 70, "Notes",
 CellID->13000],
Cell[15389, 414, 260, 10, 70, "Notes",
 CellID->12212],
Cell[15652, 426, 216, 7, 70, "Notes",
 CellID->21100],
Cell[15871, 435, 514, 18, 70, "Notes",
 CellID->7551],
Cell[16388, 455, 330, 12, 70, "Notes",
 CellID->25476],
Cell[16721, 469, 829, 32, 70, "Notes",
 CellID->6379]
}, Closed]],
Cell[CellGroupData[{
Cell[17587, 506, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->855837811],
Cell[CellGroupData[{
Cell[17972, 520, 146, 5, 70, "ExampleSection",
 CellID->8183115],
Cell[18121, 527, 72, 1, 70, "ExampleText",
 CellID->14504],
Cell[CellGroupData[{
Cell[18218, 532, 194, 7, 28, "Input",
 CellID->12946],
Cell[18415, 541, 295, 9, 36, "Output",
 CellID->23888]
}, Open  ]],
Cell[18725, 553, 121, 3, 70, "ExampleDelimiter",
 CellID->20308],
Cell[18849, 558, 146, 5, 70, "ExampleText",
 CellID->12157],
Cell[CellGroupData[{
Cell[19020, 567, 218, 7, 70, "Input",
 CellID->1430],
Cell[19241, 576, 614, 18, 36, "Output",
 CellID->5123]
}, Open  ]],
Cell[19870, 597, 120, 3, 70, "ExampleDelimiter",
 CellID->6464],
Cell[19993, 602, 130, 5, 70, "ExampleText",
 CellID->4074],
Cell[CellGroupData[{
Cell[20148, 611, 144, 5, 70, "Input",
 CellID->4346],
Cell[20295, 618, 287, 9, 36, "Output",
 CellID->13837]
}, Open  ]],
Cell[20597, 630, 120, 3, 70, "ExampleDelimiter",
 CellID->1981],
Cell[20720, 635, 105, 2, 70, "ExampleText",
 CellID->25318],
Cell[CellGroupData[{
Cell[20850, 641, 273, 10, 70, "Input",
 CellID->26611],
Cell[21126, 653, 468, 15, 36, "Output",
 CellID->16292]
}, Open  ]],
Cell[CellGroupData[{
Cell[21631, 673, 102, 3, 70, "Input",
 CellID->17591],
Cell[21736, 678, 655, 20, 92, "Output",
 CellID->3832]
}, Open  ]],
Cell[22406, 701, 121, 3, 70, "ExampleDelimiter",
 CellID->27123],
Cell[22530, 706, 51, 1, 70, "ExampleText",
 CellID->6461],
Cell[CellGroupData[{
Cell[22606, 711, 242, 8, 70, "Input",
 CellID->16991],
Cell[22851, 721, 1177, 26, 117, "Output",
 CellID->333607183]
}, Open  ]],
Cell[24043, 750, 121, 3, 70, "ExampleDelimiter",
 CellID->27330],
Cell[24167, 755, 67, 1, 70, "ExampleText",
 CellID->28498],
Cell[CellGroupData[{
Cell[24259, 760, 239, 8, 70, "Input",
 CellID->17369],
Cell[24501, 770, 293, 14, 94, "Output",
 CellID->332795252]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24843, 790, 216, 7, 70, "ExampleSection",
 CellID->14179],
Cell[25062, 799, 80, 1, 70, "ExampleText",
 CellID->24117],
Cell[CellGroupData[{
Cell[25167, 804, 260, 9, 70, "Input",
 CellID->2317],
Cell[25430, 815, 533, 17, 36, "Output",
 CellID->19914]
}, Open  ]],
Cell[25978, 835, 120, 3, 70, "ExampleDelimiter",
 CellID->1595],
Cell[26101, 840, 62, 1, 70, "ExampleText",
 CellID->1441],
Cell[CellGroupData[{
Cell[26188, 845, 272, 10, 70, "Input",
 CellID->5936],
Cell[26463, 857, 528, 17, 36, "Output",
 CellID->21867]
}, Open  ]],
Cell[CellGroupData[{
Cell[27028, 879, 100, 3, 70, "Input",
 CellID->7028],
Cell[27131, 884, 795, 20, 108, "Output",
 CellID->31453]
}, Open  ]],
Cell[27941, 907, 121, 3, 70, "ExampleDelimiter",
 CellID->27909],
Cell[28065, 912, 69, 1, 70, "ExampleText",
 CellID->13973],
Cell[CellGroupData[{
Cell[28159, 917, 364, 13, 70, "Input",
 CellID->17981],
Cell[28526, 932, 854, 28, 71, "Output",
 CellID->11503]
}, Open  ]],
Cell[29395, 963, 124, 3, 70, "ExampleDelimiter",
 CellID->66821681],
Cell[29522, 968, 72, 1, 70, "ExampleText",
 CellID->38249001],
Cell[CellGroupData[{
Cell[29619, 973, 293, 10, 70, "Input",
 CellID->1028220083],
Cell[29915, 985, 223, 7, 36, "Output",
 CellID->180430132]
}, Open  ]],
Cell[30153, 995, 124, 3, 70, "ExampleDelimiter",
 CellID->74435587],
Cell[30280, 1000, 77, 1, 70, "ExampleText",
 CellID->154543735],
Cell[CellGroupData[{
Cell[30382, 1005, 453, 15, 70, "Input",
 CellID->126626299],
Cell[30838, 1022, 420, 15, 43, "Output",
 CellID->73787570]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31307, 1043, 239, 7, 70, "ExampleSection",
 CellID->26569],
Cell[31549, 1052, 79, 1, 70, "ExampleText",
 CellID->6816],
Cell[CellGroupData[{
Cell[31653, 1057, 285, 10, 70, "Input",
 CellID->1883],
Cell[31941, 1069, 932, 32, 39, "Output",
 CellID->515284247]
}, Open  ]],
Cell[32888, 1104, 120, 3, 70, "ExampleDelimiter",
 CellID->5385],
Cell[33011, 1109, 78, 1, 70, "ExampleText",
 CellID->28402],
Cell[CellGroupData[{
Cell[33114, 1114, 248, 9, 70, "Input",
 CellID->5230],
Cell[33365, 1125, 251, 8, 36, "Output",
 CellID->95613470]
}, Open  ]],
Cell[CellGroupData[{
Cell[33653, 1138, 426, 15, 70, "Input",
 CellID->28681],
Cell[34082, 1155, 396, 13, 36, "Output",
 CellID->321454160]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34527, 1174, 222, 7, 70, "ExampleSection",
 CellID->1866],
Cell[34752, 1183, 63, 1, 70, "ExampleText",
 CellID->3687],
Cell[CellGroupData[{
Cell[34840, 1188, 354, 12, 70, "Input",
 CellID->13171],
Cell[35197, 1202, 8212, 139, 70, "Output",
 Evaluatable->False,
 CellID->289027418]
}, Open  ]],
Cell[43424, 1344, 121, 3, 70, "ExampleDelimiter",
 CellID->31245],
Cell[43548, 1349, 73, 1, 70, "ExampleText",
 CellID->32764],
Cell[CellGroupData[{
Cell[43646, 1354, 520, 17, 70, "Input",
 CellID->6238],
Cell[44169, 1373, 1002, 22, 164, "Output",
 CellID->86177339]
}, Open  ]],
Cell[45186, 1398, 120, 3, 70, "ExampleDelimiter",
 CellID->2047],
Cell[CellGroupData[{
Cell[45331, 1405, 498, 16, 70, "Input",
 CellID->26115],
Cell[45832, 1423, 29970, 496, 257, 1131, 19, "CachedBoxData", "BoxData", \
"Output",
 CellID->166890578]
}, Open  ]],
Cell[75817, 1922, 121, 3, 70, "ExampleDelimiter",
 CellID->27311],
Cell[75941, 1927, 79, 1, 70, "ExampleText",
 CellID->32657],
Cell[CellGroupData[{
Cell[76045, 1932, 387, 13, 70, "Input",
 CellID->1405],
Cell[76435, 1947, 1135, 42, 154, "Output",
 CellID->552106926]
}, Open  ]],
Cell[77585, 1992, 120, 3, 70, "ExampleDelimiter",
 CellID->7171],
Cell[CellGroupData[{
Cell[77730, 1999, 270, 8, 70, "Input",
 CellID->20580],
Cell[78003, 2009, 1042, 40, 39, "Output",
 CellID->490478798]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[79094, 2055, 234, 7, 70, "ExampleSection",
 CellID->22530],
Cell[CellGroupData[{
Cell[79353, 2066, 234, 7, 70, "ExampleSubsection",
 CellID->13675],
Cell[CellGroupData[{
Cell[79612, 2077, 288, 9, 70, "Input",
 CellID->24320],
Cell[79903, 2088, 982, 25, 146, "Output",
 CellID->14840166]
}, Open  ]],
Cell[80900, 2116, 121, 3, 70, "ExampleDelimiter",
 CellID->13377],
Cell[CellGroupData[{
Cell[81046, 2123, 291, 10, 70, "Input",
 CellID->10998],
Cell[81340, 2135, 357, 18, 168, "Output",
 CellID->512146452]
}, Open  ]],
Cell[81712, 2156, 121, 3, 70, "ExampleDelimiter",
 CellID->21604],
Cell[CellGroupData[{
Cell[81858, 2163, 328, 11, 70, "Input",
 CellID->4489],
Cell[82189, 2176, 622, 14, 70, "Output",
 Evaluatable->False,
 CellID->125166789]
}, Open  ]],
Cell[82826, 2193, 121, 3, 70, "ExampleDelimiter",
 CellID->29744],
Cell[82950, 2198, 117, 3, 70, "ExampleText",
 CellID->8388],
Cell[CellGroupData[{
Cell[83092, 2205, 278, 10, 70, "Input",
 CellID->26610],
Cell[CellGroupData[{
Cell[83395, 2219, 91, 2, 70, "Print",
 CellID->418866746],
Cell[83489, 2223, 90, 2, 70, "Print",
 CellID->91382881],
Cell[83582, 2227, 91, 2, 70, "Print",
 CellID->763995336]
}, Open  ]],
Cell[83688, 2232, 227, 7, 36, "Output",
 CellID->228243353]
}, Open  ]],
Cell[83930, 2242, 124, 3, 70, "ExampleDelimiter",
 CellID->47400043],
Cell[84057, 2247, 98, 1, 70, "ExampleText",
 CellID->622989007],
Cell[CellGroupData[{
Cell[84180, 2252, 379, 13, 70, "Input",
 CellID->198921070],
Cell[84562, 2267, 227, 7, 36, "Output",
 CellID->355551270]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[84838, 2280, 245, 7, 70, "ExampleSubsection",
 CellID->21479],
Cell[85086, 2289, 217, 7, 70, "ExampleText",
 CellID->22716],
Cell[CellGroupData[{
Cell[85328, 2300, 130, 4, 70, "Input",
 CellID->6300],
Cell[85461, 2306, 229, 7, 36, "Output",
 CellID->21396]
}, Open  ]],
Cell[CellGroupData[{
Cell[85727, 2318, 190, 6, 70, "Input",
 CellID->16853],
Cell[85920, 2326, 229, 7, 36, "Output",
 CellID->11458]
}, Open  ]],
Cell[86164, 2336, 121, 3, 70, "ExampleDelimiter",
 CellID->20830],
Cell[86288, 2341, 353, 12, 70, "ExampleText",
 CellID->24593],
Cell[CellGroupData[{
Cell[86666, 2357, 224, 8, 70, "Input",
 CellID->30806],
Cell[CellGroupData[{
Cell[86915, 2369, 88, 2, 70, "Print",
 CellID->29849],
Cell[87006, 2373, 88, 2, 70, "Print",
 CellID->14854],
Cell[87097, 2377, 89, 2, 70, "Print",
 CellID->24272]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[87235, 2385, 193, 7, 70, "Input",
 CellID->26160],
Cell[87431, 2394, 210, 7, 36, "Output",
 CellID->12294]
}, Open  ]],
Cell[87656, 2404, 121, 3, 70, "ExampleDelimiter",
 CellID->12054],
Cell[87780, 2409, 436, 17, 70, "ExampleText",
 CellID->26333],
Cell[CellGroupData[{
Cell[88241, 2430, 189, 7, 70, "Input",
 CellID->146],
Cell[88433, 2439, 233, 8, 36, "Output",
 CellID->4229]
}, Open  ]],
Cell[CellGroupData[{
Cell[88703, 2452, 193, 7, 70, "Input",
 CellID->10471],
Cell[88899, 2461, 259, 9, 39, "Output",
 CellID->10428]
}, Open  ]],
Cell[89173, 2473, 121, 3, 70, "ExampleDelimiter",
 CellID->10559],
Cell[89297, 2478, 202, 7, 70, "ExampleText",
 CellID->22241],
Cell[CellGroupData[{
Cell[89524, 2489, 215, 8, 70, "Input",
 CellID->29421],
Cell[89742, 2499, 420, 13, 36, "Output",
 CellID->22688]
}, Open  ]],
Cell[CellGroupData[{
Cell[90199, 2517, 309, 11, 70, "Input",
 CellID->16366],
Cell[90511, 2530, 420, 13, 36, "Output",
 CellID->12033]
}, Open  ]],
Cell[CellGroupData[{
Cell[90968, 2548, 252, 9, 70, "Input",
 CellID->26685],
Cell[91223, 2559, 419, 13, 36, "Output",
 CellID->2270]
}, Open  ]],
Cell[91657, 2575, 125, 3, 70, "ExampleDelimiter",
 CellID->128619277],
Cell[91785, 2580, 219, 7, 70, "ExampleText",
 CellID->84895798],
Cell[CellGroupData[{
Cell[92029, 2591, 170, 5, 70, "Input",
 CellID->665105309],
Cell[92202, 2598, 290, 9, 36, "Output",
 CellID->56451580]
}, Open  ]],
Cell[CellGroupData[{
Cell[92529, 2612, 255, 9, 70, "Input",
 CellID->129933737],
Cell[92787, 2623, 291, 9, 36, "Output",
 CellID->110624928]
}, Open  ]],
Cell[93093, 2635, 235, 7, 70, "ExampleText",
 CellID->68446400],
Cell[CellGroupData[{
Cell[93353, 2646, 286, 9, 70, "Input",
 CellID->268498511],
Cell[93642, 2657, 291, 9, 36, "Output",
 CellID->307782157]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[93982, 2672, 230, 7, 70, "ExampleSubsection",
 CellID->25329],
Cell[94215, 2681, 249, 8, 70, "ExampleText",
 CellID->32261],
Cell[CellGroupData[{
Cell[94489, 2693, 252, 9, 70, "Input",
 CellID->22860],
Cell[94744, 2704, 341, 12, 36, "Output",
 CellID->2208]
}, Open  ]],
Cell[CellGroupData[{
Cell[95122, 2721, 305, 11, 70, "Input",
 CellID->8982],
Cell[95430, 2734, 342, 12, 36, "Output",
 CellID->22162]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[95821, 2752, 248, 7, 70, "ExampleSubsection",
 CellID->32506],
Cell[96072, 2761, 68, 1, 70, "ExampleText",
 CellID->6878],
Cell[CellGroupData[{
Cell[96165, 2766, 356, 13, 70, "Input",
 CellID->11979],
Cell[96524, 2781, 745, 25, 36, "Output",
 CellID->1897]
}, Open  ]],
Cell[CellGroupData[{
Cell[97306, 2811, 340, 13, 70, "Input",
 CellID->7887],
Cell[97649, 2826, 745, 25, 36, "Output",
 CellID->6538]
}, Open  ]],
Cell[98409, 2854, 121, 3, 70, "ExampleDelimiter",
 CellID->14469],
Cell[98533, 2859, 345, 13, 70, "ExampleText",
 CellID->30783],
Cell[CellGroupData[{
Cell[98903, 2876, 275, 10, 70, "Input",
 CellID->17540],
Cell[99181, 2888, 450, 16, 36, "Output",
 CellID->22795]
}, Open  ]],
Cell[CellGroupData[{
Cell[99668, 2909, 199, 7, 70, "Input",
 CellID->7266],
Cell[99870, 2918, 781, 17, 70, "Output",
 Evaluatable->False,
 CellID->707616511]
}, Open  ]],
Cell[100666, 2938, 217, 7, 70, "ExampleText",
 CellID->13509],
Cell[CellGroupData[{
Cell[100908, 2949, 305, 11, 70, "Input",
 CellID->24557],
Cell[101216, 2962, 232, 7, 36, "Output",
 CellID->26134]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[101509, 2976, 226, 7, 70, "ExampleSection",
 CellID->32053],
Cell[101738, 2985, 248, 8, 70, "ExampleText",
 CellID->959781159],
Cell[CellGroupData[{
Cell[102011, 2997, 194, 6, 70, "Input",
 CellID->251244227],
Cell[102208, 3005, 223, 7, 36, "Output",
 CellID->297627270]
}, Open  ]],
Cell[102446, 3015, 121, 3, 70, "ExampleDelimiter",
 CellID->12258],
Cell[102570, 3020, 223, 7, 70, "ExampleText",
 CellID->2593],
Cell[CellGroupData[{
Cell[102818, 3031, 306, 11, 70, "Input",
 CellID->17843],
Cell[103127, 3044, 417, 8, 70, "Message",
 CellID->49835271],
Cell[103547, 3054, 418, 8, 70, "Message",
 CellID->246606661],
Cell[103968, 3064, 236, 8, 39, "Output",
 CellID->37169377]
}, Open  ]],
Cell[CellGroupData[{
Cell[104241, 3077, 344, 12, 70, "Input",
 CellID->18140],
Cell[104588, 3091, 236, 7, 36, "Output",
 CellID->582398595]
}, Open  ]],
Cell[CellGroupData[{
Cell[104861, 3103, 305, 11, 70, "Input",
 CellID->12937],
Cell[105169, 3116, 236, 7, 36, "Output",
 CellID->129626145]
}, Open  ]],
Cell[105420, 3126, 120, 3, 70, "ExampleDelimiter",
 CellID->2512],
Cell[105543, 3131, 202, 7, 70, "ExampleText",
 CellID->6097],
Cell[CellGroupData[{
Cell[105770, 3142, 176, 6, 70, "Input",
 CellID->9551],
Cell[105949, 3150, 338, 10, 36, "Output",
 CellID->453727676]
}, Open  ]],
Cell[CellGroupData[{
Cell[106324, 3165, 214, 7, 70, "Input",
 CellID->21817],
Cell[106541, 3174, 334, 10, 36, "Output",
 CellID->59738100]
}, Open  ]],
Cell[106890, 3187, 121, 3, 70, "ExampleDelimiter",
 CellID->21292],
Cell[107014, 3192, 363, 13, 70, "ExampleText",
 CellID->20237],
Cell[CellGroupData[{
Cell[107402, 3209, 396, 13, 70, "Input",
 CellID->27530],
Cell[107801, 3224, 11351, 190, 70, "Output",
 Evaluatable->False,
 CellID->276843348]
}, Open  ]],
Cell[119167, 3417, 121, 3, 70, "ExampleDelimiter",
 CellID->25296],
Cell[119291, 3422, 240, 8, 70, "ExampleText",
 CellID->21710],
Cell[CellGroupData[{
Cell[119556, 3434, 201, 7, 70, "Input",
 CellID->32389],
Cell[119760, 3443, 389, 12, 36, "Output",
 CellID->5628]
}, Open  ]],
Cell[120164, 3458, 191, 8, 70, "ExampleText",
 CellID->5809],
Cell[CellGroupData[{
Cell[120380, 3470, 313, 11, 70, "Input",
 CellID->28786],
Cell[120696, 3483, 390, 12, 36, "Output",
 CellID->31744]
}, Open  ]],
Cell[121101, 3498, 121, 3, 70, "ExampleDelimiter",
 CellID->18840],
Cell[121225, 3503, 240, 8, 70, "ExampleText",
 CellID->8182],
Cell[CellGroupData[{
Cell[121490, 3515, 289, 10, 70, "Input",
 CellID->28569],
Cell[121782, 3527, 291, 12, 78, "Output",
 CellID->6120]
}, Open  ]],
Cell[CellGroupData[{
Cell[122110, 3544, 88, 3, 70, "Input",
 CellID->27393],
Cell[122201, 3549, 320, 13, 78, "Output",
 CellID->6292]
}, Open  ]],
Cell[CellGroupData[{
Cell[122558, 3567, 101, 3, 70, "Input",
 CellID->14962],
Cell[122662, 3572, 233, 7, 50, "Output",
 CellID->14214]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[122956, 3586, 310, 9, 70, "SeeAlsoSection",
 CellID->8272],
Cell[123269, 3597, 2686, 98, 70, "SeeAlso",
 CellID->11434]
}, Open  ]],
Cell[CellGroupData[{
Cell[125992, 3700, 314, 9, 70, "TutorialsSection",
 CellID->10943],
Cell[126309, 3711, 152, 3, 70, "Tutorials",
 CellID->17877],
Cell[126464, 3716, 153, 3, 70, "Tutorials",
 CellID->3789],
Cell[126620, 3721, 178, 3, 70, "Tutorials",
 CellID->531660691],
Cell[126801, 3726, 152, 3, 70, "Tutorials",
 CellID->39801072],
Cell[126956, 3731, 129, 3, 70, "Tutorials",
 CellID->493403696]
}, Open  ]],
Cell[CellGroupData[{
Cell[127122, 3739, 319, 9, 70, "MoreAboutSection",
 CellID->507443541],
Cell[127444, 3750, 146, 3, 70, "MoreAbout",
 CellID->29774558],
Cell[127593, 3755, 152, 3, 70, "MoreAbout",
 CellID->32104545],
Cell[127748, 3760, 155, 3, 70, "MoreAbout",
 CellID->710397952],
Cell[127906, 3765, 144, 3, 70, "MoreAbout",
 CellID->99154164],
Cell[128053, 3770, 144, 3, 70, "MoreAbout",
 CellID->39635064],
Cell[128200, 3775, 152, 3, 70, "MoreAbout",
 CellID->134603858],
Cell[128355, 3780, 151, 3, 70, "MoreAbout",
 CellID->128708736],
Cell[128509, 3785, 125, 3, 70, "MoreAbout",
 CellID->75880587],
Cell[128637, 3790, 156, 3, 70, "MoreAbout",
 CellID->379084853]
}, Open  ]],
Cell[CellGroupData[{
Cell[128830, 3798, 305, 8, 70, "RelatedLinksSection"],
Cell[129138, 3808, 383, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[129536, 3824, 50, 0, 70, "History"],
Cell[129589, 3826, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

