(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24213,        799]
NotebookOptionsPosition[     19550,        640]
NotebookOutlinePosition[     20991,        679]
CellTagsIndexPosition[     20906,        674]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Tables and Matrices\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TableSpacing" :> 
          Documentation`HelpLookup["paclet:ref/TableSpacing"], 
          "TableAlignments" :> 
          Documentation`HelpLookup["paclet:ref/TableAlignments"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TableSpacing\"\>", 
       2->"\<\"TableAlignments\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TableDirections", "ObjectName",
 CellID->14984],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["TableDirections",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TableDirections"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["TableForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["MatrixForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
     " which specifies whether successive dimensions should be arranged as \
rows or columns. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16339]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TableDirections", "->", 
   ButtonBox["Column",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Column"]}]], "InlineFormula"],
 " specifies that successive dimensions should be arranged alternately as \
columns and rows, with the first dimension arranged as columns. "
}], "Notes",
 CellID->2556],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TableDirections", "->", 
   ButtonBox["Row",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Row"]}]], "InlineFormula"],
 " takes the first dimension to be arranged as rows. "
}], "Notes",
 CellID->25808],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TableDirections", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["dir", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["dir", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies explicitly whether each dimension should be arranged with ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4632]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->785078658],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->113397074],

Cell["By default the outermost dimension is a column:", "ExampleText",
 CellID->194365554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"e", ",", "f"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234241432],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytUskOgjAQ7UIT3NcQj9z9Dz35EQ0xgYPRIP+PM3SoBSqIsUln65vpzGsv
ukivN11kiY7PuX6kWfKMT/ccQpIzxiLYxwMDuwSr2lFZgu5KATIAwBS0As2r
KJNGoVyikMZBU4xE4MLD2WAd0UJMvBko63rvjjde7Jaw/MP0faxg3pzu6O8z
RKGsT2N3mVz8Geftw+XAZtWvjJzVUW5P9w1v52DGcoZNh6SH3/db3sbkuf/5
19qCuueNqvYPB5RaLTPlulXFXLCiWsphifEXLIjIoA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{22, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->637504987]
}, Open  ]],

Cell["Format the first dimension as a row instead:", "ExampleText",
 CellID->285974128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableDirections", "\[Rule]", "Row"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32962944],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwqAKxtAQDkP0fyAJj
1f//gTQyyQoU5gGyQDQnlGYEyzAwQygQyQQimCEcEJMDRLDC+RCFDNxoqpgG
tTkggNUcZB3EuQYahiAaWRx3eAqimcmJ1Q6QeYJQc0HmM8PNwoxHXCQT1A1c
UP0gc1goiGMuNFXMxJmDxOfBagIT1F3o5sPSJkXuxRBlhNuJHCbcUD4TjrBk
YAQACFit7w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{37, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->436620599]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16798],

Cell[TextData[{
 "Use with ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->289012416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"e", ",", "f"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->197715426],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a", "b"},
     {"c", "d"},
     {"e", "f"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{46, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->777081076]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableDirections", "\[Rule]", "Row"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->143149236],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV9sOgjAMrWzzEu9vvpjwNfrkRxBjAg9G4+X7cRuLIbWmIwwkBhImx3bt
ORus2yF5pKdz8siOSby/Jdc0O97j3eWm/xIDAHjqe7sB/ZzrJ3s/81z/lltl
WmFs9oIhwnOEVzXtI4SlZSEZFkI3SkPce4Gwcn5YFfaTzg/nwfGFFztrV29s
+3zGpjhU74WVYcb/qkAwChTJBceaBemFc48ZBZG3gkjDiBkvUkM5208VgCww
2AvHpXgYvm6SgYpK6aXWghqcS3jCZMd2bnaaGWnpxm3KZB87P+59MHYRbEzX
TLaq9p5Fz6Jn0QQLg6l9ELWKCc/1XIZdm1uq6VwdaF1BhZrUDPdvcxmCbeD6
3eY7wvaidXA7cBObqsDU7lkSXyzl51PR/c4HSyZbVXuXWXTjRFyczmHwAmqR
tf8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{117, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->389543912]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->351969742],

Cell["Format only as rows:", "ExampleText",
 CellID->337560346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableDirections", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Row", ",", "Row"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->193913254],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVUsOgjAQLVD84i9idGEMp9GVhyDEBBZGg5yIi2JbqmmeJW1EIk1K+6bT
6ZtpmTnHRXq5xkWWxNEpj+9pljyi4y1nIs8hhJSsL3aEzSs2E72sKjb6/Otx
LBoZAN4DXrZcHwKmggU1sDgAnrdcRxaeYOEZWHDsMzhSRnU90OhzGEh9tKfT
pwxOpD6yROxasRY37L+x2FOf8SnFE5Dhz20peAYYo9sT73G9p36rb+mfnvJN
0048bL5Zl42ujUd270Rl9vU/0k0MXhlGWKe1nIhmk5uo3Mm9kimQ6E5pymt8
r32eMuX4tSFCmNO3gNE+6ocGlvqaYKqPKxm/McixDm6kHtpDvVDGFvX0dbNs
+BLnCb+EVIE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{162, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->25679448]
}, Open  ]],

Cell["Only as columns:", "ExampleText",
 CellID->396236230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableDirections", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Column", ",", "Column"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->556580989],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmb1uwjAQgE1+SmjVVt06snTmLdqpT9ApQpVgqFpRBjZGRsaMPAJjRkZG
RkZGRkbG1GcbnB6HcIIRaUmkBF9y+XL+ufPpeA27rfePsNtuhvWXTvjVaje/
68+fHX7LrTDGGvx8e2S8nfCWOBtJwn/TVx+u7mg0SsTBroQMulK+RXIg5H6/
r2RXUDzRnM/ncRxTFHjucxHfr26+PpvNMC2Koj02+SQFy+v1utfraaq7uSvB
O28dosqeDwYDjoCms6U60+kUa2ObA5LOh4sP2m+a6PlyuaQoZlQ9D2mqnjNq
PGF29o6jXB6GtEM2Bmh2K0ZUsMUlbMTr0Yz2UFIuhAKyZ23d4BhRKziV8uoj
bPS3sngnL5uKvJRv13LR7s9IwbEO757XRpSnC9CyM1LUSoJFSntUVprIQ3bW
PPaM87NP6auHYpVjjQwy0FS6xiidfGQcT3Ef8lEDZW+ZkZSULBSQQaTz4iL7
etGznVPmJ561yF/mJ39B6zT5CTyncvLz5xD/KT+BXdmhvmknyngqORGHxShu
PSZ6aixurNCKtIeWlCyU4XCYiQIyVa2VNF0rTtOiKFqtVhTNzNulvFgsxuMx
NNO1xjiOVX34GPZkMiFqrdxo9UXTylF1M6a/6sC4Zo09OoulemY02+EjYFo3
AdnhvRI2KUv2W4YziSrSd1MUWZY2p2h9SblDWnhXFc/VPxOs8gNzeq+6\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{47, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->52128733]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->110566279],

Cell["A default higher-dimensional tensor:", "ExampleText",
 CellID->88677037],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Array", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["a", "##"], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->450151608],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnDtP3EAQx43NcUBCFOUhIpGCREqiKE0+RVLlQ5xQJCiiRISCJqKkpLyS
j0B5SkVBQUlJSUlJSensev26udmnd897YZAgN7b3P7Oz3vXOLyd/Gx3sfv8x
OtjbGW1/3R/92t3b+b395ec+O5QtJUlywX7/vErY55x9Kn4v8pz9+4b/zbhd
/CRDYH/ueH6r8PKa/eUHU3B2UB1bro+VV35ot5g5m1m2SZmxjLbZLOIbFHGd
np6Wca2AOB8DO62Cr7XYZ6HSeGAfVkG7pya6UworfjR1ttKDsI+Ojkq7yL7I
Z3Z9fT2ZTLCc8WzwFJWXFz98HOAdAm2o82TBdMV5di9dXV3BbI3HY0mr4vzM
HdUeqwQZGds+xuRlTaOK5/X+/v7w8LDJa1YdFamdiRWPhbdKkZ62fSbI2Jv1
tFIfKtTmry76enx8zJKVV/NeqF1eXmJjvFytmmCWpMjowfZwFZLp4aM8f11h
s6WMLWjT2Slm7e3tLaY6QEcIPlNhzCFbiX40q3K7H80Kjs01br41yHaX6+o5
LB61htF90nizPS9mQrMWL/UYReOPoqAoFj2KZ8DWrd7Qnnd7t15u5JpqBhzT
RTGlh9c63hTrSkij6JYZuINR1EkzR+GOAvYJ1Z6tlfzo6mytF7f8cdulBjHZ
JcWs65Yt/D6yrWZ0fYzJi65mCplXWc3kp6eyqkbnLay6+yxW1U6rOV5DudY2
K3PSM8uGWQW+Da4yq339tFpz6gcfPW7CigvjSF2uc4vuo8ab7XmzKOD8+QBs
yCZtz68bRfF3oa/aAn32TeA3jaJ4mcv3hvi+9H2u4uo4oZe3kSs9N4of3okP
m9ibzRtshcNqGF9kPVZdtxUXf9bYckg3lt6PF51qyLzq9tt+yD30Eobgd/Vi
llfZrhTyBNluz5S8Qz0fNaUPXZ+1T59E370G4WZoor/ItJKioCgoCnUUD4Po
cxVl9QOOmfRCUxt5UySivwhE37ZGMSXvser63H35/s5ITF7Mvk0WJq/9/B9G
GMLf1Us30i+rqWxJv67msSX9rnpE+rlJpJ9I//9J+mW7UDnpr1tYkH78rG/S
vw5sfGWwJ/2obkfSj2rqdqZE+qMk/bZ80o3B9+NFRddD55VIv21eifS7ZIlI
v911i0wxKQqKgqJQR/FwSH+GPHO6kP5azxvpxxXDkn4Yh6KOsibyqLYH0o/q
tmwi/eF1fX/H3GcfY/Kiq6mI9BPpn9Ul0k+kX+aNSH+sV8VB+l/k+BNeTvrf
tVsYkn55G9+k/xGws6oztTZfGexJP6rbkfSjmrqdKZF+Iv1z9tIn6TfZs8h2
eu49Vqn256Ub6eezRbULNSXxqWH70HpE9LlJRJ+ioCgoCiL6ql7ynbayygHH
dFFM6Xkh+nJFO6J/cnJilZkNYCvqJWvyjmp7IPqobsvuQvSb97u28zcej+/u
7rD8xU7eQ+kK++bm5uzsrM5xma3JZFK+15SIvi3RF/b5+Tnyjkl2C5bZjjmv
sKrx93aeLl6EzVbHqTebwjfuDhAvWO1kS/JlNY4twbfVEb1uVv+m1ymbofET
ex5hyu754upydOSjNS9SPwRxZK3oxEtgseh8k/oh8CeigK18k/lCP7kQ47X0
DxLqixY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{195, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->65971308]
}, Open  ]],

Cell["\<\
Format the first two dimensions as columns and the third as rows:\
\>", "ExampleText",
 CellID->53529365],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "##"], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableDirections", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Column", ",", "Column", ",", "Row"}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->193562464],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnDtPHDEQx5dbjjteEq+ISElxiaJ8lKSKUuQTnFAkKKJEFwo6SkpKSkpK
SqqIkpKSkpKSknIZr+2zd3a8tvdN8Encrb2e8fix/t/8kO7b9HD/56/p4cHe
dPJ1Nv2zf7D3d/Ll9wyq4oUoimbw9+9tBNcJXKV/sySBzw/sPWbl9BWNUPm9
5f671AtrxSoHrLQ4vwuvARQWkc0QLrfsFpla1nY37WuYejs/P89EdHZ2Jsqr
qLeBS3mo9wXX0ZsyXlTEcDFOWzw9PfFQRfn4+Fi0iNNmfG7u7u6urq7UaKDw
8PCQuoQ3Fpxonr7YDOF1wOXVknZLMkrR/0jO9u3tLY5azTlvdXp6qo8tN6f6
nLHyMtm3Kq/U4oWX7+/vebgiVliXo6MjNaJY1mZawaCvr6/lOuRjYVZ4VqP5
2ttGYrKmvanZ5fdPTk4g3ETuPe7t5uZm3lrcZc/LIvEUUvPEoll3bE/vJBwl
7GTY3Nko052T2V8wFmFFz/MnspafXRcXFxlf6lnSe1TPHe6RzQ8bxmfx+TG9
D8sOc5nZL+I5LvKqyj/YbIKTZTleUb9QwlrVB+vmrDeT4v1tU8K1Sr0za1oP
Y3mIOyvo3CJXO64U4zqKIq95SzK4ea9GLc3bZWpWKkXKnuk2VXNUKVr6zMM6
hzUFx+CmljYvTYykPZWstmPaUsm659esjtXmA6viyzzXg3UZ6x6pIdI9qm7L
1r4NJcw9gUOyllRD2rayIma/5batiFF8eXkJiRe7xNlvUdQqh+ibMurf5N1H
xLIyei9IbSs3ApO1rkFqZL6R81aKs7C1oBRvqEVRpIyyHZ2vQwrHlz1y29/z
6ESWSxMHWhknidhlIm/06RG6g4RTzoeukBN5nz90fM2sXpfl6EX5u/Ty+Pjo
7mX/FbRKSWMFRdp16oWdzjSBNJHMTbtFTn22nWLB7KCvZNNtj3KrPNnE/bkq
kq8dJps+T72NbOJ9QfdtO899vWCy6fPNwEY2sTqWy91sXmyk0/NbAyKemJpQ
86krlq29jXj6RFsP8SzXo414+njtR7YSrMtYd5vjsXPcrJAU8TQrbSCeMr9r
S02b4Fi+LM1NRbsgct2pZ3UC2oZqBgIarPtu3SN1dCCgm7b2gYAm7StkUwS0
O6Wsm4C2w3KbJaJYAaVCYiJqaheIqF4biGj/iCidXxURUYtFTUQUPzk4Gjci
ul3GSyCiokyfM/isKzqR5zNW2UsgovqIAhENRDRY+1h3n/OZSaaJiFosas77
8P8gkZpHJiJKamwgohau5Xv+uqloFyMJRLTd+Q5ENFj/x+roSEQL27ehjI5E
lFTHQEQ1KxsR7U4pAxENRDTbYyCiXbVqh4juJNr550REN+wWNRHRFdQ7fsLc
iOhOGS+BiOqz9QqIKHV6++d0Ni/NElG2Q0yKoyuVqV0goH3NVoJ1Getuczx2
QpjzMyqTMytrUwR0DUWB+ohMBJTU1EBAXw0B7U4tqxPQJlQyEM9g3XfrHqmh
A/HcsLW3KKH61lpBCR2JJ6mG3sRTkSc9Ykh1BBnpG/HkZShAFbvUf0sKsl7x
G2sviXjyMiwI8StfsAhinMXEs52R2IgnzhD5SOhfussTT6l8Y/SJlVHW2wgn
zrdUNAPYJXWSzXRtYJ3SkYpfV1Tj5XG5E008q7HmVRHMESpjojlG97mXmfYe
LTwDOBZrvA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{114, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->474622079]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28074],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TableSpacing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TableSpacing"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TableAlignments",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TableAlignments"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25020]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21478],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->26814]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with TableDirections",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
TableDirections"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TableDirections - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 52.2061650}", "context" -> "System`", 
    "keywords" -> {
     "recursive table directions", "table orientation", "column orientation", 
      "row orientation", "column major", "row major"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TableDirections is an option for TableForm and MatrixForm which \
specifies whether successive dimensions should be arranged as rows or \
columns. ", "synonyms" -> {"table directions"}, "title" -> "TableDirections", 
    "type" -> "Symbol", "uri" -> "ref/TableDirections"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4595, 159, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->785078658]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20763, 667}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1298, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1921, 60, 53, 1, 70, "ObjectName",
 CellID->14984],
Cell[1977, 63, 801, 24, 70, "Usage",
 CellID->16339]
}, Open  ]],
Cell[CellGroupData[{
Cell[2815, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3293, 109, 341, 9, 70, "Notes",
 CellID->2556],
Cell[3637, 120, 249, 8, 70, "Notes",
 CellID->25808],
Cell[3889, 130, 669, 24, 70, "Notes",
 CellID->4632]
}, Closed]],
Cell[CellGroupData[{
Cell[4595, 159, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->785078658],
Cell[CellGroupData[{
Cell[4980, 173, 148, 5, 70, "ExampleSection",
 CellID->113397074],
Cell[5131, 180, 90, 1, 70, "ExampleText",
 CellID->194365554],
Cell[CellGroupData[{
Cell[5246, 185, 315, 11, 28, "Input",
 CellID->234241432],
Cell[5564, 198, 510, 12, 78, "Output",
 Evaluatable->False,
 CellID->637504987]
}, Open  ]],
Cell[6089, 213, 87, 1, 70, "ExampleText",
 CellID->285974128],
Cell[CellGroupData[{
Cell[6201, 218, 391, 13, 28, "Input",
 CellID->32962944],
Cell[6595, 233, 478, 12, 62, "Output",
 Evaluatable->False,
 CellID->436620599]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7122, 251, 216, 7, 70, "ExampleSection",
 CellID->16798],
Cell[7341, 260, 196, 8, 70, "ExampleText",
 CellID->289012416],
Cell[CellGroupData[{
Cell[7562, 272, 316, 11, 70, "Input",
 CellID->197715426],
Cell[7881, 285, 742, 23, 78, "Output",
 CellID->777081076]
}, Open  ]],
Cell[CellGroupData[{
Cell[8660, 313, 393, 13, 70, "Input",
 CellID->143149236],
Cell[9056, 328, 655, 15, 70, "Output",
 Evaluatable->False,
 CellID->389543912]
}, Open  ]],
Cell[9726, 346, 125, 3, 70, "ExampleDelimiter",
 CellID->351969742],
Cell[9854, 351, 63, 1, 70, "ExampleText",
 CellID->337560346],
Cell[CellGroupData[{
Cell[9942, 356, 446, 15, 70, "Input",
 CellID->193913254],
Cell[10391, 373, 601, 14, 70, "Output",
 Evaluatable->False,
 CellID->25679448]
}, Open  ]],
Cell[11007, 390, 59, 1, 70, "ExampleText",
 CellID->396236230],
Cell[CellGroupData[{
Cell[11091, 395, 452, 15, 70, "Input",
 CellID->556580989],
Cell[11546, 412, 949, 19, 70, "Output",
 Evaluatable->False,
 CellID->52128733]
}, Open  ]],
Cell[12510, 434, 125, 3, 70, "ExampleDelimiter",
 CellID->110566279],
Cell[12638, 439, 78, 1, 70, "ExampleText",
 CellID->88677037],
Cell[CellGroupData[{
Cell[12741, 444, 269, 9, 70, "Input",
 CellID->450151608],
Cell[13013, 455, 1879, 35, 70, "Output",
 Evaluatable->False,
 CellID->65971308]
}, Open  ]],
Cell[14907, 493, 115, 3, 70, "ExampleText",
 CellID->53529365],
Cell[CellGroupData[{
Cell[15047, 500, 417, 14, 70, "Input",
 CellID->193562464],
Cell[15467, 516, 1945, 36, 70, "Output",
 Evaluatable->False,
 CellID->474622079]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17473, 559, 311, 9, 70, "SeeAlsoSection",
 CellID->28074],
Cell[17787, 570, 473, 17, 70, "SeeAlso",
 CellID->25020]
}, Open  ]],
Cell[CellGroupData[{
Cell[18297, 592, 314, 9, 70, "TutorialsSection",
 CellID->21478],
Cell[18614, 603, 147, 3, 70, "Tutorials",
 CellID->26814]
}, Open  ]],
Cell[CellGroupData[{
Cell[18798, 611, 305, 8, 70, "RelatedLinksSection"],
Cell[19106, 621, 372, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[19493, 636, 27, 0, 70, "History"],
Cell[19523, 638, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

