(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24099,        821]
NotebookOptionsPosition[     19118,        653]
NotebookOutlinePosition[     20687,        694]
CellTagsIndexPosition[     20602,        689]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Tables and Matrices\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TableAlignments" :> 
          Documentation`HelpLookup["paclet:ref/TableAlignments"], 
          "TableSpacing" :> 
          Documentation`HelpLookup["paclet:ref/TableSpacing"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TableAlignments\"\>", 
       2->"\<\"TableSpacing\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TableHeadings", "ObjectName",
 CellID->8522],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["TableHeadings",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TableHeadings"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["TableForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["MatrixForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
     " which gives the labels to be printed for entries in each dimension of \
a table or matrix. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7283]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TableHeadings", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " gives no labels in any dimension. "
}], "Notes",
 CellID->8160],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TableHeadings", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " gives successive integer labels for each entry in each dimension. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->237827221]
}], "Notes",
 CellID->17553],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TableHeadings", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["lbl", "TI"], 
        StyleBox["11", "TR"]], ",", 
       SubscriptBox[
        StyleBox["lbl", "TI"], 
        StyleBox["12", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " gives explicit labels for each entry. "
}], "Notes",
 CellID->24705],

Cell[TextData[{
 "The labels can be strings or other ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->650233214]
}], "Notes",
 CellID->27091],

Cell["The labels are placed as headings for rows or columns. ", "Notes",
 CellID->1259]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->64166732],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->96807056],

Cell["Give explicit headings for rows and columns:", "ExampleText",
 CellID->687548857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<r1\>\"", ",", "\"\<r2\>\"", ",", "\"\<r3\>\""}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"\"\<c1\>\"", ",", "\"\<c2\>\""}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->450242684],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdVttOwzAMTdN2tyKhrUiMy8Ne+Iq+wxMfUU1I2wMCjf1/iROnBPeslw1t
EpHa1I7tuD7HaV/L/ebtvdxv1+XqZVd+brbrr9Xzx86o4kgpVdC1VOa5Mk/2
KqrKzO6e0z0mrR3qqUWrYjfRiFmkeSysSZ8YcW7m1MwT66aBlUprmUOPhJX0
uhHyFMaWGSVni0ovtDgYTfMbalA1DeuBY7mt7QiituXmsVr8wmTSC4M7mMO0
wujfs97tMIRf59VKNnv05Nv7yuW8Pq7RPJLNDas51OKukbhCFgVyPiB2KuSu
XuyKjVgu92ipSGhVxz2O+QkzX6sf3Ovq9eyCR1Sdg13wwLv9py4g/TXP+ITs
xaCT+H/5HcKvWxf7pW//bLVqZuYY1+wAyfhDJ5j9liRMfTscirMO/6WQrb31
rRkerN6y/qoaysXC5nTZrvC18nzPhBxBL4yjxGUGrbBvyz4tSEkk4Wl7clS5
/vc1obwjrgKO7rtQxstYPwoiNL0zIeNexr6UMfGb/hn9ien/plX0DfjE+sw=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{59, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->88852398]
}, Open  ]],

Cell["Specify headings only for rows:", "ExampleText",
 CellID->781637214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<r1\>\"", ",", "\"\<r2\>\"", ",", "\"\<r3\>\""}], "}"}], 
      ",", "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280139010],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVtsOgjAMLQO8oCZeo4++G39Dn/wIYkzwwWiU/8ddis5SbpKgS6C06063
9mzjEMbR6RLG52O43t/DW3Q+Pta7612aXAcAtvLZrEB+J/JLP9skkdK8Z+rt
KqtusCywgmuEai6qSnaJt7J7Ug2k9KV09DDBeIH/0hG6Q7zoqBHXn/GiM/Ja
Q1ULGuSiCVyhYLIm2HzwWCa0bhZq0dzSWg0+atKrVIMpO4d+wld/hnYToQ6/
2rVSNqfVo6tPMzfE/kZMzngFrJXfMbSmLIMsfVgD2yd62T4sw+YYTmMUZMT2
euF+x3oPWZ/iODXZv/gYk8f6uRXhP/jdnPXK3kPJn4iVWNOI87+PYN9mZYyn
Y6vPVmCO30zLsp2yO++k0neGZ+zwPrEyO4uOnzB4hvECmWD3jtGu84d/E+A8
AYkSWzA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{45, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->44943174]
}, Open  ]],

Cell["Specify headings only for columns:", "ExampleText",
 CellID->136879370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<c1\>\"", ",", "\"\<c2\>\""}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->33602098],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytUkkOwjAMTNKFVSo7BS4c+gvucOIRFUKCAwIB/y924oaQBEoRlWrHrmfq
sbPN74f9Kb8fd/lyc80vh+Putlyfr5AKOGMsg3eVMjgXcJJvVhTgXSvAhlDQ
Bx+Bb8osC5RDO0YTqACPrZoV+ODHQSWPsCp6XgRWlXzPjlNv7Yxqm2/Uf5oK
4ob0j0ZlrwmaSMck3Z3m6M913j6MWGhUuWmcm2CvLErfwsLGMjun+l9miAIS
8tX7/naGdXDm/f6VG9Xb+Viz67sdEoV8lNqphWrL7IQ4u+7kJPa7uxnQXDtW
zCs12XHbOxvhzbrsDR+bEUe+v9diiK34XwqxM06auJ4trjG08B3KxwaCOX36
75iqbdHOR7QtYWyU8Qc8beBT\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{36, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TableForm=",
 CellID->671070512]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3154],

Cell[TextData[{
 "Use with ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->289012416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<r1\>\"", ",", "\"\<r2\>\"", ",", "\"\<r3\>\""}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"\"\<c1\>\"", ",", "\"\<c2\>\""}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143149236],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWD1vGkEQPfbuMDEm2LGNv2TJbeQiP8B9UkX+DciKZBdRItsFHSUlJSU/
gZKSkpKSkpKSkvKyOzvLnp8GsSbYojDS3d4M++btzM7O7d7P+vP9r9/154e7
+tWPx/rf+4e7p6vvfx61Ki5EUXSrr5vTSD9n+omu2yzTrb1fmntstPSLvpE2
JW2322XtMfT6SnKz2WQ5JlRCj+PxuN/vO22qQaY14BJYUfqWaPGA+1Uc62g0
QqudTodRCVihXulCJkwU7YjaGmA/kzyfzxuNhmeMndaScjQ8agfkNIirSnKr
1dKGnfeWSw2Hw2IIR5LnMIRfRA4dfj0JLzkogtPp1NlSGlTktiSOPwbb+yKX
n+08l8+MhDk4tPRDXzG+xlLM3plhLWbJJuQSprLoBcbxVPTKZ1dBtL2XyRl8
xvoq9JetnAD6+gP1TiiThSY1FLeYFS7jDrN8xq2yinn7mkqEq6sq9grLKxwH
Vkh5fR9vkFGskBtnVMLMFcOjm5/vYN5161fC9SuPNfewzAqrZRcgV4JsL6tl
5zzaj1q23aiQWpbyPJp2P8jqeiv6LavYlo5gyf71f+uauP8L8lZxLry+Eki1
Dd8dy96UtPPk/ahFhuVZZYV9XBMHQVb32JNPgK6x/jDIynuv4pvFvG/TyDaJ
arfba6D8uTOP0nv02WwmoVxOuvNmGWSbY5PJpNfruf7Oqj688GmTrK5ccbjS
dkWUErV2HIPBQDidadd4dPI48G29CzLWqpKL/4vTJp6la2txyWdVP6ueS+nY
bjKuUoVWOm7kF//rvcOvFq5eY40rsx79wmjFORZ7lJZYMFry26EIVqxt/Bpj
6pmpX0eZzWiqnvzlJir8AxqtSsk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{79, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->61872900]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->197798800],

Cell["Use automatically generated headings for rows and columns:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->237827221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323318069],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVs1uwjAMTpp2TNChjW3ajpz6ErtvJx6iQkhwmECM9+9sx+mCl/6kQoVI
TRr/Jf78tcmqPG033+Vpty6XX8fysN2tf5af+yOIjFZKFfB8vCt4r+CNnqKq
YLR9jr1BKTX11iJNoEfhRGgNdClMpzBmMGqyJrE1Ik/fIxVzqX8I6VU2WhTM
Yhb0xqSSAAakzeq5Tb0hRtcODOM8G4znIrhuU/2eWW7XiWHEuFKHADZU3jXg
ljNuAzj4r4LToFTXePoRgpzw5nlLLCNsZW4xsWRmkm8tmfpWdbw+fE2Zr85L
D+Lt65lnE19fvHVug5nD+YpluOfx7w/TyYQono4f0T8RLr+rhLHSUftxf1SV
Mhmp9cP8KRDP+iZcP1/7yHL6bqIYU9Cerstdd/6dn+bSSn65bZXu8g2fkl1e
Ut9vLbwTON7085hXPtMuiYO7S+CeTM1Fey9T+hdiuxu7\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{38, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->619172657]
}, Open  ]],

Cell["Use automatic headings only for rows:", "ExampleText",
 CellID->162665815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->287762959],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVd0OgiAUBtFqalu/q0uvvOk96qqHcK5NL1rNfH87wNGIwNQ1Fxsg3+Ec
OB+fcE7K7HJNyjxNolOR3LM8fUTHWwEQo4SQGOphT+C7gi9R46qCXrYhbxlH
RSG7FtSBloNTzcqgcWHoQ+9BT8VsActJwlP1cLWxbp+b7MQbLQrPIjB686Qc
AwfC6jVjmbolxrcdMOQ5GMznyriu7fzWiMt1+ihiXLRmgBdunFh4C5G3ARr8
OEHfiNKGTzWCURPKOGyJxbS5em59YumZ6XpryVSd1cTrolcX9Vp70UG63b55
2vS6Udb5D2UO1ys/hhn2rxvmqxJ66XT8iOqL8PtdOcgV7bWf+kYlLopRlG6c
Lw3xpK+D56daF4iL/wbfWUKfhEPxVg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{38, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->162413914]
}, Open  ]],

Cell["Only for columns:", "ExampleText",
 CellID->475805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->511051226],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytU9sOgjAM3QYkXgCvIT7yH77rkx+xEBN4MBrk/7EdBceY4IxL1q7badee
rRdZ5debrIpMpudSPvIie6anewlbHmeMJTCPBwbrGlZqJnUNeigFSB8AC9AB
aK52mdcolDEKrzFwKRwROPBwORlHGIi51QNlG++d8caK3RKWf6h+jBX0C+mO
8TxnKILOprKHTEZ/xlnz0DnovNpXRs7aXd6d7nvWTsO4coZJz0hPv++3vLn4
6f/519iCsue9qN0f9slVjabKtRGluWBFsYIhY8p3nE+zf/od6hk3jtVrYu2d
aKJCw7bHijSe7Ii4x6RL3oL4i4h9obPDXzX0a30=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{22, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TableForm=",
 CellID->218278381]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->351969742],

Cell["Specify Greek letters for row and column headings:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->650233214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "##"], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Alpha]", ",", "\[Beta]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Gamma]", ",", "\[Delta]", ",", "\[Epsilon]"}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->151556646],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV91PwjAQ775gMo0ONEGYCYm+mvhX6JOJvvi+kCXwYDTI/z97XQvd9bZ2
fOkS1t7vPnp3bX/Aa75eFJ/5ejnPZy+r/HuxnP/Mnr9WHAo8xljBP49jxucl
n4lPUZZ8PId3ALJ42CWSM4vcE1F05AxZgAxigPCIT1NdF250Eh02an2FWlfW
5VAtu4nD52xEWW1X45NrykKTff6CJnsw1rKC+JBrH3lA7pCIj3BslxzYTmVX
DSp3W21mz/Be4nUGR/SKiW7vW4/uBXLslBn26iM52cnL71wTmIZEp+Buwum7
aNBTp8jFjug6ccbpTk86oKkYRZzafewR9YOYoXHo6P8h4EB2C9dRaTFPnhbd
jZVxFDjVFEsAdqXrDCZOG7VbJsarDYhdMvcYcyviej65oSws7CuDE7VSd+cv
mVirw/kO/TP2NXxOWYV+l0FPc67Ny3esRDEt2MN+xWWdYRWOf3kkFv1+nezO
qepnW/VokDOrHov5CpHR4aMrdn9v1Orn4c3JKpMx7+TupqRXKK2mJWa2KbIc
kf4Rkm+bd9saS2e/9pMTNdZD8/jEqK4lI+MbBNc4lnjW2tl7JD+RVg8yVqWt
/vUw7xccrMdW\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{101, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->62056159]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28317],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TableAlignments",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TableAlignments"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TableSpacing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TableSpacing"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20055]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25386],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->31687]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with TableHeadings",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=TableHeadings"],
     None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TableHeadings - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 58.3000710}", "context" -> "System`", 
    "keywords" -> {
     "captions in tables", "headings in tables", "labels", "Names", "Text", 
      "titles", "row labels", "column labels", "row headings", 
      "column headings", "row captions", "column captions", "labeling rows", 
      "labeling columns", "tabular headings"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TableHeadings is an option for TableForm and MatrixForm which gives the \
labels to be printed for entries in each dimension of a table or matrix. ", 
    "synonyms" -> {"table headings"}, "title" -> "TableHeadings", "type" -> 
    "Symbol", "uri" -> "ref/TableHeadings"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4756, 168, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->64166732]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20460, 682}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1298, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1921, 60, 50, 1, 70, "ObjectName",
 CellID->8522],
Cell[1974, 63, 800, 24, 70, "Usage",
 CellID->7283]
}, Open  ]],
Cell[CellGroupData[{
Cell[2811, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3289, 109, 232, 8, 70, "Notes",
 CellID->8160],
Cell[3524, 119, 362, 11, 70, "Notes",
 CellID->17553],
Cell[3889, 132, 499, 17, 70, "Notes",
 CellID->24705],
Cell[4391, 151, 238, 9, 70, "Notes",
 CellID->27091],
Cell[4632, 162, 87, 1, 70, "Notes",
 CellID->1259]
}, Closed]],
Cell[CellGroupData[{
Cell[4756, 168, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->64166732],
Cell[CellGroupData[{
Cell[5140, 182, 147, 5, 70, "ExampleSection",
 CellID->96807056],
Cell[5290, 189, 87, 1, 70, "ExampleText",
 CellID->687548857],
Cell[CellGroupData[{
Cell[5402, 194, 614, 21, 28, "Input",
 CellID->450242684],
Cell[6019, 217, 770, 17, 94, "Output",
 Evaluatable->False,
 CellID->88852398]
}, Open  ]],
Cell[6804, 237, 74, 1, 70, "ExampleText",
 CellID->781637214],
Cell[CellGroupData[{
Cell[6903, 242, 541, 18, 28, "Input",
 CellID->280139010],
Cell[7447, 262, 656, 15, 78, "Output",
 Evaluatable->False,
 CellID->44943174]
}, Open  ]],
Cell[8118, 280, 77, 1, 70, "ExampleText",
 CellID->136879370],
Cell[CellGroupData[{
Cell[8220, 285, 517, 18, 28, "Input",
 CellID->33602098],
Cell[8740, 305, 612, 14, 94, "Output",
 Evaluatable->False,
 CellID->671070512]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9401, 325, 215, 7, 70, "ExampleSection",
 CellID->3154],
Cell[9619, 334, 196, 8, 70, "ExampleText",
 CellID->289012416],
Cell[CellGroupData[{
Cell[9840, 346, 615, 21, 70, "Input",
 CellID->143149236],
Cell[10458, 369, 1104, 22, 70, "Output",
 Evaluatable->False,
 CellID->61872900]
}, Open  ]],
Cell[11577, 394, 125, 3, 70, "ExampleDelimiter",
 CellID->197798800],
Cell[11705, 399, 151, 3, 70, "ExampleText",
 CellID->237827221],
Cell[CellGroupData[{
Cell[11881, 406, 396, 13, 70, "Input",
 CellID->323318069],
Cell[12280, 421, 693, 15, 70, "Output",
 Evaluatable->False,
 CellID->619172657]
}, Open  ]],
Cell[12988, 439, 80, 1, 70, "ExampleText",
 CellID->162665815],
Cell[CellGroupData[{
Cell[13093, 444, 450, 15, 70, "Input",
 CellID->287762959],
Cell[13546, 461, 620, 14, 70, "Output",
 Evaluatable->False,
 CellID->162413914]
}, Open  ]],
Cell[14181, 478, 57, 1, 70, "ExampleText",
 CellID->475805],
Cell[CellGroupData[{
Cell[14263, 483, 450, 15, 70, "Input",
 CellID->511051226],
Cell[14716, 500, 567, 13, 70, "Output",
 Evaluatable->False,
 CellID->218278381]
}, Open  ]],
Cell[15298, 516, 125, 3, 70, "ExampleDelimiter",
 CellID->351969742],
Cell[15426, 521, 141, 2, 70, "ExampleText",
 CellID->650233214],
Cell[CellGroupData[{
Cell[15592, 527, 542, 18, 70, "Input",
 CellID->151556646],
Cell[16137, 547, 844, 18, 70, "Output",
 Evaluatable->False,
 CellID->62056159]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17042, 572, 311, 9, 70, "SeeAlsoSection",
 CellID->28317],
Cell[17356, 583, 473, 17, 70, "SeeAlso",
 CellID->20055]
}, Open  ]],
Cell[CellGroupData[{
Cell[17866, 605, 314, 9, 70, "TutorialsSection",
 CellID->25386],
Cell[18183, 616, 147, 3, 70, "Tutorials",
 CellID->31687]
}, Open  ]],
Cell[CellGroupData[{
Cell[18367, 624, 305, 8, 70, "RelatedLinksSection"],
Cell[18675, 634, 371, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[19061, 649, 27, 0, 70, "History"],
Cell[19091, 651, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

