(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14364,        554]
NotebookOptionsPosition[     10148,        413]
NotebookOutlinePosition[     11625,        453]
CellTagsIndexPosition[     11540,        448]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Clear" :> Documentation`HelpLookup["paclet:ref/Clear"], "Unset" :> 
         Documentation`HelpLookup["paclet:ref/Unset"], "TagSet" :> 
         Documentation`HelpLookup["paclet:ref/TagSet"], "TagSetDelayed" :> 
         Documentation`HelpLookup["paclet:ref/TagSetDelayed"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Clear\"\>", 2->"\<\"Unset\"\>", 
      3->"\<\"TagSet\"\>", 4->"\<\"TagSetDelayed\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "TagUnset ",
 StyleBox["(/: =.)", "OperatorCharacter"]
}], "ObjectName",
 CellID->8872],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "/:", 
       RowBox[{
        StyleBox["lhs", "TI"], "=."}]}]], "InlineFormula"],
     "\[LineSeparator]removes any rules defined for ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     ", associated with the symbol ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32668]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Rules are removed only when their left\[Hyphen]hand side is identical to ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 ", and the tests in ",
 Cell[BoxData[
  ButtonBox["Condition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Condition"]], "InlineFormula"],
 " given on the right\[Hyphen]hand side are also identical. "
}], "Notes",
 CellID->19974]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->235249024],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->162205224],

Cell[BoxData[
 RowBox[{"h", "/:", 
  RowBox[{"f", "[", 
   RowBox[{"h", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"fh", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->392493858],

Cell[BoxData[
 RowBox[{"h", "/:", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"h", "[", "x_", "]"}], "]"}], "=."}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->118656949]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25524],

Cell["Clear immediate definitions:", "ExampleText",
 CellID->296899146],

Cell[BoxData[
 RowBox[{
  RowBox[{"sq", "/:", 
   RowBox[{"area", "[", "sq", "]"}], "=", 
   RowBox[{"s", "^", "2"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->644135117],

Cell[BoxData[
 RowBox[{"sq", "/:", 
  RowBox[{
   RowBox[{"area", "[", "sq", "]"}], "=."}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->361610878],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->326673621],

Cell["Clear delayed definitions:", "ExampleText",
 CellID->177726658],

Cell[BoxData[
 RowBox[{"int", "/:", 
  RowBox[{"rand", "[", "int", "]"}], ":=", 
  RowBox[{"Random", "[", "Integer", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66248155],

Cell[BoxData[
 RowBox[{"int", "/:", 
  RowBox[{
   RowBox[{"rand", "[", "int", "]"}], "=."}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->722719578]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32240],

Cell[TextData[{
 "Use ",
 Cell[BoxData["=."], "InlineFormula"],
 " to clear definitions with a particular left-hand side:"
}], "ExampleText",
 CellID->292515749],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sq", "/:", 
   RowBox[{"area", "[", "sq", "]"}], "=", 
   RowBox[{"s", "^", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sq", "/:", 
   RowBox[{"circ", "[", "sq", "]"}], "=", 
   RowBox[{"4", "s"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->521509637],

Cell[BoxData[
 RowBox[{"sq", "/:", 
  RowBox[{
   RowBox[{"circ", "[", "sq", "]"}], "=."}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->538346729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"area", "[", "sq", "]"}], ",", 
   RowBox[{"circ", "[", "sq", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->230290196],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["s", "2"], ",", 
   RowBox[{"circ", "[", "sq", "]"}]}], "}"}]], "Output",
 ImageSize->{98, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->483485825]
}, Open  ]],

Cell["Clear all definitions:", "ExampleText",
 CellID->57250942],

Cell[BoxData[
 RowBox[{"Clear", "[", "sq", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->634107459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "sq", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->21692100],

Cell[BoxData[
 InterpretationBox["Null",
  Definition[$CellContext`sq],
  Editable->False]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->135239025]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29334],

Cell["To clear an upvalue, the tag is required:", "ExampleText",
 CellID->454166266],

Cell[BoxData[
 RowBox[{"h", "/:", 
  RowBox[{"f", "[", 
   RowBox[{"h", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"fh", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52680478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"h", "[", "x_", "]"}], "]"}], "=."}]], "Input",
 CellLabel->"In[2]:=",
 CellID->42660897],

Cell[BoxData[
 RowBox[{
  RowBox[{"Unset", "::", "\<\"norep\"\>"}], ":", 
  " ", "\<\"Assignment on \\!\\(f\\) for \\!\\(f[\\(\\(h[x_]\\)\\)]\\) not \
found.\"\>"}]], "Message", "MSG",
 CellID->157770353],

Cell[BoxData["$Failed"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->375499462]
}, Open  ]],

Cell[BoxData[
 RowBox[{"h", "/:", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"h", "[", "x_", "]"}], "]"}], "=."}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->659795559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "h", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->5862267],

Cell[BoxData[
 InterpretationBox["Null",
  Definition[$CellContext`h],
  Editable->False]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->50571938]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18018],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Clear",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Clear"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TagSet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TagSet"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TagSetDelayed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TagSetDelayed"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31015]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TagUnset (/: =.) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 8.6440858}", "context" -> "System`", 
    "keywords" -> {
     "clearing associated values", "clearing values", 
      "clearing values of symbols", "deleting values", "erasing values", 
      "killing values", "removing assignments", "removing values", 
      "undefining symbols", "unsetting symbols"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "f /: lhs =. removes any rules defined for lhs, associated with the \
symbol f. ", "synonyms" -> {"tag unset", "=.", "/:"}, "title" -> "TagUnset", 
    "type" -> "Symbol", "uri" -> "ref/TagUnset"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3108, 108, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->235249024]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11397, 441}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 834, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1457, 44, 104, 4, 70, "ObjectName",
 CellID->8872],
Cell[1564, 50, 604, 20, 70, "Usage",
 CellID->32668]
}, Open  ]],
Cell[CellGroupData[{
Cell[2205, 75, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2683, 92, 388, 11, 70, "Notes",
 CellID->19974]
}, Closed]],
Cell[CellGroupData[{
Cell[3108, 108, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->235249024],
Cell[CellGroupData[{
Cell[3493, 122, 148, 5, 70, "ExampleSection",
 CellID->162205224],
Cell[3644, 129, 191, 6, 70, "Input",
 CellID->392493858],
Cell[3838, 137, 172, 6, 70, "Input",
 CellID->118656949]
}, Open  ]],
Cell[CellGroupData[{
Cell[4047, 148, 216, 7, 70, "ExampleSection",
 CellID->25524],
Cell[4266, 157, 71, 1, 70, "ExampleText",
 CellID->296899146],
Cell[4340, 160, 179, 6, 70, "Input",
 CellID->644135117],
Cell[4522, 168, 146, 5, 70, "Input",
 CellID->361610878],
Cell[4671, 175, 125, 3, 70, "ExampleDelimiter",
 CellID->326673621],
Cell[4799, 180, 69, 1, 70, "ExampleText",
 CellID->177726658],
Cell[4871, 183, 177, 5, 70, "Input",
 CellID->66248155],
Cell[5051, 190, 148, 5, 70, "Input",
 CellID->722719578]
}, Closed]],
Cell[CellGroupData[{
Cell[5236, 200, 233, 7, 70, "ExampleSection",
 CellID->32240],
Cell[5472, 209, 161, 5, 70, "ExampleText",
 CellID->292515749],
Cell[5636, 216, 313, 10, 70, "Input",
 CellID->521509637],
Cell[5952, 228, 146, 5, 70, "Input",
 CellID->538346729],
Cell[CellGroupData[{
Cell[6123, 237, 181, 6, 70, "Input",
 CellID->230290196],
Cell[6307, 245, 261, 9, 39, "Output",
 CellID->483485825]
}, Open  ]],
Cell[6583, 257, 64, 1, 70, "ExampleText",
 CellID->57250942],
Cell[6650, 260, 102, 3, 70, "Input",
 CellID->634107459],
Cell[CellGroupData[{
Cell[6777, 267, 106, 3, 70, "Input",
 CellID->21692100],
Cell[6886, 272, 232, 8, 36, "Output",
 CellID->135239025]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7167, 286, 226, 7, 70, "ExampleSection",
 CellID->29334],
Cell[7396, 295, 84, 1, 70, "ExampleText",
 CellID->454166266],
Cell[7483, 298, 190, 6, 70, "Input",
 CellID->52680478],
Cell[CellGroupData[{
Cell[7698, 308, 145, 5, 70, "Input",
 CellID->42660897],
Cell[7846, 315, 204, 5, 70, "Message",
 CellID->157770353],
Cell[8053, 322, 164, 5, 36, "Output",
 CellID->375499462]
}, Open  ]],
Cell[8232, 330, 172, 6, 70, "Input",
 CellID->659795559],
Cell[CellGroupData[{
Cell[8429, 340, 104, 3, 70, "Input",
 CellID->5862267],
Cell[8536, 345, 230, 8, 36, "Output",
 CellID->50571938]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8827, 360, 311, 9, 70, "SeeAlsoSection",
 CellID->18018],
Cell[9141, 371, 935, 35, 70, "SeeAlso",
 CellID->31015]
}, Open  ]],
Cell[10091, 409, 27, 0, 70, "History"],
Cell[10121, 411, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

