(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     60748,       2255]
NotebookOptionsPosition[     49474,       1855]
NotebookOutlinePosition[     51036,       1896]
CellTagsIndexPosition[     50950,       1891]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Getting Pieces of Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/GettingPiecesOfLists"], 
          "Manipulating Lists by Their Indices" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingListsByTheirIndices"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Getting Pieces of Lists\"\>", 
       2->"\<\"Manipulating Lists by Their Indices\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Span" :> Documentation`HelpLookup["paclet:ref/Span"], "Part" :> 
          Documentation`HelpLookup["paclet:ref/Part"], "Drop" :> 
          Documentation`HelpLookup["paclet:ref/Drop"], "StringTake" :> 
          Documentation`HelpLookup["paclet:ref/StringTake"], "First" :> 
          Documentation`HelpLookup["paclet:ref/First"], "Last" :> 
          Documentation`HelpLookup["paclet:ref/Last"], "Most" :> 
          Documentation`HelpLookup["paclet:ref/Most"], "Rest" :> 
          Documentation`HelpLookup["paclet:ref/Rest"], "Complement" :> 
          Documentation`HelpLookup["paclet:ref/Complement"], "Select" :> 
          Documentation`HelpLookup["paclet:ref/Select"], "Cases" :> 
          Documentation`HelpLookup["paclet:ref/Cases"], "TakeWhile" :> 
          Documentation`HelpLookup["paclet:ref/TakeWhile"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Span\"\>", 2->"\<\"Part\"\>", 
       3->"\<\"Drop\"\>", 4->"\<\"StringTake\"\>", 5->"\<\"First\"\>", 
       6->"\<\"Last\"\>", 7->"\<\"Most\"\>", 8->"\<\"Rest\"\>", 
       9->"\<\"Complement\"\>", 10->"\<\"Select\"\>", 11->"\<\"Cases\"\>", 
       12->"\<\"TakeWhile\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfExpressions"], 
          "Parts of Matrices" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfMatrices"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"], 
          "Structural Operations on Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/StructuralOperationsOnExpressions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Elements of Lists\"\>", 
       2->"\<\"Handling Arrays of Data\"\>", 3->"\<\"Language Overview\"\>", 
       4->"\<\"List Manipulation\"\>", 5->"\<\"Numerical Data\"\>", 
       6->"\<\"Parts of Expressions\"\>", 7->"\<\"Parts of Matrices\"\>", 
       8->"\<\"Rearranging & Restructuring Lists\"\>", 
       9->"\<\"Structural Operations on Expressions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Take", "ObjectName",
 CellID->29153],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Take",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Take"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Take",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Take"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"-", 
         StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the last ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Take",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Take"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["m", "TI"], ",", 
          StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives elements ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Take",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Take"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        SubscriptBox[
         StyleBox["seq", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["seq", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a nested list in which elements specified by ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["seq", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " are taken at level ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->21184]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 " uses the standard sequence specification:"
}], "Notes",
 CellID->19649],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell["all elements", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no elements", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "elements 1 through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "last ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " elements"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "element ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " only"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      StyleBox["n", "TI"]}], "}"}], Cell[TextData[{
     "elements ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " inclusive"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      StyleBox["n", "TI"], ",", 
      StyleBox["s", "TI"]}], "}"}], Cell[TextData[{
     "elements ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " in steps of ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->30350],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 " can be used on an object with any head, not necessarily ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10405],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    SubscriptBox[
     StyleBox["seq", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["seq", "TI"], 
     StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
 " effectively extracts a submatrix from ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24346],

Cell[TextData[{
 "Applying ",
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 " to a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object normally yields another ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object. "
}], "Notes",
 CellID->1025]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->264146921],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->597052296],

Cell["Take the first 4 elements from a list:", "ExampleText",
 CellID->5692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14550],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1296688030]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13795],

Cell["Take the last 3 elements:", "ExampleText",
 CellID->13852],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", 
   RowBox[{"-", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17350],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"d", ",", "e", ",", "f"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6668212]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10036],

Cell["Take elements 2 through 4:", "ExampleText",
 CellID->29361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3760],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1887482826]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2534],

Cell["Take elements from the second to the second-to-last:", "ExampleText",
 CellID->6050],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28082],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "c", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->689036923]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1936],

Cell["Take every other element:", "ExampleText",
 CellID->25584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10790],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "c", ",", "e"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1745130544]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29182],

Cell["Take the first two rows of a matrix:", "ExampleText",
 CellID->19066],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11", ",", "12", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"21", ",", "22", ",", "23"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"31", ",", "32", ",", "33"}], "}"}]}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23116],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"11", ",", "12", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "22", ",", "23"}], "}"}]}], "}"}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1218668537]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9425],

Cell["Take all rows, and the first two columns:", "ExampleText",
 CellID->13101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11", ",", "12", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"21", ",", "22", ",", "23"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"31", ",", "32", ",", "33"}], "}"}]}], "}"}], ",", "All", ",", 
   "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5610],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"11", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"21", ",", "22"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"31", ",", "32"}], "}"}]}], "}"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->399080513]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19982],

Cell["Take the first two rows, and the last column:", "ExampleText",
 CellID->28621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"11", ",", "12", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"21", ",", "22", ",", "23"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"31", ",", "32", ",", "33"}], "}"}]}], "}"}], ",", "2", ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5193],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "13", "}"}], ",", 
   RowBox[{"{", "23", "}"}]}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2144831950]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16754],

Cell["Take a submatrix:", "ExampleText",
 CellID->4593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Take", "[", 
   RowBox[{
    TagBox[
     RowBox[{"(", "\:f3a2", GridBox[{
        {"11", "12", "13", "14", "15"},
        {"21", "22", "23", "24", "25"},
        {"31", "32", "33", "34", "35"},
        {"41", "42", "43", "44", "45"},
        {"51", "52", "53", "54", "55"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{
        "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
         "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "5"}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14895],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"23", "24", "25"},
     {"33", "34", "35"},
     {"43", "44", "45"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{82, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->2093820990]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5638],

Cell["Take every other row and column:", "ExampleText",
 CellID->25167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Take", "[", 
   RowBox[{
    TagBox[
     RowBox[{"(", "\:f3a2", GridBox[{
        {"11", "12", "13", "14", "15"},
        {"21", "22", "23", "24", "25"},
        {"31", "32", "33", "34", "35"},
        {"41", "42", "43", "44", "45"},
        {"51", "52", "53", "54", "55"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxSpacings->{
        "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
         "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
     Function[BoxForm`e$, 
      MatrixForm[BoxForm`e$]]], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17420],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"11", "13", "15"},
     {"31", "33", "35"},
     {"51", "53", "55"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{82, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->792988290]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16883],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 " works with any head, not just ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->23865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"a", "+", "b", "+", "c", "+", "d", "+", "e", "+", "f"}], ",", 
   "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24696],

Cell[BoxData[
 RowBox[{"a", "+", "b", "+", "c"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1632010629]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "+", "b", "+", "c"}], ",", 
     RowBox[{"t", "+", "u", "+", "v"}], ",", 
     RowBox[{"x", "+", "y", "+", "z"}]}], "}"}], ",", "2", ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10390],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "+", "b"}], ",", 
   RowBox[{"t", "+", "u"}]}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->406441414]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"a", "+", "b", "+", "c"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"t", "+", "u", "+", "v"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "+", "y", "+", "z"}], ")"}]}], ",", "2", ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20189],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"a", "+", "b"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"t", "+", "u"}], ")"}]}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1070082745]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20183],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->13817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"SparseArray", "[", 
    RowBox[{"Range", "[", "1000", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"100", ",", "105"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22129],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "6", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 6, ">"],
     Editable->False], ",", 
    RowBox[{"{", "6", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1104885380]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10679],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"100", ",", "101", ",", "102", ",", "103", ",", "104", ",", "105"}],
   "}"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->460266342]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8252],

Cell["Pick out a subimage:", "ExampleText",
 CellID->15145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"150", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "50"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19861],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJy1VUsWgyAMDL1Jz9Cb9Ai+13Xvv6tWI5oPCSRQLYZBJ0TGeS7f9/IAgNd6
ftYTyvarjca09eJ7vPHcZkHrGf34HtN72s/ox+Hguh9sIIgjF9z+QRiL4LVu
WMtrr1334rVucLmWxiI4rqXW8tpn4cjLayrpZxTHXHhNM3HMRe6zcMylHDsC
hHrGceTGHSF/n6I45gKF7+88HHOR9ncejrlI+zsPx1xa9YzjmEuun2i5zMUx
l/ZhGYqvWY5hzXCyNLzCwvyt5RUW1sFi+IY1z7uWtm9Y87xrafuGNc/JQno6
bs1zsii60OKxpulCiwdZFF1o8ehafDqJcOi60OJBFqdOgixOnQRZOuNBFiKM
Mf8wWYg2xvzDZCHaoGNJLIV/o+L6YCzEN3L0wViEd5LNwX0j932cLEqfzJLi
HyZLin+YLCn+YbKUGfpgLFP0wVimvo+TZfo6/iz9t/wAriwTHQ==
   "], {{0, 0}, {101, 51}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{None, None},
  ImageMargins->0.,
  PlotRangeClipping->True]], "Output",
 ImageSize->{229, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->206748652]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Take", "[", 
   RowBox[{
    RowBox[{"CellularAutomaton", "[", 
     RowBox[{"150", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "50"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", 
      RowBox[{"-", "20"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"20", ",", 
      RowBox[{"-", "20"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28318],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1qwkAQ3iQaEhCLKFVB1FYvgs/RnvoQQQQ9iKI+mAffbzqjO7KO2dbV
FjVmIfky3/zshN2dDPlK1pPxLFlPR0n3c5ksJtPRqvsxXyIVeEqpLV7DhsJn
wKfdtQWAvQJHQMxuqA3ePHe2cGBxFMksBUNEX2OaPs2OMBayi7/NrpDnfuvc
jZ1E2kBbEUaIvpBZ7wvZ1PtCtvGXzhNmMHtiI21FWLbI5o74yY7l+Olmi8W6
1MQ6VC3rW/3Fr/R0sxHLVYN3uKwuzJNd07APLPw5cV7ybByzKcNxzbHVIubb
QmZ92zFO5QGyIdasHj3YV5me4Gt3582nlHGg33Mg+Prdeb/Caf8RCfnafkfG
C/VpyrNxyaYpzlIM/9MdcVzmWw+QTQuO+w3XfoWxk7noHcv6nNt/sN975qK/
wd98//s3iH7ZXwf998L7BlzNkBg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1033547516]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7813],

Cell["Sample every third cell in an image:", "ExampleText",
 CellID->14907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"30", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "50"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29554],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJy1lVFSwzAMRCVuwhm4CUdghm/u/0eLrd2VsWM3iUPJtImj9dNKyvvXz+fX
m5l9PP6/7Xm4Pz7PU/3+OD//vP76u1dXxMVyo1zFfSsRLBaXBYxZbnpdEI8b
49TdaKi4+vcLUjVK2WeNkjaHBVgXcTxwPQHWy+YiFYtlg7I5wwKsi1wiB1ge
YQ3wErMBTZsb+IIoVHGgCTyhkQpNAFm6voSd4gDRAE9opCInYOKLR0KQO0FD
4VnwMxU5ARNfkH4XeT5pjImNwtJWZdovJvLMHsPDisi8t8dKv6h8fCS8bJQ3
+ixH/aLykT0JHxXiodRVmfQL86XZU9vdRXakMukXXmb2JDxaZsQx9cU1X6bM
6I3I85hj6oucPDNHAbLYDjTm/ZKnFtqSbdjtjxHLqF8wPGBxJeMUnnAoy6Bf
MDyMsODwyPSKykG/eAyP+IKxiOcXNGb94t58Mczlw/4YsfR8MUkSTAq2JT9a
lo4voiylxIJb1jjyRZWl/Vhwr6n0fUnKrLD++2OVpfUlKTsrbK0/RiytLwzK
CgPfGZWOLzJNWGpl/QmNkS8yTZDFV/pjxKK+mEri9XWWQ1nUF5kmGO/nOZRF
fUHHsNMvcCiLjlyO/MC4ptHzhSO/il/kUBadJhr8OgdCuvqSg9+h8d+X6MfX
3h8LKsmX6JNr/dFRSb6A6zaOqqK+ROZu5Kgq6ks4c6tG68vZ98eCSop+P0dV
SdF3aCRfNvghKuHLJo6qgjG/79Axv1Vlox+ispmjqOzXOMXxC/ECEP0=
   "], {{0, 0}, {101, 51}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{None, None},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->406603684]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Take", "[", 
   RowBox[{
    RowBox[{"CellularAutomaton", "[", 
     RowBox[{"30", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "50"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->617],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAHiOAkGIPs/kAXG
ICEgYAaxwYBhA5BgpIEoG5DgAnJZgTQ/lOZCoo2RxFmBNBeUFh41jYqmcUN1
wVRJAml5JN0gWgQqLwmk+UZNIcEUASRT+KGmcCPxuZBMA/FlR00hwRRRpJSP
HicgPhtSDuBComGmSoyaSkdTpf5jL7dU0Pjqo7qRdMsjhTGsHOJG0gWj+aHy
SqOmkGCKCpIpsHKHDYkPywFmo7qRdGsihTFyKc2GxIfRoLpRZ9QUEkzR+49a
XnCjmeYwonQZ/0fN58i6kHVjT6kjVbcFkm5RJF2uw0q17X/U/IYcRlw4U9Rw
1eWEpAtUE4YMKVXuUFUCUL96DSlVPlC/RQ4q2UC8IT5QsrQaT6KmKHQUjBEA
JRGuhQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10974542]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25429],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Drop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Drop"]], "InlineFormula"],
 " are complementary:"
}], "ExampleText",
 CellID->2264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
     "h"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "4"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "d"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->186131723]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Drop", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
     "h"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "4"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29942],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "c", ",", "e", ",", "f", ",", "g", ",", "h"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1019311687]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19522],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 " is often equivalent to part extraction with ",
 Cell[BoxData[
  ButtonBox["Range",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Range"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
     "h"}], "}"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27587],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1427337609]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
   "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
    "h"}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"Range", "[", "4", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23158],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->850189196]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
     "h"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "7", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->13762],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "d", ",", "f"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2038389529]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
   "a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f", ",", "g", ",", 
    "h"}], "}"}], "[", 
  RowBox[{"[", 
   RowBox[{"Range", "[", 
    RowBox[{"2", ",", "7", ",", "2"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->30946],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "d", ",", "f"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->221772666]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26486391],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["Part",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Part"]], "InlineFormula"],
 " extraction with ",
 Cell[BoxData[
  ButtonBox["Span",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Span"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->616149101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", " ", "=", " ", 
  RowBox[{"Array", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "#"], "&"}], ",", "7"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8214583],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["x", "1"], ",", 
   SubscriptBox["x", "2"], ",", 
   SubscriptBox["x", "3"], ",", 
   SubscriptBox["x", "4"], ",", 
   SubscriptBox["x", "5"], ",", 
   SubscriptBox["x", "6"], ",", 
   SubscriptBox["x", "7"]}], "}"}]], "Output",
 ImageSize->{173, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->455334019]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{"e", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", 
     RowBox[{"-", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->260653285],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["x", "7"], ",", 
   SubscriptBox["x", "5"], ",", 
   SubscriptBox["x", "3"], ",", 
   SubscriptBox["x", "1"]}], "}"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->466973423]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{"-", "1"}], ";;", "1", ";;", 
    RowBox[{"-", "2"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->200440206],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["x", "7"], ",", 
   SubscriptBox["x", "5"], ",", 
   SubscriptBox["x", "3"], ",", 
   SubscriptBox["x", "1"]}], "}"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->218905030]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8380],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 " gives an array whose first dimensions are its arguments:"
}], "ExampleText",
 CellID->13165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", 
  RowBox[{"Take", "[", 
   RowBox[{
    RowBox[{"Array", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"10", ",", "10", ",", "10", ",", "10"}], "}"}]}], "]"}], ",", 
    "3", ",", "4"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5946],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "4", ",", "10", ",", "10"}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->731756616]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120356863],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Reverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reverse"], "[", 
   StyleBox["e", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"], "[", 
   RowBox[{
    StyleBox["e", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->171348414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", " ", "=", " ", 
  RowBox[{"Array", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["x", "#"], "&"}], ",", "7"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->104396140],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["x", "1"], ",", 
   SubscriptBox["x", "2"], ",", 
   SubscriptBox["x", "3"], ",", 
   SubscriptBox["x", "4"], ",", 
   SubscriptBox["x", "5"], ",", 
   SubscriptBox["x", "6"], ",", 
   SubscriptBox["x", "7"]}], "}"}]], "Output",
 ImageSize->{173, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->418722448]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reverse", "[", "e", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->90375369],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["x", "7"], ",", 
   SubscriptBox["x", "6"], ",", 
   SubscriptBox["x", "5"], ",", 
   SubscriptBox["x", "4"], ",", 
   SubscriptBox["x", "3"], ",", 
   SubscriptBox["x", "2"], ",", 
   SubscriptBox["x", "1"]}], "}"}]], "Output",
 ImageSize->{173, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25977510]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{"e", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->171896880],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["x", "7"], ",", 
   SubscriptBox["x", "6"], ",", 
   SubscriptBox["x", "5"], ",", 
   SubscriptBox["x", "4"], ",", 
   SubscriptBox["x", "3"], ",", 
   SubscriptBox["x", "2"], ",", 
   SubscriptBox["x", "1"]}], "}"}]], "Output",
 ImageSize->{173, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->307907187]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27297],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 " always returns a list, even if it is just taking a single element:"
}], "ExampleText",
 CellID->8042],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}], ",", 
   RowBox[{"-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14464],

Cell[BoxData[
 RowBox[{"{", "e", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1541454557]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5532],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Span",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Span"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Part",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Part"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Drop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Drop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringTake",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringTake"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["First",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/First"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Last",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Last"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Most",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Most"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Complement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Complement"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Select",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Select"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TakeWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TakeWhile"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28856]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28970],

Cell[TextData[ButtonBox["Getting Pieces of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GettingPiecesOfLists"]], "Tutorials",
 CellID->14336],

Cell[TextData[ButtonBox["Manipulating Lists by Their Indices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingListsByTheirIndices"]], "Tutorials",\

 CellID->4795]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->295315936],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->220589870],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->8673790],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->774517645],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->461071585],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->155025205],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfExpressions"]], "MoreAbout",
 CellID->791034610],

Cell[TextData[ButtonBox["Parts of Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfMatrices"]], "MoreAbout",
 CellID->999378834],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->30514924],

Cell[TextData[ButtonBox["Structural Operations on Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StructuralOperationsOnExpressions"]], "MoreAbout",
 CellID->524282059]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Take"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Take - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 9.0347208}", "context" -> "System`", 
    "keywords" -> {
     "matrix blocks", "extraction of sublists", "element range", 
      "segments of lists", "sequence of elements", "stride", "submatrices", 
      "subsequence", "slice"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Take[list, n] gives the first n elements of list. Take[list, -n] gives \
the last n elements of list. Take[list, {m, n}] gives elements m through n of \
list. Take[list, seq_1, seq_2, ...] gives a nested list in which elements \
specified by seq_i are taken at level i in list. ", "synonyms" -> {}, "title" -> 
    "Take", "type" -> "Symbol", "uri" -> "ref/Take"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11728, 367, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->264146921]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 50806, 1884}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4206, 86, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4829, 113, 42, 1, 70, "ObjectName",
 CellID->29153],
Cell[4874, 116, 2692, 92, 70, "Usage",
 CellID->21184]
}, Open  ]],
Cell[CellGroupData[{
Cell[7603, 213, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8081, 230, 201, 7, 70, "Notes",
 CellID->19649],
Cell[8285, 239, 2090, 68, 70, "2ColumnTableMod",
 CellID->30350],
Cell[10378, 309, 334, 12, 70, "Notes",
 CellID->10405],
Cell[10715, 323, 494, 19, 70, "Notes",
 CellID->24346],
Cell[11212, 344, 479, 18, 70, "Notes",
 CellID->1025]
}, Closed]],
Cell[CellGroupData[{
Cell[11728, 367, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->264146921],
Cell[CellGroupData[{
Cell[12113, 381, 148, 5, 70, "ExampleSection",
 CellID->597052296],
Cell[12264, 388, 76, 1, 70, "ExampleText",
 CellID->5692],
Cell[CellGroupData[{
Cell[12365, 393, 212, 7, 28, "Input",
 CellID->14550],
Cell[12580, 402, 224, 7, 36, "Output",
 CellID->1296688030]
}, Open  ]],
Cell[12819, 412, 121, 3, 70, "ExampleDelimiter",
 CellID->13795],
Cell[12943, 417, 64, 1, 70, "ExampleText",
 CellID->13852],
Cell[CellGroupData[{
Cell[13032, 422, 231, 8, 70, "Input",
 CellID->17350],
Cell[13266, 432, 211, 7, 36, "Output",
 CellID->6668212]
}, Open  ]],
Cell[13492, 442, 121, 3, 70, "ExampleDelimiter",
 CellID->10036],
Cell[13616, 447, 65, 1, 70, "ExampleText",
 CellID->29361],
Cell[CellGroupData[{
Cell[13706, 452, 260, 9, 70, "Input",
 CellID->3760],
Cell[13969, 463, 214, 7, 36, "Output",
 CellID->1887482826]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14232, 476, 215, 7, 70, "ExampleSection",
 CellID->2534],
Cell[14450, 485, 90, 1, 70, "ExampleText",
 CellID->6050],
Cell[CellGroupData[{
Cell[14565, 490, 282, 10, 70, "Input",
 CellID->28082],
Cell[14850, 502, 223, 7, 36, "Output",
 CellID->689036923]
}, Open  ]],
Cell[15088, 512, 120, 3, 70, "ExampleDelimiter",
 CellID->1936],
Cell[15211, 517, 64, 1, 70, "ExampleText",
 CellID->25584],
Cell[CellGroupData[{
Cell[15300, 522, 292, 10, 70, "Input",
 CellID->10790],
Cell[15595, 534, 214, 7, 36, "Output",
 CellID->1745130544]
}, Open  ]],
Cell[15824, 544, 121, 3, 70, "ExampleDelimiter",
 CellID->29182],
Cell[15948, 549, 75, 1, 70, "ExampleText",
 CellID->19066],
Cell[CellGroupData[{
Cell[16048, 554, 379, 13, 70, "Input",
 CellID->23116],
Cell[16430, 569, 329, 11, 36, "Output",
 CellID->1218668537]
}, Open  ]],
Cell[16774, 583, 120, 3, 70, "ExampleDelimiter",
 CellID->9425],
Cell[16897, 588, 80, 1, 70, "ExampleText",
 CellID->13101],
Cell[CellGroupData[{
Cell[17002, 593, 391, 13, 70, "Input",
 CellID->5610],
Cell[17396, 608, 367, 13, 36, "Output",
 CellID->399080513]
}, Open  ]],
Cell[17778, 624, 121, 3, 70, "ExampleDelimiter",
 CellID->19982],
Cell[17902, 629, 84, 1, 70, "ExampleText",
 CellID->28621],
Cell[CellGroupData[{
Cell[18011, 634, 404, 13, 70, "Input",
 CellID->5193],
Cell[18418, 649, 254, 9, 36, "Output",
 CellID->2144831950]
}, Open  ]],
Cell[18687, 661, 121, 3, 70, "ExampleDelimiter",
 CellID->16754],
Cell[18811, 666, 55, 1, 70, "ExampleText",
 CellID->4593],
Cell[CellGroupData[{
Cell[18891, 671, 888, 25, 70, "Input",
 CellID->14895],
Cell[19782, 698, 767, 23, 78, "Output",
 CellID->2093820990]
}, Open  ]],
Cell[20564, 724, 120, 3, 70, "ExampleDelimiter",
 CellID->5638],
Cell[20687, 729, 71, 1, 70, "ExampleText",
 CellID->25167],
Cell[CellGroupData[{
Cell[20783, 734, 955, 28, 70, "Input",
 CellID->17420],
Cell[21741, 764, 766, 23, 78, "Output",
 CellID->792988290]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22556, 793, 239, 7, 70, "ExampleSection",
 CellID->16883],
Cell[22798, 802, 313, 12, 70, "ExampleText",
 CellID->23865],
Cell[CellGroupData[{
Cell[23136, 818, 187, 6, 70, "Input",
 CellID->24696],
Cell[23326, 826, 191, 6, 36, "Output",
 CellID->1632010629]
}, Open  ]],
Cell[CellGroupData[{
Cell[23554, 837, 299, 10, 70, "Input",
 CellID->10390],
Cell[23856, 849, 251, 9, 36, "Output",
 CellID->406441414]
}, Open  ]],
Cell[CellGroupData[{
Cell[24144, 863, 339, 12, 70, "Input",
 CellID->20189],
Cell[24486, 877, 275, 10, 36, "Output",
 CellID->1070082745]
}, Open  ]],
Cell[24776, 890, 121, 3, 70, "ExampleDelimiter",
 CellID->20183],
Cell[24900, 895, 316, 12, 70, "ExampleText",
 CellID->13817],
Cell[CellGroupData[{
Cell[25241, 911, 248, 8, 70, "Input",
 CellID->22129],
Cell[25492, 921, 454, 16, 36, "Output",
 CellID->1104885380]
}, Open  ]],
Cell[CellGroupData[{
Cell[25983, 942, 98, 3, 70, "Input",
 CellID->10679],
Cell[26084, 947, 259, 8, 36, "Output",
 CellID->460266342]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26392, 961, 222, 7, 70, "ExampleSection",
 CellID->8252],
Cell[26617, 970, 59, 1, 70, "ExampleText",
 CellID->15145],
Cell[CellGroupData[{
Cell[26701, 975, 263, 9, 70, "Input",
 CellID->19861],
Cell[26967, 986, 891, 21, 139, "Output",
 CellID->206748652]
}, Open  ]],
Cell[CellGroupData[{
Cell[27895, 1012, 485, 16, 70, "Input",
 CellID->28318],
Cell[28383, 1030, 668, 15, 70, "Output",
 Evaluatable->False,
 CellID->1033547516]
}, Open  ]],
Cell[29066, 1048, 120, 3, 70, "ExampleDelimiter",
 CellID->7813],
Cell[29189, 1053, 75, 1, 70, "ExampleText",
 CellID->14907],
Cell[CellGroupData[{
Cell[29289, 1058, 262, 9, 70, "Input",
 CellID->29554],
Cell[29554, 1069, 1127, 24, 116, "Output",
 CellID->406603684]
}, Open  ]],
Cell[CellGroupData[{
Cell[30718, 1098, 498, 16, 70, "Input",
 CellID->617],
Cell[31219, 1116, 646, 15, 70, "Output",
 Evaluatable->False,
 CellID->10974542]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31914, 1137, 233, 7, 70, "ExampleSection",
 CellID->25429],
Cell[32150, 1146, 304, 12, 70, "ExampleText",
 CellID->2264],
Cell[CellGroupData[{
Cell[32479, 1162, 319, 11, 70, "Input",
 CellID->15966],
Cell[32801, 1175, 203, 7, 36, "Output",
 CellID->186131723]
}, Open  ]],
Cell[CellGroupData[{
Cell[33041, 1187, 319, 11, 70, "Input",
 CellID->29942],
Cell[33363, 1200, 248, 8, 36, "Output",
 CellID->1019311687]
}, Open  ]],
Cell[33626, 1211, 121, 3, 70, "ExampleDelimiter",
 CellID->19522],
Cell[33750, 1216, 329, 12, 70, "ExampleText",
 CellID->31155],
Cell[CellGroupData[{
Cell[34104, 1232, 239, 8, 70, "Input",
 CellID->27587],
Cell[34346, 1242, 224, 7, 36, "Output",
 CellID->1427337609]
}, Open  ]],
Cell[CellGroupData[{
Cell[34607, 1254, 265, 9, 70, "Input",
 CellID->23158],
Cell[34875, 1265, 223, 7, 36, "Output",
 CellID->850189196]
}, Open  ]],
Cell[CellGroupData[{
Cell[35135, 1277, 298, 10, 70, "Input",
 CellID->13762],
Cell[35436, 1289, 214, 7, 36, "Output",
 CellID->2038389529]
}, Open  ]],
Cell[CellGroupData[{
Cell[35687, 1301, 300, 10, 70, "Input",
 CellID->30946],
Cell[35990, 1313, 213, 7, 36, "Output",
 CellID->221772666]
}, Open  ]],
Cell[36218, 1323, 124, 3, 70, "ExampleDelimiter",
 CellID->26486391],
Cell[36345, 1328, 437, 17, 70, "ExampleText",
 CellID->616149101],
Cell[CellGroupData[{
Cell[36807, 1349, 201, 7, 70, "Input",
 CellID->8214583],
Cell[37011, 1358, 415, 14, 36, "Output",
 CellID->455334019]
}, Open  ]],
Cell[CellGroupData[{
Cell[37463, 1377, 224, 8, 70, "Input",
 CellID->260653285],
Cell[37690, 1387, 316, 11, 36, "Output",
 CellID->466973423]
}, Open  ]],
Cell[CellGroupData[{
Cell[38043, 1403, 196, 7, 70, "Input",
 CellID->200440206],
Cell[38242, 1412, 316, 11, 36, "Output",
 CellID->218905030]
}, Open  ]],
Cell[38573, 1426, 120, 3, 70, "ExampleDelimiter",
 CellID->8380],
Cell[38696, 1431, 222, 7, 70, "ExampleText",
 CellID->13165],
Cell[CellGroupData[{
Cell[38943, 1442, 310, 10, 70, "Input",
 CellID->5946],
Cell[39256, 1454, 225, 7, 36, "Output",
 CellID->731756616]
}, Open  ]],
Cell[39496, 1464, 125, 3, 70, "ExampleDelimiter",
 CellID->120356863],
Cell[39624, 1469, 542, 21, 70, "ExampleText",
 CellID->171348414],
Cell[CellGroupData[{
Cell[40191, 1494, 203, 7, 70, "Input",
 CellID->104396140],
Cell[40397, 1503, 415, 14, 36, "Output",
 CellID->418722448]
}, Open  ]],
Cell[CellGroupData[{
Cell[40849, 1522, 102, 3, 70, "Input",
 CellID->90375369],
Cell[40954, 1527, 414, 14, 36, "Output",
 CellID->25977510]
}, Open  ]],
Cell[CellGroupData[{
Cell[41405, 1546, 224, 8, 70, "Input",
 CellID->171896880],
Cell[41632, 1556, 415, 14, 36, "Output",
 CellID->307907187]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[42096, 1576, 226, 7, 70, "ExampleSection",
 CellID->27297],
Cell[42325, 1585, 231, 7, 70, "ExampleText",
 CellID->8042],
Cell[CellGroupData[{
Cell[42581, 1596, 217, 7, 70, "Input",
 CellID->14464],
Cell[42801, 1605, 181, 6, 36, "Output",
 CellID->1541454557]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43043, 1618, 310, 9, 70, "SeeAlsoSection",
 CellID->5532],
Cell[43356, 1629, 2847, 107, 70, "SeeAlso",
 CellID->28856]
}, Open  ]],
Cell[CellGroupData[{
Cell[46240, 1741, 314, 9, 70, "TutorialsSection",
 CellID->28970],
Cell[46557, 1752, 154, 3, 70, "Tutorials",
 CellID->14336],
Cell[46714, 1757, 178, 4, 70, "Tutorials",
 CellID->4795]
}, Open  ]],
Cell[CellGroupData[{
Cell[46929, 1766, 319, 9, 70, "MoreAboutSection",
 CellID->295315936],
Cell[47251, 1777, 144, 3, 70, "MoreAbout",
 CellID->220589870],
Cell[47398, 1782, 153, 3, 70, "MoreAbout",
 CellID->8673790],
Cell[47554, 1787, 145, 3, 70, "MoreAbout",
 CellID->774517645],
Cell[47702, 1792, 145, 3, 70, "MoreAbout",
 CellID->461071585],
Cell[47850, 1797, 139, 3, 70, "MoreAbout",
 CellID->155025205],
Cell[47992, 1802, 150, 3, 70, "MoreAbout",
 CellID->791034610],
Cell[48145, 1807, 144, 3, 70, "MoreAbout",
 CellID->999378834],
Cell[48292, 1812, 176, 3, 70, "MoreAbout",
 CellID->30514924],
Cell[48471, 1817, 181, 3, 70, "MoreAbout",
 CellID->524282059]
}, Open  ]],
Cell[CellGroupData[{
Cell[48689, 1825, 305, 8, 70, "RelatedLinksSection"],
Cell[48997, 1835, 382, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[49394, 1851, 50, 0, 70, "History"],
Cell[49447, 1853, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

