(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     37748,       1314]
NotebookOptionsPosition[     30860,       1083]
NotebookOutlinePosition[     32402,       1124]
CellTagsIndexPosition[     32316,       1119]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"], 
          "Testing and Searching List Elements" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TestingAndSearchingListElements"], 
          "Finding Expressions That Match a Pattern" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FindingExpressionsThatMatchAPattern"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>", 
       2->"\<\"Testing and Searching List Elements\"\>", 
       3->"\<\"Finding Expressions That Match a Pattern\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BinCounts" :> Documentation`HelpLookup["paclet:ref/BinCounts"],
           "Count" :> Documentation`HelpLookup["paclet:ref/Count"], "Union" :> 
          Documentation`HelpLookup["paclet:ref/Union"], "Commonest" :> 
          Documentation`HelpLookup["paclet:ref/Commonest"], "Median" :> 
          Documentation`HelpLookup["paclet:ref/Median"], "Mean" :> 
          Documentation`HelpLookup["paclet:ref/Mean"], "Sort" :> 
          Documentation`HelpLookup["paclet:ref/Sort"], "SortBy" :> 
          Documentation`HelpLookup["paclet:ref/SortBy"], "Split" :> 
          Documentation`HelpLookup["paclet:ref/Split"], "ListPlot" :> 
          Documentation`HelpLookup["paclet:ref/ListPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"BinCounts\"\>", 2->"\<\"Count\"\>", 
       3->"\<\"Union\"\>", 4->"\<\"Commonest\"\>", 5->"\<\"Median\"\>", 
       6->"\<\"Mean\"\>", 7->"\<\"Sort\"\>", 8->"\<\"SortBy\"\>", 
       9->"\<\"Split\"\>", 10->"\<\"ListPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Exploratory Data Analysis" :> 
          Documentation`HelpLookup["paclet:guide/DataClassification"], 
          "Discrete & Integer Data" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteAndIntegerData"], 
          "Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60ListManipulation"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Numerical Data Handling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumericalDataHandling"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Exploratory Data Analysis\"\>", 
       2->"\<\"Discrete & Integer Data\"\>", 
       3->"\<\"Handling Arrays of Data\"\>", 4->"\<\"List Manipulation\"\>", 
       5->"\<\"Math & Counting Operations on Lists\"\>", 
       6->"\<\"Numerical Data\"\>", 7->"\<\"New in 6.0: Core Language\"\>", 
       8->"\<\"New in 6.0: List Manipulation\"\>", 
       9->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       10->"\<\"New in 6.0: Numerical Data Handling\"\>", 
       11->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Tally", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Tally",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Tally"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]tallies the elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ", listing all distinct elements together with their multiplicities."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Tally",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Tally"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["test", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " to determine whether pairs of elements should be considered \
equivalent, and gives a list of the first representatives of each equivalence \
class, together with their multiplicities."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tally",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tally"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " lists distinct elements in the order they appear in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->273233071],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tally",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tally"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tally",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tally"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    ButtonBox["SameQ",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SameQ"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->779170446]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->209757303],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->598344682],

Cell["Obtain tallies for a list of symbols:", "ExampleText",
 CellID->574880558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tally", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "a", ",", "b", ",", "a", ",", "c", ",", "b", ",", "a"}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->464657293],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85616368]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114749295],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  StyleBox["test", "TI"]], "InlineFormula"],
 " argument to count expressions with the same ",
 Cell[BoxData[
  ButtonBox["Head",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Head"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->170890653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tally", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"w", ",", "x", ",", "y", ",", "z"}], "}"}], ",", "E", ",", 
     RowBox[{"{", 
      RowBox[{"w", ",", "x", ",", "y", ",", "z"}], "}"}], ",", "E"}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Head", "[", "#1", "]"}], "===", 
     RowBox[{"Head", "[", "#2", "]"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->250597990],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[ExponentialE]", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91042647]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["\<\
Results are returned in order of first occurrence in the list:\
\>", "ExampleText",
 CellID->34066073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tally", "[", 
  RowBox[{"{", 
   RowBox[{"b", ",", "a", ",", "b", ",", "a", ",", "c", ",", "b", ",", "a"}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213633702],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->122352912]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->228578053],

Cell["Count the instances of randomly generated integers:", "ExampleText",
 CellID->68018316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tally", "[", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"10", ",", "50"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->84636390],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"7", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"8", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{568, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->142284917]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->803721621],

Cell["Elements of the list can be any expression:", "ExampleText",
 CellID->721476597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tally", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", "x", ",", "y", ",", "z"}], "}"}], ",", "E", ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", "x", ",", "y", ",", "z"}], "}"}], ",", "E"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->250795593],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"w", ",", "x", ",", "y", ",", "z"}], "}"}], ",", "2"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\[ExponentialE]", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{259, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->223736628]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Count occurrences of characters in a string:", "ExampleText",
 CellID->41902944],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "s", "=", 
   "\"\<Tally[list] lists distinct elements in the order they appear in list.\
\>\""}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91372003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tally", "[", 
  RowBox[{"Characters", "[", "s", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->471855767],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"T\"\>", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"l\"\>", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"y\"\>", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"[\"\>", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"i\"\>", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"s\"\>", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"t\"\>", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"]\"\>", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\" \"\>", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"d\"\>", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"n\"\>", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"c\"\>", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"e\"\>", ",", "7"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"m\"\>", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"h\"\>", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"o\"\>", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"r\"\>", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"p\"\>", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\".\"\>", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{518, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->614394420]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "Elements with highest frequencies are given by ",
 Cell[BoxData[
  ButtonBox["Commonest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Commonest"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->768115720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tally", "[", 
  RowBox[{"{", 
   RowBox[{
   "b", ",", "a", ",", "c", ",", "b", ",", "a", ",", "c", ",", "b", ",", 
    "a"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22606003],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->284131849]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Commonest", "[", 
  RowBox[{"{", 
   RowBox[{
   "b", ",", "a", ",", "c", ",", "b", ",", "a", ",", "c", ",", "b", ",", 
    "a"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->520457037],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "a"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->87749655]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->325374220],

Cell[TextData[{
 "A sorted ",
 Cell[BoxData[
  ButtonBox["Tally",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tally"]], "InlineFormula"],
 " is equivalent to a list of counts for the ",
 Cell[BoxData[
  ButtonBox["Union",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Union"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->93092053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sort", "[", 
  RowBox[{"Tally", "[", 
   RowBox[{"{", 
    RowBox[{
    "b", ",", "a", ",", "c", ",", "b", ",", "a", ",", "c", ",", "b", ",", 
     "a"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->389191685],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->358678]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"Count", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "b", ",", "a", ",", "c", ",", "b", ",", "a", ",", "c", ",", "b", ",",
           "a"}], "}"}], ",", "#"}], "]"}]}], "}"}], "&"}], ",", 
   RowBox[{"Union", "[", 
    RowBox[{"{", 
     RowBox[{
     "b", ",", "a", ",", "c", ",", "b", ",", "a", ",", "c", ",", "b", ",", 
      "a"}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->544521982],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->53417325]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->366390438],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tally",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tally"]], "InlineFormula"],
 " is a discrete analog of ",
 Cell[BoxData[
  ButtonBox["BinCounts",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BinCounts"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->433455849],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->455628415],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.732381562642413`", ",", "2.671015158595569`", ",", "5.440289184634675`", 
   ",", "9.754754663681934`", ",", "3.0942465355122772`", ",", 
   "1.4787924302637556`", ",", "8.027574449862808`", ",", 
   "4.444098828898038`", ",", "2.0181830637205933`", ",", 
   "4.329616647182226`", ",", "3.967523847827892`", ",", 
   "0.08218373553222857`", ",", "3.2725012658211305`", ",", 
   "1.374653363112639`", ",", "1.4557365469999684`", ",", 
   "8.129550307332229`", ",", "0.08251173802477307`", ",", 
   "2.1674542149010967`", ",", "4.7462850622103225`", ",", 
   "0.7907170086256254`"}], "}"}]], "Output",
 ImageSize->{450, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->513362354]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Tally", "[", 
   RowBox[{"Ceiling", "[", "data", "]"}], "]"}], "//", "Sort"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24012137],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"9", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{417, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->220850843]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BinCounts", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->431523480],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "2", ",", "0", ",", "0", 
   ",", "2", ",", "1"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->37307902]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinCounts",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinCounts"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Count",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Count"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Union",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Union"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Commonest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Commonest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Median",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Median"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SortBy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SortBy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Split",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Split"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->127750864],

Cell[TextData[ButtonBox["Testing and Searching List Elements",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TestingAndSearchingListElements"]], "Tutorials",\

 CellID->32655],

Cell[TextData[ButtonBox["Finding Expressions That Match a Pattern",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FindingExpressionsThatMatchAPattern"]], "Tutorials",
 CellID->3815]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Tally",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Tally"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->276706779],

Cell[TextData[ButtonBox["Exploratory Data Analysis",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataClassification"]], "MoreAbout",
 CellID->46129247],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "MoreAbout",
 CellID->184208446],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->8245084],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->369504396],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->586998330],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->105328697],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->85352714],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->246783444],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->333762177],

Cell[TextData[ButtonBox["New in 6.0: Numerical Data Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NumericalDataHandling"]], "MoreAbout",
 CellID->145705747],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->145089255]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Tally - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 14.6754902}", "context" -> "System`", 
    "keywords" -> {
     "census", "equivalence class counting", "frequencies", "gather", 
      "multiplicities", "tally"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Tally[list] tallies the elements in list, listing all distinct elements \
together with their multiplicities. Tally[list, test] uses test to determine \
whether pairs of elements should be considered equivalent, and gives a list \
of the first representatives of each equivalence class, together with their \
multiplicities.", "synonyms" -> {}, "title" -> "Tally", "type" -> "Symbol", 
    "uri" -> "ref/Tally"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9592, 258, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->209757303]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 32173, 1112}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4796, 97, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[5419, 124, 1570, 37, 70, "ObjectNameGrid"],
Cell[6992, 163, 1191, 34, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[8220, 202, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8698, 219, 338, 12, 70, "Notes",
 CellID->273233071],
Cell[9039, 233, 516, 20, 70, "Notes",
 CellID->779170446]
}, Closed]],
Cell[CellGroupData[{
Cell[9592, 258, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->209757303],
Cell[CellGroupData[{
Cell[9977, 272, 148, 5, 70, "ExampleSection",
 CellID->598344682],
Cell[10128, 279, 80, 1, 70, "ExampleText",
 CellID->574880558],
Cell[CellGroupData[{
Cell[10233, 284, 202, 6, 28, "Input",
 CellID->464657293],
Cell[10438, 292, 360, 13, 36, "Output",
 CellID->85616368]
}, Open  ]],
Cell[10813, 308, 125, 3, 70, "ExampleDelimiter",
 CellID->114749295],
Cell[10941, 313, 289, 11, 70, "ExampleText",
 CellID->170890653],
Cell[CellGroupData[{
Cell[11255, 328, 522, 17, 70, "Input",
 CellID->250597990],
Cell[11780, 347, 368, 13, 36, "Output",
 CellID->91042647]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12197, 366, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[12421, 375, 112, 3, 70, "ExampleText",
 CellID->34066073],
Cell[CellGroupData[{
Cell[12558, 382, 202, 6, 70, "Input",
 CellID->213633702],
Cell[12763, 390, 361, 13, 36, "Output",
 CellID->122352912]
}, Open  ]],
Cell[13139, 406, 125, 3, 70, "ExampleDelimiter",
 CellID->228578053],
Cell[13267, 411, 93, 1, 70, "ExampleText",
 CellID->68018316],
Cell[CellGroupData[{
Cell[13385, 416, 166, 5, 70, "Input",
 CellID->84636390],
Cell[13554, 423, 834, 29, 36, "Output",
 CellID->142284917]
}, Open  ]],
Cell[14403, 455, 125, 3, 70, "ExampleDelimiter",
 CellID->803721621],
Cell[14531, 460, 86, 1, 70, "ExampleText",
 CellID->721476597],
Cell[CellGroupData[{
Cell[14642, 465, 374, 12, 70, "Input",
 CellID->250795593],
Cell[15019, 479, 505, 18, 36, "Output",
 CellID->223736628]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15573, 503, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[15803, 512, 86, 1, 70, "ExampleText",
 CellID->41902944],
Cell[15892, 515, 194, 7, 70, "Input",
 CellID->91372003],
Cell[CellGroupData[{
Cell[16111, 526, 138, 4, 70, "Input",
 CellID->471855767],
Cell[16252, 532, 1525, 47, 54, "Output",
 CellID->614394420]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17826, 585, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[18067, 594, 232, 8, 70, "ExampleText",
 CellID->768115720],
Cell[CellGroupData[{
Cell[18324, 606, 216, 7, 70, "Input",
 CellID->22606003],
Cell[18543, 615, 361, 13, 36, "Output",
 CellID->284131849]
}, Open  ]],
Cell[CellGroupData[{
Cell[18941, 633, 221, 7, 70, "Input",
 CellID->520457037],
Cell[19165, 642, 202, 7, 36, "Output",
 CellID->87749655]
}, Open  ]],
Cell[19382, 652, 125, 3, 70, "ExampleDelimiter",
 CellID->325374220],
Cell[19510, 657, 346, 13, 70, "ExampleText",
 CellID->93092053],
Cell[CellGroupData[{
Cell[19881, 674, 252, 8, 70, "Input",
 CellID->389191685],
Cell[20136, 684, 358, 13, 36, "Output",
 CellID->358678]
}, Open  ]],
Cell[CellGroupData[{
Cell[20531, 702, 553, 18, 70, "Input",
 CellID->544521982],
Cell[21087, 722, 360, 13, 36, "Output",
 CellID->53417325]
}, Open  ]],
Cell[21462, 738, 125, 3, 70, "ExampleDelimiter",
 CellID->366390438],
Cell[21590, 743, 323, 12, 70, "ExampleText",
 CellID->433455849],
Cell[CellGroupData[{
Cell[21938, 759, 158, 5, 70, "Input",
 CellID->455628415],
Cell[22099, 766, 775, 17, 71, "Output",
 CellID->513362354]
}, Open  ]],
Cell[CellGroupData[{
Cell[22911, 788, 165, 5, 70, "Input",
 CellID->24012137],
Cell[23079, 795, 657, 23, 36, "Output",
 CellID->220850843]
}, Open  ]],
Cell[CellGroupData[{
Cell[23773, 823, 181, 6, 70, "Input",
 CellID->431523480],
Cell[23957, 831, 290, 9, 36, "Output",
 CellID->37307902]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24308, 847, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[24627, 858, 2377, 89, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[27041, 952, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[27362, 963, 202, 4, 70, "Tutorials",
 CellID->127750864],
Cell[27567, 969, 179, 4, 70, "Tutorials",
 CellID->32655],
Cell[27749, 975, 188, 4, 70, "Tutorials",
 CellID->3815]
}, Open  ]],
Cell[CellGroupData[{
Cell[27974, 984, 305, 8, 70, "RelatedLinksSection"],
Cell[28282, 994, 355, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28674, 1011, 319, 9, 70, "MoreAboutSection",
 CellID->276706779],
Cell[28996, 1022, 154, 3, 70, "MoreAbout",
 CellID->46129247],
Cell[29153, 1027, 157, 3, 70, "MoreAbout",
 CellID->184208446],
Cell[29313, 1032, 153, 3, 70, "MoreAbout",
 CellID->8245084],
Cell[29469, 1037, 145, 3, 70, "MoreAbout",
 CellID->369504396],
Cell[29617, 1042, 190, 4, 70, "MoreAbout",
 CellID->586998330],
Cell[29810, 1048, 139, 3, 70, "MoreAbout",
 CellID->105328697],
Cell[29952, 1053, 155, 3, 70, "MoreAbout",
 CellID->85352714],
Cell[30110, 1058, 164, 3, 70, "MoreAbout",
 CellID->246783444],
Cell[30277, 1063, 179, 3, 70, "MoreAbout",
 CellID->333762177],
Cell[30459, 1068, 175, 3, 70, "MoreAbout",
 CellID->145705747],
Cell[30637, 1073, 151, 3, 70, "MoreAbout",
 CellID->145089255]
}, Open  ]],
Cell[30803, 1079, 27, 0, 70, "History"],
Cell[30833, 1081, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

