(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     53097,       2010]
NotebookOptionsPosition[     41462,       1595]
NotebookOutlinePosition[     42878,       1635]
CellTagsIndexPosition[     42792,       1630]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{StringJoin["Generating and Importing ", 
            RowBox[{"T", 
              AdjustmentBox[
              "E", BoxBaselineShift -> 0.5, 
               BoxMargins -> {{-0.3, 0}, {0, 0}}], "X"}]] :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GeneratingAndImportingTeX"], 
          "Forms of Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FormsOfInputAndOutput"]}, #, 2]& , Evaluator -> 
        Automatic], {1->
       RowBox[{"\<\"Generating and Importing \"\>", "<>", 
        RowBox[{"RowBox", "[", 
         RowBox[{"{", 
          RowBox[{"\<\"T\"\>", ",", 
           RowBox[{"AdjustmentBox", "[", 
            RowBox[{"\<\"E\"\>", ",", 
             RowBox[{"BoxBaselineShift", "\[Rule]", "0.5`"}], ",", 
             RowBox[{"BoxMargins", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.3`"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], "]"}], 
           ",", "\<\"X\"\>"}], "}"}], "]"}]}], 
       2->"\<\"Forms of Input and Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Export" :> Documentation`HelpLookup["paclet:ref/Export"], 
          "StandardForm" :> 
          Documentation`HelpLookup["paclet:ref/StandardForm"], 
          "TraditionalForm" :> 
          Documentation`HelpLookup["paclet:ref/TraditionalForm"], 
          "MathMLForm" :> 
          Documentation`HelpLookup["paclet:ref/MathMLForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Export\"\>", 
       2->"\<\"StandardForm\"\>", 3->"\<\"TraditionalForm\"\>", 
       4->"\<\"MathMLForm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Converting between Expressions & Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/ConvertingBetweenExpressionsAndStrings"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Converting between Expressions & Strings\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TeXForm", "ObjectName",
 CellID->15535],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TeXForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TeXForm"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints as a ",
     Cell[BoxData[
      FormBox[
       StyleBox[
        RowBox[{"T", 
         AdjustmentBox["E",
          BoxBaselineShift->0.5,
          BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
        SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
     " version of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15835]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TeXForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TeXForm"]], "InlineFormula"],
 " produces AMS-",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"L", 
     StyleBox[
      AdjustmentBox["A",
       BoxBaselineShift->-0.4,
       BoxMargins->{{-0.5, -0.3}, {0, 0}}],
      FontSize->Smaller], "T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 "\[Hyphen]compatible ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " output. "
}], "Notes",
 CellID->1229],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TeXForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TeXForm"]], "InlineFormula"],
 " acts as a \"wrapper\", which affects printing, but not evaluation. "
}], "Notes",
 CellID->3716],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TeXForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TeXForm"]], "InlineFormula"],
 " translates standard mathematical functions and operations. "
}], "Notes",
 CellID->23532],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["TeXForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TeXForm"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TeXForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TeXForm"], "[", 
   RowBox[{
    ButtonBox["TraditionalForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TraditionalForm"], "[", 
    StyleBox["expr", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TeXForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TeXForm"], "[", 
   RowBox[{
    ButtonBox["StandardForm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/StandardForm"], "[", 
    StyleBox["expr", "TI"], "]"}], "]"}]], "InlineFormula"],
 " can be used to get ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " output.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->365832752]
}], "Notes",
 CellID->24956],

Cell[TextData[{
 "Symbols with names like ",
 Cell[BoxData["alpha"], "InlineFormula"],
 " and ",
 Cell[BoxData["ALPHA"], "InlineFormula"],
 " that correspond to ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " symbols are translated into their corresponding ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " symbols. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->6245600]
}], "Notes",
 CellID->16158],

Cell["\<\
Following standard mathematical conventions, single\[Hyphen]character symbol \
names are given in italic font, while multiple character names are given in \
roman font. \
\>", "Notes",
 CellID->29749],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " special characters are translated whenever possible to their ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " equivalents. "
}], "Notes",
 CellID->24620]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->26826204],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->251916848],

Cell["A polynomial:", "ExampleText",
 CellID->551017233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{"a", "+", 
   RowBox[{"b", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->608693877],

Cell["b^2+a", "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TeXForm=",
 CellID->153270661]
}, Open  ]],

Cell["A typeset expression:", "ExampleText",
 CellID->134753518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  FractionBox["x", 
   SqrtBox["5"]], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->119828017],

Cell["\\frac{x}{\\sqrt{5}}", "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TeXForm=",
 CellID->249427527]
}, Open  ]],

Cell["A special character:", "ExampleText",
 CellID->240295346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", "\[Alpha]", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->173846565],

Cell["\\alpha", "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TeXForm=",
 CellID->504659270]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16870141],

Cell["Subscripts and superscripts:", "ExampleText",
 CellID->57125783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["x", "a"], ",", 
    SuperscriptBox["x", "a"], ",", 
    SubsuperscriptBox["x", "a", "b"]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->565115585],

Cell[GraphicsData["CompressedBitmap", "\<\
eJydVM0OgjAMLmzDPwRvGi9y1/gYevIhiDHBg9GoCY+PhRRdug5Rkq37uvbr
9jXjkD+L0yV/no95tr/nt+J8fGS76x1dKgCAEke6AFxXuGpGWVVodT2rGjcf
zBleMbxlWDUsinlHOEUIaxuizcjOyL9k8eGHRb+9lBOSHaM14NYyLC72xEUe
vhFZ4z8T937OSDxg7FPjutG1rjJw4uPO+GFP/omXxb1DyLxtLZkjod2puJt2
5spermwgKqus/mnrHAnhlO3/osC/XZw6cVqMU14l+1SRs1s9ePdE3OPtKLqP
7bfVajulLO15vmHx2qoKIPVa1n/DsPhXYW/XZeW9Xn9hbW8zkKpB6ZkheAF5
HKld\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->299205591]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["x", 
     RowBox[{
      RowBox[{"2", "k"}], "+", "1"}]], ",", 
    SuperscriptBox["x", 
     RowBox[{
      RowBox[{"2", "k"}], "+", "1"}]]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->483858205],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVtuOgjAQLa31kqyut000++KTlx9xn/wIYkz0wWhcf4gvxQ6CNoeBQoWE
0ikz55zOjMVdeD8ezuH9tA8Xf7fwejzt/xfby80sqUAIEZn7eybMPDaz5I7i
2DxbNCqyk0v8gL0EG/1/wV45/FXCqmC1Z4a2MduwvmaipTGRdeNglW/W1ms1
xZLpc8DEaPHMEL1/gmYXKtWWd5kS/RFrx5PV2j+uvvNBLcJ5aDtjpELn4lAX
2pw+mcU1oqDroSCfIVmgE1VhtN0NWXfognrZdt8Tv1MRH3GCmOuD7Fc1dEQT
uvLI9aAmfq+RWtbvdjZ7H/V5P4eQcPD9XEtJM/1e70TEM8/OMO2iSo2/gEMD
BnJU4Rz5773ky1dy8lheYwfXDGyMr8Yy8dqh69tOXiplozxOmJrQdO6oCeJM
C3D4/wJRwSiCByHqkzI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3817898]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->108948280],

Cell["Overscripts and underscripts:", "ExampleText",
 CellID->403952748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    OverscriptBox["x", "a"], ",", 
    UnderscriptBox["x", "a"]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->374065107],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVV01LxDAQTZPWD1TUk16EvXvx6kEQBD0J/oWyCLsHUdb98z3FTDZZktcp
TbaV7Rba9DXJ67yZyZC81+vF51e9Xs7r2duq/lks57+z1++V+aQKIURj7stb
Yd61ebN3o7VpS3oqwvYSL4BPMzHyfYzMp6zVCr4eA34EfNYzHvuJXxp4Ad+f
B/KiGpmkhmYRrBgrSwOJpXIt4TJoaTjyKTee/W+5xc4H0rVoO2JOK81zIbMX
dW8m+gttn4aWtLjY/ir8hwBLENsJSSySm9UadcTZ3RqF6lCHjH3FZJqP5Tln
e8jkLef1pKk8QN+0cwdt5Nb08NyBLGfWR1rOIm9X/JHtKknVmBmxb8UY7UJz
lQJzL9cvXEXzFbCr4p0wun3l7POPZNbL9UAN01WWVu3ZDBmk39uT48k+X/xX
VcOV3a1+W/MjvqjnoD2xW7ZQzimnhd/1qMAP0R5Jb7Jb6XhVcNnN7Qrzdj5c
BQ/HB3YHDKHN3ifT0LNbtB4AY27l7vPRqzeA70b+H6+aPTsF+Alw7tmMU0kx
uR/Iy5/5mo6nKP4AUd7UoA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{249, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->323966559]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->180162020],

Cell["List structures: ", "ExampleText",
 CellID->156464972],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->138594298],

Cell["\\{a,b,c\\}", "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TeXForm=",
 CellID->212733864]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", "c", "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->33066165],

Cell["\\{\\{a,b\\},\\{c\\}\\}", "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TeXForm=",
 CellID->1345452]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->368587115],

Cell["A matrix:", "ExampleText",
 CellID->127098374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->575346611],

Cell["\<\
\\left(
\\begin{array}{lll}
 a & b & c \\\\
 d & e & f
\\end{array}
\\right)\
\>", "Output",
 ImageSize->{126, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TeXForm=",
 CellID->595471787]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->252255214],

Cell["Algebra and logic operations:", "ExampleText",
 CellID->175264391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "y"}], ")"}], "^", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46308276],

Cell["x^3+3 y x^2+3 y^2 x+y^3", "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TeXForm=",
 CellID->75973006]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{"LogicalExpand", "[", 
   RowBox[{"Xor", "[", 
    RowBox[{"x", ",", "y"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2133304],

Cell["(x\\land \\neg y)\\lor (y\\land \\neg x)", "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TeXForm=",
 CellID->1165244]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{"ForAll", "[", 
   RowBox[{"x", ",", 
    RowBox[{"a", "\[Element]", "Reals"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"a", " ", "x"}], "+", "1"}], ">", "0"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->580610188],

Cell["\\forall _{x,a\\in \\mathbb{R}}x^2+a x+1>0", "Output",
 ImageSize->{273, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TeXForm=",
 CellID->6245184]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->87359442],

Cell["Calculus operations:", "ExampleText",
 CellID->56634825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12736060],

Cell["\\int f(x) \\, dx", "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TeXForm=",
 CellID->149028270]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"f", "[", "n", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "m"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->629161125],

Cell["\\sum _{n=1}^m f(n)", "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TeXForm=",
 CellID->452569990]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"x", "\[Rule]", "\[Infinity]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->153791026],

Cell["\\lim_{x\\to \\infty } \\, f(x)", "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TeXForm=",
 CellID->56555783]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->625409541],

Cell["Elementary functions: ", "ExampleText",
 CellID->521762288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", "x", "]"}], ",", 
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"1", "/", "3"}], ")"}]}], ",", 
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"ArcSin", "[", "x", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->200424509],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WNtOwzAMTZNujA0YF4GQQGgPSPDGI38AT3wCk6oJaXtAoLH/L0mXjHLq
1O4FKm2ps9g+PnZue8k2y7f3bLNaZLPndfa5XC2+Zk8fa9tlEqWSV6XU9FLZ
99y+FR/3zO1HqdR9m9CXqwv75cRz6N8HGfWuvd6JbbVtJ74dN7TzAPIeyAOQ
H0E+ARn9c/Z0wYphtI5APgN5ArLxbBwydo4ZO4gj5gft3giyQOG7Y+IcMXaR
3UTErvs9VdvadK3LycDLblgxPt2N99i1b7GiUKY4q/OG+sb3Y2zdUB1EUBmP
ZusuPGHw8E+YqPeJNTou8dUfH/JKUYOyD+V9VHvRVkqOGsIo/TsKIu9h7lAZ
7BcbjqJtkXloFRGuBnRE6I9G1R6FjFcZCtwd0HY/3FXrWDN2RxW7dJRYnWgn
cIb9OGfb+sNoydlS83sMH+YF9xW0K6uxsBsiin68Iadh1USOOM5iKJ2ePb4V
FUSvhpSGieaSXGNqWJCy181r04qS5vg0gpI87/VWSc28dF2NYqhkeylZp/R+
VY7E51QTUZLzqHa1xDnUHUNsFyFPa42wUrmW7UOaiIGskB64kvqXnX7+a3/k
atPhCidTvQuzeEKP2fXsTvDNTqDIbzufaFW0nokxYg0GjG68KWMtIRs18hBj
gfXgdZSqrp6iKur5poAVdAUyrlV4F0IeUF+2wnPzBb1ifmcg4/2aG990Pre7
z1M35LJ8z1hFrm/zn8wb30r+S0I2powf7hSK+iij/jin95p2/0G517ngTSXf
3PaSUw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{349, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->366019550]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55622482],

Cell["Special functions:", "ExampleText",
 CellID->561341585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Zeta", "[", "s", "]"}], ",", 
    RowBox[{"Erf", "[", "x", "]"}], ",", 
    RowBox[{"HypergeometricPFQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["a", "1"], ",", 
        SubscriptBox["a", "2"]}], "}"}], ",", 
      RowBox[{"{", 
       SubscriptBox["b", "1"], "}"}], ",", "x"}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->386270131],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWNtu00AQ3XjtJNDG6Q0oQpRUKhJ94oVvgCc+IipI7QMqKv1m+hnBa89U
k+NZzzjtA5YSe/Yyl7Nndsf+vr6//vlrfX9ztV59u1v/vr65+rP6envXNMVJ
CJO/IYTlaWieN81T+0vXQ/MLoUz/kds24TPIM5ArkL+A/AbklyP1nYD8A+S3
IN82f0k8NPTGNtpoePMR5BcgJ7SKRlxA+4Xh5dypt8607zX3aXN/RfcDw+85
jdun+Ushy3F1pv0Y5NcgLw20Cxfaqb8K3bgydFyMJKf2qaI1jUNryOE9xbso
7BAZ2qsghNi25mNJ4ypxR5vtvPJRJq1S+5DHiD9GeExWOZKaZAtR6W0uuor4
lYtK9keKh9sX0D6FuOc9VDgK6WUXLl/sQiSfLez8XAuV9IRXv4f7DEbRWLSg
cr5nQfO+UDKuHLA83UaRtfZsafky5DH6hv2IYdHzQ9Oo7Y8VtZ+4/MbdxToz
XHH60OqNyu3IM3X0vto6PCdnob/qeGpg3HjK6BHprXp+IOf13EM/rPWyMkn3
BbVabHdVBApHrSywvEeM0E+U5d4p249Afm/4hVlj2R27O/jYhWxeqKNwf6jd
ugolD3BFnpwHA6igPGnn4SwP9pViLWFeKlznsxCtezguz2fs15DK+TXmpPBy
+mwAp7Qau3Da4z/GzZUIMq7OtOus/h/56quWVJZvnT2+88G3c/sqJXzH0fbN
DEr9Wmk02rmMeXqNhDm7UixEhfsuy6NP8Ofc1dFj+bbAbwWyX6uB9coHY+WR
VkUk30X0yDTNu+UL7zsxhK19N8m5/cbiPOqVsfA99x7IfhSPNOiu53mDRRaf
D+CoccNzgkgkrUhRf73RvwtxPDLaDhfUwBzjupBn5uo3iTHnMM/tJrVX90Dt
HN1u77jWtzNkE2YLYmOd1shiq/qwvnqpFa7+nmZWkBaf8DskIoy+IZZnLi8Q
cfwa+s7w2qqzOh7gKOTFpYEFrtsnpZ9zbwhD1Ivr+YH0pBWUXyORZ3w+LGg8
onhE/efUz3XVId1PjVWYC/1WtdwJD46nMPkHiZ9YQg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{486, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34267656]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35647839],

Cell["Named symbols are translated:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->6245600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "/@", 
  RowBox[{"{", 
   RowBox[{"gamma", ",", "GAMMA", ",", "Pi", ",", "E", ",", "I"}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->349366008],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFVstOwzAQdGwnFYK2QEDiGAlOXOCKxBlOfERUIbUHBCr9yPxV8DrrEE0W
7FalRIo3O9mXx14nL/Vm+fpWb1aLunpe1x/L1eKzenpfO8hkSqnG3fMr5Z5b
9+Tvpm2dtDQa0v2lpm4g9RrwB9DP2e4U8HlENz6rAXQS0Ss3aKdOAb9lfCZl
gSo0V0vyDN7rpKqIK6s6u9JJ8sqdLMDuWPAj1Ub8ToRZhHxkL7Fk1XgNC7ZH
PG2W/n3e696nq/l3tB8T0O8IE14Rae6HrwL3l1wF8hq8kcmC8SPA5XXRkXWx
B2Xk4l+zXyZlRx7xLMIuz0HPWqkfsCvl3KE3t5lr8BG5He46jrBr/N3ZIyM8
sdNOEeQWdf2Hu6WM5I7v3f30COXt54mM4T4dRdsP7+HM4Q+tCtWbgexCBxcz
sPbBGJNmh/r2UaW9ifUG25LljCV2Zhoj+OeSi+zfg9WjmGvUqZFc4Qt9Bziu
9U0kbkdO88Oosi/jdQo8\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->335701312]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->367433106],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TeXForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TeXForm"]], "InlineFormula"],
 " gives the ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " representation of the ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " expression:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->365832752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{"Sin", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30605428],

Cell["\\sin (x)", "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TeXForm=",
 CellID->449563814]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{"TraditionalForm", "[", 
   RowBox[{"Sin", "[", "x", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->707070715],

Cell["\\sin (x)", "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TeXForm=",
 CellID->169100946]
}, Closed]],

Cell[TextData[{
 "Obtain the ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " representation of the expression in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->293218551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{"StandardForm", "[", 
   RowBox[{"Sin", "[", "x", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7709919],

Cell["\\text{Sin}[x]", "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TeXForm=",
 CellID->505901341]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->39604561],

Cell[TextData[{
 "Convert an expression to ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->109257368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"TeXForm", "[", 
   RowBox[{
    RowBox[{"1.2", " ", "x"}], "+", 
    RowBox[{"Exp", "[", "y", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->278890626],

Cell["1.2 x+e^y", "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TeXForm=",
 CellID->10009504]
}, Closed]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " to convert ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " back to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " syntax:"
}], "ExampleText",
 CellID->932274959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{
   RowBox[{"ToString", "[", "t", "]"}], ",", "TeXForm"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->326710173],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["e", "y"], "+", 
  RowBox[{"1.2`", " ", "x"}]}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->740533165]
}, Closed]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " to convert from ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ":"
}], "ExampleText",
 CellID->119463757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{"\"\<$\\sin^{-1}(x)$\>\"", ",", "TeXForm"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->821159700],

Cell[BoxData[
 RowBox[{"ArcSin", "[", "x", "]"}]], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->225193433]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->44371432],

Cell["The following expression will evaluate: ", "ExampleText",
 CellID->358083311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"n", "^", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "m"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57458041],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", "m", " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "m"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "m"}]}], ")"}]}]], "Output",
 ImageSize->{123, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->750182243]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{"Sum", "[", 
   RowBox[{
    RowBox[{"n", "^", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "1", ",", "m"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->293980104],

Cell["\\frac{1}{6} m (m+1) (2 m+1)", "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TeXForm=",
 CellID->677793192]
}, Closed]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 " to convert unevaluated expressions:"
}], "ExampleText",
 CellID->250150815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{"HoldForm", "[", 
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"n", "^", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "1", ",", "m"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->104963323],

Cell["\\sum _{n=1}^m n^2", "Output",
 ImageSize->{119, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TeXForm=",
 CellID->414727517]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->415489966],

Cell[TextData[{
 "Add formatting via ",
 Cell[BoxData[
  ButtonBox["Format",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Format"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->328627372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"bin", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "//", "TeXForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->161343839],

Cell["\\text{bin}(x,y)", "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->301702421]
}, Closed]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Format", "[", 
   RowBox[{
    RowBox[{"bin", "[", 
     RowBox[{"x_", ",", "y_"}], "]"}], ",", "TeXForm"}], "]"}], ":=", 
  RowBox[{"MatrixForm", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{"{", "y", "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->734130829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"bin", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "//", "TeXForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->88224750],

Cell["\<\
\\left(
\\begin{array}{l}
 x \\\\
 y
\\end{array}
\\right)\
\>", "Output",
 ImageSize->{112, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->269211882]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->129436154],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 " to generate a compilable ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " document:"
}], "ExampleText",
 CellID->114376251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExportString", "[", 
  RowBox[{
   RowBox[{"TraditionalForm", "[", 
    RowBox[{"Sin", "[", "x", "]"}], "]"}], ",", "\"\<TeX\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->339259066],

Cell[BoxData["\<\"\\n\\n%% AMS-LaTeX Created by Wolfram Mathematica 6.0\\n\\n\
\\\\documentclass{article}\\n\\\\usepackage{amsmath, amssymb, graphics}\\n\\n\
\\\\newcommand{\\\\mathsym}[1]{{}}\\n\\\\newcommand{\\\\unicode}{{}}\\n\\n\\\\\
begin{document}\\n\\n\\\\[\\\\sin \
(x)\\\\]\\n\\n\\n\\\\end{document}\\n\"\>"], "Output",
 ImageSize->{333, 288},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174455238]
}, Closed]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->165547780],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Splice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Splice"]], "InlineFormula"],
 " can be used to convert expressions in a file: "
}], "ExampleText",
 CellID->27675464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "^", "5"}], ",", " ", "x"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->329129734],

Cell["\<\
-\\frac{5 \\cos (x)}{8}+\\frac{5}{48} \\cos (3 x)-\\frac{1}{80} \\cos (5 x)\
\>", "Output",
 ImageSize->{483, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21530045]
}, Closed]],

Cell[TextData[{
 "The following ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " file contains the unevaluated integral:"
}], "ExampleText",
 CellID->502544694],

Cell[BoxData[
 RowBox[{
  RowBox[{"ifile", "=", 
   RowBox[{"ToFileName", "[", 
    RowBox[{"\"\<ExampleData\>\"", ",", "\"\<splicefile.mtex\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->89605992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "ifile", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->641697745],

Cell["\<\
\\text {The result of the integration is 
<*Integrate[Sin[x]^5, x]*>}\
\>", "Print",
 CellID->140218826]
}, Closed]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Splice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Splice"]], "InlineFormula"],
 " inserts the result of the integral:"
}], "ExampleText",
 CellID->145376619],

Cell[BoxData[
 RowBox[{
  RowBox[{"ofile", "=", 
   RowBox[{"ToFileName", "[", 
    RowBox[{"$TemporaryPrefix", ",", "\"\<spliceoutput.tex\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->13622565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Splice", "[", 
  RowBox[{"ifile", ",", "ofile"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->499700900],

Cell[BoxData["\<\"ExampleData\\\\splicefile.mtex\"\>"], "Output",
 ImageSize->{193, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->124702780]
}, Closed]],

Cell["This is the resulting output file:", "ExampleText",
 CellID->69975171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "ofile", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->40053897],

Cell["\<\
\\text {The result of the integration is 
-\\frac{5 \\cos (x)}{8}+\\frac{5}{48} \\cos (3 x)-\\frac{1}{80} \\cos (5 x)}\
\>", "Print",
 CellID->763760447]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14852],

Cell["A continued fraction:", "ExampleText",
 CellID->304390454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"1", "/", "#"}]}], "&"}], ",", "x", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134577312],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox["1", 
   RowBox[{"1", "+", 
    FractionBox["1", 
     RowBox[{"1", "+", 
      FractionBox["1", 
       RowBox[{"1", "+", 
        FractionBox["1", 
         RowBox[{"1", "+", 
          FractionBox["1", "x"]}]]}]]}]]}]]}]], "Output",
 ImageSize->{96, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->782348770]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TeXForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->690698542],

Cell["\<\
1+\\frac{1}{1+\\frac{1}{1+\\frac{1}{1+\\frac{1}{1+\\frac{1}{x}}}}}\
\>", "Output",
 ImageSize->{427, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TeXForm=",
 CellID->59091373]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8983],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Export",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Export"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StandardForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StandardForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraditionalForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraditionalForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathMLForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathMLForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3445]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23296],

Cell[TextData[{
 ButtonBox["Generating and Importing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GeneratingAndImportingTeX"],
 Cell[BoxData[
  FormBox[
   StyleBox[
    ButtonBox[
     RowBox[{"T", 
      AdjustmentBox["E",
       BoxBaselineShift->0.5,
       BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}],
     BaseStyle->"Link",
     ButtonData->"paclet:tutorial/GeneratingAndImportingTeX"], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"]
}], "Tutorials",
 CellID->19724],

Cell[TextData[ButtonBox["Forms of Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormsOfInputAndOutput"]], "Tutorials",
 CellID->13120]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->1208755],

Cell[TextData[ButtonBox["Converting between Expressions & Strings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConvertingBetweenExpressionsAndStrings"]], "MoreAbout",
 CellID->26078429]
}, Open  ]],

Cell["New in 1  |  Last modified in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TeXForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 19.1287292}", "context" -> "System`", 
    "keywords" -> {
     "AMSLaTeX", "formula display", "formula markup", "LaTeX", 
      "mathematical markup", "mathematical typesetting", "output in TeX form",
       "scientific typesetting", "technical typesetting", "tex form", 
      "TeX output"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TeXForm[expr] prints as a T E X version of expr. ", 
    "synonyms" -> {"te form"}, "title" -> "TeXForm", "type" -> "Symbol", 
    "uri" -> "ref/TeXForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9277, 313, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->26826204]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 42650, 1623}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3164, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3787, 105, 45, 1, 70, "ObjectName",
 CellID->15535],
Cell[3835, 108, 820, 27, 70, "Usage",
 CellID->15835]
}, Open  ]],
Cell[CellGroupData[{
Cell[4692, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5170, 157, 830, 30, 70, "Notes",
 CellID->1229],
Cell[6003, 189, 232, 7, 70, "Notes",
 CellID->3716],
Cell[6238, 198, 225, 7, 70, "Notes",
 CellID->23532],
Cell[6466, 207, 1333, 48, 70, "Notes",
 CellID->24956],
Cell[7802, 257, 811, 28, 70, "Notes",
 CellID->16158],
Cell[8616, 287, 210, 5, 70, "Notes",
 CellID->29749],
Cell[8829, 294, 411, 14, 70, "Notes",
 CellID->24620]
}, Closed]],
Cell[CellGroupData[{
Cell[9277, 313, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->26826204],
Cell[CellGroupData[{
Cell[9661, 327, 148, 5, 70, "ExampleSection",
 CellID->251916848],
Cell[9812, 334, 56, 1, 70, "ExampleText",
 CellID->551017233],
Cell[CellGroupData[{
Cell[9893, 339, 150, 5, 28, "Input",
 CellID->608693877],
Cell[10046, 346, 162, 5, 50, "Output",
 CellID->153270661]
}, Open  ]],
Cell[10223, 354, 64, 1, 70, "ExampleText",
 CellID->134753518],
Cell[CellGroupData[{
Cell[10312, 359, 137, 5, 46, "Input",
 CellID->119828017],
Cell[10452, 366, 178, 5, 50, "Output",
 CellID->249427527]
}, Open  ]],
Cell[10645, 374, 63, 1, 70, "ExampleText",
 CellID->240295346],
Cell[CellGroupData[{
Cell[10733, 379, 110, 3, 70, "Input",
 CellID->173846565],
Cell[10846, 384, 164, 5, 50, "Output",
 CellID->504659270]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11059, 395, 219, 7, 70, "ExampleSection",
 CellID->16870141],
Cell[11281, 404, 70, 1, 70, "ExampleText",
 CellID->57125783],
Cell[CellGroupData[{
Cell[11376, 409, 240, 8, 70, "Input",
 CellID->565115585],
Cell[11619, 419, 582, 14, 70, "Output",
 Evaluatable->False,
 CellID->299205591]
}, Closed]],
Cell[CellGroupData[{
Cell[12238, 438, 292, 11, 70, "Input",
 CellID->483858205],
Cell[12533, 451, 657, 15, 70, "Output",
 Evaluatable->False,
 CellID->3817898]
}, Closed]],
Cell[13205, 469, 125, 3, 70, "ExampleDelimiter",
 CellID->108948280],
Cell[13333, 474, 72, 1, 70, "ExampleText",
 CellID->403952748],
Cell[CellGroupData[{
Cell[13430, 479, 197, 7, 70, "Input",
 CellID->374065107],
Cell[13630, 488, 785, 17, 70, "Output",
 Evaluatable->False,
 CellID->323966559]
}, Closed]],
Cell[14430, 508, 125, 3, 70, "ExampleDelimiter",
 CellID->180162020],
Cell[14558, 513, 60, 1, 70, "ExampleText",
 CellID->156464972],
Cell[CellGroupData[{
Cell[14643, 518, 160, 5, 70, "Input",
 CellID->138594298],
Cell[14806, 525, 168, 5, 49, "Output",
 CellID->212733864]
}, Closed]],
Cell[CellGroupData[{
Cell[15011, 535, 225, 8, 70, "Input",
 CellID->33066165],
Cell[15239, 545, 179, 5, 49, "Output",
 CellID->1345452]
}, Closed]],
Cell[15433, 553, 125, 3, 70, "ExampleDelimiter",
 CellID->368587115],
Cell[15561, 558, 52, 1, 70, "ExampleText",
 CellID->127098374],
Cell[CellGroupData[{
Cell[15638, 563, 272, 9, 70, "Input",
 CellID->575346611],
Cell[15913, 574, 242, 12, 129, "Output",
 CellID->595471787]
}, Closed]],
Cell[16170, 589, 125, 3, 70, "ExampleDelimiter",
 CellID->252255214],
Cell[16298, 594, 72, 1, 70, "ExampleText",
 CellID->175264391],
Cell[CellGroupData[{
Cell[16395, 599, 210, 7, 70, "Input",
 CellID->46308276],
Cell[16608, 608, 180, 5, 49, "Output",
 CellID->75973006]
}, Closed]],
Cell[CellGroupData[{
Cell[16825, 618, 197, 6, 70, "Input",
 CellID->2133304],
Cell[17025, 626, 196, 5, 49, "Output",
 CellID->1165244]
}, Closed]],
Cell[CellGroupData[{
Cell[17258, 636, 326, 11, 70, "Input",
 CellID->580610188],
Cell[17587, 649, 198, 5, 49, "Output",
 CellID->6245184]
}, Closed]],
Cell[17800, 657, 124, 3, 70, "ExampleDelimiter",
 CellID->87359442],
Cell[17927, 662, 62, 1, 70, "ExampleText",
 CellID->56634825],
Cell[CellGroupData[{
Cell[18014, 667, 192, 6, 70, "Input",
 CellID->12736060],
Cell[18209, 675, 175, 5, 49, "Output",
 CellID->149028270]
}, Closed]],
Cell[CellGroupData[{
Cell[18421, 685, 248, 8, 70, "Input",
 CellID->629161125],
Cell[18672, 695, 177, 5, 49, "Output",
 CellID->452569990]
}, Closed]],
Cell[CellGroupData[{
Cell[18886, 705, 230, 7, 70, "Input",
 CellID->153791026],
Cell[19119, 714, 188, 5, 49, "Output",
 CellID->56555783]
}, Closed]],
Cell[19322, 722, 125, 3, 70, "ExampleDelimiter",
 CellID->625409541],
Cell[19450, 727, 65, 1, 70, "ExampleText",
 CellID->521762288],
Cell[CellGroupData[{
Cell[19540, 732, 344, 11, 70, "Input",
 CellID->200424509],
Cell[19887, 745, 1013, 21, 70, "Output",
 Evaluatable->False,
 CellID->366019550]
}, Closed]],
Cell[20915, 769, 124, 3, 70, "ExampleDelimiter",
 CellID->55622482],
Cell[21042, 774, 61, 1, 70, "ExampleText",
 CellID->561341585],
Cell[CellGroupData[{
Cell[21128, 779, 468, 15, 70, "Input",
 CellID->386270131],
Cell[21599, 796, 1292, 25, 70, "Output",
 Evaluatable->False,
 CellID->34267656]
}, Closed]],
Cell[22906, 824, 124, 3, 70, "ExampleDelimiter",
 CellID->35647839],
Cell[23033, 829, 118, 2, 70, "ExampleText",
 CellID->6245600],
Cell[CellGroupData[{
Cell[23176, 835, 189, 6, 70, "Input",
 CellID->349366008],
Cell[23368, 843, 720, 16, 70, "Output",
 Evaluatable->False,
 CellID->335701312]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[24137, 865, 243, 7, 70, "ExampleSection",
 CellID->367433106],
Cell[24383, 874, 645, 22, 70, "ExampleText",
 CellID->365832752],
Cell[CellGroupData[{
Cell[25053, 900, 132, 4, 70, "Input",
 CellID->30605428],
Cell[25188, 906, 166, 5, 49, "Output",
 CellID->449563814]
}, Closed]],
Cell[CellGroupData[{
Cell[25391, 916, 176, 5, 70, "Input",
 CellID->707070715],
Cell[25570, 923, 166, 5, 49, "Output",
 CellID->169100946]
}, Closed]],
Cell[25751, 931, 477, 17, 70, "ExampleText",
 CellID->293218551],
Cell[CellGroupData[{
Cell[26253, 952, 171, 5, 70, "Input",
 CellID->7709919],
Cell[26427, 959, 171, 5, 49, "Output",
 CellID->505901341]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[26647, 970, 236, 7, 70, "ExampleSection",
 CellID->39604561],
Cell[26886, 979, 322, 12, 70, "ExampleText",
 CellID->109257368],
Cell[CellGroupData[{
Cell[27233, 995, 209, 7, 70, "Input",
 CellID->278890626],
Cell[27445, 1004, 165, 5, 49, "Output",
 CellID->10009504]
}, Closed]],
Cell[27625, 1012, 515, 20, 70, "ExampleText",
 CellID->932274959],
Cell[CellGroupData[{
Cell[28165, 1036, 173, 5, 70, "Input",
 CellID->326710173],
Cell[28341, 1043, 230, 8, 35, "Output",
 CellID->740533165]
}, Closed]],
Cell[28586, 1054, 508, 20, 70, "ExampleText",
 CellID->119463757],
Cell[CellGroupData[{
Cell[29119, 1078, 159, 4, 70, "Input",
 CellID->821159700],
Cell[29281, 1084, 190, 6, 35, "Output",
 CellID->225193433]
}, Closed]],
Cell[29486, 1093, 124, 3, 70, "ExampleDelimiter",
 CellID->44371432],
Cell[29613, 1098, 83, 1, 70, "ExampleText",
 CellID->358083311],
Cell[CellGroupData[{
Cell[29721, 1103, 204, 7, 70, "Input",
 CellID->57458041],
Cell[29928, 1112, 341, 12, 50, "Output",
 CellID->750182243]
}, Closed]],
Cell[CellGroupData[{
Cell[30306, 1129, 243, 8, 70, "Input",
 CellID->293980104],
Cell[30552, 1139, 186, 5, 49, "Output",
 CellID->677793192]
}, Closed]],
Cell[30753, 1147, 222, 8, 70, "ExampleText",
 CellID->250150815],
Cell[CellGroupData[{
Cell[31000, 1159, 286, 10, 70, "Input",
 CellID->104963323],
Cell[31289, 1171, 176, 5, 49, "Output",
 CellID->414727517]
}, Closed]],
Cell[31480, 1179, 125, 3, 70, "ExampleDelimiter",
 CellID->415489966],
Cell[31608, 1184, 198, 8, 70, "ExampleText",
 CellID->328627372],
Cell[CellGroupData[{
Cell[31831, 1196, 153, 5, 70, "Input",
 CellID->161343839],
Cell[31987, 1203, 165, 5, 35, "Output",
 CellID->301702421]
}, Closed]],
Cell[32167, 1211, 354, 12, 70, "Input",
 CellID->734130829],
Cell[CellGroupData[{
Cell[32546, 1227, 152, 5, 70, "Input",
 CellID->88224750],
Cell[32701, 1234, 215, 12, 115, "Output",
 CellID->269211882]
}, Closed]],
Cell[32931, 1249, 125, 3, 70, "ExampleDelimiter",
 CellID->129436154],
Cell[33059, 1254, 456, 17, 70, "ExampleText",
 CellID->114376251],
Cell[CellGroupData[{
Cell[33540, 1275, 219, 7, 70, "Input",
 CellID->339259066],
Cell[33762, 1284, 460, 9, 308, "Output",
 CellID->174455238]
}, Closed]],
Cell[34237, 1296, 125, 3, 70, "ExampleDelimiter",
 CellID->165547780],
Cell[34365, 1301, 219, 7, 70, "ExampleText",
 CellID->27675464],
Cell[CellGroupData[{
Cell[34609, 1312, 229, 8, 70, "Input",
 CellID->329129734],
Cell[34841, 1322, 231, 7, 35, "Output",
 CellID->21530045]
}, Closed]],
Cell[35087, 1332, 350, 12, 70, "ExampleText",
 CellID->502544694],
Cell[35440, 1346, 219, 7, 70, "Input",
 CellID->89605992],
Cell[CellGroupData[{
Cell[35684, 1357, 109, 3, 70, "Input",
 CellID->641697745],
Cell[35796, 1362, 114, 4, 70, "Print",
 CellID->140218826]
}, Closed]],
Cell[35925, 1369, 209, 7, 70, "ExampleText",
 CellID->145376619],
Cell[36137, 1378, 217, 7, 70, "Input",
 CellID->13622565],
Cell[CellGroupData[{
Cell[36379, 1389, 133, 4, 70, "Input",
 CellID->499700900],
Cell[36515, 1395, 196, 5, 35, "Output",
 CellID->124702780]
}, Closed]],
Cell[36726, 1403, 76, 1, 70, "ExampleText",
 CellID->69975171],
Cell[CellGroupData[{
Cell[36827, 1408, 108, 3, 70, "Input",
 CellID->40053897],
Cell[36938, 1413, 163, 4, 70, "Print",
 CellID->763760447]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[37150, 1423, 224, 7, 70, "ExampleSection",
 CellID->14852],
Cell[37377, 1432, 64, 1, 70, "ExampleText",
 CellID->304390454],
Cell[CellGroupData[{
Cell[37466, 1437, 203, 7, 70, "Input",
 CellID->134577312],
Cell[37672, 1446, 413, 15, 86, "Output",
 CellID->782348770]
}, Closed]],
Cell[CellGroupData[{
Cell[38122, 1466, 103, 3, 70, "Input",
 CellID->690698542],
Cell[38228, 1471, 231, 7, 49, "Output",
 CellID->59091373]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[38520, 1485, 310, 9, 70, "SeeAlsoSection",
 CellID->8983],
Cell[38833, 1496, 962, 35, 70, "SeeAlso",
 CellID->3445]
}, Open  ]],
Cell[CellGroupData[{
Cell[39832, 1536, 314, 9, 70, "TutorialsSection",
 CellID->23296],
Cell[40149, 1547, 507, 16, 70, "Tutorials",
 CellID->19724],
Cell[40659, 1565, 157, 3, 70, "Tutorials",
 CellID->13120]
}, Open  ]],
Cell[CellGroupData[{
Cell[40853, 1573, 317, 9, 70, "MoreAboutSection",
 CellID->1208755],
Cell[41173, 1584, 192, 4, 70, "MoreAbout",
 CellID->26078429]
}, Open  ]],
Cell[41380, 1591, 52, 0, 70, "History"],
Cell[41435, 1593, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

