(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     87199,       2404]
NotebookOptionsPosition[     79279,       2129]
NotebookOutlinePosition[     80662,       2167]
CellTagsIndexPosition[     80576,       2162]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Graphics Directives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsDirectives"], 
          "The Structure of Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Three\[Hyphen]Dimensional Graphics Directives\"\>", 
       2->"\<\"The Structure of Graphics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Thick" :> Documentation`HelpLookup["paclet:ref/Thick"], "Thin" :> 
          Documentation`HelpLookup["paclet:ref/Thin"], "AbsoluteThickness" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteThickness"], 
          "PointSize" :> Documentation`HelpLookup["paclet:ref/PointSize"], 
          "Dashing" :> Documentation`HelpLookup["paclet:ref/Dashing"], 
          "PlotStyle" :> Documentation`HelpLookup["paclet:ref/PlotStyle"], 
          "PlotRangeClipping" :> 
          Documentation`HelpLookup["paclet:ref/PlotRangeClipping"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Thick\"\>", 2->"\<\"Thin\"\>", 
       3->"\<\"AbsoluteThickness\"\>", 4->"\<\"PointSize\"\>", 
       5->"\<\"Dashing\"\>", 6->"\<\"PlotStyle\"\>", 
       7->"\<\"PlotRangeClipping\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicGraphicsLanguage"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graphics Directives\"\>", 
       2->"\<\"Symbolic Graphics Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Thickness", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Thickness",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Thickness"], "[", 
       StyleBox["r", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a graphics directive which specifies that lines \
which follow are to be drawn with thickness ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     ". The thickness ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " is given as a fraction of the total width of the graphic. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19074]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 " can be used in both two\[Hyphen] and three\[Hyphen]dimensional graphics, \
as well as in ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " specifications. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->13759],

Cell[TextData[{
 "The following symbolic forms for ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " can be used: ",
 Cell[BoxData[
  ButtonBox["Tiny",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tiny"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Small",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Small"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Medium",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Medium"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Large",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Large"]], "InlineFormula"],
 ". These specify absolute thicknesses independent of the total width of the \
graphic. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->5850]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->121177974],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->381362522],

Cell["\<\
Specify the thickness of lines as a fraction of the total width of the \
graphic: \
\>", "ExampleText",
 CellID->25232105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "r", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.02", ",", "0.05"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128720659],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Thickness[0.01], LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[0.02], LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[0.05], LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]}]}], 
  "}"}]], "Output",
 ImageSize->{341, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->473364419]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->171757471],

Cell["Set the thickness of edges of polygons:", "ExampleText",
 CellID->539791327],

Cell[BoxData[
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"Sqrt", "[", "3", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28799232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", 
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Thickness", "[", "r", "]"}], "]"}], ",", "p2"}], "}"}], "]"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.02", ",", "0.05"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->60688723],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[0.01]], 
     PolygonBox[
      NCache[{{-1, 0}, {0, 3^Rational[1, 2]}, {1, 0}}, {{-1, 0}, {
        0, 1.7320508075688772`}, {1, 0}}]]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[0.02]], 
     PolygonBox[
      NCache[{{-1, 0}, {0, 3^Rational[1, 2]}, {1, 0}}, {{-1, 0}, {
        0, 1.7320508075688772`}, {1, 0}}]]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[0.05]], 
     PolygonBox[
      NCache[{{-1, 0}, {0, 3^Rational[1, 2]}, {1, 0}}, {{-1, 0}, {
        0, 1.7320508075688772`}, {1, 0}}]]}]}], "}"}]], "Output",
 ImageSize->{341, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->646240168]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->229206653],

Cell[TextData[{
 "Set the thicknesses of lines in plots using ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->44384296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "0.01", "]"}], ",", 
      RowBox[{"Thickness", "[", "0.02", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->558754509],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->446413357]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16461],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Thickness Specifications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->205528226],

Cell["Symbolic values for predefined absolute thicknesses: ", "ExampleText",
 CellID->278831735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "r", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10693766],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Thickness[Tiny], LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[Small], LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[Medium], LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[Large], LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]}]}], 
  "}"}]], "Output",
 ImageSize->{452, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->523774125]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Primitives Affected",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1325779],

Cell["Specify thickness of curve primitives:", "ExampleText",
 CellID->131972316],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "r", "]"}], ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.02", ",", "0.05"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74558811],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Thickness[0.01], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {Thickness[0.02], CircleBox[{0, 0}]}], ",", 
   GraphicsBox[
    {Thickness[0.05], CircleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->296240231]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "r", "]"}], ",", 
      RowBox[{"Arrowheads", "[", ".2", "]"}], ",", 
      RowBox[{"Arrow", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.02", ",", "0.05"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->126355687],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Thickness[0.01], Arrowheads[0.2], ArrowBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[0.02], Arrowheads[0.2], ArrowBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[0.05], Arrowheads[0.2], ArrowBox[{{0, 0}, {2, 1}}]}]}], 
  "}"}]], "Output",
 ImageSize->{341, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->889490797]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "r", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "3", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "4", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.02", ",", "0.05"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->118997887],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {Thickness[0.01], 
     Line3DBox[{{1, 1, 0}, {2, 2, 1}, {3, 3, 0}, {4, 4, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVmNtO20AQhje2c4AESICQNIQkDaVQKIdCoQepqtSL9qp9hwgiwUXVivL6
Vuud/dex/zVeipTYm5n9dmZ2Zzzm++zhdv5z9nB3PZt8u5/9vr27/jP5+us+
+SmsKKVuks+Pvkru/yZ38rmJ41ipL8l3OJ/PxzL6jFGQXIPkOpJfP2FU1SMt
Tq7Jt9oR6UfMqRdK30G6rEeRkRqFocgvwV7Ro2oqB2NbdM7BWCvROQNnPWOF
vg1o3BftYxA3SRrSuCfah9DuPUn7AJYMSBrReEu098De8bCN9i7YEw+7K9oT
sKckrdJYoqBGYO89SXsb7H2S1mi8Idp9aB+StE5j2T3xVVty/CTtDbBPSdqg
cUe0O2Cfk3SJxm3RXgX7ArOahVotSC/iRfaUseUcy68hLNFXjhzPWpVZNZrF
WsWzoozXoc22klkid87gKWZ3PLNbMluiEC3qgck6bUXXs1PufIMIlMmuolxk
G5oLhlMxNOcFONsezvKC80hVSWBppo09nhXTwoynSv5sdnHmFu62w4scXg+8
lx5ew8wITaBim3M5ls03zmX21WU18juaCHX+6BNx4mHVHdYSZprgmb8mLDvz
eFlzaE3HyzpYbz2WuayW42UI1nsPq+qwOE/17ZGmJWq+HI5Ay2d1SDF7peOo
zBkKCqhso0ttYiecHFF4uimFp0Jyk5lTtkrorNKA7RKjXEZrL6ZYZwletDz8
wOFX40w9jbJ8zRtlohPgpP0fP4gzldfhD2B/h+LEe1pHrPPxkZpm67LD7uHa
xXW5INbpqcC5M/YX1eqALOzA8j7oWYsFmnxxd1JJ6fZJH2L2GmhDWsXuDscZ
JPq1WxiHFq7SO0UpG2R+1nHXY1ZiLV90avBnai0ySTfPd8t2vUoy1OuYtQp7
upK1bAyncaaHRyUrX4l9LVpJk7J1Q0cxSv3I7xTXi/xqNez51iOrjGG/3S/u
i0KHyKeCu3pLbD9CDBwi5x0TB/C+W7AH5WTOPiZvwdYBbJVTkKt3ku3CspWX
92sdjFEpw9jD9X6DxivwdFcY2ayxJcP6Z7rlMpbteA/ixTMn3+EZzloBR/tp
e9/X2fmZWmNmt0sibCvSG9q3IF3bvh9s4npl10o12Cvuhu2MRVx4j9nCK/hl
tHk3ORrn2BHzJLYVlLVOoGW6sD5J+fl4FC9yTqlnJOWn3T7Y5j2G33P5hO9C
27wJ+vrtMbTNu/QQ3rHWMM507/J0LnsH7YNp/pvBPTpXrE1oS81WvjftNrSl
s1bPScr1oAVt6Z2lUqdP84I8ka5Y3lTyWVIHRU6x9Fi58w3ppUi1XTr1P8hI
Vf4Bbt9NcQ==\
\>"]], ",", 
   Graphics3DBox[
    {Thickness[0.02], 
     Line3DBox[{{1, 1, 0}, {2, 2, 1}, {3, 3, 0}, {4, 4, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyNmNtuEzEQhjd7SNIkNGmbpuk5tLSFnugBEKqEkBCCK3iHqIrUXiBQ6euv
YGf8e7P5bcWplGRnZ/yN7fGM7f4YPz9Mfo2fH+/Ho+9P4z8Pj/d/R99+PxWv
kloURZPi83MYFc//iif9fM3zPEomk0muf9GefEVfim95OVLpM6S4+I2L3319
+wlSViEU3yDcoU3Dq/2Iti2R0tJ78bCr+vdo3REpK/Vg7KjNDWy6c2yu4GeV
RhmTvKnWFyCuB6yHan0G9nAh69dgb5E2IXlDrY/B3iVtSvJArQ/B3l/IegTr
A9JmJOssaLykJ0ekrZPcV+ttsE8Wst4E+5S0DZLX1HoA9jlpmyRrrNWDsN8u
ZL0C9jVpl0heUetlWN/CR4esemrVgfY2n2bPPLZptQRru7p55riVrn6dsbjS
qhVotayt0sqo5ffFwq3iaJpbK4FWSjXrXDI9sn/n8NoPtNfZNVk1UymSgnEC
xsbiDKdSCMdm0HaA055yOONnxraf+zOSeS0vr6wJoMlsb4F4SLa8nv3EFLGS
sdo8Og70bclLqjtjXcv9Wcw9MzwdnHlp3sywuujbRYDVdFjliq/MWQu0q8BI
Gw6tXbGwtDpo7wJ9c2kdDy0G7Y3qihdozbWE6XWH/oLoCWKRFc+c0UzLHNoy
opkiu5pRFOyTS2ljdLrwSkObadKzFHKInYI9ayEi71dCG4EuMZARtAP0xKFn
oPMaEdoO6G30nem8b7l0G3WNy7SagTcEvwuZq7it8rNzItNs63CMfUZar4O2
irngESU2RpW4mR4LZeCZXfFQtxUExMz2h+uhUrgup1iTma1olbzi/tVyX/1Z
985cC8xdyHae+XTFu6nxwVZ+H3X4eGm1ZdXiuPPKNF54lvxeEnixpzQbTfbB
NOMjwxoYOOxmZVeqV0YUZrJn3q9tD+WkKC4lFhJnJz+9dM5Ipts+9+CFqbw+
DJXXElPtObUPqncFO1TOR6YOMANDzACPWKi1QhSaIbYRL75xrKJ/e/l0Vbgn
F5NnXOPtfmz30oMqY+YEZdovB0bVxKiOMSoNQRWDfnQDHHvaPEd/KntD2Zee
Zz60RGEX13aoV1PPfLtbI/kWLePSD1swQe6fMVqYSPFo+NRrb6yGz/HskXyN
OTU75wCjZqvLvFIZI75nctxPwTRn3U3S8l51Amtz6+BbKa/0Q1hPb3nl7Z1y
1a5/U4vn7Y47GJ25qe+RlmvTEGzzvwc+V3NV6MNaT8taS+fVuR6s9daq9b3c
ZWm+RTxTKyU7GdkG6VJtXuWccQ3ob1R/VPEwwUYs2g+qlXwTB3cqRbX/Ei79
Dg==\
\>"]], ",", 
   Graphics3DBox[
    {Thickness[0.05], 
     Line3DBox[{{1, 1, 0}, {2, 2, 1}, {3, 3, 0}, {4, 4, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyNl9tuEzEQhp3Nbs6HHtND0ja0tNBCC7SAAAkhcQFX8A5RFam9QKDS11+B
Z/y7cf51s4m02Z2dmc/jtcce/5jc30x/Te5vryfj73eTPze313/H337f2VfV
ijFmaq+f28Y+/7NPek3zPDfmq/1Pp9PpgUpf7H/VSom9Jw9vP0PKRBK1vdt/
s6/aT/Cpi5Q6rTPYU/0HeLfJ22nfwbtb8B6p/greKyJlD3owhmrzGoy1BTbn
sNkMopDHhORttX6BVrdJWyV5S62fg727lPUJ2HukTUkeqPUR2AekzUjWfpkn
YB8uZb0P9lPS1kjeUOshrJ8tZb2DSM5IWyd5Xa0HYL8kbYNkHWFtQdivlrJe
BfsNaZskr6p1H+wreLXJSueh6UB7mc/yZRHbeTXJi78ce/XVq46IvFerxKun
XmnQVuLzq9RLZmzNzLJlpcSr++Clb437pfY6BWGjhNCJEjJ7HYPAOcij7Ag8
Ag1LGIMwLImhPSPMViD7E8Yoj+cfM1rRKBJQfDYclfQlTqmCsolYjktiaUYp
GSgroJyWUBpRSg0UnwHnJT1yFO2Ce6ntCKGRx/OSCfUCoQWCn+PyPWTOca5y
j2oFkvSiLq+sfIJnpnA8RUoX7csIJ/Yu62l7CVJWIPXQI5n/spb37Z3znSlp
gdIGxb+TjJKe7VlxzZj4SC8k+rF62EeQpzXM7a6BffC+rBWY0/cQsRlpZYBW
JLYmZs8ielKgJ6D3MHtk5+kgTpF5Z/LrblokTVFrUIw9xNh5hFilcZl9hbnK
JCC2QexHiGLJVZk8VgqjN4iQ6yBvgCzmsvjxd3Q0XgVisaYgboEosXEFxDue
o7NVWKMJfd246kOo3Nt471OM3YBIK8GK7leQRTWYo0UrnIDaNbPqKA2+ZzmZ
Z0hht7Sk3WBkYmSWHZnHkck+c8OMiO07FSsK0VE5p5maBNS1R6hJgdrCaG3i
voUeD0DgfJn37pTE5Ou/kadl4R6vWaQcrpCY0wVn7DlzpxXH6JUwGuiZ7BD1
Rxi+AuWTit/tTr0v8m/Wg1XyWOfxtI8XuavwQm/3Hdci3r7urCGfnSVz2VM8
sjmP2JiE8luVXTh+XXOefk6wh6+Gq36GudMVV7SBfJEHK5zhqpJH/wzWrrrc
IS3PuRNYuzp/FzGz1SGs3AlpRFrOrYM8qH/daXnBfjcE251290nL64zPMHe+
LztbbsBaq1etqmP7js8zPR8aPoHyKtAFU8+Hesot5mUbNhdqo6fUuXypQ3+p
en9e8HnyXt9KNAL+qJKp/Ac2+1xk\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->302333360]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7178458],

Cell[TextData[{
 "Specify the thickness of edges of primitives using ",
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->246606596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", 
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Thickness", "[", "r", "]"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.02", ",", "0.05"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33396395],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[0.01]], DiskBox[{0, 0}]}], ",",
    
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[0.02]], DiskBox[{0, 0}]}], ",",
    
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[0.05]], DiskBox[{0, 0}]}]}], 
  "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->566752795]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", 
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Thickness", "[", "r", "]"}], "]"}], ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.02", ",", "0.05"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->336961838],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[0.01]], RectangleBox[{0, 0}]}],
    ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[0.02]], RectangleBox[{0, 0}]}],
    ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[0.05]], 
     RectangleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->49500087]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->76292278],

Cell[BoxData[
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->130811177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", 
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Thickness", "[", "r", "]"}], "]"}], ",", "p3"}], "}"}], "]"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.02", ",", "0.05"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->155389808],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[0.01]], 
     Polygon3DBox[{{1, 0, 0}, {0, 0, 1}, {1, 1, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytmWlv20YQhmleknVbPiRbsqzYUVzHSd0zCXoC+dAUKIL+gn4wUgEJ0KJF
GqA/viDandlZkno50kqqBJvSkjPPOzu7XO4uX99/eDv//f7Duzf301fv7/98
++7NX9Mf/nhvTkV7QRD8av5/Gwbm97/mF/+/zLIsiObzecaf4IIOwffmmJiT
Uy59a46hKUXybc9+ZY7kGFMpNiwLMUfLeCHWKZUSc/2fX/7OTUTnmdjU6NuY
BEluJHYTtvtctOpiFxqzgAI0vwvbc7b9VJhNKqVW1/5Z+xBqPGKvO/Fq8dXc
K4icUuY+RBmzzxOJqg0+MTvm0VUUT9n7sSh2wTtZy/tatHuSkRp4ReA1ZK+Z
aPbFq+686Nt8dK8r8TqCSGvgHYP3gL2nEukxeKN2At4n7D0R7QF473OirbcF
oLr1H4n6EPwbFX/U53g526R/Jhlrrek3EL+R+LVdP8p7o1ZnzjAf6eQ5xNxS
GSkwDpnRF/0LYLQX4zd/oRKHZfSy0v1eYnRKLUc/+W6M8lux0hJ9prWlVg+A
1vXQMLYDpjUltiug9YAWeWKztH2hPZTW6nsoGFOPKXWhzCAmpPlqWNDcWbqv
saaHG8bYLahxeYjF9jjycLG/dQpuZZzE3ne8Pbt0Vh3BSyonoBJ7VHj8Dmpw
FnvKqfSN4U7o2Do4Pg08KshrqSoYywmoYF0Sj0pTVcEyPidOd6KCvaAPKmce
FfRvqCr7UO6ByghUUo8K8yrt0IRyR/rW+U7oLSjj/GTsUcEc1FWVtlqnQgXr
UvPURVfpqO1TqEw8KliXmqrS1axKKhcelQb4p6pKD8oJqExBpe6pi1XBkaQP
5Uj61pWnDkSjB0NdpfKMoHhuCPOhh0na+RoBa67PfgoNg5kty8icP4FbO6zJ
ljLNmh5tmGudinNaLV7KE/aPVTEWNIxx33MH6dRDaauPtqJhyznaDdAanjF9
Oa1cY4wRqRhjrFLxyeCLdT3qAVAfA7XpyYBOxefL7U6oXWmlp1vRcBXoaB8D
raWMIOvRyjXGGLejdoC6m1jxyUlUXrN7aJFKw72FJ+ZAl8MNY9XpTWmlW6Gm
nrbXqTi3dtQboTY8VBx9llPLmaDnCA38uLLEO3U9egPolxI7rsO2o+MMZCp0
XHUgHe9RnV4H+kToOLvF0RtjD1W622cbS75x9oRPwfWoqVDPJFacaSAVM2Gp
nBB5QGMWToR8DWScb/jJOLM7EjKO5puTUyD3hYwjkTZHWk3GeWJXWu8zIOM8
3k+OpeU6EutzINIaStsf2quQ3CyzJaSvFdKq2BwR7g/YL6TL3/1vcgjkRPL5
0kPGfi/kpDwr5l09ifQV8HANv4S3MAOOhPUTsHDnZDUr4A9d/lnjJDnHNqiM
TeRMl15v4IPjAm3A/wj+uP9Fse+ZyxTzYs8iLj01a+YUtk6oRmH7OPaBnjC+
YZ+cQSURW9Tn+2Jud53J7xk3X6Gt+eDzdCS+d6pmtc44F5tAueZm3QtxVDlu
F7LiL/GUR2c9ElytjKDckXadrCAVO7TofSRxDF1e8iak39YX9xaGS3Lbd/nI
AdYfdw0GUL4U/6bztzHk/t2s/Nah8LsRv/wdzULUB0pNy+VPJG9hruN26dHy
+UIm8SrqfJnZVba1PhYmWtF7MaqqnelizTBjT7PybgDmH3eYKC/UlHYX0r0z
QauZMO2eO/YLXHFPhWnfp4yFiVZjYZ6xFfZ5vCeHYm3fKl5kpTeUJatDUb5k
qwdwVVvPEPOarS/hqjbzJetbtnZv1rQZFUVwx1az0lXqbbEwvuCrj8wxNaUX
XAr2/gNZUWqp\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[0.02]], 
     Polygon3DBox[{{1, 0, 0}, {0, 0, 1}, {1, 1, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJylmW1v2zYQx2U92JYf5OfYSZzYzlOzLlnbrds6FFuBouheDMM+wV4EhYEW
2LChK7APXwgbj/xTYk7HQIaNRDal+//uSNHk6fzr3af32z/vPn14d7f++ePd
3+8/vPtn/favj+pU1AiCYKv+/1gE6vN/6pP+f53neRBtt9tcv4I1HYJX6pio
kxvd+lEdQ9UKtS1x9CswV1/iakTv6qKlkYWhvVBHOplYi5iuBYExWmmb70Bp
WZvk8+//GldgGbtvwGrTu/ZW2AUh68tSK56B3IFCC5IiAtBPtO0T2HZhGz9g
e4NIerDVAUeFbSWaI616DA8D9LPpqOglq66hGkLVYqqIqQ616hIRjhAhV8VM
tdCqc/iaQNUmFd0xM9CCN6Nbw9sUurSi4/7mWncKfwfQdWrqltAtMCZd2zv1
Th9DQXmglYeI9BDKnqBMmHKmlXP4PIayz5SR4NMoZ1Au0cu+00vzJ3mdau0Y
8Z5Am4naJtNOtHYIvytoBxVtJPg12j78btDbUS2/Y63twu85tOMdtCm0F9BO
+P3xqEda3XbU0QPqFlMPC7W7gp2BMt2dEhdn1Yc1ODM+YzycQclJirN5uRKS
5mB3lnOWrzR2Ts89VK7PRKq0EpF6waixh9rXVN4DPj/nGM39qHz+zEA99FBT
Zt8Tqbxt19EjRk08scpUbjXGuB57qDzWrkjlVnZ/WXqoHWbfEancKgP1hFGb
nlgNld+dntCOHqDyKFKR2hd8E/XUQ+1K96VCzQQroq5rxipTB8JMI/WmZqwt
kTpkbZulne1FHbG2zQ7PGbXlrFk6NSFDIwNZ3JvKtRUj6+PG4PJduSmyp05b
Z2Pq/0IgR0hzxRVFzB1IcclIbc/d91PI+movyhSURwIlEr6LMmUCyjWjpJ5v
tEwZY1x8FN4jra/kV5byBaN0PLHIFJsjP96bQtZf7kWxq/ANo3Q9O4ZMsU8Y
t3tRMozLbhSeBVjKk5qUWKT0QXm6NyUEhfLE/k7qnjOq+jGW0iMTSmBJfFWQ
SV1nrtDppqdX9Wh237oGreOZgTKN54KWdgVa5qHxVV+mpXm5RtOYjT3f93o0
u5duEBvPglNPTyMvjaxXoPEszRebTLM78gloPIto70Rr5mU+SuPGd+TWTrQE
tDli4zuApfFV2tDcfdnGNQOJr3bN2iQb0wSkrwSS9Ewtk8jnEGP1dc2Ywgop
BilDTN8zUlKbFKF3XZBeMlLs6V2VFOZlTYUMXwkkqd4BUiVbaoHzejeOewcC
Ux0j9FsPha9RVQpZhYjlF0aJHqbEZZZmkL8xfejpS0OrSN5WV7nX0OO1UY1d
HTJ16s2OBHNXaetIQfjps1QbkfXSbkaMFyKDrwHoe24qJFNo+XfFr+QrDdXe
+jY7uFezk/WtvKxG9YVc1tSP78/7ata0ZO0I/ViLUTTUCfJuIuA55TFrd8Aq
9oHAR7IVLk4YgaArRklBMJ1Cj/hT50JoZ4FT6SsARp/lZe3T1a2g05XeOHDK
50bHn/VmrH0Fvf4KG7eFlj/RTVn7Vh1SGqlCMXbmmWv5PDerUIjxDCos7utb
dYgLa1tL5VbPYGVy0Dm7yp/Jb2Ft6gILMLkVVd7pJpoK0hG7yp+FL8A0dUxp
brntNaxNVdrWs6UZShGYXwJO2VWe5czBNL+WrPLyVxXXagKrc221YVf5GjNA
BI+09Vle/t7Dx4KYN9qKRuJ+BTTF9af6+qWjpokWw8dzfZXmYVO1ftCtoPE/
ZUtRnw==\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[0.05]], 
     Polygon3DBox[{{1, 0, 0}, {0, 0, 1}, {1, 1, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJylmWtvG0UUhjfem2/xNY6vsR07aVpoaUFRBVSICqTwAfET+BBVlloJBCqV
+PGRBXNm3rHXr89EthrVa8/ueZ9z5uzs7Mzpb/ef3q/+vP/04d39/JeP93+/
//Dun/ndXx/NqfgkiqKV+fwxiMzv/8wv+/lpvV5H8Wq1Wtu/aC6H6K05Jubk
pW39YI5iEhtByXw7mzfmKK2S2O5c+dbbm+/UXLF8cW+OM2vxGtrUfGeqxS0s
MvOdi0XiLJzR1Np8DT+5+S7LlXRjY87I7wtr9xKs6sbbw+//wlvsvaP/Y6t4
AUUNipIIYkikbVXOyVb1BeKpQxWTKibVyKqewlcDqtSqNj3Z8+VU1/DVRH40
VYnu7cAql/DXhjIjJUc5tKpLqLqIMldU7K9vlVNEegZlWVHGpDy3ygl8nkNZ
IWWi+HTKIXz2oax6pbvxVsk+e1bZh88hsnO4sgflCMq6Ei0rz6yyg2jHUJ4q
PhNSdq2yBZ9T9LNxsLIB5QzKZkEpP1NF2bHKGqKdQ9lSlCkp21ZZgc8F+nmc
kmcpIbRFlmwI5p/GaFlGuXBW7opndI5lJJuzhfx1VUpGlOaWkm7OrrdzlZDO
KCulAKux1yv5yc/DENTeZ1F53PaRuxA1J/tTlcrjqwfqOVHjQKyOyr7Yqgtq
P0BlfV2lcruDvA4CVO5rTaWyVQvUIVGTQKw6lZ8W/2YZBagcRVWlVpU8SV7H
SgYyhVpRqTXFi1AnB8bqqOrIoDwL9SJA5YyVVWpDGRPS06lC1TKgU5vU9mui
Gc+OgVhzldqidgzq/BGqzM16jHYW3s57yKbGyjB32hdfYRWhR9kptOV9JepL
omaIsAQqzxqZSvZP/SJEW7l14z6JZ36/blkqJO0u6xS/broiSh4Y1zrFzzrX
n0XxKz+NovUoVSktUJ4QpRyIRaf49evNURQeA37efKpQMmXe1ClNUJ4RpRKY
fXWKn22/DPToMMop8sIUHwuPd53i5+jnB/YoUSk1UF4cReE1g98VfUWUaqBH
OqVWoMgzXD9K7XeAklWZzkoHZlenVZAXGXVyOgv0jMe8TvPvqCegVQOxHUbL
QbsCrfGgPxlMi4O0DLOpnO4ExrZO4zWpp81wF3i9lx9Fy0C7QGy8yvGzGo9q
nZYibyPQ+N3uYzuMloA2AC30NjqMFq+3q27JG8+8/v3Ldy9M8zsXOc0zjV8Z
6LTiuz0BqQ3SSyIlgV6W9kg+piZI3ygkrYf7pBJyVUOuXgdiCpCSDQmcCiJ6
Q5z4cU5xBRS5qokY/UiUEvrF92if4itEYvSzQkkfoWzXWdYKmbk7nhK5vwTN
Xx9476v15QSZ3eqdumK+7/YIWgSOIGZdc/Utj9egQt4TE3P1e0XBY6bAQIwz
87k9SKk9KQt64/m87atlyPkq5YLWMlsV903boyyK616fafLp1Dl89qCakIpr
j07FOxCpKy6jQjWg4PPENEXllFX4mxBhGRUqUAXfu+o6qYbUztELVyeMdqq1
uyTeHw4CWYz9zV4Vis+4X76CxlrJ5dzfqx0F78l61JasjCI3XqVc72JtF+7R
Ts7MoUt+nKJLlh1qPzOHhvdjFWfwwZav1qhkbyzPyYJ3r1KTT1fYpbkKMOW1
2JY6uzzPbhc/WG8r4RyvWLl6z4iucgXhChG4yuF4va3kF63mYLp68QVd5V3H
GExXe5/SVV7/9sF2/5MxQwRs1YXV0lpd0lVtVyER3FjrBZhsVQXzubWSTETp
5ura1RnLsHllba5B4vlIZLfW4gat72wrOvkf0NKnCQ==\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->743747]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Pink", ",", 
       RowBox[{"EdgeForm", "[", 
        RowBox[{"Thickness", "[", "r", "]"}], "]"}], ",", 
       RowBox[{"Cylinder", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.02", ",", "0.05"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->110853312],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[0.01]], 
     CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[0.02]], 
     CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[0.05]], 
     CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->290765712]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Pink", ",", 
       RowBox[{"EdgeForm", "[", 
        RowBox[{"Thickness", "[", "r", "]"}], "]"}], ",", 
       RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.02", ",", "0.05"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->386588529],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[0.01]], CuboidBox[{0, 0, 0}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzlmItOE0EUhpfubi9L7y2llFspUAQJhItQQdEYI1Hk8goNmECiwSCv4gv4
no3OnPm7bH9HWCPEGJswtOd835kzS8vO9LB7ff7hU/f64rTb3L/qfj6/OP3S
fHN5pULukOM4Z+rnY91Rz7+rZ/Jz1uv1VCIyvlSjq1Iz8uo5XiUuR/Yc/aQn
D2dasrtqTKigr7L6d1OiHTip0DnuqBHOFpwgktWAyW4im9VZ7ybrOFOSX0Pt
vM77YR4zTAqzihqlW5hl1KlQFwk9RNbZEHoJFWtEu2qYEGIB9eoWIlpvTOh5
0A2iPaLrQs9i9slYdBO1p4n2iR4Vegq1W0Qnia4JPY7ac7HoMdBtolNEjwg9
ik4WiU6rwfRaRb3HFiJaryp0GfVW76ArQhdQey0WnQO9QXSG6LLQw+hki+iA
6JLQgR51VNFauB9rmKxiLCurBrOGDJHbFjJavxDLypGVf0ArT1YullUgK/uA
VpGsYbHSZHXIKqkhF5uM1g9iWWWyMvdoPb3DSseyKmSlxEqRtfPPWVU1ZB6A
jHaS/AMrSdbuf2KNqCH9m6RP5DMLGe3E/+uWXot+WYtFd0Anvp1/ve0K2+0n
sJMWO2U11mEEZFRCwyND7wP0hjJPBv/P8az2MuYrK1vfy/kTbbcW+9cQVry5
2rAa1CnfH+x2C+ucIpvvSXZ7GnaLbL572u0JdL5gsc1nyyWjAWMJV6jwS3IU
5ArV5t2Aa7UrWNc62bxvsdtFzL1NNu+q7HYO9i7ZvJOz2wHsPVwh+5wJslJY
76uI5VtJD/X3qbvMoOGFBvgD4nmnnAhdrR4TzWeAxGBvitbCCbq31/aIPgZt
r+1b6GhHfD4yln4v6ponRPPZy9BpmuPIYplPTgZ1uQs3JAIQR1gVzzgkVJZm
fE/1+DxrrBxqH2r6pxOyeUcVqLL8vQdO5IYrolZ05psqJWQPsApZ4EAvFZrn
LUjjV+G/C6tH3Rq5r9XghW7/RPkCUXMnriO6g6jZmzcQ3UTUnI/GEV1B1JxU
J2nWBWTN2b5/op5FVGj5dkPO8CqqL7j5dmWGKtXgtCXbglNGdEmic+QEqLgi
2Xk4STgbEm0j6rjaMA/9eluyj/oVcW2fStR8G+QM/QBEE3kM\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[0.02]], CuboidBox[{0, 0, 0}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNl+tO20AQhQ1O7JCQ+4UAgQQScRFQCuKapqj9UVrRAu0jRAgJpFZUlFfp
C/Q9o3Zn5thZT+0KKlUqUrx4zjdnZ9f2en0+fLi5/jJ8uL0adt7eD7/e3F59
65ze3ZuQO+E4zrX5fW465v+f5j/+XY9GIyPw8bU5TprgMp+dmKNnzpb4bGCO
KXPmpO7qJ07wJ1ofmmskajscPUTUM1FyddzR5ZFpSGwzsQ8iA2KSAFcQAhaY
2gWVsyhqF1l9DjUP1VUeLaaegSolUPNMbYCqWhS14rEOtQ41pTzmmFoB1bQo
aqWHHtQ5qGnlMcvUMqgWKE9RTabaoNoWRa14LEBdguorjxmmqOa0CXZBZRTV
YKoJrxWLolY8GlDXoE4pjzpTVVAbFkWt9FCGugU1qzxqTBVQ7TaonKKqTE3D
a9eiqBWPLNQ9qNPKoxJSpB6AyiuqzNQUqEOLorYSUY8SPEqJFLXlWLWgPIqx
VFFRhZDiqKHoGT60aGmJysDrGGpJeeUTKakvTi1Djc+tqB5yiZRcrzi1qjyy
IWWPOJifmqJ5ZswTIp59i5J7MU6tK49MIiV3+9PVhurBDyl7TMdPopOqF9pD
BYN/RMna8TjVrvpFwhi9v6DT6Pnlf0jZoxhYtKzfcVQfb9w/U/SkZ2J6Zs68
oaS+fUP5pk39uPked12j9C5o39BuzDMVpbdB50Dr5zVKbxqadh4l0HqFGNP2
KFfRRw31Py6rh6wmsoK1Sq6Ki4q6oOZRUVl5pyJ0B/V3QOs1NEq34N0DrVfv
KD0Leg31JtP2KOvI2kSWfo/EZ1Uwjh1k6TdYfFYRWXsYzzRmVOZ/EuPIo6Ij
ULlYKgtqYFF2BW6E9kG/Qr3JtF2vi3rfIEvvPX7Pcuj+ML93qErveMYZRH0A
pfdWY4qCH0HpfZobufqfUKOP2UpFnhtbtT249nDNvURPelcplK8ovUMVKoOq
L0DpvbBQwS7qAnXFUzl4nYPSe3Oh8vAKqOArQOanADWY6+BbwwmJInp5r4hx
D2V4EJEK8yrIO0OeRGtgz8KaKVpH9NRE02G0AQe6K71wZWmC7SMqu55ZsHuI
yp5sHuw2orLPbYGllYDuetmNLyDaBSvfLm04LCIqX2gdsDNw6HF0GWwF7DpH
u2BzYLc42kPUQ3SHoytwcFwTxlWgGT1gdXUkO/A+n8mXpzPxC29IG0I=\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[0.05]], CuboidBox[{0, 0, 0}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNlutOE0EYhqd7brs9bA+2UAotiBxEkFDOYggJKip6DQ0hgUSDQW7FG/A+
G/2+mXe3M+22IfpDm3R3532emf3and2dy/7DzfXX/sPtVb/z9r7/7eb26nvn
zd09RXZGCHFN3y9NQce/6Eh+rweDgRCntHWo2ZWtE9oG1OrI1jFt89RakK0D
2haT1h5M667+2qf9vEx7tOWWa6TbcH1Ked+W6RbSLKUu7YUz+Hwg4s+cdDbg
hFOcdThFOBYpNu1bkq6iokij/HtnJV1G3yqojb6KLoHWQR3QGUk7oM1UOg/a
Isrnc0Gbks6BtrW+bDUknYmvAmjcV9EG6CKoB/pE0hroskZ55LqkFdAVUB99
FS2DroEGoDVJC6AbqTQPugmaBa1KmgV9qVGuqiJpQFuPWjugOfQdUnZ3QfOg
UUK5tfcoGoKWU2kBtPQI6qOqmBZBixOpI9R/qCi7B5gbJfQdp65Gwz+gZdB8
Ko1Ac5J6qPlxtAKaTSi3DjXqCPUfjtMq+qbTGlHrL6gt1C/l+0bVPJly6+gf
0zp+kaIOaj7G3Bin3PfVyMjef0EP8XyPa1bUBt0nGmpX0KQ9oiVtZNeg/Nyo
aTPHpC+IRrQX9s+bH0J9HG2OmvY6bIdkX5vnprUCK4BVNiwLV+kpWWW+c8ny
Ui1udTFWpFnWmDUPqw6rlGq1YM3Aip87jmE1UVcb1RdSrRrG6sIKU60I1jLO
aFrxTn1KcNfg5qe4IWrc1Fxrghtg3G1UmpviunB34WanuBbcQ9QQv7VsJdlD
l60TWMFEq0DfM1i+YTE5R0WeQXJ0dAHiThyZZ9ulZlkJ5uvE9+QnnNek9giN
VymW8YSMqW1QD30/4ryWQf0Raq7NrOS9z84HjJ/m5EYde+goI4TxnowgSQtI
L4y0OJJmBvHKhtN3qFWlkZZ6SVpFem64NaSnlOaSs9WRHlFaSCZXA2kPqXpX
NZFuIVVv7Fmkq0jVuqWFdAmpWp/xqpHrbCMdrjTZbSBVa+4FpBWkizLtIg2R
PpPpIlIP6fNBvPqtCrVOVytlZjuyxf34391XEzTzGyANptY=\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[4]=",
 CellID->386525928]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27371],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Thick",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thick"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Thin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thin"]], "InlineFormula"],
 " to specify predefined absolute thicknesses:"
}], "ExampleText",
 CellID->608320226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Thin", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->519392947],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Thickness[Tiny], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[Large], LineBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",
 ImageSize->{230, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->214278978]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->266255764],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 " defines the thickness ",
 "as a fraction of the total width of the graphic",
 ":"
}], "ExampleText",
 CellID->371080297],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Thickness", "[", ".5", "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}],
    ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotRangeClipping", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26636789],

Cell[BoxData[
 GraphicsBox[
  {Thickness[0.5], 
   LineBox[NCache[{{Rational[1, 2], 0}, {Rational[1, 2], 1}}, {{0.5, 0}, {
      0.5, 1}}]]},
  Frame->True,
  PlotRange->{{0, 1}, {0, 1}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{154, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->489238264]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 " depends on the image size:"
}], "ExampleText",
 CellID->85601104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Thickness", "[", ".03", "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "100", ",", "150"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->146120593],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Thickness[0.03], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->50], ",", 
   GraphicsBox[
    {Thickness[0.03], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->100], ",", 
   GraphicsBox[
    {Thickness[0.03], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->150]}], "}"}]], "Output",
 ImageSize->{341, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->185552762]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->685877372],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteThickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteThickness"]], "InlineFormula"],
 " defines the thickness of lines in units of printer's points:"
}], "ExampleText",
 CellID->38957977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"AbsoluteThickness", "[", "15", "]"}], ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<15 points\>\"", ",", "White", ",", 
        RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->275776734],

Cell[BoxData[
 GraphicsBox[
  {AbsoluteThickness[15], LineBox[{{-1, 0}, {1, 0}}], InsetBox[
    StyleBox["\<\"15 points\"\>",
     StripOnInput->False,
     FrontFaceColor->GrayLevel[1],
     BackFaceColor->GrayLevel[1],
     GraphicsColor->GrayLevel[1],
     FontSize->15,
     FontColor->GrayLevel[1]], {0, 0}]}]], "Output",
 ImageSize->{154, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->492173884]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteThickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteThickness"]], "InlineFormula"],
 " is independent of the image size:"
}], "ExampleText",
 CellID->353597015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteThickness", "[", "3", "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "100", ",", "150"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10908331],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {AbsoluteThickness[3], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->50], ",", 
   GraphicsBox[
    {AbsoluteThickness[3], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->100], ",", 
   GraphicsBox[
    {AbsoluteThickness[3], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->150]}], "}"}]], "Output",
 ImageSize->{341, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31861693]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17945],

Cell[TextData[{
 "Thick lines can be clipped by a frame without ",
 Cell[BoxData[
  ButtonBox["ImagePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImagePadding"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->720938405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Thickness", "[", "0.3", "]"}], ",", "Gray", ",", 
     RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"ImagePadding", "\[Rule]", "None"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->250041298],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0.5], Thickness[0.3], CircleBox[{0., 0.}]},
  Frame->True,
  ImagePadding->None]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->173388104]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ImagePadding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImagePadding"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " leaves enough padding for thick lines:"
}], "ExampleText",
 CellID->387924877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Thickness", "[", "0.3", "]"}], ",", "Gray", ",", 
     RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"ImagePadding", "\[Rule]", "All"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->269028781],

Cell[BoxData[
 GraphicsBox[
  {GrayLevel[0.5], Thickness[0.3], CircleBox[{0, 0}]},
  Frame->True,
  ImagePadding->All]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->244919096]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
      RowBox[{"Thickness", "[", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0.05"}], "}"}], "]"}], "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "50", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75183773],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.7740371808300364], Thickness[0.026131430693536652`], 
    LineBox[{{0.3419381712506262, 0.12307825646271398`}, {0.6761811080364524, 
     0.9036228184040072}}]}, 
   {Hue[0.8909858641019788], Thickness[0.04315084382169196], 
    LineBox[{{0.544677551689495, 0.07512211715546546}, {0.08664513814028707, 
     0.257498224814632}}]}, 
   {Hue[0.8336729472381252], Thickness[0.0018736567826219243`], 
    LineBox[{{0.7958773444078884, 0.9526960535392268}, {0.5637637464223761, 
     0.008660217112018032}}]}, 
   {Hue[0.9117906213197757], Thickness[0.03720755816788329], 
    LineBox[{{0.53300382719542, 0.6734143691502252}, {0.44520457585721673`, 
     0.9491256730366406}}]}, 
   {Hue[0.8164168413827251], Thickness[0.0410814020091399], 
    LineBox[{{0.4232294426166956, 0.4825810280031575}, {0.8855025339623472, 
     0.5294564497240257}}]}, 
   {Hue[0.7258292591265647], Thickness[0.04684385368026413], 
    LineBox[{{0.5767080052379991, 0.14883214179308646`}, {0.1830596170996941, 
     0.7441477543848067}}]}, 
   {Hue[0.5860958923946338], Thickness[0.012078386895479888`], 
    LineBox[{{0.7715308012833635, 0.790981328923732}, {0.5451137369203147, 
     0.36650350120278086`}}]}, 
   {Hue[0.8933601793674846], Thickness[0.02480796776099972], 
    LineBox[{{0.16356668711025057`, 0.15612131277251495`}, {
     0.3063937487078543, 0.7375606793802016}}]}, 
   {Hue[0.8355007119968025], Thickness[0.028159129467418678`], 
    LineBox[{{0.4864786307959601, 0.4466467088967918}, {0.15470205887816868`, 
     0.6713564992250425}}]}, 
   {Hue[0.15519334165233345`], Thickness[0.007874327757371636], 
    LineBox[{{0.30095463485130214`, 0.10298296437389087`}, {0.479381794394548,
      0.8789976656488263}}]}, 
   {Hue[0.0922302015040537], Thickness[0.0184997324374108], 
    LineBox[{{0.5429603951656838, 0.37849425641664824`}, {0.1615113713100842, 
     0.12896211843821992`}}]}, 
   {Hue[0.250333243268007], Thickness[0.008615990188154366], 
    LineBox[{{0.26000402832642355`, 0.4382326335176552}, {0.9837041940795705, 
     0.23429745738979713`}}]}, 
   {Hue[0.7758374466997378], Thickness[0.027100813666548176`], 
    LineBox[{{0.5276085766701741, 0.36854659629888764`}, {0.6696567981408676, 
     0.7805820131807124}}]}, 
   {Hue[0.4528467220839003], Thickness[0.004080429801101859], 
    LineBox[{{0.3267828133458237, 0.9530045816934019}, {0.3165427370593552, 
     0.7154275486866906}}]}, 
   {Hue[0.852771714590036], Thickness[0.0036814147929290723`], 
    LineBox[{{0.5607405442464648, 0.8980764876657066}, {0.6228752135506033, 
     0.6049966842359762}}]}, 
   {Hue[0.578634197920953], Thickness[0.013520995645338763`], 
    LineBox[{{0.4587235778478187, 0.325419608572012}, {0.43049165673448053`, 
     0.2907627515159421}}]}, 
   {Hue[0.038765595491316196`], Thickness[0.0390356867505916], 
    LineBox[{{0.4716254091701866, 0.4890616304174509}, {0.3053834620545308, 
     0.3196960370705171}}]}, 
   {Hue[0.11788609294859898`], Thickness[0.00779791468914609], 
    LineBox[{{0.35054221563498955`, 0.38024274127152036`}, {
     0.4967836322221433, 0.1446498958402247}}]}, 
   {Hue[0.14706383519153143`], Thickness[0.04588392366922898], 
    LineBox[{{0.45338796380883783`, 0.12448720795482782`}, {
     0.9323272756641658, 0.2386819505059119}}]}, 
   {Hue[0.7363491332120444], Thickness[0.024959579688807822`], 
    LineBox[{{0.4998932427448579, 0.12361452970480657`}, {
     0.20710241882218994`, 0.5082553826940417}}]}, 
   {Hue[0.6158302052801263], Thickness[0.001196778117459685], 
    LineBox[{{0.08326962578205621, 0.868245878444585}, {0.9739334325463733, 
     0.43094748673803807`}}]}, 
   {Hue[0.38556150187094085`], Thickness[0.002793011636295195], 
    LineBox[{{0.08501765173128484, 0.8657549084057077}, {0.5034249219224907, 
     0.20960517771072684`}}]}, 
   {Hue[0.5415343256416578], Thickness[0.04443922776175491], 
    LineBox[{{0.09664215615700211, 0.6242588820738784}, {0.40605149319680534`,
      0.5024167940371571}}]}, 
   {Hue[0.10390597891982356`], Thickness[0.030195339443328764`], 
    LineBox[{{0.9717648295404264, 0.3398949600236867}, {0.7445539754015127, 
     0.6970588530112156}}]}, 
   {Hue[0.4813764474325528], Thickness[0.02737534630373313], 
    LineBox[{{0.39772949665862045`, 0.5651914173311408}, {0.7521186204603381, 
     0.16315958443791212`}}]}, 
   {Hue[0.5720437424423135], Thickness[0.03731589943245477], 
    LineBox[{{0.30512580468761685`, 0.5669061966153601}, {0.6589748735396059, 
     0.609998007630925}}]}, 
   {Hue[0.6752725052065587], Thickness[0.016898367538756544`], 
    LineBox[{{0.5445997631917399, 0.0495298235795838}, {0.29806876224830825`, 
     0.4694059808002915}}]}, 
   {Hue[0.5322015468903909], Thickness[0.042075322147319995`], 
    LineBox[{{0.31191736212876897`, 0.27141976758989284`}, {
     0.25965263881190426`, 0.744585301280412}}]}, 
   {Hue[0.15670386683340554`], Thickness[0.025724767046260456`], 
    LineBox[{{0.8785511992145945, 0.6122180623084315}, {0.502229073308198, 
     0.5010491565309614}}]}, 
   {Hue[0.35634869281511317`], Thickness[0.019311122650991466`], 
    LineBox[{{0.782080437966113, 0.8448019358326131}, {0.03049937281773829, 
     0.7876808321085371}}]}, 
   {Hue[0.4223452540638202], Thickness[0.038838387833874166`], 
    LineBox[{{0.17217984728589353`, 0.2843700934529625}, {0.09072363696564123,
      0.9837572907448882}}]}, 
   {Hue[0.4225413220531222], Thickness[0.04634777111999064], 
    LineBox[{{0.19041655858185758`, 0.2568424048046136}, {0.5508954349930306, 
     0.2653234135026199}}]}, 
   {Hue[0.9976045558684832], Thickness[0.020052229093321605`], 
    LineBox[{{0.6734731311623345, 0.5967317330105129}, {0.15209182232239282`, 
     0.9008017320391959}}]}, 
   {Hue[0.5360282015883264], Thickness[0.0444285609624403], 
    LineBox[{{0.04733106929799136, 0.9584582799250916}, {0.9919352593107971, 
     0.4273056264709172}}]}, 
   {Hue[0.6617301366510604], Thickness[0.032485602261894266`], 
    LineBox[{{0.7759167672056781, 0.37852717433077365`}, {0.7668227475315645, 
     0.847494348968834}}]}, 
   {Hue[0.25203712212083773`], Thickness[0.024379557276265718`], 
    LineBox[{{0.5767779074902659, 0.7970833342373429}, {0.341513665947071, 
     0.24009599887708855`}}]}, 
   {Hue[0.9425210424835739], Thickness[0.029430910309127947`], 
    LineBox[{{0.9184053048933449, 0.9359496936375389}, {0.3699856917205906, 
     0.907649004261843}}]}, 
   {Hue[0.6137016474781725], Thickness[0.049107394586612764`], 
    LineBox[{{0.8112604188381187, 0.5973880704061476}, {0.6720898066006629, 
     0.39126250432796383`}}]}, 
   {Hue[0.18667794938851334`], Thickness[0.041058508494823946`], 
    LineBox[{{0.19747766130911826`, 0.7518723413279897}, {
     0.48696580484883234`, 0.7620703416444552}}]}, 
   {Hue[0.27102409155157914`], Thickness[0.012161069769480892`], 
    LineBox[{{0.4544506933179915, 0.2289329869094181}, {0.26640479404507555`, 
     0.8246799546412593}}]}, 
   {Hue[0.7935850029763545], Thickness[0.02015584208329102], 
    LineBox[{{0.5404434650848711, 0.7381553791436617}, {0.603362549673055, 
     0.9294588906228911}}]}, 
   {Hue[0.3512901533870776], Thickness[0.017919738083920268`], 
    LineBox[{{0.16845649431202214`, 0.7901588400199282}, {0.981885637465945, 
     0.4746213860506652}}]}, 
   {Hue[0.8328952613807765], Thickness[0.045689938087036086`], 
    LineBox[{{0.8661549684967826, 0.5520095106850118}, {0.30602351461888877`, 
     0.2093759822291028}}]}, 
   {Hue[0.21340755122765231`], Thickness[0.0004421581158297827], 
    LineBox[{{0.706972735683435, 0.6336589511366304}, {0.7604985432064635, 
     0.4726022179165892}}]}, 
   {Hue[0.8186674261796798], Thickness[0.04764093737055626], 
    LineBox[{{0.18811673865555156`, 0.387139975622117}, {0.48362458649373785`,
      0.822295939999433}}]}, 
   {Hue[0.05687003713341432], Thickness[0.036547609864526896`], 
    LineBox[{{0.5263433677751599, 0.5473681327288362}, {0.6509047947084128, 
     0.0191248241292703}}]}, 
   {Hue[0.6686151880973867], Thickness[0.04714822356917917], 
    LineBox[{{0.252873282231574, 0.29851655154008117`}, {0.2702867177364694, 
     0.17493149332381353`}}]}, 
   {Hue[0.4242195555301489], Thickness[0.028939314673502883`], 
    LineBox[{{0.9509976007810663, 0.15694201614522396`}, {0.8284829719479414, 
     0.8372427365247639}}]}, 
   {Hue[0.8679910620045608], Thickness[0.016505814900848726`], 
    LineBox[{{0.28464516949308605`, 0.685801264491076}, {0.7825465276813637, 
     0.15379929553932215`}}]}, 
   {Hue[0.12954988907457632`], Thickness[0.04172623046547204], 
    LineBox[{{0.44791336555054273`, 0.18907175302985713`}, {
     0.6951481178247672, 0.32449572182905984`}}]}}]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->350586139]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9421],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Thick",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thick"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Thin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteThickness",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteThickness"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PointSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PointSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dashing"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRangeClipping",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRangeClipping"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3161]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4546],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]], "Tutorials",
 CellID->815154705],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "Tutorials",
 CellID->659944600]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Thickness",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Thickness"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->2491579],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->442137469],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->6947354]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Thickness - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 33.2072146}", "context" -> "System`", 
    "keywords" -> {
     "thickness of lines", "styling of lines", "styling of edges"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Thickness[r] is a graphics directive which specifies that lines which \
follow are to be drawn with thickness r. The thickness r is given as a \
fraction of the total width of the graphic. ", "synonyms" -> {}, "title" -> 
    "Thickness", "type" -> "Symbol", "uri" -> "ref/Thickness"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10312, 271, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->121177974]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 80432, 2155}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2797, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3420, 89, 4193, 83, 70, "ObjectNameGrid"],
Cell[7616, 174, 764, 22, 70, "Usage",
 CellID->19074]
}, Open  ]],
Cell[CellGroupData[{
Cell[8417, 201, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8895, 218, 524, 16, 70, "Notes",
 CellID->13759],
Cell[9422, 236, 853, 30, 70, "Notes",
 CellID->5850]
}, Closed]],
Cell[CellGroupData[{
Cell[10312, 271, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->121177974],
Cell[CellGroupData[{
Cell[10697, 285, 148, 5, 70, "ExampleSection",
 CellID->381362522],
Cell[10848, 292, 132, 4, 70, "ExampleText",
 CellID->25232105],
Cell[CellGroupData[{
Cell[11005, 300, 735, 25, 47, "Input",
 CellID->128720659],
Cell[11743, 327, 506, 15, 60, "Output",
 CellID->473364419]
}, Open  ]],
Cell[12264, 345, 125, 3, 70, "ExampleDelimiter",
 CellID->171757471],
Cell[12392, 350, 82, 1, 70, "ExampleText",
 CellID->539791327],
Cell[12477, 353, 432, 15, 70, "Input",
 CellID->28799232],
Cell[CellGroupData[{
Cell[12934, 372, 432, 15, 70, "Input",
 CellID->60688723],
Cell[13369, 389, 860, 23, 110, "Output",
 CellID->646240168]
}, Open  ]],
Cell[14244, 415, 125, 3, 70, "ExampleDelimiter",
 CellID->229206653],
Cell[14372, 420, 228, 8, 70, "ExampleText",
 CellID->44384296],
Cell[CellGroupData[{
Cell[14625, 432, 507, 16, 28, "Input",
 CellID->558754509],
Cell[15135, 450, 4645, 80, 128, "Output",
 Evaluatable->False,
 CellID->446413357]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19829, 536, 216, 7, 70, "ExampleSection",
 CellID->16461],
Cell[CellGroupData[{
Cell[20070, 547, 245, 7, 70, "ExampleSubsection",
 CellID->205528226],
Cell[20318, 556, 96, 1, 70, "ExampleText",
 CellID->278831735],
Cell[CellGroupData[{
Cell[20439, 561, 753, 25, 70, "Input",
 CellID->10693766],
Cell[21195, 588, 599, 17, 60, "Output",
 CellID->523774125]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21843, 611, 238, 7, 70, "ExampleSubsection",
 CellID->1325779],
Cell[22084, 620, 81, 1, 70, "ExampleText",
 CellID->131972316],
Cell[CellGroupData[{
Cell[22190, 625, 406, 14, 70, "Input",
 CellID->74558811],
Cell[22599, 641, 432, 14, 123, "Output",
 CellID->296240231]
}, Open  ]],
Cell[CellGroupData[{
Cell[23068, 660, 646, 22, 70, "Input",
 CellID->126355687],
Cell[23717, 684, 512, 15, 76, "Output",
 CellID->889490797]
}, Open  ]],
Cell[CellGroupData[{
Cell[24266, 704, 778, 25, 70, "Input",
 CellID->118997887],
Cell[25047, 731, 4766, 91, 101, "Output",
 CellID->302333360]
}, Open  ]],
Cell[29828, 825, 123, 3, 70, "ExampleDelimiter",
 CellID->7178458],
Cell[29954, 830, 234, 8, 70, "ExampleText",
 CellID->246606596],
Cell[CellGroupData[{
Cell[30213, 842, 457, 15, 70, "Input",
 CellID->33396395],
Cell[30673, 859, 536, 17, 123, "Output",
 CellID->566752795]
}, Open  ]],
Cell[CellGroupData[{
Cell[31246, 881, 463, 15, 70, "Input",
 CellID->336961838],
Cell[31712, 898, 553, 17, 123, "Output",
 CellID->49500087]
}, Open  ]],
Cell[32280, 918, 124, 3, 70, "ExampleDelimiter",
 CellID->76292278],
Cell[32407, 923, 405, 14, 70, "Input",
 CellID->130811177],
Cell[CellGroupData[{
Cell[32837, 941, 435, 15, 70, "Input",
 CellID->155389808],
Cell[33275, 958, 6262, 114, 131, "Output",
 CellID->743747]
}, Open  ]],
Cell[CellGroupData[{
Cell[39574, 1077, 534, 17, 70, "Input",
 CellID->110853312],
Cell[40111, 1096, 10308, 183, 131, "Output",
 CellID->290765712]
}, Open  ]],
Cell[CellGroupData[{
Cell[50456, 1284, 532, 17, 70, "Input",
 CellID->386588529],
Cell[50991, 1303, 4234, 80, 131, "Output",
 CellID->386525928]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[55286, 1390, 233, 7, 70, "ExampleSection",
 CellID->27371],
Cell[55522, 1399, 345, 13, 70, "ExampleText",
 CellID->608320226],
Cell[CellGroupData[{
Cell[55892, 1416, 731, 26, 70, "Input",
 CellID->519392947],
Cell[56626, 1444, 383, 12, 75, "Output",
 CellID->214278978]
}, Open  ]],
Cell[57024, 1459, 125, 3, 70, "ExampleDelimiter",
 CellID->266255764],
Cell[57152, 1464, 260, 9, 70, "ExampleText",
 CellID->371080297],
Cell[CellGroupData[{
Cell[57437, 1477, 793, 26, 70, "Input",
 CellID->26636789],
Cell[58233, 1505, 410, 13, 170, "Output",
 CellID->489238264]
}, Open  ]],
Cell[58658, 1521, 205, 7, 70, "ExampleText",
 CellID->85601104],
Cell[CellGroupData[{
Cell[58888, 1532, 662, 22, 70, "Input",
 CellID->146120593],
Cell[59553, 1556, 462, 16, 101, "Output",
 CellID->185552762]
}, Open  ]],
Cell[60030, 1575, 125, 3, 70, "ExampleDelimiter",
 CellID->685877372],
Cell[60158, 1580, 255, 7, 70, "ExampleText",
 CellID->38957977],
Cell[CellGroupData[{
Cell[60438, 1591, 684, 21, 70, "Input",
 CellID->275776734],
Cell[61125, 1614, 510, 15, 161, "Output",
 CellID->492173884]
}, Open  ]],
Cell[61650, 1632, 229, 7, 70, "ExampleText",
 CellID->353597015],
Cell[CellGroupData[{
Cell[61904, 1643, 667, 22, 70, "Input",
 CellID->10908331],
Cell[62574, 1667, 476, 16, 101, "Output",
 CellID->31861693]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[63099, 1689, 226, 7, 70, "ExampleSection",
 CellID->17945],
Cell[63328, 1698, 237, 8, 70, "ExampleText",
 CellID->720938405],
Cell[CellGroupData[{
Cell[63590, 1710, 352, 10, 70, "Input",
 CellID->250041298],
Cell[63945, 1722, 317, 10, 171, "Output",
 CellID->173388104]
}, Open  ]],
Cell[64277, 1735, 325, 11, 70, "ExampleText",
 CellID->387924877],
Cell[CellGroupData[{
Cell[64627, 1750, 351, 10, 70, "Input",
 CellID->269028781],
Cell[64981, 1762, 314, 10, 163, "Output",
 CellID->244919096]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[65344, 1778, 223, 7, 70, "ExampleSection",
 CellID->8246],
Cell[CellGroupData[{
Cell[65592, 1789, 628, 19, 70, "Input",
 CellID->75183773],
Cell[66223, 1810, 8796, 156, 203, "Output",
 CellID->350586139]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[75080, 1973, 310, 9, 70, "SeeAlsoSection",
 CellID->9421],
Cell[75393, 1984, 1699, 62, 70, "SeeAlso",
 CellID->3161]
}, Open  ]],
Cell[CellGroupData[{
Cell[77129, 2051, 313, 9, 70, "TutorialsSection",
 CellID->4546],
Cell[77445, 2062, 197, 4, 70, "Tutorials",
 CellID->815154705],
Cell[77645, 2068, 162, 3, 70, "Tutorials",
 CellID->659944600]
}, Open  ]],
Cell[CellGroupData[{
Cell[77844, 2076, 305, 8, 70, "RelatedLinksSection"],
Cell[78152, 2086, 363, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78552, 2103, 317, 9, 70, "MoreAboutSection",
 CellID->2491579],
Cell[78872, 2114, 149, 3, 70, "MoreAbout",
 CellID->442137469],
Cell[79024, 2119, 160, 3, 70, "MoreAbout",
 CellID->6947354]
}, Open  ]],
Cell[79199, 2125, 50, 0, 70, "History"],
Cell[79252, 2127, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

