(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33655,       1033]
NotebookOptionsPosition[     28862,        871]
NotebookOutlinePosition[     30265,        910]
CellTagsIndexPosition[     30180,        905]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Thick" :> Documentation`HelpLookup["paclet:ref/Thick"], 
          "Thickness" :> Documentation`HelpLookup["paclet:ref/Thickness"], 
          "AbsoluteThickness" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteThickness"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Thick\"\>", 2->"\<\"Thickness\"\>", 
       3->"\<\"AbsoluteThickness\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Graphics Directives\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Thin", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Thin",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Thin"]], "InlineFormula"],
     " \[LineSeparator]is a graphics directive that specifies that lines \
which follow should be drawn thin."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->332222347],

Cell["Compare thin and thick lines:", "ExampleText",
 CellID->568660478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Thin", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->543815691],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Thickness[Tiny], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[Large], LineBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",
 ImageSize->{230, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->303091569]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Thin", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Thick", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->494817468],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {Thickness[Tiny], Line3DBox[{{0, 0, 0}, {2, 1, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydV2tPE0EUne72watCW5FHLCKBqCiBoICiKKKgxvDBn9BgE/hgNMjf3+jc
u2fa6Zmxu0hSdu/cM2fu3NfOnPduLvs/ejdXF73VT9e9X5dXF79Xz35e26G0
Yoz5bn/fFo19/2Pf9HeeZVnS7/fn7dOYr5BMal/sUwbvquaz/Z/akRSIfPQU
o3WR0nyCTO+o9gTayaj2GEwzIlVzbQ5oq/4Is++IVBvowdFSzCEwrTGYl77F
6QBjEpJ1HbMHxoUCdFPRu0Avl0JvA90lbUqyesRswe7VUuhNcK+RtkrytKIf
Ab1B2hrJU4regCWPS6HXwL1J2jrJmhXmAdBbpG2QPKHoLizZKYVeBvduTMuz
zQLQezE7eR9aFTL4qoA7R7dh95sCbvWomQX325h/ObYafxl8Xwo9BUs+knaa
ZM0y9YwMnkXsFjG3twrpS2TvInI1pINZOmryP56dZmFvyVxt5RzVQU8RrOVg
O7n7xOfnFCk4PmDdmX/PCzpNDXOP7LPqelZ87pgu4VgOsmGvDSq9kJXlBlh3
YBvXCkc+zsp9ZBKsru8wSzlW2bH7BiQm7zRpxH/l2GI7Extdj5nDasxeUTaO
BudNE2xLHlssu9nWODtX5yzYO8TOPbYcO6NaYG+CVVarRmqDrYqzcx52wN7w
2GNR5NXi7E2S58GuKdh3f26N1n+twZbJGpIZvo/mCcOdPc48G/M84uj7aIlw
nLtx9rmIr1z1hT7qRtaoWFG44/zsTdmz62fylBpdKWQNTo/UR/wcqcPy+4Sr
j2Xl2PiMM2DkM1ltLOM9ZIBjaYNlMWL/eJagA1lRWMR3rL8dWwNR6MI29m16
KzYXiXWwtUmfFLMNv5/Z8MwnXJynPlfIIzQ72bBDjZs51LgT2D5mas+r+RbZ
dxPOcxXJuX8AnsnRnUXXbsJq7s6H2bDK/RtPyDCVhXcjeT0CQ7WQwXUS7sbH
YJD9JVHr/Rr0x+XkI1laGfV5EGXuEmcjKwmcM/ME/koDW7iS32GNRlZU86/B
md863G555YPMO5EFpxjeyYtsWP0muN9wVrsTVX535nMqe/cZ0Nr5NXpJJAZP
Mu+OGHzNONYb4NQ7YvD15lPAQ6DXFc1anr0CS/TWpysnztseahmcTxXF31X+
qrlq31Y075096M5CzxXN3ufouDPNvqJbsDd2fhLUoaI6pOWeMJF5N7G83450
BteR9e6Vn1SQ5TJ6qqMLkPR+Y4vrL6sjLDU=\
\>"]], ",", 
   Graphics3DBox[
    {Thickness[Large], Line3DBox[{{0, 0, 0}, {2, 1, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydWGtPE0EUne5uH5RHoRRQYhWJjUgkNioookR8gMbwwZ/QkE3gg9Egf3+j
e++cge3Za7fSpHTvzrln7sx9zFxOR1fn6Y/R1cXZaOPkcvTr/OLs98bxz8v8
VVxzzqX59/sdlz//yZ/0e5plWZSm6Wr+69w3SC7OH1L9uBUd+ZL/jXMxBsK/
/Yy3DZHkwau5no5+BHbGHH0P3VmREj/qAcs6/g7jCyLVr8fB0VXMAWboljj8
+Gtw9EyOJcXsArNWsFIeI5LVDvcc6PWp0EPY16fRmOR5Re+A+wGNJiTPKXob
6M2p0FuwZECjdZLVG24A7sc02iC5rehNoLenQj8AeodGmyRr1Lg+7B7SaMuS
3Tq4X1Rwe/Qa0HsV3KqteSCW7Ft28qo1PuXlwVToDtCH1o6xt9Sj8vJoKnQb
dn+yPM1xo2uVl8eG3ZJgnjMB6quxmlAlSvF+E5nOf6L8e2IguaKMM8haGrkm
ryemSkPzJtf1J//bzPWPMNOcqRMXdPxH5o2gewDdUCezkGc2z4TMD4yhCnH2
spdsVtYSWfZoCFaO/+lYuTY0wBoqD8cb70BksrJnW2B9BNb5W7HyCttg7Wc+
bjvw4MJUbFwB5sAWKsYifrnq877a7BylC2BfInazNpfYq2xYBPsssbMV7E2b
nb3RBXsdrB3sN3uRZ7PZWasH9gjMMtSt8JXNzH5fCTJqUVLYoZVbzdAhOXgz
5GLYobsV7DWTfdHYqeBFYZfnPmE4J2zmJcNTcWG/E2TRpBy2mdlTYQfEFwlO
Cal9fJey2Yu1lj2UgDVUJdkR3mfOpjKr3IGLkRYyh2+GXG1tJs5JEVfByPZz
hahmbIHxHhh5r/+fMXhnE4wccaJay0Vh+gfb2Hkpwha4rKo7mUu0n0Fba069
yC15G5X0eljBLvRmJuqVM5Xjdw88zfG1BeQYR4g+jrL97Cb7iz1QmaGNVXM9
eAuG0HmVNcOdjWuz3CabqJ5lrXCH47ol96I6tOCbMb9aNVjvYlIo0vDxmolR
TY+wzqRkEUfkIWZrmRFSRL4Bp+9eIuxUj1ChG+x422iU6+BLcPpOkv3K2TEE
2vfRDVjAqNDhacUrVX4+/Z6As69oPkHZ2wOgHyqaT3O+FYSebaDoWdjLqPvZ
TR67kn1s/zrQTxXNOc+nUbhLaWdXOj35DFgGt3Z2uvvaBxAq3D5eKaqqJoY+
Sns0naF0ytNqhVt7NGf/R6EBzAfFhI6xGLlRVuivdA+ERPso52p/AdVfNzQ=
\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->480534236]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->255849672],

Cell["Thin and thick frames:", "ExampleText",
 CellID->247876133],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{"x", ",", 
       RowBox[{"{", "4", "}"}], ",", 
       RowBox[{"{", "4", "}"}]}], "]"}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", "Thin"}]}], "]"}], ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{"x", ",", 
       RowBox[{"{", "4", "}"}], ",", 
       RowBox[{"{", "4", "}"}]}], "]"}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}], ",", 
     RowBox[{"FrameStyle", "\[Rule]", "Thick"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5646652],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1ugzAMNr9j3U+32459lV3oaW+wC6omtYdpU9eX6lOyJARhZVAg0MQZ
QYLghMSfHWObkLfitP/4LE6HXbHZHovv/WH3s8m/jqwqCgDgzM7tC7D7kt2J
81yWrHxn15yRNx1UyKgnWa6V8lGW1dMrdn1l1PPoXhBxPOIQrZh+6KHvFXrt
uUMkyxBxw7RufWoEfcyJuKkHyJBc01tq6ZAUTXuLJjDGOdrSDrkTWd4iPQyh
s/LSrIStmoEESwwSHe6XzvhUYlTiCPVSNaFTn3Wgt2CnFqS040soW+0I307C
ryw5Etrjnhsc3WddnvtiMk4SPtVs7I8xV0ei5JTcLpb9pWbQ6KoGTGVBUzNV
VWshKelMWbOeFihb+bX93giNkfCLfVFIzwKmRimV64o8Ws79jjRKdfza8+mh
7Xvf5kDLufOZz+GvdgKBoqoWlcL667w6lz6SL6TyJwMjmIe+U+2yXHv+ab/x
Hh0pdCRiE6FY7Uh2Qzsv9Lk/Xelc/GI1Ye3Nly2dtQy3/xYuedXNFe44j3Z1
xd0lfS+aOwmfqqctytHRTpT4byugdqX0O0wmSEzCr9i1Uwf/Fi45EpLI+Yb3
urQTtdqrCsEv69nboA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{169, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101960617]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 " to draw thin and thick edges:"
}], "ExampleText",
 CellID->386942407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", 
      RowBox[{"EdgeForm", "[", "Thin", "]"}], ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", 
      RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->425061707],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[Tiny]], RectangleBox[{0, 0}]}],
    ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[Large]], 
     RectangleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->128752306]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", "Thin", "]"}], ",", 
       RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
       RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->913846666],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {EdgeForm[Thickness[Tiny]], CuboidBox[{0, 0, 0}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzlmPtOE0EUh5ftbu832tJCgVLKHRECKBTxFmMkXvDyCA2YQKLBIP/7LPpI
vk+jM2d+LNOfE7veookEDu2e7ztzZrvtzvSwd3Hy+m3v4vSo1z447707OT16
3350dq4OJUY8zztWf2/GPfX4i3okf8f9fl8lrHhfxYRKzcqzO3jmn13/4OkH
ffnxZiS7r6KvDoYqq/+35WgXTipyPp6rCGcHTtbKasBkbyCb19ngKut5Lclv
onZxMK9+TX4D/qjOh3ZedzAtzBpqVKkDXwdrjk2hV1GxTnRChSkhlkGMOwi7
3oTQCxi9SXRA9LjQc6g9TXSogumvjXozDsKu1xC6hXodopMqmP6mQMw7CLte
XegJjL5IdIroMaEbqL1CdFoF018N9a45CLteTegK6m0MoatCl0FvxqIL6GSb
6AzRFaFzqL1DdFYF02tWR51RhIZcpF13NJaVI6scy8qrYPrOELnrIO36pVhW
gaziH7SKZBViWSUV4s2lRPXzsawyWTmx0mR1yRpVoRCbtOtnY1kVsjK/0dob
YqVjWVUVzFxSRN5ykHb91D9n1VTI/AHS7iT5C1aSrP3/xBpTIf2DZEjkbQdp
dxL+dUvPRT+tx6K7oP1Pn/vfO8Nu+ybspMNOOY0tGFkyqpERkKHv8XrBVySD
P2cCp72G8apk8+eo2165PJc/ZS/CbpLN9wi33cG8W2Tzfcltz2DsObL5rum2
p2AvOWzzXkuQ0YSxGttowFgng1cDCaddxdnZIpvXLW67jLF3yeZVldsuwN4n
m1dybjsL+x7ZvL40tk92CvN+4Bg7dBoBxjtwjGcZQWSAf0o8r5b9yNXqC6J5
H+AP9qZoLbwii/ca/uDVCYvHclvhEIv3ScbS16pez78kmndphk7TGM8dlnmH
ZYaQiYjMEXlIJO9WR8TKk/UsllXAbGWMb3bN5gosUWW5LgZ26IYruzh0cFWt
QtQTu8/ovFaJeuykauj+qoY9tzrVeKhCEPXRoOxdZM1df4KyXWTNHqBJ2W1k
zR5sEl2t46jZAU+Ts4Ss2Xu3KNtBVizz7YqVnVRBv1jmm5pZytbhLkq2g24q
OLoqR+fJyaLiumQXKBvC3ZbskpWV11V/jkpm+TKD12FPjppvl7yRr6ikooU=
\
\>"]], ",", 
   Graphics3DBox[
    {EdgeForm[Thickness[Large]], CuboidBox[{0, 0, 0}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNl+1OE0EUhhe23ZaW0u9SoNhCGz4CCBI+azX6QzQoqJfQEBJINBjkv9ei
l+T9NDrnnHe3s8dZIyYmknSHPe8z75yZ3Z09eza8u7r8OLy7vhh2Xt4OP11d
X3zunNzcmpA/4Xnepfl9aHrm/x/mP/5djkYjI/DxuTlOmuAynz01x8CcLfHZ
wBxT5sxL3Wx98cI/0frQfCNR2+HoIaKBiZKr54++3pqGxDYT+yCyICYJ8AUh
YJGpXVB5i6L2Aas7UAtQfeXRYuohqFICtcDUBqiqRVErHutQ61BTymOeqRVQ
TYuiVkboQZ2HmlYec0wtg2qBChTVZKoNqm1R1IrHItQlqBnlMcsU5Zw2wS6o
rKIaTDXhtWJR1IpHA+oa1CnlUWeqCmrDoqiVEcpQt6DmlEeNqRlkuw0qr6gq
U9Pw2rUoasUjB3UP6rTyqEQUqQegCooqMzUF6tCiqK3E1KMEj1IiRW3Zqc4o
j6KTKipqJqI4aih6hg8tWlqisvA6hlpSXoVESvJzqWWo7r4VNUI+kZLr5VKr
yiMXUfaMw/WpKZpXxjwh4tm3KLkXXWpdeWQTKbnb76821AiZiLLndHwvOil7
oQNkMPhHlOwdf6baWT9OmGPwF3QaIz/5Dyl7FgOLlv3bRfXxxv09RU961jEy
c+YNJfntGypj2tS37yPXdY3Tu6AzhvYdz1Sc3gadB62f1zi9aWiqPEqg9Q4x
pu1ZrmKMGvIPd4zASfdAN0GXY7SPTLqgFpBJWWWSitEd5N0BrffOON2Cdw+0
3rXj9BzoNeSbTNuzrKPXJnrp94e7VwW9dtBLv7ncvYqY/R7mM40Vlas1iXkU
4H0EKu+kcqAGFmVn4MfoDOhnyDeZtvP1ke8L9NI1x6+9PLo/zO8VstKVzrgH
UW9A6ZpqTFHwHShdn/mxq/8eOWawWqnY82KrtgfnHu21bzGSriaFyihKV6ZC
ZZH1OShdAwsVVk/nyMtN5eF1BkrX5EIV4BVSYfUv6zMDNVzr8BvDi4giRnmt
iPEIZXgQkYr6VdDvFP0kWgN7GuVM0TqiJyaajqINONBdGUQ7SxNsH1GpdubA
7iEqtdgC2G1Epb5tgaWdgO56qcIXEe2ClW+WNhweICpfZh2ws3DocXQJ0QrY
dY52Ec2D3eJoD9EA0UccXcFonm/CuAq0ogesro6k8u7zmXxxehM/ARz/jSg=
\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->613776621]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101466395],

Cell["Plots with thin and thick lines:", "ExampleText",
 CellID->77058257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thin"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->325230780],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{326, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->349551327]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "Thin is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Thickness",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thickness"], "[", 
   ButtonBox["Tiny",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tiny"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->71726306],

Cell[CellGroupData[{

Cell[BoxData["Thin"], "Input",
 CellLabel->"In[1]:=",
 CellID->648065589],

Cell[BoxData[
 RowBox[{"Thickness", "[", "Tiny", "]"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->451695431]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132654253],

Cell[TextData[{
 "Specify the thickness of lines as a fraction of the total width of the \
graphic, using ",
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->25232105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "r", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.02", ",", "0.05"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128720659],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Thickness[0.01], LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[0.02], LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[0.05], LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]}]}], 
  "}"}]], "Output",
 ImageSize->{341, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->473364419]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5136535],

Cell[TextData[{
 "Specify the thickness of lines in units of printer's points, using ",
 Cell[BoxData[
  ButtonBox["AbsoluteThickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteThickness"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->134466735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AbsoluteThickness", "[", "d", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", "2", ",", "5"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6420959],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {AbsoluteThickness[0.5], LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]}], ",",
    
   GraphicsBox[
    {AbsoluteThickness[2], LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]}], ",", 
   GraphicsBox[
    {AbsoluteThickness[5], LineBox[{{1, 0}, {2, 1}, {3, 0}, {4, 1}}]}]}], 
  "}"}]], "Output",
 ImageSize->{341, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->369646736]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27686820],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Thin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thin"]], "InlineFormula"],
 " is absolute thickness, independent of the image size:"
}], "ExampleText",
 CellID->114425692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Thin", ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "100", ",", "150"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->609952428],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Thickness[Tiny], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->50], ",", 
   GraphicsBox[
    {Thickness[Tiny], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->100], ",", 
   GraphicsBox[
    {Thickness[Tiny], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->150]}], "}"}]], "Output",
 ImageSize->{341, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->205945886]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Thick",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thick"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Thickness",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thickness"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteThickness",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteThickness"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->20836170],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->159315553]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Thin - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 34.1603640}", "context" -> "System`", 
    "keywords" -> {
     "thin", "thin lines", "thin edges", "thin 3D lines", "thin 2D lines", 
      "thin grid lines", "thin frame", "thin mesh", "thin contour", 
      "thin curve", "thin arrow", "thin grid", "thin gridlines"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Thin is a graphics directive that specifies that lines which follow \
should be drawn thin.", "synonyms" -> {}, "title" -> "Thin", "type" -> 
    "Symbol", "uri" -> "ref/Thin"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4070, 118, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30045, 898}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1372, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1995, 60, 1569, 37, 70, "ObjectNameGrid"],
Cell[3567, 99, 466, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4070, 118, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4447, 132, 148, 5, 70, "ExampleSection",
 CellID->332222347],
Cell[4598, 139, 72, 1, 70, "ExampleText",
 CellID->568660478],
Cell[CellGroupData[{
Cell[4695, 144, 731, 26, 28, "Input",
 CellID->543815691],
Cell[5429, 172, 383, 12, 75, "Output",
 CellID->303091569]
}, Open  ]],
Cell[CellGroupData[{
Cell[5849, 189, 778, 26, 47, "Input",
 CellID->494817468],
Cell[6630, 217, 3066, 59, 104, "Output",
 CellID->480534236]
}, Open  ]],
Cell[9711, 279, 125, 3, 70, "ExampleDelimiter",
 CellID->255849672],
Cell[9839, 284, 65, 1, 70, "ExampleText",
 CellID->247876133],
Cell[CellGroupData[{
Cell[9929, 289, 668, 20, 47, "Input",
 CellID->5646652],
Cell[10600, 311, 842, 18, 92, "Output",
 Evaluatable->False,
 CellID->101960617]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11491, 335, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[11715, 344, 216, 8, 70, "ExampleText",
 CellID->386942407],
Cell[CellGroupData[{
Cell[11956, 356, 497, 15, 70, "Input",
 CellID->425061707],
Cell[12456, 373, 450, 14, 123, "Output",
 CellID->128752306]
}, Open  ]],
Cell[CellGroupData[{
Cell[12943, 392, 607, 19, 70, "Input",
 CellID->913846666],
Cell[13553, 413, 2939, 59, 131, "Output",
 CellID->613776621]
}, Open  ]],
Cell[16507, 475, 125, 3, 70, "ExampleDelimiter",
 CellID->101466395],
Cell[16635, 480, 74, 1, 70, "ExampleText",
 CellID->77058257],
Cell[CellGroupData[{
Cell[16734, 485, 576, 18, 70, "Input",
 CellID->325230780],
Cell[17313, 505, 4119, 72, 70, "Output",
 Evaluatable->False,
 CellID->349551327]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21481, 583, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[21722, 592, 313, 12, 70, "ExampleText",
 CellID->71726306],
Cell[CellGroupData[{
Cell[22060, 608, 73, 2, 70, "Input",
 CellID->648065589],
Cell[22136, 612, 197, 6, 36, "Output",
 CellID->451695431]
}, Open  ]],
Cell[22348, 621, 125, 3, 70, "ExampleDelimiter",
 CellID->132654253],
Cell[22476, 626, 272, 9, 70, "ExampleText",
 CellID->25232105],
Cell[CellGroupData[{
Cell[22773, 639, 735, 25, 70, "Input",
 CellID->128720659],
Cell[23511, 666, 506, 15, 60, "Output",
 CellID->473364419]
}, Open  ]],
Cell[24032, 684, 123, 3, 70, "ExampleDelimiter",
 CellID->5136535],
Cell[24158, 689, 268, 8, 70, "ExampleText",
 CellID->134466735],
Cell[CellGroupData[{
Cell[24451, 701, 731, 24, 70, "Input",
 CellID->6420959],
Cell[25185, 727, 527, 16, 60, "Output",
 CellID->369646736]
}, Open  ]],
Cell[25727, 746, 124, 3, 70, "ExampleDelimiter",
 CellID->27686820],
Cell[25854, 751, 223, 7, 70, "ExampleText",
 CellID->114425692],
Cell[CellGroupData[{
Cell[26102, 762, 622, 21, 70, "Input",
 CellID->609952428],
Cell[26727, 785, 462, 16, 101, "Output",
 CellID->205945886]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27250, 808, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[27569, 819, 714, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[28320, 850, 318, 9, 70, "MoreAboutSection",
 CellID->20836170],
Cell[28641, 861, 149, 3, 70, "MoreAbout",
 CellID->159315553]
}, Open  ]],
Cell[28805, 867, 27, 0, 70, "History"],
Cell[28835, 869, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

