(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     55769,       2144]
NotebookOptionsPosition[     44093,       1735]
NotebookOutlinePosition[     45604,       1775]
CellTagsIndexPosition[     45518,       1770]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Structural Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Structural Operations\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Distribute" :> 
          Documentation`HelpLookup["paclet:ref/Distribute"], "Map" :> 
          Documentation`HelpLookup["paclet:ref/Map"], "Inner" :> 
          Documentation`HelpLookup["paclet:ref/Inner"], "MapThread" :> 
          Documentation`HelpLookup["paclet:ref/MapThread"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Distribute\"\>", 2->"\<\"Map\"\>", 
       3->"\<\"Inner\"\>", 4->"\<\"MapThread\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions to Lists" :> 
          Documentation`HelpLookup["paclet:guide/ApplyingFunctionsToLists"], 
          "Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Manipulating Equations" :> 
          Documentation`HelpLookup["paclet:guide/ManipulatingEquations"], 
          "Structural Operations on Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/StructuralOperationsOnExpressions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Applying Functions to Lists\"\>", 
       2->"\<\"Expressions\"\>", 3->"\<\"List Manipulation\"\>", 
       4->"\<\"Manipulating Equations\"\>", 
       5->"\<\"Structural Operations on Expressions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Thread", "ObjectName",
 CellID->14463],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Thread",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Thread"], "[", 
       RowBox[{
        StyleBox["f", "TI"], "[", 
        StyleBox["args", "TI"], "]"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]\[OpenCurlyDoubleQuote]threads\[CloseCurlyDoubleQuote] \
",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " over any lists that appear in ",
     Cell[BoxData[
      StyleBox["args", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Thread",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Thread"], "[", 
       RowBox[{
        RowBox[{
         StyleBox["f", "TI"], "[", 
         StyleBox["args", "TI"], "]"}], ",", 
        StyleBox["h", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]threads ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " over any objects with head ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     " that appear in ",
     Cell[BoxData[
      StyleBox["args", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Thread",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Thread"], "[", 
       RowBox[{
        RowBox[{
         StyleBox["f", "TI"], "[", 
         StyleBox["args", "TI"], "]"}], ",", 
        StyleBox["h", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]threads ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " over objects with head ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     " that appear in the first ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " ",
     Cell[BoxData[
      StyleBox["args", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->29053]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Functions with attribute ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 " are automatically threaded over lists. "
}], "Notes",
 CellID->3505],

Cell[TextData[{
 "All the elements in the specified ",
 Cell[BoxData[
  StyleBox["args", "TI"]], "InlineFormula"],
 " whose heads are ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " must be of the same length. "
}], "Notes",
 CellID->15741],

Cell[TextData[{
 "Arguments that do not have head ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 " are copied as many times as there are elements in the arguments that do \
have head ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->474608358,
  ButtonNote->"474608358"]
}], "Notes",
 CellID->21267],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 " specifies arguments using the standard sequence specification:"
}], "Notes",
 CellID->19662],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell["all elements", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["no elements", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "elements ",
     Cell[BoxData["1"], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", 
     StyleBox["n", "TI"]}], Cell[TextData[{
     "last ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " elements"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox["n", "TI"], "}"}], Cell[TextData[{
     "element ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " only"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      StyleBox["n", "TI"]}], "}"}], Cell[TextData[{
     "elements ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " inclusive"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["m", "TI"], ",", 
      StyleBox["n", "TI"], ",", 
      StyleBox["s", "TI"]}], "}"}], Cell[TextData[{
     "elements ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " in steps of ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->29655]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->577392162],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->432882382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"f", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14523],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "c", "]"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8243]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12365],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "x"}], "]"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4718]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17135],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "y"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "z"}], "]"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->16937]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4599],

Cell["Convert equations for lists to lists of equations:", "ExampleText",
 CellID->31499],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], "==", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13192],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Equal]", "x"}], ",", 
   RowBox[{"b", "\[Equal]", "y"}], ",", 
   RowBox[{"c", "\[Equal]", "z"}]}], "}"}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30554]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19124],

Cell["Apply a function to both sides of an equation:", "ExampleText",
 CellID->31],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"x", "==", "y"}], "]"}], ",", "Equal"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28066],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", "x", "]"}], "\[Equal]", 
  RowBox[{"Log", "[", "y", "]"}]}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26429]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29556],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Sequence Specifications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->89594218],

Cell["By default, thread over all arguments:", "ExampleText",
 CellID->516540581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "s"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", "List"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1132280624],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "r", ",", "u", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "s", ",", "v", ",", "y"}], "]"}]}], "}"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->683633691]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "s"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", "List", ",", "All"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2026291933],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "r", ",", "u", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "s", ",", "v", ",", "y"}], "]"}]}], "}"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1674873629]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4355166],

Cell["Do not thread at all:", "ExampleText",
 CellID->1005873605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "s"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", "List", ",", "None"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1269617450],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "s"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Output",
 ImageSize->{216, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1780705711]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->399193565],

Cell["Thread over the first two arguments only:", "ExampleText",
 CellID->1364709470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "s"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", "List", ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1212730026],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "r", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "s", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{324, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1747954878]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1802630487],

Cell["Thread over the last two arguments only:", "ExampleText",
 CellID->659889116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "s"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", "List", ",", 
   RowBox[{"-", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->694771067],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "s"}], "}"}], ",", "u", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "s"}], "}"}], ",", "v", ",", "y"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{324, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1266179165]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->697715823],

Cell["Thread over argument 2 only:", "ExampleText",
 CellID->1306815397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "s"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", "List", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->440354552],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "r", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "s", ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{388, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1771971873]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->893235003],

Cell["Thread over arguments 2 through 4:", "ExampleText",
 CellID->1031392189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "s"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", "List", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1521764788],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "r", ",", "u", ",", "x"}], "]"}], 
   ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "s", ",", "v", ",", "y"}], "]"}]}],
   "}"}]], "Output",
 ImageSize->{259, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123117635]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->935699176],

Cell["Thread over every other argument:", "ExampleText",
 CellID->891604522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "s"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", "List", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1789268985],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "s"}], "}"}], ",", "u", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", 
     RowBox[{"{", 
      RowBox[{"r", ",", "s"}], "}"}], ",", "v", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{324, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->388151652]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Head Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->325993866],

Cell["By default, thread over lists:", "ExampleText",
 CellID->716843823],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1401121717],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "c"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "d"}], "]"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1736809055]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "]"}], ",", "List"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->485604504],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "c"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "d"}], "]"}]}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1911858326]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->632939265],

Cell["By default, does not thread over heads other than list:", "ExampleText",
 CellID->315755270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"a", "+", "b"}], ",", 
    RowBox[{"c", "+", "d"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->96761033],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"a", "+", "b"}], ",", 
   RowBox[{"c", "+", "d"}]}], "]"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1095703291]
}, Open  ]],

Cell[TextData[{
 "Thread with respect to ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1507766930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"a", "+", "b"}], ",", 
     RowBox[{"c", "+", "d"}]}], "]"}], ",", "Plus"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1205603115],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a", ",", "c"}], "]"}], "+", 
  RowBox[{"f", "[", 
   RowBox[{"b", ",", "d"}], "]"}]}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1922302714]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13818],

Cell["Elements that are not lists are repeated:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->474608358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "h", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->655563212],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "h", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "h", ",", "y"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "h", ",", "z"}], "]"}]}], "}"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->558417889]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "^", "2"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->278661940],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "4", ",", "9"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->186804950]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27277],

Cell["Build a list of rules:", "ExampleText",
 CellID->764729615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1479493117],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"a", "\[Rule]", "1"}], ",", 
   RowBox[{"b", "\[Rule]", "2"}], ",", 
   RowBox[{"c", "\[Rule]", "3"}]}], "}"}]], "Output",
 ImageSize->{131, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26454483]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1388745373],

Cell["Equate coefficients in a polynomial equation:", "ExampleText",
 CellID->714823927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CoefficientList", "[", 
    RowBox[{"#", ",", "x"}], "]"}], "&"}], "/@", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"2", "x"}], "+", 
     RowBox[{"3", 
      RowBox[{"x", "^", "2"}]}]}], "\[Equal]", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], " ", "+", " ", 
     RowBox[{"c", " ", 
      RowBox[{"x", "^", "2"}]}]}]}], ")"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1789511824],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "\[Equal]", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86744443]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->70361311],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Equal]", "a"}], ",", 
   RowBox[{"2", "\[Equal]", "b"}], ",", 
   RowBox[{"3", "\[Equal]", "c"}]}], "}"}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->174994570]
}, Open  ]],

Cell[TextData[{
 "Alternatively use ",
 Cell[BoxData[
  ButtonBox["SolveAlways",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SolveAlways"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->115959290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SolveAlways", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"2", "x"}], "+", 
     RowBox[{"3", 
      RowBox[{"x", "^", "2"}]}]}], "\[Equal]", 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "x"}], " ", "+", " ", 
     RowBox[{"c", " ", 
      RowBox[{"x", "^", "2"}]}]}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->695610344],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", "1"}], ",", 
    RowBox[{"b", "\[Rule]", "2"}], ",", 
    RowBox[{"c", "\[Rule]", "3"}]}], "}"}], "}"}]], "Output",
 ImageSize->{145, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2001699]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1025318917],

Cell["Form pairs with a constant second element:", "ExampleText",
 CellID->1937500752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "0"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1489401594],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->410520203]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31826],

Cell[TextData[{
 "Functions with attribute ",
 Cell[BoxData[
  ButtonBox["Listable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Listable"]], "InlineFormula"],
 " are threaded automatically over lists:"
}], "ExampleText",
 CellID->284575530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1883510521],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   SqrtBox["2"], ",", 
   SqrtBox["3"], ",", "2"}], "}"}]], "Output",
 ImageSize->{114, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305720399]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "+", "1"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1340569878],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "3", ",", "4", ",", "5"}], "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->123574719]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "+", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1847982373],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", "a"}], ",", 
   RowBox[{"2", "+", "b"}], ",", 
   RowBox[{"3", "+", "c"}], ",", 
   RowBox[{"4", "+", "d"}]}], "}"}]], "Output",
 ImageSize->{159, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->331526972]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->869319521],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapThread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapThread"]], "InlineFormula"],
 " works like ",
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 ", but takes the function and arguments separately:"
}], "ExampleText",
 CellID->280322633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->401818638],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "y"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "z"}], "]"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->508871428]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->139695211],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "y"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "z"}], "]"}]}], "}"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->377218547]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1046648301],

Cell["The function to thread over can be List as well:", "ExampleText",
 CellID->1448463317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2087052524],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "z"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->538937056]
}, Open  ]],

Cell["In this case, the result is the same as a transposition:", "ExampleText",
 CellID->1939837030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->838762642],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "z"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->477054400]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29348],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Thread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thread"]], "InlineFormula"],
 " evaluates the whole expression before threading:"
}], "ExampleText",
 CellID->166134388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"x", " ", "y"}], ",", " ", 
      RowBox[{"x", " ", "z"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->328141533],

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "::", "\<\"dvar\"\>"}], ":", 
  " ", "\<\"Multiple derivative specifier \\!\\({x, y, z}\\) does not have \
the form {variable, n}, where n is a non-negative machine integer. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/D/dvar\\\", ButtonNote \
-> \\\"D::dvar\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->204925499],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "x", ",", "x"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172433972]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapThread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapThread"]], "InlineFormula"],
 " takes the function and its arguments separately:"
}], "ExampleText",
 CellID->1608977100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"D", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"x", " ", "y"}], ",", 
       RowBox[{"x", " ", "z"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->591599609],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "x", ",", "x"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->63311552]
}, Open  ]],

Cell["Suppressing evaluation has a similar effect:", "ExampleText",
 CellID->1944160648],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{"Unevaluated", "[", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"x", " ", "y"}], ",", " ", 
       RowBox[{"x", " ", "z"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1698268575],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "x", ",", "x"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->28721807]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25094],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Distribute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Distribute"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Map",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Map"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inner",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inner"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MapThread",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapThread"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19670]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14081],

Cell[TextData[ButtonBox["Structural Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StructuralOperations"]], "Tutorials",
 CellID->9695]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Thread",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Thread"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->445694338],

Cell[TextData[ButtonBox["Applying Functions to Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ApplyingFunctionsToLists"]], "MoreAbout",
 CellID->685224855],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->598425598],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->356649834],

Cell[TextData[ButtonBox["Manipulating Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ManipulatingEquations"]], "MoreAbout",
 CellID->12447137],

Cell[TextData[ButtonBox["Structural Operations on Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StructuralOperationsOnExpressions"]], "MoreAbout",
 CellID->28555560]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Thread - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 38.5979776}", "context" -> "System`", 
    "keywords" -> {
     "implementing listability", "threading operations over equations", 
      "threading over lists"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Thread[f[args]] \\[OpenCurlyDoubleQuote]threads\\[CloseCurlyDoubleQuote] \
f over any lists that appear in args. Thread[f[args], h] threads f over any \
objects with head h that appear in args. Thread[f[args], h, n] threads f over \
objects with head h that appear in the first n args. ", "synonyms" -> {"zip"},
     "title" -> "Thread", "type" -> "Symbol", "uri" -> "ref/Thread"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9329, 307, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->577392162]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 45375, 1763}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2671, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3294, 89, 44, 1, 70, "ObjectName",
 CellID->14463],
Cell[3341, 92, 2162, 72, 70, "Usage",
 CellID->29053]
}, Open  ]],
Cell[CellGroupData[{
Cell[5540, 169, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6018, 186, 236, 8, 70, "Notes",
 CellID->3505],
Cell[6257, 196, 255, 9, 70, "Notes",
 CellID->15741],
Cell[6515, 207, 405, 14, 70, "Notes",
 CellID->21267],
Cell[6923, 223, 226, 7, 70, "Notes",
 CellID->19662],
Cell[7152, 232, 2140, 70, 70, "2ColumnTableMod",
 CellID->29655]
}, Closed]],
Cell[CellGroupData[{
Cell[9329, 307, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->577392162],
Cell[CellGroupData[{
Cell[9714, 321, 148, 5, 70, "ExampleSection",
 CellID->432882382],
Cell[CellGroupData[{
Cell[9887, 330, 185, 6, 28, "Input",
 CellID->14523],
Cell[10075, 338, 296, 10, 36, "Output",
 CellID->8243]
}, Open  ]],
Cell[CellGroupData[{
Cell[10408, 353, 214, 8, 28, "Input",
 CellID->12365],
Cell[10625, 363, 371, 13, 36, "Output",
 CellID->4718]
}, Open  ]],
Cell[CellGroupData[{
Cell[11033, 381, 272, 9, 28, "Input",
 CellID->17135],
Cell[11308, 392, 372, 13, 36, "Output",
 CellID->16937]
}, Open  ]],
Cell[11695, 408, 120, 3, 70, "ExampleDelimiter",
 CellID->4599],
Cell[11818, 413, 89, 1, 70, "ExampleText",
 CellID->31499],
Cell[CellGroupData[{
Cell[11932, 418, 240, 8, 70, "Input",
 CellID->13192],
Cell[12175, 428, 303, 10, 36, "Output",
 CellID->30554]
}, Open  ]],
Cell[12493, 441, 121, 3, 70, "ExampleDelimiter",
 CellID->19124],
Cell[12617, 446, 82, 1, 70, "ExampleText",
 CellID->31],
Cell[CellGroupData[{
Cell[12724, 451, 182, 6, 70, "Input",
 CellID->28066],
Cell[12909, 459, 244, 8, 36, "Output",
 CellID->26429]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13202, 473, 216, 7, 70, "ExampleSection",
 CellID->29556],
Cell[CellGroupData[{
Cell[13443, 484, 243, 7, 70, "ExampleSubsection",
 CellID->89594218],
Cell[13689, 493, 81, 1, 70, "ExampleText",
 CellID->516540581],
Cell[CellGroupData[{
Cell[13795, 498, 417, 15, 70, "Input",
 CellID->1132280624],
Cell[14215, 515, 352, 11, 36, "Output",
 CellID->683633691]
}, Open  ]],
Cell[CellGroupData[{
Cell[14604, 531, 430, 15, 70, "Input",
 CellID->2026291933],
Cell[15037, 548, 353, 11, 36, "Output",
 CellID->1674873629]
}, Open  ]],
Cell[15405, 562, 123, 3, 70, "ExampleDelimiter",
 CellID->4355166],
Cell[15531, 567, 65, 1, 70, "ExampleText",
 CellID->1005873605],
Cell[CellGroupData[{
Cell[15621, 572, 431, 15, 70, "Input",
 CellID->1269617450],
Cell[16055, 589, 426, 15, 36, "Output",
 CellID->1780705711]
}, Open  ]],
Cell[16496, 607, 125, 3, 70, "ExampleDelimiter",
 CellID->399193565],
Cell[16624, 612, 85, 1, 70, "ExampleText",
 CellID->1364709470],
Cell[CellGroupData[{
Cell[16734, 617, 428, 15, 70, "Input",
 CellID->1212730026],
Cell[17165, 634, 565, 19, 36, "Output",
 CellID->1747954878]
}, Open  ]],
Cell[17745, 656, 126, 3, 70, "ExampleDelimiter",
 CellID->1802630487],
Cell[17874, 661, 83, 1, 70, "ExampleText",
 CellID->659889116],
Cell[CellGroupData[{
Cell[17982, 666, 443, 15, 70, "Input",
 CellID->694771067],
Cell[18428, 683, 568, 20, 36, "Output",
 CellID->1266179165]
}, Open  ]],
Cell[19011, 706, 125, 3, 70, "ExampleDelimiter",
 CellID->697715823],
Cell[19139, 711, 72, 1, 70, "ExampleText",
 CellID->1306815397],
Cell[CellGroupData[{
Cell[19236, 716, 448, 15, 70, "Input",
 CellID->440354552],
Cell[19687, 733, 671, 23, 36, "Output",
 CellID->1771971873]
}, Open  ]],
Cell[20373, 759, 125, 3, 70, "ExampleDelimiter",
 CellID->893235003],
Cell[20501, 764, 78, 1, 70, "ExampleText",
 CellID->1031392189],
Cell[CellGroupData[{
Cell[20604, 769, 474, 16, 70, "Input",
 CellID->1521764788],
Cell[21081, 787, 465, 17, 36, "Output",
 CellID->123117635]
}, Open  ]],
Cell[21561, 807, 125, 3, 70, "ExampleDelimiter",
 CellID->935699176],
Cell[21689, 812, 76, 1, 70, "ExampleText",
 CellID->891604522],
Cell[CellGroupData[{
Cell[21790, 817, 505, 17, 70, "Input",
 CellID->1789268985],
Cell[22298, 836, 564, 19, 36, "Output",
 CellID->388151652]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22911, 861, 239, 7, 70, "ExampleSubsection",
 CellID->325993866],
Cell[23153, 870, 73, 1, 70, "ExampleText",
 CellID->716843823],
Cell[CellGroupData[{
Cell[23251, 875, 257, 9, 70, "Input",
 CellID->1401121717],
Cell[23511, 886, 313, 11, 36, "Output",
 CellID->1736809055]
}, Open  ]],
Cell[CellGroupData[{
Cell[23861, 902, 290, 11, 70, "Input",
 CellID->485604504],
Cell[24154, 915, 313, 11, 36, "Output",
 CellID->1911858326]
}, Open  ]],
Cell[24482, 929, 125, 3, 70, "ExampleDelimiter",
 CellID->632939265],
Cell[24610, 934, 98, 1, 70, "ExampleText",
 CellID->315755270],
Cell[CellGroupData[{
Cell[24733, 939, 203, 7, 70, "Input",
 CellID->96761033],
Cell[24939, 948, 257, 9, 36, "Output",
 CellID->1095703291]
}, Open  ]],
Cell[25211, 960, 199, 8, 70, "ExampleText",
 CellID->1507766930],
Cell[CellGroupData[{
Cell[25435, 972, 235, 8, 70, "Input",
 CellID->1205603115],
Cell[25673, 982, 286, 10, 36, "Output",
 CellID->1922302714]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[26020, 999, 239, 7, 70, "ExampleSection",
 CellID->13818],
Cell[26262, 1008, 132, 2, 70, "ExampleText",
 CellID->474608358],
Cell[CellGroupData[{
Cell[26419, 1014, 286, 9, 70, "Input",
 CellID->655563212],
Cell[26708, 1025, 406, 13, 36, "Output",
 CellID->558417889]
}, Open  ]],
Cell[CellGroupData[{
Cell[27151, 1043, 149, 5, 70, "Input",
 CellID->278661940],
Cell[27303, 1050, 213, 7, 36, "Output",
 CellID->186804950]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27565, 1063, 223, 7, 70, "ExampleSection",
 CellID->27277],
Cell[27791, 1072, 65, 1, 70, "ExampleText",
 CellID->764729615],
Cell[CellGroupData[{
Cell[27881, 1077, 250, 8, 70, "Input",
 CellID->1479493117],
Cell[28134, 1087, 303, 10, 36, "Output",
 CellID->26454483]
}, Open  ]],
Cell[28452, 1100, 126, 3, 70, "ExampleDelimiter",
 CellID->1388745373],
Cell[28581, 1105, 88, 1, 70, "ExampleText",
 CellID->714823927],
Cell[CellGroupData[{
Cell[28694, 1110, 462, 16, 70, "Input",
 CellID->1789511824],
Cell[29159, 1128, 301, 10, 36, "Output",
 CellID->86744443]
}, Open  ]],
Cell[CellGroupData[{
Cell[29497, 1143, 101, 3, 70, "Input",
 CellID->70361311],
Cell[29601, 1148, 307, 10, 36, "Output",
 CellID->174994570]
}, Open  ]],
Cell[29923, 1161, 207, 8, 70, "ExampleText",
 CellID->115959290],
Cell[CellGroupData[{
Cell[30155, 1173, 389, 13, 70, "Input",
 CellID->695610344],
Cell[30547, 1188, 329, 11, 36, "Output",
 CellID->2001699]
}, Open  ]],
Cell[30891, 1202, 126, 3, 70, "ExampleDelimiter",
 CellID->1025318917],
Cell[31020, 1207, 86, 1, 70, "ExampleText",
 CellID->1937500752],
Cell[CellGroupData[{
Cell[31131, 1212, 214, 8, 70, "Input",
 CellID->1489401594],
Cell[31348, 1222, 361, 13, 36, "Output",
 CellID->410520203]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31758, 1241, 233, 7, 70, "ExampleSection",
 CellID->31826],
Cell[31994, 1250, 246, 8, 70, "ExampleText",
 CellID->284575530],
Cell[CellGroupData[{
Cell[32265, 1262, 168, 5, 70, "Input",
 CellID->1883510521],
Cell[32436, 1269, 250, 9, 43, "Output",
 CellID->305720399]
}, Open  ]],
Cell[CellGroupData[{
Cell[32723, 1283, 160, 5, 70, "Input",
 CellID->1340569878],
Cell[32886, 1290, 223, 7, 36, "Output",
 CellID->123574719]
}, Open  ]],
Cell[CellGroupData[{
Cell[33146, 1302, 227, 7, 70, "Input",
 CellID->1847982373],
Cell[33376, 1311, 320, 11, 36, "Output",
 CellID->331526972]
}, Open  ]],
Cell[33711, 1325, 125, 3, 70, "ExampleDelimiter",
 CellID->869319521],
Cell[33839, 1330, 361, 12, 70, "ExampleText",
 CellID->280322633],
Cell[CellGroupData[{
Cell[34225, 1346, 303, 10, 70, "Input",
 CellID->401818638],
Cell[34531, 1358, 376, 13, 36, "Output",
 CellID->508871428]
}, Open  ]],
Cell[CellGroupData[{
Cell[34944, 1376, 276, 9, 70, "Input",
 CellID->139695211],
Cell[35223, 1387, 376, 13, 36, "Output",
 CellID->377218547]
}, Open  ]],
Cell[35614, 1403, 126, 3, 70, "ExampleDelimiter",
 CellID->1046648301],
Cell[35743, 1408, 92, 1, 70, "ExampleText",
 CellID->1448463317],
Cell[CellGroupData[{
Cell[35860, 1413, 272, 9, 70, "Input",
 CellID->2087052524],
Cell[36135, 1424, 361, 13, 36, "Output",
 CellID->538937056]
}, Open  ]],
Cell[36511, 1440, 100, 1, 70, "ExampleText",
 CellID->1939837030],
Cell[CellGroupData[{
Cell[36636, 1445, 274, 9, 70, "Input",
 CellID->838762642],
Cell[36913, 1456, 361, 13, 36, "Output",
 CellID->477054400]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37323, 1475, 226, 7, 70, "ExampleSection",
 CellID->29348],
Cell[37552, 1484, 222, 7, 70, "ExampleText",
 CellID->166134388],
Cell[CellGroupData[{
Cell[37799, 1495, 335, 11, 70, "Input",
 CellID->328141533],
Cell[38137, 1508, 437, 8, 70, "Message",
 CellID->204925499],
Cell[38577, 1518, 213, 7, 36, "Output",
 CellID->172433972]
}, Open  ]],
Cell[38805, 1528, 229, 7, 70, "ExampleText",
 CellID->1608977100],
Cell[CellGroupData[{
Cell[39059, 1539, 359, 12, 70, "Input",
 CellID->591599609],
Cell[39421, 1553, 212, 7, 36, "Output",
 CellID->63311552]
}, Open  ]],
Cell[39648, 1563, 88, 1, 70, "ExampleText",
 CellID->1944160648],
Cell[CellGroupData[{
Cell[39761, 1568, 385, 13, 70, "Input",
 CellID->1698268575],
Cell[40149, 1583, 212, 7, 36, "Output",
 CellID->28721807]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40422, 1597, 311, 9, 70, "SeeAlsoSection",
 CellID->25094],
Cell[40736, 1608, 931, 35, 70, "SeeAlso",
 CellID->19670]
}, Open  ]],
Cell[CellGroupData[{
Cell[41704, 1648, 314, 9, 70, "TutorialsSection",
 CellID->14081],
Cell[42021, 1659, 151, 3, 70, "Tutorials",
 CellID->9695]
}, Open  ]],
Cell[CellGroupData[{
Cell[42209, 1667, 305, 8, 70, "RelatedLinksSection"],
Cell[42517, 1677, 357, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42911, 1694, 319, 9, 70, "MoreAboutSection",
 CellID->445694338],
Cell[43233, 1705, 163, 3, 70, "MoreAbout",
 CellID->685224855],
Cell[43399, 1710, 134, 3, 70, "MoreAbout",
 CellID->598425598],
Cell[43536, 1715, 145, 3, 70, "MoreAbout",
 CellID->356649834],
Cell[43684, 1720, 154, 3, 70, "MoreAbout",
 CellID->12447137],
Cell[43841, 1725, 180, 3, 70, "MoreAbout",
 CellID->28555560]
}, Open  ]],
Cell[44036, 1731, 27, 0, 70, "History"],
Cell[44066, 1733, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

