(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     42233,       1661]
NotebookOptionsPosition[     32984,       1327]
NotebookOutlinePosition[     34645,       1374]
CellTagsIndexPosition[     34532,       1368]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Loops and Control Structures" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LoopsAndControlStructures"], "Messages" :> 
          Documentation`HelpLookup["paclet:tutorial/Messages"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Loops and Control Structures\"\>", 
       2->"\<\"Messages\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Catch" :> Documentation`HelpLookup["paclet:ref/Catch"], 
          "Return" :> Documentation`HelpLookup["paclet:ref/Return"], "Goto" :> 
          Documentation`HelpLookup["paclet:ref/Goto"], "Interrupt" :> 
          Documentation`HelpLookup["paclet:ref/Interrupt"], "Abort" :> 
          Documentation`HelpLookup["paclet:ref/Abort"], "Sow" :> 
          Documentation`HelpLookup["paclet:ref/Sow"], "NestWhile" :> 
          Documentation`HelpLookup["paclet:ref/NestWhile"], "For" :> 
          Documentation`HelpLookup["paclet:ref/For"], "While" :> 
          Documentation`HelpLookup["paclet:ref/While"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Catch\"\>", 2->"\<\"Return\"\>", 
       3->"\<\"Goto\"\>", 4->"\<\"Interrupt\"\>", 5->"\<\"Abort\"\>", 
       6->"\<\"Sow\"\>", 7->"\<\"NestWhile\"\>", 8->"\<\"For\"\>", 
       9->"\<\"While\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flow Control" :> 
          Documentation`HelpLookup["paclet:guide/FlowControl"], 
          "Looping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/LoopingConstructs"], 
          "Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"], 
          "Scoping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/ScopingConstructs"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Flow Control\"\>", 
       2->"\<\"Looping Constructs\"\>", 3->"\<\"Procedural Programming\"\>", 
       4->"\<\"Scoping Constructs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Throw", "ObjectName",
 CellID->13037],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Throw",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Throw"], "[", 
       StyleBox["value", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]stops evaluation and returns ",
     Cell[BoxData[
      StyleBox["value", "TI"]], "InlineFormula"],
     " as the value of the nearest enclosing ",
     Cell[BoxData[
      ButtonBox["Catch",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Throw",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Throw"], "[", 
       RowBox[{
        StyleBox["value", "TI"], ",", 
        StyleBox["tag", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is caught only by ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Catch",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Catch"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
     " where ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " is a pattern that matches ",
     Cell[BoxData[
      StyleBox["tag", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->19035]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " to exit functions such as ",
 Cell[BoxData[
  ButtonBox["Nest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nest"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Fold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fold"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FixedPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPoint"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1699],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["tag", "TI"]], "InlineFormula"],
 " can be any expression. "
}], "Notes",
 CellID->13316],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["tag", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Throw",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Throw"], "[", 
   RowBox[{
    StyleBox["value", "TI"], ",", 
    StyleBox["tag", "TI"]}], "]"}]], "InlineFormula"],
 " is re\[Hyphen]evaluated every time it is compared to ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Catch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Catch"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->1890],

Cell[TextData[{
 "An error is generated and an unevaluated ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " is returned if there is no appropriate enclosing ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " to catch the ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13367]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4544876],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->292057518],

Cell[TextData[{
 "Exit to the enclosing ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " as soon as ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " is evaluated:"
}], "ExampleText",
 CellID->21531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"a", ";", "b", ";", 
   RowBox[{"Throw", "[", "c", "]"}], ";", "d", ";", "e"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2829],

Cell[BoxData["c"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31782]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32705],

Cell["Define a function that can \"throw an exception\":", "ExampleText",
 CellID->26162],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"If", "[", 
   RowBox[{
    RowBox[{"x", ">", "10"}], ",", 
    RowBox[{"Throw", "[", "overflow", "]"}], ",", 
    RowBox[{"x", "!"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15689],

Cell[TextData[{
 "The result of ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " is just what is thrown by ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->15923],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{"f", "[", "2", "]"}], "+", 
   RowBox[{"f", "[", "11", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30870],

Cell[BoxData["overflow"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25342]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{"f", "[", "2", "]"}], "+", 
   RowBox[{"f", "[", "3", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->9282],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->14196]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12180],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " to exit a loop when a criterion is satisfied:"
}], "ExampleText",
 CellID->19969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"i", "!"}], ">", 
       RowBox[{"10", "^", "10"}]}], ",", 
      RowBox[{"Throw", "[", "i", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19072],

Cell[BoxData["14"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18715]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24736],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " works inside essentially any function:"
}], "ExampleText",
 CellID->11755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"#", "<", "0"}], ",", 
      RowBox[{"Throw", "[", "#", "]"}]}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "0", ",", 
     RowBox[{"-", "1"}], ",", "5", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15174],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18477]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", 
    RowBox[{"Throw", "[", "b", "]"}], ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1154],

Cell[BoxData["b"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24729]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", "2"}], "+", 
    RowBox[{"b", "^", "2"}], "+", 
    RowBox[{"c", "^", "2"}]}], "/.", 
   RowBox[{"b", ":>", 
    RowBox[{"Throw", "[", "bbb", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10882],

Cell[BoxData["bbb"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->15851]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19769],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " to throw any type of expression:"
}], "ExampleText",
 CellID->11237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"NumericQ", "[", "#", "]"}], ",", 
      RowBox[{"Throw", "[", "#", "]"}]}], "]"}], "&"}], "//@", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "5"}], "-", "1"}], ")"}]}], ",", "x"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28301],

Cell[BoxData[
 FractionBox["1", "20"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15676]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13604],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " is caught by the nearest enclosing ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->27073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Catch", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"Throw", "[", "b", "]"}], ",", "c"}], "}"}], "]"}], ",", "d", 
    ",", "e"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24161],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "d", ",", "e"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21197]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8595],

Cell[TextData[{
 "As soon as the first ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " is evaluated, it exits to the enclosing ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Throw", "[", "a", "]"}], ",", 
    RowBox[{"Throw", "[", "b", "]"}], ",", 
    RowBox[{"Throw", "[", "c", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5485],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15062]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"Throw", "/@", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29229],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->27560]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7718],

Cell[TextData[{
 "Catch ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " with tag ",
 Cell[BoxData["u"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->29073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{"Throw", "[", 
    RowBox[{"a", ",", "u"}], "]"}], ",", "u"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8079],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8709]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9662],

Cell[TextData[{
 "The inner ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " catches ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->10224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Throw", "[", 
       RowBox[{"a", ",", "u"}], "]"}], ",", "u"}], "]"}], "]"}], ",", "v"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11574],

Cell[BoxData[
 RowBox[{"f", "[", "a", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7682]
}, Open  ]],

Cell[TextData[{
 "The outer ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 " catches ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"Catch", "[", 
     RowBox[{
      RowBox[{"Throw", "[", 
       RowBox[{"a", ",", "u"}], "]"}], ",", "v"}], "]"}], "]"}], ",", "u"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28815],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29343]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27446],

Cell["Keep the tag local:", "ExampleText",
 CellID->27532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "u", "}"}], ",", 
   RowBox[{"Catch", "[", 
    RowBox[{
     RowBox[{"Throw", "[", 
      RowBox[{"a", ",", "u"}], "]"}], ",", "u"}], "]"}]}], "]"}]], "Input",
 CellTags->"S2.6.10",
 CellLabel->"In[1]:=",
 CellID->14568],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"S2.6.10",
 CellLabel->"Out[1]=",
 CellID->32684]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5472],

Cell[TextData[{
 "Find the next prime after ",
 Cell[BoxData[
  SuperscriptBox["10", "10"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->25286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"PrimeQ", "[", "i", "]"}], ",", 
      RowBox[{"Throw", "[", "i", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"10", "^", "10"}], ",", 
      RowBox[{
       RowBox[{"10", "^", "10"}], "+", "1000"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8266],

Cell[BoxData["10000000019"], "Output",
 ImageSize->{88, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6089]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32151],

Cell["Find the first power of 17 equal to 1 mod 19:", "ExampleText",
 CellID->4604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Mod", "[", 
        RowBox[{
         RowBox[{"17", "^", "i"}], ",", "19"}], "]"}], "==", "1"}], ",", 
      RowBox[{"Throw", "[", "i", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "19"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17233],

Cell[BoxData["9"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25594]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9076],

Cell["Stop if an iteration gets too large:", "ExampleText",
 CellID->598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "^", "2"}], "+", "1"}], "&"}], ",", "2", ",", "6"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18604],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "5", ",", "26", ",", "677", ",", "458330", ",", "210066388901", 
   ",", "44127887745906175987802"}], "}"}]], "Output",
 ImageSize->{445, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23533]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"#", ">", "1000"}], ",", 
       RowBox[{"Throw", "[", "#", "]"}], ",", 
       RowBox[{
        RowBox[{"#", "^", "2"}], "+", "1"}]}], "]"}], "&"}], ",", "2", ",", 
    "6"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->468],

Cell[BoxData["458330"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31184]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25589],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Check",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Check"]], "InlineFormula"],
 " to throw an exception if a message is generated:"
}], "ExampleText",
 CellID->15268],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"2", "+", 
   RowBox[{"Check", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"1", "/", "0"}]}], ")"}]}], ",", 
     RowBox[{"Throw", "[", "error", "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7103],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->685254245],

Cell[BoxData["error"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->285447996]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"2", "+", 
   RowBox[{"Check", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"1", "/", "2"}]}], ")"}]}], ",", 
     RowBox[{"Throw", "[", "error", "]"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12613],

Cell[BoxData[
 FractionBox["8", "3"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->165149050]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4020],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " requires ",
 Cell[BoxData[
  ButtonBox["Catch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Catch"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->23355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"Throw", "[", "b", "]"}], ",", "c"}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15948],

Cell[BoxData[
 RowBox[{
  RowBox[{"Throw", "::", "\<\"nocatch\"\>"}], ":", 
  " ", "\<\"Uncaught \\!\\(Throw[b]\\) returned to top level. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Throw/nocatch\\\", \
ButtonNote -> \\\"Throw::nocatch\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->134120890],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"Throw", "[", "b", "]"}], "]"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217763174]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32271],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " can affect the structure of what is returned by a function:"
}], "ExampleText",
 CellID->31825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"#", "^", "2"}], "+", "1"}], "&"}], ",", "1", ",", "7"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9228],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "5", ",", "26", ",", "677", ",", "458330", ",", 
   "210066388901", ",", "44127887745906175987802"}], "}"}]], "Output",
 ImageSize->{463, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31173]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Catch", "[", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"#", ">", "1000"}], ",", 
       RowBox[{"Throw", "[", "#", "]"}], ",", 
       RowBox[{
        RowBox[{"#", "^", "2"}], "+", "1"}]}], "]"}], "&"}], ",", "1", ",", 
    "7"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13454],

Cell[BoxData["458330"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10309]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2792],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Catch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Catch"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Return",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Return"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Goto",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Goto"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interrupt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interrupt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["For",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/For"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["While",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/While"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24565]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19606],

Cell[TextData[ButtonBox["Loops and Control Structures",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LoopsAndControlStructures"]], "Tutorials",
 CellID->11221],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Messages"]], "Tutorials",
 CellID->25113]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->346111631],

Cell[TextData[ButtonBox["Flow Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FlowControl"]], "MoreAbout",
 CellID->27679235],

Cell[TextData[ButtonBox["Looping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LoopingConstructs"]], "MoreAbout",
 CellID->33647510],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->224450926],

Cell[TextData[ButtonBox["Scoping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ScopingConstructs"]], "MoreAbout",
 CellID->928830149]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Throw"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Throw - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 40.0511398}", "context" -> "System`", 
    "keywords" -> {
     "computed goto", "control", "divert", "errors", "handling of errors", 
      "jump", "longjmp", "non-local returns", "scope", "stop"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Throw[value] stops evaluation and returns value as the value of the \
nearest enclosing Catch. Throw[value, tag] is caught only by Catch[expr, \
form] where form is a pattern that matches tag. ", "synonyms" -> {"raise"}, 
    "title" -> "Throw", "type" -> "Symbol", "uri" -> "ref/Throw"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7859, 258, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->4544876]},
 "S2.6.10"->{
  Cell[19610, 784, 287, 10, 70, "Input",
   CellTags->"S2.6.10",
   CellID->14568],
  Cell[19900, 796, 176, 6, 36, "Output",
   CellTags->"S2.6.10",
   CellID->32684]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34208, 1354},
 {"S2.6.10", 34340, 1358}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2996, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3619, 91, 43, 1, 70, "ObjectName",
 CellID->13037],
Cell[3665, 94, 1502, 49, 70, "Usage",
 CellID->19035]
}, Open  ]],
Cell[CellGroupData[{
Cell[5204, 148, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5682, 165, 814, 33, 70, "Notes",
 CellID->1699],
Cell[6499, 200, 131, 5, 70, "Notes",
 CellID->13316],
Cell[6633, 207, 677, 26, 70, "Notes",
 CellID->1890],
Cell[7313, 235, 509, 18, 70, "Notes",
 CellID->13367]
}, Closed]],
Cell[CellGroupData[{
Cell[7859, 258, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->4544876],
Cell[CellGroupData[{
Cell[8242, 272, 148, 5, 70, "ExampleSection",
 CellID->292057518],
Cell[8393, 279, 338, 13, 70, "ExampleText",
 CellID->21531],
Cell[CellGroupData[{
Cell[8756, 296, 182, 5, 28, "Input",
 CellID->2829],
Cell[8941, 303, 154, 5, 36, "Output",
 CellID->31782]
}, Open  ]],
Cell[9110, 311, 121, 3, 70, "ExampleDelimiter",
 CellID->32705],
Cell[9234, 316, 89, 1, 70, "ExampleText",
 CellID->26162],
Cell[9326, 319, 268, 9, 70, "Input",
 CellID->15689],
Cell[9597, 330, 332, 13, 70, "ExampleText",
 CellID->15923],
Cell[CellGroupData[{
Cell[9954, 347, 179, 6, 70, "Input",
 CellID->30870],
Cell[10136, 355, 161, 5, 36, "Output",
 CellID->25342]
}, Open  ]],
Cell[CellGroupData[{
Cell[10334, 365, 177, 6, 70, "Input",
 CellID->9282],
Cell[10514, 373, 154, 5, 36, "Output",
 CellID->14196]
}, Open  ]],
Cell[10683, 381, 121, 3, 70, "ExampleDelimiter",
 CellID->12180],
Cell[10807, 386, 222, 8, 70, "ExampleText",
 CellID->19969],
Cell[CellGroupData[{
Cell[11054, 398, 376, 13, 70, "Input",
 CellID->19072],
Cell[11433, 413, 155, 5, 36, "Output",
 CellID->18715]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11637, 424, 216, 7, 70, "ExampleSection",
 CellID->24736],
Cell[11856, 433, 206, 7, 70, "ExampleText",
 CellID->11755],
Cell[CellGroupData[{
Cell[12087, 444, 370, 12, 70, "Input",
 CellID->15174],
Cell[12460, 458, 171, 6, 36, "Output",
 CellID->18477]
}, Open  ]],
Cell[CellGroupData[{
Cell[12668, 469, 187, 6, 70, "Input",
 CellID->1154],
Cell[12858, 477, 154, 5, 36, "Output",
 CellID->24729]
}, Open  ]],
Cell[CellGroupData[{
Cell[13049, 487, 291, 10, 70, "Input",
 CellID->10882],
Cell[13343, 499, 156, 5, 36, "Output",
 CellID->15851]
}, Open  ]],
Cell[13514, 507, 121, 3, 70, "ExampleDelimiter",
 CellID->19769],
Cell[13638, 512, 209, 8, 70, "ExampleText",
 CellID->11237],
Cell[CellGroupData[{
Cell[13872, 524, 448, 16, 70, "Input",
 CellID->28301],
Cell[14323, 542, 175, 6, 51, "Output",
 CellID->15676]
}, Open  ]],
Cell[14513, 551, 121, 3, 70, "ExampleDelimiter",
 CellID->13604],
Cell[14637, 556, 322, 12, 70, "ExampleText",
 CellID->27073],
Cell[CellGroupData[{
Cell[14984, 572, 293, 10, 70, "Input",
 CellID->24161],
Cell[15280, 584, 209, 7, 36, "Output",
 CellID->21197]
}, Open  ]],
Cell[15504, 594, 120, 3, 70, "ExampleDelimiter",
 CellID->8595],
Cell[15627, 599, 352, 13, 70, "ExampleText",
 CellID->2125],
Cell[CellGroupData[{
Cell[16004, 616, 255, 8, 70, "Input",
 CellID->5485],
Cell[16262, 626, 154, 5, 36, "Output",
 CellID->15062]
}, Open  ]],
Cell[CellGroupData[{
Cell[16453, 636, 184, 6, 70, "Input",
 CellID->29229],
Cell[16640, 644, 154, 5, 36, "Output",
 CellID->27560]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16843, 655, 238, 7, 70, "ExampleSection",
 CellID->7718],
Cell[17084, 664, 232, 10, 70, "ExampleText",
 CellID->29073],
Cell[CellGroupData[{
Cell[17341, 678, 177, 6, 70, "Input",
 CellID->8079],
Cell[17521, 686, 153, 5, 36, "Output",
 CellID->8709]
}, Open  ]],
Cell[17689, 694, 120, 3, 70, "ExampleDelimiter",
 CellID->9662],
Cell[17812, 699, 310, 13, 70, "ExampleText",
 CellID->10224],
Cell[CellGroupData[{
Cell[18147, 716, 276, 10, 70, "Input",
 CellID->11574],
Cell[18426, 728, 180, 6, 36, "Output",
 CellID->7682]
}, Open  ]],
Cell[18621, 737, 309, 13, 70, "ExampleText",
 CellID->7475],
Cell[CellGroupData[{
Cell[18955, 754, 276, 10, 70, "Input",
 CellID->28815],
Cell[19234, 766, 154, 5, 36, "Output",
 CellID->29343]
}, Open  ]],
Cell[19403, 774, 121, 3, 70, "ExampleDelimiter",
 CellID->27446],
Cell[19527, 779, 58, 1, 70, "ExampleText",
 CellID->27532],
Cell[CellGroupData[{
Cell[19610, 784, 287, 10, 70, "Input",
 CellTags->"S2.6.10",
 CellID->14568],
Cell[19900, 796, 176, 6, 36, "Output",
 CellTags->"S2.6.10",
 CellID->32684]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20125, 808, 222, 7, 70, "ExampleSection",
 CellID->5472],
Cell[20350, 817, 150, 6, 70, "ExampleText",
 CellID->25286],
Cell[CellGroupData[{
Cell[20525, 827, 432, 15, 70, "Input",
 CellID->8266],
Cell[20960, 844, 163, 5, 36, "Output",
 CellID->6089]
}, Open  ]],
Cell[21138, 852, 121, 3, 70, "ExampleDelimiter",
 CellID->32151],
Cell[21262, 857, 83, 1, 70, "ExampleText",
 CellID->4604],
Cell[CellGroupData[{
Cell[21370, 862, 419, 14, 70, "Input",
 CellID->17233],
Cell[21792, 878, 154, 5, 36, "Output",
 CellID->25594]
}, Open  ]],
Cell[21961, 886, 120, 3, 70, "ExampleDelimiter",
 CellID->9076],
Cell[22084, 891, 73, 1, 70, "ExampleText",
 CellID->598],
Cell[CellGroupData[{
Cell[22182, 896, 206, 8, 70, "Input",
 CellID->18604],
Cell[22391, 906, 298, 9, 36, "Output",
 CellID->23533]
}, Open  ]],
Cell[CellGroupData[{
Cell[22726, 920, 383, 13, 70, "Input",
 CellID->468],
Cell[23112, 935, 159, 5, 36, "Output",
 CellID->31184]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23320, 946, 233, 7, 70, "ExampleSection",
 CellID->25589],
Cell[23556, 955, 225, 8, 70, "ExampleText",
 CellID->15268],
Cell[CellGroupData[{
Cell[23806, 967, 326, 11, 70, "Input",
 CellID->7103],
Cell[24135, 980, 367, 7, 70, "Message",
 CellID->685254245],
Cell[24505, 989, 162, 5, 36, "Output",
 CellID->285447996]
}, Open  ]],
Cell[CellGroupData[{
Cell[24704, 999, 327, 11, 70, "Input",
 CellID->12613],
Cell[25034, 1012, 178, 6, 51, "Output",
 CellID->165149050]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[25261, 1024, 225, 7, 70, "ExampleSection",
 CellID->4020],
Cell[25489, 1033, 296, 12, 70, "ExampleText",
 CellID->23355],
Cell[CellGroupData[{
Cell[25810, 1049, 154, 5, 70, "Input",
 CellID->15948],
Cell[25967, 1056, 376, 7, 70, "Message",
 CellID->134120890],
Cell[26346, 1065, 221, 7, 36, "Output",
 CellID->217763174]
}, Open  ]],
Cell[26582, 1075, 121, 3, 70, "ExampleDelimiter",
 CellID->32271],
Cell[26706, 1080, 238, 8, 70, "ExampleText",
 CellID->31825],
Cell[CellGroupData[{
Cell[26969, 1092, 205, 8, 70, "Input",
 CellID->9228],
Cell[27177, 1102, 308, 9, 36, "Output",
 CellID->31173]
}, Open  ]],
Cell[CellGroupData[{
Cell[27522, 1116, 385, 13, 70, "Input",
 CellID->13454],
Cell[27910, 1131, 159, 5, 36, "Output",
 CellID->10309]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28130, 1143, 310, 9, 70, "SeeAlsoSection",
 CellID->2792],
Cell[28443, 1154, 2120, 80, 70, "SeeAlso",
 CellID->24565]
}, Open  ]],
Cell[CellGroupData[{
Cell[30600, 1239, 314, 9, 70, "TutorialsSection",
 CellID->19606],
Cell[30917, 1250, 164, 3, 70, "Tutorials",
 CellID->11221],
Cell[31084, 1255, 127, 3, 70, "Tutorials",
 CellID->25113]
}, Open  ]],
Cell[CellGroupData[{
Cell[31248, 1263, 319, 9, 70, "MoreAboutSection",
 CellID->346111631],
Cell[31570, 1274, 134, 3, 70, "MoreAbout",
 CellID->27679235],
Cell[31707, 1279, 146, 3, 70, "MoreAbout",
 CellID->33647510],
Cell[31856, 1284, 155, 3, 70, "MoreAbout",
 CellID->224450926],
Cell[32014, 1289, 147, 3, 70, "MoreAbout",
 CellID->928830149]
}, Open  ]],
Cell[CellGroupData[{
Cell[32198, 1297, 305, 8, 70, "RelatedLinksSection"],
Cell[32506, 1307, 383, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[32904, 1323, 50, 0, 70, "History"],
Cell[32957, 1325, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

