(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     69499,       1787]
NotebookOptionsPosition[     62786,       1557]
NotebookOutlinePosition[     64201,       1596]
CellTagsIndexPosition[     64115,       1591]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Ticks" :> Documentation`HelpLookup["paclet:ref/Ticks"], 
          "FrameTicksStyle" :> 
          Documentation`HelpLookup["paclet:ref/FrameTicksStyle"], "AxesStyle" :> 
          Documentation`HelpLookup["paclet:ref/AxesStyle"], "LabelStyle" :> 
          Documentation`HelpLookup["paclet:ref/LabelStyle"], "BaseStyle" :> 
          Documentation`HelpLookup["paclet:ref/BaseStyle"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Ticks\"\>", 
       2->"\<\"FrameTicksStyle\"\>", 3->"\<\"AxesStyle\"\>", 
       4->"\<\"LabelStyle\"\>", 5->"\<\"BaseStyle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["TicksStyle", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["TicksStyle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TicksStyle"]], "InlineFormula"],
     " \[LineSeparator]is an option for graphics functions which specifies \
how ticks should be rendered."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TicksStyle"]], "InlineFormula"],
 " gives styles for both tick marks and tick labels."
}], "Notes",
 CellID->12167170],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TicksStyle"]], "InlineFormula"],
 " can be used in both two\[Hyphen] and three\[Hyphen]dimensional graphics."
}], "Notes",
 CellID->3196],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TicksStyle", "->", 
   StyleBox["style", "TI"]}]], "InlineFormula"],
 " specifies that all ticks are to be rendered by default with the specified \
style."
}], "Notes",
 CellID->6849],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TicksStyle", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["xstyle", "TI"], ",", 
     StyleBox["ystyle", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies that ticks on different axes should use styles ",
 Cell[BoxData[
  StyleBox["xstyle", "TI"]], "InlineFormula"],
 ", \[Ellipsis]. "
}], "Notes",
 CellID->24023],

Cell[TextData[{
 "Styles can be specified using graphics directives such as ",
 Cell[BoxData[
  ButtonBox["Thick",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thick"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Red",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Red"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dashed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashed"]], "InlineFormula"],
 " as well as ",
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RGBColor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RGBColor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " and combinations given by ",
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 ".",
 " ",
 "Styles can also contain rules for options such as ",
 Cell[BoxData[
  ButtonBox["FontSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontSize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FontFamily",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FontFamily"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15125],

Cell["\<\
Style specifications can refer to styles using style names from current \
stylesheets.\
\>", "Notes",
 CellID->797803519],

Cell[TextData[{
 "Any outside styles not explicitly overridden by settings in ",
 Cell[BoxData[
  ButtonBox["TicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TicksStyle"]], "InlineFormula"],
 " will still be used."
}], "Notes",
 CellID->3528],

Cell[TextData[{
 "Explicit styles specified in the setting for ",
 Cell[BoxData[
  ButtonBox["Ticks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ticks"]], "InlineFormula"],
 " can override styles specified in ",
 Cell[BoxData[
  ButtonBox["TicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TicksStyle"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->39190952]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->357748771],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->250142988],

Cell["Specify overall ticks style, including the tick labels:", "ExampleText",
 CellID->64237016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "12"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->385529678],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13634184]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->362763594],

Cell["Specify ticks style for each axis :", "ExampleText",
 CellID->93798502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->138675862],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->60189257]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27443694],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  TicksStyle->{
    RGBColor[1, 0, 0], 
    RGBColor[0, 1, 0], 
    RGBColor[0, 0, 1]}]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->28949970,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Sytles associated with lines affect ticks:", "ExampleText",
 CellID->356019607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->457869047],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->82814557]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13225709],

Cell["Styles associated with fonts affect tick labels:", "ExampleText",
 CellID->23472827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", "Italic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140553305],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9251316]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->466432450],

Cell[TextData[{
 "Styles can be combined by ",
 Cell[BoxData[
  ButtonBox["Directive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Directive"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->21248147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", "Italic"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->348130125],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30339523]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TicksStyle"]], "InlineFormula"],
 " affects ticks and tick labels:"
}], "ExampleText",
 CellID->730034636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178370624],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124798927]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->172046868],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " offers overall style of all the label-like elements, including tick \
labels:"
}], "ExampleText",
 CellID->287688071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Blue", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->852841955],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77971007]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TicksStyle"]], "InlineFormula"],
 " can be used to together with ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " and has higher priority: "
}], "ExampleText",
 CellID->16302533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Blue", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}], ",", 
   
   RowBox[{"TicksStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->610817034],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->67178565]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->657512805],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AxesStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesStyle"]], "InlineFormula"],
 " affects affects the axes, axes labels, ticks and tick labels:"
}], "ExampleText",
 CellID->715340404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->423721885],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->363309450]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TicksStyle"]], "InlineFormula"],
 " can be used together with ",
 Cell[BoxData[
  ButtonBox["AxesStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesStyle"]], "InlineFormula"],
 ", and has higher priority:"
}], "ExampleText",
 CellID->271652939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", 
      RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}]}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->131785817],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->84021564]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->231209055],

Cell["\<\
Individually styled ticks can be used with other styles, and have higher \
priority:\
\>", "ExampleText",
 CellID->40832033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"{", 
         RowBox[{"Pi", ",", "Pi", ",", "1", ",", 
          RowBox[{"Directive", "[", 
           RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}], ",", 
        RowBox[{"2", "Pi"}], ",", 
        RowBox[{"3", "Pi"}]}], "}"}], ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", "Dashed"}], "]"}]}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "12"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->137003631],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29025762]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->324987651],

Cell[TextData[{
 "Frame ticks are not affected by ",
 Cell[BoxData[
  ButtonBox["TicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TicksStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->34798417],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "All"}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->203513887],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Frame->True,
  FrameTicks->All,
  TicksStyle->RGBColor[1, 0.5, 0]]], "Output",
 ImageSize->{154, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->529961089]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FrameTicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicksStyle"]], "InlineFormula"],
 " instead:"
}], "ExampleText",
 CellID->125974274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "All"}], ",", 
   RowBox[{"FrameTicksStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->114256204],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Frame->True,
  FrameTicks->All,
  FrameTicksStyle->RGBColor[1, 0.5, 0]]], "Output",
 ImageSize->{154, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->10152035]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ticks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ticks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameTicksStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameTicksStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AxesStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AxesStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LabelStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LabelStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaseStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BaseStyle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->257089527]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TicksStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 43.3793500}", "context" -> "System`", 
    "keywords" -> {
     "styling of tick labels", "styling of tick marks", "coordinate ticks", 
      "ruler ticks", "axis ticks", "axes ticks", "2D coordinate ticks", 
      "3D coordinate ticks"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TicksStyle is an option for graphics functions which specifies how ticks \
should be rendered.", "synonyms" -> {"ticks style"}, "title" -> "TicksStyle", 
    "type" -> "Symbol", "uri" -> "ref/TicksStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8091, 268, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->357748771]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 63972, 1584}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1660, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2283, 65, 1575, 37, 70, "ObjectNameGrid"],
Cell[3861, 104, 475, 14, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4373, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4851, 140, 224, 7, 70, "Notes",
 CellID->12167170],
Cell[5078, 149, 243, 7, 70, "Notes",
 CellID->3196],
Cell[5324, 158, 225, 7, 70, "Notes",
 CellID->6849],
Cell[5552, 167, 404, 13, 70, "Notes",
 CellID->24023],
Cell[5959, 182, 1323, 50, 70, "Notes",
 CellID->15125],
Cell[7285, 234, 131, 4, 70, "Notes",
 CellID->797803519],
Cell[7419, 240, 255, 8, 70, "Notes",
 CellID->3528],
Cell[7677, 250, 377, 13, 70, "Notes",
 CellID->39190952]
}, Closed]],
Cell[CellGroupData[{
Cell[8091, 268, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->357748771],
Cell[CellGroupData[{
Cell[8476, 282, 148, 5, 70, "ExampleSection",
 CellID->250142988],
Cell[8627, 289, 97, 1, 70, "ExampleText",
 CellID->64237016],
Cell[CellGroupData[{
Cell[8749, 294, 333, 10, 28, "Input",
 CellID->385529678],
Cell[9085, 306, 2997, 53, 127, "Output",
 Evaluatable->False,
 CellID->13634184]
}, Open  ]],
Cell[12097, 362, 125, 3, 70, "ExampleDelimiter",
 CellID->362763594],
Cell[12225, 367, 77, 1, 70, "ExampleText",
 CellID->93798502],
Cell[CellGroupData[{
Cell[12327, 372, 319, 10, 28, "Input",
 CellID->138675862],
Cell[12649, 384, 2875, 51, 127, "Output",
 Evaluatable->False,
 CellID->60189257]
}, Open  ]],
Cell[CellGroupData[{
Cell[15561, 440, 314, 9, 70, "Input",
 CellID->27443694],
Cell[15878, 451, 7626, 133, 194, 180, 6, "CachedBoxData", "BoxData", "Output",
 
 CellID->28949970]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23553, 590, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[23777, 599, 85, 1, 70, "ExampleText",
 CellID->356019607],
Cell[CellGroupData[{
Cell[23887, 604, 267, 8, 70, "Input",
 CellID->457869047],
Cell[24157, 614, 2883, 51, 70, "Output",
 Evaluatable->False,
 CellID->82814557]
}, Open  ]],
Cell[27055, 668, 124, 3, 70, "ExampleDelimiter",
 CellID->13225709],
Cell[27182, 673, 90, 1, 70, "ExampleText",
 CellID->23472827],
Cell[CellGroupData[{
Cell[27297, 678, 268, 8, 70, "Input",
 CellID->140553305],
Cell[27568, 688, 2968, 53, 70, "Output",
 Evaluatable->False,
 CellID->9251316]
}, Open  ]],
Cell[30551, 744, 125, 3, 70, "ExampleDelimiter",
 CellID->466432450],
Cell[30679, 749, 210, 8, 70, "ExampleText",
 CellID->21248147],
Cell[CellGroupData[{
Cell[30914, 761, 336, 10, 70, "Input",
 CellID->348130125],
Cell[31253, 773, 2936, 52, 70, "Output",
 Evaluatable->False,
 CellID->30339523]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34238, 831, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[34479, 840, 212, 7, 70, "ExampleText",
 CellID->730034636],
Cell[CellGroupData[{
Cell[34716, 851, 488, 15, 70, "Input",
 CellID->178370624],
Cell[35207, 868, 3080, 55, 70, "Output",
 Evaluatable->False,
 CellID->124798927]
}, Open  ]],
Cell[38302, 926, 125, 3, 70, "ExampleDelimiter",
 CellID->172046868],
Cell[38430, 931, 259, 8, 70, "ExampleText",
 CellID->287688071],
Cell[CellGroupData[{
Cell[38714, 943, 611, 19, 70, "Input",
 CellID->852841955],
Cell[39328, 964, 3058, 54, 70, "Output",
 Evaluatable->False,
 CellID->77971007]
}, Open  ]],
Cell[42401, 1021, 364, 12, 70, "ExampleText",
 CellID->16302533],
Cell[CellGroupData[{
Cell[42790, 1037, 666, 20, 70, "Input",
 CellID->610817034],
Cell[43459, 1059, 3103, 55, 70, "Output",
 Evaluatable->False,
 CellID->67178565]
}, Open  ]],
Cell[46577, 1117, 125, 3, 70, "ExampleDelimiter",
 CellID->657512805],
Cell[46705, 1122, 241, 7, 70, "ExampleText",
 CellID->715340404],
Cell[CellGroupData[{
Cell[46971, 1133, 488, 15, 70, "Input",
 CellID->423721885],
Cell[47462, 1150, 3080, 55, 70, "Output",
 Evaluatable->False,
 CellID->363309450]
}, Open  ]],
Cell[50557, 1208, 360, 12, 70, "ExampleText",
 CellID->271652939],
Cell[CellGroupData[{
Cell[50942, 1224, 644, 19, 70, "Input",
 CellID->131785817],
Cell[51589, 1245, 3026, 54, 70, "Output",
 Evaluatable->False,
 CellID->84021564]
}, Open  ]],
Cell[54630, 1302, 125, 3, 70, "ExampleDelimiter",
 CellID->231209055],
Cell[54758, 1307, 134, 4, 70, "ExampleText",
 CellID->40832033],
Cell[CellGroupData[{
Cell[54917, 1315, 845, 24, 70, "Input",
 CellID->137003631],
Cell[55765, 1341, 2961, 53, 70, "Output",
 Evaluatable->False,
 CellID->29025762]
}, Open  ]],
Cell[58741, 1397, 125, 3, 70, "ExampleDelimiter",
 CellID->324987651],
Cell[58869, 1402, 218, 8, 70, "ExampleText",
 CellID->34798417],
Cell[CellGroupData[{
Cell[59112, 1414, 298, 8, 70, "Input",
 CellID->203513887],
Cell[59413, 1424, 310, 10, 155, "Output",
 CellID->529961089]
}, Open  ]],
Cell[59738, 1437, 209, 8, 70, "ExampleText",
 CellID->125974274],
Cell[CellGroupData[{
Cell[59972, 1449, 303, 8, 70, "Input",
 CellID->114256204],
Cell[60278, 1459, 314, 10, 155, "Output",
 CellID->10152035]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[60653, 1476, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[60972, 1487, 1206, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[62215, 1536, 299, 8, 70, "MoreAboutSection"],
Cell[62517, 1546, 197, 4, 70, "MoreAbout",
 CellID->257089527]
}, Open  ]],
Cell[62729, 1553, 27, 0, 70, "History"],
Cell[62759, 1555, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

