(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26888,        845]
NotebookOptionsPosition[     22796,        712]
NotebookOutlinePosition[     24233,        751]
CellTagsIndexPosition[     24148,        746]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date and Time Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DateAndTimeFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Date and Time Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MemoryConstrained" :> 
          Documentation`HelpLookup["paclet:ref/MemoryConstrained"], 
          "AbsoluteTiming" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteTiming"], "Timing" :> 
          Documentation`HelpLookup["paclet:ref/Timing"], "Check" :> 
          Documentation`HelpLookup["paclet:ref/Check"], "Interrupt" :> 
          Documentation`HelpLookup["paclet:ref/Interrupt"], "$IterationLimit" :> 
          Documentation`HelpLookup["paclet:ref/$IterationLimit"], 
          "$RecursionLimit" :> 
          Documentation`HelpLookup["paclet:ref/$RecursionLimit"], "Pause" :> 
          Documentation`HelpLookup["paclet:ref/Pause"], "Abort" :> 
          Documentation`HelpLookup["paclet:ref/Abort"], "TimeConstraint" :> 
          Documentation`HelpLookup["paclet:ref/TimeConstraint"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MemoryConstrained\"\>", 
       2->"\<\"AbsoluteTiming\"\>", 3->"\<\"Timing\"\>", 4->"\<\"Check\"\>", 
       5->"\<\"Interrupt\"\>", 6->"\<\"$IterationLimit\"\>", 
       7->"\<\"$RecursionLimit\"\>", 8->"\<\"Pause\"\>", 9->"\<\"Abort\"\>", 
       10->"\<\"TimeConstraint\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conditionals" :> 
          Documentation`HelpLookup["paclet:guide/Conditionals"], 
          "Date & Time" :> 
          Documentation`HelpLookup["paclet:guide/DateAndTime"], 
          "Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"], 
          "Flow Control" :> 
          Documentation`HelpLookup["paclet:guide/FlowControl"], 
          "Global Computation Settings & Parameters" :> 
          Documentation`HelpLookup[
           "paclet:guide/GlobalComputationSettingsAndParameters"], 
          "Package Bulletproofing" :> 
          Documentation`HelpLookup["paclet:guide/PackageBulletproofing"], 
          "Time Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/TimeMeasurementAndOptimization"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Conditionals\"\>", 
       2->"\<\"Date & Time\"\>", 3->"\<\"Evaluation Control\"\>", 
       4->"\<\"Flow Control\"\>", 
       5->"\<\"Global Computation Settings & Parameters\"\>", 
       6->"\<\"Package Bulletproofing\"\>", 
       7->"\<\"Time Measurement & Optimization\"\>", 
       8->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["TimeConstrained", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TimeConstrained",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TimeConstrained"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", stopping after ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " seconds. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TimeConstrained",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TimeConstrained"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["t", "TI"], ",", 
        StyleBox["failexpr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]returns ",
     Cell[BoxData[
      StyleBox["failexpr", "TI"]], "InlineFormula"],
     " if the time constraint is not met. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->27079]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TimeConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstrained"]], "InlineFormula"],
 " generates an interrupt to abort the evaluation of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " if the evaluation is not completed within the specified time. "
}], "Notes",
 CellID->8202],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TimeConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstrained"]], "InlineFormula"],
 " evaluates ",
 Cell[BoxData[
  StyleBox["failexpr", "TI"]], "InlineFormula"],
 " only if the evaluation is aborted. "
}], "Notes",
 CellID->11176],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TimeConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstrained"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["$Aborted",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Aborted"]], "InlineFormula"],
 " if the evaluation is aborted and no ",
 Cell[BoxData[
  StyleBox["failexpr", "TI"]], "InlineFormula"],
 " is specified. "
}], "Notes",
 CellID->21580],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TimeConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstrained"]], "InlineFormula"],
 " is accurate only down to a granularity of at least ",
 Cell[BoxData[
  ButtonBox["$TimeUnit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeUnit"]], "InlineFormula"],
 " seconds. "
}], "Notes",
 CellID->13269],

Cell[TextData[{
 "Aborts generated by ",
 Cell[BoxData[
  ButtonBox["TimeConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstrained"]], "InlineFormula"],
 " are treated just like those generated by ",
 Cell[BoxData[
  ButtonBox["Abort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abort"]], "InlineFormula"],
 ", and can thus be overruled by ",
 Cell[BoxData[
  ButtonBox["AbortProtect",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbortProtect"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5388],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["TimeConstrained",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimeConstrained"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"]}], "]"}]], "InlineFormula"],
 " imposes no time constraint."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->103785906],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TimeConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstrained"]], "InlineFormula"],
 " may give different results on different occasions within a single session, \
for example as a result of different conditions of internal system caches."
}], "Notes",
 CellID->303163042],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TimeConstrained",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstrained"]], "InlineFormula"],
 " takes account only of CPU time spent inside the main ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel process; it does not include additional threads or processes."
}], "Notes",
 CellID->83621621]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->86303524],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->30289711],

Cell["Terminate a computation if it takes more than 1 second:", "ExampleText",
 CellID->151815341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TimeConstrained", "[", 
  RowBox[{
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"i", "^", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1000000"}], "}"}]}], "]"}], ",", "1"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->61206588],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1836389]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->304723048],

Cell["Terminate a computation if it takes more than 2 seconds:", "ExampleText",
 CellID->489967817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TimeConstrained", "[", 
  RowBox[{
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
         RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",",
      "x", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"10000", " ", "Pi"}]}], "}"}], ",", 
     RowBox[{"MaxSteps", "\[Rule]", "\[Infinity]"}], ",", " ", 
     RowBox[{"Method", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Projection\>\"", ",", 
        RowBox[{"\"\<Invariants\>\"", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"x", "[", "t", "]"}], "^", "2"}], "+", 
           RowBox[{
            RowBox[{
             RowBox[{"x", "'"}], "[", "t", "]"}], "^", "2"}]}], "}"}]}]}], 
       "}"}]}]}], "]"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->677824663],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227237827]
}, Open  ]],

Cell["\<\
With the default method, it gets a (not quite as accurate) solution within \
the time constraint:\
\>", "ExampleText",
 CellID->38619881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TimeConstrained", "[", 
  RowBox[{
   RowBox[{"NDSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
         RowBox[{"x", "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
       RowBox[{
        RowBox[{"x", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",",
      "x", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"10000", " ", "Pi"}]}], "}"}], ",", 
     RowBox[{"MaxSteps", "\[Rule]", "\[Infinity]"}]}], "]"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->401307567],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "31415.926535897932`"}], "}"}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{346, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->449781031]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16327],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MemoryConstrained",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MemoryConstrained"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteTiming",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTiming"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Timing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Timing"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Check",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Check"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interrupt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interrupt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$IterationLimit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$IterationLimit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$RecursionLimit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$RecursionLimit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Pause",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Pause"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Abort",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abort"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimeConstraint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimeConstraint"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14274]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3429],

Cell[TextData[ButtonBox["Date and Time Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DateAndTimeFunctions"]], "Tutorials",
 CellID->15885]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->10492007],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "MoreAbout",
 CellID->69901149],

Cell[TextData[ButtonBox["Date & Time",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "MoreAbout",
 CellID->676409129],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->849162877],

Cell[TextData[ButtonBox["Flow Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FlowControl"]], "MoreAbout",
 CellID->32318586],

Cell[TextData[ButtonBox["Global Computation Settings & Parameters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GlobalComputationSettingsAndParameters"]], "MoreAbout",
 CellID->88905392],

Cell[TextData[ButtonBox["Package Bulletproofing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageBulletproofing"]], "MoreAbout",
 CellID->32072150],

Cell[TextData[ButtonBox["Time Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TimeMeasurementAndOptimization"]], "MoreAbout",
 CellID->411892321],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->196937801]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TimeConstrained - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 48.8013638}", "context" -> "System`", 
    "keywords" -> {
     "evaluation with time constraints", "time constraints", 
      "terminating a computation", "abort computation"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TimeConstrained[expr, t] evaluates expr, stopping after t seconds. \
TimeConstrained[expr, t, failexpr] returns failexpr if the time constraint is \
not met. ", "synonyms" -> {"time constrained"}, "title" -> "TimeConstrained", 
    "type" -> "Symbol", "uri" -> "ref/TimeConstrained"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13634, 372, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->86303524]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24005, 739}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3842, 82, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4465, 109, 4199, 83, 70, "ObjectNameGrid"],
Cell[8667, 194, 1197, 38, 70, "Usage",
 CellID->27079]
}, Open  ]],
Cell[CellGroupData[{
Cell[9901, 237, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10379, 254, 359, 10, 70, "Notes",
 CellID->8202],
Cell[10741, 266, 297, 10, 70, "Notes",
 CellID->11176],
Cell[11041, 278, 435, 15, 70, "Notes",
 CellID->21580],
Cell[11479, 295, 369, 12, 70, "Notes",
 CellID->13269],
Cell[11851, 309, 530, 18, 70, "Notes",
 CellID->5388],
Cell[12384, 329, 509, 16, 70, "Notes",
 CellID->103785906],
Cell[12896, 347, 337, 8, 70, "Notes",
 CellID->303163042],
Cell[13236, 357, 361, 10, 70, "Notes",
 CellID->83621621]
}, Closed]],
Cell[CellGroupData[{
Cell[13634, 372, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->86303524],
Cell[CellGroupData[{
Cell[14018, 386, 147, 5, 70, "ExampleSection",
 CellID->30289711],
Cell[14168, 393, 98, 1, 70, "ExampleText",
 CellID->151815341],
Cell[CellGroupData[{
Cell[14291, 398, 276, 10, 28, "Input",
 CellID->61206588],
Cell[14570, 410, 163, 5, 36, "Output",
 CellID->1836389]
}, Open  ]],
Cell[14748, 418, 125, 3, 70, "ExampleDelimiter",
 CellID->304723048],
Cell[14876, 423, 99, 1, 70, "ExampleText",
 CellID->489967817],
Cell[CellGroupData[{
Cell[15000, 428, 1166, 35, 70, "Input",
 CellID->677824663],
Cell[16169, 465, 165, 5, 36, "Output",
 CellID->227237827]
}, Open  ]],
Cell[16349, 473, 147, 4, 70, "ExampleText",
 CellID->38619881],
Cell[CellGroupData[{
Cell[16521, 481, 755, 24, 70, "Input",
 CellID->401307567],
Cell[17279, 507, 483, 17, 36, "Output",
 CellID->449781031]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17823, 531, 311, 9, 70, "SeeAlsoSection",
 CellID->16327],
Cell[18137, 542, 2461, 89, 70, "SeeAlso",
 CellID->14274]
}, Open  ]],
Cell[CellGroupData[{
Cell[20635, 636, 313, 9, 70, "TutorialsSection",
 CellID->3429],
Cell[20951, 647, 154, 3, 70, "Tutorials",
 CellID->15885]
}, Open  ]],
Cell[CellGroupData[{
Cell[21142, 655, 318, 9, 70, "MoreAboutSection",
 CellID->10492007],
Cell[21463, 666, 135, 3, 70, "MoreAbout",
 CellID->69901149],
Cell[21601, 671, 134, 3, 70, "MoreAbout",
 CellID->676409129],
Cell[21738, 676, 147, 3, 70, "MoreAbout",
 CellID->849162877],
Cell[21888, 681, 134, 3, 70, "MoreAbout",
 CellID->32318586],
Cell[22025, 686, 192, 4, 70, "MoreAbout",
 CellID->88905392],
Cell[22220, 692, 154, 3, 70, "MoreAbout",
 CellID->32072150],
Cell[22377, 697, 173, 3, 70, "MoreAbout",
 CellID->411892321],
Cell[22553, 702, 148, 3, 70, "MoreAbout",
 CellID->196937801]
}, Open  ]],
Cell[22716, 708, 50, 0, 70, "History"],
Cell[22769, 710, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

