(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35266,       1260]
NotebookOptionsPosition[     29243,       1062]
NotebookOutlinePosition[     30830,       1104]
CellTagsIndexPosition[     30744,       1099]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Fields" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicNumberFields"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Algebraic Number Fields\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AlgebraicNumber" :> 
          Documentation`HelpLookup["paclet:ref/AlgebraicNumber"], 
          "AlgebraicNumberPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/AlgebraicNumberPolynomial"], 
          "MinimalPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/MinimalPolynomial"], 
          "Extension" :> Documentation`HelpLookup["paclet:ref/Extension"], 
          "RootReduce" :> 
          Documentation`HelpLookup["paclet:ref/RootReduce"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AlgebraicNumber\"\>", 
       2->"\<\"AlgebraicNumberPolynomial\"\>", 3->"\<\"MinimalPolynomial\"\>",
        4->"\<\"Extension\"\>", 5->"\<\"RootReduce\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Numbers" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumbers"], 
          "Algebraic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumberTheory"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Algebraic Numbers\"\>", 
       2->"\<\"Algebraic Number Theory\"\>", 3->"\<\"Number Theory\"\>", 
       4->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       5->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ToNumberField", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToNumberField",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToNumberField"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["\[Theta]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]expresses the algebraic number ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " in the number field generated by \[Theta]. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToNumberField",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToNumberField"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["a", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["\[Theta]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]expresses the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in the field generated by ",
     Cell[BoxData[
      StyleBox["\[Theta]", "TR"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToNumberField",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToNumberField"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["a", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]expresses the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in a common extension field generated by a single algebraic number."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToNumberField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToNumberField"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects corresponding to elements of the rational extension ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", "\[Theta]", "]"}], 
   TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->147520056],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToNumberField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToNumberField"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["\[Theta]", "TR"]}], "]"}]], "InlineFormula"],
 " remains unevaluated if ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " does not exist in ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", "\[Theta]", "]"}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->461204612],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 " can be given in terms of ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects, or ordinary rationals and radicals."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 " is an algebraic integer the results will always be given in terms of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AlgebraicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumber"], "[", 
   RowBox[{
    StyleBox["\[Theta]", "TR"], ",", " ", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->484521361],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToNumberField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToNumberField"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " gives a representation of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in terms of a primitive element of the field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    RowBox[{
     SubscriptBox["a", "1"], ",", 
     SubscriptBox["a", "2"], ",", "\[Ellipsis]"}], "]"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Notes",
 CellID->311395078],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToNumberField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToNumberField"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToNumberField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToNumberField"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"]}], "]"}]], "InlineFormula"],
 ", and does not necessarily use the smallest common field extension."
}], "Notes",
 CellID->195173216],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToNumberField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToNumberField"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
 " always uses the smallest common field extension."
}], "Notes",
 CellID->14056541],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToNumberField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToNumberField"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula", "TemplateInclusion"],
 " converts any form of algebraic number to an explicit ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " object."
}], "Notes",
 CellID->132372780]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->102262439],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->220829099],

Cell[TextData[{
 "Express ",
 Cell[BoxData[
  SqrtBox["2"]], "InlineFormula"],
 " in the number field generated by ",
 Cell[BoxData[
  SuperscriptBox["2", 
   RowBox[{"1", "/", "4"}]]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->348676210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToNumberField", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], ",", " ", 
   RowBox[{"2", "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "4"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77045528],

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "2"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}]}], "]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{328, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1683925219]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[TextData[{
 "The generator ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 " of the number field will auto reduce to an algebraic integer:"
}], "ExampleText",
 CellID->931179805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToNumberField", "[", 
  RowBox[{"2", ",", 
   RowBox[{"1", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1555073197],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44171920]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134713316],

Cell["Radical expressions:", "ExampleText",
 CellID->1923591617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToNumberField", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", 
     RowBox[{"Sqrt", "[", "2", "]"}]}], "+", "1"}], ",", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1625646946],

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   SqrtBox["2"], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Output",
 ImageSize->{198, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1515601225]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->200582887],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->1585484981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToNumberField", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "25"}], "-", 
       RowBox[{"24", " ", "#1"}], "-", 
       RowBox[{"12", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}], ",", " ", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "3"}], "+", 
       RowBox[{"2", 
        SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1268983691],

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "12"}], "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", 
     FractionBox["1", "4"]}], "}"}]}], "]"}]], "Output",
 ImageSize->{321, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1406251508]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->760584805],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->805666685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToNumberField", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{"Pi", " ", 
      RowBox[{"I", "/", "4"}]}], ")"}]}], ",", 
   RowBox[{"I", " ", 
    RowBox[{"AlgebraicNumber", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->955580460],

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"49", "+", 
       RowBox[{"18", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["9", "8"]}], ",", 
     FractionBox["25", "56"], ",", 
     RowBox[{"-", 
      FractionBox["1", "8"]}], ",", 
     FractionBox["1", "56"]}], "}"}]}], "]"}]], "Output",
 ImageSize->{422, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1811559721]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34509058],

Cell[TextData[{
 "Express ",
 Cell[BoxData[
  SqrtBox["3"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{
      ButtonBox["I",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/I"], 
      SqrtBox["3"]}]}], ")"}], "/", "2"}]], "InlineFormula"],
 " in a common extension field:"
}], "ExampleText",
 CellID->361354917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToNumberField", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sqrt", "[", "3", "]"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"I", " ", 
        RowBox[{"Sqrt", "[", "3", "]"}]}]}], ")"}], "/", "2"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70311489],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"225", "-", 
         RowBox[{"18", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["1", "20"]}], ",", "0", ",", 
       FractionBox["1", "60"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"225", "-", 
         RowBox[{"18", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", 
       RowBox[{"-", 
        FractionBox["1", "20"]}], ",", "0", ",", 
       FractionBox["1", "60"]}], "}"}]}], "]"}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{431, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2008567328]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1673673528],

Cell["\<\
Express algebraic numbers in the smallest common extension field:\
\>", "ExampleText",
 CellID->1911842993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToNumberField", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "-", 
           RowBox[{"10", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{
          RowBox[{"-", "9"}], "/", "2"}], ",", "0", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"Sqrt", "[", "5", "]"}]}], "}"}], ",", "All"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->878972742],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"14", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["11", "6"]}], ",", "0", ",", 
       FractionBox["1", "6"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"14", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["17", "6"], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", "6"]}]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{406, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1695634503]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell[TextData[{
 "Find a primitive element for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", 
    RowBox[{
     SqrtBox["2"], ",", "i"}], "]"}], TraditionalForm]], "InlineMath"],
 " over ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalQ]", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->668238275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToNumberField", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], ",", "I"}], "}"}], ",", " ", "All"}], 
   "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1883814028],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"9", "-", 
     RowBox[{"2", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{156, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1421096231]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "Convert an algebraic number to an explicit ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " object:"
}], "ExampleText",
 CellID->307164522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToNumberField", "[", 
  SqrtBox[
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"]}]], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2944827],

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "4"]}], "+", 
       SuperscriptBox["#1", "8"]}], "&"}], ",", "4"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
     "0"}], "}"}]}], "]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{442, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51232483]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlgebraicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlgebraicNumberPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumberPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MinimalPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MinimalPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Extension",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extension"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootReduce"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Algebraic Number Fields",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumberFields"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->259818971],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumbers"]], "MoreAbout",
 CellID->303664986],

Cell[TextData[ButtonBox["Algebraic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "MoreAbout",
 CellID->391967742],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->36884618],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->25143946],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->570849837]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToNumberField - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 10.5206698}", "context" -> "System`", 
    "keywords" -> {
     "algebraic number", "generator", "number field", "primitive element", 
      "smallest field"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ToNumberField[a, \\[Theta]] expresses the algebraic number a in the \
number field generated by \\[Theta]. ToNumberField[{a_1, a_2, ...}, \
\\[Theta]] expresses the a_i in the field generated by \\[Theta]. \
ToNumberField[{a_1, a_2, ...}] expresses the a_i in a common extension field \
generated by a single algebraic number.", "synonyms" -> {"to number field"}, 
    "title" -> "ToNumberField", "type" -> "Symbol", "uri" -> 
    "ref/ToNumberField"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13010, 418, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->102262439]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30600, 1092}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3012, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3635, 96, 1578, 37, 70, "ObjectNameGrid"],
Cell[5216, 135, 2217, 69, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[7470, 209, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7948, 226, 519, 17, 70, "Notes",
 CellID->147520056],
Cell[8470, 245, 523, 19, 70, "Notes",
 CellID->461204612],
Cell[8996, 266, 565, 21, 70, "Notes",
 CellID->1067943069],
Cell[9564, 289, 445, 15, 70, "Notes",
 CellID->484521361],
Cell[10012, 306, 846, 30, 70, "Notes",
 CellID->311395078],
Cell[10861, 338, 1050, 36, 70, "Notes",
 CellID->195173216],
Cell[11914, 376, 603, 21, 70, "Notes",
 CellID->14056541],
Cell[12520, 399, 453, 14, 70, "Notes",
 CellID->132372780]
}, Closed]],
Cell[CellGroupData[{
Cell[13010, 418, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->102262439],
Cell[CellGroupData[{
Cell[13395, 432, 148, 5, 70, "ExampleSection",
 CellID->220829099],
Cell[13546, 439, 247, 10, 70, "ExampleText",
 CellID->348676210],
Cell[CellGroupData[{
Cell[13818, 453, 243, 8, 28, "Input",
 CellID->77045528],
Cell[14064, 463, 499, 17, 39, "Output",
 CellID->1683925219]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14612, 486, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[14836, 495, 203, 6, 70, "ExampleText",
 CellID->931179805],
Cell[CellGroupData[{
Cell[15064, 505, 157, 5, 70, "Input",
 CellID->1555073197],
Cell[15224, 512, 157, 5, 36, "Output",
 CellID->44171920]
}, Open  ]],
Cell[15396, 520, 125, 3, 70, "ExampleDelimiter",
 CellID->134713316],
Cell[15524, 525, 64, 1, 70, "ExampleText",
 CellID->1923591617],
Cell[CellGroupData[{
Cell[15613, 530, 268, 9, 70, "Input",
 CellID->1625646946],
Cell[15884, 541, 286, 10, 43, "Output",
 CellID->1515601225]
}, Open  ]],
Cell[16185, 554, 125, 3, 70, "ExampleDelimiter",
 CellID->200582887],
Cell[16313, 559, 179, 7, 70, "ExampleText",
 CellID->1585484981],
Cell[CellGroupData[{
Cell[16517, 570, 621, 22, 70, "Input",
 CellID->1268983691],
Cell[17141, 594, 466, 16, 51, "Output",
 CellID->1406251508]
}, Open  ]],
Cell[17622, 613, 125, 3, 70, "ExampleDelimiter",
 CellID->760584805],
Cell[17750, 618, 200, 7, 70, "ExampleText",
 CellID->805666685],
Cell[CellGroupData[{
Cell[17975, 629, 419, 14, 70, "Input",
 CellID->955580460],
Cell[18397, 645, 642, 22, 51, "Output",
 CellID->1811559721]
}, Open  ]],
Cell[19054, 670, 124, 3, 70, "ExampleDelimiter",
 CellID->34509058],
Cell[19181, 675, 386, 16, 70, "ExampleText",
 CellID->361354917],
Cell[CellGroupData[{
Cell[19592, 695, 334, 12, 70, "Input",
 CellID->70311489],
Cell[19929, 709, 1159, 38, 81, "Output",
 CellID->2008567328]
}, Open  ]],
Cell[21103, 750, 126, 3, 70, "ExampleDelimiter",
 CellID->1673673528],
Cell[21232, 755, 117, 3, 70, "ExampleText",
 CellID->1911842993],
Cell[CellGroupData[{
Cell[21374, 762, 685, 21, 70, "Input",
 CellID->878972742],
Cell[22062, 785, 1079, 35, 81, "Output",
 CellID->1695634503]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23190, 826, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[23420, 835, 345, 12, 70, "ExampleText",
 CellID->668238275],
Cell[CellGroupData[{
Cell[23790, 851, 306, 11, 70, "Input",
 CellID->1883814028],
Cell[24099, 864, 398, 14, 39, "Output",
 CellID->1421096231]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24546, 884, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[24787, 893, 247, 8, 70, "ExampleText",
 CellID->307164522],
Cell[CellGroupData[{
Cell[25059, 905, 171, 7, 70, "Input",
 CellID->2944827],
Cell[25233, 914, 595, 20, 39, "Output",
 CellID->51232483]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25889, 941, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[26208, 952, 1262, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[27507, 1001, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[27828, 1012, 159, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[28024, 1020, 319, 9, 70, "MoreAboutSection",
 CellID->259818971],
Cell[28346, 1031, 145, 3, 70, "MoreAbout",
 CellID->303664986],
Cell[28494, 1036, 156, 3, 70, "MoreAbout",
 CellID->391967742],
Cell[28653, 1041, 136, 3, 70, "MoreAbout",
 CellID->36884618],
Cell[28792, 1046, 178, 3, 70, "MoreAbout",
 CellID->25143946],
Cell[28973, 1051, 198, 4, 70, "MoreAbout",
 CellID->570849837]
}, Open  ]],
Cell[29186, 1058, 27, 0, 70, "History"],
Cell[29216, 1060, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

