(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35210,       1352]
NotebookOptionsPosition[     26673,       1051]
NotebookOutlinePosition[     28263,       1093]
CellTagsIndexPosition[     28177,       1088]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Representation of Textual Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfTextualForms"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"The Representation of Textual Forms\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ToBoxes" :> Documentation`HelpLookup["paclet:ref/ToBoxes"], 
          "ToExpression" :> 
          Documentation`HelpLookup["paclet:ref/ToExpression"], "HoldForm" :> 
          Documentation`HelpLookup["paclet:ref/HoldForm"], "WriteString" :> 
          Documentation`HelpLookup["paclet:ref/WriteString"], "SymbolName" :> 
          Documentation`HelpLookup["paclet:ref/SymbolName"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ToBoxes\"\>", 
       2->"\<\"ToExpression\"\>", 3->"\<\"HoldForm\"\>", 
       4->"\<\"WriteString\"\>", 5->"\<\"SymbolName\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Character Operations" :> 
          Documentation`HelpLookup["paclet:guide/CharacterOperations"], 
          "Converting between Expressions & Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/ConvertingBetweenExpressionsAndStrings"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"]}, #, 2]& ,\
 Evaluator -> Automatic], {1->"\<\"Character Operations\"\>", 
       2->"\<\"Converting between Expressions & Strings\"\>", 
       3->"\<\"String Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToString", "ObjectName",
 CellID->8807],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToString"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a string corresponding to the printed form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      ButtonBox["OutputForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToString"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the string corresponding to output in the \
specified form. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->18809]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToString"]], "InlineFormula"],
 " supports the same set of options as ",
 Cell[BoxData[
  ButtonBox["OpenAppend",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OpenAppend"]], "InlineFormula"],
 ", with default settings ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FormatType",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FormatType"], "->", 
   ButtonBox["OutputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OutputForm"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PageWidth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PageWidth"], "->", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TotalWidth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TotalWidth"], "->", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21330],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToString"]], "InlineFormula"],
 " uses any relevant definitions given for ",
 Cell[BoxData[
  ButtonBox["Format",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Format"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MakeBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->665861184]
}], "Notes",
 CellID->6091]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->160436326],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->71416388],

Cell[TextData[{
 "Give a string corresponding to the ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " form of ",
 Cell[BoxData[
  SuperscriptBox["x", "2"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->2042331047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  SuperscriptBox["x", "2"], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->113547313],

Cell[BoxData["\<\" 2\\nx\"\>"], "Output",
 ImageSize->{18, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->927067202]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->236470054],

Cell[BoxData["String"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39131391]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->469064579],

Cell[TextData[{
 "Give a string corresponding to the ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->200220529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", "InputForm"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->342356654],

Cell[BoxData["\<\"x^2\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44860907]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32048],

Cell[TextData[{
 "Strings for ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " of an expression:"
}], "ExampleText",
 CellID->242361774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "3"}]}], ",", " ", "OutputForm"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1622692448],

Cell[BoxData["\<\" 2    3\\nx  + y\"\>"], "Output",
 ImageSize->{53, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1697140283]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "3"}]}], ",", " ", "InputForm"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1699289067],

Cell[BoxData["\<\"x^2 + y^3\"\>"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->566327616]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "3"}]}], ",", " ", "StandardForm"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->620718608],

Cell[BoxData["\<\"\\!\\(x\\^2 + y\\^3\\)\"\>"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2089571177]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "3"}]}], ",", " ", "TraditionalForm"}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->958936927],

Cell[BoxData["\<\"\\!\\(TraditionalForm\\`\\(y\\^3 + x\\^2\\)\\)\"\>"], \
"Output",
 ImageSize->{43, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->2135645001]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->444344618],

Cell["\<\
Non\[Hyphen]default character encoding:\
\>", "ExampleText",
 CellID->10072062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{"\[Alpha]", ",", "StandardForm"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->329191293],

Cell[BoxData["\<\"\\!\\(\[Alpha]\\)\"\>"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3868283]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{"\[Alpha]", ",", "StandardForm", ",", 
   RowBox[{"CharacterEncoding", "\[Rule]", "\"\<ASCII\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->498806779],

Cell[BoxData["\<\"\\\\!\\\\(\\\\[Alpha]\\\\)\"\>"], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->107536094]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1426644222],

Cell["String representation of boxes:", "ExampleText",
 CellID->47228557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{"SuperscriptBox", "[", 
    RowBox[{"\"\<x\>\"", ",", "\"\<2\>\""}], "]"}], ",", "InputForm"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->954520399],

Cell[BoxData["\<\"\\\\(x\\\\^2\\\\)\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->872859858]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21067],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "CharacterEncoding",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->15778],

Cell["Generate a string using the default encoding:", "ExampleText",
 CellID->160314680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", "\[Alpha]", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->678305566],

Cell[BoxData["\<\"\[Alpha]\"\>"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->276953833]
}, Open  ]],

Cell["Use ASCII encoding instead:", "ExampleText",
 CellID->8994308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{"\[Alpha]", ",", 
   RowBox[{"CharacterEncoding", "\[Rule]", "\"\<ASCII\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->204940682],

Cell[BoxData["\<\"\\\\[Alpha]\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->214102805]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FormatType",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->1173],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FormatType",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FormatType"]], "InlineFormula"],
 " to change the formatting:"
}], "ExampleText",
 CellID->265875963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{"Exp", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->295922017],

Cell[BoxData["\<\" x\\nE\"\>"], "Output",
 ImageSize->{18, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->308510498]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"FormatType", "\[Rule]", "StandardForm"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->643137162],

Cell[BoxData["\<\"\\!\\(\[ExponentialE]\\^x\\)\"\>"], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->51114927]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "NumberMarks",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->3843],

Cell[TextData[{
 "Use the default setting of ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->541222955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{"1.2", ",", "InputForm"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->303601149],

Cell[BoxData["\<\"1.2\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38756684]
}, Open  ]],

Cell["Explicitly set whether number marks should be included:", "ExampleText",
 CellID->626839330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ToString", "[", 
    RowBox[{"1.2", ",", "InputForm", ",", 
     RowBox[{"NumberMarks", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"ToString", "[", 
    RowBox[{"1.2", ",", "InputForm", ",", 
     RowBox[{"NumberMarks", "\[Rule]", "False"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->161668896],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"1.2`\"\>", ",", "\<\"1.2\"\>"}], "}"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->426626210]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PageWidth",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5932],

Cell["By default the page width is infinite:", "ExampleText",
 CellID->115886555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], "+", 
   RowBox[{"Cos", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->659923025],

Cell[BoxData["\<\"Cos[x] + Cos[y]\"\>"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54027293]
}, Open  ]],

Cell["Wrap to a new line after 9 characters in the string:", "ExampleText",
 CellID->689762629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "+", 
    RowBox[{"Cos", "[", "y", "]"}]}], ",", 
   RowBox[{"PageWidth", "\[Rule]", "10"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->370105931],

Cell[BoxData["\<\"Cos[x] + \\n \\n  Cos[y]\"\>"], "Output",
 ImageSize->{67, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->187099891]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29598],

Cell["Construct an indexed set of variables:", "ExampleText",
 CellID->776242749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"ToExpression", "[", 
     RowBox[{"\"\<x\>\"", "<>", 
      RowBox[{"ToString", "[", "#", "]"}]}], "]"}], "&"}], "/@", 
   RowBox[{"Range", "[", "5", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39604829],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x1", ",", "x2", ",", "x3", ",", "x4", ",", "x5"}], "}"}]], "Output",\

 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->291927906]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x1", "=", "5"}], ";", "v"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->142098342],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "x2", ",", "x3", ",", "x4", ",", "x5"}], "}"}]], "Output",\

 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->202575038]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60367346],

Cell["Export data to files with programmatically created names:", \
"ExampleText",
 CellID->15295587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"Map", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"#", "[", "1.", "]"}]}], "}"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"Sin", ",", "Cos", ",", "Tan", ",", "Cot", ",", "Exp"}], "}"}]}],
    "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->82333042],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Sin", ",", "0.8414709848078965`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Cos", ",", "0.5403023058681398`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Tan", ",", "1.5574077246549023`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Cot", ",", "0.6420926159343306`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Exp", ",", "2.718281828459045`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{560, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->384163430]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"Export", "[", 
   RowBox[{
    RowBox[{"ToFileName", "[", 
     RowBox[{"$TemporaryPrefix", ",", 
      RowBox[{
       RowBox[{"ToString", "[", 
        RowBox[{"x", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], "<>", "\"\<.txt\>\""}]}], 
     "]"}], ",", 
    RowBox[{"x", "[", 
     RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->123076540],

Cell[BoxData[
 RowBox[{
  RowBox[{"ofiles", "=", 
   RowBox[{"f", "/@", "v"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->24114067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"StringTake", "[", 
    RowBox[{"#", ",", 
     RowBox[{"-", "7"}]}], "]"}], "&"}], "/@", "ofiles"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->25639088],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Sin.txt\"\>", ",", "\<\"Cos.txt\"\>", ",", "\<\"Tan.txt\"\>", 
   ",", "\<\"Cot.txt\"\>", ",", "\<\"Exp.txt\"\>"}], "}"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->308282121]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "/@", "ofiles"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->568876609],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"0.8414709848078965\"\>", ",", "\<\"0.5403023058681398\"\>", 
   ",", "\<\"1.5574077246549023\"\>", ",", "\<\"0.6420926159343306\"\>", 
   ",", "\<\"2.718281828459045\"\>"}], "}"}]], "Output",
 ImageSize->{412, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->718232044]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17689],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WriteString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WriteString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SymbolName"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23205],

Cell[BoxData[""], "Input",
 CellID->29634216]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18111],

Cell[TextData[ButtonBox["The Representation of Textual Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheRepresentationOfTextualForms"]], "Tutorials",\

 CellID->7544]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->363803053],

Cell[TextData[ButtonBox["Character Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CharacterOperations"]], "MoreAbout",
 CellID->649720417],

Cell[TextData[ButtonBox["Converting between Expressions & Strings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConvertingBetweenExpressionsAndStrings"]], "MoreAbout",
 CellID->40196098],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->758590587]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
ToString"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToString - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 14.2238896}", "context" -> "System`", 
    "keywords" -> {
     "construct string from expression", "convert expression", 
      "expression conversion", "expression to string", 
      "string from expression", "textual form of expression", 
      "transform expression to string", "expressions as string", 
      "linear representation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ToString[expr] gives a string corresponding to the printed form of expr \
in OutputForm. ToString[expr, form] gives the string corresponding to output \
in the specified form. ", "synonyms" -> {"to string"}, "title" -> "ToString", 
    "type" -> "Symbol", "uri" -> "ref/ToString"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6549, 213, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->160436326]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28034, 1081}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2583, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3206, 87, 45, 1, 70, "ObjectName",
 CellID->8807],
Cell[3254, 90, 1112, 35, 70, "Usage",
 CellID->18809]
}, Open  ]],
Cell[CellGroupData[{
Cell[4403, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4881, 147, 1081, 39, 70, "Notes",
 CellID->21330],
Cell[5965, 188, 547, 20, 70, "Notes",
 CellID->6091]
}, Closed]],
Cell[CellGroupData[{
Cell[6549, 213, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->160436326],
Cell[CellGroupData[{
Cell[6934, 227, 147, 5, 70, "ExampleSection",
 CellID->71416388],
Cell[7084, 234, 299, 11, 70, "ExampleText",
 CellID->2042331047],
Cell[CellGroupData[{
Cell[7408, 249, 128, 4, 30, "Input",
 CellID->113547313],
Cell[7539, 255, 171, 5, 54, "Output",
 CellID->927067202]
}, Open  ]],
Cell[CellGroupData[{
Cell[7747, 265, 100, 3, 28, "Input",
 CellID->236470054],
Cell[7850, 270, 162, 5, 36, "Output",
 CellID->39131391]
}, Open  ]],
Cell[8027, 278, 125, 3, 70, "ExampleDelimiter",
 CellID->469064579],
Cell[8155, 283, 220, 8, 70, "ExampleText",
 CellID->200220529],
Cell[CellGroupData[{
Cell[8400, 295, 160, 5, 70, "Input",
 CellID->342356654],
Cell[8563, 302, 167, 5, 36, "Output",
 CellID->44860907]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8779, 313, 216, 7, 70, "ExampleSection",
 CellID->32048],
Cell[8998, 322, 621, 23, 70, "ExampleText",
 CellID->242361774],
Cell[CellGroupData[{
Cell[9644, 349, 216, 7, 70, "Input",
 CellID->1622692448],
Cell[9863, 358, 182, 5, 54, "Output",
 CellID->1697140283]
}, Open  ]],
Cell[CellGroupData[{
Cell[10082, 368, 215, 7, 70, "Input",
 CellID->1699289067],
Cell[10300, 377, 174, 5, 36, "Output",
 CellID->566327616]
}, Open  ]],
Cell[CellGroupData[{
Cell[10511, 387, 217, 7, 70, "Input",
 CellID->620718608],
Cell[10731, 396, 188, 5, 36, "Output",
 CellID->2089571177]
}, Open  ]],
Cell[CellGroupData[{
Cell[10956, 406, 222, 8, 70, "Input",
 CellID->958936927],
Cell[11181, 416, 214, 6, 36, "Output",
 CellID->2135645001]
}, Open  ]],
Cell[11410, 425, 125, 3, 70, "ExampleDelimiter",
 CellID->444344618],
Cell[11538, 430, 89, 3, 70, "ExampleText",
 CellID->10072062],
Cell[CellGroupData[{
Cell[11652, 437, 145, 4, 70, "Input",
 CellID->329191293],
Cell[11800, 443, 180, 5, 36, "Output",
 CellID->3868283]
}, Open  ]],
Cell[CellGroupData[{
Cell[12017, 453, 216, 6, 70, "Input",
 CellID->498806779],
Cell[12236, 461, 192, 5, 36, "Output",
 CellID->107536094]
}, Open  ]],
Cell[12443, 469, 126, 3, 70, "ExampleDelimiter",
 CellID->1426644222],
Cell[12572, 474, 73, 1, 70, "ExampleText",
 CellID->47228557],
Cell[CellGroupData[{
Cell[12670, 479, 221, 7, 70, "Input",
 CellID->954520399],
Cell[12894, 488, 182, 5, 36, "Output",
 CellID->872859858]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13125, 499, 218, 7, 70, "ExampleSection",
 CellID->21067],
Cell[CellGroupData[{
Cell[13368, 510, 234, 7, 70, "ExampleSubsection",
 CellID->15778],
Cell[13605, 519, 88, 1, 70, "ExampleText",
 CellID->160314680],
Cell[CellGroupData[{
Cell[13718, 524, 111, 3, 70, "Input",
 CellID->678305566],
Cell[13832, 529, 173, 5, 36, "Output",
 CellID->276953833]
}, Open  ]],
Cell[14020, 537, 68, 1, 70, "ExampleText",
 CellID->8994308],
Cell[CellGroupData[{
Cell[14113, 542, 195, 6, 70, "Input",
 CellID->204940682],
Cell[14311, 550, 176, 5, 36, "Output",
 CellID->214102805]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14536, 561, 226, 7, 70, "ExampleSubsection",
 CellID->1173],
Cell[14765, 570, 216, 8, 70, "ExampleText",
 CellID->265875963],
Cell[CellGroupData[{
Cell[15006, 582, 134, 4, 70, "Input",
 CellID->295922017],
Cell[15143, 588, 171, 5, 54, "Output",
 CellID->308510498]
}, Open  ]],
Cell[CellGroupData[{
Cell[15351, 598, 208, 6, 70, "Input",
 CellID->643137162],
Cell[15562, 606, 192, 5, 36, "Output",
 CellID->51114927]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15803, 617, 227, 7, 70, "ExampleSubsection",
 CellID->3843],
Cell[16033, 626, 223, 8, 70, "ExampleText",
 CellID->541222955],
Cell[CellGroupData[{
Cell[16281, 638, 137, 4, 70, "Input",
 CellID->303601149],
Cell[16421, 644, 167, 5, 36, "Output",
 CellID->38756684]
}, Open  ]],
Cell[16603, 652, 98, 1, 70, "ExampleText",
 CellID->626839330],
Cell[CellGroupData[{
Cell[16726, 657, 368, 10, 70, "Input",
 CellID->161668896],
Cell[17097, 669, 224, 7, 36, "Output",
 CellID->426626210]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17370, 682, 225, 7, 70, "ExampleSubsection",
 CellID->5932],
Cell[17598, 691, 81, 1, 70, "ExampleText",
 CellID->115886555],
Cell[CellGroupData[{
Cell[17704, 696, 189, 6, 70, "Input",
 CellID->659923025],
Cell[17896, 704, 180, 5, 36, "Output",
 CellID->54027293]
}, Open  ]],
Cell[18091, 712, 95, 1, 70, "ExampleText",
 CellID->689762629],
Cell[CellGroupData[{
Cell[18211, 717, 254, 8, 70, "Input",
 CellID->370105931],
Cell[18468, 727, 189, 5, 71, "Output",
 CellID->187099891]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[18718, 739, 223, 7, 70, "ExampleSection",
 CellID->29598],
Cell[18944, 748, 81, 1, 70, "ExampleText",
 CellID->776242749],
Cell[CellGroupData[{
Cell[19050, 753, 282, 9, 70, "Input",
 CellID->39604829],
Cell[19335, 764, 241, 8, 36, "Output",
 CellID->291927906]
}, Open  ]],
Cell[CellGroupData[{
Cell[19613, 777, 116, 4, 70, "Input",
 CellID->142098342],
Cell[19732, 783, 240, 8, 36, "Output",
 CellID->202575038]
}, Open  ]],
Cell[19987, 794, 124, 3, 70, "ExampleDelimiter",
 CellID->60367346],
Cell[20114, 799, 101, 2, 70, "ExampleText",
 CellID->15295587],
Cell[CellGroupData[{
Cell[20240, 805, 347, 12, 70, "Input",
 CellID->82333042],
Cell[20590, 819, 578, 17, 36, "Output",
 CellID->384163430]
}, Open  ]],
Cell[21183, 839, 464, 15, 70, "Input",
 CellID->123076540],
Cell[21650, 856, 139, 5, 70, "Input",
 CellID->24114067],
Cell[CellGroupData[{
Cell[21814, 865, 199, 7, 70, "Input",
 CellID->25639088],
Cell[22016, 874, 308, 8, 36, "Output",
 CellID->308282121]
}, Open  ]],
Cell[CellGroupData[{
Cell[22361, 887, 103, 3, 70, "Input",
 CellID->568876609],
Cell[22467, 892, 366, 9, 54, "Output",
 CellID->718232044]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22894, 908, 311, 9, 70, "SeeAlsoSection",
 CellID->17689],
Cell[23208, 919, 1202, 44, 70, "SeeAlso",
 CellID->23205],
Cell[24413, 965, 45, 1, 70, "Input",
 CellID->29634216]
}, Open  ]],
Cell[CellGroupData[{
Cell[24495, 971, 314, 9, 70, "TutorialsSection",
 CellID->18111],
Cell[24812, 982, 178, 4, 70, "Tutorials",
 CellID->7544]
}, Open  ]],
Cell[CellGroupData[{
Cell[25027, 991, 319, 9, 70, "MoreAboutSection",
 CellID->363803053],
Cell[25349, 1002, 151, 3, 70, "MoreAbout",
 CellID->649720417],
Cell[25503, 1007, 192, 4, 70, "MoreAbout",
 CellID->40196098],
Cell[25698, 1013, 149, 3, 70, "MoreAbout",
 CellID->758590587]
}, Open  ]],
Cell[CellGroupData[{
Cell[25884, 1021, 305, 8, 70, "RelatedLinksSection"],
Cell[26192, 1031, 386, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[26593, 1047, 50, 0, 70, "History"],
Cell[26646, 1049, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

