(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     81524,       2466]
NotebookOptionsPosition[     71861,       2135]
NotebookOutlinePosition[     73595,       2178]
CellTagsIndexPosition[     73509,       2173]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"], 
          "Views" :> Documentation`HelpLookup["paclet:tutorial/Views"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Generalized Input\"\>", 
       3->"\<\"Views\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Checkbox" :> Documentation`HelpLookup["paclet:ref/Checkbox"], 
          "Opener" :> Documentation`HelpLookup["paclet:ref/Opener"], 
          "TogglerBar" :> Documentation`HelpLookup["paclet:ref/TogglerBar"], 
          "Setter" :> Documentation`HelpLookup["paclet:ref/Setter"], "Panel" :> 
          Documentation`HelpLookup["paclet:ref/Panel"], "PaneSelector" :> 
          Documentation`HelpLookup["paclet:ref/PaneSelector"], "FlipView" :> 
          Documentation`HelpLookup["paclet:ref/FlipView"], "SlideView" :> 
          Documentation`HelpLookup["paclet:ref/SlideView"], "PopupMenu" :> 
          Documentation`HelpLookup["paclet:ref/PopupMenu"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Checkbox\"\>", 2->"\<\"Opener\"\>", 
       3->"\<\"TogglerBar\"\>", 4->"\<\"Setter\"\>", 5->"\<\"Panel\"\>", 
       6->"\<\"PaneSelector\"\>", 7->"\<\"FlipView\"\>", 
       8->"\<\"SlideView\"\>", 9->"\<\"PopupMenu\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Control Objects\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Toggler", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Toggler",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Toggler"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a toggler button with setting ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", that toggles between ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Toggler",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Toggler"], "[", 
       RowBox[{
        ButtonBox["Dynamic",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Dynamic"], "[", 
        StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the setting to be the dynamically updated current \
value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", with the value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " being toggled if the button is clicked. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Toggler",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Toggler"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a toggler button that cycles through any \
sequence of values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Toggler",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Toggler"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["val", "TI"], 
            StyleBox["1", "TR"]], "->", 
           SubscriptBox[
            StyleBox["pict", "TI"], 
            StyleBox["1", "TR"]]}], ",", 
          RowBox[{
           SubscriptBox[
            StyleBox["val", "TI"], 
            StyleBox["2", "TR"]], "->", 
           SubscriptBox[
            StyleBox["pict", "TI"], 
            StyleBox["2", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]cycles through values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " displaying them as ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["pict", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Toggler",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Toggler"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["vlist", "TI"], ",", 
        StyleBox["dpict", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays as ",
     Cell[BoxData[
      StyleBox["dpict", "TI"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is none of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->18386]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Checkbox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Checkbox"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Opener",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opener"]], "InlineFormula"],
 " are effectively special cases of ",
 Cell[BoxData[
  ButtonBox["Toggler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Toggler"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->36865483]
}], "Notes",
 CellID->2192],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Toggler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Toggler"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " by default displays as ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8552],

Cell[TextData[{
 "Clicking anywhere inside a ",
 Cell[BoxData[
  ButtonBox["Toggler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Toggler"]], "InlineFormula"],
 " advances to the next value."
}], "Notes",
 CellID->16217],

Cell["Shift-clicking goes to the previous value.", "Notes",
 CellID->32524],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["dpict", "TI"]], "InlineFormula"],
 " case cannot be reached by clicking, only by externally setting ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->352579597]
}], "Notes",
 CellID->14988],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["val", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["pict", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["Toggler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Toggler"]], "InlineFormula"],
 " can be strings, boxes, graphics or any other expressions, including \
dynamic expressions.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->306982536]
}], "Notes",
 CellID->693],

Cell["The following options can be given: ", "Notes",
 CellID->15089],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AutoAction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AutoAction"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to change the toggler automatically when the mouse is over it \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "alignment relative to surrounding text", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the displayed toggler", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the toggler is enabled, or grayed out ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the image of the displayed toggler ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "the overall image size of the displayed toggler ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->7688],

Cell[TextData[{
 "Controls such as ",
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula",
  ShowStringCharacters->False],
 " and ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula",
  ShowStringCharacters->False],
 " are not clickable inside ",
 Cell[BoxData[
  ButtonBox["Toggler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Toggler"]], "InlineFormula",
  ShowStringCharacters->False],
 "."
}], "Notes",
 CellID->12296],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["EventHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EventHandler"]], "InlineFormula",
  ShowStringCharacters->False],
 " intercepts mouse clicks, but passes them through to ",
 Cell[BoxData[
  ButtonBox["Toggler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Toggler"]], "InlineFormula",
  ShowStringCharacters->False],
 " if the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PassEventsDown",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PassEventsDown"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula",
  ShowStringCharacters->False],
 " is given. "
}], "Notes",
 CellID->20268],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<Toggler\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->763780478],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->327451266],

Cell["Click on the ouput to toggle its value:", "ExampleText",
 CellID->1086640992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Toggler", "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7237],

Cell[BoxData[
 TogglerBox[1, {1->"1", 2->"2", 3->"3", 4->"4"}, "1"]], "Output",
 ImageSize->{13, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72023596]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->281942291],

Cell[TextData[{
 "Dynamically change the value of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->429962552],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Toggler", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->773061255],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TogglerBox[Dynamic[$CellContext`x], {1->"1", 2->"2", 3->"3", 4->"4"}, 
    DynamicBox[ToBoxes[$CellContext`x, StandardForm],
     ImageSizeCache->{7., {0., 8.}}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{46, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123575779]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->260187470],

Cell["Include labels:", "ExampleText",
 CellID->370799704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Toggler", "[", 
  RowBox[{"3", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "\"\<One\>\""}], ",", 
     RowBox[{"2", "\[Rule]", "\"\<Two\>\""}], ",", 
     RowBox[{"3", "\[Rule]", "\"\<Three\>\""}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->220419386],

Cell[BoxData[
 TogglerBox[2, {1->"\<\"One\"\>", 2->"\<\"Two\"\>", 3->"\<\"Three\"\>"}, 
  "3"]], "Output",
 ImageSize->{41, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1869364164]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3698577],

Cell["\<\
Display the last element (\[WarningSign]) since the setting is not in the \
list of values:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->352579597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Toggler", "[", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{"\[WarningSign]", ",", "30"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->187164940],

Cell[BoxData[
 TogglerBox[0, {1->"1", 2->"2"}, 
  StyleBox["\[WarningSign]",
   StripOnInput->False,
   FontSize->30]]], "Output",
 ImageSize->{26, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->974218456]
}, Open  ]],

Cell["\<\
Sometimes the setting is affected by external actions, in this display \
\"N/A\":\
\>", "ExampleText",
 CellID->62548910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Button", "[", 
    RowBox[{"\"\<x=a\>\"", ",", 
     RowBox[{"x", "=", "a"}]}], "]"}], ",", 
   RowBox[{"Toggler", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", "\"\<N/A\>\""}], "]"}]}],
   "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->254736649],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   ButtonBox["\<\"x=a\"\>",
    Appearance->Automatic,
    ButtonData->"paclet:ref/x=a",
    ButtonFrame->"DialogBox",
    ButtonFunction:>($CellContext`x = $CellContext`a),
    Evaluator->Automatic,
    Method->"Preemptive"], ",", 
   TogglerBox[Dynamic[$CellContext`x], {1->"1", 2->"2", 3->
    "3"}, "\<\"N/A\"\>"]}], "}"}]], "Output",
 ImageSize->{82, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->751519139]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->704888758],

Cell["Use any type of expression as values:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->306982536],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "40"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    SqrtBox["y"], 
    RowBox[{"Tan", "[", 
     RowBox[{
      RowBox[{"\[Alpha]", " ", "y"}], "-", "\[Beta]"}], "]"}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"s", "=", "\"\<\[Alpha]\[Beta]\[Gamma]\>\""}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->505851930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Toggler", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "f", ",", "s"}], "}"}], ",", 
     RowBox[{"Alignment", "\[Rule]", "Center"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->111895333],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TogglerBox[Dynamic[$CellContext`x], {Graphics[{{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Line[CompressedData["
1:eJwl2Xk4VN//AHBrlsTMHUKlaF9ISmnB+1S2IqWkTQgVkrWEpFIJSUIq2VKW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         "]]}}}, {
     AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {0, 0}, ImageSize -> 40, 
      PlotRange -> {{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {
        Scaled[0.02], 
        Scaled[0.02]}}]->
    GraphicsBox[{{}, {}, 
      {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2Xk4VN//AHBrlsTMHUKlaF9ISmnB+1S2IqWkTQgVkrWEpFIJSUIq2VKW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        "]]}},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     AxesOrigin->{0, 0},
     ImageSize->40,
     PlotRange->
      NCache[{{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, {{
        0, 6.283185307179586}, {-0.9999998592131705, 0.9999998782112116}}],
     PlotRangeClipping->True,
     PlotRangePadding->{
       Scaled[0.02], 
       Scaled[0.02]}], $CellContext`y^Rational[1, 2] 
    Tan[$CellContext`y $CellContext`\[Alpha] - $CellContext`\[Beta]]->
    RowBox[{
     SqrtBox["y"], " ", 
     RowBox[{"Tan", "[", 
      RowBox[{
       RowBox[{"y", " ", "\[Alpha]"}], "-", "\[Beta]"}], "]"}]}], 
    "\[Alpha]\[Beta]\[Gamma]"->"\<\"\[Alpha]\[Beta]\[Gamma]\"\>"}, 
    DynamicBox[ToBoxes[$CellContext`x, StandardForm],
     ImageSizeCache->{7., {0., 8.}}],
    Alignment->Center], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{138, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->89588863]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->424266231],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Alignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->602625232],

Cell["Align labels in the toggler:", "ExampleText",
 CellID->253528423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Toggler", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"Background", "\[Rule]", "Pink"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"30", ",", "30"}], "}"}]}], ",", 
     RowBox[{"Alignment", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
      "Left", ",", "Right", ",", "Center", ",", "Bottom", ",", "Top"}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->257532128],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    Alignment->Left,
    Background->RGBColor[1, 0.5, 0.5],
    ImageSize->{30, 30}], ",", 
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    Alignment->Right,
    Background->RGBColor[1, 0.5, 0.5],
    ImageSize->{30, 30}], ",", 
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    Alignment->Center,
    Background->RGBColor[1, 0.5, 0.5],
    ImageSize->{30, 30}], ",", 
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    Alignment->Bottom,
    Background->RGBColor[1, 0.5, 0.5],
    ImageSize->{30, 30}], ",", 
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    Alignment->Top,
    Background->RGBColor[1, 0.5, 0.5],
    ImageSize->{30, 30}]}], "}"}]], "Output",
 ImageSize->{213, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95089154]
}, Open  ]],

Cell["All possible alignment positions:", "ExampleText",
 CellID->13623532],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Toggler", "[", 
     RowBox[{
      RowBox[{"Dynamic", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
      RowBox[{"Background", "\[Rule]", "Pink"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"30", ",", "30"}], "}"}]}], ",", 
      RowBox[{"Alignment", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"j", ",", "i"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", 
      RowBox[{"{", 
       RowBox[{"Left", ",", "Center", ",", "Right"}], "}"}]}], "}"}]}], "]"}],
   "//", "Grid"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->91903427],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TogglerBox[Dynamic[$CellContext`x], {1->"1", 2->"2", 3->"3"}, 
      DynamicBox[ToBoxes[$CellContext`x, StandardForm],
       ImageSizeCache->{7., {0., 8.}}],
      Alignment->{Left, Top},
      Background->RGBColor[1, 0.5, 0.5],
      ImageSize->{30, 30}], 
     TogglerBox[Dynamic[$CellContext`x], {1->"1", 2->"2", 3->"3"}, 
      DynamicBox[ToBoxes[$CellContext`x, StandardForm],
       ImageSizeCache->{7., {0., 8.}}],
      Alignment->{Center, Top},
      Background->RGBColor[1, 0.5, 0.5],
      ImageSize->{30, 30}], 
     TogglerBox[Dynamic[$CellContext`x], {1->"1", 2->"2", 3->"3"}, 
      DynamicBox[ToBoxes[$CellContext`x, StandardForm],
       ImageSizeCache->{7., {0., 8.}}],
      Alignment->{Right, Top},
      Background->RGBColor[1, 0.5, 0.5],
      ImageSize->{30, 30}]},
    {
     TogglerBox[Dynamic[$CellContext`x], {1->"1", 2->"2", 3->"3"}, 
      DynamicBox[ToBoxes[$CellContext`x, StandardForm],
       ImageSizeCache->{7., {0., 8.}}],
      Alignment->{Left, Center},
      Background->RGBColor[1, 0.5, 0.5],
      ImageSize->{30, 30}], 
     TogglerBox[Dynamic[$CellContext`x], {1->"1", 2->"2", 3->"3"}, 
      DynamicBox[ToBoxes[$CellContext`x, StandardForm],
       ImageSizeCache->{7., {0., 8.}}],
      Alignment->{Center, Center},
      Background->RGBColor[1, 0.5, 0.5],
      ImageSize->{30, 30}], 
     TogglerBox[Dynamic[$CellContext`x], {1->"1", 2->"2", 3->"3"}, 
      DynamicBox[ToBoxes[$CellContext`x, StandardForm],
       ImageSizeCache->{7., {0., 8.}}],
      Alignment->{Right, Center},
      Background->RGBColor[1, 0.5, 0.5],
      ImageSize->{30, 30}]},
    {
     TogglerBox[Dynamic[$CellContext`x], {1->"1", 2->"2", 3->"3"}, 
      DynamicBox[ToBoxes[$CellContext`x, StandardForm],
       ImageSizeCache->{7., {0., 8.}}],
      Alignment->{Left, Bottom},
      Background->RGBColor[1, 0.5, 0.5],
      ImageSize->{30, 30}], 
     TogglerBox[Dynamic[$CellContext`x], {1->"1", 2->"2", 3->"3"}, 
      DynamicBox[ToBoxes[$CellContext`x, StandardForm],
       ImageSizeCache->{7., {0., 8.}}],
      Alignment->{Center, Bottom},
      Background->RGBColor[1, 0.5, 0.5],
      ImageSize->{30, 30}], 
     TogglerBox[Dynamic[$CellContext`x], {1->"1", 2->"2", 3->"3"}, 
      DynamicBox[ToBoxes[$CellContext`x, StandardForm],
       ImageSizeCache->{7., {0., 8.}}],
      Alignment->{Right, Bottom},
      Background->RGBColor[1, 0.5, 0.5],
      ImageSize->{30, 30}]}
   }],
  "Grid"]], "Output",
 ImageSize->{110, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->252736801]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->56049591],

Cell["By default, mouse click on the output toggles its value:", "ExampleText",
 CellID->717748738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Toggler", "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->787394367],

Cell[BoxData[
 TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1"]], "Output",
 ImageSize->{13, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25191380]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->644955576],

Cell["\<\
By setting AutoAction, the value toggles when the mouse moves over the \
output:\
\>", "ExampleText",
 CellID->1418399423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Toggler", "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"AutoAction", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->926786272],

Cell[BoxData[
 TogglerBox[3, {1->"1", 2->"2", 3->"3"}, "1",
  AutoAction->True]], "Output",
 ImageSize->{13, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159916182]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->291369397],

Cell["Specify the background color:", "ExampleText",
 CellID->74743362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Toggler", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"Background", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", "Purple", ",", "Gray", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->403746081],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    Background->RGBColor[1, 0.5, 0.5]], ",", 
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    Background->RGBColor[0.5, 0, 0.5]], ",", 
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    Background->GrayLevel[0.5]], ",", 
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    Background->RGBColor[1, 1, 0]]}], "}"}]], "Output",
 ImageSize->{88, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79552053]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->89792181],

Cell["Align with surrounding text:", "ExampleText",
 CellID->34501390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Toggler", "[", 
      RowBox[{"1", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "c"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", 
       RowBox[{"{", 
        RowBox[{"Bottom", ",", "Center", ",", "Top"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->329951516],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    BaselinePosition->Bottom], "xxx", 
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    BaselinePosition->Center], "xxx", 
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    BaselinePosition->Top]}],
  Row[{
    Toggler[1, {1, 2, 3}, BaselinePosition -> Bottom], 
    Toggler[1, {1, 2, 3}, BaselinePosition -> Center], 
    Toggler[1, {1, 2, 3}, BaselinePosition -> Top]}, "xxx"]]], "Output",
 ImageSize->{85, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105502730]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->80559024],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Toggler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Toggler"]], "InlineFormula"],
 " is enabled: "
}], "ExampleText",
 CellID->154813376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Toggler", "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->337013267],

Cell[BoxData[
 TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1"]], "Output",
 ImageSize->{13, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35417536]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->183655328],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled"], " ", "\[Rule]", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the toggler is disabled but visible in its current state:"
}], "ExampleText",
 CellID->576258550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Toggler", "[", 
  RowBox[{"2", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227336428],

Cell[BoxData[
 TogglerBox[2, {1->"1", 2->"2", 3->"3"}, "2",
  Enabled->False]], "Output",
 ImageSize->{13, 19},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20688910]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->236570335],

Cell["Increase the clickable area:", "ExampleText",
 CellID->76032107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Toggler", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"Background", "\[Rule]", "Yellow"}], ",", 
     RowBox[{"FrameMargins", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10", ",", "20"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68462332],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    Background->RGBColor[1, 1, 0],
    FrameMargins->0], ",", 
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    Background->RGBColor[1, 1, 0],
    FrameMargins->10], ",", 
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    Background->RGBColor[1, 1, 0],
    FrameMargins->20]}], "}"}]], "Output",
 ImageSize->{122, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->129589760]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->80483093],

Cell["Add margins to the toggler image:", "ExampleText",
 CellID->61980679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Toggler", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"Background", "\[Rule]", "Yellow"}], ",", 
     RowBox[{"ImageMargins", "\[Rule]", "m"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"m", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "10", ",", "20"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->617961338],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    Background->RGBColor[1, 1, 0],
    ImageMargins->0], ",", 
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    Background->RGBColor[1, 1, 0],
    ImageMargins->10], ",", 
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    Background->RGBColor[1, 1, 0],
    ImageMargins->20]}], "}"}]], "Output",
 ImageSize->{128, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->229074180]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->72153848],

Cell["Use numeric values:", "ExampleText",
 CellID->44549581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Toggler", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"Background", "\[Rule]", "Pink"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"s", ",", "s"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "40", ",", "100"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->755945079],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    Background->RGBColor[1, 0.5, 0.5],
    ImageSize->{10, 10}], ",", 
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    Background->RGBColor[1, 0.5, 0.5],
    ImageSize->{40, 40}], ",", 
   TogglerBox[1, {1->"1", 2->"2", 3->"3"}, "1",
    Background->RGBColor[1, 0.5, 0.5],
    ImageSize->{100, 100}]}], "}"}]], "Output",
 ImageSize->{191, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->716666755]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->125779189],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Toggler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Toggler"]], "InlineFormula"],
 " to create a tic-tac-toe board, where every cell knows the game logic:"
}], "ExampleText",
 CellID->297253058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Row", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<Player \>\"", ",", 
       RowBox[{"Toggler", "[", 
        RowBox[{
         RowBox[{"Dynamic", "[", "player", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"\"\<X\>\"", ",", "\"\<O\>\""}], "}"}], ",", 
         RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]}], "}"}], "]"}], 
    ",", 
    RowBox[{"Grid", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", "=", "\"\< \>\""}], "}"}], ",", 
          RowBox[{"Dynamic", "[", 
           RowBox[{"Toggler", "[", 
            RowBox[{
             RowBox[{"Dynamic", "[", 
              RowBox[{"x", ",", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"x", "=", "#"}], ";", 
                  RowBox[{"player", "=", 
                   RowBox[{"player", "/.", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\<X\>\"", "\[Rule]", "\"\<O\>\""}], ",", 
                    RowBox[{"\"\<O\>\"", "\[Rule]", "\"\<X\>\""}]}], 
                    "}"}]}]}], ";"}], ")"}], "&"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"\"\< \>\"", ",", "player"}], "}"}], ",", 
             RowBox[{"Enabled", "\[Rule]", 
              RowBox[{"(", 
               RowBox[{"Dynamic", "[", 
                RowBox[{"x", "\[Equal]", "\"\< \>\""}], "]"}], ")"}]}], ",", 
             RowBox[{"ImageSize", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"15", ",", "15"}], "}"}]}], ",", 
             RowBox[{"Alignment", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"Center", ",", "Center"}], "}"}]}]}], "]"}], "]"}]}], 
         "]"}], ",", 
        RowBox[{"{", "3", "}"}], ",", 
        RowBox[{"{", "3", "}"}]}], "]"}], ",", 
      RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->681572736],

Cell[BoxData[
 TagBox[GridBox[{
    {
     InterpretationBox[
      RowBox[{"\<\"Player \"\>", "\[InvisibleSpace]", 
       TogglerBox[Dynamic[$CellContext`player], {"X"->"\<\"X\"\>", 
        "O"->"\<\"O\"\>"}, 
        DynamicBox[ToBoxes[$CellContext`player, StandardForm],
         ImageSizeCache->{7., {0., 8.}}],
        Enabled->False]}],
      Row[{"Player ", 
        Toggler[
         Dynamic[$CellContext`player], {"X", "O"}, Enabled -> False]}]]},
    {
     TagBox[GridBox[{
        {
         DynamicBox[ToBoxes[
           Toggler[
            
            Dynamic[$CellContext`x$354, ($CellContext`x$354 = #; \
$CellContext`player = 
              ReplaceAll[$CellContext`player, {"X" -> "O", "O" -> "X"}]; 
             Null)& ], {" ", $CellContext`player}, Enabled -> 
            Dynamic[$CellContext`x$354 == " "], ImageSize -> {15, 15}, 
            Alignment -> {Center, Center}], StandardForm],
          ImageSizeCache->{15., {3., 12.}}], 
         DynamicBox[ToBoxes[
           Toggler[
            
            Dynamic[$CellContext`x$355, ($CellContext`x$355 = #; \
$CellContext`player = 
              ReplaceAll[$CellContext`player, {"X" -> "O", "O" -> "X"}]; 
             Null)& ], {" ", $CellContext`player}, Enabled -> 
            Dynamic[$CellContext`x$355 == " "], ImageSize -> {15, 15}, 
            Alignment -> {Center, Center}], StandardForm],
          ImageSizeCache->{15., {3., 12.}}], 
         DynamicBox[ToBoxes[
           Toggler[
            
            Dynamic[$CellContext`x$356, ($CellContext`x$356 = #; \
$CellContext`player = 
              ReplaceAll[$CellContext`player, {"X" -> "O", "O" -> "X"}]; 
             Null)& ], {" ", $CellContext`player}, Enabled -> 
            Dynamic[$CellContext`x$356 == " "], ImageSize -> {15, 15}, 
            Alignment -> {Center, Center}], StandardForm],
          ImageSizeCache->{15., {3., 12.}}]},
        {
         DynamicBox[ToBoxes[
           Toggler[
            
            Dynamic[$CellContext`x$357, ($CellContext`x$357 = #; \
$CellContext`player = 
              ReplaceAll[$CellContext`player, {"X" -> "O", "O" -> "X"}]; 
             Null)& ], {" ", $CellContext`player}, Enabled -> 
            Dynamic[$CellContext`x$357 == " "], ImageSize -> {15, 15}, 
            Alignment -> {Center, Center}], StandardForm],
          ImageSizeCache->{15., {3., 12.}}], 
         DynamicBox[ToBoxes[
           Toggler[
            
            Dynamic[$CellContext`x$358, ($CellContext`x$358 = #; \
$CellContext`player = 
              ReplaceAll[$CellContext`player, {"X" -> "O", "O" -> "X"}]; 
             Null)& ], {" ", $CellContext`player}, Enabled -> 
            Dynamic[$CellContext`x$358 == " "], ImageSize -> {15, 15}, 
            Alignment -> {Center, Center}], StandardForm],
          ImageSizeCache->{15., {3., 12.}}], 
         DynamicBox[ToBoxes[
           Toggler[
            
            Dynamic[$CellContext`x$359, ($CellContext`x$359 = #; \
$CellContext`player = 
              ReplaceAll[$CellContext`player, {"X" -> "O", "O" -> "X"}]; 
             Null)& ], {" ", $CellContext`player}, Enabled -> 
            Dynamic[$CellContext`x$359 == " "], ImageSize -> {15, 15}, 
            Alignment -> {Center, Center}], StandardForm],
          ImageSizeCache->{15., {3., 12.}}]},
        {
         DynamicBox[ToBoxes[
           Toggler[
            
            Dynamic[$CellContext`x$360, ($CellContext`x$360 = #; \
$CellContext`player = 
              ReplaceAll[$CellContext`player, {"X" -> "O", "O" -> "X"}]; 
             Null)& ], {" ", $CellContext`player}, Enabled -> 
            Dynamic[$CellContext`x$360 == " "], ImageSize -> {15, 15}, 
            Alignment -> {Center, Center}], StandardForm],
          ImageSizeCache->{15., {3., 12.}}], 
         DynamicBox[ToBoxes[
           Toggler[
            
            Dynamic[$CellContext`x$361, ($CellContext`x$361 = #; \
$CellContext`player = 
              ReplaceAll[$CellContext`player, {"X" -> "O", "O" -> "X"}]; 
             Null)& ], {" ", $CellContext`player}, Enabled -> 
            Dynamic[$CellContext`x$361 == " "], ImageSize -> {15, 15}, 
            Alignment -> {Center, Center}], StandardForm],
          ImageSizeCache->{15., {3., 12.}}], 
         DynamicBox[ToBoxes[
           Toggler[
            
            Dynamic[$CellContext`x$362, ($CellContext`x$362 = #; \
$CellContext`player = 
              ReplaceAll[$CellContext`player, {"X" -> "O", "O" -> "X"}]; 
             Null)& ], {" ", $CellContext`player}, Enabled -> 
            Dynamic[$CellContext`x$362 == " "], ImageSize -> {15, 15}, 
            Alignment -> {Center, Center}], StandardForm],
          ImageSizeCache->{15., {3., 12.}}]}
       },
       ColumnsEqual->False,
       GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       RowsEqual->False],
      "Grid"]}
   },
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Column"]], "Output",
 ImageSize->{77, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->278746722]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->568892072],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Checkbox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Checkbox"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Opener",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opener"]], "InlineFormula"],
 " are special cases of ",
 Cell[BoxData[
  ButtonBox["Toggler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Toggler"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->36865483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Toggler", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"False", ",", "True"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->160928523],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TogglerBox[Dynamic[$CellContext`x], {False->"False", True->"True"}, 
    DynamicBox[ToBoxes[$CellContext`x, StandardForm],
     ImageSizeCache->{35., {0., 8.}}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{35., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{102, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->384814780]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Checkbox", "[", 
    RowBox[{"Dynamic", "[", "y", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->135051261],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   CheckboxBox[Dynamic[$CellContext`y]], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{35., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{78, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->772707155]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Opener", "[", 
    RowBox[{"Dynamic", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "z", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->931726378],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   OpenerBox[Dynamic[$CellContext`z]], ",", 
   DynamicBox[ToBoxes[$CellContext`z, StandardForm],
    ImageSizeCache->{35., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{77, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->113469843]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11568],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Checkbox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Checkbox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Opener",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Opener"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TogglerBar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TogglerBar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Setter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Setter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Panel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Panel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PaneSelector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PaneSelector"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FlipView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FlipView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SlideView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SlideView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PopupMenu",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupMenu"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10797]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4346],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938],

Cell[TextData[ButtonBox["Views",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Views"]], "Tutorials",
 CellID->14681]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->962488420],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->209174661]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Toggler - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 4.7705226}", "context" -> "System`", 
    "keywords" -> {
     "toggler", "flipping state", "round robin state", "mode switching"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Toggler[x] represents a toggler button with setting x, that toggles \
between True and False. Toggler[Dynamic[x]] takes the setting to be the \
dynamically updated current value of x, with the value of x being toggled if \
the button is clicked. Toggler[x, {val_1, val_2, ...}] represents a toggler \
button that cycles through any sequence of values val_i. Toggler[x, {val_1 -> \
pict_1, val_2 -> pict_2, ...}] cycles through values val_i displaying them as \
pict_i. Toggler[x, vlist, dpict] displays as dpict if x is none of the val_i. \
", "synonyms" -> {}, "title" -> "Toggler", "type" -> "Symbol", "uri" -> 
    "ref/Toggler"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15430, 490, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->763780478]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 73365, 2166}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2752, 59, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3375, 86, 1572, 37, 70, "ObjectNameGrid"],
Cell[4950, 125, 4077, 133, 70, "Usage",
 CellID->18386]
}, Open  ]],
Cell[CellGroupData[{
Cell[9064, 263, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9542, 280, 535, 20, 70, "Notes",
 CellID->2192],
Cell[10080, 302, 302, 12, 70, "Notes",
 CellID->8552],
Cell[10385, 316, 225, 8, 70, "Notes",
 CellID->16217],
Cell[10613, 326, 75, 1, 70, "Notes",
 CellID->32524],
Cell[10691, 329, 332, 12, 70, "Notes",
 CellID->14988],
Cell[11026, 343, 574, 22, 70, "Notes",
 CellID->693],
Cell[11603, 367, 69, 1, 70, "Notes",
 CellID->15089],
Cell[11675, 370, 2104, 54, 70, "3ColumnTableMod",
 CellID->7688],
Cell[13782, 426, 552, 21, 70, "Notes",
 CellID->12296],
Cell[14337, 449, 709, 24, 70, "Notes",
 CellID->20268],
Cell[15049, 475, 344, 10, 70, "Notes",
 CellID->307511469]
}, Closed]],
Cell[CellGroupData[{
Cell[15430, 490, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->763780478],
Cell[CellGroupData[{
Cell[15815, 504, 148, 5, 70, "ExampleSection",
 CellID->327451266],
Cell[15966, 511, 83, 1, 70, "ExampleText",
 CellID->1086640992],
Cell[CellGroupData[{
Cell[16074, 516, 190, 6, 28, "Input",
 CellID->7237],
Cell[16267, 524, 208, 6, 40, "Output",
 CellID->72023596]
}, Open  ]],
Cell[16490, 533, 125, 3, 70, "ExampleDelimiter",
 CellID->281942291],
Cell[16618, 538, 160, 6, 70, "ExampleText",
 CellID->429962552],
Cell[CellGroupData[{
Cell[16803, 548, 320, 10, 70, "Input",
 CellID->773061255],
Cell[17126, 560, 452, 12, 70, "Output",
 CellID->123575779]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17627, 578, 220, 7, 70, "ExampleSection",
 CellID->260187470],
Cell[17850, 587, 58, 1, 70, "ExampleText",
 CellID->370799704],
Cell[CellGroupData[{
Cell[17933, 592, 313, 9, 70, "Input",
 CellID->220419386],
Cell[18249, 603, 237, 7, 70, "Output",
 CellID->1869364164]
}, Open  ]],
Cell[18501, 613, 123, 3, 70, "ExampleDelimiter",
 CellID->3698577],
Cell[18627, 618, 190, 5, 70, "ExampleText",
 CellID->352579597],
Cell[CellGroupData[{
Cell[18842, 627, 257, 8, 70, "Input",
 CellID->187164940],
Cell[19102, 637, 260, 9, 70, "Output",
 CellID->974218456]
}, Open  ]],
Cell[19377, 649, 131, 4, 70, "ExampleText",
 CellID->62548910],
Cell[CellGroupData[{
Cell[19533, 657, 393, 13, 70, "Input",
 CellID->254736649],
Cell[19929, 672, 508, 16, 70, "Output",
 CellID->751519139]
}, Open  ]],
Cell[20452, 691, 125, 3, 70, "ExampleDelimiter",
 CellID->704888758],
Cell[20580, 696, 128, 2, 70, "ExampleText",
 CellID->306982536],
Cell[20711, 700, 658, 22, 70, "Input",
 CellID->505851930],
Cell[CellGroupData[{
Cell[21394, 726, 365, 11, 70, "Input",
 CellID->111895333],
Cell[21762, 739, 19327, 333, 70, "Output",
 CellID->89588863]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41138, 1078, 222, 7, 70, "ExampleSection",
 CellID->424266231],
Cell[CellGroupData[{
Cell[41385, 1089, 230, 7, 70, "ExampleSubsection",
 CellID->602625232],
Cell[41618, 1098, 71, 1, 70, "ExampleText",
 CellID->253528423],
Cell[CellGroupData[{
Cell[41714, 1103, 623, 19, 70, "Input",
 CellID->257532128],
Cell[42340, 1124, 887, 27, 70, "Output",
 CellID->95089154]
}, Open  ]],
Cell[43242, 1154, 75, 1, 70, "ExampleText",
 CellID->13623532],
Cell[CellGroupData[{
Cell[43342, 1159, 858, 26, 70, "Input",
 CellID->91903427],
Cell[44203, 1187, 2612, 65, 70, "Output",
 CellID->252736801]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46864, 1258, 230, 7, 70, "ExampleSubsection",
 CellID->56049591],
Cell[47097, 1267, 99, 1, 70, "ExampleText",
 CellID->717748738],
Cell[CellGroupData[{
Cell[47221, 1272, 185, 6, 70, "Input",
 CellID->787394367],
Cell[47409, 1280, 200, 6, 70, "Output",
 CellID->25191380]
}, Open  ]],
Cell[47624, 1289, 125, 3, 70, "ExampleDelimiter",
 CellID->644955576],
Cell[47752, 1294, 132, 4, 70, "ExampleText",
 CellID->1418399423],
Cell[CellGroupData[{
Cell[47909, 1302, 232, 7, 70, "Input",
 CellID->926786272],
Cell[48144, 1311, 221, 7, 70, "Output",
 CellID->159916182]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48414, 1324, 231, 7, 70, "ExampleSubsection",
 CellID->291369397],
Cell[48648, 1333, 71, 1, 70, "ExampleText",
 CellID->74743362],
Cell[CellGroupData[{
Cell[48744, 1338, 441, 14, 70, "Input",
 CellID->403746081],
Cell[49188, 1354, 547, 15, 70, "Output",
 CellID->79552053]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[49784, 1375, 236, 7, 70, "ExampleSubsection",
 CellID->89792181],
Cell[50023, 1384, 70, 1, 70, "ExampleText",
 CellID->34501390],
Cell[CellGroupData[{
Cell[50118, 1389, 517, 16, 70, "Input",
 CellID->329951516],
Cell[50638, 1407, 619, 17, 70, "Output",
 CellID->105502730]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[51306, 1430, 227, 7, 70, "ExampleSubsection",
 CellID->80559024],
Cell[51536, 1439, 204, 8, 70, "ExampleText",
 CellID->154813376],
Cell[CellGroupData[{
Cell[51765, 1451, 185, 6, 70, "Input",
 CellID->337013267],
Cell[51953, 1459, 200, 6, 70, "Output",
 CellID->35417536]
}, Open  ]],
Cell[52168, 1468, 125, 3, 70, "ExampleDelimiter",
 CellID->183655328],
Cell[52296, 1473, 370, 12, 70, "ExampleText",
 CellID->576258550],
Cell[CellGroupData[{
Cell[52691, 1489, 235, 7, 70, "Input",
 CellID->227336428],
Cell[52929, 1498, 218, 7, 70, "Output",
 CellID->20688910]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[53196, 1511, 233, 7, 70, "ExampleSubsection",
 CellID->236570335],
Cell[53432, 1520, 70, 1, 70, "ExampleText",
 CellID->76032107],
Cell[CellGroupData[{
Cell[53527, 1525, 469, 14, 70, "Input",
 CellID->68462332],
Cell[53999, 1541, 519, 16, 70, "Output",
 CellID->129589760]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[54567, 1563, 232, 7, 70, "ExampleSubsection",
 CellID->80483093],
Cell[54802, 1572, 75, 1, 70, "ExampleText",
 CellID->61980679],
Cell[CellGroupData[{
Cell[54902, 1577, 470, 14, 70, "Input",
 CellID->617961338],
Cell[55375, 1593, 519, 16, 70, "Output",
 CellID->229074180]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[55943, 1615, 229, 7, 70, "ExampleSubsection",
 CellID->72153848],
Cell[56175, 1624, 61, 1, 70, "ExampleText",
 CellID->44549581],
Cell[CellGroupData[{
Cell[56261, 1629, 524, 17, 70, "Input",
 CellID->755945079],
Cell[56788, 1648, 544, 16, 70, "Output",
 CellID->716666755]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[57393, 1671, 227, 7, 70, "ExampleSection",
 CellID->125779189],
Cell[57623, 1680, 254, 8, 70, "ExampleText",
 CellID->297253058],
Cell[CellGroupData[{
Cell[57902, 1692, 2089, 55, 70, "Input",
 CellID->681572736],
Cell[59994, 1749, 5268, 125, 70, "Output",
 CellID->278746722]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[65311, 1880, 237, 7, 70, "ExampleSection",
 CellID->568892072],
Cell[65551, 1889, 446, 17, 70, "ExampleText",
 CellID->36865483],
Cell[CellGroupData[{
Cell[66022, 1910, 307, 10, 70, "Input",
 CellID->160928523],
Cell[66332, 1922, 453, 12, 70, "Output",
 CellID->384814780]
}, Open  ]],
Cell[CellGroupData[{
Cell[66822, 1939, 222, 7, 70, "Input",
 CellID->135051261],
Cell[67047, 1948, 327, 10, 70, "Output",
 CellID->772707155]
}, Open  ]],
Cell[CellGroupData[{
Cell[67411, 1963, 220, 7, 70, "Input",
 CellID->931726378],
Cell[67634, 1972, 325, 10, 70, "Output",
 CellID->113469843]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[68020, 1989, 311, 9, 70, "SeeAlsoSection",
 CellID->11568],
Cell[68334, 2000, 2168, 80, 70, "SeeAlso",
 CellID->10797]
}, Open  ]],
Cell[CellGroupData[{
Cell[70539, 2085, 313, 9, 70, "TutorialsSection",
 CellID->4346],
Cell[70855, 2096, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[71017, 2101, 148, 3, 70, "Tutorials",
 CellID->341631938],
Cell[71168, 2106, 121, 3, 70, "Tutorials",
 CellID->14681]
}, Open  ]],
Cell[CellGroupData[{
Cell[71326, 2114, 319, 9, 70, "MoreAboutSection",
 CellID->962488420],
Cell[71648, 2125, 141, 3, 70, "MoreAbout",
 CellID->209174661]
}, Open  ]],
Cell[71804, 2131, 27, 0, 70, "History"],
Cell[71834, 2133, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

