(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10221,        368]
NotebookOptionsPosition[      7260,        269]
NotebookOutlinePosition[      8597,        307]
CellTagsIndexPosition[      8513,        302]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reading Textual Data" :> 
          Documentation`HelpLookup["paclet:tutorial/ReadingTextualData"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Reading Textual Data\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WordSeparators" :> 
          Documentation`HelpLookup["paclet:ref/WordSeparators"], "NullWords" :> 
          Documentation`HelpLookup["paclet:ref/NullWords"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"WordSeparators\"\>", 
       2->"\<\"NullWords\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TokenWords", "ObjectName",
 CellID->26176],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["TokenWords",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TokenWords"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Read",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Read"]], "InlineFormula"],
     " and related functions which gives a list of token words to be used to \
delimit words. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6586]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["TokenWords",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TokenWords"]], "InlineFormula"],
 " is a list of strings which are used as delimiters for words to be read. "
}], "Notes",
 CellID->26874],

Cell[TextData[{
 "The delimiters specified by ",
 Cell[BoxData[
  ButtonBox["TokenWords",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TokenWords"]], "InlineFormula"],
 " are themselves returned as words. "
}], "Notes",
 CellID->30242]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->112490564],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->571859076],

Cell["A text file:", "ExampleText",
 CellID->278285583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "\"\<ExampleData/language\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2073893962],

Cell["22*a*b+56*c+13*a*d", "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->237111386]
}, Open  ]],

Cell["Read the file:", "ExampleText",
 CellID->1099146713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/language\>\"", ",", "Word"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1762049528],

Cell[BoxData[
 RowBox[{"{", "\<\"22*a*b+56*c+13*a*d\"\>", "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->151115254]
}, Open  ]],

Cell["\<\
Read the file using token words to delimit words in the text:\
\>", "ExampleText",
 CellID->763095421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{"\"\<ExampleData/language\>\"", ",", "Word", ",", 
   RowBox[{"TokenWords", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<+\>\"", ",", "\"\<*\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->962140940],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"22\"\>", ",", "\<\"*\"\>", ",", "\<\"a\"\>", ",", "\<\"*\"\>", 
   ",", "\<\"b\"\>", ",", "\<\"+\"\>", ",", "\<\"56\"\>", ",", "\<\"*\"\>", 
   ",", "\<\"c\"\>", ",", "\<\"+\"\>", ",", "\<\"13\"\>", ",", "\<\"*\"\>", 
   ",", "\<\"a\"\>", ",", "\<\"*\"\>", ",", "\<\"d\"\>"}], "}"}]], "Output",
 ImageSize->{301, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->307284897]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31248],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WordSeparators",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WordSeparators"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NullWords",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NullWords"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2242]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30241],

Cell[TextData[ButtonBox["Reading Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ReadingTextualData"]], "Tutorials",
 CellID->30509]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TokenWords - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 5.5674180}", "context" -> "System`", 
    "keywords" -> {
     "markers in data files", "tokens in data files", "words as tokens"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "TokenWords is an option for Read and related functions which gives a \
list of token words to be used to delimit words. ", 
    "synonyms" -> {"token words"}, "title" -> "TokenWords", "type" -> 
    "Symbol", "uri" -> "ref/TokenWords"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3638, 126, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->112490564]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8370, 295}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1278, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1901, 59, 48, 1, 70, "ObjectName",
 CellID->26176],
Cell[1952, 62, 627, 19, 70, "Usage",
 CellID->6586]
}, Open  ]],
Cell[CellGroupData[{
Cell[2616, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3094, 103, 265, 8, 70, "Notes",
 CellID->26874],
Cell[3362, 113, 239, 8, 70, "Notes",
 CellID->30242]
}, Closed]],
Cell[CellGroupData[{
Cell[3638, 126, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->112490564],
Cell[CellGroupData[{
Cell[4023, 140, 148, 5, 70, "ExampleSection",
 CellID->571859076],
Cell[4174, 147, 55, 1, 70, "ExampleText",
 CellID->278285583],
Cell[CellGroupData[{
Cell[4254, 152, 133, 3, 70, "Input",
 CellID->2073893962],
Cell[4390, 157, 99, 2, 70, "Print",
 CellID->237111386]
}, Open  ]],
Cell[4504, 162, 58, 1, 70, "ExampleText",
 CellID->1099146713],
Cell[CellGroupData[{
Cell[4587, 167, 158, 4, 70, "Input",
 CellID->1762049528],
Cell[4748, 173, 206, 6, 36, "Output",
 CellID->151115254]
}, Open  ]],
Cell[4969, 182, 112, 3, 70, "ExampleText",
 CellID->763095421],
Cell[CellGroupData[{
Cell[5106, 189, 268, 7, 70, "Input",
 CellID->962140940],
Cell[5377, 198, 469, 10, 36, "Output",
 CellID->307284897]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5907, 215, 311, 9, 70, "SeeAlsoSection",
 CellID->31248],
Cell[6221, 226, 464, 17, 70, "SeeAlso",
 CellID->2242]
}, Open  ]],
Cell[CellGroupData[{
Cell[6722, 248, 314, 9, 70, "TutorialsSection",
 CellID->30241],
Cell[7039, 259, 149, 3, 70, "Tutorials",
 CellID->30509]
}, Open  ]],
Cell[7203, 265, 27, 0, 70, "History"],
Cell[7233, 267, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

