(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38658,        910]
NotebookOptionsPosition[     35450,        802]
NotebookOutlinePosition[     36734,        840]
CellTagsIndexPosition[     36649,        835]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Bottom" :> Documentation`HelpLookup["paclet:ref/Bottom"], 
         "Center" :> Documentation`HelpLookup["paclet:ref/Center"], "Axis" :> 
         Documentation`HelpLookup["paclet:ref/Axis"], "Baseline" :> 
         Documentation`HelpLookup["paclet:ref/Baseline"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Bottom\"\>", 2->"\<\"Center\"\>", 
      3->"\<\"Axis\"\>", 4->"\<\"Baseline\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Top", "ObjectName",
 CellID->28742],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Top",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Top"]], "InlineFormula"],
     " \[LineSeparator]is a symbol that represents the top for purposes of \
alignment and positioning. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21252]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->29064330],

Cell["Align the contents of a grid to the top:", "ExampleText",
 CellID->94306447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"a", ",", 
      SqrtBox["x"], ",", "b", ",", 
      FractionBox["x", "y"], ",", "c"}], "}"}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Top"}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "All"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176068346],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", 
     SqrtBox["x"], "b", 
     FractionBox["x", "y"], "c"}
   },
   ColumnsEqual->False,
   GridBoxAlignment->{"Columns" -> {{Automatic}}, "Rows" -> {{Top}}},
   GridBoxFrame->{"Columns" -> True, "Rows" -> {{True}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
   RowsEqual->False],
  "Grid"]], "Output",
 ImageSize->{102, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->138747686]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->825938041],

Cell[TextData[{
 "Place the control of ",
 Cell[BoxData[
  ButtonBox["MenuView",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MenuView"]], "InlineFormula"],
 " at the top of the panel:"
}], "ExampleText",
 CellID->156257647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MenuView", "[", 
  RowBox[{
   RowBox[{"Range", "[", "2", "]"}], ",", 
   RowBox[{"ControlPlacement", "\[Rule]", "Top"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->115448565],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = 1}, 
   InterpretationBox[
    StyleBox[
     PanelBox[
      TagBox[GridBox[{
         {
          ItemBox[
           PopupMenuBox[Dynamic[BoxForm`var$$], {1->"1", 2->"2"},
            DefaultBaseStyle->"MenuViewLabel",
            Enabled->Automatic],
           Alignment->Left,
           StripOnInput->False]},
         {
          ItemBox[
           StyleBox[Cell[BoxData[
             PaneSelectorBox[{1->"1", 2->"2"}, Dynamic[BoxForm`var$$],
              Alignment->{Left, Top},
              ImageSize->All]],
             Background->GrayLevel[1]],
            Deployed->False,
            StripOnInput->False],
           Background->GrayLevel[1],
           Frame->True,
           FrameStyle->GrayLevel[0.8235294117647058],
           StripOnInput->False]}
        },
        ColumnsEqual->False,
        GridBoxAlignment->{"Columns" -> {{Left}}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        RowsEqual->False],
       "Grid"],
      BaselinePosition->Automatic,
      DefaultBaseStyle->"MenuView",
      FrameMargins->6,
      ImageMargins->Automatic],
     Deployed->True,
     StripOnInput->False],
    MenuView[{1, 2}, ControlPlacement -> Top]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{70, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110539898]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleText",
 CellID->467567170],

Cell["Align the top of a grid with the baseline of the text:", "ExampleText",
 CellID->458844947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"Grid", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
     RowBox[{"Frame", "\[Rule]", "All"}], ",", 
     RowBox[{"BaselinePosition", "\[Rule]", "Top"}]}], "]"}], ",", "y"}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->94197876],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   TagBox[GridBox[{
      {"a", "b"},
      {"c", "d"}
     },
     BaselinePosition->Top,
     ColumnsEqual->False,
     GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
     RowsEqual->False],
    "Grid"], ",", "y"}], "}"}]], "Output",
 ImageSize->{93, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->45709746]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->338216689],

Cell["Align text to the top of the enclosing graphic:", "ExampleText",
 CellID->125552549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Text", "[", 
      RowBox[{"\"\<ABCDEF\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Top"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Top"}], "}"}]}], "]"}], ",", 
     RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->186093363],

Cell[BoxData[
 GraphicsBox[{
   InsetBox["\<\"ABCDEF\"\>", ImageScaled[{0.5, 1.}], {Automatic, Top}], 
   CircleBox[{0, 0}]},
  Axes->True,
  Ticks->None]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->219450764]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->493017311],

Cell["View 3D objects from the top:", "ExampleText",
 CellID->727675960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sphere", "[", "]"}], ",", 
      RowBox[{"Cuboid", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Sphere", "[", "]"}], ",", 
       RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", "Top"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->198155887],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{SphereBox[{0, 0, 0}], CuboidBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[{SphereBox[{0, 0, 0}], CuboidBox[{0, 0, 0}]},
    ViewPoint->Top,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydewdYm8ears/JOdvO7p6zu/fe3fvc5+7deveWHbBjO3HcktixE8f5wdhg
Yxvc+Om9995ErwIhBAgQCASIIkA0CQQSvfdmirEBg8HY2BiQ3udeocTnZEmc
kDyP9GtmNOV9v++b+We+maHuu1iY2t53sTS5/w+fO913sLA0cf6Hi/ZO6qT3
fnHo0CFT9Zf+u0Pq8P9ThzRfUwDqRFNT019oQr9Uh+7uhd5TB9S/6uehr//5
dorxXsqvvo5/nfRNnv+Qdnsv7de/T/mPtX0n/ea3Wt0L/lL9+MUfat73z7fj
Bvvi772z5Hv7cl7bF//VO0v+al9OvX3xX7+z5K/35dTdF/+jd5b8o305qX3x
P35nyT/el/PyvvifvLPkn+zLeWlf/E/fWfJP9+X8fF/8z95Z8s/25fxve4/f
PCC0DaGdCe1BaF9CBxE6nNCRhI4mdByhEwh96JeJhP7v+8r+5p2t/GZfzv+y
9/jdDULfJ7QloR01DfkTOljTkLqVeEInEzqV0GxCZxCaS+hcQv8qT93we+pA
JqF/X8u3av3zd7b/5/ty/vXe42/1CH2L0CaEttZAcNdwVUOIIHSMhmWKpn11
a9mE5hGaT+hCQhcTWqhFl2nR5dq0SEstico9VBXatPBrVH+zr62/eCeqv9iX
87d7j3+4QmhDQt8jtDmh7QntSmhvQgcSOozQUW8FwyI0RyOVPVRatECLLtFA
UuOpPkzXHKHrDtP1h2nJYVqq/rxPS4/QDUfpOjVmQv9uX6t/+U58f/k98j30
9xShr2kE9+BbuvPTCI6hEVyiRnHphM7SaE2Nr0hrT2TlWnSlFi3Wpuu06YYj
tPQY3fQh3fwBLT9Otx6n2z6gf9l2Qi1JdaD1GN1yhP5O+799J9Lffk9POfRv
aqRqYRoQ2ojQtEbLTm/Bhmi0rLblpD1hmnKIKVfLjKdtVqBtVqRtVnrYrOJ9
s6rjZjXHzeqPmUmPmck+MGs5Ydr6Ed1+mu48Q3edobvP0L1n6b6P6b5P6L6z
dO9puusk3foh/R1b/907Ue/982d7w+//0SG02hivE/oOoU01fe/3SEP3Op5p
HDFLImYsYs4h5tnEIk/LokDboviwRdkRi8ojFuJjFnUfWEg+smw6ZdlyykJx
xrLtrGXnJxbd58z7PjPrv2A6eJEeukgPf06PfEGPqj/qwAV6+Dzd/wmtlvmf
qjH8zTtR/tU+Pnuj8S/Voj30f3U1kI2/JVzPb4RrFkEsYollErFmEWsOsc4m
1nlaNoWHbUuO2JYdta08Zif+wK7+hJ30pK3sjK38Y9u2czYdn1l3X7Tu/dym
/5L10JdWw19ZjVIW4zpmk7r01BV6Spee1jWdVocpevIrevwSPXSe/s5Y+1cH
ZvHeWxbkaxO5rRkIrL6xZzM/YhFMrBjEOpbYJhE7lpY9R9uBe9iRd8Sp4H3n
4mMuZR+4VH7kKj7pWn/aVXrWVfaJq/y8S9sFl84vXLovOfdddhrUcRy+4jCq
Zz9+1W7ymt20gc3MdcvZG+ZzN0znb5jN3zB9dIOev07P6dMzevT4Zfo7b5yD
c/nlWy7aX3PR9E1TS2LmQMzdiKUPsQki9gziGEOcErWcU7Rc07Xdsg578I56
Fhz3LP7Aq+xDb9FJH/EZn/qPfaTnfGWf+cgv+rRd8um87N1Deffreg3qeY5c
8xgzcJ+44Tpt6DJzy2nuttO8kcOCsd3jOzZP7lgs3jFfvGO2dMd00Zh+cpte
MKQfXqW/8/b9EUZ/mL+85fO+nmasMSSm94iZBbGwI1YuxNaLOAQQ5zDiGk3c
47U8mdpe7MM+mYd9c4/4848GFB0PLD0RKDoVJD4bVPdpsOSzYNnnwfJLwW1f
BXfqBPXoBfVfCxoyCBy5ETB+03/ytt+0kc/MHe/5u54L9z2ePHBbNHFZop2W
afsVU5tVM4tVU4tV2nKVpp/ep5fu0gu36DEdev9M5idoao/VUR3NuHSDmN4h
5qbE2obYOxMnT+LqTzxCiFck8YkjfslaASztwIzDwTmHQ/KPhgo+DBOeDK84
w6j+hFF7PqLhYkTTpYiWryLadCI69SJ6rkX0X2cMGjJGboWPG4VN3Ql7eC90
9kHwvEnQgmnAopn/koXvU0vvVSvPZ9bua9bO6zYOz21snlurP1bPrUzXLOhn
ZvTSPfo7c7SDMdsj9Z6GmT6xuE2sHxB7S+LsQNzciacv8Q0i/uEkMIYEJ5LQ
VBLO0WZw34/gHY8sOBFVfDq67OOYynOxNRdiG76Ia7wc16wT16oX13Etrvt6
XJ9h3ODtuBHj2LG7MZP3ox+aRM+aRj0yj3xsGbFoFb5sE7piG/zMLnDN3v+5
g++Go/cLR/eXTi6bTg6bTvabjtabDmYv7EzXrU2fmtLfmbf+CLPT6ria0duP
2VVifZPY3yXOZsTdlni5EF8vEhBAgkNJaBQJjycRTK0o9pGYzGOxOR/G8U/G
F51NKP00UfRZkvjz5Povk6UUs/kKU3GN2X6d2WXI7LvNHDRmjtxjjj1InqST
ps2SZi0S560SHlvHL9rGLtvHrDpGP3OKXHdmbLiEvXQN2XQLfOXu/9rde8vD
442HyxsPxy1329duFpvOFi8c6FXLvXnHj47hGg19RBELPWJjSByNiJsJ8bIi
fo4k0J2E+JLwYBLBINGxJDbpcFzq0QTO8cTsE8l5p5mFH6eUnEutuMiqupRW
+1WaRJfddJXdos9uu5HeeSu9xzi9/y576AF7lGZPmLGnLdJmrdPmbVmP7VIX
HZjLTskrLknPXBOeu8e/8Ih76RnzyivytTdjyyd02zd4x9d/189nx89j29fl
jY/9trfVaw/LV670mt3eoujQj7yTTmtUo1aTlR6xMyAuhsTzLvE1J4F2JNSF
MLxIZACJCSNxUVqJ8UeSmceY7A9TM0+ycs+w+Z+kF53nlH6eIfoyQ0xl1l/J
kl7Lar6epbjJ7TDidt/h9t3nDppwR8y44xZZU1ZZM7aZc/aZC44Zi86cZdf0
FXf2M4+0da/UDe+UTd/kV35JW/7xbwJitwOjdoMiVMFhyuDg3WD/3WDvnSD3
nUDH3QCbbV+LLU961Y5+NyfNvOzMW07WOsRRj7jpE5/bJMCEhFgRhiOJciex
viQhmCQxtJgxR1ITj6WlfpjOOcnJPpuZ92lW4Wfcki+yyy/nVOnk1urlSvR5
TTd48lt5bcZ5nffyek3yBkzzhi3yxqzyJm14D+15s465j5xzn7jmLLlnr3hm
P/PmrvtmbvhlvAxIfxXI3gpibYek7IQm74YlqsLjVOHRKkaEkhGqZAQqGX7K
cE9VmLMq1HYn0OKVt9kP6Oq3b0dzNTdrijjpEg894neDBN8l4WYkypbEOpME
L5IcQFJDtdMi30+PO56RfCIr7RQ382xOzqe5/Au8oi/ySr/KF+nyxVcL6q8X
Sm8WNhsVtt4VdDwQdNOCfnPBkKVg1EYwYSeYdhTMOBfOuxY+di9Y9OQ/9c5f
9c1f9+dtBOa+DMp5FZK9FZq1HZ6xw+AoI9iqKJYqiqmKTlRFx6liopUxDFVM
iComANHeiHRRMux3Qy1e+dKa1cIPzDs/0ehsj5oO8bxCAq6R0Nsk4gGJtSQJ
DiTZjaT6EHaQNif8/czo49yEEzkpp3jpZ/O55/i8CwUFlwpLKEH5laKqa8W1
N0okt4RNxkL5PWGbSWmnaWmvRemAdemwbemYQ+mkU+lDF+Gcu3DBU/jEu2TZ
t3jFv3gtsOh5cOGL0IJXYfwtRv6byLydqFxldLYqJgtxGar4dFU8S5XAVCUm
qhLjkBiFxHAkBCHeB3Guu1EO22FW6570u8dCzQz8Uw0/Kw0/L10SeIWE3yBR
d0i8KUm2IalOhO1BMvy0skKOZEccz409kZ98is86W5hxTpB9sTj/yxIBJRTq
lVbol1UbltfdrpDeqZDdFylMRO1mom5LUZ9N5aBd5Yhj5bizaMpNNOMhmvcS
PfatWPKveBpY/iy4fD20dCNcuMkoeR1Z/Ca6aCemUBlXoIrPRwIPSTlI5qqY
mSpmuiqFhVQmUhOQEoMUBpjBSPZVJrqr4ux2GGY/MN5rOJ5Tj4tqghTx1iFB
OoRxjcTcIgn3SYo5SbMjHFeS5a2VE3CEF3YsP+pEQfypIubHxexzwsyLpblf
lvF1Kor1RGUGlZWGVTW3q+rvVDfeF7fQ4lZzcadVTY9tTb9DzbBTzZhrzaR7
zUOvmlmfmkd+4icB4uXg6pXQ6rXwqo2IypdRolfRFVux5dvxZbsJQlVSCZKL
wCxECh+sPKTlqthcsDOQzkZ6KtKTkB6L9EikhYDlp2K6qRJsXoWavnutoVlr
ntdo0p4iXhQJokiELom7TpKMSKoJSbckmQ4k253k+RzhBx0rDP+wKOZUSeLZ
0tRz5ekXK7hfVvJ0qgqvVpcY1JQb1lQZ1dberZM8qG8yrZdbNLRbN3TZNfQ6
SgadJSNuknEPyZS3ZMZXMh/Q8DioYTGk/mlY/TNG3Xpk7Yvo2s3Ymtfx4u3E
6t2kSiVTpEopB6sMaUKwi8ERIKMAmfnIzEVWFrI44KYhKxlZ8ciKQkYo0v3A
clEmWP3AquotU3WH9KBIoJomReL0SLIhSbtDMkwJ15rwnAjfQ7vQ72hxyIfC
iFNlsWcrks5Vsi5WZXwpztapyb9aJzCoF95sqDCSVN+V1D2QSs0amy2bFDZN
HfaybkdZn4tsyF026imb8JFN+8lmA2WPgmVPwpqWGE0rkY1r0Y3PY6Uv4yWv
Ehu2kut3mHXK1FpVWo2KXQ1OJTJEyCxHVim4JcgWIKcAuXnIzQEvEzw2eCnI
TUBOFLihyPBWsZx+gKlmPX5Bo1MXivhThKFmqkOY+oR9i2TeIznmJN+WFLpo
FXsdEfofLwv9SBR1tir+nJh5sSbty7pMnfrcqxK+gbToZmOpUZPonkxs0lxv
1tJo2dJiI2+1l3c6KXpcFf0eimEvxZivYtJf8TBIMReiWAhXLEbIl6PkqzHy
9biWjYTmzSTZa2bTm9TG3bRGZbpExWlAZh2yapEtRk41civBK0deKfJLwBeA
z0cBDwVcFKSDnwp+AvKikBuMLE8Vy+YHVvlv+dpRxJci4WqyFGFeIezrJOs2
4d0nfAsisCdCt8Pl3sdFgR9VhZ8RR39am3ChPuVLSbqONOtqE89AVnCzudio
peyevNJEUWPW2mDV1mTbJndob3Nq73Lt6PXoGPDuGPbtGA/omArumAntmA/v
eBzZsRjd/jS2/VlC+/OkthfM1leprVssxTZbvstpUWY2q7hNyG5ErgS8BuTV
gV+DgmoUVkJQjqJSFBWjuADFeSjORhEHRakQJKAgEnmBqizXH+N7UWPGoRSJ
VZOlSPo1wr1BeEakwIQUW2mVOmpXuB+t8j0hDjpdx/i0IeaCNPFSYyol4+i1
cA3keTcVhUatJffayk3aq807aq06JbZdMocuuXN3u1t3l2dPn3fPoF/PSGDP
RHDPdFjPLKPnUVTP45iepbjulcTuteSu5yldL1mdr9idbzgdO5ntyqw2VXar
KleBvBbkN4PfhEIpBBIU1aO4BiXVEIpQWobSEpQJUJaP0myUZkCYipIECBgq
vt9uutW7PU4a38nnFLHUmHMURZLVjHUJ9xrJu0EKjUkJrVVmrV3p9L7Y44Na
v1MNIZ9IIz5riv2iOekrOUtPkWHQlm3Ynm/UIbjXKTTpqjDvqbbqqbPtlTr0
NTv3Kdz6Ozz7u30G+v0HhgIHRkMGJsIHpiMGZqMHHsUOPIkfWE7qX2X2r6X2
baT1bab3vs7o3c7q2c3uVuZ2qXidqvx2FLShsBVFchQ3o0SG0kaUSVBeh4oa
VFRBVAGREJVFqORDlANRBspTUBqHolDwXH/Az/aWtYvGqBMokkYR7hWSp08E
hlrCu9oVZoerbA/XOB+v9/xI4n+2KfR8c+Tn8rivWpOvtKfpd2QaduUYdeff
7Sky6S016xNZ9YttB+odBhudB5vdhlo9hzt9hnv8R/qDRoZDR8bCRyYjRx5G
j8zFjSwkjCwmjTxNGV5lDa+zh15whjYzB7e4A9s5A0pevyq/T1XQi8JuFHWh
pBPCdpS2oVyBihaIZKiUoqoB1bWoroZYBHEZxMUQ8yHOQVU6Kpkoi4LA5wCs
/SgSQ5FUimRSJE+PCAyI8KaW6J52tfnhOrujEpcTjV5nmgPOyUMvtkZdbo/X
7WRe62bf6Mm83Zd7t5//YKDIbLDMaqjSdrjGYaTeebTRbbTFc6zNd7zTf7w3
aHwgdHw4fGIscmIyZmImbmI+cWIheXwxZfxp2viz9PHnGWMvssZeZY9u5Y7s
5A0r+cOqwiEUDaC4H8I+lPWivBsVnajsQFUbqhUQt6CmCbVS1NWjToz6StSX
oa4IdXzUciFmozIBpSE/xvoLioRRJIkiHIrkUqTwKhHqE9EtLfF97TqL96X2
H8hcT7V4f9IaeKE97MvOKJ3u+Ku9KTf62bcGsu4M5j4YLjAbKbYcLbMdq3QY
r3GeaHCbaPKclPtOtflPdQVN9YZODzCmRyKnx2Omp+KnZxKn55nTj1Onl9Km
VzjTzzKnnnOnXuZMvuJNvsmf2CkYVwrGVMWjEI6gdBjlQxANoLIf1b0Q96Cm
C3UdqG9DvRwNzZA0QloPaQ2kVZCWQVoESR7qs1CbgqpoZaHbu33db3nHaKw7
hyIFOkR4lYj0ifi2Vv2DI1LL4832JxWuH7f5fNYZdKk7nOqN1utPMBhMuTWU
fmck6/4oz3SswHKixGay3GGqynmq1m1a4vmwyWdG7j/THjTbFTrby5gdjJob
iZkbj5+bSpqbZc49Ys09Zs8tcWZXMmfXsmc3cmde5s285j98Uzi9UzS9WzKl
Kp1E+QQqxlE5iuoRiIdRO4i6ftT3QdIDaSca29GoQFMLZE2QNaC5FrJKyMog
K0IjDxIO6pJUouB389bsr1yiiI9G32oTz6dIiS4R6RGxPmkwOtJocqzZ6kSr
w5l2t3NdPp/3BH3VH35lMFp/KPHmSKrxWPq9cS49ybOYKrSZLrF/WO40U+U2
W+s5J/GZl/nPy4MetYc+6mI86otaGIxdGI1fmEh6PJ3yeJb1+BF74UnGwnLW
wkr2whrv0Ub+o82C+deC+TfFczvCWWXZjKrioaryIaqmIJ5EzQTqxtAwCskw
pINo7IesF83daOlASxvkciiaoJBAUQtFJeRlaCmELAdSFsQRP7C/8ZZ7MEVY
Gp0LKFKuS6qvknoD7Sajoy30h63WpzodP+l2v9Dn++VAkO4Q49pIzI2xxNsT
qfcmOSbTXPOHedYzhfZzJU7z5a7zVZ6Pan0WJP6PZUFPFKFP2hlPuqMW+2IX
h+KXRpOWJlKWpllLs+lLjzKWnnCXlnMWV3mLa/mLG4VPNouevC55vF26sFO+
sCt6pKyaV1XPoWYWdTOon4ZkCtJJNI1DNormYcgHoehHaw/autDWjnY52mVo
l6C9Bm0itJZAkQ8ZB/WxB+AeSZEMivApIqRIlS6pu6rVaHC4xfhYG32i0/ps
j+P5fvcvBn2pkWC9Mcb1iZhbU0l3plMfzHDMZrOt5vPsHgkcF4Sujys8nlR7
L9b5L0mDlmShywrGcnvU0+7Yp/3xK0NJK6MpKxOslen0ldmMlUfclSc5K8t5
K6v8p+uFTzeKljdLlrfKlrcrlnZEi7tVT5Tix6raBdQ/QsM8pHNomoHsIVqm
IJ+AYhxto2gbQvsAOnrR2YXOdnTJ0dWErgZ0idFRjnYBFFw0Jh2Au/pNlk2R
IopUUKRWl0ivardcP9JmfLyTPtVr/emA48Uh98ujvlfGg/UnGTenY41nku7P
sUznOZYL2baP8xyeCFwWhe5LFd7L1X5P6wJXpCGrsvBVReSzjphn3fFr/Ulr
Qylro6y1ifS16cy1Oe7aQs7ak7y1Zf7aqmBtvfjZC+GzzbLVrYrV7cqVneqn
uzXLyrplVcMSpItofAzZApofQT4HxSzaHqJ9Ch0T6BxD1zC6B9HTh54u9Laj
V47eJvTWo7sKXUK056GFdQDuKZqeXkqRaopIdLWarx5uvX600/hEL312wPr8
sOOlMQ+dCb9r08E3Zhi3Z2PvzSfRCyyLxxybxWz7pXznZYH7itBrpcJ3tTrw
WV3ImjR8vTlyXRHzvCP+eXfSRn/KxhBrYzR9YyJz4yH3xVzui4W8jUX+xrJg
Y7V4Y134/EX5803R+lbV+rZ4bbd2bbf+mVKyqpKuoOkpmpfRsgjFE7Q9Rvsj
dMyhawbd0+iZRO84+kbQP4j+Pgx0Y6AdAy0YaER/LXor0FWI1owf4/4v6hmb
pqdXUqSOIjJdbYXekc7rx3uNTw2Yfjpic3Hc6fKkx5WHfgazwbfmI+4sxD54
kmS+yLJa5tg9zXZayXd7JvBcE/quVwQ8rw5+Xhe+IY180RzzQhH/siPpZTdz
s5+1OZS+OZqxOcl9dVgN4N1nFTR4/lUz6pZ8rQhKS66r3a53pOf6hwPGZ4bp
8+PWl6YcdR56XJvzM3wUbPSYcX8x1nQ5yfIpy3aV4/gs22Ut3+O5wGdD6P+i
IuhlddjLuohNafSr5rhXisTXHczX3ayt/vStoYytUe6bidwtdfuHtB7mvjr0
K3XgaxQ/iIxLkTJ136BIE6XVpnu4S+9o//WTw8afjNEXp6wvzzhemXM3WPC9
9ST47hLD5Gms+WqSzTOW/TrH+Xm2+0ae90uB36Yw6FVF6Otqxuu6qC1p3BtZ
4htF8nZH6nY3e6c/Y2eIuzOaszORt/0zkKl7bQNFWiitTt3DfXrHhwxOjxmf
m6S/mLHWmXe8tuBuuOhrvBx8f4Vh+izGaj3J7nmq0wuO28tsz80839eCwC1h
yJuK8O3qqO262B1pwq4seVeRutvOVnZnKPu5qqEc5Wje7gR/56ciUw8pVRRp
pLRaKa1u3SODeidGDT6eNLowQ1+et77y2NFg0f3WU9+7q0H0GsPieYzNi0SH
l6kurzger7k+W3n+bwqDd0rCdssjd6tilLXxSkmSSpaiUqSp2jnK7ixVX45q
KA+jfNWEQPlTkanfcGK1xVNaHZR2n+7REb2TE/qfPjT6fM6EWrC6uuRw46mb
0arP/fUgs41wq5fRdpuJTq9T3d+ke21z/XZ4QbuFocqSCGV5tLIqTlWbqJKk
QJamknNU7ZmqrmxVHw+DfIwKMFGMgyL7zTc9slajxy5Ke1Dn+Jje6Sn983O3
Ly080F201H9qf+uZ6511H5ONIIvNcJtX0Q5bCa7bKZ476T67WQFKXoiyIFxV
EqUqj1VVJaCWCQkLTemQZ6ras1VduejNx2AhRooxLsRPR6WgtHupw8PUhxNX
zs7oX3h06/KT+3pPLa4/szdad73/wtt0M9DqdZjdmyjn7Xj3nRTvXba/MitI
mRumKohUFcegLB6VyahJRQMbTRmQc9GWi6589BZgoAgjQoyX/QxUrWr9UYdH
qRNTuh/P6V98fJNavndt1dxw3e7OCxeTTS/z1wE2b0IdtqNcd+M9lUxfJTtQ
lRmiymWAH42iOJQlojIFNWmo56AxCy05aMtDZwF6izBQguEyjIl+Kiq1YbVT
2gPUkXHq5EPdTx9d+2LJUHf1rv662a0Xtvc2nenXnpZv/O12Qp12I92Vcd6q
ZH9VWjAyw5ATifxYFKnXJckQqWds6ajPRGM2mnlo5aNTgJ4S9JdiuAJjVT8V
VbkG1SD1/iR1ak7n/JOrl57euLJmfH2DNtq0vv/ayeyNh/WOn8NuiIsywlMV
64ukQLBCkcFAdjTy4yBIgjAFFWxUZ6COC2kumvOhKERHMbpL0V+OoUqMig+K
SuMv+WcNpCHq6BR1ep76bFHv8oqB3rqR4UsT49dWJm8cLXbcbZW+jqogNzC8
EOOHxCCkhoETCW4s8hJQyEQJC+UcVKuXNTl76xtZAeRFaBeiqxx9IgxWY6T2
wD3wLaZW6rAa0zR1+hH12bLuV8/0r23cuvnq/t03FvSOvZXSzQ7ezgj0QLgP
ogOQELLnwk6P3nN88pJQkIpiNsoyUJmNWh4a+GgSQF6CtjJ0VaC3CgM1GK7/
yZgaKK3BPUxnFqgLT3Wo9av6L2/e2rp3b8fcTGlrrXJxgJcr/D0R6oeoIMSH
gRmJtFhkJiCXCX7ani+rNGvP0yHOR30hGovRUorWCnRWokeM/joMNxwYk8Zr
+08U6aeOqQE9pi6uUDrP9QxeGd5+c+fBrqm50tpG5eQIDzf4eSPEHxHBiGUg
KQqsOGQkITsV+WwIMiHMRgUP1XzUCSAtQXMZFCJ0VKO7Fn0NGJIe1Jbe4umk
jqkNSY1nldLZ0L3+ysBo+/aDXRMLpaWtysEJ7h7w8UFQIMJDEROBxJi9DYh0
Jrgs8DgozEJJLsrzUVWI2mJIStFUAXnV3kKiqx69Egw2HRSPZpfiH6kjExow
zyidFzrXX1813jY0Ud6zVJrbqexc4OoJbz8EBCEsDFGRiI8FMxHsFGSykZsB
fjaKeSgr2HNQ1QhRX47GSrSI0VqLzgb0qCd5zQfW1jdotIapjxaoz9SieUFd
37pivH2dVhpbqUwdVDaucPKChx/8ghESjohoxMYjORksFjLSkZ2F/BwI8iEs
hKgY1aWoq9hzKchqoKhHuxTdMvS1HBjN1+fmqA9mqfMrFKWG8kbXeOcarbpt
pXrgAEs3OHjBzR8+IQiKQHgMohOQyERqGtIzwOWCx0MBHyUClAtRVY7aSkjE
aKqDXIK2JnQ2o1dxUC19g+TIMPXxEnV5gzJQI9nVM1XdsMZdB5i5wdYbzgHw
CkVAJEJjEZmIuBQks5GWicwc5OSBX7DnLi4t3XMmiqtQX7PncGmWolWGDjm6
Ww+KRLOb/D+o0wvUl88p/S0dY+UVWqVvjduOMHGDlQ8cA+EeBt9IBMeBkYSY
VCSmIzULnFxk5yNPgMISlJShXIQqMWrrIJGgqQnyZrQp0NV+YN1odur/fs9i
r76mbit1TFRXrGDoiLvuMPeBXRBcwuEVhYB4hCUjioV4DphcsHnI5CO3CHwh
iipQWgVRDcT1qJdCKkOzHIpWdHQcVBbfYDg5v2enN7epByodS5W+A4zcYeIL
qyA4hsM9Gr7xCGaCkYbYDCRlIzUPnAJkF+/tWxSK9lzbFbV7Ls/aRkia0aRA
SzvaOn8ahr1TJZ89pQy2qHtKykKl5wBDd9z1hVkQbMPhEg2vBAQwEcpGVCbi
c8DMB7sQmSXIKQO/EkVilNZBJIG4CfUtkLaiuQOK7p+MQf2rHs0oox3KTEXZ
q/RdccsHD4JgGQ6HaLgnwDcFQWyEZyImB4n5SBWAIwS3HLwqFNSguB5lUlTK
UCNHQxsaO9HS83Mw7MG4sUXRKsoGui647g3jQJiGwyYazgnwTIE/GyFZiMxF
HH9vM5QlREYFcqqQXwtBA4SNqGjec8rWtkPShaben4lhD4bxDmUByhF6njAM
wN0wWETDLgEuKfBiIyALYbmI5iO+CMxSsCuQWY3cWvAlKGpCaQtErRB3oK4b
0r6fhGH/ufr/St3foWxBueGaH26F4kEULOPhwIQbGz5ZCMoFg4+YIiSWIkWE
9Gpw68CToKAJxXKUtaGyc89nW9/303rn/jP6f0eZ7KpFoeMNg2DcjoBJHKyS
4ZgGj0z45SKYD0YRYkuRJAJLDE4duBLwZCiUo7gNZZ2o7IG4/+fKQXPW/28p
s121EHT9YRAGoxjQSbBmwSkDnjnw4yOkCBGliBUhSQxWHThSZMuQJ0dh+94+
RVnPnvv6oBL4/Rnc/0x5QCcQ+hEwiodpKmw4cMqGRz78BQgVIlKEuGok1YEl
AUeGbDny2lHYheIelB28te89p/yfKFcVFQz9GBglg2bDOgtOPHgUwq8EIRWI
rEZcLZIkYMnAkYPbBl4nCnpQdGAZf+857r+mQnAtFrdS8IADy2w48uFRDL8y
BFeCUYOYBiQ2IbUF6W3I6kRuD/gHbu97z7X/TicGBkzcyYB5LuwL4SqEdwUC
qxFWhygp4puRrACrHZxucA/ci773XP9fUgkwzIAJD9YCOJbCXQRfMYIbENGE
mBYktCGlE+wDj1jfe3fhN9ezcJ8PyxI4iuBRA38JgpsQ3oLoNsR3Htgevvf2
xR8/KIFNJZxr4SGBrwxB8gPXt/8eyD9p4uo86rJ7xf/9AHXsv4Xyzz+jjv3n
sv/lZ9Sx/zz0v/6MOvafQP6fP6OO/beP/u1n1LH/XO3/+hl17D/B+r8PWsev
v/2m2xvq/v2gJf/DjTLyEzHvtaSl/v2uj/bd99z+cBfu0C/+Py+D2WQ=\
\>"]]}], "}"}]], "Output",
 ImageSize->{230, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->289763438]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11052],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bottom",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Bottom"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Center",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Center"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Axis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Axis"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Baseline",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Baseline"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16856]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Top - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 13.0207338}", "context" -> "System`", 
    "keywords" -> {
     "view point", "view position", "camera position", "grid alignment", 
      "control placement"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Top is a symbol that represents the top for purposes of alignment and \
positioning. ", "synonyms" -> {}, "title" -> "Top", "type" -> "Symbol", "uri" -> 
    "ref/Top"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1978, 66, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 36515, 828}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 819, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1442, 44, 41, 1, 70, "ObjectName",
 CellID->28742],
Cell[1486, 47, 455, 14, 70, "Usage",
 CellID->21252]
}, Open  ]],
Cell[CellGroupData[{
Cell[1978, 66, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[2355, 80, 147, 5, 70, "ExampleSection",
 CellID->29064330],
Cell[2505, 87, 82, 1, 70, "ExampleText",
 CellID->94306447],
Cell[CellGroupData[{
Cell[2612, 92, 468, 15, 42, "Input",
 CellID->176068346],
Cell[3083, 109, 508, 16, 48, "Output",
 CellID->138747686]
}, Open  ]],
Cell[3606, 128, 125, 3, 70, "ExampleDelimiter",
 CellID->825938041],
Cell[3734, 133, 228, 8, 70, "ExampleText",
 CellID->156257647],
Cell[CellGroupData[{
Cell[3987, 145, 207, 6, 28, "Input",
 CellID->115448565],
Cell[4197, 153, 1469, 47, 82, "Output",
 CellID->110539898]
}, Open  ]],
Cell[5681, 203, 120, 3, 70, "ExampleText",
 CellID->467567170],
Cell[5804, 208, 97, 1, 70, "ExampleText",
 CellID->458844947],
Cell[CellGroupData[{
Cell[5926, 213, 448, 15, 70, "Input",
 CellID->94197876],
Cell[6377, 230, 555, 18, 68, "Output",
 CellID->45709746]
}, Open  ]],
Cell[6947, 251, 125, 3, 70, "ExampleDelimiter",
 CellID->338216689],
Cell[7075, 256, 90, 1, 70, "ExampleText",
 CellID->125552549],
Cell[CellGroupData[{
Cell[7190, 261, 508, 15, 70, "Input",
 CellID->186093363],
Cell[7701, 278, 350, 11, 121, "Output",
 CellID->219450764]
}, Open  ]],
Cell[8066, 292, 125, 3, 70, "ExampleDelimiter",
 CellID->493017311],
Cell[8194, 297, 72, 1, 70, "ExampleText",
 CellID->727675960],
Cell[CellGroupData[{
Cell[8291, 302, 492, 16, 70, "Input",
 CellID->198155887],
Cell[8786, 320, 25292, 422, 131, "Output",
 CellID->289763438]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34139, 749, 311, 9, 70, "SeeAlsoSection",
 CellID->11052],
Cell[34453, 760, 925, 35, 70, "SeeAlso",
 CellID->16856]
}, Open  ]],
Cell[35393, 798, 27, 0, 70, "History"],
Cell[35423, 800, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

