(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     66451,       2271]
NotebookOptionsPosition[     54419,       1846]
NotebookOutlinePosition[     55878,       1886]
CellTagsIndexPosition[     55792,       1881]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Statistics" :> 
          Documentation`HelpLookup["paclet:tutorial/BasicStatistics"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Basic Statistics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Plus" :> Documentation`HelpLookup["paclet:ref/Plus"], 
          "Accumulate" :> Documentation`HelpLookup["paclet:ref/Accumulate"], 
          "Tr" :> Documentation`HelpLookup["paclet:ref/Tr"], "Mean" :> 
          Documentation`HelpLookup["paclet:ref/Mean"], "Count" :> 
          Documentation`HelpLookup["paclet:ref/Count"], "Norm" :> 
          Documentation`HelpLookup["paclet:ref/Norm"], "Sum" :> 
          Documentation`HelpLookup["paclet:ref/Sum"], "Max" :> 
          Documentation`HelpLookup["paclet:ref/Max"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Plus\"\>", 2->"\<\"Accumulate\"\>", 
       3->"\<\"Tr\"\>", 4->"\<\"Mean\"\>", 5->"\<\"Count\"\>", 
       6->"\<\"Norm\"\>", 7->"\<\"Sum\"\>", 
       8->"\<\"Max\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Arithmetic Functions" :> 
          Documentation`HelpLookup["paclet:guide/ArithmeticFunctions"], 
          "Discrete & Integer Data" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteAndIntegerData"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Operations on Vectors" :> 
          Documentation`HelpLookup["paclet:guide/OperationsOnVectors"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Arithmetic Functions\"\>", 
       2->"\<\"Discrete & Integer Data\"\>", 3->"\<\"List Manipulation\"\>", 
       4->"\<\"Math & Counting Operations on Lists\"\>", 
       5->"\<\"Mathematical Functions\"\>", 
       6->"\<\"Matrices and Linear Algebra\"\>", 7->"\<\"Numerical Data\"\>", 
       8->"\<\"Operations on Vectors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Total", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Total",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Total"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the total of the elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Total",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Total"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]totals all elements down to level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Total",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Total"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         StyleBox["n", "TI"], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]totals elements at level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Total",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Total"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]totals elements at levels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->12069]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Total",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Total"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Apply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apply"], "[", 
   RowBox[{
    ButtonBox["Plus",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Plus"], ",", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->35430661,
  ButtonNote->"35430661"]
}], "Notes",
 CellID->31391],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Total",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Total"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"]}], "]"}]], "InlineFormula"],
 " totals all elements at any level in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->500306949,
  ButtonNote->"500306949"]
}], "Notes",
 CellID->16139],

Cell[TextData[{
 "For a 2D array or matrix: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->931116143,
  ButtonNote->"931116143"]
}], "Notes",
 CellID->1835],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Total",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Total"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Total",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Total"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", " ", 
        RowBox[{"{", "1", "}"}]}], "]"}]], "InlineFormula"],
     " "
    }], "TableText"], Cell["totals for each column ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Total",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Total"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", "2", "}"}]}], "]"}]], "InlineFormula"],
     " "
    }], "TableText"], Cell["totals for each row ", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Total",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Total"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", "2"}], "]"}]], "InlineFormula"],
     " "
    }], "TableText"], Cell["overall total of all elements ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->4306],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Total",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Total"], "[", 
   RowBox[{
    StyleBox["f", "TI"], "[", 
    RowBox[{
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
 " gives the sum of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " for any head ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->226367431,
  ButtonNote->"226367431"]
}], "Notes",
 CellID->10039],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Total",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Total"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{
     ButtonBox["Method",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Method"], "->", 
     "\"\<CompensatedSummation\>\""}]}], "]"}]], "InlineFormula"],
 " uses compensated summation to reduce numerical error in the result. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->42655279,
  ButtonNote->"42655279"]
}], "Notes",
 CellID->32173],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Total",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Total"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->740283194,
  ButtonNote->"740283194"]
}], "Notes",
 CellID->21069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->14405242],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->104541589],

Cell["Total the values in a list:", "ExampleText",
 CellID->17209322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8649062],

Cell[BoxData[
 RowBox[{"a", "+", "b", "+", "c", "+", "d"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45278870]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->302705735],

Cell["Use exact arithmetic to total the values:", "ExampleText",
 CellID->376401775],

Cell[BoxData[
 RowBox[{
  RowBox[{"list", " ", "=", 
   RowBox[{"{", 
    RowBox[{
    "Pi", ",", " ", "1", ",", " ", "4", ",", " ", "E", ",", " ", "7", ",", 
     " ", "8"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->255168711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", "list", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->317556251],

Cell[BoxData[
 RowBox[{"20", "+", "\[ExponentialE]", "+", "\[Pi]"}]], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->249753505]
}, Open  ]],

Cell["Use machine arithmetic:", "ExampleText",
 CellID->69009712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"N", "[", "list", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->297145917],

Cell[BoxData["25.859874482048838`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->188348536]
}, Open  ]],

Cell["Use 47-digit precision arithmetic:", "ExampleText",
 CellID->437914277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"N", "[", 
   RowBox[{"list", ",", " ", "47"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->67589944],

Cell[BoxData["25.8598744820488384738229308546321653819544164930750646672745`\
47."], "Output",
 ImageSize->{340, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->180311728]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9924578],

Cell["Total the columns of a matrix:", "ExampleText",
 CellID->931116143],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"1", "2", "3"},
       {"4", "5", "6"},
       {"7", "8", "9"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->209521705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->301372198],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"12", ",", "15", ",", "18"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->518095434]
}, Open  ]],

Cell["Total the rows:", "ExampleText",
 CellID->20679172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"m", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->581662176],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "15", ",", "24"}], "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->69463503]
}, Open  ]],

Cell["Total all the elements:", "ExampleText",
 CellID->111993572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"m", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->38845282],

Cell[BoxData["45"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->388615328]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->77485047],

Cell["Total by adding parts in the first dimension:", "ExampleText",
 CellID->25875650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", " ", "=", " ", 
  RowBox[{"Array", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["a", "##"], "&"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->258518822],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztms1uEzEUhd1MQgIipSAB3UArIfEjsWLJA8CKh4gqpHaBQKVPQp+Bn7cM
M9NxSM+cO/cnk6RFqdRm7LGPr894bOerP80uTj9/mV2cncyOP57Pvp2enXw/
/vD1vMwq9lLa+5FSeneYyut5eVX/Vj+X5W9KL6q/Rc6bpzGknyv3j1a8/3bN
+lr8df/TI8idlH+qZFElhov85dyl0qPycgB5+7pCK3e4osaAaDxw9WTQ5GNv
UPWe2S8W04i0LPd1oaBGL/eVa7DYDHEQvzASLEf9Sw8h9y6r9S+G8uJOtm8R
VWqiqqJ7YKvfynHUhb63HTqI6XSki0YZxxx1S9NteTfq6r+mdq1fWYk64Ogv
9zUUn+KqZ8TWbrdGbKXCZj+cZTGNrY+DOhhlVAfjmRh1qrE8NLz/k55823Z/
+3qO2Tdt1NlGIX+zWWxaX6o3bdyL2nAlNRwvg0ZtElJbnnHzesFixRnV5ivG
ivO7zwlNLT8lmxOohs5kX2OxjcDX0bzdc30043pR0FgG0NYY0hjb/ZAKpve3
qDJpng26Ol2LX9Mb5FcsluwXe//UtYmu7GxlY3NL3p9YymN6f8312Ey6nMZ9
lbffBxvu9zTY7372e3xFeElzXzlynylPhbfraYHHiHQgvguukq+bzzfwia2w
McfqZb2jXqL8rUTxJ9QKkpOfkMYofjlbufqmXF1eBq+2Tbjer1lfi//xnD2n
azt1E7HBmXOqK6iEy6shERt7T6yESyNebBUtyLzMnFP5F6vvo1+qgsq+lD5Y
yVd9vzULoJuMQ+rzf/5mQXfQmhqlYCElWblRZeuFW7UjzTxnxIzO4HifEjIn
N+MadlrG66s+O2LpcBOfTnazVtsRMEhbCZhGxNgYvo1+bJqQ1TpBImZlLf2Q
m9U4kERuYhwIyY2FQzJCRp/GltmhxDVj7FAikbHYkEQyYjbIOkYyhm1iGzYy
pqnYSM9mVCQyxnbX6t5M5Uzam2ijVV2zg+yEVyUWy3jOyVk3GctvAs4JSMSk
chIR6qu8Rr7YSQFttLCVPvc3j0qJiOVyGKdEwqTyEgHL5bXvFtslW17XN0W+
+iFbkTHFdCXyZSNb3iiQfNnIFqpgVHgfydftJ1s34+yW93/I0g7cmjfV6vuo
l6qgMi8l3uiZLpkQFmT2ZUxLpnsLBVVXpntcg7lliIP4pX2jrd/32MkvdQ/G
mUsn7zIwl07KFWQulG25mYv1zBd1z3BCTqJNQn1KqmhPezghZ9Tp2NFkt+oV
yz0idwRrd4YrEo+VUNXj3T0qd2e6dPdzOq8NLNbYma4docq+SoTqavX3/hfR
RrA0v2wES+uZjT2tRyUTl9jZLi/x41RoO8QvFot0tutJfT+y4i+Towl8IrnK
+RK5iZbD3Zz1bJZG3g6UcquSt6lSXjt79TT01P73s1cxVzZ99ioWpffs1VUr
XrLhPXt1WLdSXVpoU9r7CzPf47A=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{402, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->636804404]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", "t", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->125246979],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmk1v1DAQhr3Z7G75Khz46AHRcOGjR34EnPgFiMOqQmoPCFRK//6ScWLI
Tl57xpO0BeRKzWa8npk3Y8dxnvbj9vLsy9ft5fnptvlwsf1+dn76o3n/7aJt
Wi6cW/x0zr07cu35rj3zv/Rz1f4695yOy9C2cxtmN8L3Lyb6H9+y/xNfhXug
16o1KzLq3+3tT9UaNetNPSkONS3VHhVreyDn3Gsl16dy1pEP15Kbl1qfZeal
1lV+3kHvqs+YV+dq2HvQzvv5791d1sptHoWPoLdXQ02ur1Uqty5K3V/hI4um
P3VqT44sevYirKdoSdiPLcoE+1/QKc1O3x/ORrSO8BWO22tgW+Jw1RtjHG6v
jHF41ax65qqPVQ/lq/u7zKIj+PP8ulmFVx8+1geKmvExnR6V+tP9vJklGhyv
yVHDOm3TiO6F6XVEd65d41CTC1Ema+RR+ZXj2XsHXJmce81ycS2UaxU0jKJV
u/j1o2j3TZp41HD341kqaeL24Syawkptq9M8mqja1WQtIQq6m4f2wvdHT+K6
z0JR+KwM+yW0dtTgGtGKTv4PhTyaJ6smH7cPM/Oip8F15E2tITl5eRzbfgw/
ORukcdTrFWx9iXSMer2ekHeKL3/z1+9ayTzpP98w+61gH5uy0uGzypOTADp8
Ejy7t0c6vTKeFQqDah+nMEtwV6cpTMxDT2HiceMUJt6qpzA4RprCxH30FAZV
TKYwKa8ZKcyIRyi5i8IvSVrG/jJbEXySNGXsy1esgQ25RFaEJDG5YS18toS3
Fh+p0BDBLjRk3/86aUhuDXVvyJoZp3+Lz513OhqiiWLXKO3vbXVEu327xtQ7
sl0jj4poSBXiFAqi1FQoiDxmiIL4sSzUQ6HXcp1/K/XweQvlUFVlbqqBs9CB
U4yup4Za+GjeKJTC5t9RCmknGdvZxtr23qUV/ZPEAvVN8wqVR5JWiBFGrELl
kSQVQk0gp1D66CiF1AtSi9HqgtccSC6Uvkl6gWPIBEPhl6QY2J8/VQY2pAfZ
UZI045Y0pamGZu4VypG/9hbK0dkd5VD9fatQD3PUQj1ugnrwewI+p2cZS/0b
tfSfNzoKItUlj4Kk/mOJvtcRB81Y2es0jyay8ykIGrM4BdE8oYdv7wfgE63c
iPAM/TgFCe0SlYjRj3XEn9OHWB4t7cjNw/fNWrqxjvhjqmF7AjZI239MOTRz
ncx5qYeUlQ6Ygki7HzpMoyJu8QsLsCKJ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{373, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->683879327]
}, Open  ]],

Cell["Total in the last dimension only:", "ExampleText",
 CellID->21248738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"t", ",", 
   RowBox[{"{", 
    RowBox[{"-", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->487334816],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWdtu00AQ3dhxakAUqJK0SIiaJ0TV74CnfkRUIbUPCFT6/2HXjlPneHZn
xo7dlGylpN71zNk5Y+8lc25Wj3c/f60e729XxY+H1Z+7+9u/xfffD7YrnRiT
XBljvlwYe722V+Wn/ru2H2M+ue90229OoF0MfP/yyMefl0/hDfTm9ss1U+jP
7GVC9C04+2nzyTuDpcojsY1zRUzJxhb73zUxWjFRyAveI8xN4NNix0am5+fG
mKr4bT0U/GifMD8qsmRN86bsjHkNva8or6w5pr02Gdl7Lvd9YmEvLuR+GD/O
xm4orZy+p7B2Yp7JM9D249m3fbTMeQQZ68C4iTwHHAqfEQ5Bm58eeNzMmqyp
meW8qPUWdxVs47ObvVAcZzcl1qX8hfKJeRknLzi7ZLONXpswx9rY6X3veVBz
CqU3ajM2s8m+2xvyA2J+PPnEmKi5pI9xHFTMRLd8hp6Ks0dUenXAU21Kjp0A
NsfIjZUZ32mYQ8M3IzsgNMfUvaWnIu8TBk2XJ0TDto7ZsGh5zJMqT7iyOMYT
23Sz1H9qpk5Hs/XTOrpdTwWnqtoPVwRqDRzSH3m+9dhT+4mGb5fT2Zg4yCPm
oWp3+41Jn3oLsKLn8D6tvsY4dqw+g5W8YuCaV57/33rev+wUVc2Lq6pU3lgd
r73PGO+qOllbX++xFVWT5x2/Uk24X/XOy6eYUH1zzr5ViV+oPNxes1TE5FMZ
TpsYIhVlznuEuQlVlCXv04ufT0Xx8/OrKH5+fhXFz6+/isJZUSu7VFXBanjA
d6eK/lHuh3wa7UV3lFaOP1BYAlWFzACjqpDsVaoKybyDqkKyDoxLn+HIHHAo
fEY4BG1+euChf7rJX9nPzrCorkQVIeZlKHVFtAseSB3/eNSBmM+otvgyMZ7a
ktSrTWvNofbo/u9fuEqufUPCde1x0cKqC1VJbo6tUxM4NF39f1y0sOoS84R5
whWmHEV0op5u5jYqLaHKO9pLlZJ9+fmUlSSAK+GDftLK/1D+PuXkf+dJ7lkd
T6gFWB2PInEocaAyInuaYysjsqhqXqiMVN7cL63aG5WRcj5s72rVDjP5B/sx
pio=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{554, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->24682160]
}, Open  ]],

Cell["Total in the last two dimensions:", "ExampleText",
 CellID->62008217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"t", ",", 
   RowBox[{"-", "2"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->299281055],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWWFP2zAQddOklElUfKDANgmCNmnafsj2aT+iQkjwAW1i/P8udnHnvJx9
Zydp0q5IpT373svzXWI755+r18eH59Xr0/2q/PGy+v34dP+n/P7rpWqaTpTK
bpRSd9eq+r2ufpmP/Surj1JL/X+6bVcnYJcj778duT6uf2GyoP8XVWMGvdu2
3M1cVhmXLqLWq+HTSIzuzcnWK5dRpKyGECrzY/zKClB0xsXQacvernfBRzEK
tVVLoJZcJDmMWJ8fFdKHbMZW51Rr4XIqIhc4HpxlQFn1Y5bCEPDn7Auw86Rx
kSxR4yIZWoxL2zrLx7ztV97IuKjTNT2n4SqCNqqfHXl64cGsnwh59PVy4i6T
6hgLHtuLHePJp07N19ScgE8Ycs4JLQ17IFZkoeI2Fq3DRED7Z/aOitboPgfK
c18OxRqKX39a8ar0OrsbVi4C5GqfOAugYjsjyaIayviu2TLwxijGjRTZUEs7
bRzbIimX2s5YLVzU5ztk4XJmR2TXafr54aI775zF1Tgx/Xrnmr+xZI73aSBO
1nZx6C/ZyXWBp/IZo19yb/bBs/DE/R344ZzJxY1bxbvC++KO+jFehTBeoVmw
DQ/9/kavQSUVi73x+jISHXfgRc9iMq8b8Pr39q0bvwm/v0b635JXtbo+Bns/
QO+01lt2aB1PCIbt35wQSCsNvra4SncYQVWRtWdMhbvhL9IUV9kuCBb2lKCh
Y8lHLgJDn2dozCUXvTBCqMyP8SvDuG7mGtSJK3Sg4txovaawzXqsDIdzJtoN
livwCtSUZViBchIXrVxriqz217S9l8Wdx3DKawyYtUC8eRyjlsREqbU7UIMk
T8kOoZJ9qDypFfqxj6srntQKfF88dEWfnGOS6kGhGKZVTrth5d5Lx6R1mAjo
OyO9wr/PI+9HK/nkDcQqzf1m50menbdWrq/Rrr47FJukapzORtV9+2M7S8rl
/3tq066Gj3a3bOaNkNwxUxVq9xtHHKosz3rC+SrRnE7JvdoF/twTx0M7YaF2
liknI13xGH3CHWlJXHN/vA6x0v9p7ZuTtNlXpf8zeVWry9TyG28+ttfUW7ZW
GWmpyV8MVl7K\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{542, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->536177385]
}, Open  ]],

Cell["Total all the elements:", "ExampleText",
 CellID->500306949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"t", ",", " ", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->508997448],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWMFu2zAMVRU7TTtg26FJWwxt08sO239sp31EUAxoD0OLtv+fSUqUKjQl
kpbj2IYLJLFo8omkaNJ9f1bvj3//rd6fHlbL36+rl8enh7flr+dXI5qcKKW/
KaXur5S5Xpsr9/F/N+aj1Nx+T3ZydQrWy4Hfvz/y/mfuFL6YbyucgLuludSI
bE7pF+FJW4WFyEKbxaXAJ73V3fOr4gOGxLBIx8KwqURDeqbJnSxmIYpnZyGI
B7dJx4N55uNxcldt4d3CO7/DMNeqRKWXfNsPr8zFFd8O+B2uLw6HsuftlB97
1Y6Ou2qT720CAfZ4rDoqa170FAqdCwpBmpkMPPcsuY6M9TjYueEansK0pzhW
r0Cqqq/xUOtSmBdMPoS85NbLZrbM1ljvgPNV6gs+i46DOsNQslFD3xRSZV3K
QDt5haj4rJfmFT09EpXyrV4G2kFFKykbNUSx+m4defo10KU8tCddqtgbKIUG
T7zsEJqNVItRTglUWb4gGlzn+QbXforgTy8nUh2gDD9f+ZXh62vzJmsnM3yW
p1utWfCLTfSY3Rkib9P+HMhhR4vZY7NBEn+dN6g6OFjH5uBw5kmf81IXB8ax
+T8Pn1VLJPdD04KcJ96boVZXvL9d+95mVX/U/P1J3L9zu/h9b1pafQYZ6Bpb
fuj7x2bjv7pTsNIY847JLij9CuM7F1nYXrwQ+OTZ3j2/WGw8wyIdC5ONX9A2
SDzxnWJsfDyeOBvP2EUQT4qN/7T2nawynZhsPGRUE7Z7TOw13w74Ha4hr9wg
CoONR2Mn2Hg07iwuXY6wwBAS+jgbj0ZPodC5oBCkmcnAc2/5TtpHVnRk43k4
IxvfLE6sXpzddrQ6YaSvwGnUZwZ5ZOZHZn5k5uEuTXWCNIsqPf0079kuGo+l
x9jJVD3L8pXqOvIIKbQ0S8+JlGbph5Sv/MoI62vzRNrvYruC7HyKjYX6XHa9
KTsuG68T+3Dik76ZSO1jrHvMnsu2dz1uqT31lhWZL4HGLYbQAWa5Sa1+c+xQ
66NDWeGhOPfvbhfvR5O8ujr5DzHZ1N8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{539, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->589021845]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->234388982],

Cell["Total the last dimension in a ragged array:", "ExampleText",
 CellID->60830218],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", "6", "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->395123994],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"a", ",", 
   RowBox[{"{", 
    RowBox[{"-", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27216841],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "9", ",", "6"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->369703942]
}, Open  ]],

Cell["Total all the elements:", "ExampleText",
 CellID->247932639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"a", ",", " ", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->191032150],

Cell[BoxData["21"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->946979218]
}, Open  ]],

Cell["\<\
You cannot total in the first dimension because the lists have incompatible \
lengths:\
\>", "ExampleText",
 CellID->479014516],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", "a", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2735247],

Cell[BoxData[
 RowBox[{
  RowBox[{"Total", "::", "\<\"tllen\"\>"}], ":", 
  " ", "\<\"Lists of unequal length in \\!\\({\\(\\({1, 2, 3}\\)\\), \
\\(\\({4, 5}\\)\\), \\(\\({6}\\)\\)}\\) cannot be added.\"\>"}]], "Message", \
"MSG",
 CellID->681487637],

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5"}], "}"}], ",", 
    RowBox[{"{", "6", "}"}]}], "}"}], "]"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->658830634]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->93518575],

Cell["Total the columns in a sparse matrix:", "ExampleText",
 CellID->740283194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", " ", "=", " ", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", " ", "i_"}], "}"}], "\[Rule]", 
       RowBox[{"-", "2"}]}], ",", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", " ", "j_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
       "1"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"10", ",", " ", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43659143],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "28", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 28, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->851423999]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", "s", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->101720150],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 ImageSize->{205, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->52541439]
}, Open  ]],

Cell["Total the rows:", "ExampleText",
 CellID->99235393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"s", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->671934709],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 ImageSize->{205, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->364315183]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14015765],

Cell["Total several sparse vectors:", "ExampleText",
 CellID->107205234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"list", " ", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"SparseArray", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", "^", "i"}], "}"}], "\[Rule]", "1"}], ",", 
      RowBox[{"{", "100", "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "6"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300450822],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmUtPwzAMgNOm3YOxwS4wbgMJ8SvgCCd+RDUhbQcEGvv/JWniNrjuY6Uq
a/GkLovzsPMlcbP4NTps396jw24TrV/20ed2t/laP3/slUh6QnixEOJ2JdRv
/St54OOpJ8ua3EJ9S1XpUaWBSkOV+iq90aUybS3OUP4a5QPbLkTyec/7lwml
CyR9Ilq7+ZXtDWvFVuF20rYbqj6c9xO6k6TISEXykXY2df0QBMKWqcd3ynVq
pg0+oIRqFVoxpGXWjVA+tH2U1ZkQIwRd0losiXVWRWrEjJhRC4yyHeeDFUFW
aseSl4SpxKIISSkeVUDWquJFayzy0GWeW8tHNp3WIUOPiLSlirrWOWbOzHkg
nPNe5Lwx7Wmunh5VHV9K9+e2EgQ7P87WyQ9PbOULQt6UJXmCdPJLpsbUOqKG
y81/vsp9G5vTEMVHCvrcU9eLBHltBS3LfOCyQlObvq9y5TEtptXqe3XqsKh1
qrH16NMJbRnFF6gc21fV/x18isL5LonDfRezZbZ9Yltyc0b4MPfGwvWsuAzu
R9xbBZcu1cYv6EfaMpkORzilrpUzlL/qkOOciTGxk9irenwPSLY+oVHgeWd7
uzr7uStff99b2Z1NZzEd44Jdo9+FsNPwjgPNut7lQHXRMTyYGyoK2k4O2zOO
+x377Ca2ij03vtccSuzzr/QFJGX3bC4EbEyOleX0MCNm9EtG5s1O7UCOWRGk
ODbInJlzIWfjGDGVcWPq/zk+xlFFptYVtWTsOal7fiJZxhwvO2LlMS2m1ZAW
vT/h7M8xrfaJc7yQ2faRLe0psEUcJzs2YsPEmFjbxOrt1VOPFfYtttk3e80q
oTQMMT7apa5kVtPJODaiKrxvNVWziw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{511, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->289198391]
}, Open  ]],

Cell[CellGroupData[{

Cell["Total[list]", "Input",
 CellLabel->"In[2]:=",
 CellID->581005170],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "6", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 6, ">"],
     Editable->False], ",", 
    RowBox[{"{", "100", "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->289080938]
}, Open  ]],

Cell["Total all the elements in all the vectors:", "ExampleText",
 CellID->617439546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"list", ",", " ", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->886253983],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->170356741]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->48740227],

Cell["Total works with any head:", "ExampleText",
 CellID->425613112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"f", "[", 
   RowBox[{"1", ",", "2", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23701669],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137580927]
}, Open  ]],

Cell["Find the total derivative order:", "ExampleText",
 CellID->226367431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"Derivative", "[", 
   RowBox[{"1", ",", "2", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->72852333],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->726335236]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13772],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->166353865],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", "\"\<CompensatedSummation\>"}]], 
  "InlineFormula"],
 "\" to reduce accumulated errors in a sum:"
}], "ExampleText",
 CellID->42655279],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", "=", " ", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{".1", ",", " ", 
     RowBox[{"10", "^", "6"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15118352],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Total", "[", 
   RowBox[{"x", ",", " ", 
    RowBox[{"Method", "\[Rule]", "CompensatedSummation"}]}], "]"}], " ", "-", 
  " ", 
  RowBox[{"10", "^", "5"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->179507001],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->344819619]
}, Open  ]],

Cell["\<\
Without compensated summation, small errors may accumulate with each term:\
\>", "ExampleText",
 CellID->162262429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Total", "[", "x", "]"}], " ", "-", " ", 
  RowBox[{"10", "^", "5"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->693577648],

Cell[BoxData["8.731149137020111`*^-10"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->422834602]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->160663827],

Cell["Form a polynomial from monomials:", "ExampleText",
 CellID->327058486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "^", "2"}], ",", " ", 
    RowBox[{"3", " ", 
     RowBox[{"x", "^", "3"}]}], ",", " ", "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->933012722],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "2"], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "3"]}]}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27184340]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->811065381],

Cell["\<\
Show that the trace of a matrix is equal to the total of its eigenvalues:\
\>", "ExampleText",
 CellID->596085667],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->431939339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->180083875],

Cell[BoxData["4.302807624969373`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->413804446]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"Eigenvalues", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->225364240],

Cell[BoxData[
 RowBox[{"4.30280762496937`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->165972842]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20999502],

Cell[TextData[{
 "Search for \"perfect\" numbers equal to the sum of their divisors ",
 ButtonBox["[more info]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/PerfectNumber.html"], None}],
 ":"
}], "ExampleText",
 CellID->181986743],

Cell[BoxData[
 RowBox[{
  RowBox[{"perfectQ", "[", "x_Integer", "]"}], " ", ":=", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Total", "[", 
     RowBox[{"Divisors", "[", "x", "]"}], "]"}], " ", "\[Equal]", " ", 
    RowBox[{"2", " ", "x"}]}], ")"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->447464234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Last", "[", 
  RowBox[{"Reap", "[", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"perfectQ", "[", "x", "]"}], ",", " ", 
       RowBox[{"Sow", "[", "x", "]"}]}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", ",", "10000"}], "}"}]}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->493777585],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"6", ",", "28", ",", "496", ",", "8128"}], "}"}], "}"}]], "Output",\

 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->654787814]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->200819151],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Total",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Total"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Apply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apply"], "[", 
   RowBox[{
    ButtonBox["Plus",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Plus"], ",", 
    StyleBox["list", "TI"]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->35430661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"list", " ", "=", " ", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"9", ",", " ", 
    RowBox[{"{", "10", "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->217312596],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "9", ",", "9", ",", "4", ",", "2", ",", "5", ",", "6", ",", "0", ",", "3", 
   ",", "4", ",", "1"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->209406252]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", "list", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5042982],

Cell[BoxData["43"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->350554845]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"Plus", ",", " ", "list"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->78972001],

Cell[BoxData["43"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->292642160]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->165859323],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Total",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Total"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", " ", 
    StyleBox["k", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Total",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Total"], "[", 
   RowBox[{
    ButtonBox["Flatten",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Flatten"], "[", 
    RowBox[{
     StyleBox["list", "TI"], ",", " ", 
     RowBox[{
      StyleBox["k", "TI"], "-", "1"}]}], "]"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->369030123],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", " ", "=", " ", 
  RowBox[{"Array", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["a", "##"], "&"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "4", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->416198261],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{517, 101},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24278348]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Total", "[", 
     RowBox[{"t", ",", " ", "k"}], "]"}], " ", "===", " ", 
    RowBox[{"Total", "[", 
     RowBox[{"Flatten", "[", 
      RowBox[{"t", ",", " ", 
       RowBox[{"k", "-", "1"}]}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", " ", 
     RowBox[{"ArrayDepth", "[", "t", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->441333097],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{164, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5120416]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30395],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Plus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Plus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Accumulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accumulate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tr",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tr"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Count",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Count"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Norm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Norm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Max",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Max"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25102]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7573],

Cell[TextData[ButtonBox["Basic Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicStatistics"]], "Tutorials",
 CellID->1827]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->56076402],

Cell[TextData[ButtonBox["Arithmetic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ArithmeticFunctions"]], "MoreAbout",
 CellID->87060721],

Cell[TextData[ButtonBox["Discrete & Integer Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteAndIntegerData"]], "MoreAbout",
 CellID->387843342],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->122136498],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->9836013],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->59374907],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->547976920],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->354140029],

Cell[TextData[ButtonBox["Operations on Vectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnVectors"]], "MoreAbout",
 CellID->709164376]
}, Open  ]],

Cell["New in 5  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Total - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 14.7082770}", "context" -> "System`", 
    "keywords" -> {
     "column sum", "compensated summation", "row sum", 
      "sum of array elements", "sum of list", "total of list"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Total[list] gives the total of the elements in list. Total[list, n] \
totals all elements down to level n. Total[list, {n}] totals elements at \
level n. Total[list, {n_1, n_2}] totals elements at levels n_1 through n_2. ",
     "synonyms" -> {}, "title" -> "Total", "type" -> "Symbol", "uri" -> 
    "ref/Total"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16035, 467, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->14405242]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 55649, 1874}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3440, 73, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4063, 100, 4189, 83, 70, "ObjectNameGrid"],
Cell[8255, 185, 2214, 75, 70, "Usage",
 CellID->12069]
}, Open  ]],
Cell[CellGroupData[{
Cell[10506, 265, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10984, 282, 623, 24, 70, "Notes",
 CellID->31391],
Cell[11610, 308, 545, 20, 70, "Notes",
 CellID->16139],
Cell[12158, 330, 187, 7, 70, "Notes",
 CellID->1835],
Cell[12348, 339, 1878, 52, 70, "2ColumnTableMod",
 CellID->4306],
Cell[14229, 393, 770, 30, 70, "Notes",
 CellID->10039],
Cell[15002, 425, 566, 19, 70, "Notes",
 CellID->32173],
Cell[15571, 446, 427, 16, 70, "Notes",
 CellID->21069]
}, Closed]],
Cell[CellGroupData[{
Cell[16035, 467, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->14405242],
Cell[CellGroupData[{
Cell[16419, 481, 148, 5, 70, "ExampleSection",
 CellID->104541589],
Cell[16570, 488, 69, 1, 70, "ExampleText",
 CellID->17209322],
Cell[CellGroupData[{
Cell[16664, 493, 166, 5, 28, "Input",
 CellID->8649062],
Cell[16833, 500, 199, 6, 36, "Output",
 CellID->45278870]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17081, 512, 220, 7, 70, "ExampleSection",
 CellID->302705735],
Cell[17304, 521, 84, 1, 70, "ExampleText",
 CellID->376401775],
Cell[17391, 524, 244, 8, 70, "Input",
 CellID->255168711],
Cell[CellGroupData[{
Cell[17660, 536, 104, 3, 70, "Input",
 CellID->317556251],
Cell[17767, 541, 209, 6, 36, "Output",
 CellID->249753505]
}, Open  ]],
Cell[17991, 550, 65, 1, 70, "ExampleText",
 CellID->69009712],
Cell[CellGroupData[{
Cell[18081, 555, 132, 4, 70, "Input",
 CellID->297145917],
Cell[18216, 561, 176, 5, 36, "Output",
 CellID->188348536]
}, Open  ]],
Cell[18407, 569, 77, 1, 70, "ExampleText",
 CellID->437914277],
Cell[CellGroupData[{
Cell[18509, 574, 161, 5, 70, "Input",
 CellID->67589944],
Cell[18673, 581, 225, 6, 36, "Output",
 CellID->180311728]
}, Open  ]],
Cell[18913, 590, 123, 3, 70, "ExampleDelimiter",
 CellID->9924578],
Cell[19039, 595, 73, 1, 70, "ExampleText",
 CellID->931116143],
Cell[19115, 598, 743, 22, 70, "Input",
 CellID->209521705],
Cell[CellGroupData[{
Cell[19883, 624, 101, 3, 70, "Input",
 CellID->301372198],
Cell[19987, 629, 216, 7, 36, "Output",
 CellID->518095434]
}, Open  ]],
Cell[20218, 639, 57, 1, 70, "ExampleText",
 CellID->20679172],
Cell[CellGroupData[{
Cell[20300, 644, 148, 5, 70, "Input",
 CellID->581662176],
Cell[20451, 651, 214, 7, 36, "Output",
 CellID->69463503]
}, Open  ]],
Cell[20680, 661, 66, 1, 70, "ExampleText",
 CellID->111993572],
Cell[CellGroupData[{
Cell[20771, 666, 123, 4, 70, "Input",
 CellID->38845282],
Cell[20897, 672, 159, 5, 36, "Output",
 CellID->388615328]
}, Open  ]],
Cell[21071, 680, 124, 3, 70, "ExampleDelimiter",
 CellID->77485047],
Cell[21198, 685, 87, 1, 70, "ExampleText",
 CellID->25875650],
Cell[CellGroupData[{
Cell[21310, 690, 270, 9, 70, "Input",
 CellID->258518822],
Cell[21583, 701, 1704, 32, 70, "Output",
 Evaluatable->False,
 CellID->636804404]
}, Open  ]],
Cell[CellGroupData[{
Cell[23324, 738, 101, 3, 70, "Input",
 CellID->125246979],
Cell[23428, 743, 1464, 28, 70, "Output",
 Evaluatable->False,
 CellID->683879327]
}, Open  ]],
Cell[24907, 774, 75, 1, 70, "ExampleText",
 CellID->21248738],
Cell[CellGroupData[{
Cell[25007, 779, 168, 6, 70, "Input",
 CellID->487334816],
Cell[25178, 787, 1313, 26, 70, "Output",
 Evaluatable->False,
 CellID->24682160]
}, Open  ]],
Cell[26506, 816, 75, 1, 70, "ExampleText",
 CellID->62008217],
Cell[CellGroupData[{
Cell[26606, 821, 143, 5, 70, "Input",
 CellID->299281055],
Cell[26752, 828, 1322, 26, 70, "Output",
 Evaluatable->False,
 CellID->536177385]
}, Open  ]],
Cell[28089, 857, 66, 1, 70, "ExampleText",
 CellID->500306949],
Cell[CellGroupData[{
Cell[28180, 862, 136, 4, 70, "Input",
 CellID->508997448],
Cell[28319, 868, 1281, 25, 70, "Output",
 Evaluatable->False,
 CellID->589021845]
}, Open  ]],
Cell[29615, 896, 125, 3, 70, "ExampleDelimiter",
 CellID->234388982],
Cell[29743, 901, 85, 1, 70, "ExampleText",
 CellID->60830218],
Cell[29831, 904, 321, 11, 70, "Input",
 CellID->395123994],
Cell[CellGroupData[{
Cell[30177, 919, 167, 6, 70, "Input",
 CellID->27216841],
Cell[30347, 927, 213, 7, 36, "Output",
 CellID->369703942]
}, Open  ]],
Cell[30575, 937, 66, 1, 70, "ExampleText",
 CellID->247932639],
Cell[CellGroupData[{
Cell[30666, 942, 136, 4, 70, "Input",
 CellID->191032150],
Cell[30805, 948, 159, 5, 36, "Output",
 CellID->946979218]
}, Open  ]],
Cell[30979, 956, 137, 4, 70, "ExampleText",
 CellID->479014516],
Cell[CellGroupData[{
Cell[31141, 964, 99, 3, 70, "Input",
 CellID->2735247],
Cell[31243, 969, 250, 6, 70, "Message",
 CellID->681487637],
Cell[31496, 977, 384, 13, 36, "Output",
 CellID->658830634]
}, Open  ]],
Cell[31895, 993, 124, 3, 70, "ExampleDelimiter",
 CellID->93518575],
Cell[32022, 998, 80, 1, 70, "ExampleText",
 CellID->740283194],
Cell[CellGroupData[{
Cell[32127, 1003, 642, 21, 70, "Input",
 CellID->43659143],
Cell[32772, 1026, 483, 17, 36, "Output",
 CellID->851423999]
}, Open  ]],
Cell[CellGroupData[{
Cell[33292, 1048, 101, 3, 70, "Input",
 CellID->101720150],
Cell[33396, 1053, 325, 10, 36, "Output",
 CellID->52541439]
}, Open  ]],
Cell[33736, 1066, 57, 1, 70, "ExampleText",
 CellID->99235393],
Cell[CellGroupData[{
Cell[33818, 1071, 148, 5, 70, "Input",
 CellID->671934709],
Cell[33969, 1078, 326, 10, 36, "Output",
 CellID->364315183]
}, Open  ]],
Cell[34310, 1091, 124, 3, 70, "ExampleDelimiter",
 CellID->14015765],
Cell[34437, 1096, 72, 1, 70, "ExampleText",
 CellID->107205234],
Cell[CellGroupData[{
Cell[34534, 1101, 397, 13, 70, "Input",
 CellID->300450822],
Cell[34934, 1116, 1098, 22, 70, "Output",
 Evaluatable->False,
 CellID->289198391]
}, Open  ]],
Cell[CellGroupData[{
Cell[36069, 1143, 71, 2, 70, "Input",
 CellID->581005170],
Cell[36143, 1147, 455, 16, 36, "Output",
 CellID->289080938]
}, Open  ]],
Cell[36613, 1166, 85, 1, 70, "ExampleText",
 CellID->617439546],
Cell[CellGroupData[{
Cell[36723, 1171, 139, 4, 70, "Input",
 CellID->886253983],
Cell[36865, 1177, 158, 5, 36, "Output",
 CellID->170356741]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37072, 1188, 242, 7, 70, "ExampleSection",
 CellID->48740227],
Cell[37317, 1197, 69, 1, 70, "ExampleText",
 CellID->425613112],
Cell[CellGroupData[{
Cell[37411, 1202, 162, 5, 70, "Input",
 CellID->23701669],
Cell[37576, 1209, 158, 5, 36, "Output",
 CellID->137580927]
}, Open  ]],
Cell[37749, 1217, 75, 1, 70, "ExampleText",
 CellID->226367431],
Cell[CellGroupData[{
Cell[37849, 1222, 171, 5, 70, "Input",
 CellID->72852333],
Cell[38023, 1229, 158, 5, 36, "Output",
 CellID->726335236]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38230, 1240, 218, 7, 70, "ExampleSection",
 CellID->13772],
Cell[CellGroupData[{
Cell[38473, 1251, 227, 7, 70, "ExampleSubsection",
 CellID->166353865],
Cell[38703, 1260, 277, 10, 70, "ExampleText",
 CellID->42655279],
Cell[38983, 1272, 218, 7, 70, "Input",
 CellID->15118352],
Cell[CellGroupData[{
Cell[39226, 1283, 245, 8, 70, "Input",
 CellID->179507001],
Cell[39474, 1293, 160, 5, 36, "Output",
 CellID->344819619]
}, Open  ]],
Cell[39649, 1301, 125, 3, 70, "ExampleText",
 CellID->162262429],
Cell[CellGroupData[{
Cell[39799, 1308, 158, 5, 70, "Input",
 CellID->693577648],
Cell[39960, 1315, 180, 5, 36, "Output",
 CellID->422834602]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[40201, 1327, 227, 7, 70, "ExampleSection",
 CellID->160663827],
Cell[40431, 1336, 76, 1, 70, "ExampleText",
 CellID->327058486],
Cell[CellGroupData[{
Cell[40532, 1341, 244, 8, 70, "Input",
 CellID->933012722],
Cell[40779, 1351, 261, 9, 36, "Output",
 CellID->27184340]
}, Open  ]],
Cell[41055, 1363, 125, 3, 70, "ExampleDelimiter",
 CellID->811065381],
Cell[41183, 1368, 124, 3, 70, "ExampleText",
 CellID->596085667],
Cell[41310, 1373, 238, 8, 70, "Input",
 CellID->431939339],
Cell[CellGroupData[{
Cell[41573, 1385, 98, 3, 70, "Input",
 CellID->180083875],
Cell[41674, 1390, 175, 5, 36, "Output",
 CellID->413804446]
}, Open  ]],
Cell[CellGroupData[{
Cell[41886, 1400, 139, 4, 70, "Input",
 CellID->225364240],
Cell[42028, 1406, 254, 7, 36, "Output",
 CellID->165972842]
}, Open  ]],
Cell[42297, 1416, 124, 3, 70, "ExampleDelimiter",
 CellID->20999502],
Cell[42424, 1421, 266, 8, 70, "ExampleText",
 CellID->181986743],
Cell[42693, 1431, 307, 9, 70, "Input",
 CellID->447464234],
Cell[CellGroupData[{
Cell[43025, 1444, 400, 13, 70, "Input",
 CellID->493777585],
Cell[43428, 1459, 256, 9, 36, "Output",
 CellID->654787814]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[43733, 1474, 237, 7, 70, "ExampleSection",
 CellID->200819151],
Cell[43973, 1483, 519, 20, 70, "ExampleText",
 CellID->35430661],
Cell[CellGroupData[{
Cell[44517, 1507, 200, 6, 70, "Input",
 CellID->217312596],
Cell[44720, 1515, 291, 9, 36, "Output",
 CellID->209406252]
}, Open  ]],
Cell[CellGroupData[{
Cell[45048, 1529, 102, 3, 70, "Input",
 CellID->5042982],
Cell[45153, 1534, 159, 5, 36, "Output",
 CellID->350554845]
}, Open  ]],
Cell[CellGroupData[{
Cell[45349, 1544, 134, 4, 70, "Input",
 CellID->78972001],
Cell[45486, 1550, 159, 5, 36, "Output",
 CellID->292642160]
}, Open  ]],
Cell[45660, 1558, 125, 3, 70, "ExampleDelimiter",
 CellID->165859323],
Cell[45788, 1563, 662, 25, 70, "ExampleText",
 CellID->369030123],
Cell[CellGroupData[{
Cell[46475, 1592, 280, 9, 70, "Input",
 CellID->416198261],
Cell[46758, 1603, 2473, 45, 70, "Output",
 Evaluatable->False,
 CellID->24278348]
}, Open  ]],
Cell[CellGroupData[{
Cell[49268, 1653, 460, 14, 70, "Input",
 CellID->441333097],
Cell[49731, 1669, 234, 7, 36, "Output",
 CellID->5120416]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50026, 1683, 311, 9, 70, "SeeAlsoSection",
 CellID->30395],
Cell[50340, 1694, 1863, 71, 70, "SeeAlso",
 CellID->25102]
}, Open  ]],
Cell[CellGroupData[{
Cell[52240, 1770, 313, 9, 70, "TutorialsSection",
 CellID->7573],
Cell[52556, 1781, 141, 3, 70, "Tutorials",
 CellID->1827]
}, Open  ]],
Cell[CellGroupData[{
Cell[52734, 1789, 318, 9, 70, "MoreAboutSection",
 CellID->56076402],
Cell[53055, 1800, 150, 3, 70, "MoreAbout",
 CellID->87060721],
Cell[53208, 1805, 157, 3, 70, "MoreAbout",
 CellID->387843342],
Cell[53368, 1810, 145, 3, 70, "MoreAbout",
 CellID->122136498],
Cell[53516, 1815, 188, 4, 70, "MoreAbout",
 CellID->9836013],
Cell[53707, 1821, 154, 3, 70, "MoreAbout",
 CellID->59374907],
Cell[53864, 1826, 163, 3, 70, "MoreAbout",
 CellID->547976920],
Cell[54030, 1831, 139, 3, 70, "MoreAbout",
 CellID->354140029],
Cell[54172, 1836, 152, 3, 70, "MoreAbout",
 CellID->709164376]
}, Open  ]],
Cell[54339, 1842, 50, 0, 70, "History"],
Cell[54392, 1844, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

