(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11975,        431]
NotebookOptionsPosition[      8706,        326]
NotebookOutlinePosition[     10213,        366]
CellTagsIndexPosition[     10129,        361]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Files and Streams" :> 
          Documentation`HelpLookup["paclet:tutorial/FilesAndStreams"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Files and Streams\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Short" :> Documentation`HelpLookup["paclet:ref/Short"], 
          "Skeleton" :> Documentation`HelpLookup["paclet:ref/Skeleton"], 
          "PageWidth" :> Documentation`HelpLookup["paclet:ref/PageWidth"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Short\"\>", 
       2->"\<\"Skeleton\"\>", 3->"\<\"PageWidth\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TotalWidth", "ObjectName",
 CellID->28842],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["TotalWidth",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TotalWidth"]], "InlineFormula"],
     "\[LineSeparator]is an option which can be set for output streams to \
specify the maximum total number of characters of text that should be printed \
for each output expression. Short forms of expressions are given if the \
number of characters needed to print the whole expression is too large. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32420]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TotalWidth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TotalWidth"]], "InlineFormula"],
 " bounds the actual numbers of characters generated. Line breaks are not \
counted. "
}], "Notes",
 CellID->23225],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TotalWidth", "->", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 " allows expressions of any length to be printed. "
}], "Notes",
 CellID->30881],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SetOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetOptions"], "[", 
   RowBox[{
    StyleBox["stream", "TI"], ",", 
    RowBox[{"TotalWidth", "->", 
     StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
 " resets the total width allowed for an open stream. "
}], "Notes",
 CellID->31718]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->433874835],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->33416036],

Cell[TextData[{
 "Set the ",
 Cell[BoxData[
  ButtonBox["TotalWidth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TotalWidth"]], "InlineFormula"],
 " to be 60 characters for a stream: "
}], "ExampleText",
 CellID->280573051],

Cell[BoxData[
 RowBox[{
  RowBox[{"file1", "=", 
   RowBox[{"$TemporaryPrefix", "<>", "\"\<test1\>\""}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179329578],

Cell[BoxData[{
 RowBox[{
  RowBox[{"stream", "=", 
   RowBox[{"OpenWrite", "[", 
    RowBox[{"file1", ",", 
     RowBox[{"TotalWidth", "\[Rule]", "60"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Write", "[", 
   RowBox[{"stream", ",", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", "y"}], ")"}], "^", "5"}], "]"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Close", "[", "stream", "]"}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->694287890],

Cell[TextData[{
 "Set the ",
 Cell[BoxData[
  ButtonBox["TotalWidth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TotalWidth"]], "InlineFormula"],
 " to be 30 characters for a stream: "
}], "ExampleText",
 CellID->377445682],

Cell[BoxData[
 RowBox[{
  RowBox[{"file2", "=", 
   RowBox[{"$TemporaryPrefix", "<>", "\"\<test2\>\""}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->54838315],

Cell[BoxData[{
 RowBox[{
  RowBox[{"stream", "=", 
   RowBox[{"OpenWrite", "[", 
    RowBox[{"file2", ",", 
     RowBox[{"TotalWidth", "\[Rule]", "30"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Write", "[", 
   RowBox[{"stream", ",", 
    RowBox[{"Expand", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", "y"}], ")"}], "^", "5"}], "]"}]}], "]"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"Close", "[", "stream", "]"}], ";"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->205315132],

Cell["Compare the two resulting files: ", "ExampleText",
 CellID->36717047],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "file1", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->308122416],

Cell["\<\
6223232232322x^5 + 5*x^4*y + 10*x^3*y^2 + 10*x^2*y^3 + 5*x*y^4 + y^5\
\>", "Print",
 CellLabel->"During evaluation of In[43]:=",
 CellID->155128689]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "file2", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->76020921],

Cell["6223233x^5 + 5*x^4*y + <<>> + y^5", "Print",
 CellLabel->"During evaluation of In[44]:=",
 CellID->547926881]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26865],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Short",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Short"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Skeleton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Skeleton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageWidth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PageWidth"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20975]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16588],

Cell[TextData[ButtonBox["Files and Streams",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FilesAndStreams"]], "Tutorials",
 CellID->478647659]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TotalWidth - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 18.4583730}", "context" -> "System`", 
    "keywords" -> {
     "maximum total number of characters", "file I/O", "terminal I/O"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "TotalWidth is an option which can be set for output streams to specify \
the maximum total number of characters of text that should be printed for \
each output expression. Short forms of expressions are given if the number of \
characters needed to print the whole expression is too large. ", 
    "synonyms" -> {"total width"}, "title" -> "TotalWidth", "type" -> 
    "Symbol", "uri" -> "ref/TotalWidth"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4095, 137, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->433874835]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9986, 354}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1329, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1952, 59, 48, 1, 70, "ObjectName",
 CellID->28842],
Cell[2003, 62, 667, 16, 70, "Usage",
 CellID->32420]
}, Open  ]],
Cell[CellGroupData[{
Cell[2707, 83, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3185, 100, 254, 8, 70, "Notes",
 CellID->23225],
Cell[3442, 110, 252, 8, 70, "Notes",
 CellID->30881],
Cell[3697, 120, 361, 12, 70, "Notes",
 CellID->31718]
}, Closed]],
Cell[CellGroupData[{
Cell[4095, 137, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->433874835],
Cell[CellGroupData[{
Cell[4480, 151, 147, 5, 70, "ExampleSection",
 CellID->33416036],
Cell[4630, 158, 229, 8, 70, "ExampleText",
 CellID->280573051],
Cell[4862, 168, 166, 5, 70, "Input",
 CellID->179329578],
Cell[5031, 175, 498, 17, 70, "Input",
 CellID->694287890],
Cell[5532, 194, 229, 8, 70, "ExampleText",
 CellID->377445682],
Cell[5764, 204, 165, 5, 70, "Input",
 CellID->54838315],
Cell[5932, 211, 498, 17, 70, "Input",
 CellID->205315132],
Cell[6433, 230, 75, 1, 70, "ExampleText",
 CellID->36717047],
Cell[CellGroupData[{
Cell[6533, 235, 109, 3, 70, "Input",
 CellID->308122416],
Cell[6645, 240, 158, 4, 70, "Print",
 CellID->155128689]
}, Open  ]],
Cell[CellGroupData[{
Cell[6840, 249, 108, 3, 70, "Input",
 CellID->76020921],
Cell[6951, 254, 115, 2, 70, "Print",
 CellID->547926881]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7127, 263, 311, 9, 70, "SeeAlsoSection",
 CellID->26865],
Cell[7441, 274, 692, 26, 70, "SeeAlso",
 CellID->20975]
}, Open  ]],
Cell[CellGroupData[{
Cell[8170, 305, 314, 9, 70, "TutorialsSection",
 CellID->16588],
Cell[8487, 316, 147, 3, 70, "Tutorials",
 CellID->478647659]
}, Open  ]],
Cell[8649, 322, 27, 0, 70, "History"],
Cell[8679, 324, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

