(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23650,        761]
NotebookOptionsPosition[     19773,        640]
NotebookOutlinePosition[     21520,        684]
CellTagsIndexPosition[     21435,        679]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/Evaluation"], 
          "The Standard Evaluation Procedure" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStandardEvaluationProcedure"], 
          "Tracing Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/TracingEvaluation"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Evaluation\"\>", 
       2->"\<\"The Standard Evaluation Procedure\"\>", 
       3->"\<\"Tracing Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TraceDialog" :> 
          Documentation`HelpLookup["paclet:ref/TraceDialog"], "TracePrint" :> 
          Documentation`HelpLookup["paclet:ref/TracePrint"], "TraceScan" :> 
          Documentation`HelpLookup["paclet:ref/TraceScan"], "Monitor" :> 
          Documentation`HelpLookup["paclet:ref/Monitor"], "EvaluationMonitor" :> 
          Documentation`HelpLookup["paclet:ref/EvaluationMonitor"], "Stack" :> 
          Documentation`HelpLookup["paclet:ref/Stack"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"TraceDialog\"\>", 2->"\<\"TracePrint\"\>", 
       3->"\<\"TraceScan\"\>", 4->"\<\"Monitor\"\>", 
       5->"\<\"EvaluationMonitor\"\>", 
       6->"\<\"Stack\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level System Spelunking" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelSystemSpelunking"], 
          "Symbolic Execution History" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicExecutionHistory"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Low-Level System Spelunking\"\>", 
       2->"\<\"Symbolic Execution History\"\>", 
       3->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Trace", "ObjectName",
 CellID->4564],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Trace",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Trace"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a list of all expressions used in the \
evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Trace",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Trace"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]includes only those expressions which match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Trace",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Trace"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]includes all evaluations which use transformation rules \
associated with the symbol ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->11500]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In general, ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
 " is compared both with each complete expression that is evaluated, and with \
the tag associated with any transformation rule used in the evaluation. "
}], "Notes",
 CellID->10298],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     StyleBox["lhs", "TI"], "->", 
     StyleBox["rhs", "TI"]}]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " picks out expressions which match ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 ", then replaces them with ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 " in the list returned. "
}], "Notes",
 CellID->7682],

Cell[TextData[{
 "All expressions in the list returned by ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " are wrapped in ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23875],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " returns a set of nested lists. Each individual list corresponds to a \
single evaluation chain, which contains the sequence of forms found for a \
particular expression. The list has sublists which give the histories of \
subsidiary evaluations. "
}], "Notes",
 CellID->30370],

Cell["The following options can be given: ", "Notes",
 CellID->16498],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MatchLocalNames",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MatchLocalNames"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[TextData[{
     "whether to allow ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " to stand for ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "$", 
       StyleBox["nnn", "TI"]}]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TraceAbove",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TraceAbove"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to show evaluation chains which contain the chain containing ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TraceBackward",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TraceBackward"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to show expressions preceding ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " in the evaluation chain "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TraceDepth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TraceDepth"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "how many levels of nested evaluations to include ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TraceForward",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TraceForward"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to show expressions following ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " in the evaluation chain "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TraceOff",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TraceOff"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "forms within which to switch off tracing ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TraceOn",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TraceOn"], "_", Cell[
    "forms within which to switch on tracing ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TraceOriginal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TraceOriginal"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to look at expressions before their heads and arguments are evaluated \
\
\>", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->31051],

Cell[TextData[{
 "During the execution of ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ", the settings for the ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " argument, and for the options ",
 Cell[BoxData[
  ButtonBox["TraceOn",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceOn"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraceOff",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceOff"]], "InlineFormula"],
 ", can be modified by resetting the values of the global variables ",
 Cell[BoxData["$TracePattern"], "InlineFormula"],
 ", ",
 Cell[BoxData["$TraceOn"], "InlineFormula"],
 " and ",
 Cell[BoxData["$TraceOff"], "InlineFormula"],
 ", respectively. "
}], "Notes",
 CellID->28864]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->187906540],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->328987072],

Cell["Trace each step in an evaluation:", "ExampleText",
 CellID->714030922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"u", "=", "2"}], ";", 
   RowBox[{"Do", "[", 
    RowBox[{
     RowBox[{"u", "=", 
      RowBox[{"u", "*", "u"}]}], ",", 
     RowBox[{"{", "3", "}"}]}], "]"}], ";", "u"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10911687],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{513, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109085946]
}, Open  ]],

Cell[TextData[{
 "Trace only the computations with head ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->790170772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"u", "=", "2"}], ";", 
    RowBox[{"Do", "[", 
     RowBox[{
      RowBox[{"u", "=", 
       RowBox[{"u", "*", "u"}]}], ",", 
      RowBox[{"{", "3", "}"}]}], "]"}], ";", "u"}], ",", "Times"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->152128226],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"2", " ", "2"}],
        HoldForm], ",", 
       TagBox["4",
        HoldForm]}], "}"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"4", " ", "4"}],
        HoldForm], ",", 
       TagBox["16",
        HoldForm]}], "}"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"16", " ", "16"}],
        HoldForm], ",", 
       TagBox["256",
        HoldForm]}], "}"}], "}"}]}], "}"}], "}"}]], "Output",
 ImageSize->{304, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->566738404]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15467],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraceDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceDialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TracePrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TracePrint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraceScan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceScan"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Monitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Monitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EvaluationMonitor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EvaluationMonitor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Stack",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Stack"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20770]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22677],

Cell[TextData[ButtonBox["Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Evaluation"]], "Tutorials",
 CellID->959752411],

Cell[TextData[ButtonBox["The Standard Evaluation Procedure",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStandardEvaluationProcedure"]], "Tutorials",
 CellID->23023],

Cell[TextData[ButtonBox["Tracing Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TracingEvaluation"]], "Tutorials",
 CellID->260]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level System Spelunking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelSystemSpelunking"]], "MoreAbout",
 CellID->205207014],

Cell[TextData[ButtonBox["Symbolic Execution History",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicExecutionHistory"]], "MoreAbout",
 CellID->195632945],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->223095085]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Trace - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 26.5054540}", "context" -> "System`", 
    "keywords" -> {
     "call stack", "computation history", "debug", "history of computation", 
      "tracing assignments", "tracing based on tags", 
      "tracing calls to functions", "tracing messages", 
      "tracing of built-in functions", "tracing of conditions", 
      "tracing of recursion", "tracing of rules", 
      "tracing of system functions", "tracing of transformation rules"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Trace[expr] generates a list of all expressions used in the evaluation \
of expr. Trace[expr, form] includes only those expressions which match form. \
Trace[expr, s] includes all evaluations which use transformation rules \
associated with the symbol s. ", "synonyms" -> {}, "title" -> "Trace", "type" -> 
    "Symbol", "uri" -> "ref/Trace"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11650, 364, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->187906540]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21291, 672}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2925, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3548, 92, 42, 1, 70, "ObjectName",
 CellID->4564],
Cell[3593, 95, 1487, 48, 70, "Usage",
 CellID->11500]
}, Open  ]],
Cell[CellGroupData[{
Cell[5117, 148, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5595, 165, 500, 16, 70, "Notes",
 CellID->10298],
Cell[6098, 183, 549, 20, 70, "Notes",
 CellID->7682],
Cell[6650, 205, 348, 13, 70, "Notes",
 CellID->23875],
Cell[7001, 220, 408, 10, 70, "Notes",
 CellID->30370],
Cell[7412, 232, 69, 1, 70, "Notes",
 CellID->16498],
Cell[7484, 235, 3321, 95, 70, "3ColumnTableMod",
 CellID->31051],
Cell[10808, 332, 805, 27, 70, "Notes",
 CellID->28864]
}, Closed]],
Cell[CellGroupData[{
Cell[11650, 364, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->187906540],
Cell[CellGroupData[{
Cell[12035, 378, 148, 5, 70, "ExampleSection",
 CellID->328987072],
Cell[12186, 385, 76, 1, 70, "ExampleText",
 CellID->714030922],
Cell[CellGroupData[{
Cell[12287, 390, 291, 10, 28, "Input",
 CellID->10911687],
Cell[12581, 402, 2306, 42, 71, "Output",
 Evaluatable->False,
 CellID->109085946]
}, Open  ]],
Cell[14902, 447, 215, 8, 70, "ExampleText",
 CellID->790170772],
Cell[CellGroupData[{
Cell[15142, 459, 329, 12, 70, "Input",
 CellID->152128226],
Cell[15474, 473, 768, 32, 36, "Output",
 CellID->566738404]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16303, 512, 311, 9, 70, "SeeAlsoSection",
 CellID->15467],
Cell[16617, 523, 1453, 53, 70, "SeeAlso",
 CellID->20770]
}, Open  ]],
Cell[CellGroupData[{
Cell[18107, 581, 314, 9, 70, "TutorialsSection",
 CellID->22677],
Cell[18424, 592, 135, 3, 70, "Tutorials",
 CellID->959752411],
Cell[18562, 597, 174, 3, 70, "Tutorials",
 CellID->23023],
Cell[18739, 602, 144, 3, 70, "Tutorials",
 CellID->260]
}, Open  ]],
Cell[CellGroupData[{
Cell[18920, 610, 299, 8, 70, "MoreAboutSection"],
Cell[19222, 620, 163, 3, 70, "MoreAbout",
 CellID->205207014],
Cell[19388, 625, 162, 3, 70, "MoreAbout",
 CellID->195632945],
Cell[19553, 630, 148, 3, 70, "MoreAbout",
 CellID->223095085]
}, Open  ]],
Cell[19716, 636, 27, 0, 70, "History"],
Cell[19746, 638, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

