(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17949,        641]
NotebookOptionsPosition[     13658,        500]
NotebookOutlinePosition[     15167,        539]
CellTagsIndexPosition[     15082,        534]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tracing Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/TracingEvaluation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Tracing Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dialog" :> Documentation`HelpLookup["paclet:ref/Dialog"], 
          "Return" :> Documentation`HelpLookup["paclet:ref/Return"], "Trace" :> 
          Documentation`HelpLookup["paclet:ref/Trace"], "TraceScan" :> 
          Documentation`HelpLookup["paclet:ref/TraceScan"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dialog\"\>", 2->"\<\"Return\"\>", 
       3->"\<\"Trace\"\>", 4->"\<\"TraceScan\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Execution History" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicExecutionHistory"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Symbolic Execution History\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TraceDialog", "ObjectName",
 CellID->21750],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TraceDialog",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TraceDialog"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]initiates a dialog for every expression used in the \
evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TraceDialog",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TraceDialog"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]initiates a dialog only for expressions which match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TraceDialog",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TraceDialog"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]initiates dialogs only for expressions whose \
evaluations use transformation rules associated with the symbol ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->8653]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The expression to be evaluated when a dialog is called is given as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", 
   ButtonBox["$Line",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Line"], "]"}]], "InlineFormula"],
 " of the dialog, wrapped in ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 ". The expression can be seen by asking for ",
 Cell[BoxData["%"], "InlineFormula"],
 " when the dialog is first started. "
}], "Notes",
 CellID->11953],

Cell["Any value returned from the dialog is discarded. ", "Notes",
 CellID->15229],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraceDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceDialog"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " returns the result of evaluating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4509]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3238178],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->307282892],

Cell[TextData[{
 "Trace evaluation of an expression, entering a ",
 Cell[BoxData[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
 " whenever addition is encountered:"
}], "ExampleText",
 CellID->784463549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraceDialog", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"2", "^", "2"}]}], ",", "_Plus"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300391381],

Cell[BoxData[
 RowBox[{
  RowBox[{"TraceDialog", "::", "\<\"dgbgn\"\>"}], ":", 
  " ", "\<\"Entering Dialog; use Return[] to exit. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/TraceDialog/dgbgn\\\", ButtonNote -> \
\\\"TraceDialog::dgbgn\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->145117171],

Cell[BoxData[
 TagBox[
  RowBox[{"1", "+", 
   SuperscriptBox["2", "2"]}],
  HoldForm]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->465358469],

Cell[BoxData[
 RowBox[{
  RowBox[{"TraceDialog", "::", "\<\"dgend\"\>"}], ":", 
  " ", "\<\"Exiting Dialog. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/TraceDialog/dgend\\\", ButtonNote -> \
\\\"TraceDialog::dgend\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->376027776],

Cell[BoxData[
 RowBox[{
  RowBox[{"TraceDialog", "::", "\<\"dgbgn\"\>"}], ":", 
  " ", "\<\"Entering Dialog; use Return[] to exit. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/TraceDialog/dgbgn\\\", ButtonNote -> \
\\\"TraceDialog::dgbgn\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->29483330],

Cell[BoxData[
 TagBox[
  RowBox[{"1", "+", "4"}],
  HoldForm]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->443883665],

Cell[BoxData[
 RowBox[{
  RowBox[{"TraceDialog", "::", "\<\"dgend\"\>"}], ":", 
  " ", "\<\"Exiting Dialog. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/TraceDialog/dgend\\\", ButtonNote -> \
\\\"TraceDialog::dgend\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->391699727],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53383526]
}, Open  ]],

Cell["In the dialog you can look at the evaluation stack:", "ExampleText",
 CellID->21352336],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stack", "[", "_", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->173295030],

Cell[BoxData[
 RowBox[{"{", 
  TagBox[
   RowBox[{"TraceDialog", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      SuperscriptBox["2", "2"]}], ",", "_Plus"}], "]"}],
   HoldForm], "}"}]], "Output",
 ImageSize->{188, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"(Dialog) Out[2]=",
 CellID->671057332]
}, Open  ]],

Cell["This returns from the first dialog:", "ExampleText",
 CellID->8320785],

Cell[BoxData[
 RowBox[{"Return", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7167209],

Cell["Another dialog has started:", "ExampleText",
 CellID->538890306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Stack", "[", "_", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->38815438],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"TraceDialog", "[", 
     RowBox[{
      RowBox[{"1", "+", 
       SuperscriptBox["2", "2"]}], ",", "_Plus"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"1", "+", 
     SuperscriptBox["2", "2"]}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{231, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"(Dialog) Out[4]=",
 CellID->82965788]
}, Open  ]],

Cell["\<\
In the dialog, you can check evaluations to see if they come out as you \
expect:\
\>", "ExampleText",
 CellID->186063005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "^", "2"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->199949396],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"(Dialog) Out[5]=",
 CellID->802273245]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", "%"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->239151704],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"(Dialog) Out[6]=",
 CellID->25858498]
}, Open  ]],

Cell["\<\
Return from the second dialog. Since there are no more additions, the \
evaluation will finish:\
\>", "ExampleText",
 CellID->260430210],

Cell[BoxData[
 RowBox[{"Return", "[", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->452869476]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8778],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Return",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Return"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraceScan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceScan"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4886]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5343],

Cell[TextData[ButtonBox["Tracing Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TracingEvaluation"]], "Tutorials",
 CellID->260]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Symbolic Execution History",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicExecutionHistory"]], "MoreAbout",
 CellID->9904332]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TraceDialog - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 19.7709066}", "context" -> "System`", 
    "keywords" -> {"dialog", "stack trace", "evaluation chain", "debug"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "TraceDialog[expr] initiates a dialog for every expression used in the \
evaluation of expr. TraceDialog[expr, form] initiates a dialog only for \
expressions which match form. TraceDialog[expr, s] initiates dialogs only for \
expressions whose evaluations use transformation rules associated with the \
symbol s. ", "synonyms" -> {"trace dialog"}, "title" -> "TraceDialog", "type" -> 
    "Symbol", "uri" -> "ref/TraceDialog"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5832, 190, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->3238178]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14941, 527}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2020, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2643, 76, 49, 1, 70, "ObjectName",
 CellID->21750],
Cell[2695, 79, 1560, 48, 70, "Usage",
 CellID->8653]
}, Open  ]],
Cell[CellGroupData[{
Cell[4292, 132, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4770, 149, 610, 19, 70, "Notes",
 CellID->11953],
Cell[5383, 170, 82, 1, 70, "Notes",
 CellID->15229],
Cell[5468, 173, 327, 12, 70, "Notes",
 CellID->4509]
}, Closed]],
Cell[CellGroupData[{
Cell[5832, 190, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->3238178],
Cell[CellGroupData[{
Cell[6215, 204, 148, 5, 70, "ExampleSection",
 CellID->307282892],
Cell[6366, 211, 258, 8, 70, "ExampleText",
 CellID->784463549],
Cell[CellGroupData[{
Cell[6649, 223, 183, 6, 70, "Input",
 CellID->300391381],
Cell[6835, 231, 377, 7, 19, "Message",
 CellID->145117171],
Cell[7215, 240, 228, 9, 36, "Output",
 CellID->465358469],
Cell[7446, 251, 354, 7, 70, "Message",
 CellID->376027776],
Cell[7803, 260, 376, 7, 70, "Message",
 CellID->29483330],
Cell[8182, 269, 203, 8, 36, "Output",
 CellID->443883665],
Cell[8388, 279, 354, 7, 70, "Message",
 CellID->391699727],
Cell[8745, 288, 157, 5, 36, "Output",
 CellID->53383526]
}, Open  ]],
Cell[8917, 296, 93, 1, 70, "ExampleText",
 CellID->21352336],
Cell[CellGroupData[{
Cell[9035, 301, 101, 3, 70, "Input",
 CellID->173295030],
Cell[9139, 306, 336, 12, 53, "Output",
 CellID->671057332]
}, Open  ]],
Cell[9490, 321, 76, 1, 70, "ExampleText",
 CellID->8320785],
Cell[9569, 324, 95, 3, 70, "Input",
 CellID->7167209],
Cell[9667, 329, 70, 1, 70, "ExampleText",
 CellID->538890306],
Cell[CellGroupData[{
Cell[9762, 334, 100, 3, 70, "Input",
 CellID->38815438],
Cell[9865, 339, 442, 17, 53, "Output",
 CellID->82965788]
}, Open  ]],
Cell[10322, 359, 132, 4, 70, "ExampleText",
 CellID->186063005],
Cell[CellGroupData[{
Cell[10479, 367, 92, 3, 70, "Input",
 CellID->199949396],
Cell[10574, 372, 167, 5, 50, "Output",
 CellID->802273245]
}, Open  ]],
Cell[CellGroupData[{
Cell[10778, 382, 92, 3, 70, "Input",
 CellID->239151704],
Cell[10873, 387, 166, 5, 50, "Output",
 CellID->25858498]
}, Open  ]],
Cell[11054, 395, 146, 4, 70, "ExampleText",
 CellID->260430210],
Cell[11203, 401, 97, 3, 70, "Input",
 CellID->452869476]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11349, 410, 310, 9, 70, "SeeAlsoSection",
 CellID->8778],
Cell[11662, 421, 928, 35, 70, "SeeAlso",
 CellID->4886]
}, Open  ]],
Cell[CellGroupData[{
Cell[12627, 461, 313, 9, 70, "TutorialsSection",
 CellID->5343],
Cell[12943, 472, 144, 3, 70, "Tutorials",
 CellID->260]
}, Open  ]],
Cell[CellGroupData[{
Cell[13124, 480, 299, 8, 70, "MoreAboutSection"],
Cell[13426, 490, 160, 3, 70, "MoreAbout",
 CellID->9904332]
}, Open  ]],
Cell[13601, 496, 27, 0, 70, "History"],
Cell[13631, 498, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

