(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13515,        468]
NotebookOptionsPosition[     10311,        362]
NotebookOutlinePosition[     11672,        399]
CellTagsIndexPosition[     11587,        394]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tracing Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/TracingEvaluation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Tracing Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Trace" :> Documentation`HelpLookup["paclet:ref/Trace"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Trace\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TraceForward", "ObjectName",
 CellID->27236],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["TraceForward",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TraceForward"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Trace",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
     " and related functions which specifies whether to include later \
expressions on the evaluation chain that contains the pattern ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " sought. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28469]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TraceForward", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " includes the final expression on the evaluation chain that contains ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19924],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TraceForward", "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " includes all expressions after ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " on the evaluation chain that contains ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30386],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraceForward",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceForward"]], "InlineFormula"],
 " allows you to see the transformations performed on an expression generated \
during an evaluation. "
}], "Notes",
 CellID->18972]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->908882171],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->4101977],

Cell["A recursive definition for finding Fibonacci numbers:", "ExampleText",
 CellID->85517671],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fib", "[", "0", "]"}], "=", 
   RowBox[{
    RowBox[{"fib", "[", "1", "]"}], "=", "1"}]}], ";", 
  RowBox[{
   RowBox[{"fib", "[", "n_", "]"}], ":=", 
   RowBox[{
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "1"}], "]"}], "+", 
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75714580],

Cell[TextData[{
 "Show only what evaluations of ",
 Cell[BoxData["fib"], "InlineFormula"],
 " are encountered:"
}], "ExampleText",
 CellID->91783335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fib", "[", "3", "]"}], ",", " ", "_fib"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->387546432],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"fib", "[", "3", "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"fib", "[", "2", "]"}],
      HoldForm], ",", 
     RowBox[{"{", 
      TagBox[
       RowBox[{"fib", "[", "1", "]"}],
       HoldForm], "}"}], ",", 
     RowBox[{"{", 
      TagBox[
       RowBox[{"fib", "[", "0", "]"}],
       HoldForm], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    TagBox[
     RowBox[{"fib", "[", "1", "]"}],
     HoldForm], "}"}]}], "}"}]], "Output",
 ImageSize->{329, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->951556166]
}, Open  ]],

Cell[TextData[{
 "Show only the evaluations of ",
 Cell[BoxData["fib"], "InlineFormula"],
 " and the results:"
}], "ExampleText",
 CellID->902758101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fib", "[", "3", "]"}], ",", "_fib", ",", 
   RowBox[{"TraceForward", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->347458106],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWN1ugjAUPlARN6OwXemdT7Nd7SGIWaIXy4zzgeaTYgt0MV8Oa9G2gE2A
nv6c7/Troe3pR3HafX4Vp/222Lwfi8Nuv/3ZvH0fZZGIiKJfIspWJPOlzFWP
Smf5EE3UW+iyklbyFUtx3nwTqH/23D4DGe1zrS8PjIf1opoFAaVrkOdML4WO
1vnu9xJI32sgHCyP2dlQpYkU9beZtCoJxgdUNVeOvjC7E0e3Q7194UwD2WPL
r6096Uh5TFt44L0YZbZX8ic3Q0FMu1ZKVv/X08PaYCNz6GNiqq3d7AH5T+35
rN//6LxtRFOu15W89IJqmg0/qCYZT0mIsvBilV0rk23IGM6rH9vvZRTPwegX
UYXrZ08xeT57Zg7OWD+oYay6zfO7xlLDZJSNAZycptS+wmpj9h9THOkKjztL
h8Dtw+9t7HLj+Vx8ORZWOe8zx8FCszSp66lKqKfryj5EBNee290CNz6KdyrD
Y8rNSox3RKyHdGZzmCi+V1U/o8T65Si4WlhZWfsoF2XhP1QnHU/HTa1u1XYL
GlKL3hnUNy/5nYLb+brb2KY9v9bmBNVmTFkLan29p7JnixxFF87Qmao=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{416, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->403498053]
}, Open  ]],

Cell[TextData[{
 "Show all intermediate evaluations between calls of ",
 Cell[BoxData["fib"], "InlineFormula"],
 " and the result:"
}], "ExampleText",
 CellID->17157376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fib", "[", "3", "]"}], ",", "_fib", ",", 
   RowBox[{"TraceForward", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->29144157],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1uEzEQdrLZpgW1m7aXcmkrgRAXQOpDwImHiKpK7QGB2j5eeSnggjgs
a3sN0cc4479xckikrHfWs/Pn8Xhm9tPy8fbm8/Lx7np5+fF++fX27vrh8sOX
++FRM1Fq8qSUujpTw30/3Jm//n0b/vbW3j3X18bN9upsuEyVfa7HFuY7gGcA
v2Tw9eW94fwMZl4AjJI1o0THnuevPPP68o7kOB0u7QC60ZBS9tcQujs81Bnh
vUi8OTxvPe9rPEouv4YNQRk1Uu1feFSfk5uCteUPAvHmJFe0AsLr30Ze/2zC
SSVjE/R75HIIsM8XKG9HPd/2m1t7Lh7gPLfKqO+U0Dfd16fjbl/HIVfjBcB7
jMZdT0dav6arcatxazaz8zZ6Ia1cnXBVEL/cquE8Wi9XE7Pv/vN6lJ/G8scY
6qzClbE/vdL74+giWjuOi95/5jajlA6v8chjz1Z9hyd9/F1sbnA+Pnfjm3G8
8ODjWufmHqXpcbkM4tv0ITWvuSCsuQq/BhjxHZ3SeVWtPM3Nz0grSudqsXSP
PPR9uVws/S5Q/v3KdpKWx0VO7gQLlWc+4uE54suxQ+maE04o5wrPzNxpIsUT
cxnO2ykrl5Kli7IKZv3bWQnJSBnnP6GycplZXr3msG14kKnZOOseiXBxEYXL
ZFsPnqwUnA22s1ouI1UYFicblRVSlTxaFlfCxPENVfFlPJ+rhOucHlztyq3v
dvZNap4MEh2OdfRMtBfr51AZZqzvp/DhtE7x/hQ5uA5iiqfV6KNJybWZPYD4
qA29B+I7fSgHan+YTZHLELpsDlw3Edemfj80XwIZL0SYs2RY5OUy/zBd0G/S
qHI5Bc6ncQmrNbkIJd3LzuVfxwfDeunWE9P76A7LdRbD31rtuuvxNOrtY+B9
kqxByJcA6iyPt4+PunvOfWcwfmWA/G8MSLv0N4YfhgvujNo9+Z+kFNK90Vi6
vp5zbk/b0V946CP8nbTWrrcqJ0tcb9XuKS7fT5OPy1/LdCqQi/at+j26UCmQ
+q9ebn9sxv5cTSGzF5AKl+mk2z20XqZOsFL9idXsqLStY/ifMvajrbyrhCkd
wjxyV7/RGlnrUV9OcLXsb1trjt9GD40dknGryR85qqEF\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{444, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->368720491]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10925],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->18875]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20802],

Cell[TextData[ButtonBox["Tracing Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TracingEvaluation"]], "Tutorials",
 CellID->260]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TraceForward - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 20.0052876}", "context" -> "System`", 
    "keywords" -> {"stack trace", "evaluation chain"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TraceForward is an option for Trace and related functions which \
specifies whether to include later expressions on the evaluation chain that \
contains the pattern form sought. ", "synonyms" -> {"trace forward"}, "title" -> 
    "TraceForward", "type" -> "Symbol", "uri" -> "ref/TraceForward"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4136, 146, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->908882171]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11444, 387}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1136, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1759, 57, 50, 1, 70, "ObjectName",
 CellID->27236],
Cell[1812, 60, 760, 22, 70, "Usage",
 CellID->28469]
}, Open  ]],
Cell[CellGroupData[{
Cell[2609, 87, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3087, 104, 333, 11, 70, "Notes",
 CellID->19924],
Cell[3423, 117, 398, 14, 70, "Notes",
 CellID->30386],
Cell[3824, 133, 275, 8, 70, "Notes",
 CellID->18972]
}, Closed]],
Cell[CellGroupData[{
Cell[4136, 146, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->908882171],
Cell[CellGroupData[{
Cell[4521, 160, 146, 5, 70, "ExampleSection",
 CellID->4101977],
Cell[4670, 167, 95, 1, 70, "ExampleText",
 CellID->85517671],
Cell[4768, 170, 402, 14, 70, "Input",
 CellID->75714580],
Cell[5173, 186, 149, 5, 70, "ExampleText",
 CellID->91783335],
Cell[CellGroupData[{
Cell[5347, 195, 163, 5, 28, "Input",
 CellID->387546432],
Cell[5513, 202, 666, 27, 36, "Output",
 CellID->951556166]
}, Open  ]],
Cell[6194, 232, 149, 5, 70, "ExampleText",
 CellID->902758101],
Cell[CellGroupData[{
Cell[6368, 241, 212, 6, 28, "Input",
 CellID->347458106],
Cell[6583, 249, 817, 17, 36, "Output",
 Evaluatable->False,
 CellID->403498053]
}, Open  ]],
Cell[7415, 269, 169, 5, 70, "ExampleText",
 CellID->17157376],
Cell[CellGroupData[{
Cell[7609, 278, 210, 6, 28, "Input",
 CellID->29144157],
Cell[7822, 286, 1354, 26, 71, "Output",
 Evaluatable->False,
 CellID->368720491]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9237, 319, 311, 9, 70, "SeeAlsoSection",
 CellID->10925],
Cell[9551, 330, 190, 6, 70, "SeeAlso",
 CellID->18875]
}, Open  ]],
Cell[CellGroupData[{
Cell[9778, 341, 314, 9, 70, "TutorialsSection",
 CellID->20802],
Cell[10095, 352, 144, 3, 70, "Tutorials",
 CellID->260]
}, Open  ]],
Cell[10254, 358, 27, 0, 70, "History"],
Cell[10284, 360, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

