(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13548,        459]
NotebookOptionsPosition[     10635,        362]
NotebookOutlinePosition[     11922,        398]
CellTagsIndexPosition[     11837,        393]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tracing Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/TracingEvaluation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Tracing Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Trace" :> Documentation`HelpLookup["paclet:ref/Trace"], 
          "TraceOff" :> Documentation`HelpLookup["paclet:ref/TraceOff"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Trace\"\>", 
       2->"\<\"TraceOff\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TraceOn", "ObjectName",
 CellID->27822],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["TraceOn",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TraceOn"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Trace",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
     " and related functions which specifies when tracing should be switched \
on. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10258]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"TraceOn", "->", 
   StyleBox["patt", "TI"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " and related functions do not start tracing until they encounter \
expressions to evaluate which match the pattern ",
 Cell[BoxData[
  StyleBox["patt", "TI"]], "InlineFormula"],
 ". This pattern is also tested against tags associated with the evaluation. \
"
}], "Notes",
 CellID->30873],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraceOff",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceOff"]], "InlineFormula"],
 " can be used within tracing switched on by ",
 Cell[BoxData[
  ButtonBox["TraceOn",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceOn"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30876],

Cell[TextData[{
 "Once tracing has been switched off by ",
 Cell[BoxData[
  ButtonBox["TraceOff",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceOff"]], "InlineFormula"],
 ", however, ",
 Cell[BoxData[
  ButtonBox["TraceOn",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceOn"]], "InlineFormula"],
 " will not switch it on again. "
}], "Notes",
 CellID->30396],

Cell[TextData[{
 "During the execution of ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ", the settings for ",
 Cell[BoxData[
  ButtonBox["TraceOn",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceOn"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraceOff",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceOff"]], "InlineFormula"],
 " can be modified by resetting the values of the global variables ",
 Cell[BoxData["$TraceOn"], "InlineFormula"],
 " and ",
 Cell[BoxData["$TraceOff"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18706]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->178577143],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->38796352],

Cell[TextData[{
 "Trace evaluation of an expression that evaluates a function ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->83694623],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "x_", "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"x", "^", "2"}], " ", "+", " ", "1"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31069508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"1", "+", 
   RowBox[{"g", "[", "1", "]"}], "+", 
   RowBox[{"g", "[", 
    RowBox[{"g", "[", "1", "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->440553655],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1SE0EQnrDZBEhIggHKm0HFkpN40oNyU09W6UXPKYoqOFhayNmn8DV8
N3mCdXt3B4Yv3XTvbipshFRldnu2/6a7p2em5+P0/OT42/T89Gg6+XA2/XFy
evRz8v77WdoVtZxr/XXO7T106XuSvmV/+l2kf+d6abuSdsXF82vx3C2eb4vn
sdD/OaB3bp3ayEtIXBvgLwA/AfgNwNOS+J8AXlliraK0iQLPhJ4K8Z4DvAbw
SIEjZTQa/uqS6PlKwbd5pcNRBXCP0YKssV88kf+o6N8U6J4q3/sN0+e18N0e
8+0UxH6ijpl+zjsxY5VYoF8V5KCeHYFekt81yrfy7TbULjSHCcS5hvw8Hs4e
SX43ucopdeyN/R2BryTPFrUZVnwJZzS6TziYZg7mRfQZjkmiQ/7rRjyJH8qV
9OiarWHHtltY5lnVjrxsb03Mr5h/2wIeF4H1ran5LGa52bAqeEyNtcg8upvg
IcDkG272DxQfbCvfOXqLHMx6fdOoMadq2vSM2qCcrbTpMPL7QT/Hl9sBWKyF
1vA5HGOlx1oJrdDK+heToTHOtIyC+MgP402Tp2VgTd5GI60wNmnF665ZhN2F
1rAwwraY5XOjKWZDuAG+mnfEame2DYMNMCMgD5SBK7FmA+SfxWv7Cp7VaDCD
odmBKCImu2n2xH06l1sJHAr87acysnxu2vyn7fi1yNhRvteNPJz5WiYYGMao
nf1RxpaiI/IbBzCXN4bwHeVp+xuUP1boM3hO2QxnXdl4ISkRM2YtbjwdZoGy
8WNbOzGqbfsOnrd1xLwMbtyLiKkhqw1af96R5deFsJI9CvpxPbipgsVZiPpx
tvqM8SCQx+XYnYBvFOjp8bn1StKPw99Uxhk+uRpSOA4fb4QnrUk2r7wE+DHA
SI8zB2voCNflV60mv5yjwjuegwCL5p2v6a5B/3Zy/a7nsCLd9Tuid6DjC4B/
K9//ZFzo9QLeMANId1lEsZ9RaLuYsjdD1Dy7Zc7Lcm9EzcQ0oqbduRCwa/ZF
E+v2t32fQc0jkwXva+shXblqMAH5DOOq0jNz887VYanZSxYXhU2vxmjyqLGt
Qfe1q7Ir9v9eX7Fb425UCsrZo8nnW/tI5n16aoJk9ErVsxVxzM8khyALzz/U
/Mq5tP4B4DByKA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{496, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->261740490]
}, Open  ]],

Cell[TextData[{
 "Trace only evaluation inside of ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->577127716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"g", "[", "1", "]"}], "+", 
    RowBox[{"g", "[", 
     RowBox[{"g", "[", "1", "]"}], "]"}]}], ",", 
   RowBox[{"TraceOn", "\[Rule]", "_g"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->335130619],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1OGzEQdthsAiSEUH7EkVKQ2lMLZ8qt5cS1Pa8QEhwQFfAofQR4IeBQ
JN5la++uwXwZM7NORAwhUtYZ7/x+Ho/j2c8ujg5Psovjg2xt7yz7c3R8cL72
8/RMTyUNpRqXSqnNVaV/5/pX8TWfK/1VqqOfU3oqrcbf1fixGr9X46FnPnVG
pWbNM7EWctUE+hfQn4DeATqryY/2pl6xV4l+JA7C7kq5fJ+BngG6z9AJEw3H
Px2pn2Gotygph+4QXplov1Qj6u9X8wseuQ3mfTcSf8JzuKlJSjol5qnVSAkU
Uo/8tMcO+tnyyPvst4X2pXrbkeJi9qQhca+hPsuHu8Vnv50/1ojhs6rgSh/o
QobHjKJNpmMdQkxx7X1yqH9WyOfTh3Z9frTFaMi55Qj7dYbiSNu2aGK9w3rY
9PBh5g2P5mDeciudBOlGeh5ogwxVo3oMAsvMe0peYgdrQlcUNVYczpuO0Bu0
s6QfLcJ+15mn9FLn5XN2GkWcL1PJMCO4nYf8qA8zg7PHVSrO3lyUKCyKvKJ9
5xDBbKKqWOC56NIRoDjqXOJuBXMCDLC2oA60gWcJhwHqLzKp+UgPetQb4OBw
MBKj+0dl//2XUJQfrsJxK7nCvB82U3APcXuqJ4iRu/2hjSXGR9S36NBUNZmH
92iPO9PDVh/zu+5KGysJ4S234laOu7lzKy87PzAfZWcvrVsaMW2DijuubLBV
0+3w9Z15rJbPdRSoqMw87g27Pz849qgKt+LoTRw/LT9VzX3+UfwLTJzuSN3h
w1DfAnodaJTHbMaeI9LD6pukqLAn/s3hMvvQ9shmYH45f9ob3w2Ue9pT/wE+
fgX6L/O+6FYXxBX8wh3u6/3fF9zc/4G6XfS7MWp9Lb31G1E0sfWsb8VrEGMP
dNy94WsReu89UFeuXg+03FXcnXsyu3X/8pfLvth7DZw92Vnz3pWpcyq/9S6E
DInJuJHLsYj5PiqLYtQ3oXFaxZUIvR+V94pdsIH3F/PYLjU0/gNUnb5s\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{420, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->50364859]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27141],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraceOff",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceOff"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16139]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22105],

Cell[TextData[ButtonBox["Tracing Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TracingEvaluation"]], "Tutorials",
 CellID->260]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TraceOn - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 27.2867240}", "context" -> "System`", 
    "keywords" -> {"stack trace", "evaluation chain", "trace control"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "TraceOn is an option for Trace and related functions which specifies \
when tracing should be switched on. ", "synonyms" -> {"trace on"}, "title" -> 
    "TraceOn", "type" -> "Symbol", "uri" -> "ref/TraceOn"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4956, 177, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->178577143]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11694, 386}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1233, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1856, 58, 45, 1, 70, "ObjectName",
 CellID->27822],
Cell[1904, 61, 613, 19, 70, "Usage",
 CellID->10258]
}, Open  ]],
Cell[CellGroupData[{
Cell[2554, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3032, 102, 538, 17, 70, "Notes",
 CellID->30873],
Cell[3573, 121, 334, 12, 70, "Notes",
 CellID->30876],
Cell[3910, 135, 373, 13, 70, "Notes",
 CellID->30396],
Cell[4286, 150, 633, 22, 70, "Notes",
 CellID->18706]
}, Closed]],
Cell[CellGroupData[{
Cell[4956, 177, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->178577143],
Cell[CellGroupData[{
Cell[5341, 191, 147, 5, 70, "ExampleSection",
 CellID->38796352],
Cell[5491, 198, 180, 6, 70, "ExampleText",
 CellID->83694623],
Cell[5674, 206, 209, 7, 70, "Input",
 CellID->31069508],
Cell[CellGroupData[{
Cell[5908, 217, 222, 7, 28, "Input",
 CellID->440553655],
Cell[6133, 226, 1387, 27, 58, "Output",
 Evaluatable->False,
 CellID->261740490]
}, Open  ]],
Cell[7535, 256, 153, 6, 70, "ExampleText",
 CellID->577127716],
Cell[CellGroupData[{
Cell[7713, 266, 286, 9, 28, "Input",
 CellID->335130619],
Cell[8002, 277, 1243, 24, 58, "Output",
 Evaluatable->False,
 CellID->50364859]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9306, 308, 311, 9, 70, "SeeAlsoSection",
 CellID->27141],
Cell[9620, 319, 445, 17, 70, "SeeAlso",
 CellID->16139]
}, Open  ]],
Cell[CellGroupData[{
Cell[10102, 341, 314, 9, 70, "TutorialsSection",
 CellID->22105],
Cell[10419, 352, 144, 3, 70, "Tutorials",
 CellID->260]
}, Open  ]],
Cell[10578, 358, 27, 0, 70, "History"],
Cell[10608, 360, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

