(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9593,        327]
NotebookOptionsPosition[      7634,        266]
NotebookOutlinePosition[      8799,        297]
CellTagsIndexPosition[      8756,        294]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Simplification" :> 
          Documentation`HelpLookup["paclet:tutorial/Simplification"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Simplification\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Simplify" :> Documentation`HelpLookup["paclet:ref/Simplify"], 
          "FullSimplify" :> 
          Documentation`HelpLookup["paclet:ref/FullSimplify"], "ReplaceAll" :> 
          Documentation`HelpLookup["paclet:ref/ReplaceAll"], "ExcludedForms" :> 
          Documentation`HelpLookup["paclet:ref/ExcludedForms"], 
          "FunctionExpand" :> 
          Documentation`HelpLookup["paclet:ref/FunctionExpand"], 
          "ComplexityFunction" :> 
          Documentation`HelpLookup["paclet:ref/ComplexityFunction"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Simplify\"\>", 
       2->"\<\"FullSimplify\"\>", 3->"\<\"ReplaceAll\"\>", 
       4->"\<\"ExcludedForms\"\>", 5->"\<\"FunctionExpand\"\>", 
       6->"\<\"ComplexityFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TransformationFunctions", "ObjectName",
 CellID->21301],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["TransformationFunctions",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TransformationFunctions"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Simplify",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["FullSimplify",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
     " which gives the list of functions to apply to try to transform parts \
of an expression. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27781]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"TransformationFunctions", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " uses a built\[Hyphen]in collection of transformation functions. "
}], "Notes",
 CellID->30702],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TransformationFunctions", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " uses only the functions ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30293],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TransformationFunctions", "->", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " uses built\[Hyphen]in transformation functions together with the functions \
",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["f", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25896]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25978],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullSimplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullSimplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplaceAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExcludedForms",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExcludedForms"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FunctionExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FunctionExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexityFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexityFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22014]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14020],

Cell[TextData[ButtonBox["Simplification",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Simplification"]], "Tutorials",
 CellID->4901]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TransformationFunctions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 36.6150878}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TransformationFunctions is an option for Simplify and FullSimplify which \
gives the list of functions to apply to try to transform parts of an \
expression. ", "synonyms" -> {"transformation functions"}, "title" -> 
    "TransformationFunctions", "type" -> "Symbol", "uri" -> 
    "ref/TransformationFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1748, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2371, 67, 61, 1, 70, "ObjectName",
 CellID->21301],
Cell[2435, 70, 821, 24, 70, "Usage",
 CellID->27781]
}, Open  ]],
Cell[CellGroupData[{
Cell[3293, 99, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3771, 116, 308, 9, 70, "Notes",
 CellID->30702],
Cell[4082, 127, 497, 19, 70, "Notes",
 CellID->30293],
Cell[4582, 148, 652, 23, 70, "Notes",
 CellID->25896]
}, Closed]],
Cell[CellGroupData[{
Cell[5271, 176, 311, 9, 70, "SeeAlsoSection",
 CellID->25978],
Cell[5585, 187, 1485, 53, 70, "SeeAlso",
 CellID->22014]
}, Open  ]],
Cell[CellGroupData[{
Cell[7107, 245, 314, 9, 70, "TutorialsSection",
 CellID->14020],
Cell[7424, 256, 138, 3, 70, "Tutorials",
 CellID->4901]
}, Open  ]],
Cell[7577, 262, 27, 0, 70, "History"],
Cell[7607, 264, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

