(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    117691,       2536]
NotebookOptionsPosition[    112273,       2357]
NotebookOutlinePosition[    113685,       2396]
CellTagsIndexPosition[    113598,       2391]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Rotate" :> Documentation`HelpLookup["paclet:ref/Rotate"], 
          "Scale" :> Documentation`HelpLookup["paclet:ref/Scale"], "Normal" :> 
          Documentation`HelpLookup["paclet:ref/Normal"], 
          "TranslationTransform" :> 
          Documentation`HelpLookup["paclet:ref/TranslationTransform"], 
          "AffineTransform" :> 
          Documentation`HelpLookup["paclet:ref/AffineTransform"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Rotate\"\>", 2->"\<\"Scale\"\>", 
       3->"\<\"Normal\"\>", 4->"\<\"TranslationTransform\"\>", 
       5->"\<\"AffineTransform\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Geometric Transforms" :> 
          Documentation`HelpLookup["paclet:guide/GeometricTransforms"], 
          "Graphics Transformations" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsTransformations"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Geometric Transforms\"\>", 
       2->"\<\"Graphics Transformations\"\>", 
       3->"\<\"Symbolic Graphics Language\"\>", 
       4->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Translate", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Translate",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Translate"], "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents graphics primitives ",
     Cell[BoxData[
      StyleBox["g", "TI"]], "InlineFormula"],
     " translated by the vector ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2662]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Translate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Translate"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " in effect adds ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " to each set of coordinates that appear in the graphics primitives ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27996],

Cell[TextData[{
 "For objects specified with scaled coordinates ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Translate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Translate"]], "InlineFormula"],
 " effectively applies its transformation to the corresponding ordinary \
coordinates. "
}], "Notes",
 CellID->28213],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " if possible replaces all ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Translate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Translate"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["g", "TI"], 
     StyleBox["i", "TI"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " constructs by versions of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["g", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " in which the coordinates have explicitly been transformed. "
}], "Notes",
 CellID->9451]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->35210025],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->21443249],

Cell["Translation of a 2D graphics primitive:", "ExampleText",
 CellID->191385360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Translate", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19486452],

Cell[BoxData[
 GraphicsBox[GeometricTransformationBox[CircleBox[{0, 0}], {1, 0}],
  Axes->True]], "Output",
 ImageSize->{184, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->153951682]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->76243112],

Cell["Translate a 3D graphics primitive: ", "ExampleText",
 CellID->118021406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Translate", "[", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->655917439],

Cell[BoxData[
 Graphics3DBox[
  InterpretationBox[SphereBox[{1., 0., 0.}, 1.],
   Translate[
    Sphere[{0, 0, 0}], {1, 0, 0}]],
  Axes->True]], "Output",
 ImageSize->{184, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128721569,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->61910161],

Cell["Transformation applied to a 2D shape:", "ExampleText",
 CellID->479507293],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Rectangle", "[", "]"}], ",", 
     RowBox[{"AbsolutePointSize", "[", "10", "]"}], ",", 
     RowBox[{"Opacity", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->419323043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", ".35", "]"}], ",", "Blue", ",", "gr"}], "}"}], 
    ",", 
    RowBox[{"Translate", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Opacity", "[", ".85", "]"}], ",", "Red", ",", "gr"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".5"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->150504143],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], Opacity[0.35], RectangleBox[{0, 0}], 
    {AbsolutePointSize[10], Opacity[1], 
     {RGBColor[1, 0, 1], PointBox[{0, 0}]}, 
     {RGBColor[0, 1, 0], PointBox[{1, 1}]}}}, GeometricTransformationBox[
    {RGBColor[1, 0, 0], Opacity[0.85], RectangleBox[{0, 0}], 
     {AbsolutePointSize[10], Opacity[1], 
      {RGBColor[1, 0, 1], PointBox[{0, 0}]}, 
      {RGBColor[0, 1, 0], PointBox[{1, 1}]}}}, {0.5, 0.5}]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->938852315]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->881371952],

Cell["Transformation applied to a 3D shape:", "ExampleText",
 CellID->137131831],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cuboid", "[", "]"}], ",", 
     RowBox[{"AbsolutePointSize", "[", "10", "]"}], ",", 
     RowBox[{"Opacity", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367829949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Opacity", "[", ".35", "]"}], ",", "Blue", ",", "gr"}], "}"}], 
     ",", 
     RowBox[{"Translate", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", ".85", "]"}], ",", "Red", ",", "gr"}], "}"}],
        ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5", ",", ".5"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167437831],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[0, 0, 1], Opacity[0.35], CuboidBox[{0, 0, 0}], 
    {AbsolutePointSize[10], Opacity[1], 
     {RGBColor[1, 0, 1], Point3DBox[{0, 0, 0}]}, 
     {RGBColor[0, 1, 0], Point3DBox[{1, 1, 1}]}}}, 
   InterpretationBox[
    {RGBColor[1., 0., 0.], Opacity[0.85], 
     CuboidBox[{0.5, 0.5, 0.5}, {1.5, 1.5, 1.5}], 
     {AbsolutePointSize[10.], Opacity[1.], 
      {RGBColor[1., 0., 1.], Point3DBox[{0.5, 0.5, 0.5}]}, 
      {RGBColor[0., 1., 0.], Point3DBox[{1.5, 1.5, 1.5}]}}},
    Translate[{
      Opacity[0.85], 
      RGBColor[1, 0, 0], {
       Cuboid[{0, 0, 0}], 
       AbsolutePointSize[10], 
       Opacity[1], {
        RGBColor[1, 0, 1], 
        Point[{0, 0, 0}]}, {
        RGBColor[0, 1, 0], 
        Point[{1, 1, 1}]}}}, {0.5, 0.5, 0.5}]]},
  Boxed->False]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->709038499,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->502229663],

Cell["The transformations can be nested:", "ExampleText",
 CellID->91498056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sphere", "[", "]"}], ",", 
     RowBox[{"Translate", "[", 
      RowBox[{
       RowBox[{"Sphere", "[", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "]"}], ",", 
     RowBox[{"Translate", "[", 
      RowBox[{
       RowBox[{"Translate", "[", 
        RowBox[{
         RowBox[{"Sphere", "[", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "0", ",", "0"}], "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2", ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->739741198],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], 
   InterpretationBox[SphereBox[{2., 0., 0.}, 1.],
    Translate[
     Sphere[{0, 0, 0}], {2, 0, 0}]], 
   InterpretationBox[SphereBox[{2., 2., 0.}, 1.],
    Translate[
     Translate[
      Sphere[{0, 0, 0}], {2, 0, 0}], {0, 2, 0}]]},
  Boxed->False]], "Output",
 ImageSize->{184, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46547451,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12173152],

Cell[TextData[{
 "When possible, ",
 Cell[BoxData[
  ButtonBox["Normal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Normal"]], "InlineFormula"],
 " will transform the coordinates explicitly:"
}], "ExampleText",
 CellID->30475332],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Normal", "@", 
  RowBox[{"Translate", "[", 
   RowBox[{
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x0", ",", "y0", ",", "z0"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->274222939],

Cell[BoxData[
 RowBox[{"Point", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "+", "x0"}], ",", 
    RowBox[{"y", "+", "y0"}], ",", 
    RowBox[{"z", "+", "z0"}]}], "}"}], "]"}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19822280]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->220213805],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GeometricTransformation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeometricTransformation"]], "InlineFormula"],
 " is a generalization of ",
 Cell[BoxData[
  ButtonBox["Translate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Translate"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->580696592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Translate", "[", 
      RowBox[{
       RowBox[{"Circle", "[", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "3"}], "}"}]}], "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{
       RowBox[{"Circle", "[", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"IdentityMatrix", "[", "2", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "3"}], "}"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{
       RowBox[{"Circle", "[", "]"}], ",", 
       RowBox[{"TranslationTransform", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "3"}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317995040],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[GeometricTransformationBox[CircleBox[{0, 0}], {1, 3}],
    Axes->True], ",", 
   GraphicsBox[
    GeometricTransformationBox[CircleBox[{0, 0}], {{{1, 0}, {0, 1}}, {1, 3}}],
    
    Axes->True], ",", 
   GraphicsBox[
    GeometricTransformationBox[CircleBox[{0, 0}], {{{1, 0}, {0, 1}}, {1, 3}}],
    
    Axes->True]}], "}"}]], "Output",
 ImageSize->{491, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->125524678]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20297],

Cell["Rotating and translating a cylinder along a circle:", "ExampleText",
 CellID->7174054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Translate", "[", 
      RowBox[{
       RowBox[{"Rotate", "[", 
        RowBox[{
         RowBox[{"Cylinder", "[", "]"}], ",", "t", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "]"}], ",", 
       RowBox[{"12", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"Cos", "[", "t", "]"}], ",", 
          RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{
        RowBox[{"Pi", "/", "15"}], 
        RowBox[{"Range", "[", "30", "]"}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3162985],

Cell[BoxData[
 Graphics3DBox[{
   InterpretationBox[
    CylinderBox[{{0., 11.945682899623428`, 1.5167926890793062`}, {0., 
     11.529859517987909`, 3.4730878905469176`}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[1, 15] Pi, {1, 0, 0}], {
     0, 12 Cos[Rational[1, 15] Pi], 12 Sin[Rational[1, 15] Pi]}]], 
   InterpretationBox[
    CylinderBox[{{0., 11.36928213478701, 3.967294259267001}, {0., 
     10.555808848635412`, 5.794385174552203}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[2, 15] Pi, {1, 0, 0}], {
     0, 12 Cos[Rational[2, 15] Pi], 12 Sin[Rational[2, 15] Pi]}]], 
   InterpretationBox[
    CylinderBox[{{0., 10.295989184791843`, 6.24440603313473}, {0., 
     9.120418680206896, 7.862440021884625}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[1, 5] Pi, {1, 0, 0}], {
     0, 3 (1 + 5^Rational[1, 2]), 
      12 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2]}]], 
   InterpretationBox[
    CylinderBox[{{0., 8.772712101783693, 8.248607299369873}, {0., 
     7.286422450828905, 9.586868512087591}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[4, 15] Pi, {1, 0, 0}], {
     0, 12 Sin[Rational[7, 30] Pi], 12 Cos[Rational[7, 30] Pi]}]], 
   InterpretationBox[
    CylinderBox[{{0., 6.866025403784438, 9.892304845413264}, {0., 
     5.133974596215562, 10.892304845413264`}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[1, 3] Pi, {1, 0, 0}], {
     0, 6, 6 3^Rational[1, 2]}]], 
   InterpretationBox[
    CylinderBox[{{0., 4.659260448794523, 11.103661201166894`}, {0., 
     2.7571474162042158`, 11.72169518991679}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[2, 5] Pi, {1, 0, 0}], {
     0, 3 (-1 + 5^Rational[1, 2]), 
      12 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}]],
    
   InterpretationBox[
    CylinderBox[{{0., 2.248863454580115, 11.829734281151625`}, {0., 
     0.25981966384356814`, 12.038791207686932`}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[7, 15] Pi, {1, 0, 0}], {
     0, 12 Sin[Rational[1, 30] Pi], 12 Cos[Rational[1, 30] Pi]}]], 
   InterpretationBox[
    CylinderBox[{{0., -0.259819663843568, 12.038791207686932`}, {
     0., -2.248863454580115, 11.829734281151625`}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[8, 15] Pi, {1, 0, 0}], {
     0, (-12) Sin[Rational[1, 30] Pi], 12 Cos[Rational[1, 30] Pi]}]], 
   InterpretationBox[
    CylinderBox[{{0., -2.7571474162042158`, 11.721695189916788`}, {
     0., -4.659260448794523, 11.103661201166895`}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[3, 5] Pi, {1, 0, 0}], {
     0, 3 (1 - 5^Rational[1, 2]), 
      12 (Rational[5, 8] + Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}]],
    
   InterpretationBox[
    CylinderBox[{{0., -5.133974596215562, 10.892304845413264`}, {
     0., -6.866025403784438, 9.892304845413264}}, 0.9999999999999999],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[2, 3] Pi, {1, 0, 0}], {
     0, -6, 6 3^Rational[1, 2]}]], 
   InterpretationBox[
    CylinderBox[{{0., -7.286422450828905, 9.58686851208759}, {
     0., -8.772712101783693, 8.248607299369874}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[11, 15] Pi, {1, 0, 0}], {
     0, (-12) Sin[Rational[7, 30] Pi], 12 Cos[Rational[7, 30] Pi]}]], 
   InterpretationBox[
    CylinderBox[{{0., -9.120418680206896, 7.862440021884625}, {
     0., -10.295989184791843`, 6.24440603313473}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[4, 5] Pi, {1, 0, 0}], {
     0, 3 (-1 - 5^Rational[1, 2]), 
      12 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2]}]], 
   InterpretationBox[
    CylinderBox[{{0., -10.555808848635412`, 5.794385174552203}, {
     0., -11.36928213478701, 3.9672942592670006`}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[13, 15] Pi, {1, 0, 0}], {
     0, (-12) Cos[Rational[2, 15] Pi], 12 Sin[Rational[2, 15] Pi]}]], 
   InterpretationBox[
    CylinderBox[{{0., -11.529859517987909`, 3.4730878905469176`}, {
     0., -11.945682899623428`, 1.5167926890793062`}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[14, 15] Pi, {1, 0, 0}], {
     0, (-12) Cos[Rational[1, 15] Pi], 12 Sin[Rational[1, 15] Pi]}]], 
   InterpretationBox[CylinderBox[{{0., -12., 1.}, {0., -12., -1.}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Pi, {1, 0, 0}], {0, -12, 0}]], 
   InterpretationBox[
    CylinderBox[{{0., -11.945682899623428`, -1.5167926890793062`}, {
     0., -11.529859517987909`, -3.4730878905469176`}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[16, 15] Pi, {1, 0, 0}], {
     0, (-12) Cos[Rational[1, 15] Pi], (-12) Sin[Rational[1, 15] Pi]}]], 
   InterpretationBox[
    CylinderBox[{{0., -11.36928213478701, -3.9672942592670006`}, {
     0., -10.555808848635412`, -5.794385174552203}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[17, 15] Pi, {1, 0, 0}], {
     0, (-12) Cos[Rational[2, 15] Pi], (-12) Sin[Rational[2, 15] Pi]}]], 
   InterpretationBox[
    CylinderBox[{{0., -10.295989184791843`, -6.24440603313473}, {
     0., -9.120418680206896, -7.862440021884625}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[6, 5] Pi, {1, 0, 0}], {
     0, 3 (-1 - 5^
       Rational[1, 2]), (-12) (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}]], 
   InterpretationBox[
    CylinderBox[{{0., -8.772712101783693, -8.248607299369873}, {
     0., -7.286422450828905, -9.586868512087591}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[19, 15] Pi, {1, 0, 0}], {
     0, (-12) Sin[Rational[7, 30] Pi], (-12) Cos[Rational[7, 30] Pi]}]], 
   InterpretationBox[
    CylinderBox[{{0., -6.866025403784438, -9.892304845413264}, {
     0., -5.133974596215562, -10.892304845413264`}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[4, 3] Pi, {1, 0, 0}], {
     0, -6, (-6) 3^Rational[1, 2]}]], 
   InterpretationBox[
    CylinderBox[{{0., -4.659260448794523, -11.103661201166894`}, {
     0., -2.7571474162042158`, -11.72169518991679}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[7, 5] Pi, {1, 0, 0}], {
     0, 3 (1 - 5^
       Rational[1, 2]), (-12) (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}]], 
   InterpretationBox[
    CylinderBox[{{0., -2.248863454580115, -11.829734281151625`}, {
     0., -0.25981966384356814`, -12.038791207686932`}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[22, 15] Pi, {1, 0, 0}], {
     0, (-12) Sin[Rational[1, 30] Pi], (-12) Cos[Rational[1, 30] Pi]}]], 
   InterpretationBox[
    CylinderBox[{{0., 0.25981966384356814`, -12.038791207686932`}, {0., 
     2.248863454580115, -11.829734281151625`}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[23, 15] Pi, {1, 0, 0}], {
     0, 12 Sin[Rational[1, 30] Pi], (-12) Cos[Rational[1, 30] Pi]}]], 
   InterpretationBox[
    CylinderBox[{{0., 2.7571474162042158`, -11.721695189916788`}, {0., 
     4.659260448794523, -11.103661201166895`}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[8, 5] Pi, {1, 0, 0}], {
     0, 3 (-1 + 5^Rational[1, 2]), (-12) (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}]], 
   InterpretationBox[
    CylinderBox[{{0., 5.133974596215562, -10.892304845413264`}, {0., 
     6.866025403784438, -9.892304845413264}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[5, 3] Pi, {1, 0, 0}], {
     0, 6, (-6) 3^Rational[1, 2]}]], 
   InterpretationBox[
    CylinderBox[{{0., 7.286422450828905, -9.586868512087591}, {0., 
     8.772712101783693, -8.248607299369873}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[26, 15] Pi, {1, 0, 0}], {
     0, 12 Sin[Rational[7, 30] Pi], (-12) Cos[Rational[7, 30] Pi]}]], 
   InterpretationBox[
    CylinderBox[{{0., 9.120418680206896, -7.862440021884625}, {0., 
     10.295989184791843`, -6.24440603313473}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[9, 5] Pi, {1, 0, 0}], {
     0, 3 (1 + 5^Rational[1, 2]), (-12) (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2]}]], 
   InterpretationBox[
    CylinderBox[{{0., 10.555808848635412`, -5.794385174552203}, {0., 
     11.36928213478701, -3.9672942592670006`}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[28, 15] Pi, {1, 0, 0}], {
     0, 12 Cos[Rational[2, 15] Pi], (-12) Sin[Rational[2, 15] Pi]}]], 
   InterpretationBox[
    CylinderBox[{{0., 11.529859517987909`, -3.4730878905469176`}, {0., 
     11.945682899623428`, -1.5167926890793062`}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], Rational[29, 15] Pi, {1, 0, 0}], {
     0, 12 Cos[Rational[1, 15] Pi], (-12) Sin[Rational[1, 15] Pi]}]], 
   InterpretationBox[CylinderBox[{{0., 12., -1.}, {0., 12., 1.}}, 1.],
    Translate[
     Rotate[
      Cylinder[{{0, 0, -1}, {0, 0, 1}}], 2 Pi, {1, 0, 0}], {0, 12, 0}]]},
  Boxed->False]], "Output",
 ImageSize->{101, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->599188537,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21564],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rotate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rotate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Scale",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scale"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TranslationTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TranslationTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AffineTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AffineTransform"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10504]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Translate",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Translate"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->518331727],

Cell[TextData[ButtonBox["Geometric Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeometricTransforms"]], "MoreAbout",
 CellID->402798367],

Cell[TextData[ButtonBox["Graphics Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsTransformations"]], "MoreAbout",
 CellID->235231031],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->155771739],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->783399143]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Translate - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 37.2713546}", "context" -> "System`", 
    "keywords" -> {
     "geometric transforms", "graphics transformations", 
      "isometric transform", "move", "rigid motion", "translate graphics", 
      "translation matrix", "translation transform"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Translate[g, {x, y, ...}] represents graphics primitives g translated by \
the vector {x, y, ...}. ", "synonyms" -> {}, "title" -> "Translate", "type" -> 
    "Symbol", "uri" -> "ref/Translate"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7838, 244, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->35210025]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 113456, 2384}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2140, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2763, 74, 1574, 37, 70, "ObjectNameGrid"],
Cell[4340, 113, 966, 31, 70, "Usage",
 CellID->2662]
}, Open  ]],
Cell[CellGroupData[{
Cell[5343, 149, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5821, 166, 705, 25, 70, "Notes",
 CellID->27996],
Cell[6529, 193, 551, 19, 70, "Notes",
 CellID->28213],
Cell[7083, 214, 718, 25, 70, "Notes",
 CellID->9451]
}, Closed]],
Cell[CellGroupData[{
Cell[7838, 244, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->35210025],
Cell[CellGroupData[{
Cell[8222, 258, 147, 5, 70, "ExampleSection",
 CellID->21443249],
Cell[8372, 265, 82, 1, 70, "ExampleText",
 CellID->191385360],
Cell[CellGroupData[{
Cell[8479, 270, 308, 10, 28, "Input",
 CellID->19486452],
Cell[8790, 282, 239, 7, 184, "Output",
 CellID->153951682]
}, Open  ]],
Cell[9044, 292, 124, 3, 70, "ExampleDelimiter",
 CellID->76243112],
Cell[9171, 297, 78, 1, 70, "ExampleText",
 CellID->118021406],
Cell[CellGroupData[{
Cell[9274, 302, 321, 10, 70, "Input",
 CellID->655917439],
Cell[9598, 314, 33781, 561, 227, 154, 5, "CachedBoxData", "BoxData", "Output",
 
 CellID->128721569]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43428, 881, 219, 7, 70, "ExampleSection",
 CellID->61910161],
Cell[43650, 890, 80, 1, 70, "ExampleText",
 CellID->479507293],
Cell[43733, 893, 620, 20, 70, "Input",
 CellID->419323043],
Cell[CellGroupData[{
Cell[44378, 917, 499, 17, 70, "Input",
 CellID->150504143],
Cell[44880, 936, 604, 14, 201, "Output",
 CellID->938852315]
}, Open  ]],
Cell[45499, 953, 125, 3, 70, "ExampleDelimiter",
 CellID->881371952],
Cell[45627, 958, 80, 1, 70, "ExampleText",
 CellID->137131831],
Cell[45710, 961, 637, 20, 70, "Input",
 CellID->367829949],
Cell[CellGroupData[{
Cell[46372, 985, 587, 19, 70, "Input",
 CellID->167437831],
Cell[46962, 1006, 5021, 95, 216, 821, 22, "CachedBoxData", "BoxData", \
"Output",
 CellID->709038499]
}, Open  ]],
Cell[51998, 1104, 125, 3, 70, "ExampleDelimiter",
 CellID->502229663],
Cell[52126, 1109, 76, 1, 70, "ExampleText",
 CellID->91498056],
Cell[CellGroupData[{
Cell[52227, 1114, 732, 22, 70, "Input",
 CellID->739741198],
Cell[52962, 1138, 30004, 500, 176, 315, 9, "CachedBoxData", "BoxData", \
"Output",
 CellID->46547451]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[83015, 1644, 236, 7, 70, "ExampleSection",
 CellID->12173152],
Cell[83254, 1653, 235, 8, 70, "ExampleText",
 CellID->30475332],
Cell[CellGroupData[{
Cell[83514, 1665, 318, 10, 70, "Input",
 CellID->274222939],
Cell[83835, 1677, 324, 11, 36, "Output",
 CellID->19822280]
}, Open  ]],
Cell[84174, 1691, 125, 3, 70, "ExampleDelimiter",
 CellID->220213805],
Cell[84302, 1696, 359, 12, 70, "ExampleText",
 CellID->580696592],
Cell[CellGroupData[{
Cell[84686, 1712, 1081, 32, 70, "Input",
 CellID->317995040],
Cell[85770, 1746, 576, 18, 172, "Output",
 CellID->125524678]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[86395, 1770, 224, 7, 70, "ExampleSection",
 CellID->20297],
Cell[86622, 1779, 92, 1, 70, "ExampleText",
 CellID->7174054],
Cell[CellGroupData[{
Cell[86739, 1784, 789, 24, 70, "Input",
 CellID->3162985],
Cell[87531, 1810, 21358, 417, 237, 9626, 220, "CachedBoxData", "BoxData", \
"Output",
 CellID->599188537]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[108950, 2234, 311, 9, 70, "SeeAlsoSection",
 CellID->21564],
Cell[109264, 2245, 1210, 44, 70, "SeeAlso",
 CellID->10504]
}, Open  ]],
Cell[CellGroupData[{
Cell[110511, 2294, 305, 8, 70, "RelatedLinksSection"],
Cell[110819, 2304, 363, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[111219, 2321, 319, 9, 70, "MoreAboutSection",
 CellID->518331727],
Cell[111541, 2332, 151, 3, 70, "MoreAbout",
 CellID->402798367],
Cell[111695, 2337, 159, 3, 70, "MoreAbout",
 CellID->235231031],
Cell[111857, 2342, 162, 3, 70, "MoreAbout",
 CellID->155771739],
Cell[112022, 2347, 179, 3, 70, "MoreAbout",
 CellID->783399143]
}, Open  ]],
Cell[112216, 2353, 27, 0, 70, "History"],
Cell[112246, 2355, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

