(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38912,       1210]
NotebookOptionsPosition[     33086,       1009]
NotebookOutlinePosition[     34569,       1049]
CellTagsIndexPosition[     34483,       1044]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vectors and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/VectorsAndMatrices"], 
          "Rearranging Nested Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/RearrangingNestedLists"], 
          "Nested Lists" :> 
          Documentation`HelpLookup["paclet:tutorial/NestedLists"], 
          "Getting and Setting Pieces of Matrices" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GettingAndSettingPiecesOfMatrices"], 
          "Basic Matrix Operations" :> 
          Documentation`HelpLookup["paclet:tutorial/BasicMatrixOperations"], 
          "Tensors" :> 
          Documentation`HelpLookup["paclet:tutorial/Tensors"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Vectors and Matrices\"\>", 
       2->"\<\"Rearranging Nested Lists\"\>", 3->"\<\"Nested Lists\"\>", 
       4->"\<\"Getting and Setting Pieces of Matrices\"\>", 
       5->"\<\"Basic Matrix Operations\"\>", 
       6->"\<\"Tensors\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Flatten" :> Documentation`HelpLookup["paclet:ref/Flatten"], 
          "Thread" :> Documentation`HelpLookup["paclet:ref/Thread"], 
          "ConjugateTranspose" :> 
          Documentation`HelpLookup["paclet:ref/ConjugateTranspose"], "Tr" :> 
          Documentation`HelpLookup["paclet:ref/Tr"], "Reverse" :> 
          Documentation`HelpLookup["paclet:ref/Reverse"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Flatten\"\>", 2->"\<\"Thread\"\>", 
       3->"\<\"ConjugateTranspose\"\>", 4->"\<\"Tr\"\>", 
       5->"\<\"Reverse\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Handling Arrays of Data" :> 
          Documentation`HelpLookup["paclet:guide/HandlingArraysOfData"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Matrix Operations" :> 
          Documentation`HelpLookup["paclet:guide/MatrixOperations"], 
          "Parts of Matrices" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfMatrices"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"], 
          "Structural Operations on Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/StructuralOperationsOnExpressions"], "Tensors" :> 
          Documentation`HelpLookup["paclet:guide/Tensors"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Handling Arrays of Data\"\>", 
       2->"\<\"List Manipulation\"\>", 
       3->"\<\"Matrices and Linear Algebra\"\>", 
       4->"\<\"Matrix Operations\"\>", 5->"\<\"Parts of Matrices\"\>", 
       6->"\<\"Rearranging & Restructuring Lists\"\>", 
       7->"\<\"Structural Operations on Expressions\"\>", 
       8->"\<\"Tensors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Transpose", "ObjectName",
 CellID->7491],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Transpose",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Transpose"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]transposes the first two levels in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Transpose",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Transpose"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]transposes ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " so that the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " level in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " is the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " level in the result. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->17252]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 " gives the usual transpose of a matrix. "
}], "Notes",
 CellID->5726],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Transpose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Transpose"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " can be input as ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["m", "TI"], "\[Transpose]"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26269],

Cell[TextData[{
 Cell[BoxData["\[Transpose]"], "InlineFormula"],
 " can be entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["tr", "InlineCode"],
 StyleBox["\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[Transpose]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Transpose"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->5134],

Cell[TextData[{
 "Acting on a tensor ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["T", "TI"], 
    RowBox[{
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["1", "TR"]], 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["2", "TR"]], 
     SubscriptBox[
      StyleBox["i", "TI"], 
      StyleBox["3", "TR"]], 
     StyleBox["\[Ellipsis]", "TR"]}]], "Transpose"}]], "InlineFormula"],
 " gives the tensor ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["T", "TI"], 
   RowBox[{
    SubscriptBox[
     StyleBox["i", "TI"], 
     StyleBox["2", "TR"]], 
    SubscriptBox[
     StyleBox["i", "TI"], 
     StyleBox["1", "TR"]], 
    SubscriptBox[
     StyleBox["i", "TI"], 
     StyleBox["3", "TR"]], 
    StyleBox["\[Ellipsis]", "TR"]}]]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->15323232,
  ButtonNote->"15323232"]
}], "Notes",
 CellID->863],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Transpose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Transpose"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " gives the tensor ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["T", "TI"], 
   RowBox[{
    SubscriptBox[
     StyleBox["i", "TI"], 
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["1", "TR"]]], 
    SubscriptBox[
     StyleBox["i", "TI"], 
     SubscriptBox[
      StyleBox["n", "TI"], 
      StyleBox["2", "TR"]]], 
    StyleBox["\[Ellipsis]", "TR"]}]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6130],

Cell[TextData[{
 "So long as the lengths of the lists at particular levels are the same, the \
specifications ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " do not necessarily have to be distinct. "
}], "Notes",
 CellID->5721],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Transpose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Transpose"]], "InlineFormula"],
 " works on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->11049]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->145082146],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->95086426],

Cell["Transpose a 2\[Times]3 matrix:", "ExampleText",
 CellID->182573073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142059282],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "z"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->246933970]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31680],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->362653286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->379716019],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVTsOwjAMNY0DLZ+BjwRIDMwM7FwAJg5RISQYEAi4f3FSF4oxIpVgI1Ls
PNt5deIkXafX3faQXvebdLo6p6fdfnOZLo9nMpkaACyoT0ZA44xGvi+yjPSY
JDqnR9ZJ47y+QV/ggcDoZ6GwRiQigoVuC3+ThCVYF3ajsnkrPjBAh3lbDtq7
J3cGsiJzdEp2UHJtqGxGWG2Z7SnXT3yRyocvPPpamy9xcRC/ERVKSDs3F5Rb
wnUKy3n+j/pBlOUaxKzbXKmwOvty6qcm0FrhvFb5TmluErwP+GXO91kXd6Mc
HVfYH+21McUtxsdrk9cTg1+tnsDDoFldXtFYjZZv/kzbJcj/FlC7AVUgUtM=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->266034680]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Transpose", "[", "m", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29632385],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a", "x"},
     {"b", "y"},
     {"c", "z"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{46, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->660997828]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->547535867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"Array", "[", 
   RowBox[{"a", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->165208725],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWdtu2zAMdaxkyS7Nkg0Y+tj9zPa0jwiKAe1DsaHr/3eWU6fuKS2SEiW7
gQs4DQWK5KEpRtL5dXi4+X13eLi9Plz9vD/8vbm9/nf14899M+QWVVU3T/X9
smq+Pzbf2qf7c83zLB6lj/7TnbSqJcgfmo+6eq33mZC93grGd4nzMR60Uyq+
3cB8Kl8l4ttF5g/lYxVg1NKsd9HtCavUODePio5CnyueL8J4MF/W8eyF+eHk
WvR2fTSrRnTEbD+O+u+U4yivC/tD+f2Z4F8L/aG8ScTv/Tqi1+TCv0n0Z7NK
Wq3VSW7nvPY9rOXXM1ZeaJzSW2eMQWZ7KDLMnkW2hiMqnbNwJJukzCGO88rc
cG7Sao5fzxxKJ/KNPYrad4W8XJh42YKMnRBl1I/DSu2B7bFyXjisFyZYceeH
Vm2wfgX5kxIrV/mLNg7Jfm8pWGfUGSWkv81kF2WskKnh4dYJN1+KB08HXM1K
8WjXwpj7La7z2fRnzgtVkZoKjsOK2DAqG6xcdXNYcX78e+1O1HkwDp3T81e6
9+JF6nwTWoeS/hVjF7NQM36oipD4xfgl/SvGLrnalP14TDzcnpPDY1OleMdF
r2Ptb+y3KKuyVc7VqQwR7csGF217G4UOIxofHY0j7t3JaljKZvhx94Szf0+7
evp/GdBz1fP5FVcu7pwof317IX9O4G/o/ljrbwf6Q/64t0AxTDkkbXXMLNZL
vfNksbS7tZnVemlnqqxWZ3cZ9ZbfKrszs1szu2XHbmlXjeyUTsnleC6t9zEY
Lj3CcnmaHqs15WyVYrLqrneoz/Uy5oM7N9rcmHJeyjBa1I1LaP9pg5XzkofR
QlnLDsRhxb1lKqPVrrKoPd6UGKCZ0YrD81YYrfYXp9Ceapz+XIbR4qzYMFqc
lzKMFmXFjtGiMFowWnGVPsSYWPSvGLu5GC2L/hVjNxejVQoP9uNURiuuSjm2
IJXL4uzlYbFk/SMVS0nmqgyinGzVsT61s/psTv/eNcRWoZ7rjWvYqv78EHvU
10thqzT+9o9xbFV7g3N6kVrOqVr8B66qvbc=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{513, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->597539860]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", 
  RowBox[{"m", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167162347],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWVtP6zAMzpbtbMCBrSBxeYM/w3k6P2JCSPCAQMA/h3douhUVz4kvcTqQ
irRRp45viT0n3//V693tw+r1/mZ1+e959XR3f/Nyef34XA/5kXOjN+fc1bmr
nz/qp+YT/t7rz/px/XQQvn379sNNAL1ff43dNt8CoQPfFIwvM+dXmfMxfzT+
LSPyc/2LzV8q/YO0D19bXkMuqL2NSmtdhUjFxrnzjoXzMK8CH/SL8gPqzfUj
Nq+KvKdWC9Jj1uoFa6Y16ZHZYRzy/xGOQ3rWs765UF+wzyO5wtWH6S8R71lk
fNfxluqbG8dblwUN1/SLbuZs645zhXzdQ3TExjG+mYENcRkSS+Y/whJOLEuu
Gy8K/a0eT4OlPfEIyOyR5yu1PzxLN6xBWF+U0nKo0oJ1fyktRyotsBs5JLTA
+gr5y0QU1Zod0TJaTgD9l9Ai7aZHjR2cfmzCyCMqJtguKyF3wZQLu1lqv1J2
aePEycZdxl+a17vsh2AGHAljwstTqAVKhVp19RXzpT3F5exTm0hiZ0j7SGI5
ZqMldg4uv5ODlkBi54tUnnHymSMXyqHyeVFILqeeauIE69XYKE5oHinkUh0K
lFtmF8K7JbwqSH9TTllS8aylZJ8VlE3tRV20eHU+J2a8+sfTgFvL06Dbo9zb
+jDuN/Ht3mNON//PEb4uf8t3weTDbu05dlUbesKwK8W3jPDpbsvDI8RJ5E/S
FR6Qlu9+/E6kRdoRDciLrf9a5KWVO1Gt4oDAbNsX6+wGBOa3IjDSrOCdmzG6
PyxGPtsehSlnAyd+ZVapBPKii1MJzEW+3rZoy7itDeKzLw8joE53NreC6C1f
ojPT3QpCWnqLbYO6SCOqw0OoiJbRAnu7XNSlySJVDzagLgPqoo0TpJtftp56
nn7qK1xBG9QF86U/1IWSYoO6UJG0QV0wLRaoi24nx9AEi3zmyJXWvRjq0kc9
1cRJi7pQ/mhRF6qe5qIuul1I3Xjn4i28yipFWmykUr5KY6NDV3i+6HAV3i+O
DaKy3n/SWV3konsvmUJU2vfepRGVFJ8EUYH3pb4znrIrxVdF+Fi3/g3BwUjc
6BMOli9a\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{499, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->373670750]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", 
  RowBox[{"m", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->110937748],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWm1PGzEMvjYt7djoCpMmPsKf2T7tR1RoEnxAmxj/n91dSSlPnfNLnLtS
HdKVOnJsP44TfHn4tXm+//24eX6429z8fNr8vX+4+3fz489TPRQmVTWtn+r2
uqq/v9Tf2if+hPp5E7fS5+Yz7LSqGcjn9ce0OtT7SsiN3hzG15nzMR6001d8
68R8Kl99xLc25g/lbRVg1NKsx+guCavUODePio5CXyqeK2E8mC/veC6F+eHk
qWh1m2jmtRiI2c046p8px1Fe9OwP5U8ngn8h9IfyMhN/4zcQZ00p/MtMfz67
pNWa7+R2jsx3s5Ox5uL4QmxVrp2O1CcSajZmLy9b6ViGyVl3PMssrLgep5W5
dG7yao7fz1SdH3Q+at/Yt61AxjPqQuQFT0Ls7jgvKKO+DStaQew+WKlOW4P1
wgUrdlpfimD9pvSi7eYnbRySfm9mqHWUqXopYRdlrJBjw4PxaedL8WDN4k6w
4sG3IM7uMfVb3FrgjpTtY+585bxwFWzDSt0B+GPVZpRbEfu6pt6kfTBKrJd7
/25E7rTHTGK0U5BXCbtnVM4UdiXnsQQP+iErxYCHq1gOD7WPhsTD7XMOj0+V
cjfFGJVsJ36nYjmYZbPN1SmHiPbiiYu2tTKhwxwNj47GYVs7WQ1L2Yz4/rne
+x32xq/39MJr/VF6uHOxc6L8RXucvyDwl7o/1vpL6dnYhLiu5SRtdYws1nu9
02SxtN3ayGq9t3OsrFa0OzOt8kdld0Z2a2S3/Ngt7a4pw3Zxd/JRryTPJYmB
mtcnw9Vnnroj4d4KpRVwKtnq5rMstUVFuu1ntO/1PowWdyvuw2hxXvphtLib
eh9Gi+t3+mG0uFt8H0aL88J19u3+MvV4x8QAjYyWDc9HYbTac76nnqrM+cyd
r7kV7MNoYVQ+WHN3qy+j5fM3KMVoaXeuT6VbGS3J+UXZ5Rgtj/NYgsdyfknw
cP91ZDmPh8SD+R3mPNYyWlwV2bis3Nq08Tw+WGjbud3CkIhozkq7RnR9amd1
sVXxlpxjq/b1ctgqzl8Q+NOwVV3+UnoiVmO3sFrOqZr8B66Svbc=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{513, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->225771129]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Transpose", "[", 
  RowBox[{"m", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->90879558],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztms1S2zAQx5U4aYBCMBwYjjxDH6I99Q3KIcN0Bg4MDPD+wbKrjvl35ZVW
K+GCMpPE60j7pZUl/SY/dy+3v+93L3c3u6sfT7vH27ub56vvD0/drWZhzOKX
Mebbpemu991V/7av6+49XA5XX+1n437dmxXIR93H0vzb7pSQbbs13G8T+6M/
qKeUf62nP/qHctNn+UgYlbN6Rmil7nP9KO+o6HP5cx6ZPZSXQdm03qw7sSF6
2/vYftN9NMTYfvG0p/qXtIfy4QeJfxNoT6dK+lbrv3LfJ8y2reSNt7f9FUck
Xku6D2m6MXth2fK3Kp2zFE8OxJnjq5KLshHZxufuCdP+RMXKMcg4n1HeimLF
pwquITqxxlrhYuVyudiHPKOsV6sM47/NpBfldubxYEXOeeVxO1jMqc7cdtqp
nV3MCIfFRj0Z9GLzacc5zcWmtxuldjsaNS/RiyebJdOfmsO+3eKUHWk8nF6y
ArOPKndupisVfcdeFyKtshmPecOI6JmsE1eM7q0ourBRDqUfbmdoc9b8idfR
APt9OdGuGd3H2sYn0tjeuP+UvXG7lrEXRivsJXKi+KtKlipZmi9ZcnpXQVmM
JSo+cpKLqKTa0yZKc4m/EiVNHypRen+itHSzIhNJwhNxntMmWsE1sQxJ4k4S
OiSJsxJLkvpaUiNH1G6GG7kcerXIUal4uFoJWmEzrSjoG0e5dM6PmKEy5Ait
6sTKWaGqU3/0KzlKiyc3OQobxUqKUuIqT4qGUf3sZKiv6l5IJ0GxI1DJ0Nt2
MjIUuyZVUjTt30qU1f+VnFRypEmOYqsmjSRRZKAcQ/JZnx89KpMnmQ85iFHs
/lZGkGJP4PL/K+AZYCyXIUjcGViHIHFWZARJspLNicBUovRWHs4tZVaa95nj
sdRF779J+rFyVmL/h6VTDaHESTInJHoxC7mIExImaTycXjx7yIhT6skudTQ5
9kTyu0LUKTWWMK2apElKR9zeroXvKfI0JlA+EhRCnjh743ZnjD0qvkEIYUtm
8QqFJZQz\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{348, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->99474900]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20037],

Cell[TextData[{
 "Enter using ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]tr\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ":"
}], "ExampleText",
 CellID->18569],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "}"}], "\[Transpose]"]], "Input",
 CellLabel->"In[1]:=",
 CellID->2807],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23535]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MatrixForm", "[", 
    RowBox[{"Transpose", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"x", ",", "x", ",", "x", ",", "x"}], "}"}], "}"}], "}"}], 
       "}"}], ",", "#"}], "]"}], "]"}], "&"}], "/@", 
  RowBox[{"Permutations", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199759087],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{502, 309},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->212016953]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1215],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Flatten",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Flatten"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Thread",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thread"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ConjugateTranspose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ConjugateTranspose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tr",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tr"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reverse"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28599]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15017],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "Tutorials",
 CellID->15665],

Cell[TextData[ButtonBox["Rearranging Nested Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RearrangingNestedLists"]], "Tutorials",
 CellID->17011],

Cell[TextData[ButtonBox["Nested Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NestedLists"]], "Tutorials",
 CellID->27725],

Cell[TextData[ButtonBox["Getting and Setting Pieces of Matrices",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/GettingAndSettingPiecesOfMatrices"]], "Tutorials",
 CellID->24908],

Cell[TextData[ButtonBox["Basic Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicMatrixOperations"]], "Tutorials",
 CellID->3162],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Tensors"]], "Tutorials",
 CellID->493403696]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->462448852],

Cell[TextData[ButtonBox["Handling Arrays of Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HandlingArraysOfData"]], "MoreAbout",
 CellID->269915799],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->293642276],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->118122521],

Cell[TextData[ButtonBox["Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixOperations"]], "MoreAbout",
 CellID->15381911],

Cell[TextData[ButtonBox["Parts of Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfMatrices"]], "MoreAbout",
 CellID->542373532],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->168704001],

Cell[TextData[ButtonBox["Structural Operations on Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StructuralOperationsOnExpressions"]], "MoreAbout",
 CellID->16567764],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Tensors"]], "MoreAbout",
 CellID->4790429]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Transpose"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Transpose - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 38.6307644}", "context" -> "System`", 
    "keywords" -> {
     "collapse", "contraction", "levels", "matrix transpose", 
      "permutation of indices", "tensors", "transpose of matrices", 
      "transposition of lists"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Transpose[list] transposes the first two levels in list. Transpose[list, \
{n_1, n_2, ...}] transposes list so that the k\\[Null]^th level in list is \
the n_k\\[Null]^th level in the result. ", "synonyms" -> {}, "title" -> 
    "Transpose", "type" -> "Symbol", "uri" -> "ref/Transpose"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10410, 339, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->145082146]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34339, 1037}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4025, 85, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4648, 112, 46, 1, 70, "ObjectName",
 CellID->7491],
Cell[4697, 115, 1736, 57, 70, "Usage",
 CellID->17252]
}, Open  ]],
Cell[CellGroupData[{
Cell[6470, 177, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6948, 194, 208, 7, 70, "Notes",
 CellID->5726],
Cell[7159, 203, 337, 13, 70, "Notes",
 CellID->26269],
Cell[7499, 218, 441, 14, 70, "Notes",
 CellID->5134],
Cell[7943, 234, 934, 38, 70, "Notes",
 CellID->863],
Cell[8880, 274, 883, 35, 70, "Notes",
 CellID->6130],
Cell[9766, 311, 285, 9, 70, "Notes",
 CellID->5721],
Cell[10054, 322, 319, 12, 70, "Notes",
 CellID->11049]
}, Closed]],
Cell[CellGroupData[{
Cell[10410, 339, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->145082146],
Cell[CellGroupData[{
Cell[10795, 353, 147, 5, 70, "ExampleSection",
 CellID->95086426],
Cell[10945, 360, 73, 1, 70, "ExampleText",
 CellID->182573073],
Cell[CellGroupData[{
Cell[11043, 365, 274, 9, 28, "Input",
 CellID->142059282],
Cell[11320, 376, 361, 13, 36, "Output",
 CellID->246933970]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11730, 395, 216, 7, 70, "ExampleSection",
 CellID->31680],
Cell[11949, 404, 285, 10, 70, "Input",
 CellID->362653286],
Cell[CellGroupData[{
Cell[12259, 418, 106, 3, 70, "Input",
 CellID->379716019],
Cell[12368, 423, 589, 14, 70, "Output",
 Evaluatable->False,
 CellID->266034680]
}, Open  ]],
Cell[CellGroupData[{
Cell[12994, 442, 137, 4, 70, "Input",
 CellID->29632385],
Cell[13134, 448, 742, 23, 78, "Output",
 CellID->660997828]
}, Open  ]],
Cell[13891, 474, 125, 3, 70, "ExampleDelimiter",
 CellID->547535867],
Cell[CellGroupData[{
Cell[14041, 481, 209, 7, 70, "Input",
 CellID->165208725],
Cell[14253, 490, 1285, 25, 70, "Output",
 Evaluatable->False,
 CellID->597539860]
}, Open  ]],
Cell[CellGroupData[{
Cell[15575, 520, 187, 6, 70, "Input",
 CellID->167162347],
Cell[15765, 528, 1318, 26, 70, "Output",
 Evaluatable->False,
 CellID->373670750]
}, Open  ]],
Cell[CellGroupData[{
Cell[17120, 559, 187, 6, 70, "Input",
 CellID->110937748],
Cell[17310, 567, 1301, 25, 70, "Output",
 Evaluatable->False,
 CellID->225771129]
}, Open  ]],
Cell[CellGroupData[{
Cell[18648, 597, 186, 6, 70, "Input",
 CellID->90879558],
Cell[18837, 605, 1256, 25, 70, "Output",
 Evaluatable->False,
 CellID->99474900]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20142, 636, 239, 7, 70, "ExampleSection",
 CellID->20037],
Cell[20384, 645, 187, 7, 70, "ExampleText",
 CellID->18569],
Cell[CellGroupData[{
Cell[20596, 656, 248, 9, 70, "Input",
 CellID->2807],
Cell[20847, 667, 298, 11, 36, "Output",
 CellID->23535]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21194, 684, 223, 7, 70, "ExampleSection",
 CellID->2594],
Cell[CellGroupData[{
Cell[21442, 695, 494, 16, 70, "Input",
 CellID->199759087],
Cell[21939, 713, 5869, 100, 70, "Output",
 Evaluatable->False,
 CellID->212016953]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27869, 820, 310, 9, 70, "SeeAlsoSection",
 CellID->1215],
Cell[28182, 831, 1186, 44, 70, "SeeAlso",
 CellID->28599]
}, Open  ]],
Cell[CellGroupData[{
Cell[29405, 880, 314, 9, 70, "TutorialsSection",
 CellID->15017],
Cell[29722, 891, 149, 3, 70, "Tutorials",
 CellID->15665],
Cell[29874, 896, 157, 3, 70, "Tutorials",
 CellID->17011],
Cell[30034, 901, 134, 3, 70, "Tutorials",
 CellID->27725],
Cell[30171, 906, 185, 4, 70, "Tutorials",
 CellID->24908],
Cell[30359, 912, 154, 3, 70, "Tutorials",
 CellID->3162],
Cell[30516, 917, 129, 3, 70, "Tutorials",
 CellID->493403696]
}, Open  ]],
Cell[CellGroupData[{
Cell[30682, 925, 319, 9, 70, "MoreAboutSection",
 CellID->462448852],
Cell[31004, 936, 155, 3, 70, "MoreAbout",
 CellID->269915799],
Cell[31162, 941, 145, 3, 70, "MoreAbout",
 CellID->293642276],
Cell[31310, 946, 163, 3, 70, "MoreAbout",
 CellID->118122521],
Cell[31476, 951, 144, 3, 70, "MoreAbout",
 CellID->15381911],
Cell[31623, 956, 144, 3, 70, "MoreAbout",
 CellID->542373532],
Cell[31770, 961, 177, 3, 70, "MoreAbout",
 CellID->168704001],
Cell[31950, 966, 180, 3, 70, "MoreAbout",
 CellID->16567764],
Cell[32133, 971, 124, 3, 70, "MoreAbout",
 CellID->4790429]
}, Open  ]],
Cell[CellGroupData[{
Cell[32294, 979, 305, 8, 70, "RelatedLinksSection"],
Cell[32602, 989, 387, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[33004, 1005, 52, 0, 70, "History"],
Cell[33059, 1007, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

