(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    686513,      17646]
NotebookOptionsPosition[    661981,      16816]
NotebookOutlinePosition[    663947,      16868]
CellTagsIndexPosition[    663832,      16862]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Graph Drawing in Mathematica " :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphDrawingIntroduction"], "Tree Drawing" :> 
          Documentation`HelpLookup["paclet:tutorial/TreeDrawing"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Introduction to Graph Drawing in Mathematica \"\>", 
       2->"\<\"Tree Drawing\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LayeredGraphPlot" :> 
          Documentation`HelpLookup["paclet:ref/LayeredGraphPlot"], 
          "GraphPlot" :> Documentation`HelpLookup["paclet:ref/GraphPlot"], 
          "TreeForm" :> Documentation`HelpLookup["paclet:ref/TreeForm"], 
          "Level" :> Documentation`HelpLookup["paclet:ref/Level"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LayeredGraphPlot\"\>", 
       2->"\<\"GraphPlot\"\>", 3->"\<\"TreeForm\"\>", 
       4->"\<\"Level\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Systems" :> 
          Documentation`HelpLookup[
           "paclet:guide/ComputationalSystemsAndDiscovery"], 
          "Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "New in 6.0: Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60DataVisualization"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Computational Systems\"\>", 
       2->"\<\"Data Visualization\"\>", 3->"\<\"Discrete Mathematics\"\>", 
       4->"\<\"New in 6.0: Data Visualization\"\>", 
       5->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       6->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["TreePlot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TreePlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TreePlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           RowBox[{
            StyleBox["i", "TI"], "\[InvisibleSpace]", 
            StyleBox["1", "TR"]}]], "->", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           RowBox[{
            StyleBox["j", "TI"], "\[InvisibleSpace]", 
            StyleBox["1", "TR"]}]]}], ",", 
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           RowBox[{
            StyleBox["i", "TI"], "\[InvisibleSpace]", 
            StyleBox["2", "TR"]}]], "->", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           RowBox[{
            StyleBox["j", "TI"], "\[InvisibleSpace]", 
            StyleBox["2", "TR"]}]]}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a tree plot of the graph in which vertex ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["ik", "TI"]]], "InlineFormula"],
     " is connected to vertex ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["jk", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TreePlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TreePlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            SubscriptBox[
             StyleBox["v", "TI"], 
             RowBox[{
              StyleBox["i", "TI"], "\[InvisibleSpace]", 
              StyleBox["1", "TR"]}]], "->", 
            SubscriptBox[
             StyleBox["v", "TI"], 
             RowBox[{
              StyleBox["j", "TI"], "\[InvisibleSpace]", 
              StyleBox["1", "TR"]}]]}], ",", 
           SubscriptBox[
            StyleBox["lbl", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]associates labels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " with edges in the graph."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TreePlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TreePlot"], "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["pos", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]places roots of trees in the plot at position ",
     Cell[BoxData[
      StyleBox["pos", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TreePlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TreePlot"], "[", 
       RowBox[{
        StyleBox["g", "TI"], ",", 
        StyleBox["pos", "TI"], ",", 
        SubscriptBox[
         StyleBox["v", "TI"], 
         StyleBox["k", "TI"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses vertex ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["k", "TI"]]], "InlineFormula"],
     " as the root node in the tree plot."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->18997]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["TreePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TreePlot"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " lays out the vertices of ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " in a tree of successive layers, or a collection of trees."
}], "Notes",
 CellID->362328099],

Cell[TextData[{
 "If the graph ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 " is not a tree, ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 " lays out its vertices on the basis of a spanning tree of each component of \
the graph. "
}], "Notes",
 CellID->184029240],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["TreePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TreePlot"], "[", 
   StyleBox["g", "TI"], "]"}]], "InlineFormula"],
 " attempts to choose the root so as to make trees have as few layers as \
possible."
}], "Notes",
 CellID->229489000],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 " places each tree root at the top. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TreePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TreePlot"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", 
    StyleBox["pos", "TI"]}], "]"}]], "InlineFormula"],
 " places the roots at position ",
 Cell[BoxData[
  StyleBox["pos", "TI"]], "InlineFormula"],
 ". ",
 "Possible positions are: ",
 Cell[BoxData[
  ButtonBox["Top",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Top"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Bottom",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Bottom"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Left",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Left"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Right",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Right"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->443019707],

Cell[TextData[{
 "The vertex names ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " and the labels ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " can be any expressions."
}], "Notes",
 CellID->174694386],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectedEdges",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedEdges"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", edges are drawn as ordinary lines",
 ". ",
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectedEdges",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedEdges"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", edges are drawn as arrows."
}], "Notes",
 CellID->69175411],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 ", with the following additions and changes:"
}], "Notes",
 CellID->77467358],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DataRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DataRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the range of vertex coordinates to generate", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DirectedEdges",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DirectedEdges"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to show edges as directed arrows", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["EdgeLabeling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EdgeLabeling"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to include labels given for edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["EdgeRenderingFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/EdgeRenderingFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to give explicit graphics for edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Frame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Frame"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to draw a frame around the plot", "TableText"]},
   {Cell["      ", "TableRowIcon"], "FrameTicks", "None", Cell[
    "what ticks to include on the frame", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LayerSizeFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LayerSizeFunction"], 
    RowBox[{"(", 
     RowBox[{"1", "&"}], ")"}], Cell[
    "the height to allow for each layer", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MultiedgeStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MultiedgeStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to draw multiple edges between vertices", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PackingMethod",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PackingMethod"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "method to use for packing components", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRangePadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRangePadding"], "Automatic", Cell[
    "how much padding to include around the plot", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "overall graphics directives for vertices and edges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SelfLoopStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SelfLoopStyle"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to draw edges linking a vertex to itself", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["VertexLabeling",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexLabeling"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to show vertex names as labels", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["VertexRenderingFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/VertexRenderingFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to give explicit graphics for vertices", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True}}}},
 CellID->353462848],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexLabeling"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", vertices are displayed as points, with their names ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " given in tooltips. "
}], "Notes",
 CellID->16670666],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["k", "TI"]], ",", 
    StyleBox["vlab", "TI"]}], "]"}]], "InlineFormula"],
 " can be used to specify an alternative tooltip for a vertex. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["i", "TI"]], "->", 
     SubscriptBox[
      StyleBox["v", "TI"], 
      StyleBox["j", "TI"]]}], ",", 
    StyleBox["lbl", "TI"]}], "]"}]], "InlineFormula"],
 " specifies a tooltip for an edge."
}], "Notes",
 CellID->762729751],

Cell[TextData[{
 "Explicit settings for ",
 Cell[BoxData[
  ButtonBox["VertexRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " override settings for ",
 Cell[BoxData[
  ButtonBox["VertexLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexLabeling"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EdgeLabeling",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeLabeling"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DirectedEdges",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectedEdges"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->442256812],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexRenderingFunction"], "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 ", each vertex is rendered with the graphics primitives given by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["r", "TI"], 
     StyleBox["k", "TI"]], ",", 
    SubscriptBox[
     StyleBox["v", "TI"], 
     StyleBox["k", "TI"]]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is the position where the vertex is being placed, and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is its name."
}], "Notes",
 CellID->183388779],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["EdgeRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EdgeRenderingFunction"], "->", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 ", each edge is rendered with the graphics primitives given by ",
 Cell[BoxData[
  RowBox[{
   StyleBox["g", "TI"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["i", "TI"]], ",", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["j", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["i", "TI"]], ",", 
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["j", "TI"]]}], "}"}], ",", 
    SubscriptBox[
     StyleBox["lbl", "TI"], 
     StyleBox["ij", "TI"]]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["r", "TI"], 
    StyleBox["i", "TI"]], ",", 
   SubscriptBox[
    StyleBox["r", "TI"], 
    StyleBox["j", "TI"]]}]], "InlineFormula"],
 " are the beginning and ending points of the edge, ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["v", "TI"], 
    StyleBox["i", "TI"]], ",", 
   SubscriptBox[
    StyleBox["v", "TI"], 
    StyleBox["j", "TI"]]}]], "InlineFormula"],
 " are the beginning and ending vertices, and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["ij", "TI"]]], "InlineFormula"],
 " is any label specified for the edge. "
}], "Notes",
 CellID->144575570],

Cell[TextData[{
 "The graphics primitives obtained applying ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["VertexRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
 " are in effect directly spliced into the graphic generated by ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["Inset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Inset"]], "InlineFormula"],
 " can be used to insert an arbitrary expression."
}], "Notes",
 CellID->100047542],

Cell[TextData[{
 "In the graphics generated by ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 ", edges are effectively drawn first, and vertices afterwards."
}], "Notes",
 CellID->106749993],

Cell["\<\
The graph does not need to be connected. Disconnected components are \
typically arranged so as to fill the area roughly uniformly.\
\>", "Notes",
 CellID->70117131],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["TreePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TreePlot"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " generates a tree plot of the graph represented by the adjacency matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->122404946],

Cell[TextData[{
 "The adjacency matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " can be a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " object."
}], "Notes",
 CellID->3967714],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " returns an object of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Graphics"], "[", 
   RowBox[{
    ButtonBox["Annotation",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Annotation"], "[", 
    RowBox[{
     StyleBox["data", "TI"], ",", 
     RowBox[{
      ButtonBox["VertexCoordinateRules",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/VertexCoordinateRules"], "->", 
      StyleBox["rules", "TI"]}]}], "]"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->68183324]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->107655429],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(7)", "ExampleCount"]
}], "ExampleSection",
 CellID->6633876],

Cell["Draw a tree:", "ExampleText",
 CellID->1489454305],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "4"}], ",", 
    RowBox[{"1", "\[Rule]", "6"}], ",", 
    RowBox[{"1", "\[Rule]", "8"}], ",", 
    RowBox[{"2", "\[Rule]", "6"}], ",", 
    RowBox[{"3", "\[Rule]", "8"}], ",", 
    RowBox[{"4", "\[Rule]", "5"}], ",", 
    RowBox[{"7", "\[Rule]", "8"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->168190180],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.01162829777814, 1.61860527644502}, {0., 
    0.809302638222512}, {0.809302638222512, 0.809302638222512}, {
    2.02325659555628, 0.809302638222512}, {0.809302638222512, 0.}, {
    1.61860527644502, 0.}, {0., 0.}, {2.42790791466754, 0.}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{1, 4}], LineBox[{2, 7}], LineBox[{5, 3}], LineBox[{6, 4}], 
      LineBox[{8, 4}]}, 
     {RGBColor[0., 0., 0.7], PointBox[1], PointBox[2], PointBox[3], 
      PointBox[4], PointBox[5], PointBox[6], PointBox[7], PointBox[8]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.01162829777814, 1.61860527644502}, {0., 
     0.809302638222512}, {0.809302638222512, 0.809302638222512}, {
     2.02325659555628, 0.809302638222512}, {0.809302638222512, 0.}, {
     1.61860527644502, 0.}, {0., 0.}, {2.42790791466754, 0.}}]& ],
  AspectRatio->0.816496580927726,
  FrameTicks->None,
  ImageSize->{110., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{114, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19786609]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->940541746],

Cell["Show direction of edges:", "ExampleText",
 CellID->1978791016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"1", "\[Rule]", "8"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "8"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12016927],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.01162829777814, 1.618605276445024}, {0., 
    0.809302638222512}, {0.809302638222512, 0.809302638222512}, {
    2.02325659555628, 0.809302638222512}, {0.809302638222512, 0.}, {
    1.618605276445024, 0.}, {0., 0.}, {2.427907914667536, 0.}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03150025645452451, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], ArrowBox[{1, 4}], ArrowBox[{2, 7}], 
      ArrowBox[{5, 3}], ArrowBox[{6, 4}], ArrowBox[{8, 4}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "7"],
       Annotation[#, 7, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.01162829777814, 1.618605276445024}, {0., 
     0.809302638222512}, {0.809302638222512, 0.809302638222512}, {
     2.02325659555628, 0.809302638222512}, {0.809302638222512, 0.}, {
     1.618605276445024, 0.}, {0., 0.}, {2.427907914667536, 0.}}]& ],
  AspectRatio->0.816496580927726,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->414914585]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32707144],

Cell["Include vertex labels:", "ExampleText",
 CellID->367941274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"1", "\[Rule]", "8"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "8"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->738297439],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{115, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217238232]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->628343972],

Cell["Show edge labels:", "ExampleText",
 CellID->270550211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "4"}], ",", 
    RowBox[{"1", "\[Rule]", "6"}], ",", 
    RowBox[{"1", "\[Rule]", "8"}], ",", 
    RowBox[{"2", "\[Rule]", "6"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"3", "\[Rule]", "8"}], ",", "\"\<3\[Rule]8\>\""}], "}"}], ",", 
    RowBox[{"4", "\[Rule]", "5"}], ",", 
    RowBox[{"7", "\[Rule]", "8"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1965963005],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.01162829777814, 1.618605276445024}, {0., 
    0.809302638222512}, {0.809302638222512, 0.809302638222512}, {
    2.02325659555628, 0.809302638222512}, {0.809302638222512, 0.}, {
    1.618605276445024, 0.}, {0., 0.}, {2.427907914667536, 0.}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{1, 4}], LineBox[{2, 7}], LineBox[{5, 3}], 
      {Arrowheads[{{0.5, 0.5, 
          GraphicsBox[{
            GrayLevel[0], 
            InsetBox[
             BoxData[
              FormBox[
               StyleBox["\"3\[Rule]8\"", StripOnInput -> False], 
               TraditionalForm]], {0, 0}, 
             ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
             GrayLevel[1]]}]}, {0, 0}}], ArrowBox[{6, 4}]}, 
      LineBox[{8, 4}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "7"],
       Annotation[#, 7, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.01162829777814, 1.618605276445024}, {0., 
     0.809302638222512}, {0.809302638222512, 0.809302638222512}, {
     2.02325659555628, 0.809302638222512}, {0.809302638222512, 0.}, {
     1.618605276445024, 0.}, {0., 0.}, {2.427907914667536, 0.}}]& ],
  AspectRatio->0.816496580927726,
  FrameTicks->None,
  ImageSize->{115., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{119, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1197661911]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->184183475],

Cell["Drawing a tree with different orientation from the default:", \
"ExampleText",
 CellID->388077390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"1", "\[Rule]", "8"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"3", "\[Rule]", "8"}], ",", "\"\<3\[Rule]8\>\""}], "}"}], ",", 
     
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}]}], "}"}], ",", "Left"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->404507675],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 1.0116282977781392`}, {0.8093026382225131, 
    0.}, {0.8093026382225122, 0.809302638222512}, {0.8093026382225109, 
    2.02325659555628}, {1.6186052764450243`, 0.8093026382225129}, {
    1.6186052764450234`, 1.618605276445025}, {1.6186052764450252`, 
    8.67466711215488*^-16}, {1.6186052764450227`, 2.427907914667537}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{1, 4}], LineBox[{2, 7}], LineBox[{5, 3}], 
      {Arrowheads[{{0.5, 0.5, 
          GraphicsBox[{
            GrayLevel[0], 
            InsetBox[
             BoxData[
              FormBox[
               StyleBox["\"3\[Rule]8\"", StripOnInput -> False], 
               TraditionalForm]], {0, 0}, 
             ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
             GrayLevel[1]]}]}, {0, 0}}], ArrowBox[{6, 4}]}, 
      LineBox[{8, 4}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "7"],
       Annotation[#, 7, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1.0116282977781392`}, {0.8093026382225131, 
     0.}, {0.8093026382225122, 0.809302638222512}, {0.8093026382225109, 
     2.02325659555628}, {1.6186052764450243`, 0.8093026382225129}, {
     1.6186052764450234`, 1.618605276445025}, {1.6186052764450252`, 
     8.67466711215488*^-16}, {1.6186052764450227`, 2.427907914667537}}]& ],
  AspectRatio->1.224744871391589,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{181, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->239196217]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->276082913],

Cell["Specify the root node:", "ExampleText",
 CellID->1645047370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"TreePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "4"}], ",", 
       RowBox[{"1", "\[Rule]", "6"}], ",", 
       RowBox[{"1", "\[Rule]", "8"}], ",", 
       RowBox[{"2", "\[Rule]", "6"}], ",", 
       RowBox[{"3", "\[Rule]", "8"}], ",", 
       RowBox[{"4", "\[Rule]", "5"}], ",", 
       RowBox[{"7", "\[Rule]", "8"}]}], "}"}], ",", "Automatic", ",", "root", 
     ",", 
     RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"root", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->807222073],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{1.0116282977781401`, 1.618605276445024}, {0., 
      0.809302638222512}, {0.809302638222512, 0.809302638222512}, {
      2.0232565955562802`, 0.809302638222512}, {0.809302638222512, 0.}, {
      1.618605276445024, 0.}, {0., 0.}, {2.427907914667536, 0.}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {1, 4}, {2, 7}, {5, 3}, {6, 4}, {8, 4}}]}, {
        InsetBox[
         FrameBox["1",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 1], InsetBox[
         FrameBox["4",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 2], InsetBox[
         FrameBox["6",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 3], InsetBox[
         FrameBox["8",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 4], InsetBox[
         FrameBox["2",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 5], InsetBox[
         FrameBox["3",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 6], InsetBox[
         FrameBox["5",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 7], InsetBox[
         FrameBox["7",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 8]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{1.0116282977781401`, 1.618605276445024}, {0.,
        0.809302638222512}, {0.809302638222512, 0.809302638222512}, {
       2.0232565955562802`, 0.809302638222512}, {0.809302638222512, 0.}, {
       1.618605276445024, 0.}, {0., 0.}, {2.427907914667536, 0.}}]& ],
    AspectRatio->0.816496580927726,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0.6756639246921762, 1.8017704658458031`}, {
      0.6756639246921762, 2.7026556987687047`}, {0., 0.9008852329229016}, {
      1.3513278493843524`, 0.9008852329229016}, {0., 0.}, {0.9008852329229016,
       0.}, {0.6756639246921762, 3.6035409316916063`}, {1.8017704658458031`, 
      0.}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {1, 4}, {2, 7}, {5, 3}, {6, 4}, {8, 4}}]}, {
        InsetBox[
         FrameBox["1",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 1], InsetBox[
         FrameBox["4",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 2], InsetBox[
         FrameBox["6",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 3], InsetBox[
         FrameBox["8",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 4], InsetBox[
         FrameBox["2",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 5], InsetBox[
         FrameBox["3",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 6], InsetBox[
         FrameBox["5",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 7], InsetBox[
         FrameBox["7",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 8]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.6756639246921762, 1.8017704658458031`}, {
       0.6756639246921762, 2.7026556987687047`}, {0., 0.9008852329229016}, {
       1.3513278493843524`, 0.9008852329229016}, {0., 0.}, {
       0.9008852329229016, 0.}, {0.6756639246921762, 3.6035409316916063`}, {
       1.8017704658458031`, 0.}}]& ],
    AspectRatio->1.4142135623730951`,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{363, 218},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197917692]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->830148031],

Cell["\<\
If the graph is not a tree, it is laid out based on a spanning tree of this \
graph:\
\>", "ExampleText",
 CellID->1258500244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"3", "\[Rule]", "4"}], ",", 
    RowBox[{"4", "\[Rule]", "1"}], ",", 
    RowBox[{"3", "\[Rule]", "5"}], ",", 
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"5", "\[Rule]", "5"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1882563794],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.8770580193070292}, {0.4385290096535146, 
    1.7541160386140584`}, {0.8770580193070292, 0.8770580193070292}, {0., 
    0.}, {0.8770580193070292, 0.}, {0.022581119474775663`, 
    0.9786730569435195}, {0.02910323986274328, 1.0057742119460578`}, {
    0.03656963077489506, 1.0326305643337832`}, {0.04497114840871305, 
    1.059209224162213}, {0.05429750374785745, 1.085477641566289}, {
    0.06453727516273004, 1.111403646622948}, {0.075677922398106, 
    1.1369554887483928`}, {0.08770580193070324, 1.1621018755818144`}, {
    0.26311740579210874`, 1.5129250833046255`}, {0.27601778753928763`, 
    1.5376352190307563`}, {0.289774872898418, 1.561878842094324}, {
    0.3043718140948216, 1.5856262622602173`}, {0.31979073481459575`, 
    1.6088483969739784`}, {0.33601275209704884`, 1.6315168069780908`}, {
    0.3530179994599381, 1.6536037311404475`}, {0.3707856512291882, 
    1.6750821204523443`}, {0.06774335842432681, 0.956091937468744}, {
    0.08551101019357686, 0.977570326780641}, {0.10251625755646612`, 
    0.9996572509429976}, {0.11873827483891924`, 1.02232566094711}, {
    0.13415719555869338`, 1.0455477956608712`}, {0.14875413675509697`, 
    1.0692952158267646`}, {0.16251122211422725`, 1.0935388388903322`}, {
    0.17541160386140614`, 1.118248974616463}, {0.3508232077228117, 
    1.469072182339274}, {0.362851087255409, 1.4942185691726957`}, {
    0.3739917344907849, 1.5197704112981405`}, {0.38423150590565747`, 
    1.5456964163547995`}, {0.39355786124480185`, 1.5719648337588754`}, {
    0.4019593788786199, 1.5985434935873053`}, {0.4094257697907716, 
    1.6253998459750307`}, {0.4159478901787392, 1.6525010009775691`}, {
    0.880984606398445, -0.00006168375952136038}, {
    0.9509046871554265, -0.011187117580601567`}, {
    1.0149014245309422`, -0.041469300065675806`}, {
    1.0678415516923314`, -0.08847925546776053}, {
    1.1054786678070052`, -0.14844625023438726`}, {
    1.1247938477273451`, -0.2165602487619657}, {
    1.1242377941529256`, -0.28735773300535133`}, {
    1.1038551089101492`, -0.35515993881802355`}, {
    1.0652807153780524`, -0.41452835747980865`}, {
    1.0116087190224565`, -0.46070096600450605`}, {
    0.9471442249164251, -0.4899741955909988}, {0.8770580193070292, -0.5}, {
    0.8069718136976334, -0.4899741955909988}, {
    0.742507319591602, -0.4607009660045061}, {
    0.688835323236006, -0.41452835747980865`}, {
    0.6502609297039093, -0.3551599388180236}, {
    0.6298782444611328, -0.28735773300535133`}, {
    0.6293221908867133, -0.21656024876196572`}, {
    0.6486373708070533, -0.1484462502343873}, {
    0.6862744869217269, -0.08847925546776056}, {
    0.7392146140831162, -0.04146930006567583}, {
    0.8032113514586318, -0.011187117580601567`}, {
    0.8731314322156134, -0.00006168375952136038}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
         2}, {1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
        37, 2}, {2, 3}, {3, 4}, {3, 5}, {4, 1}, {5, 38, 39, 40, 41, 42, 43, 
        44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 
        5}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.8770580193070292}, {0.4385290096535146, 
     1.7541160386140584`}, {0.8770580193070292, 0.8770580193070292}, {0., 
     0.}, {0.8770580193070292, 0.}}]& ],
  AspectRatio->1.415636228576106,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{157, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->208227863]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Graph Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->369255627],

Cell["Specify a graph using a rule list: ", "ExampleText",
 CellID->1096410170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "4"}], ",", 
    RowBox[{"1", "\[Rule]", "7"}], ",", 
    RowBox[{"2", "\[Rule]", "5"}], ",", 
    RowBox[{"3", "\[Rule]", "4"}], ",", 
    RowBox[{"4", "\[Rule]", "5"}], ",", 
    RowBox[{"5", "\[Rule]", "6"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->430275],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.7869910029407435}, {0.9837387536759294, 
    1.573982005881487}, {0., 0.}, {0.7869910029407435, 0.}, {
    1.1804865044111152`, 0.7869910029407435}, {1.967477507351859, 
    0.7869910029407435}, {1.573982005881487, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {2, 5}, {4, 5}, {5, 7}, {6, 2}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.7869910029407435}, {0.9837387536759294, 
     1.573982005881487}, {0., 0.}, {0.7869910029407435, 0.}, {
     1.1804865044111152`, 0.7869910029407435}, {1.967477507351859, 
     0.7869910029407435}, {1.573982005881487, 0.}}]& ],
  AspectRatio->0.8944271909999159,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1691417158]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56963074],

Cell["Specify a graph using a dense adjacency matrix: ", "ExampleText",
 CellID->155380432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->273676337],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.}, {0.7745966692414834, 
    0.7745966692414834}, {0.7745966692414834, 0.}, {1.5491933384829668`, 
    0.}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}, {2, 3}, {2, 4}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.}, {0.7745966692414834, 
     0.7745966692414834}, {0.7745966692414834, 0.}, {1.5491933384829668`, 
     0.}}]& ],
  AspectRatio->0.7071067811865476,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->108931975]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1640804889],

Cell["Specify a graph using a sparse adjacency matrix: ", "ExampleText",
 CellID->1544973088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "4"}], "}"}]}], "}"}], "\[Rule]", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1430216091],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.}, {0.7745966692414834, 
    0.7745966692414834}, {0.7745966692414834, 0.}, {1.5491933384829668`, 
    0.}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}, {2, 3}, {2, 4}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.}, {0.7745966692414834, 
     0.7745966692414834}, {0.7745966692414834, 0.}, {1.5491933384829668`, 
     0.}}]& ],
  AspectRatio->0.7071067811865476,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->940482128]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Graph Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->4212966],

Cell["Give labels for some edges:", "ExampleText",
 CellID->124062807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"3", "\[Rule]", "1"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"2", "\[Rule]", "4"}], ",", "\"\<2\[Rule]4\>\""}], "}"}], ",", 
    RowBox[{"2", "\[Rule]", "5"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1524298092],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.8944271909999159, 1.7888543819998317`}, {
    0.4472135954999579, 0.8944271909999159}, {1.3416407864998738`, 
    0.8944271909999159}, {0., 0.}, {0.8944271909999159, 0.}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], 
      {Arrowheads[{{0.5, 0.5, 
          GraphicsBox[{
            GrayLevel[0], 
            InsetBox[
             BoxData[
              FormBox[
               StyleBox["\"2\[Rule]4\"", StripOnInput -> False], 
               TraditionalForm]], {0, 0}, 
             ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
             GrayLevel[1]]}]}, {0, 0}}], ArrowBox[{2, 4}]}, LineBox[{2, 5}], 
      LineBox[{3, 1}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.8944271909999159, 1.7888543819998317`}, {
     0.4472135954999579, 0.8944271909999159}, {1.3416407864998738`, 
     0.8944271909999159}, {0., 0.}, {0.8944271909999159, 0.}}]& ],
  AspectRatio->1.1547005383792515`,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 208},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1228283265]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1093274895],

Cell["Give vertex labels:", "ExampleText",
 CellID->250888577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"5", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1908060239],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->187916918]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1301177980],

Cell["Do not show multiedges or self-loops:", "ExampleText",
 CellID->956609091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"5", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "None"}], ",", 
   RowBox[{"SelfLoopStyle", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->417724249],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.0859306069076735`, 1.7374889710522774`}, {
    0.43437224276306935`, 0.8687444855261387}, {1.7374889710522774`, 
    0.8687444855261387}, {0., 0.}, {0.8687444855261387, 0.}, {
    1.7374889710522774`, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 4}, {2, 5}, {3, 1}, {3, 6}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.0859306069076735`, 1.7374889710522774`}, {
     0.43437224276306935`, 0.8687444855261387}, {1.7374889710522774`, 
     0.8687444855261387}, {0., 0.}, {0.8687444855261387, 0.}, {
     1.7374889710522774`, 0.}}]& ],
  AspectRatio->1.,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1790119196]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->622455388],

Cell["Show edge as arrows:", "ExampleText",
 CellID->1768796684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "7"}], ",", 
     RowBox[{"2", "\[Rule]", "8"}], ",", 
     RowBox[{"4", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"MultiedgeStyle", "\[Rule]", "None"}], ",", 
   RowBox[{"SelfLoopStyle", "\[Rule]", "None"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1049937125],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 1.7517114918515921`}, {0., 
    0.8758557459257961}, {0.6568918094443471, 2.6275672377773884`}, {
    0.8758557459257962, 0.8758557459257961}, {1.3137836188886942`, 
    1.7517114918515921`}, {0.4379278729628981, 0.}, {1.3137836188886942`, 
    0.}, {1.7517114918515924`, 0.8758557459257961}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03054064093764101, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], ArrowBox[{3, 5}], ArrowBox[{4, 5}], 
      ArrowBox[{4, 6}], ArrowBox[{4, 7}], ArrowBox[{8, 5}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 1.7517114918515921`}, {0., 
     0.8758557459257961}, {0.6568918094443471, 2.6275672377773884`}, {
     0.8758557459257962, 0.8758557459257961}, {1.3137836188886942`, 
     1.7517114918515921`}, {0.4379278729628981, 0.}, {1.3137836188886942`, 
     0.}, {1.7517114918515924`, 0.8758557459257961}}]& ],
  AspectRatio->1.224744871391589,
  FrameTicks->None,
  ImageSize->{132., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{136, 161},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1177124423]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->996109397],

Cell["Plot a disconnected graph using different packing methods: ", \
"ExampleText",
 CellID->2995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"TreePlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"i", "\[Rule]", 
         RowBox[{"Mod", "[", 
          RowBox[{
           RowBox[{"i", "^", "2"}], ",", "31"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "0", ",", "31"}], "}"}]}], "]"}], ",", 
      RowBox[{"PackingMethod", "\[Rule]", "pm"}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"pm", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Automatic\>\"", ",", "\"\<ClosestPacking\>\""}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellTags->"b:0.1",
 CellLabel->"In[1]:=",
 CellID->1209134277],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    GraphicsBox[
     TagBox[GraphicsComplexBox[CompressedData["
1:eJxFk3lQU1cUxhHUoSRvMwKaRMpiC1IQLIahVeBCgwxoiShagVJxgYoGAVsX
dGSRCB1csBojI2gUGJaYUltr2aTviIrDwCAgKLgVMQoyBBQrAhWm6fTd1z8y
d7537vnOd37vxWFz0po4czMzs52m379nUjAh9NBIkI/W2zVQZWSxXi+JCK9a
QcGDsOqafpj0T/ZLjFBZPmQzhNNvg14P+Buu9fUu9Bhluef+UwMFBYVpNHjn
d96Ns3rr/1+/AHDdzVWndymcYjs2buhWyhgkLO9qjksWgkV9duad30lUem+u
te8QA46bjCMplIjX5WNB8nEHEuF5+79sDyeK5yCch/Pl83Ann4fLgfD8ba9W
hKyrmIEUN48dfxwpAqzxfbzfRW16pp3Mhtf4Pnfyfljj+TgPruP5tc0+yzWq
mcDN4ft/+K6xsfT5O96fu8f7cTl4jXkF9/jJgy9Y83yxP94f++P3eYnQlUcX
iwDrQoXE2qFhmr1qXn/Q5aQEya7nl0KWkR326TmWGipBYn28a6aLkQ3bwi57
bClBfjqd3MlziM07aNak6RCj/JaINycrB9kjwpYrZnqTrrRT1jcMsBFL28K9
8sXo2eYyykb9gu0sWRd4y6Q9yyvXKhUGdspF26b7SYxOhbWdX+vUx9ZYhhi8
u8TopK3AEL+8l52Mj1X6CiUoZVVaQkLWY/aPsl2HIsIk6I7ckPl58UN+n4+D
Ni69Nf2Ate8vO/3BEwlq5eoG59pL9vZSlMz1f5Td7uX8lZT3fxp3IPhKmklz
860Gb3bln5Ly+XKjQhtd1VLUx+Vfeyhsa0yGFJ3h9lMwYsXtSJPm9j/xSfSj
DCcpz+fVuoBcw1MJms/xW3Q05qzs7P98Me+uYuUrjen/hXkft4tlbntQgHnP
s3t95ufXJGDelaUFWSt/JAHzXvxhq8N6GxIw74BVl0P1uQRg3uoFvz7MnBAC
5u2es7/ywE4hYN6JnzWlw18CwLxtfMfeiDQCwLwd35vbklEC/ntx/3pNYnqQ
ADBvXMe8cT/mreT8MW88H/PG+TBvxOXHvPF+mDfeH/O25fhg3pgf5o35vtsd
sGzmAgbd6C0OF60iQPSiLPmdNYPOTfTN12UTsJ2dinxOMGhbek58DRAwYG2e
3jaTQbLTNRYekwRs3qeurpukkYpuM45/SkJRYpuHbsSkQ8fWz9pBQn8TFaN9
RqMR+ro+sIiEaLfO2dp7NMobu3xO201C0q3mLRbzaeQQ8nJuTj8NL9V55xgB
jXaPxnYtN2dg7OrU0bhxCp0ItUtLkTJQcduTvt9NoZglvfel3gxYOSZVZFZR
KLYz5Z63goHWcrIlSU2h6tOeBVXfMvCNtn6PPolCmoqsvWfSGXD2oT2/CKGQ
c4l8pFXDQN2J3+ou9JNoZa37mvg0BlSX+1fXviXRn+7ksHgTA51Ty9KezKLQ
xGBdsEjOQM9qr6WW8yg0p9cxdYMzA8+PkNeXuFFoR5Gt6o0VA1svajoiAk36
sEphHKahZ8B23/YoCskctSVhd2kYdcpbuON7CsV5OLvZV9PwYlwha99Lo3k3
3FraU0lQLjr6d8NhGqUk+66Ml5MQ+ayw46KaRj7QMPGeIiEjyoJJKKHRhVG/
FaWPCFC4b70pukqjAr0kZJeOAGPC3CuFjTR6ueg8m5xKQOnwtZjpbhotNh+f
/UsIAQFFohleQzQSEntsAyUE/ANEFClV
       "], {
        {RGBColor[0.5, 0., 0.], 
         LineBox[{{1, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 
           47, 48, 49, 50, 51, 52, 53, 54, 55, 1}, {2, 56, 57, 58, 59, 60, 61,
            62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 
           78, 2}, {3, 4}, {4, 7}, {5, 6}, {6, 14}, {7, 13}, {8, 79, 80, 81, 
           82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 9}, {9, 95, 96,
            97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110,
            8}, {10, 8}, {11, 12}, {12, 21}, {13, 3}, {14, 19}, {15, 11}, {16,
            17}, {17, 6}, {18, 19}, {19, 17}, {20, 21}, {21, 15}, {22, 13}, {
           23, 15}, {24, 11}, {25, 14}, {26, 3}, {27, 12}, {28, 9}, {29, 7}, {
           30, 4}, {31, 2}, {32, 1}}]}, 
        {RGBColor[0, 0, 0.7], 
         TagBox[
          TooltipBox[PointBox[1],
           "0"],
          Annotation[#, 0, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[2],
           "1"],
          Annotation[#, 1, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[3],
           "2"],
          Annotation[#, 2, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[4],
           "4"],
          Annotation[#, 4, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[5],
           "3"],
          Annotation[#, 3, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[6],
           "9"],
          Annotation[#, 9, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[7],
           "16"],
          Annotation[#, 16, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[8],
           "5"],
          Annotation[#, 5, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[9],
           "25"],
          Annotation[#, 25, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[10],
           "6"],
          Annotation[#, 6, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[11],
           "7"],
          Annotation[#, 7, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[12],
           "18"],
          Annotation[#, 18, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[13],
           "8"],
          Annotation[#, 8, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[14],
           "19"],
          Annotation[#, 19, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[15],
           "10"],
          Annotation[#, 10, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[16],
           "11"],
          Annotation[#, 11, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[17],
           "28"],
          Annotation[#, 28, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[18],
           "12"],
          Annotation[#, 12, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[19],
           "20"],
          Annotation[#, 20, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[20],
           "13"],
          Annotation[#, 13, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[21],
           "14"],
          Annotation[#, 14, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[22],
           "15"],
          Annotation[#, 15, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[23],
           "17"],
          Annotation[#, 17, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[24],
           "21"],
          Annotation[#, 21, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[25],
           "22"],
          Annotation[#, 22, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[26],
           "23"],
          Annotation[#, 23, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[27],
           "24"],
          Annotation[#, 24, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[28],
           "26"],
          Annotation[#, 26, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[29],
           "27"],
          Annotation[#, 27, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[30],
           "29"],
          Annotation[#, 29, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[31],
           "30"],
          Annotation[#, 30, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[32],
           "31"],
          Annotation[#, 31, "Tooltip"]& ]}}],
      Annotation[#, 
       VertexCoordinateRules -> {{6.89666384535836, -0.9223948311309647}, {
        6.89666384535836, -3.9095293382446625`}, {
        1.6720959906278297`, -0.42239483113096465`}, {
        0.7794523052729261, -1.1365097794148875`}, {
        0.42239483113096465`, -4.123644286528585}, {
        1.3150385164858682`, -3.4095293382446625`}, {
        0.42239483113096465`, -1.8506247276988104`}, {
        4.3021730235995665`, -3.554881660897996}, {
        3.8392629737132906`, -4.480701760670547}, {
        4.765083073485842, -4.480701760670547}, {
        3.766586812386624, -1.1365097794148875`}, {
        4.659230497741527, -0.42239483113096465`}, {
        1.8506247276988104`, -1.1365097794148875`}, {
        1.1365097794148875`, -4.123644286528585}, {
        3.4095293382446625`, -1.8506247276988104`}, {
        2.207682201840772, -4.837759234812508}, {
        2.207682201840772, -4.123644286528585}, {
        0.7794523052729261, -5.551874183096431}, {
        0.7794523052729261, -4.837759234812508}, {
        4.837759234812508, -1.8506247276988104`}, {
        4.837759234812508, -1.1365097794148875`}, {
        1.8506247276988104`, -1.8506247276988104`}, {
        3.4095293382446625`, -2.5647396759827332`}, {
        4.123644286528585, -1.8506247276988104`}, {
        1.493567253556849, -4.837759234812508}, {
        2.5647396759827332`, -1.1365097794148875`}, {
        5.551874183096431, -1.1365097794148875`}, {
        3.8392629737132906`, -5.406521860443099}, {
        0.42239483113096465`, -2.5647396759827332`}, {
        1.1365097794148875`, -1.8506247276988104`}, {
        6.89666384535836, -4.9095293382446625`}, {
        6.89666384535836, -1.9223948311309647`}}]& ],
     AspectRatio->0.873580423290518,
     FrameTicks->None,
     PlotRange->All,
     PlotRangePadding->Scaled[0.1]],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     TagBox[GraphicsComplexBox[CompressedData["
1:eJxVlHlQU1cUxrOAgoCavATItGDZxAG1CpTGzMC9iILKUnEDWa1LQdTgjHVh
k8UNkDVoK1KpgLggFHAARdT7TGgMI7URGaPFxJgQpLhRAiIgoXTw3Y5/vHlz
5p7znd/33TfPbmvCuh0MGo0mnHr+ewfaVGlP6Z6AisQl/hoZh3Q8mhH52IYO
qbrCYhn9TvwgIHnAMwe2AFvOpKkuWw7CRqRr3zdo0cMm9SVtlTlc27d8aYE3
i5xTW8Zk6ljwI68i5RepOSmbnkNDfS5DhpXDSGt4EhK5j4Bq1dVNg/1iUDzh
KwgtYcFpjj7kQRPu/D6Ii+tq7/rsiFejwGngUMVYshFZIfFwlPOMIGOfS+I/
OROULuYReGqkbotZmGdGVkflU48h0H4xMivFbRbpORnozjnIhdM6HFxT/Q5F
nWcdM+bAobL5VqxhS1xT/QENtef2njCGlB5VU3wUD+WX2r8nCgoNfXPI4OHi
BGX5JObpcYiAj0rZWN/WdTQmYzMNUn7exRYdGfQyw/pUXgtKkhbrl48jKt9P
c2To9Bze//l9WpOf37c1WfPwvMG16gnQ3L5l2Tl134JvttO8XLqAd7Knc/xt
Dgm6paqDc+WAOX44PrqMQ+Yb6nfYhbWDYLBhy0Ihh5ytskfRx9pAfvKeuoYl
HNJHcSntmpkYWIlUkmf9BMl/ubFwwEYM7ibF5PpXEGT47uObK262gbw6yf62
SIJUbBM/cKxpB7Umu1S98whyjKvoS/KTg8ycjDOFA2zS23589evYLmDSP7M6
r5NNrvnEb3H2641+Mja5yfq7VK9tSnweJFqWECpW4/mNR4fqTiZpsL5Hpm/Q
62Yt3p9aWYCso3swX7Jzq+/lrT2YX7bjmbtXmxb7u6zk5+QWaLD/mjqfoTCl
GucTZdwrfX1eifN7FXdFNuH0FOdbP6YG7Vw6pGr7WN6WXcdpkOrXtOpa3Zg0
SOndU/9ZE7BoEu+7/qUhVC8yYB5l62z5bV8D5n2W6igy9jNgP+n5a+6Xlhiw
370Wg7yObydxHgKJs43elAapvMQrAlfb5dMglSf1/VB5H5M0J5yspePz2Su7
S1uWMvB8IX1WjfRXBqT0Te5GPVK9ZUBqf3j7wLsr1kxI8W2uHpf/wWNCiv/N
KNPCfZABKX86q1LNjCoGpPz/EGgzkchn4Hzml/8d5tNEx/mdsbBP1Dr9n68p
V9yoDydgXZDdy1jyAnA8tqC/dz0BxVG7oxTxWSA5+vCjrgACyptzKwWdhWis
MfMDWk7AlgcBZUelF9GPVly3q3wCrggZLkpLuYYazUOulCwiIL/oVrP54RY0
Flf4ON+OgGvrZt3odiOR8P6G9HwOAdebmt6rPiNB6dsDlYOb2HBewypND1Kj
Mfe5VvTVbHhz3LhXdPoFMk+aBPYCNiy9NeDKj9WgXkYJPcKFDScGJ0dFHlpk
uYQfXM9jQ45Z3tutE1qUqD8R42zChn9xj3B23u1BpPB54+/DLNje+MVIbLoO
ObVmsYo0U/+/bIcmB0EvEr4MV6AGFhQKdneoDujQ+oND5R03WNBckXD1SG4P
+niu7IaKZEEVUh7yu6BFqf5ni/XtLHg5jmu0944GMXUzw026WHBXcmvEqu4X
SPLuvob3fEqv2P665bgapRbnNjm+YkEycSTGzlaNTJfKzJw+sGCaNIEfka1C
73+W/0Y2sWFN5cmo0tBWlCIz339NwoaK4HLgWt2I4jNtAos6p/wX/PQVQ1CD
CkeP5IRp2HBknV9atawMbeno8WLq2TAO5jXX3TyADCanF+YaEbDcxPahdacI
XM/zUryxJKC/3lo0FlYFQnxOJdm7ELDbJmBZRFI9+BeENWNV
       "], {
        {RGBColor[0.5, 0., 0.], 
         LineBox[{{1, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 
           47, 48, 49, 50, 51, 52, 53, 54, 55, 1}, {2, 56, 57, 58, 59, 60, 61,
            62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 
           78, 2}, {3, 4}, {4, 7}, {5, 6}, {6, 14}, {7, 13}, {8, 79, 80, 81, 
           82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 9}, {9, 95, 96,
            97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110,
            8}, {10, 8}, {11, 12}, {12, 21}, {13, 3}, {14, 19}, {15, 11}, {16,
            17}, {17, 6}, {18, 19}, {19, 17}, {20, 21}, {21, 15}, {22, 13}, {
           23, 15}, {24, 11}, {25, 14}, {26, 3}, {27, 12}, {28, 9}, {29, 7}, {
           30, 4}, {31, 2}, {32, 1}}]}, 
        {RGBColor[0, 0, 0.7], 
         TagBox[
          TooltipBox[PointBox[1],
           "0"],
          Annotation[#, 0, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[2],
           "1"],
          Annotation[#, 1, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[3],
           "2"],
          Annotation[#, 2, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[4],
           "4"],
          Annotation[#, 4, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[5],
           "3"],
          Annotation[#, 3, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[6],
           "9"],
          Annotation[#, 9, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[7],
           "16"],
          Annotation[#, 16, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[8],
           "5"],
          Annotation[#, 5, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[9],
           "25"],
          Annotation[#, 25, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[10],
           "6"],
          Annotation[#, 6, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[11],
           "7"],
          Annotation[#, 7, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[12],
           "18"],
          Annotation[#, 18, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[13],
           "8"],
          Annotation[#, 8, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[14],
           "19"],
          Annotation[#, 19, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[15],
           "10"],
          Annotation[#, 10, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[16],
           "11"],
          Annotation[#, 11, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[17],
           "28"],
          Annotation[#, 28, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[18],
           "12"],
          Annotation[#, 12, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[19],
           "20"],
          Annotation[#, 20, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[20],
           "13"],
          Annotation[#, 13, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[21],
           "14"],
          Annotation[#, 14, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[22],
           "15"],
          Annotation[#, 15, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[23],
           "17"],
          Annotation[#, 17, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[24],
           "21"],
          Annotation[#, 21, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[25],
           "22"],
          Annotation[#, 22, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[26],
           "23"],
          Annotation[#, 23, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[27],
           "24"],
          Annotation[#, 24, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[28],
           "26"],
          Annotation[#, 26, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[29],
           "27"],
          Annotation[#, 27, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[30],
           "29"],
          Annotation[#, 29, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[31],
           "30"],
          Annotation[#, 30, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[32],
           "31"],
          Annotation[#, 31, "Tooltip"]& ]}}],
      Annotation[#, 
       VertexCoordinateRules -> {{0.3890125487418643, -5.1961756823861}, {
        2.1395690180802536`, -5.1961756823861}, {1.1510601089256416`, 
        0.09864105057122341}, {0.2584164235707379, -0.6154738977126994}, {
        3.5810006251765363`, -4.31109311076041}, {
        4.47364431053144, -3.5969781624764874`}, {-0.09864105057122352, \
-1.3295888459966223`}, {4.8626568592733035`, 0.1477950022888228}, {
        4.399746809387028, -0.7780250974837286}, {
        5.32556690915958, -0.7780250974837286}, {
        1.619960344167263, -2.5605366414220208`}, {
        2.5126040295221665`, -1.846421693138098}, {
        1.3295888459966223`, -0.6154738977126994}, {
        4.295115573460459, -4.31109311076041}, {
        1.2629028700253015`, -3.2746515897059436`}, {
        5.366287995886344, -5.025208059044333}, {
        5.366287995886344, -4.31109311076041}, {
        3.9380580993184977`, -5.739323007328256}, {
        3.9380580993184977`, -5.025208059044333}, {
        2.6911327665931473`, -3.2746515897059436`}, {
        2.6911327665931473`, -2.5605366414220208`}, {
        1.3295888459966223`, -1.3295888459966223`}, {
        1.2629028700253015`, -3.9887665379898665`}, {
        1.9770178183092244`, -3.2746515897059436`}, {
        4.652173047602421, -5.025208059044333}, {
        2.043703794280545, -0.6154738977126994}, {
        3.40524771487707, -2.5605366414220208`}, {
        4.399746809387028, -1.70384519725628}, {-0.09864105057122352, \
-2.043703794280545}, {0.6154738977126993, -1.3295888459966223`}, {
        2.1395690180802536`, -6.1961756823861}, {
        0.3890125487418643, -6.1961756823861}}]& ],
     AspectRatio->1.0774281542094797`,
     FrameTicks->None,
     PlotRange->All,
     PlotRangePadding->Scaled[0.1]],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{410, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"b:0.1",
 CellLabel->"Out[1]=",
 CellID->950036013]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->739766316],

Cell["\<\
For large graphs, it is sometimes better not to draw vertices at all:\
\>", "ExampleText",
 CellID->1632065829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "\[Rule]", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"i", "^", "2"}], ",", "351"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "351"}], "}"}]}], "]"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->693558391],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{279, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->238107355]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1529467861],

Cell["Drawing a tree with different orientations:", "ExampleText",
 CellID->1551442486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"TreePlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1", "\[Rule]", "4"}], ",", 
          RowBox[{"1", "\[Rule]", "6"}], ",", 
          RowBox[{"1", "\[Rule]", "8"}], ",", 
          RowBox[{"2", "\[Rule]", "6"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"3", "\[Rule]", "8"}], ",", "\"\<3\[Rule]8\>\""}], "}"}], 
          ",", 
          RowBox[{"4", "\[Rule]", "5"}], ",", 
          RowBox[{"7", "\[Rule]", "8"}]}], "}"}], ",", "pos", ",", 
        RowBox[{"BaselinePosition", "\[Rule]", "Top"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", "pos"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"pos", ",", 
        RowBox[{"{", 
         RowBox[{
         "Automatic", ",", "Left", ",", "Top", ",", "Right", ",", "Bottom", 
          ",", "Center"}], "}"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"{", "3", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1155268122],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{1.01162829777814, 1.618605276445024}, {0., 
        0.809302638222512}, {0.809302638222512, 0.809302638222512}, {
        2.02325659555628, 0.809302638222512}, {0.809302638222512, 0.}, {
        1.618605276445024, 0.}, {0., 0.}, {2.427907914667536, 0.}}, {
         {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
          LineBox[{1, 4}], LineBox[{2, 7}], LineBox[{5, 3}], 
          {Arrowheads[{{0.5, 0.5, 
              GraphicsBox[{
                GrayLevel[0], 
                InsetBox[
                 BoxData[
                  FormBox[
                   StyleBox["\"3\[Rule]8\"", StripOnInput -> False], 
                   TraditionalForm]], {0, 0}, 
                 ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
                 GrayLevel[1]]}]}, {0, 0}}], ArrowBox[{6, 4}]}, 
          LineBox[{8, 4}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "7"],
           Annotation[#, 7, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{1.01162829777814, 1.618605276445024}, {0., 
         0.809302638222512}, {0.809302638222512, 0.809302638222512}, {
         2.02325659555628, 0.809302638222512}, {0.809302638222512, 0.}, {
         1.618605276445024, 0.}, {0., 0.}, {2.427907914667536, 0.}}]& ],
      AspectRatio->0.816496580927726,
      BaselinePosition->Top,
      FrameTicks->None,
      PlotLabel->FormBox["Automatic", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{0., 1.0116282977781392`}, {0.8093026382225131, 
        0.}, {0.8093026382225122, 0.809302638222512}, {0.8093026382225109, 
        2.02325659555628}, {1.6186052764450243`, 0.8093026382225129}, {
        1.6186052764450234`, 1.618605276445025}, {1.6186052764450252`, 
        8.67466711215488*^-16}, {1.6186052764450227`, 2.427907914667537}}, {
         {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
          LineBox[{1, 4}], LineBox[{2, 7}], LineBox[{5, 3}], 
          {Arrowheads[{{0.5, 0.5, 
              GraphicsBox[{
                GrayLevel[0], 
                InsetBox[
                 BoxData[
                  FormBox[
                   StyleBox["\"3\[Rule]8\"", StripOnInput -> False], 
                   TraditionalForm]], {0, 0}, 
                 ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
                 GrayLevel[1]]}]}, {0, 0}}], ArrowBox[{6, 4}]}, 
          LineBox[{8, 4}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "7"],
           Annotation[#, 7, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{0., 1.0116282977781392`}, {
         0.8093026382225131, 0.}, {0.8093026382225122, 0.809302638222512}, {
         0.8093026382225109, 2.02325659555628}, {1.6186052764450243`, 
         0.8093026382225129}, {1.6186052764450234`, 1.618605276445025}, {
         1.6186052764450252`, 8.67466711215488*^-16}, {1.6186052764450227`, 
         2.427907914667537}}]& ],
      AspectRatio->1.224744871391589,
      BaselinePosition->Top,
      FrameTicks->None,
      PlotLabel->FormBox["Left", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{1.01162829777814, 1.618605276445024}, {0., 
        0.809302638222512}, {0.809302638222512, 0.809302638222512}, {
        2.02325659555628, 0.809302638222512}, {0.809302638222512, 0.}, {
        1.618605276445024, 0.}, {0., 0.}, {2.427907914667536, 0.}}, {
         {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
          LineBox[{1, 4}], LineBox[{2, 7}], LineBox[{5, 3}], 
          {Arrowheads[{{0.5, 0.5, 
              GraphicsBox[{
                GrayLevel[0], 
                InsetBox[
                 BoxData[
                  FormBox[
                   StyleBox["\"3\[Rule]8\"", StripOnInput -> False], 
                   TraditionalForm]], {0, 0}, 
                 ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
                 GrayLevel[1]]}]}, {0, 0}}], ArrowBox[{6, 4}]}, 
          LineBox[{8, 4}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "7"],
           Annotation[#, 7, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{1.01162829777814, 1.618605276445024}, {0., 
         0.809302638222512}, {0.809302638222512, 0.809302638222512}, {
         2.02325659555628, 0.809302638222512}, {0.809302638222512, 0.}, {
         1.618605276445024, 0.}, {0., 0.}, {2.427907914667536, 0.}}]& ],
      AspectRatio->0.816496580927726,
      BaselinePosition->Top,
      FrameTicks->None,
      PlotLabel->FormBox["Top", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]]},
    {
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{1.6186052764450243`, 1.4162796168893963`}, {
        0.809302638222512, 2.4279079146675357`}, {0.8093026382225124, 
        1.618605276445024}, {0.8093026382225126, 0.40465131911125596`}, {
        2.220446049250313*^-16, 1.6186052764450238`}, {6.661338147750939*^-16,
         0.8093026382225119}, {0., 2.4279079146675357`}, {
        8.881784197001252*^-16, 0.}}, {
         {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
          LineBox[{1, 4}], LineBox[{2, 7}], LineBox[{5, 3}], 
          {Arrowheads[{{0.5, 0.5, 
              GraphicsBox[{
                GrayLevel[0], 
                InsetBox[
                 BoxData[
                  FormBox[
                   StyleBox["\"3\[Rule]8\"", StripOnInput -> False], 
                   TraditionalForm]], {0, 0}, 
                 ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
                 GrayLevel[1]]}]}, {0, 0}}], ArrowBox[{6, 4}]}, 
          LineBox[{8, 4}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "7"],
           Annotation[#, 7, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{1.6186052764450243`, 
         1.4162796168893963`}, {0.809302638222512, 2.4279079146675357`}, {
         0.8093026382225124, 1.618605276445024}, {0.8093026382225126, 
         0.40465131911125596`}, {2.220446049250313*^-16, 
         1.6186052764450238`}, {6.661338147750939*^-16, 0.8093026382225119}, {
         0., 2.4279079146675357`}, {8.881784197001252*^-16, 0.}}]& ],
      AspectRatio->1.224744871391589,
      BaselinePosition->Top,
      FrameTicks->None,
      PlotLabel->FormBox["Right", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{1.416279616889397, 0.}, {2.4279079146675366`, 
        0.8093026382225126}, {1.6186052764450245`, 0.8093026382225121}, {
        0.40465131911125685`, 0.8093026382225114}, {1.6186052764450243`, 
        1.618605276445024}, {0.8093026382225119, 1.6186052764450238`}, {
        2.427907914667536, 1.6186052764450247`}, {0., 
        1.6186052764450232`}}, {
         {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
          LineBox[{1, 4}], LineBox[{2, 7}], LineBox[{5, 3}], 
          {Arrowheads[{{0.5, 0.5, 
              GraphicsBox[{
                GrayLevel[0], 
                InsetBox[
                 BoxData[
                  FormBox[
                   StyleBox["\"3\[Rule]8\"", StripOnInput -> False], 
                   TraditionalForm]], {0, 0}, 
                 ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
                 GrayLevel[1]]}]}, {0, 0}}], ArrowBox[{6, 4}]}, 
          LineBox[{8, 4}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "7"],
           Annotation[#, 7, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{1.416279616889397, 0.}, {
         2.4279079146675366`, 0.8093026382225126}, {1.6186052764450245`, 
         0.8093026382225121}, {0.40465131911125685`, 0.8093026382225114}, {
         1.6186052764450243`, 1.618605276445024}, {0.8093026382225119, 
         1.6186052764450238`}, {2.427907914667536, 1.6186052764450247`}, {0., 
         1.6186052764450232`}}]& ],
      AspectRatio->0.816496580927726,
      BaselinePosition->Top,
      FrameTicks->None,
      PlotLabel->FormBox["Bottom", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[
       GraphicsComplexBox[{{1.2241015729675688`, 1.2241015730225262`}, {
        0.6120507865937004, 1.8361523594788318`}, {0.6120507864837844, 
        0.6120507866761367}, {2.089672095976903, 1.2241015728670814`}, {0., 
        3.297471184993128*^-10}, {2.4482031456053903`, 0.}, {
        2.1983193043695337`*^-10, 2.448203145935137}, {2.4482031460450546`, 
        2.4482031456053885`}}, {
         {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{1, 3}], 
          LineBox[{1, 4}], LineBox[{2, 7}], LineBox[{5, 3}], 
          {Arrowheads[{{0.5, 0.5, 
              GraphicsBox[{
                GrayLevel[0], 
                InsetBox[
                 BoxData[
                  FormBox[
                   StyleBox["\"3\[Rule]8\"", StripOnInput -> False], 
                   TraditionalForm]], {0, 0}, 
                 ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
                 GrayLevel[1]]}]}, {0, 0}}], ArrowBox[{6, 4}]}, 
          LineBox[{8, 4}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "7"],
           Annotation[#, 7, "Tooltip"]& ]}}],
       Annotation[#, 
        VertexCoordinateRules -> {{1.2241015729675688`, 
         1.2241015730225262`}, {0.6120507865937004, 1.8361523594788318`}, {
         0.6120507864837844, 0.6120507866761367}, {2.089672095976903, 
         1.2241015728670814`}, {0., 3.297471184993128*^-10}, {
         2.4482031456053903`, 0.}, {2.1983193043695337`*^-10, 
         2.448203145935137}, {2.4482031460450546`, 2.4482031456053885`}}]& ],
      AspectRatio->Automatic,
      BaselinePosition->Top,
      FrameTicks->None,
      PlotLabel->FormBox["Center", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]]}
   }],
  "Grid"]], "Output",
 ImageSize->{470, 429},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->210182402]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8888429],

Cell["Multiclick to move vertices in a graph: ", "ExampleText",
 CellID->455833000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"1", "\[Rule]", "5"}], ",", 
    RowBox[{"1", "\[Rule]", "7"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"3", "\[Rule]", "4"}], ",", 
    RowBox[{"3", "\[Rule]", "8"}], ",", 
    RowBox[{"6", "\[Rule]", "7"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119821187],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.4183300132670378, 1.6733200530681511`}, {
    1.2549900398011133`, 2.5099800796022267`}, {0., 0.8366600265340756}, {
    0.8366600265340756, 0.8366600265340756}, {2.091650066335189, 
    1.6733200530681511`}, {1.6733200530681511`, 0.8366600265340756}, {
    2.5099800796022267`, 0.8366600265340756}, {0.8366600265340756, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {5, 6}, {5, 7}, {8, 4}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.4183300132670378, 1.6733200530681511`}, {
     1.2549900398011133`, 2.5099800796022267`}, {0., 0.8366600265340756}, {
     0.8366600265340756, 0.8366600265340756}, {2.091650066335189, 
     1.6733200530681511`}, {1.6733200530681511`, 0.8366600265340756}, {
     2.5099800796022267`, 0.8366600265340756}, {0.8366600265340756, 0.}}]& ],
  AspectRatio->1.,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->252804765]
}, Open  ]],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.9085604975643475, 1.6032871267399642`}, {
    1.7452205240984227`, 2.4399471532740393`}, {0.49023048429730975`, 
    0.7666271002058888}, {1.3268905108313853`, 0.7666271002058888}, {
    2.581880550632498, 1.6032871267399642`}, {2.1635505373654604`, 
    0.7666271002058888}, {3.000210563899536, 0.7666271002058888}, {
    1.6770551424723206`, -0.05610407142930733}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {5, 6}, {5, 7}, {8, 4}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.4183300132670378, 1.6733200530681511`}, {
     1.2549900398011133`, 2.5099800796022267`}, {0., 0.8366600265340756}, {
     0.8366600265340756, 0.8366600265340756}, {2.091650066335189, 
     1.6733200530681511`}, {1.6733200530681511`, 0.8366600265340756}, {
     2.5099800796022267`, 0.8366600265340756}, {0.8366600265340756, 0.}}]& ],
  AspectRatio->1.,
  FrameTicks->None,
  ImageSize->{196., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Input",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellLabel->"In[2]:=",
 CellID->907421761]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(14)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->463608210],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AspectRatio",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->900310349],

Cell["\<\
By default a suitable aspect ratio is calculated for good visual appearance:\
\>", "ExampleText",
 CellID->1707013097],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "\[Rule]", 
      RowBox[{"RandomInteger", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"i", "-", "1"}]}], "}"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "1", ",", "50"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1173269234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", "g", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2111380344],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{3.610366303100342, 1.4736188992246295`}, {
    0.5894475596898517, 1.1788951193797037`}, {2.6525140186043332`, 
    1.1788951193797037`}, {4.715580477518814, 1.1788951193797037`}, {
    4.273494807751425, 0.8841713395347778}, {5.599751817053592, 
    1.1788951193797037`}, {4.126132917828962, 0.5894475596898519}, {
    1.3262570093021666`, 0.8841713395347778}, {3.5366853581391107`, 
    0.29472377984492604`}, {1.9157045689920182`, 0.8841713395347778}, {
    3.8314091379840365`, 0.29472377984492604`}, {1.7683426790695553`, 
    0.5894475596898519}, {6.041837486820981, 1.1788951193797037`}, {
    2.5788330736431018`, 0.8841713395347778}, {3.094599688371722, 
    0.8841713395347778}, {0.14736188992246294`, 0.8841713395347778}, {
    1.7683426790695553`, 0.29472377984492604`}, {4.126132917828962, 
    0.29472377984492604`}, {6.336561266665907, 1.1788951193797037`}, {
    2.357790238759407, 0.5894475596898519}, {2.063066458914481, 
    0.5894475596898519}, {4.420856697673888, 0.29472377984492604`}, {
    5.452389927131129, 0.8841713395347778}, {4.568218587596351, 
    0.8841713395347778}, {4.862942367441277, 0.8841713395347778}, {
    0.44208566976738883`, 0.8841713395347778}, {4.715580477518814, 
    0.29472377984492604`}, {3.3893234682166478`, 0.8841713395347778}, {
    4.420856697673888, 0.}, {4.420856697673888, 0.5894475596898519}, {
    2.210428348836944, 0.29472377984492604`}, {2.5051521286818703`, 
    0.29472377984492604`}, {3.6840472480615736`, 0.8841713395347778}, {
    0.14736188992246294`, 0.5894475596898519}, {6.041837486820981, 
    0.8841713395347778}, {1.7683426790695553`, 0.}, {0.7368094496123148, 
    0.8841713395347778}, {1.1788951193797035`, 0.5894475596898519}, {
    6.631285046510833, 1.1788951193797037`}, {3.9787710279064994`, 
    0.8841713395347778}, {1.0315332294572406`, 0.8841713395347778}, {
    3.3893234682166478`, 0.5894475596898519}, {0., 0.29472377984492604`}, {
    3.6840472480615736`, 0.5894475596898519}, {0.29472377984492587`, 
    0.29472377984492604`}, {2.799875908526796, 0.5894475596898519}, {
    1.4736188992246295`, 0.5894475596898519}, {5.747113706976055, 
    0.8841713395347778}, {5.1576661472862035`, 0.8841713395347778}, {
    3.094599688371722, 0.5894475596898519}, {2.799875908526796, 
    0.29472377984492604`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 1}, {4, 1}, {5, 4}, {6, 1}, {7, 5}, {8, 3}, {9, 
       7}, {10, 3}, {11, 7}, {12, 10}, {13, 1}, {14, 3}, {15, 3}, {16, 2}, {
       17, 12}, {18, 7}, {19, 1}, {20, 14}, {21, 10}, {22, 7}, {23, 6}, {24, 
       4}, {25, 4}, {26, 2}, {27, 7}, {28, 3}, {29, 22}, {30, 5}, {31, 20}, {
       32, 20}, {33, 3}, {34, 16}, {35, 13}, {36, 17}, {37, 2}, {38, 8}, {39, 
       1}, {40, 3}, {41, 2}, {42, 28}, {43, 34}, {44, 33}, {45, 34}, {46, 
       14}, {47, 8}, {48, 6}, {49, 4}, {50, 15}, {51, 46}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "48"],
       Annotation[#, 48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "50"],
       Annotation[#, 50, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{3.610366303100342, 1.4736188992246295`}, {
     0.5894475596898517, 1.1788951193797037`}, {2.6525140186043332`, 
     1.1788951193797037`}, {4.715580477518814, 1.1788951193797037`}, {
     4.273494807751425, 0.8841713395347778}, {5.599751817053592, 
     1.1788951193797037`}, {4.126132917828962, 0.5894475596898519}, {
     1.3262570093021666`, 0.8841713395347778}, {3.5366853581391107`, 
     0.29472377984492604`}, {1.9157045689920182`, 0.8841713395347778}, {
     3.8314091379840365`, 0.29472377984492604`}, {1.7683426790695553`, 
     0.5894475596898519}, {6.041837486820981, 1.1788951193797037`}, {
     2.5788330736431018`, 0.8841713395347778}, {3.094599688371722, 
     0.8841713395347778}, {0.14736188992246294`, 0.8841713395347778}, {
     1.7683426790695553`, 0.29472377984492604`}, {4.126132917828962, 
     0.29472377984492604`}, {6.336561266665907, 1.1788951193797037`}, {
     2.357790238759407, 0.5894475596898519}, {2.063066458914481, 
     0.5894475596898519}, {4.420856697673888, 0.29472377984492604`}, {
     5.452389927131129, 0.8841713395347778}, {4.568218587596351, 
     0.8841713395347778}, {4.862942367441277, 0.8841713395347778}, {
     0.44208566976738883`, 0.8841713395347778}, {4.715580477518814, 
     0.29472377984492604`}, {3.3893234682166478`, 0.8841713395347778}, {
     4.420856697673888, 0.}, {4.420856697673888, 0.5894475596898519}, {
     2.210428348836944, 0.29472377984492604`}, {2.5051521286818703`, 
     0.29472377984492604`}, {3.6840472480615736`, 0.8841713395347778}, {
     0.14736188992246294`, 0.5894475596898519}, {6.041837486820981, 
     0.8841713395347778}, {1.7683426790695553`, 0.}, {0.7368094496123148, 
     0.8841713395347778}, {1.1788951193797035`, 0.5894475596898519}, {
     6.631285046510833, 1.1788951193797037`}, {3.9787710279064994`, 
     0.8841713395347778}, {1.0315332294572406`, 0.8841713395347778}, {
     3.3893234682166478`, 0.5894475596898519}, {0., 0.29472377984492604`}, {
     3.6840472480615736`, 0.5894475596898519}, {0.29472377984492587`, 
     0.29472377984492604`}, {2.799875908526796, 0.5894475596898519}, {
     1.4736188992246295`, 0.5894475596898519}, {5.747113706976055, 
     0.8841713395347778}, {5.1576661472862035`, 0.8841713395347778}, {
     3.094599688371722, 0.5894475596898519}, {2.799875908526796, 
     0.29472377984492604`}}]& ],
  AspectRatio->0.4714045207910317,
  FrameTicks->None,
  ImageSize->{297., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{301, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1325483815]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->478547557],

Cell["\<\
If self loops exist, an aspect ratio based on the actual coordinates show the \
loop undistorted:\
\>", "ExampleText",
 CellID->59975126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"TreePlot", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "2"}], ",", 
      RowBox[{"2", "\[Rule]", "3"}], ",", 
      RowBox[{"1", "\[Rule]", 
       RowBox[{"2", "\[Rule]", "4"}]}], ",", 
      RowBox[{"2", "\[Rule]", "5"}], ",", 
      RowBox[{"1", "\[Rule]", "1"}]}], "}"}], "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1346485848],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.816496580927726}, {0.816496580927726, 
    1.632993161855452}, {0.816496580927726, 0.816496580927726}, {0., 0.}, {
    1.632993161855452, 0.816496580927726}, {-0.0015596281882097108`, 
    0.8128924928340217}, {-0.03859544528116658, 
    0.7525522805122693}, {-0.09106302499796493, 
    0.7050154942363911}, {-0.15475387019022896`, 
    0.6740951253920164}, {-0.22455925006046268`, 
    0.6622713395368226}, {-0.29487997852631076`, 
    0.6704925388902976}, {-0.3600755326816732, 
    0.6980992896797751}, {-0.41491648694163447`, 
    0.7428772162355454}, {-0.4550039725025825, 
    0.801234619126506}, {-0.4771225166939762, 
    0.8684905703399894}, {-0.4794979604892671, 
    0.9392503769928664}, {-0.4619397662556434, 
    1.0078382971102708`}, {-0.42585630104113137`, 
    1.0687527987407548`}, {-0.3741418695054553, 
    1.1171078454444754`}, {-0.3109445577395409, 
    1.1490248120349722`}, {-0.24133350954204283`, 
    1.161943594470742}, {-0.17089232338302485`, 
    1.1548279593418402`}, {-0.10527118424678644`, 
    1.1282486615851353`}, {-0.04973365447827887, 
    1.084337663441285}, {-0.008734476166238727, 1.0266171268142346`}, {
    0.01443774988206722, 0.9597168957926356}, {0.017924347360772003`, 
    0.8890031304509525}, {0.0014456514630393406`, 0.820147879726791}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 4}, {1, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 1}, {2, 3}, {2, 5}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        RowBox[{"2", "\[Rule]", "4"}]],
       Annotation[#, 2 -> 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.816496580927726}, {0.816496580927726, 
     1.632993161855452}, {0.816496580927726, 0.816496580927726}, {0., 0.}, {
     1.632993161855452, 0.816496580927726}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2104589148]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DirectedEdges",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->203839123],

Cell["Show the direction of edges:", "ExampleText",
 CellID->2036916947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", " ", "6"}], ",", 
     RowBox[{"3", "\[Rule]", " ", "6"}], ",", 
     RowBox[{"4", "\[Rule]", " ", "6"}], ",", 
     RowBox[{"5", "\[Rule]", " ", "6"}]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1851389954],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.}, {1.1547005383792515`, 
    0.5773502691896257}, {0.5773502691896257, 0.}, {1.1547005383792515`, 
    0.}, {1.7320508075688772`, 0.}, {2.309401076758503, 0.}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.0321077484548308, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{3, 2}], ArrowBox[{4, 2}], ArrowBox[{5, 2}], 
      ArrowBox[{6, 2}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.}, {1.1547005383792515`, 
     0.5773502691896257}, {0.5773502691896257, 0.}, {1.1547005383792515`, 
     0.}, {1.7320508075688772`, 0.}, {2.309401076758503, 0.}}]& ],
  AspectRatio->0.5,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 91},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->387529401]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "EdgeLabeling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->238189510],

Cell["By default edge labels are shown:", "ExampleText",
 CellID->825767658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "5"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"2", "\[Rule]", "4"}], ",", 
    RowBox[{"3", "\[Rule]", "7"}], ",", 
    RowBox[{"5", "\[Rule]", "6"}], ",", 
    RowBox[{"6", "\[Rule]", "7"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"6", "\[Rule]", "8"}], ",", "\"\<6\[Rule]8\>\""}], "}"}]}], 
   "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->612297678],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.9008852329229017, 0.}, {0.9008852329229017, 
    0.9008852329229013}, {0., 0.9008852329229013}, {0., 
    1.8017704658458031`}, {0., 0.}, {0.6756639246921762, 
    2.7026556987687047`}, {1.3513278493843524`, 1.8017704658458031`}, {
    1.8017704658458034`, 0.9008852329229013}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{2, 7}], 
      LineBox[{3, 4}], LineBox[{3, 5}], LineBox[{4, 6}], LineBox[{7, 6}], 
      {Arrowheads[{{0.5, 0.5, 
          GraphicsBox[{
            GrayLevel[0], 
            InsetBox[
             BoxData[
              FormBox[
               StyleBox["\"6\[Rule]8\"", StripOnInput -> False], 
               TraditionalForm]], {0, 0}, 
             ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
             GrayLevel[1]]}]}, {0, 0}}], ArrowBox[{7, 8}]}}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.9008852329229017, 0.}, {0.9008852329229017, 
     0.9008852329229013}, {0., 0.9008852329229013}, {0., 
     1.8017704658458031`}, {0., 0.}, {0.6756639246921762, 
     2.7026556987687047`}, {1.3513278493843524`, 1.8017704658458031`}, {
     1.8017704658458034`, 0.9008852329229013}}]& ],
  AspectRatio->1.224744871391589,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{181, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2046198038]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1515268568],

Cell["Displays the edge label as a tooltip:", "ExampleText",
 CellID->384406038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"6", "\[Rule]", "8"}], ",", "\"\<6\[Rule]8\>\""}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"EdgeLabeling", "\[Rule]", " ", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->349905032],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.9008852329229017, 0.}, {0.9008852329229017, 
    0.9008852329229013}, {0., 0.9008852329229013}, {0., 
    1.8017704658458031`}, {0., 0.}, {0.6756639246921762, 
    2.7026556987687047`}, {1.3513278493843524`, 1.8017704658458031`}, {
    1.8017704658458034`, 0.9008852329229013}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{2, 7}], 
      LineBox[{3, 4}], LineBox[{3, 5}], LineBox[{4, 6}], LineBox[{7, 6}], 
      TagBox[
       TooltipBox[LineBox[{7, 8}],
        "\"6\[Rule]8\""],
       Annotation[#, "6\[Rule]8", "Tooltip"]& ]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.9008852329229017, 0.}, {0.9008852329229017, 
     0.9008852329229013}, {0., 0.9008852329229013}, {0., 
     1.8017704658458031`}, {0., 0.}, {0.6756639246921762, 
     2.7026556987687047`}, {1.3513278493843524`, 1.8017704658458031`}, {
     1.8017704658458034`, 0.9008852329229013}}]& ],
  AspectRatio->1.224744871391589,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{181, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1014724403]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2141000564],

Cell["Displays the edge label both explicitly and as a tooltip:", \
"ExampleText",
 CellID->2014701195],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"6", "\[Rule]", "8"}], ",", "\"\<6\[Rule]8\>\""}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"EdgeLabeling", "\[Rule]", " ", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->682974758],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.9008852329229017, 0.}, {0.9008852329229017, 
    0.9008852329229013}, {0., 0.9008852329229013}, {0., 
    1.8017704658458031`}, {0., 0.}, {0.6756639246921762, 
    2.7026556987687047`}, {1.3513278493843524`, 1.8017704658458031`}, {
    1.8017704658458034`, 0.9008852329229013}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{1, 2}], LineBox[{2, 7}], 
      LineBox[{3, 4}], LineBox[{3, 5}], LineBox[{4, 6}], LineBox[{7, 6}], 
      TagBox[
       TooltipBox[
        {Arrowheads[{{0.5, 0.5, 
            GraphicsBox[{
              GrayLevel[0], 
              InsetBox[
               BoxData[
                FormBox[
                 StyleBox["\"6\[Rule]8\"", StripOnInput -> False], 
                 TraditionalForm]], {0, 0}, 
               ImageScaled[{0.5, 0.5}], Automatic, None, Background -> 
               GrayLevel[1]]}]}, {0, 0}}], ArrowBox[{7, 8}]},
        "\"6\[Rule]8\""],
       Annotation[#, "6\[Rule]8", "Tooltip"]& ]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.9008852329229017, 0.}, {0.9008852329229017, 
     0.9008852329229013}, {0., 0.9008852329229013}, {0., 
     1.8017704658458031`}, {0., 0.}, {0.6756639246921762, 
     2.7026556987687047`}, {1.3513278493843524`, 1.8017704658458031`}, {
     1.8017704658458034`, 0.9008852329229013}}]& ],
  AspectRatio->1.224744871391589,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{181, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1052846637]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "EdgeRenderingFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->65693485],

Cell["Change the setbacks used for arrows:", "ExampleText",
 CellID->170649085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"6", "\[Rule]", "8"}], ",", 
     RowBox[{"6", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Arrow", "[", 
       RowBox[{"#1", ",", "0.1"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->474579552],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{
      ArrowBox[{{0.9008852329229016, 0.}, {0.9008852329229016, 
       0.9008852329229016}}, 0.1], 
      ArrowBox[{{0.9008852329229016, 0.9008852329229016}, {
       1.3513278493843524`, 1.8017704658458031`}}, 0.1], 
      ArrowBox[{{0., 0.9008852329229016}, {0., 1.8017704658458031`}}, 0.1], 
      ArrowBox[{{0., 0.9008852329229016}, {0., 0.}}, 0.1], 
      ArrowBox[{{0., 1.8017704658458031`}, {0.6756639246921762, 
       2.7026556987687047`}}, 0.1], 
      ArrowBox[{{1.3513278493843524`, 1.8017704658458031`}, {
       0.6756639246921762, 2.7026556987687047`}}, 0.1], 
      ArrowBox[{{1.3513278493843524`, 1.8017704658458031`}, {
       1.8017704658458031`, 0.9008852329229016}}, 0.1], 
      ArrowBox[{{1.3513278493843524`, 1.8017704658458031`}, {
       1.3326857443111677`, 1.859696892703093}, {1.3211245596369883`, 
       1.9233871781578011`}, {1.3265564040610418`, 1.9878899573113042`}, {
       1.3486060844708347`, 2.048749837743315}, {1.385750566041251, 
       2.1017630525226294`}, {1.43542417262909, 2.1432678264761074`}, {
       1.4941958054013376`, 2.1703973055285477`}, {1.558005938696964, 
       2.181277578556696}, {1.6224470231366444`, 2.175157113818565}, {
       1.6830679277313654`, 2.1524586694117245`}, {1.7356813922981282`, 
       2.1147500921559503`}, {1.7766532535603723`, 2.0646360219053697`}, {
       1.803153467254758, 2.005577981584643}, {1.8133515874256314`, 
       1.9416552798476772`}, {1.8065432005902444`, 1.8772832414997078`}, {
       1.783198581603399, 1.8169082283176659`}, {1.7449302104210516`, 
       1.7647005160576679`}, {1.6943813934734062`, 1.7242662415177907`}, {
       1.6350436828895127`, 1.6983983163007428`}, {1.5710157049524878`, 
       1.6888835123790358`}, {1.5067200561974048`, 1.6963790446173561`}, {
       1.4465978219523719`, 1.7203671750521792`}, {1.394801817805513, 
       1.7591909745415557`}, {1.3513278493843524`, 1.8017704658458031`}}, 
       0.1]}, GraphicsComplexBox[{{0.9008852329229016, 0.}, {
      0.9008852329229016, 0.9008852329229016}, {0., 0.9008852329229016}, {0., 
      1.8017704658458031`}, {0., 0.}, {0.6756639246921762, 
      2.7026556987687047`}, {1.3513278493843524`, 1.8017704658458031`}, {
      1.8017704658458031`, 0.9008852329229016}, {1.3326857443111677`, 
      1.859696892703093}, {1.3211245596369883`, 1.9233871781578011`}, {
      1.3265564040610418`, 1.9878899573113042`}, {1.3486060844708347`, 
      2.048749837743315}, {1.385750566041251, 2.1017630525226294`}, {
      1.43542417262909, 2.1432678264761074`}, {1.4941958054013376`, 
      2.1703973055285477`}, {1.558005938696964, 2.181277578556696}, {
      1.6224470231366444`, 2.175157113818565}, {1.6830679277313654`, 
      2.1524586694117245`}, {1.7356813922981282`, 2.1147500921559503`}, {
      1.7766532535603723`, 2.0646360219053697`}, {1.803153467254758, 
      2.005577981584643}, {1.8133515874256314`, 1.9416552798476772`}, {
      1.8065432005902444`, 1.8772832414997078`}, {1.783198581603399, 
      1.8169082283176659`}, {1.7449302104210516`, 1.7647005160576679`}, {
      1.6943813934734062`, 1.7242662415177907`}, {1.6350436828895127`, 
      1.6983983163007428`}, {1.5710157049524878`, 1.6888835123790358`}, {
      1.5067200561974048`, 1.6963790446173561`}, {1.4465978219523719`, 
      1.7203671750521792`}, {1.394801817805513, 1.7591909745415557`}}, 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[PointBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[6],
         "7"],
        Annotation[#, 7, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[7],
         "6"],
        Annotation[#, 6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[8],
         "8"],
        Annotation[#, 8, "Tooltip"]& ]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0.9008852329229016, 0.}, {0.9008852329229016, 
     0.9008852329229016}, {0., 0.9008852329229016}, {0., 
     1.8017704658458031`}, {0., 0.}, {0.6756639246921762, 
     2.7026556987687047`}, {1.3513278493843524`, 1.8017704658458031`}, {
     1.8017704658458031`, 0.9008852329229016}}]& ],
  AspectRatio->1.2208276391619122`,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{181, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->138669109]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141508825],

Cell["Draw self-loops as red arrows and otherwise gray: ", "ExampleText",
 CellID->2122510440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"6", "\[Rule]", "8"}], ",", 
     RowBox[{"6", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", " ", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"First", "[", "#2", "]"}], "\[Equal]", 
         RowBox[{"Last", "[", "#2", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"Red", ",", " ", 
          RowBox[{"Arrow", "[", "#1", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"GrayLevel", "[", "0.5", "]"}], ",", " ", 
          RowBox[{"Arrow", "[", "#1", "]"}]}], "}"}]}], "]"}], "&"}], 
     ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1956840094],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{
      {GrayLevel[0.5], 
       ArrowBox[{{0.9008852329229017, 0.}, {0.9008852329229017, 
        0.9008852329229013}}]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0.9008852329229017, 0.9008852329229013}, {
        1.3513278493843524`, 1.8017704658458031`}}]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0., 0.9008852329229013}, {0., 1.8017704658458031`}}]}, 
      {GrayLevel[0.5], ArrowBox[{{0., 0.9008852329229013}, {0., 0.}}]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{0., 1.8017704658458031`}, {0.6756639246921762, 
        2.7026556987687047`}}]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{1.3513278493843524`, 1.8017704658458031`}, {
        0.6756639246921762, 2.7026556987687047`}}]}, 
      {GrayLevel[0.5], 
       ArrowBox[{{1.3513278493843524`, 1.8017704658458031`}, {
        1.8017704658458034`, 0.9008852329229013}}]}, 
      {RGBColor[1, 0, 0], 
       ArrowBox[{{1.3513278493843524`, 1.8017704658458031`}, {
        1.3326857443111668`, 1.8596968927030926`}, {1.3211245596369874`, 
        1.923387178157801}, {1.326556404061041, 1.987889957311304}, {
        1.3486060844708339`, 2.048749837743315}, {1.3857505660412504`, 
        2.1017630525226294`}, {1.4354241726290893`, 2.1432678264761074`}, {
        1.494195805401337, 2.1703973055285477`}, {1.5580059386969636`, 
        2.181277578556696}, {1.622447023136644, 2.1751571138185652`}, {
        1.6830679277313652`, 2.1524586694117245`}, {1.735681392298128, 
        2.114750092155951}, {1.7766532535603723`, 2.06463602190537}, {
        1.803153467254758, 2.005577981584643}, {1.8133515874256314`, 
        1.941655279847677}, {1.8065432005902444`, 1.8772832414997074`}, {
        1.783198581603399, 1.8169082283176654`}, {1.7449302104210513`, 
        1.7647005160576674`}, {1.694381393473406, 1.72426624151779}, {
        1.6350436828895125`, 1.6983983163007421`}, {1.5710157049524873`, 
        1.688883512379035}, {1.5067200561974041`, 1.6963790446173554`}, {
        1.4465978219523712`, 1.7203671750521785`}, {1.3948018178055124`, 
        1.759190974541555}, {1.3513278493843524`, 1.8017704658458031`}}]}}, 
     GraphicsComplexBox[{{0.9008852329229017, 0.}, {0.9008852329229017, 
      0.9008852329229013}, {0., 0.9008852329229013}, {0., 
      1.8017704658458031`}, {0., 0.}, {0.6756639246921762, 
      2.7026556987687047`}, {1.3513278493843524`, 1.8017704658458031`}, {
      1.8017704658458034`, 0.9008852329229013}, {1.3326857443111668`, 
      1.8596968927030926`}, {1.3211245596369874`, 1.923387178157801}, {
      1.326556404061041, 1.987889957311304}, {1.3486060844708339`, 
      2.048749837743315}, {1.3857505660412504`, 2.1017630525226294`}, {
      1.4354241726290893`, 2.1432678264761074`}, {1.494195805401337, 
      2.1703973055285477`}, {1.5580059386969636`, 2.181277578556696}, {
      1.622447023136644, 2.1751571138185652`}, {1.6830679277313652`, 
      2.1524586694117245`}, {1.735681392298128, 2.114750092155951}, {
      1.7766532535603723`, 2.06463602190537}, {1.803153467254758, 
      2.005577981584643}, {1.8133515874256314`, 1.941655279847677}, {
      1.8065432005902444`, 1.8772832414997074`}, {1.783198581603399, 
      1.8169082283176654`}, {1.7449302104210513`, 1.7647005160576674`}, {
      1.694381393473406, 1.72426624151779}, {1.6350436828895125`, 
      1.6983983163007421`}, {1.5710157049524873`, 1.688883512379035}, {
      1.5067200561974041`, 1.6963790446173554`}, {1.4465978219523712`, 
      1.7203671750521785`}, {1.3948018178055124`, 1.759190974541555}}, 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[PointBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[6],
         "7"],
        Annotation[#, 7, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[7],
         "6"],
        Annotation[#, 6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[8],
         "8"],
        Annotation[#, 8, "Tooltip"]& ]}]}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.9008852329229017, 0.}, {0.9008852329229017, 
     0.9008852329229013}, {0., 0.9008852329229013}, {0., 
     1.8017704658458031`}, {0., 0.}, {0.6756639246921762, 
     2.7026556987687047`}, {1.3513278493843524`, 1.8017704658458031`}, {
     1.8017704658458034`, 0.9008852329229013}}]& ],
  AspectRatio->1.2208276391619122`,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{181, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->644227865]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->420690581],

Cell["Use a custom arrow head: ", "ExampleText",
 CellID->293080936],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"h", "=", 
  RowBox[{"Graphics", "[", 
   RowBox[{"Line", "[", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}]}], "}"}]}], "}"}], "}"}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->874236904],

Cell[BoxData[
 GraphicsBox[
  LineBox[NCache[{{{-1, Rational[1, 2]}, {0, 
      0}, {-1, Rational[-1, 2]}}}, {{{-1, 0.5}, {0, 
      0}, {-1, -0.5}}}]]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->172613196]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"6", "\[Rule]", "8"}], ",", 
     RowBox[{"6", "\[Rule]", "6"}]}], "}"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Arrowheads", "[", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{"Automatic", ",", "Automatic", ",", "h"}], "}"}], "}"}], 
         "]"}], ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"#1", ",", "0.1"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->183329943],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{
      {Arrowheads[{{Automatic, Automatic, 
          GraphicsBox[
           LineBox[
            NCache[{{{-1, 
                Rational[1, 2]}, {0, 0}, {-1, 
                Rational[-1, 2]}}}, {{{-1, 0.5}, {0, 0}, {-1, -0.5}}}]]]}}], 
       ArrowBox[{{0.9008852329229016, 0.}, {0.9008852329229016, 
        0.9008852329229016}}, 0.1]}, 
      {Arrowheads[{{Automatic, Automatic, 
          GraphicsBox[
           LineBox[
            NCache[{{{-1, 
                Rational[1, 2]}, {0, 0}, {-1, 
                Rational[-1, 2]}}}, {{{-1, 0.5}, {0, 0}, {-1, -0.5}}}]]]}}], 
       ArrowBox[{{0.9008852329229016, 0.9008852329229016}, {
        1.3513278493843524`, 1.8017704658458031`}}, 0.1]}, 
      {Arrowheads[{{Automatic, Automatic, 
          GraphicsBox[
           LineBox[
            NCache[{{{-1, 
                Rational[1, 2]}, {0, 0}, {-1, 
                Rational[-1, 2]}}}, {{{-1, 0.5}, {0, 0}, {-1, -0.5}}}]]]}}], 
       ArrowBox[{{0., 0.9008852329229016}, {0., 1.8017704658458031`}}, 
        0.1]}, 
      {Arrowheads[{{Automatic, Automatic, 
          GraphicsBox[
           LineBox[
            NCache[{{{-1, 
                Rational[1, 2]}, {0, 0}, {-1, 
                Rational[-1, 2]}}}, {{{-1, 0.5}, {0, 0}, {-1, -0.5}}}]]]}}], 
       ArrowBox[{{0., 0.9008852329229016}, {0., 0.}}, 0.1]}, 
      {Arrowheads[{{Automatic, Automatic, 
          GraphicsBox[
           LineBox[
            NCache[{{{-1, 
                Rational[1, 2]}, {0, 0}, {-1, 
                Rational[-1, 2]}}}, {{{-1, 0.5}, {0, 0}, {-1, -0.5}}}]]]}}], 
       ArrowBox[{{0., 1.8017704658458031`}, {0.6756639246921762, 
        2.7026556987687047`}}, 0.1]}, 
      {Arrowheads[{{Automatic, Automatic, 
          GraphicsBox[
           LineBox[
            NCache[{{{-1, 
                Rational[1, 2]}, {0, 0}, {-1, 
                Rational[-1, 2]}}}, {{{-1, 0.5}, {0, 0}, {-1, -0.5}}}]]]}}], 
       ArrowBox[{{1.3513278493843524`, 1.8017704658458031`}, {
        0.6756639246921762, 2.7026556987687047`}}, 0.1]}, 
      {Arrowheads[{{Automatic, Automatic, 
          GraphicsBox[
           LineBox[
            NCache[{{{-1, 
                Rational[1, 2]}, {0, 0}, {-1, 
                Rational[-1, 2]}}}, {{{-1, 0.5}, {0, 0}, {-1, -0.5}}}]]]}}], 
       ArrowBox[{{1.3513278493843524`, 1.8017704658458031`}, {
        1.8017704658458031`, 0.9008852329229016}}, 0.1]}, 
      {Arrowheads[{{Automatic, Automatic, 
          GraphicsBox[
           LineBox[
            NCache[{{{-1, 
                Rational[1, 2]}, {0, 0}, {-1, 
                Rational[-1, 2]}}}, {{{-1, 0.5}, {0, 0}, {-1, -0.5}}}]]]}}], 
       ArrowBox[{{1.3513278493843524`, 1.8017704658458031`}, {
        1.3326857443111677`, 1.859696892703093}, {1.3211245596369883`, 
        1.9233871781578011`}, {1.3265564040610418`, 1.9878899573113042`}, {
        1.3486060844708347`, 2.048749837743315}, {1.385750566041251, 
        2.1017630525226294`}, {1.43542417262909, 2.1432678264761074`}, {
        1.4941958054013376`, 2.1703973055285477`}, {1.558005938696964, 
        2.181277578556696}, {1.6224470231366444`, 2.175157113818565}, {
        1.6830679277313654`, 2.1524586694117245`}, {1.7356813922981282`, 
        2.1147500921559503`}, {1.7766532535603723`, 2.0646360219053697`}, {
        1.803153467254758, 2.005577981584643}, {1.8133515874256314`, 
        1.9416552798476772`}, {1.8065432005902444`, 1.8772832414997078`}, {
        1.783198581603399, 1.8169082283176659`}, {1.7449302104210516`, 
        1.7647005160576679`}, {1.6943813934734062`, 1.7242662415177907`}, {
        1.6350436828895127`, 1.6983983163007428`}, {1.5710157049524878`, 
        1.6888835123790358`}, {1.5067200561974048`, 1.6963790446173561`}, {
        1.4465978219523719`, 1.7203671750521792`}, {1.394801817805513, 
        1.7591909745415557`}, {1.3513278493843524`, 1.8017704658458031`}}, 
        0.1]}}, 
     GraphicsComplexBox[{{0.9008852329229016, 0.}, {0.9008852329229016, 
      0.9008852329229016}, {0., 0.9008852329229016}, {0., 
      1.8017704658458031`}, {0., 0.}, {0.6756639246921762, 
      2.7026556987687047`}, {1.3513278493843524`, 1.8017704658458031`}, {
      1.8017704658458031`, 0.9008852329229016}, {1.3326857443111677`, 
      1.859696892703093}, {1.3211245596369883`, 1.9233871781578011`}, {
      1.3265564040610418`, 1.9878899573113042`}, {1.3486060844708347`, 
      2.048749837743315}, {1.385750566041251, 2.1017630525226294`}, {
      1.43542417262909, 2.1432678264761074`}, {1.4941958054013376`, 
      2.1703973055285477`}, {1.558005938696964, 2.181277578556696}, {
      1.6224470231366444`, 2.175157113818565}, {1.6830679277313654`, 
      2.1524586694117245`}, {1.7356813922981282`, 2.1147500921559503`}, {
      1.7766532535603723`, 2.0646360219053697`}, {1.803153467254758, 
      2.005577981584643}, {1.8133515874256314`, 1.9416552798476772`}, {
      1.8065432005902444`, 1.8772832414997078`}, {1.783198581603399, 
      1.8169082283176659`}, {1.7449302104210516`, 1.7647005160576679`}, {
      1.6943813934734062`, 1.7242662415177907`}, {1.6350436828895127`, 
      1.6983983163007428`}, {1.5710157049524878`, 1.6888835123790358`}, {
      1.5067200561974048`, 1.6963790446173561`}, {1.4465978219523719`, 
      1.7203671750521792`}, {1.394801817805513, 1.7591909745415557`}}, 
      {RGBColor[0, 0, 0.7], 
       TagBox[
        TooltipBox[PointBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[6],
         "7"],
        Annotation[#, 7, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[7],
         "6"],
        Annotation[#, 6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[8],
         "8"],
        Annotation[#, 8, "Tooltip"]& ]}]},
    ContentSelectable->True],
   Annotation[#, 
    VertexCoordinateRules -> {{0.9008852329229016, 0.}, {0.9008852329229016, 
     0.9008852329229016}, {0., 0.9008852329229016}, {0., 
     1.8017704658458031`}, {0., 0.}, {0.6756639246921762, 
     2.7026556987687047`}, {1.3513278493843524`, 1.8017704658458031`}, {
     1.8017704658458031`, 0.9008852329229016}}]& ],
  AspectRatio->1.2208276391619122`,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{181, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->633509661]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->332586483],

Cell["Draw vertices only:", "ExampleText",
 CellID->26472224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", "10", "}"}], ",", 
     RowBox[{"{", "10", "}"}]}], "]"}], ",", " ", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1020060192],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.0873205644391246`, 0.27183014110978115`}, {0.,
     0.}, {0.27183014110978115`, 0.}, {0.5436602822195623, 0.}, {
    0.8154904233293435, 0.}, {1.0873205644391246`, 0.}, {1.3591507055489058`, 
    0.}, {1.630980846658687, 0.}, {1.9028109877684682`, 0.}, {
    2.1746411288782492`, 0.}}, {
     {RGBColor[0.5, 0., 0.]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.0873205644391246`, 0.27183014110978115`}, {
     0., 0.}, {0.27183014110978115`, 0.}, {0.5436602822195623, 0.}, {
     0.8154904233293435, 0.}, {1.0873205644391246`, 0.}, {1.3591507055489058`,
      0.}, {1.630980846658687, 0.}, {1.9028109877684682`, 0.}, {
     2.1746411288782492`, 0.}}]& ],
  AspectRatio->0.3535533905932738,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1405805230]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "LayerSizeFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->230110335],

Cell["Draw a tree with the first level of height 1, second 2:", "ExampleText",
 CellID->1920904431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}]}], "}"}], ",", 
   RowBox[{"LayerSizeFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"#", "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->269954683],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.8017837257372732, 1.6035674514745464`}, {
    0.2672612419124244, 1.0690449676496976`}, {1.3363062095621219`, 
    1.0690449676496976`}, {0., 0.}, {0.5345224838248488, 0.}, {
    1.0690449676496976`, 0.}, {1.6035674514745464`, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {2, 4}, {2, 5}, {3, 6}, {3, 7}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.8017837257372732, 1.6035674514745464`}, {
     0.2672612419124244, 1.0690449676496976`}, {1.3363062095621219`, 
     1.0690449676496976`}, {0., 0.}, {0.5345224838248488, 0.}, {
     1.0690449676496976`, 0.}, {1.6035674514745464`, 0.}}]& ],
  AspectRatio->1.,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->706441802]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25972127],

Cell["Plot a binary tree with random layer size:", "ExampleText",
 CellID->324456243],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i", "\[Rule]", " ", 
        RowBox[{
         RowBox[{"2", "i"}], "+", "j", "-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{
         RowBox[{"2", "^", "7"}], "-", "1"}]}], "}"}]}], "]"}], "]"}], ",", 
   "Center", ",", 
   RowBox[{"LayerSizeFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"RandomReal", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "4"}], ",", "4"}], "}"}], "]"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->157182503],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJw1lgk4lXkbxo+DbJF9aaTT0CRTIpqk5f0rylroFJKTtIwUqklhGpEsH7Ll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    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 7}, {3, 6}, {3, 13}, {4, 5}, {4, 
       10}, {5, 9}, {5, 19}, {6, 12}, {6, 25}, {7, 8}, {7, 16}, {8, 15}, {8, 
       31}, {9, 18}, {9, 37}, {10, 11}, {10, 22}, {11, 21}, {11, 43}, {12, 
       24}, {12, 49}, {13, 14}, {13, 28}, {14, 27}, {14, 55}, {15, 30}, {15, 
       61}, {16, 17}, {16, 34}, {17, 33}, {17, 67}, {18, 36}, {18, 73}, {19, 
       20}, {19, 40}, {20, 39}, {20, 79}, {21, 42}, {21, 85}, {22, 23}, {22, 
       46}, {23, 45}, {23, 91}, {24, 48}, {24, 97}, {25, 26}, {25, 52}, {26, 
       51}, {26, 103}, {27, 54}, {27, 109}, {28, 29}, {28, 58}, {29, 57}, {29,
        115}, {30, 60}, {30, 121}, {31, 32}, {31, 64}, {32, 63}, {32, 127}, {
       33, 66}, {33, 133}, {34, 35}, {34, 70}, {35, 69}, {35, 139}, {36, 
       72}, {36, 145}, {37, 38}, {37, 76}, {38, 75}, {38, 151}, {39, 78}, {39,
        157}, {40, 41}, {40, 82}, {41, 81}, {41, 163}, {42, 84}, {42, 169}, {
       43, 44}, {43, 88}, {44, 87}, {44, 175}, {45, 90}, {45, 181}, {46, 
       47}, {46, 94}, {47, 93}, {47, 187}, {48, 96}, {48, 192}, {49, 50}, {49,
        100}, {50, 99}, {50, 194}, {51, 102}, {51, 196}, {52, 53}, {52, 
       106}, {53, 105}, {53, 198}, {54, 108}, {54, 200}, {55, 56}, {55, 
       112}, {56, 111}, {56, 202}, {57, 114}, {57, 204}, {58, 59}, {58, 
       118}, {59, 117}, {59, 206}, {60, 120}, {60, 208}, {61, 62}, {61, 
       124}, {62, 123}, {62, 210}, {63, 126}, {63, 212}, {64, 65}, {64, 
       130}, {65, 129}, {65, 214}, {66, 132}, {66, 216}, {67, 68}, {67, 
       136}, {68, 135}, {68, 218}, {69, 138}, {69, 220}, {70, 71}, {70, 
       142}, {71, 141}, {71, 222}, {72, 144}, {72, 224}, {73, 74}, {73, 
       148}, {74, 147}, {74, 226}, {75, 150}, {75, 228}, {76, 77}, {76, 
       154}, {77, 153}, {77, 230}, {78, 156}, {78, 232}, {79, 80}, {79, 
       160}, {80, 159}, {80, 234}, {81, 162}, {81, 236}, {82, 83}, {82, 
       166}, {83, 165}, {83, 238}, {84, 168}, {84, 240}, {85, 86}, {85, 
       172}, {86, 171}, {86, 242}, {87, 174}, {87, 244}, {88, 89}, {88, 
       178}, {89, 177}, {89, 246}, {90, 180}, {90, 248}, {91, 92}, {91, 
       184}, {92, 183}, {92, 250}, {93, 186}, {93, 252}, {94, 95}, {94, 
       190}, {95, 189}, {95, 254}, {97, 98}, {97, 193}, {100, 101}, {100, 
       195}, {103, 104}, {103, 197}, {106, 107}, {106, 199}, {109, 110}, {109,
        201}, {112, 113}, {112, 203}, {115, 116}, {115, 205}, {118, 119}, {
       118, 207}, {121, 122}, {121, 209}, {124, 125}, {124, 211}, {127, 
       128}, {127, 213}, {130, 131}, {130, 215}, {133, 134}, {133, 217}, {136,
        137}, {136, 219}, {139, 140}, {139, 221}, {142, 143}, {142, 223}, {
       145, 146}, {145, 225}, {148, 149}, {148, 227}, {151, 152}, {151, 
       229}, {154, 155}, {154, 231}, {157, 158}, {157, 233}, {160, 161}, {160,
        235}, {163, 164}, {163, 237}, {166, 167}, {166, 239}, {169, 170}, {
       169, 241}, {172, 173}, {172, 243}, {175, 176}, {175, 245}, {178, 
       179}, {178, 247}, {181, 182}, {181, 249}, {184, 185}, {184, 251}, {187,
        188}, {187, 253}, {190, 191}, {190, 255}}]}, 
     {RGBColor[0, 0, 0.7], 
      PointBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
        19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
       36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53,
        54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
       71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88,
        89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 
       105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 
       119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 
       133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 
       147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 
       161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 
       175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 
       189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 
       203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 
       217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 
       231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 
       245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255}]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw1lgk4lXkbxo+DbJF9aaTT0CRTIpqk5f0rylroFJKTtIwUqklhGpEsH7Ll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     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->131380172]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "MultiedgeStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->100942717],

Cell["Spreads multiple edges by a specified scaled distance:", "ExampleText",
 CellID->1029865650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"TreePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "6"}], ",", 
       RowBox[{"1", "\[Rule]", "7"}], ",", 
       RowBox[{"2", "\[Rule]", "3"}], ",", 
       RowBox[{"3", "\[Rule]", "4"}], ",", 
       RowBox[{"3", "\[Rule]", "5"}], ",", 
       RowBox[{"4", "\[Rule]", "6"}], ",", 
       RowBox[{"4", "\[Rule]", "8"}], ",", 
       RowBox[{"4", "\[Rule]", "8"}]}], "}"}], ",", 
     RowBox[{"MultiedgeStyle", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "/", "5."}], ",", 
       RowBox[{"1", "/", "4."}], ",", 
       RowBox[{"1", "/", "3."}], ",", 
       RowBox[{"1", "/", "2."}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40554687],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0., 1.7517114918515921`}, {0.6568918094443471, 
      2.6275672377773884`}, {0., 0.8758557459257961}, {0.4379278729628981, 
      0.}, {0.8758557459257962, 0.8758557459257961}, {1.3137836188886942`, 
      1.7517114918515921`}, {1.3137836188886942`, 0.}, {1.7517114918515924`, 
      0.8758557459257961}, {1.4106158486188989`, 1.6790873195539386`}, {
      1.4320341729463026`, 1.6618865992129064`}, {1.4522670687524666`, 
      1.6433059823086922`}, {1.4712258042493993`, 1.6234269545255835`}, {
      1.4888272355058112`, 1.6023366957559508`}, {1.5049941710765655`, 
      1.580127697771005}, {1.5196557105273754`, 1.5568973585961972`}, {
      1.5327475553701435`, 1.532747555370143}, {1.7079187045553028`, 
      1.182405256999825}, {1.7193834402304853`, 1.1574418991899778`}, {
      1.7291707878998455`, 1.1317744641244452`}, {1.7372378249453495`, 
      1.105515516876874}, {1.7435491732072086`, 1.0787802166099651`}, {
      1.7480771541355358`, 1.0516858115425538`}, {1.750801910175209, 
      1.024351124755094}, {1.7517114918515926`, 0.9968960330885517}, {
      1.3137836188886942`, 1.6306712046888365`}, {1.3146932005650778`, 
      1.6032161130222942`}, {1.317417956604751, 1.5758814262348344`}, {
      1.3219459375330784`, 1.5487870211674233`}, {1.328257285794937, 
      1.522051720900514}, {1.3363243228404416`, 1.495792773652943}, {
      1.3461116705098015`, 1.4701253385874105`}, {1.357576406184984, 
      1.4451619807775633`}, {1.5327475553701433`, 1.0948196824072451`}, {
      1.5458394002129114`, 1.070669879181191}, {1.5605009396637215`, 
      1.0474395400063832`}, {1.5766678752344758`, 1.0252305420214374`}, {
      1.5942693064908877`, 1.0041402832518047`}, {1.6132280419878202`, 
      0.9842612554686961}, {1.6334609377939842`, 0.9656806385644818}, {
      1.654879262121388, 0.9484799182234496}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {4, 5}, {5, 6}, {5, 7}, {6, 2}, {6, 9, 10, 
          11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 8}, {6, 25, 
          26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 8}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "8"],
         Annotation[#, 8, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 1.7517114918515921`}, {
       0.6568918094443471, 2.6275672377773884`}, {0., 0.8758557459257961}, {
       0.4379278729628981, 0.}, {0.8758557459257962, 0.8758557459257961}, {
       1.3137836188886942`, 1.7517114918515921`}, {1.3137836188886942`, 0.}, {
       1.7517114918515924`, 0.8758557459257961}}]& ],
    AspectRatio->1.224744871391589,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0., 1.7517114918515921`}, {0.6568918094443471, 
      2.6275672377773884`}, {0., 0.8758557459257961}, {0.4379278729628981, 
      0.}, {0.8758557459257962, 0.8758557459257961}, {1.3137836188886942`, 
      1.7517114918515921`}, {1.3137836188886942`, 0.}, {1.7517114918515924`, 
      0.8758557459257961}, {1.4272946906734523`, 1.6823436146497956`}, {
      1.4499526840505106`, 1.667223660045798}, {1.4713332816490206`, 
      1.6503456347634273`}, {1.491300403538364, 1.6318169614553393`}, {
      1.5097269660601524`, 1.6117555685642069`}, {1.5264956906706995`, 
      1.5902891397499537`}, {1.5414998503774107`, 1.567554301228485}, {
      1.5546439490182882`, 1.5436957521942154`}, {1.7298150982034475`, 
      1.1933534538238972`}, {1.7410154782463365`, 1.1685230454906337`}, {
      1.7502008532394848`, 1.1428788146123834`}, {1.757312761524559, 
      1.1165839776353939`}, {1.7623059383243918`, 1.0898058918832836`}, {
      1.7651486038372561`, 1.062714990386956}, {1.765822665504047, 
      1.0354836971387256`}, {1.76432383316101, 1.0082853296746805`}, {
      1.3011712775792768`, 1.6192819081027077`}, {1.29967244523624, 
      1.5920835406386626`}, {1.3003465069030304`, 1.564852247390432}, {
      1.303189172415895, 1.5377613458941046`}, {1.3081823492157278`, 
      1.5109832601419944`}, {1.3152942575008022`, 1.4846884231650048`}, {
      1.3244796324939503`, 1.4590441922867545`}, {1.3356800125368393`, 
      1.434213783953491}, {1.5108511617219986`, 1.0838714855831728`}, {
      1.5239952603628761`, 1.0600129365489033`}, {1.5389994200695876`, 
      1.0372780980274345`}, {1.5557681446801344`, 1.0158116692131816`}, {
      1.574194707201923, 0.9957502763220493}, {1.5941618290912665`, 
      0.977221603013961}, {1.6155424266897764`, 0.9603435777315903}, {
      1.6382004200668345`, 0.9452236231275927}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {4, 5}, {5, 6}, {5, 7}, {6, 2}, {6, 9, 10, 
          11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 8}, {6, 25, 
          26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 8}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "8"],
         Annotation[#, 8, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 1.7517114918515921`}, {
       0.6568918094443471, 2.6275672377773884`}, {0., 0.8758557459257961}, {
       0.4379278729628981, 0.}, {0.8758557459257962, 0.8758557459257961}, {
       1.3137836188886942`, 1.7517114918515921`}, {1.3137836188886942`, 0.}, {
       1.7517114918515924`, 0.8758557459257961}}]& ],
    AspectRatio->1.219841419299259,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0., 1.7517114918515921`}, {0.6568918094443471, 
      2.6275672377773884`}, {0., 0.8758557459257961}, {0.4379278729628981, 
      0.}, {0.8758557459257962, 0.8758557459257961}, {1.3137836188886942`, 
      1.7517114918515921`}, {1.3137836188886942`, 0.}, {1.7517114918515924`, 
      0.8758557459257961}, {1.4576316815518628`, 1.6887779644364562`}, {
      1.481650884368188, 1.6768167529060396`}, {1.504366704667195, 
      1.6625344494030905`}, {1.525555570003604, 1.6460716224598635`}, {
      1.5450089364475195`, 1.6275903016411049`}, {1.5625353411044671`, 
      1.6072723828252407`}, {1.5779622865213712`, 1.5853178379583805`}, {
      1.5911379384318631`, 1.5619427469010032`}, {1.7663090876170222`, 
      1.2116004485306846`}, {1.7771037693166287`, 1.1870348723678648`}, {
      1.785411237959975, 1.161520589114225}, {1.7911497302184973`, 
      1.1353087140991482`}, {1.794262767007155, 1.1086572284527612`}, {
      1.7947197093598912`, 1.0818284400176976`}, {1.7925160599828462`, 
      1.0550864016767225`}, {1.7876735075173846`, 1.0286943125054127`}, {
      1.2778216032229022`, 1.5988729252719758`}, {1.2729790507574403`, 
      1.572480836100666}, {1.2707754013803954`, 1.545738797759691}, {
      1.2712323437331319`, 1.5189100093246275`}, {1.2743453805217895`, 
      1.4922585236782402`}, {1.2800838727803119`, 1.4660466486631634`}, {
      1.288391341423658, 1.440532365409524}, {1.2991860231232646`, 
      1.4159667892467038`}, {1.474357172308424, 1.0656244908763852`}, {
      1.4875328242189159`, 1.042249399819008}, {1.50295976963582, 
      1.0202948549521478`}, {1.5204861742927676`, 0.9999769361362835}, {
      1.539939540736683, 0.9814956153175252}, {1.561128406073092, 
      0.9650327883742978}, {1.5838442263720989`, 0.9507504848713488}, {
      1.6078634291884242`, 0.9387892733409323}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {4, 5}, {5, 6}, {5, 7}, {6, 2}, {6, 9, 10, 
          11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 8}, {6, 25, 
          26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 8}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "8"],
         Annotation[#, 8, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 1.7517114918515921`}, {
       0.6568918094443471, 2.6275672377773884`}, {0., 0.8758557459257961}, {
       0.4379278729628981, 0.}, {0.8758557459257962, 0.8758557459257961}, {
       1.3137836188886942`, 1.7517114918515921`}, {1.3137836188886942`, 0.}, {
       1.7517114918515924`, 0.8758557459257961}}]& ],
    AspectRatio->1.2099811454859646`,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0., 1.7517114918515921`}, {0.6568918094443471, 
      2.6275672377773884`}, {0., 0.8758557459257961}, {0.4379278729628981, 
      0.}, {0.8758557459257962, 0.8758557459257961}, {1.3137836188886942`, 
      1.7517114918515921`}, {1.3137836188886942`, 0.}, {1.7517114918515924`, 
      0.8758557459257961}, {1.524583149263635, 1.7065401639141051`}, {
      1.5496659882504362`, 1.699460440993622}, {1.573639816105137, 
      1.689236602856123}, {1.5961123331970022`, 1.6760359489395773`}, {
      1.6167158068381087`, 1.660074490291044}, {1.6351130887369834`, 
      1.6416134148347783`}, {1.6510031319794995`, 1.6209548133811569`}, {
      1.6641259172590128`, 1.5984367363145782`}, {1.8392970664441721`, 
      1.2480944379442596`}, {1.8494378569297274`, 1.2240853634807014`}, {
      1.8564307121471146`, 1.1989781680145157`}, {1.8601612033728023`, 
      1.1731836972216565`}, {1.8605682861069652`, 1.1471240431196514`}, {
      1.8576452989850827`, 1.1212256370962315`}, {1.8514400727822613`, 
      1.0959122719299716`}, {1.8420541477265673`, 1.071598166988241}, {
      1.2234409630137197`, 1.5559690707891474`}, {1.214055037958026, 
      1.5316549658474166`}, {1.2078498117552043`, 1.5063416006811567`}, {
      1.2049268246333218`, 1.4804431946577368`}, {1.2053339073674847`, 
      1.4543835405557317`}, {1.2090643985931724`, 1.4285890697628727`}, {
      1.2160572538105596`, 1.4034818742966868`}, {1.226198044296115, 
      1.3794727998331289`}, {1.401369193481274, 1.0291305014628103`}, {
      1.4144919787607872`, 1.0066124243962313`}, {1.4303820220033034`, 
      0.9859538229426101}, {1.4487793039021781`, 0.9674927474863443}, {
      1.4693827775432846`, 0.951531288837811}, {1.4918552946351498`, 
      0.9383306349212651}, {1.5158291224898508`, 0.9281067967837665}, {
      1.5409119614766518`, 0.9210270738632833}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {4, 5}, {5, 6}, {5, 7}, {6, 2}, {6, 9, 10, 
          11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 8}, {6, 25, 
          26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 8}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "8"],
         Annotation[#, 8, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 1.7517114918515921`}, {
       0.6568918094443471, 2.6275672377773884`}, {0., 0.8758557459257961}, {
       0.4379278729628981, 0.}, {0.8758557459257962, 0.8758557459257961}, {
       1.3137836188886942`, 1.7517114918515921`}, {1.3137836188886942`, 0.}, {
       1.7517114918515924`, 0.8758557459257961}}]& ],
    AspectRatio->1.188376655907873,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{452, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1008867074]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PackingMethod",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->47225018],

Cell["Packing disconnected components using different methods:", "ExampleText",
 CellID->1302252890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "@", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"TreePlot", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"i", "\[Rule]", 
           RowBox[{"Mod", "[", 
            RowBox[{
             RowBox[{"i", "^", "2"}], ",", "114"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "0", ",", "114"}], "}"}]}], "]"}], ",", 
        RowBox[{"PackingMethod", "\[Rule]", "m"}], ",", 
        RowBox[{"PlotLabel", "\[Rule]", "m"}], ",", 
        RowBox[{"BaselinePosition", "\[Rule]", "Top"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "150"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"m", ",", 
        RowBox[{"{", 
         RowBox[{
         "\"\<Layered\>\"", ",", "\"\<LayeredTop\>\"", ",", 
          "\"\<LayeredLeft\>\"", ",", "\"\<ClosestPacking\>\"", ",", 
          "\"\<ClosestPackingCenter\>\"", ",", "\"\<NestedGrid\>\""}], 
         "}"}]}], "}"}]}], "]"}], ",", "3"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47617879],

Cell[BoxData[
 TagBox[GridBox[{
    {
     GraphicsBox[
      TagBox[GraphicsComplexBox[CompressedData["
1:eJxlWHlcjN3bn/ZFZWaiaWaaFvc9TSgp7dsc9CQpobTvSIqHZAtFVJYSJVsI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        "], {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
            127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 1}, {
            2, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 
            151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 2}, {3, 
            4}, {4, 7}, {5, 6}, {6, 16}, {7, 28}, {8, 9}, {9, 23}, {10, 11}, {
            11, 57}, {12, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 
            172, 173, 174, 175, 176, 177, 13}, {13, 178, 179, 180, 181, 182, 
            183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 12}, {14, 
            15}, {15, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 
            205, 206, 207, 208, 209, 43}, {16, 53}, {17, 18}, {18, 25}, {19, 
            12}, {20, 21}, {21, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
            219, 220, 221, 222, 223, 224, 225, 48}, {22, 23}, {23, 30}, {24, 
            25}, {25, 51}, {26, 27}, {27, 6}, {28, 18}, {29, 30}, {30, 40}, {
            31, 32}, {32, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 
            236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 
            32}, {33, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 
            260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 33}, {
            34, 35}, {35, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 
            282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 
            35}, {36, 37}, {37, 27}, {38, 28}, {39, 40}, {40, 56}, {41, 10}, {
            42, 43}, {43, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 
            305, 306, 307, 308, 309, 310, 15}, {44, 45}, {45, 311, 312, 313, 
            314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 
            66}, {46, 47}, {47, 9}, {48, 327, 328, 329, 330, 331, 332, 333, 
            334, 335, 336, 337, 338, 339, 340, 341, 342, 21}, {49, 13}, {50, 
            51}, {51, 4}, {52, 53}, {53, 72}, {54, 7}, {55, 56}, {56, 47}, {
            57, 64}, {58, 2}, {59, 60}, {60, 343, 344, 345, 346, 347, 348, 
            349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 
            362, 363, 364, 365, 60}, {61, 366, 367, 368, 369, 370, 371, 372, 
            373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 
            386, 387, 388, 61}, {62, 4}, {63, 56}, {64, 75}, {65, 51}, {66, 
            389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 
            402, 403, 404, 45}, {67, 15}, {68, 47}, {69, 41}, {70, 43}, {71, 
            72}, {72, 37}, {73, 25}, {74, 40}, {75, 41}, {76, 35}, {77, 405, 
            406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 
            419, 420, 421, 422, 423, 424, 425, 426, 427, 77}, {78, 30}, {79, 
            75}, {80, 25}, {81, 12}, {82, 47}, {83, 15}, {84, 66}, {85, 51}, {
            86, 9}, {87, 64}, {88, 4}, {89, 61}, {90, 2}, {91, 57}, {92, 
            56}, {93, 7}, {94, 13}, {95, 48}, {96, 18}, {97, 43}, {98, 23}, {
            99, 10}, {100, 40}, {101, 28}, {102, 35}, {103, 33}, {104, 30}, {
            105, 28}, {106, 23}, {107, 12}, {108, 18}, {109, 16}, {110, 13}, {
            111, 11}, {112, 9}, {113, 7}, {114, 2}, {115, 1}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[13],
            "49"],
           Annotation[#, 49, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[14],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[15],
            "64"],
           Annotation[#, 64, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[16],
            "81"],
           Annotation[#, 81, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[17],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[18],
            "100"],
           Annotation[#, 100, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[19],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[20],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[21],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[22],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[23],
            "55"],
           Annotation[#, 55, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[24],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[25],
            "82"],
           Annotation[#, 82, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[26],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[27],
            "111"],
           Annotation[#, 111, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[28],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[29],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[30],
            "61"],
           Annotation[#, 61, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[31],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[32],
            "96"],
           Annotation[#, 96, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[33],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[34],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[35],
            "58"],
           Annotation[#, 58, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[36],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[37],
            "99"],
           Annotation[#, 99, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[38],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[39],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[40],
            "73"],
           Annotation[#, 73, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[41],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[42],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[43],
            "106"],
           Annotation[#, 106, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[44],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[45],
            "45"],
           Annotation[#, 45, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[46],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[47],
            "43"],
           Annotation[#, 43, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[48],
            "102"],
           Annotation[#, 102, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[49],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[50],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[51],
            "112"],
           Annotation[#, 112, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[52],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[53],
            "63"],
           Annotation[#, 63, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[54],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[55],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[56],
            "85"],
           Annotation[#, 85, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[57],
            "42"],
           Annotation[#, 42, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[58],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[59],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[60],
            "76"],
           Annotation[#, 76, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[61],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[62],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[63],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[64],
            "54"],
           Annotation[#, 54, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[65],
            "44"],
           Annotation[#, 44, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[66],
            "87"],
           Annotation[#, 87, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[67],
            "46"],
           Annotation[#, 46, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[68],
            "47"],
           Annotation[#, 47, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[69],
            "48"],
           Annotation[#, 48, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[70],
            "50"],
           Annotation[#, 50, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[71],
            "51"],
           Annotation[#, 51, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[72],
            "93"],
           Annotation[#, 93, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[73],
            "52"],
           Annotation[#, 52, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[74],
            "53"],
           Annotation[#, 53, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[75],
            "66"],
           Annotation[#, 66, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[76],
            "56"],
           Annotation[#, 56, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[77],
            "57"],
           Annotation[#, 57, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[78],
            "59"],
           Annotation[#, 59, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[79],
            "60"],
           Annotation[#, 60, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[80],
            "62"],
           Annotation[#, 62, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[81],
            "65"],
           Annotation[#, 65, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[82],
            "67"],
           Annotation[#, 67, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[83],
            "68"],
           Annotation[#, 68, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[84],
            "69"],
           Annotation[#, 69, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[85],
            "70"],
           Annotation[#, 70, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[86],
            "71"],
           Annotation[#, 71, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[87],
            "72"],
           Annotation[#, 72, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[88],
            "74"],
           Annotation[#, 74, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[89],
            "75"],
           Annotation[#, 75, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[90],
            "77"],
           Annotation[#, 77, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[91],
            "78"],
           Annotation[#, 78, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[92],
            "79"],
           Annotation[#, 79, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[93],
            "80"],
           Annotation[#, 80, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[94],
            "83"],
           Annotation[#, 83, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[95],
            "84"],
           Annotation[#, 84, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[96],
            "86"],
           Annotation[#, 86, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[97],
            "88"],
           Annotation[#, 88, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[98],
            "89"],
           Annotation[#, 89, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[99],
            "90"],
           Annotation[#, 90, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[100],
            "91"],
           Annotation[#, 91, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[101],
            "92"],
           Annotation[#, 92, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[102],
            "94"],
           Annotation[#, 94, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[103],
            "95"],
           Annotation[#, 95, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[104],
            "97"],
           Annotation[#, 97, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[105],
            "98"],
           Annotation[#, 98, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[106],
            "101"],
           Annotation[#, 101, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[107],
            "103"],
           Annotation[#, 103, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[108],
            "104"],
           Annotation[#, 104, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[109],
            "105"],
           Annotation[#, 105, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[110],
            "107"],
           Annotation[#, 107, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[111],
            "108"],
           Annotation[#, 108, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[112],
            "109"],
           Annotation[#, 109, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[113],
            "110"],
           Annotation[#, 110, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[114],
            "113"],
           Annotation[#, 113, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[115],
            "114"],
           Annotation[#, 114, "Tooltip"]& ]}}],
       Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxlVX1Q02Uc/znmYAzQHzA22IDBhnAcSEAJ8bI95sQweVHelgwUBXnJu7Jd
ECmaIuB5EBwjL6mg2EEkhQbKTbpzD+mxAoIEwdp5nHBIi4RghPLiNDv2fe6y
P3a77x97vp+372deh97el8OgKEr1/PPvt9GuNvOIXIJqkUYeyBZiZmxz22yL
I6Lc2lmRuyTY5eLn/uZ3TTJq6bek0shHujvf7GupHjDL9n/wA2MueVZXFdOW
/kuQK2KxPrTauMekG3TJjuw75I7yuE3fX8q5p+Nd7p+VutijbMuc25j+Eq2a
lgUfeSiNYNL4Vrs5afLiY5nNGXVdqtEeT42klUfwKRS+2HzK/js+9lQ3WDd5
L8guFY6kpIcKcCg/ZNerF9yQxjH4wMcTbtgctaoWKFyQcJUK+PqaO85d3yOr
5SY+La+S4FCT/vgEvSwb9TLySsRirN1ye77wiYDgjXZo8kkuYiELL51vwXi8
QWaLgG+hpO9gUIAreR9V6ocPp4nRveqat9R/LOlAP+BbvOPcFg/DM8LnWNfg
g92BNujbsPi28B/Z+LAFX3JHzpOf2xlYsa6jDPafWJPnaXkidLWcp2g8adZV
qD6yn+wTEbysv7WVmoebEOgvpwMWIt1ZCPTsp5yH8uLsEOwHfEUPsly3Z3m/
MEuwdOse2x5bP3TV9nbGaMicLqZbtHMnR4B8aNPS8IgPrm5tFb8n8SB5qP3z
bgfnpBe6Upo29pmCSWbAS/e6vX/QxoHoB/gyOdWhsc5OuCH9mOHNaFuCNyWt
THmunoHAX/Avga2dqnnsg5HYb/J6von4CfrXdSp8Bz+lCR9jVsZ8xRCH6Av7
8rO1BbeKF0neaqqUM3nBPsS/0hR/vfVZJ9T/Tt6JcbkIW3ATP2YSXUrYzFWS
f8g78Ndsk7aIn+cR+C9/tWqoM9DEH8BTeSXYTyHhYuHL04y4zjmCr5hf0WUX
ZZQJLPkquhZRf1ywiegP/rQq2bWqXA6Zk9uZP13vpMm8NzJhmv+lAB84q//9
fB9F9Id9sB/07ZXyTq8JRBjuGfiCPqCvb08ul91tJvrDvQJ+uFfAD36Bf3Bv
1nINNbPAJjPoB/mHe4B8wPt6Q0fImHAjeR/y+KI+vlMDG6L0YrzS3HWzKMOB
5At+D3zBX9g3z6kP3EEJyX3D/cL+8stJkoAyJgL+oM8rXWdSf03g4qT1d0h/
eK68Fk11r5G8gd6nqK1HvTO88Ov3rWhazST+/Nc/T9K/wA/6D/CD/uDn7Ogn
f9294UTyBn0IeQa8QXFC53ElA0O/kb6z+At+qZsDlDe3bSb9EZ5530bSaE3u
E/QFfZ7WtCWqjJsJn6Nv8E8PN4j+58/+MmN7gesznf9yyViflCb+mG7E5nQN
OJLf9+weShyOcST7CxbzV1PveBB/oF8AP/zfwP1BXwN/Rv1KZ7TvI3JfM73T
1h7mDWT/hFUYU6DhEv3iwwLPu2MuwQ/9EvvF3qYLTBH+Bx+aRJI=
         "]]& ],
      AspectRatio->0.9441173497535634,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox["\"Layered\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[GraphicsComplexBox[CompressedData["
1:eJxVWHk81Nv7Z6xZZzGTZZj5jGWGlLhFuMwpa01ku7bETaty1W2VS9yIrJWl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        "], {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
            127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 1}, {
            2, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 
            151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 2}, {3, 
            4}, {4, 7}, {5, 6}, {6, 16}, {7, 28}, {8, 9}, {9, 23}, {10, 11}, {
            11, 57}, {12, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 
            172, 173, 174, 175, 176, 177, 13}, {13, 178, 179, 180, 181, 182, 
            183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 12}, {14, 
            15}, {15, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 
            205, 206, 207, 208, 209, 43}, {16, 53}, {17, 18}, {18, 25}, {19, 
            12}, {20, 21}, {21, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
            219, 220, 221, 222, 223, 224, 225, 48}, {22, 23}, {23, 30}, {24, 
            25}, {25, 51}, {26, 27}, {27, 6}, {28, 18}, {29, 30}, {30, 40}, {
            31, 32}, {32, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 
            236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 
            32}, {33, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 
            260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 33}, {
            34, 35}, {35, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 
            282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 
            35}, {36, 37}, {37, 27}, {38, 28}, {39, 40}, {40, 56}, {41, 10}, {
            42, 43}, {43, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 
            305, 306, 307, 308, 309, 310, 15}, {44, 45}, {45, 311, 312, 313, 
            314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 
            66}, {46, 47}, {47, 9}, {48, 327, 328, 329, 330, 331, 332, 333, 
            334, 335, 336, 337, 338, 339, 340, 341, 342, 21}, {49, 13}, {50, 
            51}, {51, 4}, {52, 53}, {53, 72}, {54, 7}, {55, 56}, {56, 47}, {
            57, 64}, {58, 2}, {59, 60}, {60, 343, 344, 345, 346, 347, 348, 
            349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 
            362, 363, 364, 365, 60}, {61, 366, 367, 368, 369, 370, 371, 372, 
            373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 
            386, 387, 388, 61}, {62, 4}, {63, 56}, {64, 75}, {65, 51}, {66, 
            389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 
            402, 403, 404, 45}, {67, 15}, {68, 47}, {69, 41}, {70, 43}, {71, 
            72}, {72, 37}, {73, 25}, {74, 40}, {75, 41}, {76, 35}, {77, 405, 
            406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 
            419, 420, 421, 422, 423, 424, 425, 426, 427, 77}, {78, 30}, {79, 
            75}, {80, 25}, {81, 12}, {82, 47}, {83, 15}, {84, 66}, {85, 51}, {
            86, 9}, {87, 64}, {88, 4}, {89, 61}, {90, 2}, {91, 57}, {92, 
            56}, {93, 7}, {94, 13}, {95, 48}, {96, 18}, {97, 43}, {98, 23}, {
            99, 10}, {100, 40}, {101, 28}, {102, 35}, {103, 33}, {104, 30}, {
            105, 28}, {106, 23}, {107, 12}, {108, 18}, {109, 16}, {110, 13}, {
            111, 11}, {112, 9}, {113, 7}, {114, 2}, {115, 1}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[13],
            "49"],
           Annotation[#, 49, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[14],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[15],
            "64"],
           Annotation[#, 64, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[16],
            "81"],
           Annotation[#, 81, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[17],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[18],
            "100"],
           Annotation[#, 100, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[19],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[20],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[21],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[22],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[23],
            "55"],
           Annotation[#, 55, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[24],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[25],
            "82"],
           Annotation[#, 82, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[26],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[27],
            "111"],
           Annotation[#, 111, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[28],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[29],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[30],
            "61"],
           Annotation[#, 61, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[31],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[32],
            "96"],
           Annotation[#, 96, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[33],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[34],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[35],
            "58"],
           Annotation[#, 58, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[36],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[37],
            "99"],
           Annotation[#, 99, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[38],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[39],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[40],
            "73"],
           Annotation[#, 73, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[41],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[42],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[43],
            "106"],
           Annotation[#, 106, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[44],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[45],
            "45"],
           Annotation[#, 45, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[46],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[47],
            "43"],
           Annotation[#, 43, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[48],
            "102"],
           Annotation[#, 102, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[49],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[50],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[51],
            "112"],
           Annotation[#, 112, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[52],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[53],
            "63"],
           Annotation[#, 63, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[54],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[55],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[56],
            "85"],
           Annotation[#, 85, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[57],
            "42"],
           Annotation[#, 42, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[58],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[59],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[60],
            "76"],
           Annotation[#, 76, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[61],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[62],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[63],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[64],
            "54"],
           Annotation[#, 54, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[65],
            "44"],
           Annotation[#, 44, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[66],
            "87"],
           Annotation[#, 87, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[67],
            "46"],
           Annotation[#, 46, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[68],
            "47"],
           Annotation[#, 47, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[69],
            "48"],
           Annotation[#, 48, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[70],
            "50"],
           Annotation[#, 50, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[71],
            "51"],
           Annotation[#, 51, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[72],
            "93"],
           Annotation[#, 93, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[73],
            "52"],
           Annotation[#, 52, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[74],
            "53"],
           Annotation[#, 53, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[75],
            "66"],
           Annotation[#, 66, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[76],
            "56"],
           Annotation[#, 56, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[77],
            "57"],
           Annotation[#, 57, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[78],
            "59"],
           Annotation[#, 59, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[79],
            "60"],
           Annotation[#, 60, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[80],
            "62"],
           Annotation[#, 62, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[81],
            "65"],
           Annotation[#, 65, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[82],
            "67"],
           Annotation[#, 67, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[83],
            "68"],
           Annotation[#, 68, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[84],
            "69"],
           Annotation[#, 69, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[85],
            "70"],
           Annotation[#, 70, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[86],
            "71"],
           Annotation[#, 71, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[87],
            "72"],
           Annotation[#, 72, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[88],
            "74"],
           Annotation[#, 74, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[89],
            "75"],
           Annotation[#, 75, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[90],
            "77"],
           Annotation[#, 77, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[91],
            "78"],
           Annotation[#, 78, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[92],
            "79"],
           Annotation[#, 79, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[93],
            "80"],
           Annotation[#, 80, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[94],
            "83"],
           Annotation[#, 83, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[95],
            "84"],
           Annotation[#, 84, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[96],
            "86"],
           Annotation[#, 86, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[97],
            "88"],
           Annotation[#, 88, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[98],
            "89"],
           Annotation[#, 89, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[99],
            "90"],
           Annotation[#, 90, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[100],
            "91"],
           Annotation[#, 91, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[101],
            "92"],
           Annotation[#, 92, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[102],
            "94"],
           Annotation[#, 94, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[103],
            "95"],
           Annotation[#, 95, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[104],
            "97"],
           Annotation[#, 97, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[105],
            "98"],
           Annotation[#, 98, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[106],
            "101"],
           Annotation[#, 101, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[107],
            "103"],
           Annotation[#, 103, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[108],
            "104"],
           Annotation[#, 104, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[109],
            "105"],
           Annotation[#, 105, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[110],
            "107"],
           Annotation[#, 107, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[111],
            "108"],
           Annotation[#, 108, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[112],
            "109"],
           Annotation[#, 109, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[113],
            "110"],
           Annotation[#, 110, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[114],
            "113"],
           Annotation[#, 113, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[115],
            "114"],
           Annotation[#, 114, "Tooltip"]& ]}}],
       Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxVVXtMU2cU70ppAaVCoQVrV9vSQukwgCEwBOlnaNjMhGFpeKhDM9cFF6OZ
JEo6IQxKAbcgrsyIc7DB0jFFeQ5diPSbiwwBM6o8tDOKjyEIdFAGOgZzD3pO
wh83Nyf33u/3Oudc6buHtXomg8HI/ff67x7RZ7jpYIuI++D4K/l1EjoqKtrW
cTGYtDy5nnG+hEcF1V+qlo841Yz5u2nFcQvWwUat5WT/snqX4RrToZu2pmUJ
GwtqggmbXejmvsNpzf1x4Yu/LitJDr+u87z+njWgqW86QeBN3nPViuqloZEY
Ibl+aTntUfVz60TljMbx9qtEEjXGTG5zWJ/ezjBtCWSQ5v/xfWiwuYZTJ5tV
y3LmNr3g+FFD1NSveYcELn4+VJPVrtwdwSOq/s/lXVl+NFt7ZuytWDHWvYLx
/vY4Kb5/YPvFBRtLiXy3cusUumNs4tJlDfngfopd7UVA71VinD/E4uN5IR8f
L3zgxSHpQ/nri45LaU+xpWmiy4usabC5LWo2UkG0OXZ570bU8zo5eMqbStGP
/St3ta5Vv3TzEpNmrvioBvzylvKxFLGKtJsCMmsLlq1Vobc/ybOpkC/7jyuf
1k+tI+D/9OnEQc94Kfr5y2dX1/B7ZIg/YzrGu3VDSrxc/KBeyVtKNQ2RXWGV
Csw/z8VP1Rc26x8uo0UJHqGqgjk12/W85mtRZJ3xNdJcnDF8LpOFNfD17Rbm
7fPgon/Az5BYFiy2v7QaJ6pSfDUy5JuZUbKn7CyTQL6Q3zdt+lnbJgGdErXf
bTJJ0P8nJfeSwrt56H9U6YfZUV/5o/8VSRd2D4SvRzxtQm3v2BsixMsxDdyf
O8LF76se91yuuMJFPBdvzONZqiDfk7WI/Q/9Dvqzbft3NuwMQf0vvl20V9l9
MR/gE3iwfCnMm0U7J5NTH6g3ID9TYGnH2vhxtXlSwko6waedigStWKogi7eS
o+01fHruxuSB0vRQzA9qyK/Ky/bO0GaHuvV7x4icqaR7jT8/PdHLQP8BD/AL
Xfm6H06xm9cGUphn0GssYx+NNQjQn+98RPSHGSn6D/MK/GFegT/kBX7CvHE0
9Yxns55Yg3/Q/zAP0B9wfq+9dfOwyB3Ph36E/nTv2cOWWNgE9Avjx3oCdwRh
3vA96IV8AS9aqbtWdCcA9cH8Ar6eZbT8tCsIn4M/lmFeZGl6EE1bOQf3R+Hj
bdb5DDHig99HnR81P6wQ0jdH3Xx9zSzMZ3V+Kty/kD/sP+AP/kOe00Nnfh/p
8sN+g30I/kO/A1/Yb8AX8oX33/+NaxINBOH+iMse9ZDXcnA+wV/w5+/KC6m5
4z6ox/I8pH7i0UvMZ/V+kdGWiphEiU6O/ji7tus7+nn4/VLMPob8jhzxm9fJ
T55uFKL/sF+AP/xvYP5gX4Mej7N/tm0NWcD5Stc4s5hREsR/6BbD2lDPR/9Y
/t0RKVuU6P/q/6OM/gOc2XU6
         "]]& ],
      AspectRatio->0.9712408668557281,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox["\"LayeredTop\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[GraphicsComplexBox[CompressedData["
1:eJxdWHk8lF3Yti9j14xtnjEzPGMLEclSHClbRCGy9yKv0qaSJVLIUllSypLE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        "], {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
            127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 1}, {
            2, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 
            151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 2}, {3, 
            4}, {4, 7}, {5, 6}, {6, 16}, {7, 28}, {8, 9}, {9, 23}, {10, 11}, {
            11, 57}, {12, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 
            172, 173, 174, 175, 176, 177, 13}, {13, 178, 179, 180, 181, 182, 
            183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 12}, {14, 
            15}, {15, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 
            205, 206, 207, 208, 209, 43}, {16, 53}, {17, 18}, {18, 25}, {19, 
            12}, {20, 21}, {21, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
            219, 220, 221, 222, 223, 224, 225, 48}, {22, 23}, {23, 30}, {24, 
            25}, {25, 51}, {26, 27}, {27, 6}, {28, 18}, {29, 30}, {30, 40}, {
            31, 32}, {32, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 
            236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 
            32}, {33, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 
            260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 33}, {
            34, 35}, {35, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 
            282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 
            35}, {36, 37}, {37, 27}, {38, 28}, {39, 40}, {40, 56}, {41, 10}, {
            42, 43}, {43, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 
            305, 306, 307, 308, 309, 310, 15}, {44, 45}, {45, 311, 312, 313, 
            314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 
            66}, {46, 47}, {47, 9}, {48, 327, 328, 329, 330, 331, 332, 333, 
            334, 335, 336, 337, 338, 339, 340, 341, 342, 21}, {49, 13}, {50, 
            51}, {51, 4}, {52, 53}, {53, 72}, {54, 7}, {55, 56}, {56, 47}, {
            57, 64}, {58, 2}, {59, 60}, {60, 343, 344, 345, 346, 347, 348, 
            349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 
            362, 363, 364, 365, 60}, {61, 366, 367, 368, 369, 370, 371, 372, 
            373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 
            386, 387, 388, 61}, {62, 4}, {63, 56}, {64, 75}, {65, 51}, {66, 
            389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 
            402, 403, 404, 45}, {67, 15}, {68, 47}, {69, 41}, {70, 43}, {71, 
            72}, {72, 37}, {73, 25}, {74, 40}, {75, 41}, {76, 35}, {77, 405, 
            406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 
            419, 420, 421, 422, 423, 424, 425, 426, 427, 77}, {78, 30}, {79, 
            75}, {80, 25}, {81, 12}, {82, 47}, {83, 15}, {84, 66}, {85, 51}, {
            86, 9}, {87, 64}, {88, 4}, {89, 61}, {90, 2}, {91, 57}, {92, 
            56}, {93, 7}, {94, 13}, {95, 48}, {96, 18}, {97, 43}, {98, 23}, {
            99, 10}, {100, 40}, {101, 28}, {102, 35}, {103, 33}, {104, 30}, {
            105, 28}, {106, 23}, {107, 12}, {108, 18}, {109, 16}, {110, 13}, {
            111, 11}, {112, 9}, {113, 7}, {114, 2}, {115, 1}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[13],
            "49"],
           Annotation[#, 49, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[14],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[15],
            "64"],
           Annotation[#, 64, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[16],
            "81"],
           Annotation[#, 81, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[17],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[18],
            "100"],
           Annotation[#, 100, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[19],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[20],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[21],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[22],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[23],
            "55"],
           Annotation[#, 55, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[24],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[25],
            "82"],
           Annotation[#, 82, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[26],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[27],
            "111"],
           Annotation[#, 111, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[28],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[29],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[30],
            "61"],
           Annotation[#, 61, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[31],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[32],
            "96"],
           Annotation[#, 96, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[33],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[34],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[35],
            "58"],
           Annotation[#, 58, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[36],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[37],
            "99"],
           Annotation[#, 99, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[38],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[39],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[40],
            "73"],
           Annotation[#, 73, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[41],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[42],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[43],
            "106"],
           Annotation[#, 106, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[44],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[45],
            "45"],
           Annotation[#, 45, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[46],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[47],
            "43"],
           Annotation[#, 43, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[48],
            "102"],
           Annotation[#, 102, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[49],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[50],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[51],
            "112"],
           Annotation[#, 112, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[52],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[53],
            "63"],
           Annotation[#, 63, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[54],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[55],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[56],
            "85"],
           Annotation[#, 85, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[57],
            "42"],
           Annotation[#, 42, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[58],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[59],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[60],
            "76"],
           Annotation[#, 76, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[61],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[62],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[63],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[64],
            "54"],
           Annotation[#, 54, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[65],
            "44"],
           Annotation[#, 44, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[66],
            "87"],
           Annotation[#, 87, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[67],
            "46"],
           Annotation[#, 46, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[68],
            "47"],
           Annotation[#, 47, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[69],
            "48"],
           Annotation[#, 48, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[70],
            "50"],
           Annotation[#, 50, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[71],
            "51"],
           Annotation[#, 51, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[72],
            "93"],
           Annotation[#, 93, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[73],
            "52"],
           Annotation[#, 52, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[74],
            "53"],
           Annotation[#, 53, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[75],
            "66"],
           Annotation[#, 66, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[76],
            "56"],
           Annotation[#, 56, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[77],
            "57"],
           Annotation[#, 57, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[78],
            "59"],
           Annotation[#, 59, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[79],
            "60"],
           Annotation[#, 60, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[80],
            "62"],
           Annotation[#, 62, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[81],
            "65"],
           Annotation[#, 65, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[82],
            "67"],
           Annotation[#, 67, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[83],
            "68"],
           Annotation[#, 68, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[84],
            "69"],
           Annotation[#, 69, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[85],
            "70"],
           Annotation[#, 70, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[86],
            "71"],
           Annotation[#, 71, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[87],
            "72"],
           Annotation[#, 72, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[88],
            "74"],
           Annotation[#, 74, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[89],
            "75"],
           Annotation[#, 75, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[90],
            "77"],
           Annotation[#, 77, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[91],
            "78"],
           Annotation[#, 78, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[92],
            "79"],
           Annotation[#, 79, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[93],
            "80"],
           Annotation[#, 80, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[94],
            "83"],
           Annotation[#, 83, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[95],
            "84"],
           Annotation[#, 84, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[96],
            "86"],
           Annotation[#, 86, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[97],
            "88"],
           Annotation[#, 88, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[98],
            "89"],
           Annotation[#, 89, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[99],
            "90"],
           Annotation[#, 90, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[100],
            "91"],
           Annotation[#, 91, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[101],
            "92"],
           Annotation[#, 92, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[102],
            "94"],
           Annotation[#, 94, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[103],
            "95"],
           Annotation[#, 95, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[104],
            "97"],
           Annotation[#, 97, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[105],
            "98"],
           Annotation[#, 98, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[106],
            "101"],
           Annotation[#, 101, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[107],
            "103"],
           Annotation[#, 103, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[108],
            "104"],
           Annotation[#, 104, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[109],
            "105"],
           Annotation[#, 105, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[110],
            "107"],
           Annotation[#, 107, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[111],
            "108"],
           Annotation[#, 108, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[112],
            "109"],
           Annotation[#, 109, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[113],
            "110"],
           Annotation[#, 110, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[114],
            "113"],
           Annotation[#, 113, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[115],
            "114"],
           Annotation[#, 114, "Tooltip"]& ]}}],
       Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxdVXtMU2cUL6WlvOFKC8yWPmgL1SADYSgI3G9iwOIjDdSBIOiAijIdk25x
TCtkgjrBwAIzahQSGrZMnEMwDQ9nP4cBBz7GeKh1GCzIGAMMoCDO6jbp+Qz7
4+bmy733nN/rnCvJyE3QMBkMhvbf6797fUFYUIFGgsrjcsI/HRfjINNerfpr
GToZe/npzmJH7Hn63HJL3jTNeHY/8fCaWWPvhYRvy25a6JQvfmZOqieM2bya
1vOa3+msni7uZR0fp7V3rUh4PEeHz9QWuFzyxl4/dk1Ee7qgrIX3jNnVqUGU
doQO3jkeHcGi8PWLlkTz6Tna/suKyg9GXfBwT9KRCG8GUj64901gkxSLKqo4
Nb5TNPPck8It8zJcVXR/giERI7W1HifwgGLYVoAipQpz8+5p44nYutRf330H
DYRG9pyscsJtkiHXyb0+aExzNjx3lo05doW27I3TBG+Ua41cvd8OWXkZ/XMe
bjbRjgj4FvI2PJu7KyT1qcwNFhMlRaFxzj8Jh71w8xDvq4FXUlSxznyCG8TF
+THH/ISm14TPPsPtx/Er7NEPqzbXrb7hgDOteqkbNC9vXWTi5AUdaehfrA9+
f7bEBpU3Tn2fEi/E9YeT+s8msxDgtXvaVKofd0Og/zoqYGqNjx0CPbsY3Du7
Njkj6N+ZwuRTW+VIXNabN3pPRM4Lfkvwgl58FJbT/LLH2Q+DfsnRqguGT5bi
/tCQCIZSgNxUN24dSfLCDzJ1H8XIOWjgl5LqwhIxOQNeqn3p5zvsXYl+gC/d
qSxEyfXAVan7TFujHAneLUnF246dYSLwF/qP2nwctl3vjsFf8BOev8G/R4IH
4pC2z4GPCkrPxzyUiYi+0G93VlPO9fwZkrcPswa5g3/JiH9Qz/daNs+hxWK0
4iZ+jKk8dQ6sFyT/kHfgv6NkV0Ou5k8a+D//7oWp0kQRfwBPaX2wIlnGw4LQ
EeamxkmCL9/7qME5cpRuTbfbczDCDzsNLSu6wpKiSsqcPJTqjuW9OnH3IYnV
H/n/zv6YxfbzaNHIiX/bizr+ON7JIPpDP+gP+LVinyT9AX8M8wx8A5V9x01D
AqIv5B/0h3kF/DCvgB/8Iv5Z522mWTjWMyUhZ9AP8g/zAPmA+h2mhpX9Ajap
D3mEfJrfu83Wb1yGDjp2p/WtnDTO1xra9qe5knzB98AX/IV+ukMuj9j9YjLf
ML/QH54Df9BncP1rVX6sFCcu1CH7QzS/NorR8jfJG+gdYA5Z23lFgdcP2lJU
BYv4s9g/Bdm/4D/sP8AP+oOfE32nnty96kHyBvpDniHvvcqwccUpPob9BnjB
X/CrojZgW1uYO9kfq9MH7WXVHDKfoC/o86q8TqUddSd8RNJW76AMEfFn8X5R
4OXPdf2d0RTxZ/qqUmO4uYR8fy3+juq32CWkf0TeZx1uyPft/rXuF8AP/xuY
P+AD/Jln5huj/GfJfI21j3CEFhvS/5HtKhZfzyP6qbsvZYz7+BH9F/8fffE/
ShhJow==
         "]]& ],
      AspectRatio->0.9884242675585164,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox["\"LayeredLeft\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]]},
    {
     GraphicsBox[
      TagBox[GraphicsComplexBox[CompressedData["
1:eJxdWHk4VWv7Nu29RTLt7G1vtr3WRiiRSgjrDYeIpJFGlaFTNAh1KtJASCWK
QiWHSlKiQYfajyJFgyEZMktERKLMP7/vWMv1fX+t67ne9T7Pfd/PsN53Ydv2
rHQXExERSRMVEfn/Zyqy3Ka7AUf/eX7CII9Vd20ol4saPEdTU6zUwPL5K9uB
863Eza1cU2tuh7DB93LiGXyAEPm8au6GHxVCzfSL35/0yiPrmT4NhtJM8AxY
/j5LXQlxF9rbRZrLg6ri9w6zJdNQ4oDqojt/AzH7gFhhrkItAf+JIw2fjkR2
Sbr3ER5vYx/VJjDAa0zBxUZXBSW7uScHXWoWWjx5F1v2Jxuxof32gTV9Qn3n
B9YJpoMEdm2nmbO/EqR/TO2zC20k4kJMpLzslGFJR3nLnaFxQlL1fKu0Ex/O
pLlUnf9LEsWuXDkm/k4VnM7knHR9xqTwWvoU4KuSxNDNHSF77139KdR9J2pf
vZOOSL5mYcx03wt9lP+fn2OTV1zhowemI978bxxIcN+mvyocQ4omZeZKRiyI
lOeCVcowxSdA9ZJBvQIdSZ9Y+fbZEXEIWqVU06GQJDzMH3+eozcirGcmdpeL
1hJk/KhNvm7re9nIpz/Wt65SCW45MO6lr+NQeKc714YlsaYjUv8VB/vN3otJ
IFLPSs867oiBFCLjP+aqX2DMEaDpn9KX6d7NI0j7X16dk/wU/7WZAvhea3rc
f1gNzWFWfPi7ToHi93JZ3Le2UFl4ahY3KPKMixIqnk47maxM2SRelo6535b5
UpR+JD7uNjyMXScLt5+bzOrCJSm8GqBttXu3KpVfMn8FcoPFM3MwYOaHSQem
0BCZz/a4lK8uWneEgvKVtvADg3/j1BBlpU/n5bD5EBRfYxmuXkiQ8UTcYyQ/
hnVT9Wb1ZU7umgM4lb+gC2uKHba+EjJ3S1Ue5akA69CSBDFBF5WPfvamA4z1
P6j6J+ud5G96RctExlmR4j+Qxc7SapSl8kPiWfxxvnH8mDwsK5E2jLP9QuEL
//X4TpoWC9W9vSp+b/Oo8KD2mryiv9mImWaR3zEXg0mcqLS09VeOg+B/bA34
N3/ik7Y6vC6peK3YOUjhJeOR8UsXXs872TYTlXnrzO3LEgeyn0m+a3Me1hTX
dRKkvoxo7ZQUB2lKf7JfSfxkv5L4yXyR+SP77dXDlqs6+1Qom9SPrH+yH8j6
IP3XH0N6F+/xKP9kPZL16Ux8lNM21ED/PmlAkwmSk7acTtUXuZ/kS+aXjIfP
Wt344vMY1d9k/5LxRzPcrn05JEfxJ/XZ/6HNteCNADLnKPRdzhql9DMsrPio
GfyLqjdS7we+wTVnsyVhudWsGXLPRP5nvpD506TmL5l/cv6R+En9yXz2nNLZ
ve6DPFVv5Dwk65ms99WE5hWdRB5Q820SL5lfMl8GmTiNs2oGNT9iLNdxcnvU
qP4k9SX1EQ05dLV1WIbiAxtvqHUqCaj8/Pd80YCMtOYjF+bJUfnp3/upZWGz
HLXfZmz+r3hjeSp+cPPrsDAODZH5oebLJH7ye0P2HzmvSf7Dh1qPD95Wpuqn
c4Nr6raCcSo/nx++Oh6XrUjpJ0V3D9T5yKP0/+/vowD27jB8qe2Co7nDWUs1
Jr6Xj/MvetgvxNFVyx2ueysw0NraUXGQiSP857q+tgIMnqn9FjgNYqi3qrW/
KB0D88iUTrEvGJJK6YuQPIeBbNGMy5xaDI2kha1le2EQha27sn3CxnUEUGiD
gThfW7Vq4v0nPj2HRDQwOCQ6tOP6EIauWD9Ki6BjsHjRroXaSjja4XA0qa6b
D6M5egYmi3BkYbY5s7qBT+FvSNfTe1jDhzUFa6P4R6fWWXbcc/MSp/ZXHY3Y
8CQHp/w7bt108/h7HGVPxocterN+VeMUPsvHB2ajGpzCz+xtrFpXglP8Lmw9
mzjtKU7x1+EndDddxxE2qU98bs+mGcem9GtmrxjT3zSlr6PnC8++bC7qrK33
vzhxHqlVO37LaB8XFXvb3JhtrAZC59mnzutxUek7zTccjhp0VFgLLAY5aO8l
i9LGrzz49uh6ZkoZByXpbx7fcIcHZ3V8ZSqecdAp8/Cowx48uFAtoeQp5KAy
k6fuNao88Pt4a+aKDxw0Xrzu07IqVXC7bJfePMxBr/a3mLrFq0KrhK71DwMu
2nzMT4fupQo7ZzwimH5cpLh1vt2YgyrVv/YWHy0fWqoCG5MQaZJQodav6JwZ
FLNRofbzYvZEKQSqUP5lXOR1UlJUqPjdax5qn/1HhcLXL2FtwM9RQSGT+GMO
ss843lSh+F1y2a+SFaRC8X/x8Wz2djsVSp8bskaxuZIqlH7zXw1UiuZN6Wu7
y5n/ovAXcTgrMq+xVgl837ixxLf9IhiKLXWffykBZ+kuydO/B4g5hG+LiAIL
pKUcJI6cHiCq/8pNmjObBRiim/7mDBA8p9BFrpYsyPzW34/f7CeWDe+TvrCe
BTrP3x3n6/cT95dbVMFeFuw6usBA6dFP4vtFo9sNwSyI9v2qGVfVSahFOOsd
u8kGzvzoFc/rOwh+kLPn6Rw2rB7cfNmv4StxPXs099A7Nnw1OCYt8amdaP0W
jWwb2eA3Tl8uLG0jFnv0beztYUPie9PTQy++EItkl1R7iyiDaFz8WqnMVuJ7
1PmaJzOUwe2DVZRVwmdiTHJPawlXGYIytqLRfS3EEh9mSEsLG7S6l64MMPtM
PFR4/mfDKzbUDize6y3XSkR+0Xd7cZcNv30OHjzd0Uq0pLUnx15kwxs6fVp0
8Rfi6gcVObcANqSna140y2oj9unMN9X3YEOOmN9hi+vthHTltj3iK9hgEpqq
su7iV+LtOa8rn03YYD45v65ctmdbKrNgOJW45Cr/k0hIsW80orGg/mV1H/38
T4LrfTPc9ocSKN5+9Q+h2E9UGskzDjcqwdsXwcrNsf3EMeH9jrL3SvD4U8eh
fN4AEazktnstKMEp/8UXc28OEG+jFL2lMpVgTbXHgWsGv4hnKobb+pKVQM5G
tXvpakmUuWC9TDvGgyUO5XInbSWRMD74nY0RD76bGMnpm0mima1pZfuX8yBq
/NnrFXqS6JTVMk13Nx4Ydb6M6VCTRGVOS9uZh3jw45r5MjFZSUTXUbI/co4H
F2P4C66MMBBfrSr+QvJEv2W8npnXzkDX7I6YrHvCgz/+SY1UK6SjEpQg/F2j
BpruUill9+kockW3zpbvapDQnHmZG09H9/pKAu+L8mGfY84Z0RN09HYg9Xeg
NB/0FUNlI/6kIz/2kh7mTD583rmL82I5HZ1fb+q2l8cHl7fqzHsGdPRBJs79
7Cw+RPSaFznPpCPuHwlsL30+eORLqPTcxVC0V5LbyTMsmM/L8A7PxpCG5/ba
nOSJ872rhGVOHobEDz/Kjs9lQUPgxn+OFmFoo6lfgEoFC6zbpzMryjC0uYF+
xLCbBTUClJVdg6HZL19VNDHYUBr0iqfVjCEbXkigEs4GxctfRLGvGIorHDV/
Y8qGsDc7y7ttcLT/4oxg8WxlcIwPHdu9HEdWoSGj88qVQber3dN3NY4Ode66
VdKtDBE/7OaMTnyP/pIcr/0oxQHHvGPnGFsm5qu1VNniWRyQixkfOb8dR5JO
fycOWHLAPXW1ZLwnjrqj+63HXDmwbt91b2wXjlz4M9NsAznQ06evLz1XgFoa
Ja0HJu4HqbGl59qdBKjJJb/IqqdTaDR8hJ/rI0AZTq/ji9u/CZNM95S1nBGg
bIlOn/id3UL8TZ6UwXUBisYYoltn9widopw3cdIESKxj7YNmi17hOxM5l9Lb
AlT+O9zT0/2HcJOpefXGRAHiP+Cfv364T/hlvfeZ6AgBGmX+kEJ7fgo1NEZA
ep8A/V2fujp7Tr9we+Ki/CFHASrZkllRmdwvJO8zHTWa34ff9gulY+XcmJJT
67YK9p7ibTi1P7S2Ju5wMU75lx+e5pj5GKfiJ44sem+WjlP4VFO+F/28g1P4
7XeFqNY9wil+b4aq1swuwin+hqbFjFWtOKVPwTX/S5r0Kf0CLVm/xXWm9C2u
GvL1jlREzy2Do70m7l/O5588zFyqiAwijNMezxDA4qJtF6QZiuiRqba53jgO
HjaB+rklCigYe4wU2nDYoVUtVLutgK525Vc6vsJBKiGN4xijgCJ/rr++JQUH
uWWmgqYJ+5HPTynZYzj02jTiRWkKyCEnr8BmMw6NUsf/2ViugOadOzVQTuCw
1d9tlZeUIhq5uKJLXQuHL0e77M/aK6KPwXqjfGWcOs/tHxA5NKKIw4WoxTIb
aqfWlRPy6QE8JrU/jnHzWsQaJuU/rGjpIrUAJrKfjL+z8JuhZBSTwrfPP4CI
m7BJ/AodjnGvA5kUP2bxbW1dZybFn1j6sqAOY6KHk/rgx/YkGzZO6XfPeG7r
4UtT+m4/s+aCYyiGahduCimcuM/e/vpggY/bxHlq3dzWvn2ywA2ZlnzVEkOp
yl36ZfNl4b4V64e/Foba7qgv3lw+A+Y9zH+iNRND9nUbYlc7zwCx77qeSBpD
zMGsp9FvZCDY2n9X2IR9p1fZzWmxDAxYLe0cnXifxnR0XJAxHbw1lRcVamMo
druHgrvhdJi7MVzc8Q8M5QeGd92qlIaexuUirh4Y0jWn616Ol6bu34ki9nzG
KWlY2uHnan13al1qj8mmde+n9hcnp2k3dGAoZtK/RcgRv1tjU/GzTi7vV5mG
U/gMa2MG3SdsEj9DSeRmwPgUv1Mh6bv1vk3xV/0jJ5dROqXP2SbZOQsypvSr
MNvzZm3ElL5RWi/7XxbR0MhsmXrliXm7FZcrP11BQ34HD4x+5fIha0FaeUMT
DRWtchsul+OD3F51jvA7DcknX3D6ROPDzpMqDhrjNFRlMqeJPqAGGe+TL8nI
0VHSts0B1xrVQKb6+T0fnI7CvRN0TxWrga5Q+d1yQzqSsvh9Nv+RGmx6aLyq
Zx0DVS+rmia4yIMjUtXmZt4MpGwacjU3iAf0M/p2P08wkH1KWXG2Fw/m8bXW
zkhgINlr/CpVFx74bNzw4cRDBhJu+NHe+wcPnkkcfG1fwkChlcMii+fzwDbp
2XvXbwwkug+NjfF5oBSYrPx4miTaL2Z6yVKWB+9NPDNa7tYTip0pVj6WfAj0
LWvVbW4gNuwIEZnhyAeaq+5S9ZONhN2Pe92j6/nQZ3Xv6S65JmJgpayTuScf
dn966Jx3sYk4qO68ong/H5IufF02rNhM1LOMRxOD+KDgtkfiR3gz8e1FrFPO
GT6Yt68wDBpqJmIulc9TiudDstqF5Zva2okT458+3HfGgDZ9n4ir41ei8zdL
3tYDg1pt/5hH974SwbfDPdi+2MT5P6bWQrKDoBl/COIex4DuJS731bmDqK50
GXaIxEApu7Ht3PUOwmHTjW1pVzHY0jXvCr+5g4DA9wv1Js73R7zGekM4ncSA
VUPbh4n75OFT4SXZK3G0UGrO0swYDtzVbQjk2U7MY9ldJYeOcsCpMzy1i8BR
wTDrZ5wnB8TeGhhoT9xfvExc9DiOHIjffryqfC6OdsYW6osYcoCh5Wjcozlx
P8mgVa5Wmfi+Fb98G6SGo2POS+fyxTjwLvNWxyn2xP3hXon3zjZlcD6qrvzP
EwytaRLOmu/FhqgMerdxFoZOdtvck3Biw4PNN04uSMfQ8tPbJDwWsmGNixWk
3cSQ4+7377coT7wfLrPpehKGburn1wyNsKD04bnvSlcxBBqzp6NGFhxJMvks
E4ehmuYqd6MXLAiv6Qo8FYOhPWufiHalsECza+aNWT0cZM/yk8930IDLC9a5
Ny/iotp3MHhwlQY8Gk4PCfuLi1x4pR6i2zXgdGBUR9U9LgoztnTjHdaAsCuL
Nvh95KK93gvfNl7WgDZtdxHrDi4K9LgmXpqrAU2HPvzK+spFzu20OKxJA0QC
9X8XfeCi59eMGtrFNUE+56yrUToX1RX73N2Ia0Kk451CLX8uUihIfSxtognS
1oJ39AVcZFRRdFPWVpP6vxTvNqizYLkmbJpfIWOSzKHWq7TtmextHGr/umd/
HpaczaH87xgubPET51DxT40JPkd0K1P4ghyjPw11KVP4Gz5BULEoh+JXN+Te
66nFofhnBtitebyZQ+nz3uq6/+ZEDqWfRUTzQuX2KX1dtJpMPSLE0dqItfVZ
Durge3nzs54RMfTyg9TAmI06GEvfP5z0lxiyCx4K9TdSh0hae5a4jBhS3hl6
2oWvDtGFV8qKhKLIwDAGjxVVh493LUK1L4kidbM5327UC6Bluttlh8uiyC6n
YM3afwRwg37nktoLUdQkHi13LlYAxyO+F1opiKGCSucl3L8EcHL7g8HtQWIo
sh4z8toqgLP+L7/dlBBHO9+JLN2xUkD9v2MQZfmWDgL4Fr/Ne4m6BLXef9fX
NfiWBLX/V7BxVLISjfL/QTog77U7DTVOxo+lFUD8ORqFL3n7l1JhJI3C3253
+hTvTxrFr2P6khutXBrFfwnjYL31PQlkO6kP/a+i+N+zJSj98A4b1RMJU/o+
f3eOPxr9lWh5stNw2isMOufV0JyH2ol40/BD3rkYaEyPybDzbCfuZLpGBGRg
YDSLuVj8UxshslJUxywZg9xImcT0NW1EYFC2TkYsBqGV1Xf2V34h2GcqA2rC
MWBLrv55xPULIdV0UBsCMPh2wud5d08r4TrdzNZ9LwYh9nq35SUaif0pC268
zuTDUkjuUTVqIKTv/P7TIIUPV07G5e89UE/sHQpmbo/lQ0qVi5HzyzqiZ5fp
0JYwPliLBJVKa9QRKm8fHdU9zAetHQXYs+haItVmJ7vEiw8XR/HHCQq1hKHm
kj/sN/Nhw3iYTMn1T4SI67zoGxPzu27Q+hffUAOZJk47tsicBg4WwzO89DUQ
phcxfuctDUp+dFxv4WugjU+NLYZX0CGx8mDyS0kNRHshJhX3lA5P/g5ZLNGh
jsREHTrLpBiQdluFxixUR0LlWwt9DRhQqvVo94skdZSZE6K+Yh4Dduw7oT1y
VB19zzPXCGQwwP4P2/WhW9WRoulwv3M2HVj2Ck7VtupI3t0w39iODr2Le10r
TNQRY6V6aX8BDc7eeV6XsVCd+l9KrqfOCV2x8YYEtT9R2X8TG5eg/F+1uD97
MEscPCfj5+V6j5S7iVP4xp5rjIouFqfw97pJfKszFqf4pQdsMTy6VZzin5aT
ysq+K07pszrPp2EtV4LS75wjH0+5KkHpu78+KZEzlwb/B6dqTnc=
        "], {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
            127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 1}, {
            2, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 
            151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 2}, {3, 
            4}, {4, 7}, {5, 6}, {6, 16}, {7, 28}, {8, 9}, {9, 23}, {10, 11}, {
            11, 57}, {12, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 
            172, 173, 174, 175, 176, 177, 13}, {13, 178, 179, 180, 181, 182, 
            183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 12}, {14, 
            15}, {15, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 
            205, 206, 207, 208, 209, 43}, {16, 53}, {17, 18}, {18, 25}, {19, 
            12}, {20, 21}, {21, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
            219, 220, 221, 222, 223, 224, 225, 48}, {22, 23}, {23, 30}, {24, 
            25}, {25, 51}, {26, 27}, {27, 6}, {28, 18}, {29, 30}, {30, 40}, {
            31, 32}, {32, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 
            236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 
            32}, {33, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 
            260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 33}, {
            34, 35}, {35, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 
            282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 
            35}, {36, 37}, {37, 27}, {38, 28}, {39, 40}, {40, 56}, {41, 10}, {
            42, 43}, {43, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 
            305, 306, 307, 308, 309, 310, 15}, {44, 45}, {45, 311, 312, 313, 
            314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 
            66}, {46, 47}, {47, 9}, {48, 327, 328, 329, 330, 331, 332, 333, 
            334, 335, 336, 337, 338, 339, 340, 341, 342, 21}, {49, 13}, {50, 
            51}, {51, 4}, {52, 53}, {53, 72}, {54, 7}, {55, 56}, {56, 47}, {
            57, 64}, {58, 2}, {59, 60}, {60, 343, 344, 345, 346, 347, 348, 
            349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 
            362, 363, 364, 365, 60}, {61, 366, 367, 368, 369, 370, 371, 372, 
            373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 
            386, 387, 388, 61}, {62, 4}, {63, 56}, {64, 75}, {65, 51}, {66, 
            389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 
            402, 403, 404, 45}, {67, 15}, {68, 47}, {69, 41}, {70, 43}, {71, 
            72}, {72, 37}, {73, 25}, {74, 40}, {75, 41}, {76, 35}, {77, 405, 
            406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 
            419, 420, 421, 422, 423, 424, 425, 426, 427, 77}, {78, 30}, {79, 
            75}, {80, 25}, {81, 12}, {82, 47}, {83, 15}, {84, 66}, {85, 51}, {
            86, 9}, {87, 64}, {88, 4}, {89, 61}, {90, 2}, {91, 57}, {92, 
            56}, {93, 7}, {94, 13}, {95, 48}, {96, 18}, {97, 43}, {98, 23}, {
            99, 10}, {100, 40}, {101, 28}, {102, 35}, {103, 33}, {104, 30}, {
            105, 28}, {106, 23}, {107, 12}, {108, 18}, {109, 16}, {110, 13}, {
            111, 11}, {112, 9}, {113, 7}, {114, 2}, {115, 1}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[13],
            "49"],
           Annotation[#, 49, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[14],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[15],
            "64"],
           Annotation[#, 64, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[16],
            "81"],
           Annotation[#, 81, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[17],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[18],
            "100"],
           Annotation[#, 100, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[19],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[20],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[21],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[22],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[23],
            "55"],
           Annotation[#, 55, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[24],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[25],
            "82"],
           Annotation[#, 82, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[26],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[27],
            "111"],
           Annotation[#, 111, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[28],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[29],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[30],
            "61"],
           Annotation[#, 61, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[31],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[32],
            "96"],
           Annotation[#, 96, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[33],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[34],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[35],
            "58"],
           Annotation[#, 58, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[36],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[37],
            "99"],
           Annotation[#, 99, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[38],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[39],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[40],
            "73"],
           Annotation[#, 73, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[41],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[42],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[43],
            "106"],
           Annotation[#, 106, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[44],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[45],
            "45"],
           Annotation[#, 45, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[46],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[47],
            "43"],
           Annotation[#, 43, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[48],
            "102"],
           Annotation[#, 102, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[49],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[50],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[51],
            "112"],
           Annotation[#, 112, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[52],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[53],
            "63"],
           Annotation[#, 63, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[54],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[55],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[56],
            "85"],
           Annotation[#, 85, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[57],
            "42"],
           Annotation[#, 42, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[58],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[59],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[60],
            "76"],
           Annotation[#, 76, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[61],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[62],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[63],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[64],
            "54"],
           Annotation[#, 54, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[65],
            "44"],
           Annotation[#, 44, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[66],
            "87"],
           Annotation[#, 87, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[67],
            "46"],
           Annotation[#, 46, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[68],
            "47"],
           Annotation[#, 47, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[69],
            "48"],
           Annotation[#, 48, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[70],
            "50"],
           Annotation[#, 50, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[71],
            "51"],
           Annotation[#, 51, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[72],
            "93"],
           Annotation[#, 93, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[73],
            "52"],
           Annotation[#, 52, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[74],
            "53"],
           Annotation[#, 53, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[75],
            "66"],
           Annotation[#, 66, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[76],
            "56"],
           Annotation[#, 56, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[77],
            "57"],
           Annotation[#, 57, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[78],
            "59"],
           Annotation[#, 59, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[79],
            "60"],
           Annotation[#, 60, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[80],
            "62"],
           Annotation[#, 62, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[81],
            "65"],
           Annotation[#, 65, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[82],
            "67"],
           Annotation[#, 67, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[83],
            "68"],
           Annotation[#, 68, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[84],
            "69"],
           Annotation[#, 69, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[85],
            "70"],
           Annotation[#, 70, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[86],
            "71"],
           Annotation[#, 71, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[87],
            "72"],
           Annotation[#, 72, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[88],
            "74"],
           Annotation[#, 74, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[89],
            "75"],
           Annotation[#, 75, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[90],
            "77"],
           Annotation[#, 77, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[91],
            "78"],
           Annotation[#, 78, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[92],
            "79"],
           Annotation[#, 79, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[93],
            "80"],
           Annotation[#, 80, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[94],
            "83"],
           Annotation[#, 83, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[95],
            "84"],
           Annotation[#, 84, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[96],
            "86"],
           Annotation[#, 86, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[97],
            "88"],
           Annotation[#, 88, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[98],
            "89"],
           Annotation[#, 89, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[99],
            "90"],
           Annotation[#, 90, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[100],
            "91"],
           Annotation[#, 91, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[101],
            "92"],
           Annotation[#, 92, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[102],
            "94"],
           Annotation[#, 94, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[103],
            "95"],
           Annotation[#, 95, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[104],
            "97"],
           Annotation[#, 97, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[105],
            "98"],
           Annotation[#, 98, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[106],
            "101"],
           Annotation[#, 101, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[107],
            "103"],
           Annotation[#, 103, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[108],
            "104"],
           Annotation[#, 104, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[109],
            "105"],
           Annotation[#, 105, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[110],
            "107"],
           Annotation[#, 107, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[111],
            "108"],
           Annotation[#, 108, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[112],
            "109"],
           Annotation[#, 109, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[113],
            "110"],
           Annotation[#, 110, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[114],
            "113"],
           Annotation[#, 113, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[115],
            "114"],
           Annotation[#, 114, "Tooltip"]& ]}}],
       Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxdVXswnFcUXxQbS6zdxbJeu+tdJGFoo/iuMDKITEIU0bRibLWZRFPRSFVS
1ZCsGR1aicS7Hk29KhM0ySz20iiqJF6rxWI8UyISghGvtuHcmeSPb+6cP+49
v9c5Hz/8M3+RIo1GO/ff9/9ZijzCbUMF6NU5yMeNuvL8l3U8NBK5UVriaYw9
mlq9l9MnqVsneS5evBnpSMzNglTBMkWbCLALXeiTmldem7//XAt5aUePODE4
OPLi4YfVpjqI53jIJ81NCxuy52dc3XehgmXDdyqKMPV2rGJLHWuIwq/6MPBg
fNocXbRIfdyR+etQjio+vckKOWhrgIojRMUJN8akB+53ZnZ/ykVc/LgsNnBR
uje4xivHZZXi559yDT6vgytlpYs+V0eprGRntdM+eth9pme84uUWRTdMn2Qc
NcGp5SF/pX9JR5n+/ptKnYb4aKrkclgDh+D1iG4WBBQqolufJJ+tynshte1U
OPT3KRUEfF3FnMqYjEXy/ouJzOIjuSaoxmX9jMkTfZwjCt8bkMJHbOduN513
dXGaFg97lqwRPhcNb9gPs1QQ41v/joZ4JZwQoDMwwyqUfmWy1STZsy4d5hQ8
7VEYoqD/9ydiIo4/56LopcwYeb8O/tlPtaoySJ/gVQ8eEhfqqiPQ/8iFJdeH
im8h0LM/Us5bt1dD0P8uzzRD1UaI1AcrfW1/aaSg3uY1u8OPvV1zhHh+yCXx
/JoxsuH09RbJWYTf775ZT6avauJ616xVWgMP5fTV77pcrEdqwKtr7fbFRw5q
RD/AxwsXiLlyTVzW5GwxJ6ATvGbYyjMqypD4C/41M1fbtSV8zHkgZlwqUUbg
5+Oskn9CLCukwh5/b7zAx9t9Bqjurvp9Eq4JTsge8EgxbaGgH010nS4TPyV5
85yyqQuMFRD/EjIC2/1Otko5UWr9XxsZYN049xxF4RzxY4l7Ilb1+ALJP+Qd
+LvkWjprBLMJ/+VqbrXlqCbxB/C8J3PYn72phX0fMZyyvKcIvpSVuxXllrpI
3pGnVPXhhvSCVWDjH0VcxCk/8GDGjo93cKKurskViZ/wjdoMb/untFOb4rZH
fW3s2VWCF/pB/y7HHxsvT2uj7jPWdovVShjmGfi+L6kdaJfPUqCv6g9WJSV+
DKI/zCvgh3kF/OAX+Afz1lo7nmf9uQGpQT/IP8wD5APeH/4G7blWZUTehzxC
PoMpGdPKyQxtn8pYWSOByfBQJ/mC+8AX/IV+Aotjo79NbJL5hvmF/hu3I/Kn
4piEP+hzrnc6rPlPIb5jw1q8Wb1B9HNq6ZOZJ62QvIHeNTFJA9/do+PDnha7
mQ20N/YL+GdO9i/4D/sP8IP+4OezK9ZRQb1aJG+wDyHPkPdjlHmudYERJvtt
By/4C37Z3xEo6wfsJvvjukeQft0zYzKfoC/oo5Aclze5pkH44A9+Mp7VERJ/
Xt8vZvh2+Vh8xj4m8Wfp7OC44xiT3D+46bCSvV+L9E8aaxOL9ZUR+EP2yw5+
+N/A/MG+Bv5rcZOJq2V6JD+zoWGl4c1bxJ+J2tbErHtsop+aiuiStcyI6P/6
/1GI/wXkHWt4
         "]]& ],
      AspectRatio->1.0226504196774027`,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox["\"ClosestPacking\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[GraphicsComplexBox[CompressedData["
1:eJxdWHk8Vd33vmZd0z33HtdQkkZKRYpQzlYyRClRolARyRyVikKkUqGQqQyR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        "], {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
            127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 1}, {
            2, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 
            151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 2}, {3, 
            4}, {4, 7}, {5, 6}, {6, 16}, {7, 28}, {8, 9}, {9, 23}, {10, 11}, {
            11, 57}, {12, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 
            172, 173, 174, 175, 176, 177, 13}, {13, 178, 179, 180, 181, 182, 
            183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 12}, {14, 
            15}, {15, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 
            205, 206, 207, 208, 209, 43}, {16, 53}, {17, 18}, {18, 25}, {19, 
            12}, {20, 21}, {21, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
            219, 220, 221, 222, 223, 224, 225, 48}, {22, 23}, {23, 30}, {24, 
            25}, {25, 51}, {26, 27}, {27, 6}, {28, 18}, {29, 30}, {30, 40}, {
            31, 32}, {32, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 
            236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 
            32}, {33, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 
            260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 33}, {
            34, 35}, {35, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 
            282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 
            35}, {36, 37}, {37, 27}, {38, 28}, {39, 40}, {40, 56}, {41, 10}, {
            42, 43}, {43, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 
            305, 306, 307, 308, 309, 310, 15}, {44, 45}, {45, 311, 312, 313, 
            314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 
            66}, {46, 47}, {47, 9}, {48, 327, 328, 329, 330, 331, 332, 333, 
            334, 335, 336, 337, 338, 339, 340, 341, 342, 21}, {49, 13}, {50, 
            51}, {51, 4}, {52, 53}, {53, 72}, {54, 7}, {55, 56}, {56, 47}, {
            57, 64}, {58, 2}, {59, 60}, {60, 343, 344, 345, 346, 347, 348, 
            349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 
            362, 363, 364, 365, 60}, {61, 366, 367, 368, 369, 370, 371, 372, 
            373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 
            386, 387, 388, 61}, {62, 4}, {63, 56}, {64, 75}, {65, 51}, {66, 
            389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 
            402, 403, 404, 45}, {67, 15}, {68, 47}, {69, 41}, {70, 43}, {71, 
            72}, {72, 37}, {73, 25}, {74, 40}, {75, 41}, {76, 35}, {77, 405, 
            406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 
            419, 420, 421, 422, 423, 424, 425, 426, 427, 77}, {78, 30}, {79, 
            75}, {80, 25}, {81, 12}, {82, 47}, {83, 15}, {84, 66}, {85, 51}, {
            86, 9}, {87, 64}, {88, 4}, {89, 61}, {90, 2}, {91, 57}, {92, 
            56}, {93, 7}, {94, 13}, {95, 48}, {96, 18}, {97, 43}, {98, 23}, {
            99, 10}, {100, 40}, {101, 28}, {102, 35}, {103, 33}, {104, 30}, {
            105, 28}, {106, 23}, {107, 12}, {108, 18}, {109, 16}, {110, 13}, {
            111, 11}, {112, 9}, {113, 7}, {114, 2}, {115, 1}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[13],
            "49"],
           Annotation[#, 49, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[14],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[15],
            "64"],
           Annotation[#, 64, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[16],
            "81"],
           Annotation[#, 81, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[17],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[18],
            "100"],
           Annotation[#, 100, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[19],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[20],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[21],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[22],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[23],
            "55"],
           Annotation[#, 55, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[24],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[25],
            "82"],
           Annotation[#, 82, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[26],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[27],
            "111"],
           Annotation[#, 111, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[28],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[29],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[30],
            "61"],
           Annotation[#, 61, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[31],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[32],
            "96"],
           Annotation[#, 96, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[33],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[34],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[35],
            "58"],
           Annotation[#, 58, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[36],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[37],
            "99"],
           Annotation[#, 99, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[38],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[39],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[40],
            "73"],
           Annotation[#, 73, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[41],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[42],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[43],
            "106"],
           Annotation[#, 106, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[44],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[45],
            "45"],
           Annotation[#, 45, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[46],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[47],
            "43"],
           Annotation[#, 43, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[48],
            "102"],
           Annotation[#, 102, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[49],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[50],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[51],
            "112"],
           Annotation[#, 112, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[52],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[53],
            "63"],
           Annotation[#, 63, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[54],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[55],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[56],
            "85"],
           Annotation[#, 85, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[57],
            "42"],
           Annotation[#, 42, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[58],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[59],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[60],
            "76"],
           Annotation[#, 76, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[61],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[62],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[63],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[64],
            "54"],
           Annotation[#, 54, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[65],
            "44"],
           Annotation[#, 44, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[66],
            "87"],
           Annotation[#, 87, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[67],
            "46"],
           Annotation[#, 46, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[68],
            "47"],
           Annotation[#, 47, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[69],
            "48"],
           Annotation[#, 48, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[70],
            "50"],
           Annotation[#, 50, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[71],
            "51"],
           Annotation[#, 51, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[72],
            "93"],
           Annotation[#, 93, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[73],
            "52"],
           Annotation[#, 52, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[74],
            "53"],
           Annotation[#, 53, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[75],
            "66"],
           Annotation[#, 66, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[76],
            "56"],
           Annotation[#, 56, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[77],
            "57"],
           Annotation[#, 57, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[78],
            "59"],
           Annotation[#, 59, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[79],
            "60"],
           Annotation[#, 60, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[80],
            "62"],
           Annotation[#, 62, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[81],
            "65"],
           Annotation[#, 65, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[82],
            "67"],
           Annotation[#, 67, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[83],
            "68"],
           Annotation[#, 68, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[84],
            "69"],
           Annotation[#, 69, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[85],
            "70"],
           Annotation[#, 70, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[86],
            "71"],
           Annotation[#, 71, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[87],
            "72"],
           Annotation[#, 72, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[88],
            "74"],
           Annotation[#, 74, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[89],
            "75"],
           Annotation[#, 75, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[90],
            "77"],
           Annotation[#, 77, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[91],
            "78"],
           Annotation[#, 78, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[92],
            "79"],
           Annotation[#, 79, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[93],
            "80"],
           Annotation[#, 80, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[94],
            "83"],
           Annotation[#, 83, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[95],
            "84"],
           Annotation[#, 84, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[96],
            "86"],
           Annotation[#, 86, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[97],
            "88"],
           Annotation[#, 88, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[98],
            "89"],
           Annotation[#, 89, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[99],
            "90"],
           Annotation[#, 90, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[100],
            "91"],
           Annotation[#, 91, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[101],
            "92"],
           Annotation[#, 92, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[102],
            "94"],
           Annotation[#, 94, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[103],
            "95"],
           Annotation[#, 95, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[104],
            "97"],
           Annotation[#, 97, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[105],
            "98"],
           Annotation[#, 98, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[106],
            "101"],
           Annotation[#, 101, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[107],
            "103"],
           Annotation[#, 103, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[108],
            "104"],
           Annotation[#, 104, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[109],
            "105"],
           Annotation[#, 105, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[110],
            "107"],
           Annotation[#, 107, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[111],
            "108"],
           Annotation[#, 108, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[112],
            "109"],
           Annotation[#, 109, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[113],
            "110"],
           Annotation[#, 110, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[114],
            "113"],
           Annotation[#, 113, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[115],
            "114"],
           Annotation[#, 114, "Tooltip"]& ]}}],
       Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxdVQ1MlGUcP+44vI6743g5zvBCJA1jfZhaFpq8j45hipkcQqcs8hjMmzXR
ZExKGIzRINn4GBPEYBLDISkFlUfZeB+RTCEulni5POG4IsUQsqO6Sz4q3/s9
G9x2uz275/3/f1///xuZnmXMlEokksP/ff//xWdjqe5cdjVHFeGVo4GJWno5
oW78dkkQNbXHvTDx5rSAeyfry79MDbgv7Bh2bV0dN8Rvvx8Rn1rh5iWzun5r
zJzw5InC9MhnpWRXXt6R8EVTQsHK/X+v+OxX/rWH9yf4LY2y49kXNXT5NeNW
+ocf6Wo3dG6pVND88No1Q1wAaVNtLurWB5DzVktvLMeRz/0P+3VEzPAfWHLu
jEQEkerssai6G78JV51vT0gfmxNWrNzlvPTLrGDi7drodXIa67lSG12u89UP
JuBT/9Xj+sHLOuI9ZK37s3uW4SUPcXWBjw+vnZ+vi5vVP/ii56R6QkXwv68+
8Q/dmZt46h6fsc9uiz7kz/ikNdd4bpo9wo19twzTa5TkmOuoiTpk1KeH0Pg+
WbVeJ6Hon7+7v+zAt4vI675+Z2LckaHVSgK8DaL+PPTvnHSMeAunBejZqlVH
nYr8XUB/EX8IiT/dXFUwqqY4i/c56uhvkH2SNiPA/8TAsJ4N+0OodOxa7dJi
CcuD89ESa17zlDAYFma9sFdNzs1Fbsj5XklxBl5L0ellH793l+kHfJXBBhrX
/ID3TzUGdW2aYniXVWTt1p5QEPgL/5J+lHtNGzWkR+vtC70QzPwcd7Ul/JMy
KoBHi9nwcryhVxg6FuvIf2UxWb886ZuLFi1Fv/GUrrMpjUqWN9PSqBntUxzz
r9h1tbR0iZwmaHJadw4p6YFkhcpS42F5KPb2uUZsUyz/yDv4f9T+1sGWaC8P
/u+IzzN/gOfm0Yp7ikw3Hza9tzGzXcXw/TCzOFlv8PAiDyWB/k/rrg823eKY
X2L+Asn8s2zBWU/SRf0ZXvRD/8m/vm55V+/me/bQ8la9nCyYZ+G5jM2pbVUD
POoeNxpnZTY10x/zCvyYV+CHX/AP8yZ1nu8wP6+lOEM/5B/zgHygflVI/ao0
QyCrjzwin7788iL/UPphWXmuv+wOyxeeB1/4i36f2s+4t5U42XxjftG/qagj
w/GEgvGHPjHq6w8GaRCp6HvG1nDXxfSrVOVeeqkwgOUNeruSMn/WcBJyRNwv
zJ/5/nGMH/zH/gN+6A8/m0T9CPKGfYg8I+++/cT2G/DCX/g1MPnIjsriYbY/
pDW98rP1ajaf0Bf6lIjzweY9/w1O05mlXOiPb171dKBsLHGt0sb82SO+X9jz
ktUB3cNf1PDoX1Cd3Peq+QpvWrBfgB/vG8wf9jX4fye/bY/i/Fh+1nWv/WmJ
Wcr88e1jph/wQ//5Punpv8VsIqg=
         "]]& ],
      AspectRatio->1.0666231549355376`,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox["\"ClosestPackingCenter\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]], 
     GraphicsBox[
      TagBox[GraphicsComplexBox[CompressedData["
1:eJxlWHs8VVvXdk8l11KRrIXItte22WuTHPZQdJFKIkVRiiQUlUtuSQgVUUkX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        "], {
         {RGBColor[0.5, 0., 0.], 
          LineBox[{{1, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
            127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 1}, {
            2, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 
            151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 2}, {3, 
            4}, {4, 7}, {5, 6}, {6, 16}, {7, 28}, {8, 9}, {9, 23}, {10, 11}, {
            11, 57}, {12, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 
            172, 173, 174, 175, 176, 177, 13}, {13, 178, 179, 180, 181, 182, 
            183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 12}, {14, 
            15}, {15, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 
            205, 206, 207, 208, 209, 43}, {16, 53}, {17, 18}, {18, 25}, {19, 
            12}, {20, 21}, {21, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
            219, 220, 221, 222, 223, 224, 225, 48}, {22, 23}, {23, 30}, {24, 
            25}, {25, 51}, {26, 27}, {27, 6}, {28, 18}, {29, 30}, {30, 40}, {
            31, 32}, {32, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 
            236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 
            32}, {33, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 
            260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 33}, {
            34, 35}, {35, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 
            282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 
            35}, {36, 37}, {37, 27}, {38, 28}, {39, 40}, {40, 56}, {41, 10}, {
            42, 43}, {43, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 
            305, 306, 307, 308, 309, 310, 15}, {44, 45}, {45, 311, 312, 313, 
            314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 
            66}, {46, 47}, {47, 9}, {48, 327, 328, 329, 330, 331, 332, 333, 
            334, 335, 336, 337, 338, 339, 340, 341, 342, 21}, {49, 13}, {50, 
            51}, {51, 4}, {52, 53}, {53, 72}, {54, 7}, {55, 56}, {56, 47}, {
            57, 64}, {58, 2}, {59, 60}, {60, 343, 344, 345, 346, 347, 348, 
            349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 
            362, 363, 364, 365, 60}, {61, 366, 367, 368, 369, 370, 371, 372, 
            373, 374, 375, 376, 377, 378, 379, 380, 381, 382, 383, 384, 385, 
            386, 387, 388, 61}, {62, 4}, {63, 56}, {64, 75}, {65, 51}, {66, 
            389, 390, 391, 392, 393, 394, 395, 396, 397, 398, 399, 400, 401, 
            402, 403, 404, 45}, {67, 15}, {68, 47}, {69, 41}, {70, 43}, {71, 
            72}, {72, 37}, {73, 25}, {74, 40}, {75, 41}, {76, 35}, {77, 405, 
            406, 407, 408, 409, 410, 411, 412, 413, 414, 415, 416, 417, 418, 
            419, 420, 421, 422, 423, 424, 425, 426, 427, 77}, {78, 30}, {79, 
            75}, {80, 25}, {81, 12}, {82, 47}, {83, 15}, {84, 66}, {85, 51}, {
            86, 9}, {87, 64}, {88, 4}, {89, 61}, {90, 2}, {91, 57}, {92, 
            56}, {93, 7}, {94, 13}, {95, 48}, {96, 18}, {97, 43}, {98, 23}, {
            99, 10}, {100, 40}, {101, 28}, {102, 35}, {103, 33}, {104, 30}, {
            105, 28}, {106, 23}, {107, 12}, {108, 18}, {109, 16}, {110, 13}, {
            111, 11}, {112, 9}, {113, 7}, {114, 2}, {115, 1}}]}, 
         {RGBColor[0, 0, 0.7], 
          TagBox[
           TooltipBox[PointBox[1],
            "0"],
           Annotation[#, 0, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[2],
            "1"],
           Annotation[#, 1, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[3],
            "2"],
           Annotation[#, 2, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[4],
            "4"],
           Annotation[#, 4, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[5],
            "3"],
           Annotation[#, 3, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[6],
            "9"],
           Annotation[#, 9, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[7],
            "16"],
           Annotation[#, 16, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[8],
            "5"],
           Annotation[#, 5, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[9],
            "25"],
           Annotation[#, 25, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[10],
            "6"],
           Annotation[#, 6, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[11],
            "36"],
           Annotation[#, 36, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[12],
            "7"],
           Annotation[#, 7, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[13],
            "49"],
           Annotation[#, 49, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[14],
            "8"],
           Annotation[#, 8, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[15],
            "64"],
           Annotation[#, 64, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[16],
            "81"],
           Annotation[#, 81, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[17],
            "10"],
           Annotation[#, 10, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[18],
            "100"],
           Annotation[#, 100, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[19],
            "11"],
           Annotation[#, 11, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[20],
            "12"],
           Annotation[#, 12, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[21],
            "30"],
           Annotation[#, 30, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[22],
            "13"],
           Annotation[#, 13, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[23],
            "55"],
           Annotation[#, 55, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[24],
            "14"],
           Annotation[#, 14, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[25],
            "82"],
           Annotation[#, 82, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[26],
            "15"],
           Annotation[#, 15, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[27],
            "111"],
           Annotation[#, 111, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[28],
            "28"],
           Annotation[#, 28, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[29],
            "17"],
           Annotation[#, 17, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[30],
            "61"],
           Annotation[#, 61, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[31],
            "18"],
           Annotation[#, 18, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[32],
            "96"],
           Annotation[#, 96, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[33],
            "19"],
           Annotation[#, 19, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[34],
            "20"],
           Annotation[#, 20, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[35],
            "58"],
           Annotation[#, 58, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[36],
            "21"],
           Annotation[#, 21, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[37],
            "99"],
           Annotation[#, 99, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[38],
            "22"],
           Annotation[#, 22, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[39],
            "23"],
           Annotation[#, 23, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[40],
            "73"],
           Annotation[#, 73, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[41],
            "24"],
           Annotation[#, 24, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[42],
            "26"],
           Annotation[#, 26, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[43],
            "106"],
           Annotation[#, 106, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[44],
            "27"],
           Annotation[#, 27, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[45],
            "45"],
           Annotation[#, 45, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[46],
            "29"],
           Annotation[#, 29, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[47],
            "43"],
           Annotation[#, 43, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[48],
            "102"],
           Annotation[#, 102, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[49],
            "31"],
           Annotation[#, 31, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[50],
            "32"],
           Annotation[#, 32, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[51],
            "112"],
           Annotation[#, 112, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[52],
            "33"],
           Annotation[#, 33, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[53],
            "63"],
           Annotation[#, 63, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[54],
            "34"],
           Annotation[#, 34, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[55],
            "35"],
           Annotation[#, 35, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[56],
            "85"],
           Annotation[#, 85, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[57],
            "42"],
           Annotation[#, 42, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[58],
            "37"],
           Annotation[#, 37, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[59],
            "38"],
           Annotation[#, 38, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[60],
            "76"],
           Annotation[#, 76, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[61],
            "39"],
           Annotation[#, 39, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[62],
            "40"],
           Annotation[#, 40, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[63],
            "41"],
           Annotation[#, 41, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[64],
            "54"],
           Annotation[#, 54, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[65],
            "44"],
           Annotation[#, 44, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[66],
            "87"],
           Annotation[#, 87, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[67],
            "46"],
           Annotation[#, 46, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[68],
            "47"],
           Annotation[#, 47, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[69],
            "48"],
           Annotation[#, 48, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[70],
            "50"],
           Annotation[#, 50, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[71],
            "51"],
           Annotation[#, 51, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[72],
            "93"],
           Annotation[#, 93, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[73],
            "52"],
           Annotation[#, 52, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[74],
            "53"],
           Annotation[#, 53, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[75],
            "66"],
           Annotation[#, 66, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[76],
            "56"],
           Annotation[#, 56, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[77],
            "57"],
           Annotation[#, 57, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[78],
            "59"],
           Annotation[#, 59, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[79],
            "60"],
           Annotation[#, 60, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[80],
            "62"],
           Annotation[#, 62, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[81],
            "65"],
           Annotation[#, 65, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[82],
            "67"],
           Annotation[#, 67, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[83],
            "68"],
           Annotation[#, 68, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[84],
            "69"],
           Annotation[#, 69, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[85],
            "70"],
           Annotation[#, 70, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[86],
            "71"],
           Annotation[#, 71, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[87],
            "72"],
           Annotation[#, 72, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[88],
            "74"],
           Annotation[#, 74, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[89],
            "75"],
           Annotation[#, 75, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[90],
            "77"],
           Annotation[#, 77, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[91],
            "78"],
           Annotation[#, 78, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[92],
            "79"],
           Annotation[#, 79, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[93],
            "80"],
           Annotation[#, 80, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[94],
            "83"],
           Annotation[#, 83, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[95],
            "84"],
           Annotation[#, 84, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[96],
            "86"],
           Annotation[#, 86, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[97],
            "88"],
           Annotation[#, 88, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[98],
            "89"],
           Annotation[#, 89, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[99],
            "90"],
           Annotation[#, 90, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[100],
            "91"],
           Annotation[#, 91, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[101],
            "92"],
           Annotation[#, 92, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[102],
            "94"],
           Annotation[#, 94, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[103],
            "95"],
           Annotation[#, 95, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[104],
            "97"],
           Annotation[#, 97, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[105],
            "98"],
           Annotation[#, 98, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[106],
            "101"],
           Annotation[#, 101, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[107],
            "103"],
           Annotation[#, 103, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[108],
            "104"],
           Annotation[#, 104, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[109],
            "105"],
           Annotation[#, 105, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[110],
            "107"],
           Annotation[#, 107, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[111],
            "108"],
           Annotation[#, 108, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[112],
            "109"],
           Annotation[#, 109, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[113],
            "110"],
           Annotation[#, 110, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[114],
            "113"],
           Annotation[#, 113, "Tooltip"]& ], 
          TagBox[
           TooltipBox[PointBox[115],
            "114"],
           Annotation[#, 114, "Tooltip"]& ]}}],
       Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxlVQ9Q03UUX9AREDB3iusGY387Yn+RbaBm+z0OpVNJE3Pjj8af4sqQ7MYx
wQEJoji1G3/UokOu29Isjv4InQZegSF0AnKWjUt2sqPiciXIJHCYWAHvddru
drt33+/3vc+f995EubtT8/xYLFbhP99/f30196/u12ug7rnXSppjl4DWfNA2
HC0Cl3zCOLzeH0qj35iRto4x1RueuVpRoADLfDzNVOTsyXRkKeE3x+1Gr3CK
Cbm/1R7jEIHZezO0wOwHoltjf5QGSSB/l/GE1RoEluKeX7u3qGDDJz/0VHIj
APOF2Xt1Deoo4J8s2WgtUoJ9WUk5z6cE38C2jwYnVBDqdfKzuQpgQpgLZz5V
wvtF3e0RAh0k6WvOHRlSwkD59AvH2FrKF8f5Mb+BEwXTIV1G5xoh8Wllxejd
p0VwXHpo8ujWB4S3tk95pcnjB+9ofkrOtsgX+QVQvuZiWWJD93/5jSvX3eNu
0lJ+PE8OM+weXi6GJoku/JpASHz6vhsK+lkthi8nLl+qKVMBa/FTH3n4gt4q
gxdHRtevWHuDwfr9Z3Ur29mBlH+mLnMg2xUMiDfji7W68awQQP33CT5LGWkW
Eb6ciJgqT4KE6h/vctxJi4tdrHubeThmsTBG/71PXo/veukeU9P0tW5GNcsc
GS1N63T5Uz+ICytyn/g4FC6u2s4LaOFTjHjz9p8WNluCCQ/im5xxGvbmyWG5
idU71iqm87eLHp9qaVCRv+ifKe7s6Hun+GAoTW10moSUP0ojKavKV1Dc03or
sDpNSfq3GStTLGwe1SvebO6ojeZTvQfn2dW8Z3X0frzqYoYtQwN9hk7PHn/5
oh/j5MdCf3ip/7Hfkb/+1TW9TLuPwXz2g6BevWwJ+YN40k8dcJl2yMD9lzTx
sCCS8K2o3Xim3ywnfMK5KqiOFwDqn/tLvWx7ioz8ezhmsTBG/xb0nyW8WA/r
b4vtjFvllMHgIc5YhkJO84x839SeP2ZdpyJ9lr7VXul2iSjGeUX8OK9YD/1C
/3DeTqTHH8hy8yhG/bD/cR6wPzB/ptO2M3G1mvJjP6I+uL8W1HAzLd1bEsc7
JHQf3yNf9BfrWU0va5tKdHQf5xfrD74i3ulJlhB/1CeFm7bPfikSNs3nmyP9
Ppx66vMPEgSUD/UO752d1fweA40nbV9lBjxG5+if1HLFa8gJpH2F/HD/IX7U
H/18t+1GUtldDvUb7kPsZ+x3xIv7DfGiv+jX3YK9c5OMlPZHQkLEyLXrappP
1Bf12TzPP4z48L85Gi5kBxN+3C/IL4nr6PjzWyndX9CDQ7Gts6/Y9/zTVP/1
XXXRDlU8neN+Qfz4f/PoPkb+ntTc+jvnFPT+Zv+O74ccwkf6aSnpl15wubyw
Tfy//kL8fwOjdwnC
         "]]& ],
      AspectRatio->0.8484784798889841,
      BaselinePosition->Top,
      FrameTicks->None,
      ImageSize->150,
      PlotLabel->FormBox["\"NestedGrid\"", TraditionalForm],
      PlotRange->All,
      PlotRangePadding->Scaled[0.1]]}
   }],
  "Grid"]], "Output",
 ImageSize->{470, 369},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1871102719]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRangePadding",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->44888674],

Cell[TextData[{
 "Use different ",
 Cell[BoxData[
  ButtonBox["PlotRangePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRangePadding"]], "InlineFormula"],
 " around the graph: "
}], "ExampleText",
 CellID->1808033363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{
     RowBox[{"TreePlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "\[Rule]", "8"}], ",", 
         RowBox[{"2", "\[Rule]", "3"}], ",", 
         RowBox[{"3", "\[Rule]", "7"}], ",", 
         RowBox[{"3", "\[Rule]", "8"}], ",", 
         RowBox[{"4", "\[Rule]", "8"}], ",", 
         RowBox[{"5", "\[Rule]", "7"}], ",", 
         RowBox[{"6", "\[Rule]", "7"}]}], "}"}], ",", 
       RowBox[{"PlotRangePadding", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"FrameMargins", "\[Rule]", "0"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0.1", ",", 
       RowBox[{"Scaled", "[", "0.1", "]"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->500288768],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    GraphicsBox[
     TagBox[
      GraphicsComplexBox[{{0., 0.}, {0.4183300132670378, 
       0.8366600265340756}, {1.2549900398011133`, 0.8366600265340756}, {
       1.2549900398011133`, 1.6733200530681511`}, {2.091650066335189, 
       0.8366600265340756}, {0.8366600265340756, 0.}, {1.6733200530681511`, 
       0.}, {2.5099800796022267`, 0.}}, {
        {RGBColor[0.5, 0., 0.], 
         LineBox[{{1, 2}, {3, 4}, {4, 5}, {4, 2}, {6, 2}, {7, 5}, {8, 5}}]}, 
        {RGBColor[0, 0, 0.7], 
         TagBox[
          TooltipBox[PointBox[1],
           "1"],
          Annotation[#, 1, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[2],
           "8"],
          Annotation[#, 8, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[3],
           "2"],
          Annotation[#, 2, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[4],
           "3"],
          Annotation[#, 3, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[5],
           "7"],
          Annotation[#, 7, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[6],
           "4"],
          Annotation[#, 4, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[7],
           "5"],
          Annotation[#, 5, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[8],
           "6"],
          Annotation[#, 6, "Tooltip"]& ]}}],
      Annotation[#, 
       VertexCoordinateRules -> {{0., 0.}, {0.4183300132670378, 
        0.8366600265340756}, {1.2549900398011133`, 0.8366600265340756}, {
        1.2549900398011133`, 1.6733200530681511`}, {2.091650066335189, 
        0.8366600265340756}, {0.8366600265340756, 0.}, {1.6733200530681511`, 
        0.}, {2.5099800796022267`, 0.}}]& ],
     AspectRatio->0.816496580927726,
     FrameTicks->None,
     PlotRange->All,
     PlotRangePadding->0],
    FrameMargins->0,
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     TagBox[
      GraphicsComplexBox[{{0., 0.}, {0.4183300132670378, 
       0.8366600265340756}, {1.2549900398011133`, 0.8366600265340756}, {
       1.2549900398011133`, 1.6733200530681511`}, {2.091650066335189, 
       0.8366600265340756}, {0.8366600265340756, 0.}, {1.6733200530681511`, 
       0.}, {2.5099800796022267`, 0.}}, {
        {RGBColor[0.5, 0., 0.], 
         LineBox[{{1, 2}, {3, 4}, {4, 5}, {4, 2}, {6, 2}, {7, 5}, {8, 5}}]}, 
        {RGBColor[0, 0, 0.7], 
         TagBox[
          TooltipBox[PointBox[1],
           "1"],
          Annotation[#, 1, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[2],
           "8"],
          Annotation[#, 8, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[3],
           "2"],
          Annotation[#, 2, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[4],
           "3"],
          Annotation[#, 3, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[5],
           "7"],
          Annotation[#, 7, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[6],
           "4"],
          Annotation[#, 4, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[7],
           "5"],
          Annotation[#, 5, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[8],
           "6"],
          Annotation[#, 6, "Tooltip"]& ]}}],
      Annotation[#, 
       VertexCoordinateRules -> {{0., 0.}, {0.4183300132670378, 
        0.8366600265340756}, {1.2549900398011133`, 0.8366600265340756}, {
        1.2549900398011133`, 1.6733200530681511`}, {2.091650066335189, 
        0.8366600265340756}, {0.8366600265340756, 0.}, {1.6733200530681511`, 
        0.}, {2.5099800796022267`, 0.}}]& ],
     AspectRatio->0.816496580927726,
     FrameTicks->None,
     PlotRange->All,
     PlotRangePadding->0.1],
    FrameMargins->0,
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     TagBox[
      GraphicsComplexBox[{{0., 0.}, {0.4183300132670378, 
       0.8366600265340756}, {1.2549900398011133`, 0.8366600265340756}, {
       1.2549900398011133`, 1.6733200530681511`}, {2.091650066335189, 
       0.8366600265340756}, {0.8366600265340756, 0.}, {1.6733200530681511`, 
       0.}, {2.5099800796022267`, 0.}}, {
        {RGBColor[0.5, 0., 0.], 
         LineBox[{{1, 2}, {3, 4}, {4, 5}, {4, 2}, {6, 2}, {7, 5}, {8, 5}}]}, 
        {RGBColor[0, 0, 0.7], 
         TagBox[
          TooltipBox[PointBox[1],
           "1"],
          Annotation[#, 1, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[2],
           "8"],
          Annotation[#, 8, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[3],
           "2"],
          Annotation[#, 2, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[4],
           "3"],
          Annotation[#, 3, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[5],
           "7"],
          Annotation[#, 7, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[6],
           "4"],
          Annotation[#, 4, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[7],
           "5"],
          Annotation[#, 5, "Tooltip"]& ], 
         TagBox[
          TooltipBox[PointBox[8],
           "6"],
          Annotation[#, 6, "Tooltip"]& ]}}],
      Annotation[#, 
       VertexCoordinateRules -> {{0., 0.}, {0.4183300132670378, 
        0.8366600265340756}, {1.2549900398011133`, 0.8366600265340756}, {
        1.2549900398011133`, 1.6733200530681511`}, {2.091650066335189, 
        0.8366600265340756}, {0.8366600265340756, 0.}, {1.6733200530681511`, 
        0.}, {2.5099800796022267`, 0.}}]& ],
     AspectRatio->0.816496580927726,
     FrameTicks->None,
     PlotRange->All,
     PlotRangePadding->Scaled[0.1]],
    FrameMargins->0,
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{497, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1049022900]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->179618439],

Cell["Specify an overall style for the graph: ", "ExampleText",
 CellID->1676190373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"TreePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "3"}], ",", 
       RowBox[{"1", "\[Rule]", "5"}], ",", 
       RowBox[{"1", "\[Rule]", "6"}], ",", 
       RowBox[{"1", "\[Rule]", "7"}], ",", 
       RowBox[{"2", "\[Rule]", "3"}], ",", 
       RowBox[{"4", "\[Rule]", "5"}], ",", 
       RowBox[{"5", "\[Rule]", "8"}]}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "ps"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ps", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Dashed", ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Red", ",", 
         RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Dashed"}], "]"}]}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14566157],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{1.2265341270883092`, 1.401753288100925}, {0., 
      0.7008766440504625}, {1.0513149660756935`, 0.7008766440504625}, {
      1.752191610126156, 0.7008766440504625}, {2.4530682541766184`, 
      0.7008766440504625}, {0., 0.}, {0.7008766440504625, 0.}, {
      1.401753288100925, 0.}}, {
       {RGBColor[1, 0, 0], 
        LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {3, 8}, {6, 2}, {7, 3}}]}, 
       {RGBColor[1, 0, 0], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "8"],
         Annotation[#, 8, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{1.2265341270883092`, 1.401753288100925}, {0.,
        0.7008766440504625}, {1.0513149660756935`, 0.7008766440504625}, {
       1.752191610126156, 0.7008766440504625}, {2.4530682541766184`, 
       0.7008766440504625}, {0., 0.}, {0.7008766440504625, 0.}, {
       1.401753288100925, 0.}}]& ],
    AspectRatio->0.7559289460184545,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{1.2265341270883092`, 1.401753288100925}, {0., 
      0.7008766440504625}, {1.0513149660756935`, 0.7008766440504625}, {
      1.752191610126156, 0.7008766440504625}, {2.4530682541766184`, 
      0.7008766440504625}, {0., 0.}, {0.7008766440504625, 0.}, {
      1.401753288100925, 0.}}, {
       {RGBColor[0.5, 0., 0.], PointSize[Medium], 
        LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {3, 8}, {6, 2}, {7, 3}}]}, 
       {RGBColor[0, 0, 0.7], PointSize[Medium], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "8"],
         Annotation[#, 8, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{1.2265341270883092`, 1.401753288100925}, {0.,
        0.7008766440504625}, {1.0513149660756935`, 0.7008766440504625}, {
       1.752191610126156, 0.7008766440504625}, {2.4530682541766184`, 
       0.7008766440504625}, {0., 0.}, {0.7008766440504625, 0.}, {
       1.401753288100925, 0.}}]& ],
    AspectRatio->0.7559289460184545,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{1.2265341270883092`, 1.401753288100925}, {0., 
      0.7008766440504625}, {1.0513149660756935`, 0.7008766440504625}, {
      1.752191610126156, 0.7008766440504625}, {2.4530682541766184`, 
      0.7008766440504625}, {0., 0.}, {0.7008766440504625, 0.}, {
      1.401753288100925, 0.}}, {
       {RGBColor[0.5, 0., 0.], Dashing[{Small, Small}], 
        LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {3, 8}, {6, 2}, {7, 3}}]}, 
       {RGBColor[0, 0, 0.7], Dashing[{Small, Small}], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "8"],
         Annotation[#, 8, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{1.2265341270883092`, 1.401753288100925}, {0.,
        0.7008766440504625}, {1.0513149660756935`, 0.7008766440504625}, {
       1.752191610126156, 0.7008766440504625}, {2.4530682541766184`, 
       0.7008766440504625}, {0., 0.}, {0.7008766440504625, 0.}, {
       1.401753288100925, 0.}}]& ],
    AspectRatio->0.7559289460184545,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{1.2265341270883092`, 1.401753288100925}, {0., 
      0.7008766440504625}, {1.0513149660756935`, 0.7008766440504625}, {
      1.752191610126156, 0.7008766440504625}, {2.4530682541766184`, 
      0.7008766440504625}, {0., 0.}, {0.7008766440504625, 0.}, {
      1.401753288100925, 0.}}, {
       {RGBColor[1, 0, 0], PointSize[Medium], Dashing[{Small, Small}], 
        LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {3, 8}, {6, 2}, {7, 3}}]}, 
       {RGBColor[1, 0, 0], PointSize[Medium], Dashing[{Small, Small}], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "8"],
         Annotation[#, 8, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{1.2265341270883092`, 1.401753288100925}, {0.,
        0.7008766440504625}, {1.0513149660756935`, 0.7008766440504625}, {
       1.752191610126156, 0.7008766440504625}, {2.4530682541766184`, 
       0.7008766440504625}, {0., 0.}, {0.7008766440504625, 0.}, {
       1.401753288100925, 0.}}]& ],
    AspectRatio->0.7559289460184545,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{452, 78},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->676210195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297939305],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["VertexRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
 " which has higher priority: "
}], "ExampleText",
 CellID->580503372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"1", "\[Rule]", "7"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "8"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red"}], "]"}]}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p", ",", "l"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"Point", "[", "p", "]"}]}], "}"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317015018],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{1.2265341270883092`, 1.401753288100925}, {0., 
      0.7008766440504625}, {1.0513149660756935`, 0.7008766440504625}, {
      1.752191610126156, 0.7008766440504625}, {2.4530682541766184`, 
      0.7008766440504625}, {0., 0.}, {0.7008766440504625, 0.}, {
      1.401753288100925, 0.}}, 
      {RGBColor[1, 0, 0], PointSize[Large], 
       LineBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {3, 8}, {6, 2}, {7, 3}}]}], 
     {RGBColor[1, 0, 0], PointSize[Large], 
      {RGBColor[0, 1, 0], 
       PointBox[{1.2265341270883092`, 1.401753288100925}]}, 
      {RGBColor[0, 1, 0], PointBox[{0., 0.7008766440504625}]}, 
      {RGBColor[0, 1, 0], 
       PointBox[{1.0513149660756935`, 0.7008766440504625}]}, 
      {RGBColor[0, 1, 0], 
       PointBox[{1.752191610126156, 0.7008766440504625}]}, 
      {RGBColor[0, 1, 0], 
       PointBox[{2.4530682541766184`, 0.7008766440504625}]}, 
      {RGBColor[0, 1, 0], PointBox[{0., 0.}]}, 
      {RGBColor[0, 1, 0], PointBox[{0.7008766440504625, 0.}]}, 
      {RGBColor[0, 1, 0], PointBox[{1.401753288100925, 0.}]}}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.2265341270883092`, 1.401753288100925}, {0., 
     0.7008766440504625}, {1.0513149660756935`, 0.7008766440504625}, {
     1.752191610126156, 0.7008766440504625}, {2.4530682541766184`, 
     0.7008766440504625}, {0., 0.}, {0.7008766440504625, 0.}, {
     1.401753288100925, 0.}}]& ],
  AspectRatio->0.7559289460184545,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1665415811]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->414909817],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " which has higher priority: "
}], "ExampleText",
 CellID->88626299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"1", "\[Rule]", "7"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"5", "\[Rule]", "8"}]}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Dashed", ",", "Red"}], "]"}]}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p", ",", "vl", ",", "el"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"Line", "[", "p", "]"}]}], "}"}]}], "]"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->238367270],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     {RGBColor[1, 0, 0], Dashing[{Small, Small}], 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.2265341270883092`, 1.401753288100925}, {0., 
        0.7008766440504625}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.2265341270883092`, 1.401753288100925}, {
        1.0513149660756935`, 0.7008766440504625}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.2265341270883092`, 1.401753288100925}, {1.752191610126156, 
        0.7008766440504625}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.2265341270883092`, 1.401753288100925}, {
        2.4530682541766184`, 0.7008766440504625}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{1.0513149660756935`, 0.7008766440504625}, {1.401753288100925,
         0.}}]}, 
      {RGBColor[0, 1, 0], LineBox[{{0., 0.}, {0., 0.7008766440504625}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.7008766440504625, 0.}, {1.0513149660756935`, 
        0.7008766440504625}}]}}, 
     GraphicsComplexBox[{{1.2265341270883092`, 1.401753288100925}, {0., 
      0.7008766440504625}, {1.0513149660756935`, 0.7008766440504625}, {
      1.752191610126156, 0.7008766440504625}, {2.4530682541766184`, 
      0.7008766440504625}, {0., 0.}, {0.7008766440504625, 0.}, {
      1.401753288100925, 0.}}, 
      {RGBColor[1, 0, 0], Dashing[{Small, Small}], 
       TagBox[
        TooltipBox[PointBox[1],
         "1"],
        Annotation[#, 1, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[2],
         "3"],
        Annotation[#, 3, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[3],
         "5"],
        Annotation[#, 5, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[4],
         "6"],
        Annotation[#, 6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[5],
         "7"],
        Annotation[#, 7, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[6],
         "2"],
        Annotation[#, 2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[7],
         "4"],
        Annotation[#, 4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[PointBox[8],
         "8"],
        Annotation[#, 8, "Tooltip"]& ]}]}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.2265341270883092`, 1.401753288100925}, {0., 
     0.7008766440504625}, {1.0513149660756935`, 0.7008766440504625}, {
     1.752191610126156, 0.7008766440504625}, {2.4530682541766184`, 
     0.7008766440504625}, {0., 0.}, {0.7008766440504625, 0.}, {
     1.401753288100925, 0.}}]& ],
  AspectRatio->0.7559289460184545,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->940432148]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "SelfLoopStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->91275691],

Cell["Draw self-loops with a specified scaled diameter:", "ExampleText",
 CellID->1053407179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"TreePlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "1"}], ",", 
       RowBox[{"1", "\[Rule]", "2"}], ",", 
       RowBox[{"1", "\[Rule]", "4"}], ",", 
       RowBox[{"2", "\[Rule]", "3"}], ",", 
       RowBox[{"2", "\[Rule]", "5"}], ",", 
       RowBox[{"4", "\[Rule]", "6"}]}], "}"}], ",", 
     RowBox[{"SelfLoopStyle", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"0.1", ",", "0.2", ",", "0.5"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->375686493],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{1.0859306069076735`, 1.7374889710522774`}, {
      0.43437224276306935`, 0.8687444855261387}, {1.7374889710522774`, 
      0.8687444855261387}, {0., 0.}, {0.8687444855261387, 0.}, {
      1.7374889710522774`, 0.}, {1.0851452894893898`, 1.7375013078041113`}, {
      1.0711612733379836`, 1.7397263945683288`}, {1.0583619258628716`, 
      1.745782831065348}, {1.0477739004305862`, 1.7551848221457715`}, {
      1.0402464772076463`, 1.7671782210991054`}, {1.0363834412235755`, 
      1.7808010208046305`}, {1.0364946519384595`, 1.7949605176533177`}, {
      1.0405711889870177`, 1.8085209588158617`}, {1.0482860676934425`, 
      1.820394642548227}, {1.059020466964569, 1.829629164253173}, {
      1.0719133657857844`, 1.8354838101704756`}, {1.0859306069076735`, 
      1.8374889710522773`}, {1.0999478480295626`, 1.8354838101704756`}, {
      1.112840746850778, 1.829629164253173}, {1.1235751461219046`, 
      1.820394642548227}, {1.1312900248283293`, 1.8085209588158617`}, {
      1.1353665618768876`, 1.7949605176533177`}, {1.1354777725917715`, 
      1.7808010208046305`}, {1.1316147366077007`, 1.7671782210991054`}, {
      1.1240873133847609`, 1.7551848221457715`}, {1.1134992879524754`, 
      1.745782831065348}, {1.1006999404773634`, 1.7397263945683288`}, {
      1.0867159243259572`, 1.7375013078041113`}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
          22, 23, 24, 25, 26, 27, 28, 29, 1}, {1, 2}, {1, 3}, {2, 4}, {2, 
          5}, {3, 6}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "6"],
         Annotation[#, 6, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{1.0859306069076735`, 1.7374889710522774`}, {
       0.43437224276306935`, 0.8687444855261387}, {1.7374889710522774`, 
       0.8687444855261387}, {0., 0.}, {0.8687444855261387, 0.}, {
       1.7374889710522774`, 0.}}]& ],
    AspectRatio->1.028374602061966,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{1.0859306069076735`, 1.7374889710522774`}, {
      0.43437224276306935`, 0.8687444855261387}, {1.7374889710522774`, 
      0.8687444855261387}, {0., 0.}, {0.8687444855261387, 0.}, {
      1.7374889710522774`, 0.}, {1.0843599720711061`, 1.7375136445559454`}, {
      1.0563919397682937`, 1.7419638180843806`}, {1.0307932448180694`, 
      1.7540766910784187`}, {1.0096171939534988`, 1.772880673239266}, {
      0.9945623475076188, 1.7968674711459334`}, {0.9868362755394774, 
      1.824113070556984}, {0.9870586969692454, 1.8524320642543581`}, {
      0.9952117710663617, 1.879552946579446}, {1.0106415284792112`, 
      1.9033003140441769`}, {1.0321103270214647`, 1.9217693574540688`}, {
      1.0578961246638954`, 1.9334786492886742`}, {1.0859306069076735`, 
      1.9374889710522774`}, {1.1139650891514516`, 1.9334786492886742`}, {
      1.1397508867938821`, 1.9217693574540688`}, {1.1612196853361356`, 
      1.9033003140441769`}, {1.1766494427489853`, 1.879552946579446}, {
      1.1848025168461016`, 1.8524320642543581`}, {1.1850249382758695`, 
      1.824113070556984}, {1.1772988663077282`, 1.7968674711459334`}, {
      1.1622440198618482`, 1.772880673239266}, {1.1410679689972776`, 
      1.7540766910784187`}, {1.1154692740470533`, 1.7419638180843806`}, {
      1.087501241744241, 1.7375136445559454`}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
          22, 23, 24, 25, 26, 27, 28, 29, 1}, {1, 2}, {1, 3}, {2, 4}, {2, 
          5}, {3, 6}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "6"],
         Annotation[#, 6, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{1.0859306069076735`, 1.7374889710522774`}, {
       0.43437224276306935`, 0.8687444855261387}, {1.7374889710522774`, 
       0.8687444855261387}, {0., 0.}, {0.8687444855261387, 0.}, {
       1.7374889710522774`, 0.}}]& ],
    AspectRatio->1.0559870474263466`,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{1.0859306069076735`, 1.7374889710522774`}, {
      0.43437224276306935`, 0.8687444855261387}, {1.7374889710522774`, 
      0.8687444855261387}, {0., 0.}, {0.8687444855261387, 0.}, {
      1.7374889710522774`, 0.}, {1.082004019816255, 1.737550654811447}, {
      1.0120839390592242`, 1.748676088632535}, {0.9480872016836636, 
      1.7789582711176306`}, {0.895147074522237, 1.8259682265197483`}, {
      0.857509958407537, 1.8859352212864173`}, {0.8381947784871834, 
      1.9540492198140436`}, {0.8387508320616032, 2.024846704057479}, {
      0.859133517304394, 2.0926489098701992`}, {0.8977079108365179, 
      2.152017328532026}, {0.9513799071921516, 2.198189937056756}, {
      1.0158444012982284`, 2.227463166643269}, {1.0859306069076735`, 
      2.2374889710522776`}, {1.1560168125171186`, 2.227463166643269}, {
      1.2204813066231954`, 2.198189937056756}, {1.274153302978829, 
      2.152017328532026}, {1.312727696510953, 2.0926489098701992`}, {
      1.3331103817537437`, 2.024846704057479}, {1.3336664353281638`, 
      1.9540492198140438`}, {1.31435125540781, 1.8859352212864173`}, {
      1.27671413929311, 1.8259682265197485`}, {1.2237740121316836`, 
      1.7789582711176306`}, {1.1597772747561228`, 1.7486760886325352`}, {
      1.0898571939990922`, 1.737550654811447}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
          22, 23, 24, 25, 26, 27, 28, 29, 1}, {1, 2}, {1, 3}, {2, 4}, {2, 
          5}, {3, 6}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "6"],
         Annotation[#, 6, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{1.0859306069076735`, 1.7374889710522774`}, {
       0.43437224276306935`, 0.8687444855261387}, {1.7374889710522774`, 
       0.8687444855261387}, {0., 0.}, {0.8687444855261387, 0.}, {
       1.7374889710522774`, 0.}}]& ],
    AspectRatio->1.1348002515114868`,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{491, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->155313840]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexLabeling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->24443973],

Cell["Show vertex labels:", "ExampleText",
 CellID->1001631834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "7"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1042589918],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.7385489458759964}, {1.1078234188139946`, 
    1.4770978917519928`}, {0.7385489458759964, 0.7385489458759964}, {
    1.4770978917519928`, 0.7385489458759964}, {2.215646837627989, 
    0.7385489458759964}, {2.215646837627989, 0.}, {0.7385489458759964, 
    0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {2, 4}, {2, 5}, {3, 7}, {6, 5}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["6",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["7",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.7385489458759964}, {1.1078234188139946`, 
     1.4770978917519928`}, {0.7385489458759964, 0.7385489458759964}, {
     1.4770978917519928`, 0.7385489458759964}, {2.215646837627989, 
     0.7385489458759964}, {2.215646837627989, 0.}, {0.7385489458759964, 
     0.}}]& ],
  AspectRatio->0.816496580927726,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->907922855]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->291462997],

Cell["Show vertex labels as tooltips only:", "ExampleText",
 CellID->73764302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "7"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "Tooltip"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->655204029],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.7385489458759964}, {1.1078234188139946`, 
    1.4770978917519928`}, {0.7385489458759964, 0.7385489458759964}, {
    1.4770978917519928`, 0.7385489458759964}, {2.215646837627989, 
    0.7385489458759964}, {2.215646837627989, 0.}, {0.7385489458759964, 
    0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {2, 4}, {2, 5}, {3, 7}, {6, 5}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.7385489458759964}, {1.1078234188139946`, 
     1.4770978917519928`}, {0.7385489458759964, 0.7385489458759964}, {
     1.4770978917519928`, 0.7385489458759964}, {2.215646837627989, 
     0.7385489458759964}, {2.215646837627989, 0.}, {0.7385489458759964, 
     0.}}]& ],
  AspectRatio->0.816496580927726,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1845611119]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->268593998],

Cell["Show vertex labels as tooltips only if the graph is small:", \
"ExampleText",
 CellID->1953868534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "7"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69684929],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.7385489458759964}, {1.1078234188139946`, 
    1.4770978917519928`}, {0.7385489458759964, 0.7385489458759964}, {
    1.4770978917519928`, 0.7385489458759964}, {2.215646837627989, 
    0.7385489458759964}, {2.215646837627989, 0.}, {0.7385489458759964, 
    0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {2, 4}, {2, 5}, {3, 7}, {6, 5}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.7385489458759964}, {1.1078234188139946`, 
     1.4770978917519928`}, {0.7385489458759964, 0.7385489458759964}, {
     1.4770978917519928`, 0.7385489458759964}, {2.215646837627989, 
     0.7385489458759964}, {2.215646837627989, 0.}, {0.7385489458759964, 
     0.}}]& ],
  AspectRatio->0.816496580927726,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1873360300]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8973542],

Cell["Show vertex labels both explicitly and as tooltips:", "ExampleText",
 CellID->1197125759],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "6"}], ",", 
     RowBox[{"2", "\[Rule]", "7"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->406910921],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.7385489458759964}, {1.1078234188139946`, 
    1.4770978917519928`}, {0.7385489458759964, 0.7385489458759964}, {
    1.4770978917519928`, 0.7385489458759964}, {2.215646837627989, 
    0.7385489458759964}, {2.215646837627989, 0.}, {0.7385489458759964, 
    0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {2, 3}, {2, 4}, {2, 5}, {3, 7}, {6, 5}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox["1",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox["2",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox["4",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 3],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox["6",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 4],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox["7",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 5],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox["3",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 6],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox["5",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 7],
        "5"],
       Annotation[#, 5, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.7385489458759964}, {1.1078234188139946`, 
     1.4770978917519928`}, {0.7385489458759964, 0.7385489458759964}, {
     1.4770978917519928`, 0.7385489458759964}, {2.215646837627989, 
     0.7385489458759964}, {2.215646837627989, 0.}, {0.7385489458759964, 
     0.}}]& ],
  AspectRatio->0.816496580927726,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->322450815]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexCoordinateRules",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->74973014],

Cell["Explicitly specify all vertex coordinates: ", "ExampleText",
 CellID->49039736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->930075907],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {0., 1.}, {0., 0.}, {2., -1.}, {2., 
    1.}}, {
     {RGBColor[0.5, 0., 0.], LineBox[{{1, 2}, {1, 5}, {2, 3}, {3, 4}}]}, {
      InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {0., 1.}, {0., 0.}, {2., -1.}, {2., 
     1.}}]& ],
  AspectRatio->1.224744871391589,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{104, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1801603638]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexRenderingFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->82661052],

Cell["Show no vertices:", "ExampleText",
 CellID->1148726976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "\[Rule]", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"i", "^", "2"}], ",", "300"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "300"}], "}"}]}], "]"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1976145425],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 193},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64398702]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1647530537],

Cell["Render vertices using a predefined graphic:", "ExampleText",
 CellID->2039050761],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", " ", "=", " ", 
   GraphicsBox[RasterBox[CompressedData["
1:eJydVduR2zAMtAiIFEkAVAvpIB+pJCVcA+n/LwtIsn0Xa04Oxp6hqF1w8aJ+
fPz5/ZFut9sv/H/iv/6fsTEfy94XWO/d+BxfyvLSej+jWH+NNztj1Nrr+onV
rbZ6rqoWW9sT4dTzs5Wd0Jdy7vnJeIvcuFxB+wHzDDwv9SLeSuDLJfVuFQf0
y3IQgeP7dbzXoPer8mHmCXoDf71Yd/y8XCpWGDv+tC9f4Mt7eHP8G/ID/046
HX+9HdYW+OsHOP4dQVLeS2jzfl7mKJi19i2+LPPsmthakZKKYNbEjtuIVayx
Wi0VKZG6LBnd4GPGLdWqosmN5I4n8j3CZmkuZMzzgKrUuJaSiMgZAJGyX4SC
HUqkTmi9qJk3W2AkPPvrlKytOIFF42nkPDReUOOiNakfSSEl6RhZVRmxMzff
dJyIL2njJxHNA6vgjRHOiFYm1f3AsAxX/qAKlxmHjimn7SSHiWlWUOAg4IUe
5IIkinMyqIcyg3dm7IofnLiakXvFutYqwaUJZxJYQCHitiLvTfMEXGUEhMh1
ICQ6Ao5D3U0e6150oKZpGsfLtAeZ1Tl4gxJB/BRNbjoeMQ+wfIlA8XOLB10f
jcRbtjTcJTHnatCyOC2W8jQ/vKlwj34+DXPEnr+kk8eTx/2CaXt2o5CeCu8D
8sLR1iwoHHpnOggIRY8wkVniyOE0IUI0o0JPlPbJXPsuaZqk3lNIemQLzfI0
gOgJ1B1vmiHCA0yxFXjhL9ejd9fk3iS0oxjZu9IJ0Ogq06fBZDQnym2Cdg41
UJaxk300PGS085ex5YZmEIePvHfrFoN6C/97ffGW1pCTs48BVGEeoQpD/ILQ
VDCjEK57vB7Ftjq5VKy58mOYkKytyMz0+uuBCWWAAh4ZF2C//dA0w62B62C9
/kk6tb+gLnJc
     "], {{0, 0}, {48, 52}},
     ColorFunction->(Apply[RGBColor, 
       Part[{{0.7607843137254902, 0.8274509803921568, 0.20784313725490197`, 
        1.}, {0.043137254901960784`, 0.3764705882352941, 0.10588235294117647`,
         1.}, {0.011764705882352941`, 0.5254901960784314, 0.09019607843137255,
         1.}, {0.9372549019607843, 0.9372549019607843, 0.9176470588235294, 
        1.}, {0.807843137254902, 0.23529411764705882`, 0.3058823529411765, 
        1.}, {0.3411764705882353, 0.6588235294117647, 0.07450980392156863, 
        1.}, {0.3333333333333333, 0.34509803921568627`, 0.27450980392156865`, 
        1.}, {0.8549019607843137, 0.4666666666666667, 0.4235294117647059, 
        1.}, {0.5215686274509804, 0.5686274509803921, 0.5333333333333333, 
        1.}, {0.5490196078431373, 0.7450980392156863, 0.6039215686274509, 
        1.}, {0.9294117647058824, 0.6980392156862745, 0.6784313725490196, 
        1.}, {0.32941176470588235`, 0.6549019607843137, 0.3803921568627451, 
        1.}, {0.16862745098039217`, 0.5725490196078431, 0.13333333333333333`, 
        1.}, {0.7647058823529411, 0.8352941176470589, 0.7568627450980392, 
        1.}, {0.5254901960784314, 0.7333333333333333, 0.11372549019607843`, 
        1.}, {1., 1., 1., 0.}}, #]]& ),
     ColorFunctionScaling->False],
    Background->None,
    ImageSize->{25., 27.},
    PlotRange->{{0, 48}, {0, 52}}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->876584969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "7"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "6"}], ",", 
     RowBox[{"3", "\[Rule]", "7"}], ",", 
     RowBox[{"3", "\[Rule]", "9"}], ",", 
     RowBox[{"4", "\[Rule]", "8"}], ",", 
     RowBox[{"5", "\[Rule]", "8"}], ",", 
     RowBox[{"6", "\[Rule]", "8"}]}], "}"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Inset", "[", 
       RowBox[{"gr", ",", "#1"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280649582],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztfHVYFWu7/my7yMXqZJECIqKIndhiKwaCdOdadC+6u7u7GyQVFVGwlW4k
lO48izV8G/bsb5/z/X7Xdf47eDHMPHM/930/7zvxvrNmKSlHVVXSkqOqKciR
LunL6aqqKVBIF3X06aHNfwAA8Ib++w4F0NdX6GuM3zcrK/S//xtLttUl67sv
b6sKUibKi8dLC0ZL83+V5Pcnx3S62DRbULq8nHqjg9uyE0afFy5+/7q8ML+8
vHyHkbW0tPiirrw+J3mmopieNVKcO1CY/TshotXWpMXGqDfQqy8lqis/bfZV
9Upf7+Ly4oUNiqPjY22t39vzUrvDveucLNpcrQdMddpNtDrMdNuNNDupav3G
mv0hnp+LUmrqq+YW5++uZrEMDPZ3fHlfH+gxFBPwwdP+p71pB1W1w1Snw0yn
zUCtm6o2YEXtSQqvq8j+2v4FAPU4Vpd7Smsq6pu/fGn51B7g2maq3WSo0WKu
12ih/yLMa3ph7ufkyOjE2INVJFPf2GhxVXHH+FBNQUqfq3WzkUYjVa2dZvSV
ZvjtTfkEHTz+e3Z2do0dsbrcPjs/H+1Ga1SSa9ZT6s2IyYkLbuvtBqQZ+5p6
O7INtNrVFJvMtAdqijMSw6fm54HLjGzk6nJrVV1V6T3pThXFjpKsxIxoQIYR
jfJ0rr92b8CV9qow7UVtJXBlQ8bSyso3J88eTc2BysKi5wVrGSMjw+0alFEf
9+K40JbOtrUM1Opyy8/3L4ddLPr8Xeob3soyIk0x/kOWlNoA1/6J0Y3IX6mx
fXpq/TZWk5PDIO/y7Eyvi1WHolxnRDBdeaOTLfTt4kjv7/LSXW5eIO/PX/2v
Pa1/aWiOVr+8usHz7MqSl6d5o6JMCY02sbwIet7ysetHsj2lV1WtMidjI3pk
ccbBhdqsIhcn/6zyS91ahS9a6hPt9Zqlpe20lX/PTv+lTboXR02sFFsN1X9p
6bTWvFrLyPhSHmOp9ouq8VWLMjY1uZbBvLrctrS8OLs4uwL+LK+szCxtWo0z
T8zPtPS1pGrLNj9TKrDS73FxHxnuz6kttEt2oIQaFDWU1H99n/I67ffML0kG
zxydZmlhjWduZWVhBeSZn58rqkj9rKL4Rlvzub7aQlHZj8HWxLIkyxQbx0Sn
d631z1+XlP4on5qeOLvuCjk9PSZbKK9ZaKScon7N8+EFs1vGIZYv35a+8nas
spOt0Llc//hG+0S/maFM+fcyAx+Ti3oSGBcuTi8hEvXQLm1OrZdmCV9SgOur
XKjKppKLyTctyu2lwp9edZK6ZnEvNC/qRVnqNwfbLMfrLcr3X1Jlgj1oUUFW
qZ/ylUzkDxgfQnty87qKwlWEsE4HzCoc8lrylhbnTjP8MTE4p6YnS9qKiX4i
gB4LyhQp7M8uEojfZYh/Evz0jvYpu0K7AmdTHxs5zRwKqxEP1pqfbH5w0y0k
oIDcaoU8FYQUtUGcDbkY+SHm2iobumugw/aF4x/W8D/04ZzWHKLhHFyOeARN
SMdT4YLR8fTyiBQLZVdfjaMux3dqE/k9DsGV+YH7CEAdCXdDXvBB7Lcny2Uo
F7aWdI/0AhtdjkyMWNZabTJhAlSZESYYAgUh7npUxPUcoLCd5LLlQBTXLt29
wCPsYZ/D1yIFz4WxiHigLvkQ7oZwsqqir4dhJaNxm6kc7F77QJe17bUXki4B
Wtv/0OHAGaLIxrhzPpfR5sKAKiAUtJs/YB/wjLRbhfNKzHGJIPyZSDYhe6xU
FOdxewJKHy2TihX1wPxhgkYHHXycrvEXl5+7P51OF7mYfPlB2r3HSYgLPjxb
5dHAPY6njk8MC1TEI0R4bFnErbCsmvDTmuKarppyWXJHAtBXfZA3wzCSkVjA
DEE0QO61YQJdele780Wh72fI3kw6IpeEFrLmAR6xoWT4dcNU1POlOb3RojS4
gCmWQw19V/eafgT1atLFc37w8z6opzE4IX8UQEHss0CSrHcKuHL9xeXM/HRt
z7uG7q9NvS35P3K1ix/SioiaiWjLaO206nyFLPkLcWxn/AlIbSSXFe9D/6Nc
nqSdWijgEZpgRtDI4yL5kEn+GPVCEdDlr8mh4paKjsGehu6GkNpQ7aIjtHyC
WgyfV5JvdE2KZMIRiVjYMWfCDjXUOY8DV3wPIp1Rm+QwgDRKwp/8KI0Ec+cS
j8LYVB3zqb605pJldYmYnJ7wr5W5mXyJ7CtyPgQvFUjepcwmZIZyKpNAemEA
LdRdX3Loay6NXCStmD+8Spiaw3vLg8utlFs2+7p7VfjLzi+MsxnZ0FluVXXp
SORlki9ZKpx81gUPPGV6HCqom38CoLHv1MaaZfC4VxPUstHuZfvCq4XuR5HV
QniphQSdYmrg65TesYGlhd9/cTY4MaiXIw2o7wKs2MgeWK1E8rNk/D47Aq+P
8KGI/ZT0q5fCMIeCCYD1nhuJ9y2LVE54odwr+W4l4PYGIAobaSvLEwxniPc9
NReDxADNnYAd7FwAQT+dfCMEI+DIj/bhkUo+r5QgfjYcR/DGALbsZsVGT+LO
3A7De1XzCAXCbyYLdQ5mr6wsntngqqbjrWisBMEOy2yJph9IAAUl6Ue0L0Pc
TTpxxvneHhksvwdOOpV3mx2HQhZFLOQi3JVdIYVLyAXD4spX0JyyuDAEuvJ6
HcTuTuaywf1hjQSMEayGGO0kkl4B+62YB4IGJ7aqYC7FcF6M4tzhxGtaTNvl
SBILwcjFkVlpaNHwCyMzjQuLU6Ar1tUl3KPG+2LyMaUsLskY+Fa73bdjL/lU
S6lFH2TT3ctkw3E4nAB3R95MIJ6OQP5hB9tkj2IxQxL1yZ6vHFM/Fs3OLwAM
T/BfU8MqBernY/nVMwnCgWyAPYdRvqxL+XlJN7HN2jiyB1ooBI/wRMulkwhe
MMAOvt0BzarHcd79bFh9SHVzA3B2faTC0T3S71bnbFp0zqTotnau5e1kDfVw
Iw59GNkTqZXAbZXBJxmKPRbGhvKDbTLG4OzxBF/4iViibp7+xPQU6GZ59eay
UtxYSXupa1l60qhI/WGqrkqWxVW7OzBzpgN+OFomn3Yi97kgpFgY625XxE5D
HMEDxxfMcTKc17sicM0NbHXJVvCjSuM59XG40oWIq6fsTvG4cRz3g6Ms0Dv1
URhTVtsSfgFzEsyJ7VgEG3cA7/XUh/U99QBjtMZmXemuk64nEXznbthNHnOB
I8FwYRc4uzlmqybsrB/CIkNohx5SMBC2P5Sd7LtPu8RgfGb0L8rD06PxHxOV
So2Pxh7UKNp7Ohq+xYUZcNrDFrjXoEDDrfzq6YSDB2NPPcuUd6v1fdfTMLsw
t6b88ednr5d+l3Nkr6YdUM4n8QfC6GmAM4tg1JnQN4aaOQdFY4/tjzpuVm7p
Vxf2a+r30vLSmjJ8dbm7faS7dbAz82uOWTGFmqRrUm4b0hA3Ojn1rq/lVd/7
qZkJgHG/3bzwr5swqLtnZWmleaSjabDDq8bTvtraIMNQJ8Mg90fp3NxKdmN1
92TP1MwkOIpDM/IdmZnX8p8xtvPU1D7Fxa38OeIBUdb08fhGVNazZw2Rkf+H
+j/U/6H+ZxTjmrp5bHJ0dnaKsbq62LY0MT7d9D2MizjT1jL/a2BybpqbsXN2
fnaBPuFcXABx2xfnZhd6usY/vp/88XW+v292dnJ1PsLDwC4tLU3PTc7NTK1h
6XtWRoYnvnwsU1FojI2ZnxiZpc86eP8b/fEP7/6lP4VYd8v6/nNdYVrkYGxI
n49zj48zfUY8Eug+ZGfy01x3yMnit6/TzwDXbi/H4eK8X7/6FpcWSYysXyND
JSXZTXHBP31d+3zpAKduD/sRd9pPC70BW6NhT/tfoZ6tLtYTWSkTPW10RTIj
a3l5qbym5GVc8K8wv5+MrC5Ph3F/135rar8l5bcb7XegW7Oz5WBk4NiHuuHJ
Ea7/L4fsjOoYS5a5xYXubx9Lg9zLI/2aUyLpKk0G6k3GWo36Ku26St22Rm05
yeWlGa8/1tATAYZL5tHBvixf14oQz+9FGf0uls36KvSE1TRtBXp5HTFBb0qz
3nx+OTw2zOjHbdPTk++Kst8lhDTkp7b4OHRQ1TY1GWkC2xp1FHsM1VvcbL4W
ZVbUFDR2NnJDPfn/z57Aahjz/F1NXe29I0PN/Z1vA1zb6Qn0qbu7zXs3m6q8
ZPpNmNH7u/pHR753NI+vLBZGB3RYUVsMNRot9NqCPKrDfSaWF/auYnZ+a28a
WZytelnc4k5rM9T4QVXrCfGs8aA1t30H9q4rDUKU6t1sqnNT6EqMOxc4M90W
6e/6/tHjVl2lnvyU5KSwydlZAUa8qu5l4VPpVhW5jiC3+peF7z/XCzHiv6bG
Q9UVGmVk2mwoXbXlWbnJ+/7Okxg2MTuLWFfZ2tjXUS6t3Cmv0FlRkJKTAAgy
cmaW5rNoto2Xb4/lpsYnhc3MzzC4thbnZ368JvXb07kkM+7d5zpg37/hSASZ
154L9KSl95saDOamVFY9Z/jcMt7S2mNAmU6OzooLF2bkLy8tdTk6jXg4loX7
t/f1AMJ/y9zI+PNlyW97459uNk0tX0HGqYGen542fUZadXkp+xmRphC3Pora
5yC3kblp4b9l/cVfQninukI/zX55cR5kG/lQ122s1aumNd3WBObOT030uFt3
Kyp2BQXu/1sWcr01tyysLCWFu32Tl/7h6cNomy0Fz7OrdOT7TS1mJ8dBttb+
zkI3s2EdnS/hEcJ/y0Jt6JvplUUvD9MmBdlkA0rXxG8A9BefH/dSX+mVglJ5
Qw3Yfg2dX1MdKG3P5IMdrBbpgX3/NnuDz62D8+NmjprNGorFSoqVdTVrzK5p
vtWGqh9lZML8PEDm4h+vIm21OuRlgzTVBmcm15ih2RuZu5YnnY0V2ww0xg2o
Q6Vla2Os9qHOrqG+1VU+hpJHtMt7fdVhE70uJzcQMTw1/K2neXUVPJNyPlfl
GKkOmOoOGBpPDw7QY4tLCx0jPRNTkyBiXWnMgDpY8ncl8PwGn47Q56L1A+8H
xn51jXY0dv34+vnz9NTU5OJMR+v379XZ2Zp3v0pJJ7laNhibdnX9sI91o4Tp
n7E5R0kwdk10lw1WLuuqnJ6fBjAMro/9DY2DzUMTQ00DjV8+fenq7qSHv/c0
znz+GOek0P3gaYaNQaGKwszHhpCyBIqX3l2/+zIBcr65gfJeKiEfowfG+hcX
FwHsKheqe6Sjob9hbGq89XfTd/q/5kZ6uHOsb6KxKS/R/of8kwpVpVh1ueHY
+PLGV+Z+5qpRalcdJZ1zPAwDjSk5Zg308fLi7PLyMuY/rPLBk/z4oAZjk87O
79Aqg5TWqmS02Nocfn5hfnCs91rBnVMp18+GXtrvJs5rvl9Y63hMRkCVi0lV
gFa94eN2Hwub64cuGV2xKXBXclXbJyuyi4bd7YLarokG5Nlvp8v6vwth3OVR
c/MzFjUWvJFi15PuibiJC9qJ8miKmEdZlwTQqh21q11l2vSUgm6LKnio6EUZ
GiXZnpY7xWJA2OWB2WmMAqRh+wJO2Va6VrdXMKpFz87NZH9O44k9JJn56LDX
if2uh7mpwnccZfISfF5Y61WFqrTryP76UiB9nueRwyPbEp87Orexqjy7XLG7
aMhNz5C7jUgqOfop31MX52fBUcg/V5vu/2e1LW5G36bbrhhdtcl3g1Yrt1bt
xhacnp5Kak1lppGAZ0zs+hwHfdgvxgpiXPbx24uRtDifFelZu2jKOTw55nQM
b8cFt9mz2xi1/SlylzJuix5GOhV7LxQj6ifm8NqN4RBN716R4NOA8p5NquwC
DmznYonCXqJYF2EhHWGxMAmPBKdnxpLXHK9zuwmwGTLBHBGbnyKYlLGAEuZ4
KE4tAXnQV0A1TyvgXXT/5BBYM7r1Z7NqsR6gzwbIsRLNYcfDEKdDRTmcBQ+Y
iuMseOxK3bXN7sn4Kgi574cZI5EubFtUkLsV0JsVsBgHrFYG+owf+UrszeDP
0RXtr9da8d9X7Ayt+IzfRXrFHH+r+P6/Kt7Yij3DPUrl0rtprNutEXtd0QRt
FEJ7P5FyeJc8u2jQTq7A3YAKHJCCCTgK3Q8Uehwp+CBO7GkCUSuTwG+KOuWD
EfLCblLlAExhYM3u75zQbnD6JsEdzW+EYFPn4TY6vkeOQLbfIRa5GzBmBe5x
cFA5b4WK3g/glUkRvxnOY1REPOqIPmSHORqKZdJGAlQYYIuyLnNZa8Xsz1mH
o/dtMWdjd0Lts0XC1fAk6hG4mhBMb+fxqF1MzkzAY/gWedRZf9F7fnyySaKS
4cLaOcR7YTgBU/SZUCzOEgNowgAr2KGAi2ut+J9XfO9vFZ/eUPHGVmzqb7yR
fkEtVyvkrb9N+flHiYcELNEcaiwOUZaxr1MkE++fD2K5HURgUYXtVTgmb6d7
Ouo+ixkcrwO/EoqXSsEBNgheB9itEHawZmqRhkS8ROT7eFr5PY2sw0dcyWzq
O2Sc7ydXp+oUWIkFcEiFY/lMkCxPuR8aKN6LUONw5sbqcBxwxKhmEdjdkHus
OCQDYZLxSGq+7Forxr+LOhIt6lHj71pNNS89cSlECKfPKkoVjMgJ9XwRJh66
704Y/KwrfstThITG7Wc++ryBxzn0YZxGSLkUolgoCrCAn/JklwxnvxrJt9aK
/1SxfaRF7OvU/7xi5g33ktn5hYHR3y9ay1I+5yrmPqQVEw1TCdftL1gnG2nn
SQqHwtDmaE4K5lIYQS2JdCkCddwRj6Di4bp4y2K+s9HiYuFndAsegPcS1PDk
eEPH2+LWYp08M718Tod88l1PETV/HZsSpXOxBJQTnFMPe8ANp5XGeSsKc9ob
w2VKAlQw6gm8D1L4DoZfuZ54pqjNtL4zBmQbm55qG2gray30eBmlmHvYtZis
EEG+6yjtXER9mHqQ4MOGo2J5LDCySSTpWPz5EOQBK9IWDfQpZ7J+Adfh8AvH
I4+G1GlV/LDA/HOdkg4XrP7nOnnPRB0+FHZ6tU6w5cBnh1MzE0G1UnsDiJvs
0ULeuCehnAQTdk4DpHnhVbI/ic+RXymO7F7JLRGDoOQeSH57xqaQ1ziRn5pN
up9+OuNT8sj0POOuCc9psL2WwLXFAcfuinkYSj7sgtqpslsv9fyZGCEeVx4J
H07/ar67SRipZHJ4zfnAKkHNRF67bN5LsSTPl/YtA70AnsHS2PfS8PlhVjfC
ZgfUpSDSjQDCbvXd13yElbJO4zyJ+5y57Qp59PJJF2NQruWnkt4c1k3noaXx
SyWjqWUqL5trQJa/10T+dzXxQGvKId1NO5X+MYle08YW+jbQeC3uDqDEDljC
4c7o+0Fk+UTsKV84myvxeNhJ1bCLh31QokFEwHLP4zQdxXRNrC27fQXv1Xgc
0ps554f54lwPo+8QswtzlEJjZn0cQIX/4Yi44E1SSCDcCkPiXbAkP2GVmFvn
vUmHQ4g7HWFE35NOFV7sNmjFNDKliJPNnUmv+NLUxFuwutSvGQLuhwBVdsAe
LuyGexbJ+SQWLeiOYHLnehh7/UHAwYOBWLIP/TxBOVT4iPgcP+GHcX3Bze3P
IR5B7PqdvrgwjvuHuuQSsaf/WtfBv9V1bUNdG1vp+2CTRMpNoWCcoDN6kw0S
oMDuBIlEvBak5F46ankLeMhM9MBJxnNxuKFvJdzHeQohveHXQklYQ/zxqAcv
OmtXVubBVpqanzYoNScGYA+6o9ns0IARjMuWK7RK3PK5kJSfEvAQsdUEfSuR
m9MbfSTszPHwS5sdWc9HEfZb4njcTzi9CFpZngNbKe1rFt6f55AvluiIBsw5
AEOUReYRjxecaolyaBURQAl2MorzaCgR58V3J/HRZgfk/jDseQ8i3Iz/aY7B
xNzY8vIi7h/quh0IrevGf1sX2ErgM/HCxmJKmb7Ry5MqmXC8OxP9Nq2XL/ss
5DigiUJ7Ix+lkUWDMcrZxMsxTNud2QBz1DYjBJ8NyaFK07Hce3x6Ehyhwlt+
tXrUecnnnzUqJh7w38kfcFAzV1U37RJGj7zJhuNWEulUJP5qAkElk4PNbQ/9
OACMkTAjuH7eQ5tym/cdX9bOten52aiPMdIZtyyqhSVjmNncsbIZCtT8u2ds
hQF9mHgE7mYSSTQUR8nH8fnt2uSAAExQuw1hksFHHSoNI1+lAIT/l4qu/FNF
zOvPL2ClnTUOFXqerygOJR5SqdqKQVZkM5igG0LSm6QVzitshxQPoWugmCwx
ez1wcE+YQCTWtdp5YWEBrAhW2/nB942nW61KUHXg3WRlSrLnXkMhYXe2w844
3Si+cy44IS+YaABquzWaxxFH9EHhgtil0++1DrYBREZ+3+hQ8vcs5xrloJfO
yhkG6pl2ErQHAg5M/E5ohVDuJ35kHgeOE6FIJnsUxgbH64uFeTMfixbK+pQD
kP7l375Mh+7fvsT9P/G/90//YCuAT+ff93yVTJAW97rM78N93Bm31w9x0B/G
ZgsH9NgPepFTGsSELHDb7befS8ZfyrhsXG7XPNgK+mdbWVpRLjS44HcH5yFw
zoPM6wY/HAInOcMBI/ZtJuig2oNKIfyAwc7DsfDzGUek0pRyvhWAT4HYPF+H
XQ+5x+UuftSHS9gJKRqCFPSC/WHBAejC1DIFA0tFN+mwEgOYzqfxX4i/Gfwh
anZhFuBkZCYFu0jGP/l3btn+0S3L+lMelr7RHqca/yfJj3ULz9zP2osI2ssa
yCcccza+PsG+wuBK6hX5TA2vXI+a3rqekV5Qk6XU1zW6Kup+upJO/i2FfAGB
SEEmfx5SqAi1yCr7S/SpyKOKeRrGpY5veutrOmoB8Lna1Nx0Q+8HzeeWilkP
NQsPnE0S2O3HiwreeznxUXlT/oOUa49yZGSS1aLjXKu7X68sr4DV/WxoCBIR
+U88hr9PWvPIONPBzzv2zC3O0/+2/OrL/lr0tvPtq+7aTwPf6d00Nb84t7w4
9P07nZ3RA3sWZma8SKTRvtVp8tz8ctaX0truutqut9VtbyZmVp9vDk2O8q8i
menmFpdXH4lWtNZVd7562/G25EdF9+hq4q+pCfpyYXaWTjXx8yeDmSnp1q3v
mZmrtP+tGbA/wCN58585a9uvPT2LdHVXV09CtsH9YDutrhI3sECim8Ea6caA
U5BtqCrIwgmJEiDapyHbBIgqaQPLehQP0T4D2Sb8uxYAz5MNURxE+yxkGwdR
5dzAsh7FQrTPQbZxEFWQhQsSxUC0z0O2MRBV8gaW9Sgaoi0B2cZAVEEWbkgU
BdG+ANlGQVS5NrCsR5EQ7YuQbRREFWThgUQZz1Q3v3B0fG5svLp6CeIFAVHl
3sCyHmWcyZvpqnRtugPw04/N9J10yPr+dVWQhRcSZZxdm+nCdPnVVZCFvpMO
Wd+/rsqzgWU9CoN4uQbxAoOogix8kCg7xMs1iBd2iCrvBpb1KBvEiyTECxtE
FWThh0RZIV4kIV5YIap8G1jWoywQLzchXlggqiDLXkiUGeLlJsQLM0SVfwPL
epQJ4uU2xAsTRBVkEYBE90C83IZ42QNR3buBZT26G+LlLsTLbogqyCIIie6C
eLkL8bILoiqw3kfsPwd725u/zna09VeWxx07MtvXM/b143Bhdl9s2FBu+tir
qsGmT/TgysQ4Hf6nUfBtA/qd7nPTx5aPb1PPnemrLJ//2Tvd2zX3qX4gLaEv
PnyktHDs/euh9h+Lg/0rU1OgXdA7qM02MNRfXVXYGhvcYW/6zUK/xZwy6mg+
RDMctKIM2Rj+sjP5bWf828VytCC9pan+uYsDvTzgHuOg+/C1oaYgtd3PpdPe
9LuVQbeVwbC96aCNwaA1dYhmRM8ctjUeCXTvKs3ODXJfWlkWXG99lsm52bSU
2Iz40DRj7R5v+3ZjrSZjzSaqWhtFtcvPcbDx04fmz5+/10eeO7faI4w3VZm7
+/tC3WiVxVlfitMH7M2ajDSajDSbKWpdJlofQ9z725vCTXXrSvOXl9eUGJ8N
7JhdmI99/DDB27FZX72FotLm6/guLriqNHcTpL+kGF3dkJKccPdOU19nmbNV
h57aD4rKz7TokmCP1q5WsOvATxLA5W56yF3hcd79h22KMj3psalpkcOMwcX6
sfSI0fWrx9KHD+GeDnW3pbpMdFrKc9OyE+h7wO4AGcHPLZJkZCrNbdruPBp7
UZKQFgNAXTL4doJHVdfwwEdZjX5j4w+l2RWvK9f8Ca+z7aSHyg31h5wshyP9
n+dn/sXZE0brgM56slN/25n9iA781PgN9ASyMD4z2l6pqvDb1qjPSLfzWz09
AJpZe9sXdNITHdCrp9rl6dD29dOqh/0bsj+mx//QkOvUN16Zn1tXf7q6b1uG
ivK3YLdOBbnfETFpjx7RyTZkbguN8XmrJP3O2GR6eQkUBd9xbagqjfW26lFR
fBsSsqomsl7x9uWVFZ9wl08a8ukyMrkvitfUwLyOsYFwN6M2mafemiqvCrI2
5m2bXVky8DX4QFVtVVaJ1Naia8kyct4N/HC2U+vRVnmtrtXU2b6Ww/C3O8BW
v01N9bupXpOR6cLE+M+RgecfyxLKU/p+9a0sLPUN9YK9xfSurylPX6WVot1i
pD/9vHJmfra9vz3rXV5R7fOp2amZiYmh0UH6Wbx2jWPcAZBhH0PiP6Rlf8n2
fx7iHu2TW5XXM9j1qiS1LcIryeBCk9SjT1/fxmoodn17axZur2wvL+p6+KDz
MUlHKU7dA4Y1Nq87a3vGusD7BKpnuMP9rUdpc1VMXYxvTrB3gv+Hxo/fOj63
Z2eW+Wu+Ub1Rr6n04k3lS2fay8ZXmvbaD90eCDruP+d59bTRNT6auO+7kI+D
n6bnJ8F7E+Nuieoa7bid/5jVg5PfQ3ivJyevJ5FZDasUoBzpqBkZY/DBw7zW
zfB5z3MByxPizteveT7E3OehT3b/sONgt2RjUmY+HiTh9dr/Q1c9471d9Njk
SGlzEWfUAZyvMJ8zn1AAJ94GD9fZ6x1p6WX6uCTP9ZOp5pfKGI+6QJz+gSvB
T08YXGR+QACMkNvs2RAG7Mxa8HsJMinf0gbHBoANLtFZ3bksdgRAlmmHNpLX
iuNCuMjRoAtbDFEwKsux5BOX3e9zqYmKOh87Hraf320rh/1OvB76gA3nFgXs
tQicejoW70SUSLhzL121Z/wneP9H9w//pL40AyisgCwbnIrc74S8EX2G00N8
qxY70pbtZsZDMaMz3Npix4KOiHqTeLw3MxkxC5rjuQ2Iu7Qw6lnYm5F4tBPf
vTxFg+f2f3H6rPw+yQ/HG3TweATsiC12kyzn1sdkPtUDV6MED4QjAepuuBKS
g4K/YrtPxeuqXu6j2/Fk7SyshA/qMn2G7YhmVkPtoDJvtWb3fhW45rT4e/GR
ZH7eQGGBUP6LoexcFCIgTd7zmO+wyQHJJD6k557tGmwwVSTZjPMBTUw36oF8
5rWnKRi5RMwFT/Qxf8wuUzSbBhKg7IDZEv/iNKQ+0O2lz5fubymf3LULbsnG
ky54sNjHaZfW1mnk0S5GsT2KwxMpSCZFQSnbh/u8zwG6SEAKwWuDU83l5PDA
oDxhsmloq7ciSR9c15w2D/wwqzTP/15a01we9s5MKfe0dCT2qgc+Ojs0s67m
WsLNuwmst0KI2xXggron77k8QriLAPIcwBPElVDS/VT8NmfMgUBWrXxO8xqx
NaeMJWp5YSXtk7f7K/vr8VIyyXi9RG5eCvGY9SGrEol9oThAi22vIUE/h2ha
iNDOxlOSyfciuPCGeKcCvsdp4k9SqZblTr3jZcMTTeB7st2/OsLeWRiV2l2M
O6aXzikdQkSrcsuEntQvOLHbhQ1QRki4Ei1L8bo5CP1skl4C91FPorg1p0sl
z8P0hzLp+smf4n6OlGz0h1haXI6rM8Ta7gEsmBCuGKUYzhvhGJIRSir2olAI
96O4049iSSoZZLQn7Hy0SEiNtHYKl20+v0YGScQPHd9AW16YYYy94ANjnUZ5
En+Y7ACs2cR88WqJnMc8EPtt9krGnxILE7wfc0QhhXQzjgh3Y9XKue5feVUl
kdO9mP9KDOZ22pHa1tSN1x1E+3CXROKDXbqozSYowAbBaYW/HoBWTWPfF4g/
FnD1jOURQUeMZBz3dge2qwlKGjkmWyxZVLPId+LxWxx2W6bcm5n6xvCESP2S
S/Y9zKyNAqwQ261QwrYE6WjkgwQm3gCRC77XxM32ifljJSLJgDWH5XMPkcCL
nK4cZkXcgv5IFleO971xc7M/+Ta4mp6ftn/hvDcUfzkEtd8HDViynvQ/mFB7
wzr/8FGrq4ASM9oNJ+CP4/PDSkSJsDiTdrjABTxxcHWsfIZuZHZI1rNnYEt1
jfYcdz54KBxzJQiNckcAZuzaqVei3hzXjr+E0z4I6LDyBOA5vbFiIaTDoQc2
2SMR3qi9NCyBImhW7vS5v32tpRjOEH3jfVVdr/WeS1MLeG7HEm8mSN9OVtSK
l2fSRLO5w9UzuTTTueTTiHcSWNG+LIAZaqcJmuiCfJZ9QiVHpTw9ju7pBoMn
W04uL8I95F2k8QtJnRzCuSiR28kqTzOUH3heB3RZhEKwJnk8z5I5ldOxpyL2
7PaAAVQMmzVK1J8ok3aakmm+sLS4YZwOH56eSv+c5/jOyqXA406inEwAlWSB
Pu7LwWuFOeFERlHYr0SiD7lwstDQYgEIlAecEMAVUOu7sDjfEBlJtwR+jwLx
51ts9J+u8WGXahf3ajvdNBOZZK0zNKl9rqz7nRH7bfHiNgS8GatUHAlpgSe5
Yfb7w9hcEYfCD9V01GwYr7NNzk3rFJpcjHiA9MHfikIdCeXAeDLvcNxDP1yP
hR1L+3DuWjD3DieOU4nCSmXKPq9DW393rI17QFOrq+BMcP3tOsZ7bGwvO97K
p6sdCLu8NwBxMxqxLxDG4b4HoJ9QtjiN7AvRtUfxjjiYL+JO1lmVYu2Storx
2Ym1PmSMDZkrmmpC6uJ8Xtsr50pcz7h3MuWWZPKTiqZX+Y2V1ArL/Obi+t5v
0wuz/RMDWyB+LkH8bGWMalcWl3PbymLexZqXKigX3TiddPtsym2NIpPWwS77
F/6+H4NzvhYOjI/8nh2ZW5hbm0esvZcz8ntxYWFxaWFienIPROsCRGsnQ3Bi
bnFkZmp5fmF6bnphcXFtZHIGknseknuagToLQZ2FoMA31M9BUKchKPCd5fMQ
1EkIisGy9pxkHXUcgmKwrFW6jjoKQTFY1p5zrKPEISjwHedLEJQYBMVgAb+X
tgF1EIJisKwdfeuoAxAU+O22qxDUfggKfCP0GgS1D4ICvxV2HYIShKAYLGvP
AdZReyEoBgtwA4Lig6AYLGvz+HUUDwTFYAFuQVBcEBSDZW0evo7ihKAYLOBb
6xtQRAiKwbI2j15H4SEoBgs4I92AwkJQDBbgPgSFhqAYLOBscwMKCUExWMD5
IuxP1Mzs9Ks3FU0FGdNlRWOlBcNFOf15GUORgS3Whq12pn0hvr2Zcb0FmUvv
a1d+Dy0uL4FXjA2sDFXg4eqSHWSlT2R//uztbnj9xtXmZ6TvZ2/H3/ambVTV
DjOdDlOdNqpaD1VtwN60Mz3mzcu8jv6OLRBGhkNwDsL2p0/6T2NvV0l1Se/M
SHVcUK+9KX0e3Wig1kEz/uxs1tXyZWRuZmB8eGF+HrzGbuBjeAMeQ1oHfPu4
5kNtuY5qu6Zyk51hz+vn+Tkpc8vLf6uR4QWceW5gYFzrt00tzoUbUb9cvzsU
7lOSn/Sj9Ts0m6EMzjuh2Vv7m5raZJSnEiLTogJXv60KbQuGJjjr3LmxLeh3
vh8+doNW1IpQ7/GFhb/VzFAD5487/sxbGOjrstDrUJTvyc+kTzg3QXIYKoAs
oyow50fTpzfWeqP6BtNNzVA0gxt8e3xVISrAKc9MvUNT+23dK3oMxDH2AnIM
xtA433wLzY+PHjvQTDKVlel75db3bg0si8k1VR3R03ira1AXFwfIrx9ViJkF
+kR6Gax7ZXZ5ZfXjkZX55fnFubm0FN82OcVKqlaNjvpKw6e6rs/RRdGGsaa+
2X6fOr7kvsiu7Xm3ND//eJ0NGVUXdiHxtkUZ7XbQo8u2929YSqWWZ1TmRn+j
WaTZXuxRfDzc9iomMyY7PSDsVbKM/mN+c2GMNy+voxiLIt++kLNOL7zLOp6v
HRGMIxX9o+erSoEOYMK8jYLgsYMdjESgrbA8ruLaDjLX7C8W5UfEmcsHV/mL
eJ3YqUUQ9BJnfkoGHiEBbSTRC3XeneOAq4BugcHztorRmfG1YxXkzfmcIxQk
Aqht30ZB4g0Q3Oac532vM1O4tugAIhGsnB7CwGM8TJf3RsKxc0GIk+Gw/bZY
6VjyPlMc2RTzLAPHZYfaaolHBR+yqnD9C69ujipfOFYqXf5GvMCzBDzRiAw8
YBZQFjdM1HiWfQ/ryiZOQ5GNMDg1wmPqff0k6pnYI1f84Od8UbKxOJwHcrMe
QsQajqftkgg5/RfentGeoqbKnl/973reOle56BcKWebgNKPEQjJj/arDL8Xy
ScQgxWzw2zUwN33ETvsIs9siARks8Az9IJr7ajyJ3Z1LIoHg9uZ0xBvZNV5G
KyNLvkZQSs8Jh0jw+BGeRnCL0jCAzB6dZLEn6YfoI2E0BedazEMrw2lm473L
hQOrBK8EcZrE8Slm4k2e20bW5YzNjCwtjG5khBd8TxZ24gb0dgMO8FshJL1M
zvM+GCGXfVhfsnL6tafRgqciCOyuyB1OeMcKy6uh++USyI7l3Jw+MJW8E2MT
b4CNx9PS8jK1xJLJAc1pjQWskIAhAm+ONc8hquQgb0Y8JWjs36WDuZfMfTAI
j/E6Qi0wA2zh56MIjyJJu2nomylP5hY6lpYW1o4n0F3Lr9YnudJX4rhV07BE
HxYmZ7x9qaJt8bETtocAPaSgH5YnAMvph5FLJ7C5sAN2iF32KBZNjscR9yLr
oz/3tq25A7kWl1bPloSGNIsKecvnp4yKDG4lqetm24mbnYTTmE8FERyz+JVi
yaeC4SKhbNsdkCzGOKIXVjgceSnmcNr7nI3XLvb5+RWLN87aSfqnQq7fD7qF
N+M8FQrntUOwmmEADbYHsRjtGKE/KByHwjgEQuACgeK0aselpcXH61cw1qr2
GpsSx2OpN6WyD8hk4/C+7IDjbsCV/Wj89bg6ikymiEjsSdHwE3YvnELfx07O
Tz1Zv4oxT89M//jV9q2/2b6C5lBta1ZKMymmvWyrnZxdSvlaMjI/PD07Qwcu
rSyB177/jf+FAfjjvwBcn1EU\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{200, 204},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->256439430]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Define a complete binary tree of depth 3:", "ExampleText",
 CellID->35668815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", "\[Rule]", " ", 
       RowBox[{
        RowBox[{"2", "i"}], "+", "j", "-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "7"}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92411642],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "2"}], ",", 
   RowBox[{"2", "\[Rule]", "4"}], ",", 
   RowBox[{"3", "\[Rule]", "6"}], ",", 
   RowBox[{"4", "\[Rule]", "8"}], ",", 
   RowBox[{"5", "\[Rule]", "10"}], ",", 
   RowBox[{"6", "\[Rule]", "12"}], ",", 
   RowBox[{"7", "\[Rule]", "14"}], ",", 
   RowBox[{"1", "\[Rule]", "3"}], ",", 
   RowBox[{"2", "\[Rule]", "5"}], ",", 
   RowBox[{"3", "\[Rule]", "7"}], ",", 
   RowBox[{"4", "\[Rule]", "9"}], ",", 
   RowBox[{"5", "\[Rule]", "11"}], ",", 
   RowBox[{"6", "\[Rule]", "13"}], ",", 
   RowBox[{"7", "\[Rule]", "15"}]}], "}"}]], "Output",
 ImageSize->{365, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305873591]
}, Open  ]],

Cell["Use different tree layouts: ", "ExampleText",
 CellID->249847445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"TreePlot", "[", 
    RowBox[{"t", ",", "p"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{
      "Top", ",", "Left", ",", "Bottom", ",", "Right", ",", "Center"}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->684034572],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{2.4748737341529163`, 2.1213203435596424`}, {
      1.0606601717798212`, 1.414213562373095}, {0.35355339059327373`, 
      0.7071067811865475}, {3.8890872965260113`, 1.414213562373095}, {
      3.181980515339464, 0.7071067811865475}, {0., 0.}, {1.7677669529663687`, 
      0.7071067811865475}, {1.414213562373095, 0.}, {2.82842712474619, 0.}, {
      4.596194077712559, 0.7071067811865475}, {4.242640687119285, 0.}, {
      0.7071067811865475, 0.}, {2.1213203435596424`, 0.}, {
      3.5355339059327373`, 0.}, {4.949747468305833, 0.}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 7}, {3, 6}, {3, 12}, {4, 5}, {4, 
         10}, {5, 9}, {5, 14}, {7, 8}, {7, 13}, {10, 11}, {10, 15}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[9],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[10],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[11],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[12],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[13],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[14],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[15],
          "15"],
         Annotation[#, 15, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{2.4748737341529163`, 2.1213203435596424`}, {
       1.0606601717798212`, 1.414213562373095}, {0.35355339059327373`, 
       0.7071067811865475}, {3.8890872965260113`, 1.414213562373095}, {
       3.181980515339464, 0.7071067811865475}, {0., 0.}, {1.7677669529663687`,
        0.7071067811865475}, {1.414213562373095, 0.}, {2.82842712474619, 
       0.}, {4.596194077712559, 0.7071067811865475}, {4.242640687119285, 
       0.}, {0.7071067811865475, 0.}, {2.1213203435596424`, 0.}, {
       3.5355339059327373`, 0.}, {4.949747468305833, 0.}}]& ],
    AspectRatio->0.6546536707079771,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0., 2.474873734152914}, {0.7071067811865491, 
      1.0606601717798199`}, {1.4142135623730976`, 0.353553390593273}, {
      0.7071067811865461, 3.88908729652601}, {1.4142135623730945`, 
      3.1819805153394634`}, {2.1213203435596455`, 0.}, {1.414213562373096, 
      1.7677669529663682`}, {2.1213203435596437`, 1.4142135623730951`}, {
      2.1213203435596424`, 2.8284271247461907`}, {1.414213562373093, 
      4.596194077712558}, {2.121320343559641, 4.242640687119286}, {
      2.1213203435596446`, 0.7071067811865476}, {2.1213203435596433`, 
      2.121320343559643}, {2.1213203435596415`, 3.535533905932738}, {
      2.12132034355964, 4.949747468305833}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 7}, {3, 6}, {3, 12}, {4, 5}, {4, 
         10}, {5, 9}, {5, 14}, {7, 8}, {7, 13}, {10, 11}, {10, 15}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[9],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[10],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[11],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[12],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[13],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[14],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[15],
          "15"],
         Annotation[#, 15, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 2.474873734152914}, {0.7071067811865491, 
       1.0606601717798199`}, {1.4142135623730976`, 0.353553390593273}, {
       0.7071067811865461, 3.88908729652601}, {1.4142135623730945`, 
       3.1819805153394634`}, {2.1213203435596455`, 0.}, {1.414213562373096, 
       1.7677669529663682`}, {2.1213203435596437`, 1.4142135623730951`}, {
       2.1213203435596424`, 2.8284271247461907`}, {1.414213562373093, 
       4.596194077712558}, {2.121320343559641, 4.242640687119286}, {
       2.1213203435596446`, 0.7071067811865476}, {2.1213203435596433`, 
       2.121320343559643}, {2.1213203435596415`, 3.535533905932738}, {
       2.12132034355964, 4.949747468305833}}]& ],
    AspectRatio->1.5275252316519456`,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{2.4748737341529172`, 0.}, {3.8890872965260117`, 
      0.7071067811865482}, {4.596194077712559, 1.414213562373096}, {
      1.0606601717798219`, 0.7071067811865467}, {1.7677669529663693`, 
      1.4142135623730945`}, {4.949747468305833, 2.1213203435596437`}, {
      3.181980515339464, 1.4142135623730954`}, {3.5355339059327373`, 
      2.121320343559643}, {2.1213203435596424`, 2.1213203435596424`}, {
      0.35355339059327395`, 1.4142135623730936`}, {0.707106781186547, 
      2.121320343559641}, {4.242640687119285, 2.1213203435596433`}, {
      2.82842712474619, 2.1213203435596424`}, {1.414213562373095, 
      2.121320343559642}, {0., 2.121320343559641}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 7}, {3, 6}, {3, 12}, {4, 5}, {4, 
         10}, {5, 9}, {5, 14}, {7, 8}, {7, 13}, {10, 11}, {10, 15}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[9],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[10],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[11],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[12],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[13],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[14],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[15],
          "15"],
         Annotation[#, 15, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{2.4748737341529172`, 0.}, {
       3.8890872965260117`, 0.7071067811865482}, {4.596194077712559, 
       1.414213562373096}, {1.0606601717798219`, 0.7071067811865467}, {
       1.7677669529663693`, 1.4142135623730945`}, {4.949747468305833, 
       2.1213203435596437`}, {3.181980515339464, 1.4142135623730954`}, {
       3.5355339059327373`, 2.121320343559643}, {2.1213203435596424`, 
       2.1213203435596424`}, {0.35355339059327395`, 1.4142135623730936`}, {
       0.707106781186547, 2.121320343559641}, {4.242640687119285, 
       2.1213203435596433`}, {2.82842712474619, 2.1213203435596424`}, {
       1.414213562373095, 2.121320343559642}, {0., 2.121320343559641}}]& ],
    AspectRatio->0.6546536707079773,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{2.1213203435596437`, 2.4748737341529172`}, {
      1.4142135623730956`, 3.8890872965260117`}, {0.7071067811865479, 
      4.59619407771256}, {1.4142135623730963`, 1.0606601717798219`}, {
      0.7071067811865486, 1.7677669529663689`}, {0., 4.949747468305833}, {
      0.7071067811865481, 3.1819805153394642`}, {4.440892098500626*^-16, 
      3.5355339059327378`}, {8.881784197001252*^-16, 2.1213203435596424`}, {
      0.707106781186549, 0.35355339059327395`}, {1.3322676295501878`*^-15, 
      0.707106781186547}, {4.440892098500626*^-16, 4.242640687119286}, {
      8.881784197001252*^-16, 2.8284271247461903`}, {8.881784197001252*^-16, 
      1.414213562373095}, {1.3322676295501878`*^-15, 0.}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 7}, {3, 6}, {3, 12}, {4, 5}, {4, 
         10}, {5, 9}, {5, 14}, {7, 8}, {7, 13}, {10, 11}, {10, 15}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[9],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[10],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[11],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[12],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[13],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[14],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[15],
          "15"],
         Annotation[#, 15, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{2.1213203435596437`, 2.4748737341529172`}, {
       1.4142135623730956`, 3.8890872965260117`}, {0.7071067811865479, 
       4.59619407771256}, {1.4142135623730963`, 1.0606601717798219`}, {
       0.7071067811865486, 1.7677669529663689`}, {0., 4.949747468305833}, {
       0.7071067811865481, 3.1819805153394642`}, {4.440892098500626*^-16, 
       3.5355339059327378`}, {8.881784197001252*^-16, 2.1213203435596424`}, {
       0.707106781186549, 0.35355339059327395`}, {1.3322676295501878`*^-15, 
       0.707106781186547}, {4.440892098500626*^-16, 4.242640687119286}, {
       8.881784197001252*^-16, 2.8284271247461903`}, {8.881784197001252*^-16, 
       1.414213562373095}, {1.3322676295501878`*^-15, 0.}}]& ],
    AspectRatio->1.5275252316519463`,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{2.0340670325583465`, 2.0340670325961727`}, {
      1.300180935618038, 2.0340670326620707`}, {0.9961953610982017, 
      3.0719387041961084`}, {2.767953129498655, 2.034067032464377}, {
      3.071938703925298, 0.9961953609030438}, {1.1915288810460911`, 
      4.068134065116692}, {0.9961953609118142, 0.9961953611826246}, {0., 
      1.1915288811752403`}, {2.876605183887958, 0.}, {3.0719387042980735`, 
      3.0719387039165262`}, {4.068134065192347, 2.8766051838344597`}, {
      1.5130829922327393`*^-10, 2.876605184382396}, {1.1915288806808009`, 
      2.269615606564912*^-10}, {4.06813406488973, 1.1915288806273043`}, {
      2.8766051846185396`, 4.068134064889729}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 7}, {3, 6}, {3, 12}, {4, 5}, {4, 
         10}, {5, 9}, {5, 14}, {7, 8}, {7, 13}, {10, 11}, {10, 15}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[9],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[10],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[11],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[12],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[13],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[14],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[15],
          "15"],
         Annotation[#, 15, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{2.0340670325583465`, 2.0340670325961727`}, {
       1.300180935618038, 2.0340670326620707`}, {0.9961953610982017, 
       3.0719387041961084`}, {2.767953129498655, 2.034067032464377}, {
       3.071938703925298, 0.9961953609030438}, {1.1915288810460911`, 
       4.068134065116692}, {0.9961953609118142, 0.9961953611826246}, {0., 
       1.1915288811752403`}, {2.876605183887958, 0.}, {3.0719387042980735`, 
       3.0719387039165262`}, {4.068134065192347, 2.8766051838344597`}, {
       1.5130829922327393`*^-10, 2.876605184382396}, {1.1915288806808009`, 
       2.269615606564912*^-10}, {4.06813406488973, 1.1915288806273043`}, {
       2.8766051846185396`, 4.068134064889729}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{563, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->251885608]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->190033263],

Cell["Draw a K-ary tree:", "ExampleText",
 CellID->417731522],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"KaryTree", "[", 
    RowBox[{"level_", ",", 
     RowBox[{"k_:", " ", "2"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"i", "\[Rule]", 
          RowBox[{
           RowBox[{"k", "*", "i"}], "+", "j"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{"k", "-", "2"}], ")"}]}], ",", "1", ",", "1"}], "}"}]}], 
        "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"k", "^", 
             RowBox[{"(", 
              RowBox[{"level", "-", "1"}], ")"}]}], "-", "1"}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"k", "-", "1"}], ")"}]}]}], "}"}]}], "]"}], "]"}], "/;", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"level", ">", "1"}], "&&", 
      RowBox[{"k", ">", "1"}]}], ")"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->212432726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"KaryTree", "[", 
    RowBox[{"4", ",", "3"}], "]"}], ",", "Center"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->138891],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.6335557481980123`, 2.638018858597688}, {
    1.8720252991615696`, 3.0776886684209526`}, {2.633555748079574, 
    1.7586792390651254`}, {3.395086197352893, 3.0776886682158118`}, {
    2.0320520228797654`, 4.290636761909569}, {1.1104948501251268`, 
    3.5173584782442173`}, {0.9015947984761208, 2.3326274137975243`}, {
    1.5030985237594232`, 1.2907924004128402`}, {2.633555747961138, 
    0.8793396195325627}, {3.764012972273686, 1.2907924001083182`}, {
    4.365516697837638, 2.332627413330968}, {4.156616646507773, 
    3.5173584778339375`}, {3.2350594739614404`, 4.290636761747536}, {
    2.3273004515124445`, 5.258200377418298}, {1.7313001602206413`, 
    5.11694571356551}, {1.1839407012140857`, 4.84205146132271}, {
    0.714730364604856, 4.448337240981191}, {0.34896440108868454`, 
    3.9570282880674834`}, {0.10636134843259759`, 3.39461119540224}, {0., 
    2.791406014025556}, {0.035614323615174914`, 2.1799316913974427`}, {
    0.2112843418737147, 1.5931529665231325`}, {0.5175396386213515, 
    1.0627032323408097`}, {0.9378699115401308, 0.6171791713204149}, {
    1.4496150468198516`, 0.28059910090979656`}, {2.0251867317588657`, 
    0.07110813982426034}, {2.6335557478426983`, 0.}, {3.241924763945686, 
    0.0711081396603781}, {3.8174964489411343`, 0.2805991005908681}, {
    4.329241584311523, 0.6171791708636332}, {4.749571857350315, 
    1.0627032317707983`}, {5.055827154240844, 1.5931529658706198`}, {
    5.23149717265745, 2.179931690697608}, {5.267111496437344, 
    2.791406013316128}, {5.160750148167238, 3.3946111947214646`}, {
    4.918147095662654, 3.95702828745206}, {4.552381132278832, 
    4.448337240464298}, {4.08317079577566, 4.842051460932215}, {
    3.535811336843154, 5.116945713322461}, {2.9398110455894035`, 
    5.2582003773358}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {2, 7}, {3, 8}, {3, 
       9}, {3, 10}, {4, 11}, {4, 12}, {4, 13}, {5, 14}, {5, 15}, {5, 16}, {6, 
       17}, {6, 18}, {6, 19}, {7, 20}, {7, 21}, {7, 22}, {8, 23}, {8, 24}, {8,
        25}, {9, 26}, {9, 27}, {9, 28}, {10, 29}, {10, 30}, {10, 31}, {11, 
       32}, {11, 33}, {11, 34}, {12, 35}, {12, 36}, {12, 37}, {13, 38}, {13, 
       39}, {13, 40}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "40"],
       Annotation[#, 40, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.6335557481980123`, 2.638018858597688}, {
     1.8720252991615696`, 3.0776886684209526`}, {2.633555748079574, 
     1.7586792390651254`}, {3.395086197352893, 3.0776886682158118`}, {
     2.0320520228797654`, 4.290636761909569}, {1.1104948501251268`, 
     3.5173584782442173`}, {0.9015947984761208, 2.3326274137975243`}, {
     1.5030985237594232`, 1.2907924004128402`}, {2.633555747961138, 
     0.8793396195325627}, {3.764012972273686, 1.2907924001083182`}, {
     4.365516697837638, 2.332627413330968}, {4.156616646507773, 
     3.5173584778339375`}, {3.2350594739614404`, 4.290636761747536}, {
     2.3273004515124445`, 5.258200377418298}, {1.7313001602206413`, 
     5.11694571356551}, {1.1839407012140857`, 4.84205146132271}, {
     0.714730364604856, 4.448337240981191}, {0.34896440108868454`, 
     3.9570282880674834`}, {0.10636134843259759`, 3.39461119540224}, {0., 
     2.791406014025556}, {0.035614323615174914`, 2.1799316913974427`}, {
     0.2112843418737147, 1.5931529665231325`}, {0.5175396386213515, 
     1.0627032323408097`}, {0.9378699115401308, 0.6171791713204149}, {
     1.4496150468198516`, 0.28059910090979656`}, {2.0251867317588657`, 
     0.07110813982426034}, {2.6335557478426983`, 0.}, {3.241924763945686, 
     0.0711081396603781}, {3.8174964489411343`, 0.2805991005908681}, {
     4.329241584311523, 0.6171791708636332}, {4.749571857350315, 
     1.0627032317707983`}, {5.055827154240844, 1.5931529658706198`}, {
     5.23149717265745, 2.179931690697608}, {5.267111496437344, 
     2.791406013316128}, {5.160750148167238, 3.3946111947214646`}, {
     4.918147095662654, 3.95702828745206}, {4.552381132278832, 
     4.448337240464298}, {4.08317079577566, 4.842051460932215}, {
     3.535811336843154, 5.116945713322461}, {2.9398110455894035`, 
     5.2582003773358}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->500402523]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113617842],

Cell["Generate and plot a random tree:", "ExampleText",
 CellID->29497398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"RandomInteger", "[", "#", "]"}], " ", "\[Rule]", " ", 
     RowBox[{"#", " ", "+", " ", "1"}]}], " ", "&"}], " ", "/@", " ", 
   RowBox[{"Range", "[", 
    RowBox[{"0", ",", " ", "30"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41905187],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.5735089073793896, 1.720526722138169}, {
    1.4337722684484742`, 2.2940356295175586`}, {4.014562351655727, 
    2.8675445368969483`}, {2.2940356295175586`, 1.720526722138169}, {
    1.720526722138169, 1.1470178147587793`}, {2.8675445368969483`, 
    2.2940356295175586`}, {4.014562351655727, 2.2940356295175586`}, {
    3.7278078979660325`, 1.720526722138169}, {4.588071259035117, 
    2.2940356295175586`}, {5.448334620104202, 2.2940356295175586`}, {
    3.441053444276338, 1.1470178147587793`}, {2.8675445368969483`, 
    1.720526722138169}, {4.874825712724812, 1.720526722138169}, {
    5.448334620104202, 1.720526722138169}, {0., 1.1470178147587793`}, {
    2.2940356295175586`, 1.1470178147587793`}, {6.595352434862981, 
    2.2940356295175586`}, {4.014562351655727, 1.1470178147587793`}, {
    6.595352434862981, 1.720526722138169}, {3.441053444276338, 
    0.5735089073793898}, {6.0218435274835915`, 1.720526722138169}, {
    5.448334620104202, 1.1470178147587793`}, {4.301316805345422, 
    1.720526722138169}, {0.5735089073793896, 1.1470178147587793`}, {
    6.0218435274835915`, 1.1470178147587793`}, {0., 0.5735089073793898}, {
    2.8675445368969483`, 1.1470178147587793`}, {1.1470178147587793`, 
    1.1470178147587793`}, {6.0218435274835915`, 0.5735089073793898}, {
    6.0218435274835915`, 0.}, {4.874825712724812, 1.1470178147587793`}, {
    2.2940356295175586`, 0.5735089073793898}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 15}, {1, 24}, {1, 28}, {2, 3}, {2, 4}, {3, 6}, {3, 
       7}, {3, 9}, {3, 10}, {3, 17}, {4, 5}, {4, 16}, {4, 27}, {6, 12}, {7, 
       8}, {7, 23}, {8, 11}, {8, 18}, {10, 13}, {10, 14}, {10, 21}, {11, 
       20}, {13, 31}, {14, 22}, {15, 26}, {16, 32}, {17, 19}, {21, 25}, {25, 
       29}, {29, 30}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "31"],
       Annotation[#, 31, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.5735089073793896, 1.720526722138169}, {
     1.4337722684484742`, 2.2940356295175586`}, {4.014562351655727, 
     2.8675445368969483`}, {2.2940356295175586`, 1.720526722138169}, {
     1.720526722138169, 1.1470178147587793`}, {2.8675445368969483`, 
     2.2940356295175586`}, {4.014562351655727, 2.2940356295175586`}, {
     3.7278078979660325`, 1.720526722138169}, {4.588071259035117, 
     2.2940356295175586`}, {5.448334620104202, 2.2940356295175586`}, {
     3.441053444276338, 1.1470178147587793`}, {2.8675445368969483`, 
     1.720526722138169}, {4.874825712724812, 1.720526722138169}, {
     5.448334620104202, 1.720526722138169}, {0., 1.1470178147587793`}, {
     2.2940356295175586`, 1.1470178147587793`}, {6.595352434862981, 
     2.2940356295175586`}, {4.014562351655727, 1.1470178147587793`}, {
     6.595352434862981, 1.720526722138169}, {3.441053444276338, 
     0.5735089073793898}, {6.0218435274835915`, 1.720526722138169}, {
     5.448334620104202, 1.1470178147587793`}, {4.301316805345422, 
     1.720526722138169}, {0.5735089073793896, 1.1470178147587793`}, {
     6.0218435274835915`, 1.1470178147587793`}, {0., 0.5735089073793898}, {
     2.8675445368969483`, 1.1470178147587793`}, {1.1470178147587793`, 
     1.1470178147587793`}, {6.0218435274835915`, 0.5735089073793898}, {
     6.0218435274835915`, 0.}, {4.874825712724812, 1.1470178147587793`}, {
     2.2940356295175586`, 0.5735089073793898}}]& ],
  AspectRatio->0.659380473395787,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->587340453]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->943217],

Cell["Delete random connections in a binary tree:", "ExampleText",
 CellID->46269310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"Delete", "[", 
   RowBox[{
    RowBox[{"Flatten", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i", "\[Rule]", " ", 
         RowBox[{
          RowBox[{"2", "i"}], "+", "j", "-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "100"}], "}"}]}], "]"}], "]"}], ",", 
    RowBox[{"List", "/@", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "100"}], "}"}], ",", 
       RowBox[{"{", "40", "}"}]}], "]"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->300061220],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxlVntY02UbHiCwCQ42BgxmyGBsbOMw4spAgr2RYCIBuhRQQA0pVBACBaJC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    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {2, 5}, {3, 4}, {3, 115}, {4, 7}, {4, 10}, {5, 
       6}, {5, 117}, {6, 120}, {7, 122}, {8, 9}, {8, 19}, {9, 18}, {9, 39}, {
       10, 11}, {10, 25}, {11, 60}, {12, 13}, {12, 27}, {13, 67}, {14, 15}, {
       14, 34}, {15, 33}, {15, 76}, {16, 17}, {16, 37}, {17, 36}, {17, 78}, {
       18, 128}, {19, 20}, {19, 42}, {20, 41}, {20, 129}, {21, 22}, {21, 
       45}, {22, 44}, {22, 130}, {23, 24}, {23, 50}, {24, 49}, {24, 97}, {25, 
       26}, {25, 63}, {26, 62}, {26, 139}, {27, 28}, {27, 69}, {28, 143}, {29,
        30}, {29, 72}, {30, 71}, {30, 145}, {31, 32}, {31, 126}, {32, 74}, {
       32, 147}, {33, 75}, {33, 149}, {34, 35}, {34, 127}, {35, 151}, {36, 
       153}, {37, 38}, {37, 81}, {38, 80}, {38, 155}, {39, 40}, {39, 86}, {40,
        85}, {40, 159}, {41, 161}, {42, 43}, {42, 89}, {43, 88}, {43, 163}, {
       44, 165}, {45, 46}, {45, 91}, {46, 167}, {47, 48}, {47, 133}, {48, 
       95}, {48, 171}, {49, 96}, {49, 173}, {50, 51}, {50, 100}, {51, 99}, {
       51, 175}, {52, 53}, {52, 103}, {53, 102}, {53, 177}, {54, 55}, {54, 
       109}, {55, 181}, {56, 57}, {56, 112}, {57, 111}, {57, 183}, {58, 59}, {
       58, 134}, {59, 114}, {59, 185}, {60, 61}, {60, 138}, {63, 64}, {63, 
       140}, {65, 66}, {65, 141}, {67, 68}, {67, 142}, {69, 70}, {69, 144}, {
       72, 73}, {72, 146}, {76, 77}, {76, 150}, {78, 79}, {78, 154}, {81, 
       82}, {81, 156}, {83, 84}, {83, 157}, {86, 87}, {86, 160}, {89, 90}, {
       89, 164}, {91, 92}, {91, 168}, {93, 94}, {93, 169}, {97, 98}, {97, 
       174}, {100, 101}, {100, 176}, {103, 104}, {103, 178}, {105, 106}, {105,
        179}, {107, 108}, {107, 180}, {109, 110}, {109, 182}, {112, 113}, {
       112, 184}, {115, 118}, {116, 8}, {117, 121}, {118, 31}, {119, 16}, {
       120, 47}, {121, 123}, {122, 125}, {123, 107}, {124, 56}, {125, 135}, {
       126, 148}, {127, 152}, {128, 158}, {129, 162}, {130, 166}, {131, 
       132}, {132, 170}, {133, 172}, {136, 137}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "54"],
       Annotation[#, 54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "58"],
       Annotation[#, 58, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "60"],
       Annotation[#, 60, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "62"],
       Annotation[#, 62, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "64"],
       Annotation[#, 64, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "66"],
       Annotation[#, 66, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "68"],
       Annotation[#, 68, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "70"],
       Annotation[#, 70, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "74"],
       Annotation[#, 74, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "76"],
       Annotation[#, 76, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "78"],
       Annotation[#, 78, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "80"],
       Annotation[#, 80, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "82"],
       Annotation[#, 82, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "86"],
       Annotation[#, 86, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "88"],
       Annotation[#, 88, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "90"],
       Annotation[#, 90, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[53],
        "92"],
       Annotation[#, 92, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[54],
        "48"],
       Annotation[#, 48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[55],
        "96"],
       Annotation[#, 96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[56],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[57],
        "98"],
       Annotation[#, 98, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[58],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[59],
        "100"],
       Annotation[#, 100, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[60],
        "53"],
       Annotation[#, 53, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[61],
        "106"],
       Annotation[#, 106, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[62],
        "108"],
       Annotation[#, 108, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[63],
        "55"],
       Annotation[#, 55, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[64],
        "110"],
       Annotation[#, 110, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[65],
        "56"],
       Annotation[#, 56, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[66],
        "112"],
       Annotation[#, 112, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[67],
        "57"],
       Annotation[#, 57, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[68],
        "114"],
       Annotation[#, 114, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[69],
        "59"],
       Annotation[#, 59, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[70],
        "118"],
       Annotation[#, 118, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[71],
        "120"],
       Annotation[#, 120, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[72],
        "61"],
       Annotation[#, 61, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[73],
        "122"],
       Annotation[#, 122, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[74],
        "124"],
       Annotation[#, 124, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[75],
        "128"],
       Annotation[#, 128, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[76],
        "65"],
       Annotation[#, 65, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[77],
        "130"],
       Annotation[#, 130, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[78],
        "69"],
       Annotation[#, 69, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[79],
        "138"],
       Annotation[#, 138, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[80],
        "140"],
       Annotation[#, 140, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[81],
        "71"],
       Annotation[#, 71, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[82],
        "142"],
       Annotation[#, 142, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[83],
        "72"],
       Annotation[#, 72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[84],
        "144"],
       Annotation[#, 144, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[85],
        "148"],
       Annotation[#, 148, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[86],
        "75"],
       Annotation[#, 75, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[87],
        "150"],
       Annotation[#, 150, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[88],
        "156"],
       Annotation[#, 156, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[89],
        "79"],
       Annotation[#, 79, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[90],
        "158"],
       Annotation[#, 158, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[91],
        "83"],
       Annotation[#, 83, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[92],
        "166"],
       Annotation[#, 166, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[93],
        "84"],
       Annotation[#, 84, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[94],
        "168"],
       Annotation[#, 168, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[95],
        "172"],
       Annotation[#, 172, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[96],
        "176"],
       Annotation[#, 176, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[97],
        "89"],
       Annotation[#, 89, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[98],
        "178"],
       Annotation[#, 178, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[99],
        "180"],
       Annotation[#, 180, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[100],
        "91"],
       Annotation[#, 91, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[101],
        "182"],
       Annotation[#, 182, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[102],
        "184"],
       Annotation[#, 184, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[103],
        "93"],
       Annotation[#, 93, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[104],
        "186"],
       Annotation[#, 186, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[105],
        "94"],
       Annotation[#, 94, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[106],
        "188"],
       Annotation[#, 188, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[107],
        "95"],
       Annotation[#, 95, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[108],
        "190"],
       Annotation[#, 190, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[109],
        "97"],
       Annotation[#, 97, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[110],
        "194"],
       Annotation[#, 194, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[111],
        "196"],
       Annotation[#, 196, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[112],
        "99"],
       Annotation[#, 99, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[113],
        "198"],
       Annotation[#, 198, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[114],
        "200"],
       Annotation[#, 200, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[115],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[116],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[117],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[118],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[119],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[120],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[121],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[122],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[123],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[124],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[125],
        "51"],
       Annotation[#, 51, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[126],
        "63"],
       Annotation[#, 63, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[127],
        "67"],
       Annotation[#, 67, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[128],
        "73"],
       Annotation[#, 73, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[129],
        "77"],
       Annotation[#, 77, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[130],
        "81"],
       Annotation[#, 81, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[131],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[132],
        "85"],
       Annotation[#, 85, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[133],
        "87"],
       Annotation[#, 87, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[134],
        "101"],
       Annotation[#, 101, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[135],
        "103"],
       Annotation[#, 103, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[136],
        "52"],
       Annotation[#, 52, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[137],
        "105"],
       Annotation[#, 105, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[138],
        "107"],
       Annotation[#, 107, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[139],
        "109"],
       Annotation[#, 109, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[140],
        "111"],
       Annotation[#, 111, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[141],
        "113"],
       Annotation[#, 113, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[142],
        "115"],
       Annotation[#, 115, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[143],
        "117"],
       Annotation[#, 117, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[144],
        "119"],
       Annotation[#, 119, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[145],
        "121"],
       Annotation[#, 121, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[146],
        "123"],
       Annotation[#, 123, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[147],
        "125"],
       Annotation[#, 125, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[148],
        "127"],
       Annotation[#, 127, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[149],
        "129"],
       Annotation[#, 129, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[150],
        "131"],
       Annotation[#, 131, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[151],
        "133"],
       Annotation[#, 133, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[152],
        "135"],
       Annotation[#, 135, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[153],
        "137"],
       Annotation[#, 137, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[154],
        "139"],
       Annotation[#, 139, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[155],
        "141"],
       Annotation[#, 141, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[156],
        "143"],
       Annotation[#, 143, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[157],
        "145"],
       Annotation[#, 145, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[158],
        "147"],
       Annotation[#, 147, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[159],
        "149"],
       Annotation[#, 149, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[160],
        "151"],
       Annotation[#, 151, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[161],
        "153"],
       Annotation[#, 153, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[162],
        "155"],
       Annotation[#, 155, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[163],
        "157"],
       Annotation[#, 157, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[164],
        "159"],
       Annotation[#, 159, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[165],
        "161"],
       Annotation[#, 161, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[166],
        "163"],
       Annotation[#, 163, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[167],
        "165"],
       Annotation[#, 165, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[168],
        "167"],
       Annotation[#, 167, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[169],
        "169"],
       Annotation[#, 169, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[170],
        "171"],
       Annotation[#, 171, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[171],
        "173"],
       Annotation[#, 173, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[172],
        "175"],
       Annotation[#, 175, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[173],
        "177"],
       Annotation[#, 177, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[174],
        "179"],
       Annotation[#, 179, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[175],
        "181"],
       Annotation[#, 181, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[176],
        "183"],
       Annotation[#, 183, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[177],
        "185"],
       Annotation[#, 185, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[178],
        "187"],
       Annotation[#, 187, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[179],
        "189"],
       Annotation[#, 189, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[180],
        "191"],
       Annotation[#, 191, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[181],
        "193"],
       Annotation[#, 193, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[182],
        "195"],
       Annotation[#, 195, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[183],
        "197"],
       Annotation[#, 197, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[184],
        "199"],
       Annotation[#, 199, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[185],
        "201"],
       Annotation[#, 201, "Tooltip"]& ]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxlVntY02UbHiCwCQ42BgxmyGBsbOMw4spAgr2RYCIBuhRQQA0pVBACBaJC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     "]]& ],
  AspectRatio->1.0541288169161243`,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 190},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132571779]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1604511784],

Cell["Linking a number with one that is one bit rotated right:", "ExampleText",
 CellID->1746063565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"j", "->", 
      RowBox[{"FromDigits", "[", 
       RowBox[{
        RowBox[{"RotateRight", "[", 
         RowBox[{"IntegerDigits", "[", 
          RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", "2"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", 
       RowBox[{
        RowBox[{"2", "^", "8"}], "-", "1"}]}], "}"}]}], "]"}], ",", 
   "Center"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->759610285],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 175},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->333983456]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->842478017],

Cell["Linking a number with one that is one bit rotated left:", "ExampleText",
 CellID->1696081216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"j", "->", 
     RowBox[{"FromDigits", "[", 
      RowBox[{
       RowBox[{"RotateLeft", "[", 
        RowBox[{"IntegerDigits", "[", 
         RowBox[{"j", ",", "2"}], "]"}], "]"}], ",", "2"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", 
      RowBox[{
       RowBox[{"2", "^", "6"}], "-", "1"}]}], "}"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->856391230],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxlVnlYTG0bb9pmCzPN1Awtc6aZKGRJlkg9ibS9SlpIZCnxWrKUN8nSTqFo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    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
         80, 81, 82, 83, 84, 85, 86, 87, 1}, {2, 88, 89, 90, 91, 92, 93, 94, 
        95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 
        110, 2}, {3, 2}, {4, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120,
         121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 
        4}, {5, 2}, {6, 4}, {7, 6}, {8, 134, 135, 136, 137, 138, 139, 140, 
        141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 
        155, 156, 8}, {9, 2}, {10, 4}, {11, 6}, {12, 8}, {13, 10}, {14, 12}, {
        15, 14}, {16, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 
        168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 16}, {17, 
        2}, {18, 4}, {19, 6}, {20, 8}, {21, 10}, {22, 12}, {23, 14}, {24, 
        16}, {25, 18}, {26, 20}, {27, 22}, {28, 24}, {29, 26}, {30, 28}, {31, 
        30}, {32, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 
        192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 32}, {33, 2}, {
        34, 4}, {35, 6}, {36, 8}, {37, 10}, {38, 12}, {39, 14}, {40, 16}, {41,
         18}, {42, 20}, {43, 22}, {44, 24}, {45, 26}, {46, 28}, {47, 30}, {48,
         32}, {49, 34}, {50, 36}, {51, 38}, {52, 40}, {53, 42}, {54, 44}, {55,
         46}, {56, 48}, {57, 50}, {58, 52}, {59, 54}, {60, 56}, {61, 58}, {62,
         60}, {63, 62}, {64, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212,
         213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 
        64}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "48"],
       Annotation[#, 48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "51"],
       Annotation[#, 51, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[53],
        "52"],
       Annotation[#, 52, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[54],
        "53"],
       Annotation[#, 53, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[55],
        "54"],
       Annotation[#, 54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[56],
        "55"],
       Annotation[#, 55, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[57],
        "56"],
       Annotation[#, 56, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[58],
        "57"],
       Annotation[#, 57, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[59],
        "58"],
       Annotation[#, 58, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[60],
        "59"],
       Annotation[#, 59, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[61],
        "60"],
       Annotation[#, 60, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[62],
        "61"],
       Annotation[#, 61, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[63],
        "62"],
       Annotation[#, 62, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[64],
        "63"],
       Annotation[#, 63, "Tooltip"]& ]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxTTMoPSmViYGBwAGIQzeAztf/HVQWHlwdetS2SVzkA49+zD3gboyt6wLL7
mG87r6yDkxvTtYk14gd21j5a8/MTp0PF8/SNrfnKB+ZOrDDbEyMPl09XSdY9
1vfV3obDc2ZukcqBeLPVc89df2TPqKnVGFqqeiDKWyUhgVnQQbBft/TJFQm4
fTD9X2MYjwp+4HCA6Q9ZeK9XrfkjXL/appvGUXHMDhpbXz30cpM+8OhmjWrR
ExYHmHyf8SnGRsPP9g63l/tt3C4Lt39Nw6a73SIKB4od/K+xnuJ0MJh91e95
9sf9Rv7vmCf/VYTbHxj0LHNCmyDc/qrlz8+kzvoJt//7LoEMBUERuP0w98Lk
bW9MW3DgPKsDzH6Ye2D2f/wrIagVxuxw7+sjj3v6//f3GrI2rWgWgOtPvdc0
TdhGCK4f5l+Y/i6fNPY7C37Zu2lULHxVyQYPT5h8m8ed0498P9jPvVon9yya
F+7/qoOHzn6QEzrA334s/1GigsMymfAlod+ZD6QEuVfoqirD/T9/S6eiR78I
3P/nw360XrrBAHffwr3RyyaHS8D9z/6gNWXjbx64fIvXuWeflXnh7n9zet8W
qe9/4P6HuEMA7n+x4uOBFZ1CcP2d0+dZ6j4ThesP/RfMq+7IAfcfxF+cDjD/
FxY+PHOsRBguDxFncoD5H2LPdwz/27066O259sd+mH/R/QezH+YfdPfD7Ie5
F919MPth7oHZD07voYoOCZB42Q+zD918mH6YeTD9HwVS1vN5KcHdD1OPLg+L
Xxhfx+XsIrYZ3PD8xvXkdeHru3IHAMp83fo=
     "]]& ],
  AspectRatio->1.0624209777819476`,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{229, 239},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->563443096]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->581457596],

Cell["Linking a number with itself but with last bit dropped:", "ExampleText",
 CellID->1522827744],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"j", "->", 
      RowBox[{"FromDigits", "[", 
       RowBox[{
        RowBox[{"Drop", "[", 
         RowBox[{
          RowBox[{"IntegerDigits", "[", 
           RowBox[{"j", ",", "2"}], "]"}], ",", 
          RowBox[{"-", "1"}]}], "]"}], ",", "2"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", 
       RowBox[{
        RowBox[{"2", "^", "8"}], "-", "1"}]}], "}"}]}], "]"}], ",", 
   "Center"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2050629870],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJw1l3k8VPv/x8cSCtnGMoOxzJgt4VpKbjovEaVNIiVpuaKkTFkuJUnWstUl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    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268,
         269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 1}, {2, 1}, {
        3, 2}, {4, 2}, {5, 3}, {6, 3}, {7, 4}, {8, 4}, {9, 5}, {10, 5}, {11, 
        6}, {12, 6}, {13, 7}, {14, 7}, {15, 8}, {16, 8}, {17, 9}, {18, 9}, {
        19, 10}, {20, 10}, {21, 11}, {22, 11}, {23, 12}, {24, 12}, {25, 13}, {
        26, 13}, {27, 14}, {28, 14}, {29, 15}, {30, 15}, {31, 16}, {32, 16}, {
        33, 17}, {34, 17}, {35, 18}, {36, 18}, {37, 19}, {38, 19}, {39, 20}, {
        40, 20}, {41, 21}, {42, 21}, {43, 22}, {44, 22}, {45, 23}, {46, 23}, {
        47, 24}, {48, 24}, {49, 25}, {50, 25}, {51, 26}, {52, 26}, {53, 27}, {
        54, 27}, {55, 28}, {56, 28}, {57, 29}, {58, 29}, {59, 30}, {60, 30}, {
        61, 31}, {62, 31}, {63, 32}, {64, 32}, {65, 33}, {66, 33}, {67, 34}, {
        68, 34}, {69, 35}, {70, 35}, {71, 36}, {72, 36}, {73, 37}, {74, 37}, {
        75, 38}, {76, 38}, {77, 39}, {78, 39}, {79, 40}, {80, 40}, {81, 41}, {
        82, 41}, {83, 42}, {84, 42}, {85, 43}, {86, 43}, {87, 44}, {88, 44}, {
        89, 45}, {90, 45}, {91, 46}, {92, 46}, {93, 47}, {94, 47}, {95, 48}, {
        96, 48}, {97, 49}, {98, 49}, {99, 50}, {100, 50}, {101, 51}, {102, 
        51}, {103, 52}, {104, 52}, {105, 53}, {106, 53}, {107, 54}, {108, 
        54}, {109, 55}, {110, 55}, {111, 56}, {112, 56}, {113, 57}, {114, 
        57}, {115, 58}, {116, 58}, {117, 59}, {118, 59}, {119, 60}, {120, 
        60}, {121, 61}, {122, 61}, {123, 62}, {124, 62}, {125, 63}, {126, 
        63}, {127, 64}, {128, 64}, {129, 65}, {130, 65}, {131, 66}, {132, 
        66}, {133, 67}, {134, 67}, {135, 68}, {136, 68}, {137, 69}, {138, 
        69}, {139, 70}, {140, 70}, {141, 71}, {142, 71}, {143, 72}, {144, 
        72}, {145, 73}, {146, 73}, {147, 74}, {148, 74}, {149, 75}, {150, 
        75}, {151, 76}, {152, 76}, {153, 77}, {154, 77}, {155, 78}, {156, 
        78}, {157, 79}, {158, 79}, {159, 80}, {160, 80}, {161, 81}, {162, 
        81}, {163, 82}, {164, 82}, {165, 83}, {166, 83}, {167, 84}, {168, 
        84}, {169, 85}, {170, 85}, {171, 86}, {172, 86}, {173, 87}, {174, 
        87}, {175, 88}, {176, 88}, {177, 89}, {178, 89}, {179, 90}, {180, 
        90}, {181, 91}, {182, 91}, {183, 92}, {184, 92}, {185, 93}, {186, 
        93}, {187, 94}, {188, 94}, {189, 95}, {190, 95}, {191, 96}, {192, 
        96}, {193, 97}, {194, 97}, {195, 98}, {196, 98}, {197, 99}, {198, 
        99}, {199, 100}, {200, 100}, {201, 101}, {202, 101}, {203, 102}, {204,
         102}, {205, 103}, {206, 103}, {207, 104}, {208, 104}, {209, 105}, {
        210, 105}, {211, 106}, {212, 106}, {213, 107}, {214, 107}, {215, 
        108}, {216, 108}, {217, 109}, {218, 109}, {219, 110}, {220, 110}, {
        221, 111}, {222, 111}, {223, 112}, {224, 112}, {225, 113}, {226, 
        113}, {227, 114}, {228, 114}, {229, 115}, {230, 115}, {231, 116}, {
        232, 116}, {233, 117}, {234, 117}, {235, 118}, {236, 118}, {237, 
        119}, {238, 119}, {239, 120}, {240, 120}, {241, 121}, {242, 121}, {
        243, 122}, {244, 122}, {245, 123}, {246, 123}, {247, 124}, {248, 
        124}, {249, 125}, {250, 125}, {251, 126}, {252, 126}, {253, 127}, {
        254, 127}, {255, 128}, {256, 128}}]}, 
     {RGBColor[0, 0, 0.7], PointBox[CompressedData["
1:eJwd0wOfEAYAxuEue7Va1lXbsm1zC5ddl3XZ5rK11dJybbll27Zt20+9v//z
Ed7A4DZBIQGhLOB7oUIThrCEIzwRiEgkIhOFqEQjOj8Qg5j8SCxi8xNxiEs8
4pOAhCQiMUlISjICSU4KUvIzv/ArqUhNGtKSjvRkICOZyEwWspKN7OQgJ7nI
TR7yko/8FKAghShMEYpSjOKUoCSlKE0ZyvIbv1OO8lSgIkFUojJVqEo1qlOD
mtSiNnWoSz3q04BgGtKIxjShKc1oTgta0orWhNCGtrSjPR3oSCc604WudKM7
PehJL3rTh770oz8DGMggBvMHQxjKMIYzgpGMYjRjGMs4xjOBiUxiMlP4k7+Y
yjT+ZjozmMksZvMPc5jLPOazgIUsYjFL+Jf/WMoylrOClaxiNWv4n7WsYz0b
2MgmNrOFrWxjOzvYyS52s4e97GM/BzjIIQ5zhKMc4zgnOMkpTnOGs5zjPBe4
yCUuc4WrXOM6N7jJLW5zh7vc4z4PeMgjHvOEpzzjOS94ySte84a3vOM9H/jI
Jz7zhW/n/wqYtIE2
       "]]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw1l3k4lOv/xycJhWxj32fGbAnHUuqk+y2itEmkJC1HKikTcrRJslW2OkR0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     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{229, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->287215605]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1514008187],

Cell["Linking a number with itself but with first bit dropped:", "ExampleText",
 CellID->1238314478],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"j", "->", 
     RowBox[{"FromDigits", "[", 
      RowBox[{
       RowBox[{"Drop", "[", 
        RowBox[{
         RowBox[{"IntegerDigits", "[", 
          RowBox[{"j", ",", "2"}], "]"}], ",", "1"}], "]"}], ",", "2"}], 
      "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "0", ",", 
      RowBox[{
       RowBox[{"2", "^", "6"}], "-", "1"}]}], "}"}]}], "]"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->1448658424],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGAIB2IQbT3l75zta6Uclk2UXjrnAYODROzm5G/dXA77P+kK
syr+sWczv3Tn/XVJOD/D5ETBkzk/7I0Oqdy50PDNXnLrp/3TIxXg8t0NXXUf
WbgcYPJa+ltmnFUTg/Pfai44sG3DY3uIfR/sT969u2mlhxJcP0RcAK4eYp4U
nF8ZtfL7q4CfcP1s3Zv05D/KweWNwTSbA0z+n3+j+94UETgfIn8M6v5n9k+m
6dduDlOG23+beb/lhj9CcPMOgMVl4HxYOMHMm/tvVeLMNgW4/Jxl2aw/dnCh
2SeGxn8Gt/+gV27+sneKcP1Ts63kpukIwNVD/CuJpv8bXP+XlIvLJWzl4PIC
ZUnnDkuwOsDkIeEtDOczQIEBmH/N/useAZZdXCpw/8PCC+aex3YfFIQ6ZdHi
jxlu33qVnhfzrRTR1PPC5cP4nr+8+0IczofRMPdcKvD7tmaRElz/ju1/tBdP
EYSrh4SnFJx/AOpOmH6JjZO3qi6VR7OPHe5fSHiIwvnGUH/D/A+Lf5j9sPhH
tU8Gzf0McPNg8Y/qXi40+8TQ+M/g9sPiH6YfFv8w9bD4R9X/Da4fFv+o/mV1
gMnD4h/GZ0ADy5ek7WUskXKIEqqeufk3g4OSnln2ZlMph61RxoLM2owOm6qz
Iw/8l3TQEZrxwaWS0SF3+1rNV1clHdoyl/ixPWR0yJlWNFVqt6RDauX7w7zR
TA6Vn7c06m+UdLCZsEb/zj0mh48Ky3bc3CHpoPF+upZLMrPD96elsyZclHTw
9vecw3uf2SFuwqwFs39KOrjxSPPP8mRxYOLk5DLUk3KwPt4fWDebxeHtoYW9
y7OlHGa6n93Edp7FAbW8YnHoTI1cc/w9Qr5Y/pO+na40XL/EjISZlxOlHdyh
5tc7tc6/1ykNt7+VPbRx6iJpB02o+/6auO2wXyUNdz/XpI4lIQuk4f7jLPQV
aG2Vhvv/yJr+B+uipR10oeET8uvIud2q0vDwO988pSb3uZRDNDR8AetMj+U=

    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
         80, 81, 82, 83, 84, 85, 86, 87, 1}, {2, 1}, {3, 1}, {4, 2}, {5, 1}, {
        6, 2}, {7, 3}, {8, 4}, {9, 1}, {10, 2}, {11, 3}, {12, 4}, {13, 5}, {
        14, 6}, {15, 7}, {16, 8}, {17, 1}, {18, 2}, {19, 3}, {20, 4}, {21, 
        5}, {22, 6}, {23, 7}, {24, 8}, {25, 9}, {26, 10}, {27, 11}, {28, 
        12}, {29, 13}, {30, 14}, {31, 15}, {32, 16}, {33, 1}, {34, 2}, {35, 
        3}, {36, 4}, {37, 5}, {38, 6}, {39, 7}, {40, 8}, {41, 9}, {42, 10}, {
        43, 11}, {44, 12}, {45, 13}, {46, 14}, {47, 15}, {48, 16}, {49, 17}, {
        50, 18}, {51, 19}, {52, 20}, {53, 21}, {54, 22}, {55, 23}, {56, 24}, {
        57, 25}, {58, 26}, {59, 27}, {60, 28}, {61, 29}, {62, 30}, {63, 31}, {
        64, 32}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "48"],
       Annotation[#, 48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "51"],
       Annotation[#, 51, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[53],
        "52"],
       Annotation[#, 52, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[54],
        "53"],
       Annotation[#, 53, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[55],
        "54"],
       Annotation[#, 54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[56],
        "55"],
       Annotation[#, 55, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[57],
        "56"],
       Annotation[#, 56, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[58],
        "57"],
       Annotation[#, 57, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[59],
        "58"],
       Annotation[#, 58, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[60],
        "59"],
       Annotation[#, 59, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[61],
        "60"],
       Annotation[#, 60, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[62],
        "61"],
       Annotation[#, 61, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[63],
        "62"],
       Annotation[#, 62, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[64],
        "63"],
       Annotation[#, 63, "Tooltip"]& ]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxTTMoPSmViYGBwAGIQbT3l75zta6Uclk2UXjrnAYODROzm5G/dXA77P+kK
syr+sWczv3Tn/XVJOD/D5ETBkzk/7I0Oqdy50PDNXnLrp/3TIxXg8t0NXXUf
WbgcYPJa+ltmnFUTg/Pfai44sG3DY3uIfR/sT969u2mlhxJcP0RcAK4eYp4U
nF8ZtfL7q4CfcP1s3Zv05D/KweWNwTSbA0z+n3+j+94UETgfIn8M6v5n9k+m
6dduDlOG23+beb/lhj9CcPMOgMVl4HxYOMHMm/tvVeLMNgW4/Jxl2aw/dnCh
2SeGxn8Gt/+gV27+sneKcP1Ts63kpukIwNVD/CuJpv8bXP+XlIvLJWzl4PIC
ZUnnDkuwOsDkIeEtDOczQIEBmH/N/useAZZdXCpw/8PCC+aex3YfFIQ6ZdHi
jxlu33qVnhfzrRTR1PPC5cP4nr+8+0IczofRMPdcKvD7tmaRElz/ju1/tBdP
EYSrh4SnFJx/AOpOmH6JjZO3qi6VR7OPHe5fSHiIwvnGUH/D/A+Lf5j9sPhH
tU8Gzf0McPNg8Y/qXi40+8TQ+M/g9sPiH6YfFv8w9bD4R9X/Da4fFv+o/mV1
gMnD4h/GZ0ADAAfn/EQ=
     "]]& ],
  AspectRatio->0.5103153756241231,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{229, 115},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->342802775]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " for hierachical style drawing of directed graph:"
}], "ExampleText",
 CellID->42741813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"pt", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"1", "\[Rule]", "4"}], ",", 
       RowBox[{"1", "\[Rule]", "6"}], ",", 
       RowBox[{"1", "\[Rule]", "8"}], ",", 
       RowBox[{"2", "\[Rule]", "6"}], ",", 
       RowBox[{"3", "\[Rule]", "8"}], ",", 
       RowBox[{"4", "\[Rule]", "5"}], ",", 
       RowBox[{"7", "\[Rule]", "8"}]}], "}"}], ",", 
     RowBox[{"PlotLabel", "\[Rule]", "pt"}], ",", 
     RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
     RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"pt", ",", 
     RowBox[{"{", 
      RowBox[{"TreePlot", ",", "LayeredGraphPlot"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1047607103],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{1.01162829777814, 1.618605276445024}, {0., 
      0.809302638222512}, {0.809302638222512, 0.809302638222512}, {
      2.02325659555628, 0.809302638222512}, {0.809302638222512, 0.}, {
      1.618605276445024, 0.}, {0., 0.}, {2.427907914667536, 0.}}, {
       {RGBColor[0.5, 0., 0.], Arrowheads[{{0.03150025645452451, 0.7}}], 
        ArrowBox[{1, 2}], ArrowBox[{1, 3}], ArrowBox[{1, 4}], 
        ArrowBox[{2, 7}], ArrowBox[{5, 3}], ArrowBox[{6, 4}], 
        ArrowBox[{8, 4}]}, {InsetBox[
         FrameBox["1",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 1], InsetBox[
         FrameBox["4",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 2], InsetBox[
         FrameBox["6",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 3], InsetBox[
         FrameBox["8",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 4], InsetBox[
         FrameBox["2",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 5], InsetBox[
         FrameBox["3",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 6], InsetBox[
         FrameBox["5",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 7], InsetBox[
         FrameBox["7",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 8]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{1.01162829777814, 1.618605276445024}, {0., 
       0.809302638222512}, {0.809302638222512, 0.809302638222512}, {
       2.02325659555628, 0.809302638222512}, {0.809302638222512, 0.}, {
       1.618605276445024, 0.}, {0., 0.}, {2.427907914667536, 0.}}]& ],
    AspectRatio->0.816496580927726,
    FrameTicks->None,
    PlotLabel->FormBox["TreePlot", TraditionalForm],
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0., 2.}, {0., 1.}, {-1., 1.}, {1., 1.}, {-1., 2.}, {
      1., 2.}, {0., 0.}, {2., 2.}}, {
       {RGBColor[0.5, 0., 0.], Arrowheads[{{0.028937842778793417`, 0.7}}], 
        ArrowBox[{1, 2}], ArrowBox[{1, 3}], ArrowBox[{1, 4}], 
        ArrowBox[{2, 7}], ArrowBox[{5, 3}], ArrowBox[{6, 4}], 
        ArrowBox[{8, 4}]}, {InsetBox[
         FrameBox["1",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 1], InsetBox[
         FrameBox["4",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 2], InsetBox[
         FrameBox["6",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 3], InsetBox[
         FrameBox["8",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 4], InsetBox[
         FrameBox["2",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 5], InsetBox[
         FrameBox["3",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 6], InsetBox[
         FrameBox["5",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 7], InsetBox[
         FrameBox["7",
          Background->RGBColor[1, 1, 0.8],
          FrameStyle->RGBColor[0.94, 0.85, 0.36],
          StripOnInput->False], 8]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 2.}, {0., 1.}, {-1., 1.}, {1., 1.}, {-1.,
        2.}, {1., 2.}, {0., 0.}, {2., 2.}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotLabel->FormBox["LayeredGraphPlot", TraditionalForm],
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{390, 168},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1153758716]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1170669461],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 " for general undirected graph drawing:"
}], "ExampleText",
 CellID->1408649024],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "6"}], ",", 
     RowBox[{"1", "\[Rule]", "20"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "17"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "12"}], ",", 
     RowBox[{"4", "\[Rule]", "5"}], ",", 
     RowBox[{"4", "\[Rule]", "15"}], ",", 
     RowBox[{"5", "\[Rule]", "6"}], ",", 
     RowBox[{"5", "\[Rule]", "10"}], ",", 
     RowBox[{"6", "\[Rule]", "7"}], ",", 
     RowBox[{"7", "\[Rule]", "8"}], ",", 
     RowBox[{"7", "\[Rule]", "16"}], ",", 
     RowBox[{"8", "\[Rule]", "9"}], ",", 
     RowBox[{"8", "\[Rule]", "19"}], ",", 
     RowBox[{"9", "\[Rule]", "10"}], ",", 
     RowBox[{"9", "\[Rule]", "14"}], ",", 
     RowBox[{"10", "\[Rule]", "11"}], ",", 
     RowBox[{"11", "\[Rule]", "12"}], ",", 
     RowBox[{"11", "\[Rule]", "20"}], ",", 
     RowBox[{"12", "\[Rule]", "13"}], ",", 
     RowBox[{"13", "\[Rule]", "14"}], ",", 
     RowBox[{"13", "\[Rule]", "18"}], ",", 
     RowBox[{"14", "\[Rule]", "15"}], ",", 
     RowBox[{"15", "\[Rule]", "16"}], ",", 
     RowBox[{"16", "\[Rule]", "17"}], ",", 
     RowBox[{"17", "\[Rule]", "18"}], ",", 
     RowBox[{"18", "\[Rule]", "19"}], ",", 
     RowBox[{"19", "\[Rule]", "20"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219311158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"GraphPlot", "[", "g", "]"}], ",", 
   RowBox[{"GraphPlot3D", "[", "g", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1935028127],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0., 1.5092286568176039`}, {0.5707039925928266, 
      0.7948833216096945}, {0.570087555488515, 2.2230257303960657`}, {
      0.715967906345673, 1.5101158563601127`}, {1.3256466363227133`, 
      0.0003968020511597725}, {1.3268041766078964`, 1.7134425716242836`}, {
      2.0124707572257083`, 0.649313821184241}, {2.1542681783776865`, 0.}, {
      1.317220310866213, 1.3008998117330444`}, {2.7673667336470724`, 
      1.50377719951935}, {2.156987411142495, 1.3004913768422397`}, {
      1.3298764916862307`, 3.013587999786182}, {2.158430377170293, 
      3.013278774565787}, {2.0189208820395788`, 2.363593163715019}, {
      2.9131803253283746`, 2.218382172519465}, {1.4710539104595433`, 
      2.364890112381402}, {3.4832874250506456`, 1.5037576732825495`}, {
      1.4649096931227734`, 0.6506387181266067}, {2.91353923272862, 
      0.7915185640706556}, {2.1656267491942875`, 1.7136561271663373`}}, {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {3, 12}, {5, 7}, {5, 
         8}, {6, 20}, {7, 9}, {7, 10}, {8, 19}, {9, 3}, {9, 11}, {10, 14}, {
         11, 18}, {12, 13}, {12, 14}, {13, 15}, {13, 16}, {14, 6}, {15, 11}, {
         15, 17}, {16, 4}, {17, 10}, {18, 8}, {18, 4}, {19, 17}, {19, 20}, {
         20, 16}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[PointBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[3],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[4],
          "20"],
         Annotation[#, 20, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[5],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[6],
          "17"],
         Annotation[#, 17, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[7],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[8],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[9],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[10],
          "15"],
         Annotation[#, 15, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[11],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[12],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[13],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[14],
          "16"],
         Annotation[#, 16, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[15],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[16],
          "19"],
         Annotation[#, 19, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[17],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[18],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[19],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[PointBox[20],
          "18"],
         Annotation[#, 18, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0., 1.5092286568176039`}, {
       0.5707039925928266, 0.7948833216096945}, {0.570087555488515, 
       2.2230257303960657`}, {0.715967906345673, 1.5101158563601127`}, {
       1.3256466363227133`, 0.0003968020511597725}, {1.3268041766078964`, 
       1.7134425716242836`}, {2.0124707572257083`, 0.649313821184241}, {
       2.1542681783776865`, 0.}, {1.317220310866213, 1.3008998117330444`}, {
       2.7673667336470724`, 1.50377719951935}, {2.156987411142495, 
       1.3004913768422397`}, {1.3298764916862307`, 3.013587999786182}, {
       2.158430377170293, 3.013278774565787}, {2.0189208820395788`, 
       2.363593163715019}, {2.9131803253283746`, 2.218382172519465}, {
       1.4710539104595433`, 2.364890112381402}, {3.4832874250506456`, 
       1.5037576732825495`}, {1.4649096931227734`, 0.6506387181266067}, {
       2.91353923272862, 0.7915185640706556}, {2.1656267491942875`, 
       1.7136561271663373`}}]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   Graphics3DBox[
    TagBox[
     GraphicsComplex3DBox[{{1.118932418206827, 0.8614302643777074, 0.}, {
      1.2814051849698087`, 0.9564592510505616, 1.048741645084963}, {
      2.0014647442140188`, 0.8661455296891518, 0.05810526248140002}, {
      0.09439427755448815, 0.863926662718518, 0.03810672446040764}, {
      1.1149246705226328`, 1.9111826126753007`, 1.4902134912823035`}, {
      1.1153203364134634`, 0.09536084969694925, 1.6539472256525416`}, {
      1.9977642627255352`, 1.8587827550864127`, 1.4677969757151699`}, {
      0.09091614877600673, 1.8739446167829552`, 1.4709856545168347`}, {
      1.9105690803331907`, 1.7834384807872268`, 0.4663446950583586}, {
      1.9067116110442013`, 1.046213653789434, 2.057155809555155}, {
      0.8870163642106299, 1.8161307480763926`, 0.44053341978562255`}, {
      1.9100662154614163`, 0.036239322203641566`, 0.6233297089631952}, {
      0.885812869306081, 0., 0.6045561286958885}, {1.9984650113905633`, 
      0.14159245861518754`, 1.6219307272298191`}, {0.7199767897359262, 
      0.9554049272869732, 1.0452198797768009`}, {0.0032569172979363126`, 
      0.05177078200422347, 0.6278777332918799}, {0.8828287774210202, 
      1.0497397414724376`, 2.0947242724140147`}, {0.0034527989948853754`, 
      1.7688609578030023`, 0.4718824350898466}, {0., 1.0448427458263845`, 
      2.036310839181915}, {0.09152513835519915, 0.12788227463465107`, 
      1.6289154686138854`}}, {
       {RGBColor[0.5, 0., 0.], 
        Line3DBox[{{1, 2}, {1, 3}, {1, 4}, {2, 5}, {2, 6}, {3, 12}, {5, 7}, {
         5, 8}, {6, 20}, {7, 9}, {7, 10}, {8, 19}, {9, 3}, {9, 11}, {10, 
         14}, {11, 18}, {12, 13}, {12, 14}, {13, 15}, {13, 16}, {14, 6}, {15, 
         11}, {15, 17}, {16, 4}, {17, 10}, {18, 8}, {18, 4}, {19, 17}, {19, 
         20}, {20, 16}}]}, 
       {RGBColor[0, 0, 0.7], 
        TagBox[
         TooltipBox[Point3DBox[1],
          "1"],
         Annotation[#, 1, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[2],
          "2"],
         Annotation[#, 2, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[3],
          "6"],
         Annotation[#, 6, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[4],
          "20"],
         Annotation[#, 20, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[5],
          "3"],
         Annotation[#, 3, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[6],
          "17"],
         Annotation[#, 17, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[7],
          "4"],
         Annotation[#, 4, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[8],
          "12"],
         Annotation[#, 12, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[9],
          "5"],
         Annotation[#, 5, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[10],
          "15"],
         Annotation[#, 15, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[11],
          "10"],
         Annotation[#, 10, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[12],
          "7"],
         Annotation[#, 7, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[13],
          "8"],
         Annotation[#, 8, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[14],
          "16"],
         Annotation[#, 16, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[15],
          "9"],
         Annotation[#, 9, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[16],
          "19"],
         Annotation[#, 19, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[17],
          "14"],
         Annotation[#, 14, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[18],
          "11"],
         Annotation[#, 11, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[19],
          "13"],
         Annotation[#, 13, "Tooltip"]& ], 
        TagBox[
         TooltipBox[Point3DBox[20],
          "18"],
         Annotation[#, 18, "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{1.118932418206827, 0.8614302643777074, 0.}, {
       1.2814051849698087`, 0.9564592510505616, 1.048741645084963}, {
       2.0014647442140188`, 0.8661455296891518, 0.05810526248140002}, {
       0.09439427755448815, 0.863926662718518, 0.03810672446040764}, {
       1.1149246705226328`, 1.9111826126753007`, 1.4902134912823035`}, {
       1.1153203364134634`, 0.09536084969694925, 1.6539472256525416`}, {
       1.9977642627255352`, 1.8587827550864127`, 1.4677969757151699`}, {
       0.09091614877600673, 1.8739446167829552`, 1.4709856545168347`}, {
       1.9105690803331907`, 1.7834384807872268`, 0.4663446950583586}, {
       1.9067116110442013`, 1.046213653789434, 2.057155809555155}, {
       0.8870163642106299, 1.8161307480763926`, 0.44053341978562255`}, {
       1.9100662154614163`, 0.036239322203641566`, 0.6233297089631952}, {
       0.885812869306081, 0., 0.6045561286958885}, {1.9984650113905633`, 
       0.14159245861518754`, 1.6219307272298191`}, {0.7199767897359262, 
       0.9554049272869732, 1.0452198797768009`}, {0.0032569172979363126`, 
       0.05177078200422347, 0.6278777332918799}, {0.8828287774210202, 
       1.0497397414724376`, 2.0947242724140147`}, {0.0034527989948853754`, 
       1.7688609578030023`, 0.4718824350898466}, {0., 1.0448427458263845`, 
       2.036310839181915}, {0.09152513835519915, 0.12788227463465107`, 
       1.6289154686138854`}}]& ],
    AspectRatio->Automatic,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{390, 202},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1897544943]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->781685086],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " to display sparse matrices:"
}], "ExampleText",
 CellID->1865416085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"g", "=", 
  RowBox[{"ExampleData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Matrix\>\"", ",", "\"\<Bai/bfwa62\>\""}], "}"}], ",", 
    "\"\<Matrix\>\""}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1254585860],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "450", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 450, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"62", ",", "62"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1792143536]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ArrayPlot", "[", "g", "]"}], ",", 
   RowBox[{"MatrixPlot", "[", "g", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1133133760],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 186},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->141903805]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["For non-tree graphs, edges may overlap:", "ExampleText",
 CellID->259535291],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->500618139],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.7385489458759964, 0.7385489458759964}, {0., 
    0.}, {0.7385489458759964, 0.}, {1.4770978917519928`, 0.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {2, 3}, {2, 4}, {3, 4}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.7385489458759964, 0.7385489458759964}, {0., 
     0.}, {0.7385489458759964, 0.}, {1.4770978917519928`, 0.}}]& ],
  AspectRatio->0.7071067811865476,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{104, 76},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->516362428]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " avoid overlapping edges:"
}], "ExampleText",
 CellID->56994867],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->175008072],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->192399764]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}], ",", 
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->227487619],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.8648503539108852}, {0.8668518684273616, 
    0.8781026529327044}, {0.01386443746610222, 0.}, {0.8801907641202376, 
    0.012435009015255905`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {1, 4}, {2, 3}, {2, 4}, {3, 4}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.8648503539108852}, {0.8668518684273616, 
     0.8781026529327044}, {0.01386443746610222, 0.}, {0.8801907641202376, 
     0.012435009015255905`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->903351210]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2085888102],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 " automatically chooses the base node to minimize tree height: "
}], "ExampleText",
 CellID->216671225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1351880948],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 0.}, {0.4472135954999579, 
    0.8944271909999159}, {0.8944271909999159, 0.}}, {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.04266728990926259, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{2, 3}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 0.}, {0.4472135954999579, 
     0.8944271909999159}, {0.8944271909999159, 0.}}]& ],
  AspectRatio->1.,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->2055512166]
}, Open  ]],

Cell["\<\
Explicitly specify a top node, in case this is also the root node: \
\>", "ExampleText",
 CellID->266469226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}]}], "}"}], ",", "Top", ",", "1", ",", 
   RowBox[{"DirectedEdges", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->44242984],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwpICwBAOQ/R/IAuOU
//+BNITUApHMnx/WfnncCkQM3CACxP8PBgyaSKo+3Iz5/XUDEDFwgwgQH7uq
///PABEDN4gYhKqYgAQzMCDYiFLNClYFCjcIn5mGukCqmIh2GQuaHSw0dBlp
YUa3OL0V/+VxBRCB0m0FmI9F1Z/vW1DSLZCPosoQSDLtr683xMFjYN5dXr41
OxvENEASXR0evtjdHV10hoHBFA0NVFGmtdHRuEwfXjxIiH+8lQCMMCBi4AYR
IP7gSC9klBQswFTPSnTuheUsBqJ10TMXk5/3GVgQukgJD+JLs8GVBj7dTUdJ
wUA+iirCZQaQu7e6+j9a6bA9P399fDy6KLAYmW9vjy46y8Rkmo4Oquhgyee0
Kzu+v1rx/c1aIGJgARJM19fksoI4IHHssfn9zRQgYuAGEYMm/ZCqihlav9Ky
zBiuugZtOUNEyvz+agKKKiAfRRWklc7ACADNhUcj\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->145352398]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell["Complete binary trees with random layer layout sizes:", "ExampleText",
 CellID->109185977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"TreePlot", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i", "\[Rule]", " ", 
          RowBox[{
           RowBox[{"2", "i"}], "+", "j", "-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{
           RowBox[{"2", "^", "7"}], "-", "1"}]}], "}"}]}], "]"}], "]"}], ",", 
     "Center", ",", 
     RowBox[{"LayerSizeFunction", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"RandomReal", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "4"}], ",", "4"}], "}"}], "]"}], "&"}], ")"}]}]}], 
    "]"}], ",", 
   RowBox[{"{", "6", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->577069777],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[GraphicsComplexBox[CompressedData["
1:eJw9lQs4lHkbxienSoUxM5LYTVql0sEmZeP9R4WUZLVKxC6mVnKINoeUIsdU
DjmMwzjkkKI+W1FJmVYHX2SdIockO58kWuQ8bHO/e32uyzXXzDv/93nv+3c/
96j/4mHlIsFgMGa+/otfhbMd3H8eliXhdxzxmva8kkF5iqiQYy54r3oy4IBS
O4PYy+VsbTqvSB5d0S7am8QiMdttcH2jLR+fs1y98b1frFvGkl7LktZ5Jeo/
LJ9HYoroz7uUzuBV5sacB2EVsqR+Xiu+V53X/V6LOY8stpbF54+X5uF+w3r0
fTvd7+A+meZCfE+4QPZwnUCa8C3els6dZJHNAvp+v4XS14+nzzOxTpuhluWP
Vx4tYZJ0itF06K9Jimcgh3MrtennO3KCntexo8ryo58EqTRUxLmu06/1xxQV
iDpvFs75GdHzp2vf4NyTQJ7d/AUssqXmBc45jNHPUcimz1EjtJ6LvXdxrlx2
Cs+xJ5g+N7HzjbsFkSDd8F2FTL+tw32Ernxcz6+S8JksG6GyfL5zj9+9iNgl
thQK/YRU4omW/PdVSuSq0Rw8VxuvA/OCpvRT64qfUgKjOb+KeCzC+Pdv06p3
mKMbOb1DrKvn9ybM2Z9wUbLW7Q01a7s85ii4MpVGcz5TqTf6MSdPmgGfCtIX
YE5xgjXnsouIYuQFYE7dzb6N+g3M/8/J8BqCvmMZ9JziygMxS7dziO9YMOZY
GGQkLftOmXyOnI85bSOt8Et3/QxXPEdU599SZahCGpUtMIfOoQqx+dSLOZ2z
M+GLuS49p+NbLfhSbr0fc5KrOuDLDlM+5miGvYMvp3a3YU51jRx82RlAz8kP
jtW3kpYm7nJ7cr5/s5BsmgzA3IOxZ3HdPPQ/EfYmEmSZZ8CTjIMLSVeSMmlx
mqHu2rLqPhQpkaofdaDDUr4A826lMTKWZE1Q6YW59rqvOWT7bX3BM4cRSu7S
3dvHm9lkiaAfPthJcvG8Cc9FzsW3Bqkm08dhJiUskiQYW661a4CqibyiO+Gr
CF83vek1UDs/Af2e6p5Xt6X2Us4sW60DGkyS2n/W1P3PHoq3Pgk61j3IThFz
SVsbAR2+T1RtpJ/2Ue6SJdBhV6rt1cH5mxpYoAEdbqoZ4Bz+wQA6+s6+Nbrl
M0w5uslCR58WX3jfY4zyLjeGDhuLDm9xTpT12VJiHRMXTvIOD09Rt4ekXcQ6
AkYve9WMMEit9uwVYh0pQZXInVhHrsawwckbsyMVsiRJfuAp6BBUMveWeikQ
H2YIdISpTh4R8+n8Iwk6jE6cu1ZcyyQ9z2kdVdb7vjm6+Guuy1ZDR9m+GvA2
9UmCjme5B3e0mLPJY147dDgFVwd62HFImGcqdBxRUUNeYiOboaNBW61xg6kS
KVHzgQ6uxCGzNtmFpHz4InRMTh9A/tInK6BjF+9VS3PG1xx4SEOHqJ/OzbFU
BehgmoQgN6zAcegoWxyI3OxzPgsdWZUc5Ga5izV0zEktQm761aqhI/f5NeSm
rNMWOipN7iM3fv0voeONpBtyE+6pCh2fI/5Abm7UqkJH+BYecsPvsoeOTf6z
9MS5Gf9XR9diB+SGW0brEJzb7225QYb02HKm3+5XIpv3LYSu62P1uG4SdyXz
iJQ0CQ6eOpa5Uon4WOvv92qVJPy1D4f1Bzmks5QPn1YUOGHeT07PiirvS5Bh
n/7A/pscIutwTbYkexZJ47aHznXmkI0lsfD55JxleF6nLZ3xUYkMovDz5JNu
OQ5RWBjjN75mhhJcXnfv/S02qThVAm71Po3Qv/J0eNxRMxHV3hm13WcnmyQb
d0xcDZqkVm9rXirXxiKCqGFwb452hn/PsgYuPWgap3o8Cg/ocFnEvWLrkszd
Y1R4Ar/A9YMiGVSikKOGeQ7gsSaucIn6/0Yoz8OGn0y5isSfax/fcfUL1XuW
78Jt/5rDMD3ksK7uAngWVchrWIUPUx4JPzCd9jDJ09FWx+exQxQjYeBjd5kC
sTSIR65t01SRj/5pfzPHykHq9Okp7URNBWKov6JC2n2QUkm1B4cbkQewF/Kf
VMEhdWnULMbyIaqKxwOHgpkwYfKcYUp3BwUOzwda0BdtSjngMO0vqPgv8wsV
+sNLcCg3lUl32DpCjSwqAoelEb3oG9n2VHAIHo2+NnhllPJt6gaHkcbShpEF
49QjCR44ZI9pYO8FfY/BoVfPPPt23gT1WiUGHDKtFq3Z/fMUpRwlBIcFtUK+
uDdOa4nA4fzeP6zKNk1TzpdGwSHzTmDYJw6DVO42A4eH66cocQ+1vdgBDlv+
piTWq84i3Pu3wUE/LZA5oi1BVJY5g4OpaRZ67MLANnB4uH/7/SkzSfKUqQQO
g1vbpcbdpUhb0ztw4J47h14MD+ODg4b9k6D4FGmi7BoEDul3Dv16/LY8CX2s
BQ7K3nuwHyEptnTPdl9W0z6uQIq/vwAO0cmGgnwZJtmYHg4OiwOisG9JfzeD
w/VVYwnTCUyiU0BzUDaf/eH8UkXy03yaQ+3wXexrKPsDOBDRx+yUfEVy/Uea
w+fxUfnsFSxy+FUJONh+U4T9l8pRB4drJv4RMlkscrfeDBy6GTlrN7HZxDFh
ITiUGfPRH4Ml78Ehqskxsvg0m2gYC8BB4swuzfFONokMPwUO+5UWoI+MvMfA
QePhes1kfQ6JyzQEh0Wi7S+0ojjEb80pcMhy/Q195qqZAQ6Kacl/7arjkPga
Y3CQfa750015JcLKaAUHy4Pm6Mff1waBgx6ZOTjXWImczKsAh4b3dO9cGrUD
hymqEb1Ta20BDjbOIvSOsRzNwYZbjt6xrDEAh0UlLuidCr9IcFg9M4De0Ts2
Cg7RW9+id4xSZMDhQrUmemdKmeZwOUKE3mmxpzlYS36P3sl1oznovGtG70x5
FIJDQfJF9M6SGj9wkKJa0Ts5qVfBITH6CHqn/0U6ONjl30LvyETQHOpnZ6N3
os1oDgfDndA7hq/ng0PCfCP0zmgGzeHGvmz0zo+TNIdtv8egdyyO0hxs4ij0
TtFdmsOxu0PoHaGI5jD3mTp6p4BPc8gqY6wR945cHM1hZ28tOAgLJOzE79vP
9IJb1pOVOD+tZwWuPd+l4/4P5CKRgzY5czzPb0Jz5KTDSg/Pm7gkArlaGWcF
fcZjLcidpNNh6G+4pY2ciqavw69q3UPIse6ts/DTxr4KuTesnIH/b4fSsBc6
GsPgcziPjT369ok8eK5Z9Qp71tXHSBTzjhyMxV4W8kyQD0fzeOzt+8U85Efn
4lrs+ctAL+TN8dFx9IDeZCN8ON3zJ3pj+tQAfHDvl0SveKrZwAfF9j3oobLm
i/DB2ykdPcWNsYQP34rWoddG8qPhg799O3pP72EXfMiPrUJPXtfYCB+u+nqj
R6MtufDhTKM/etdbpQ4+pEQ2oJc3WOTAB6FWGnrchrcYPqjfu4+e9y9uhA9f
jLXxuxAimwwfXq4Kx+9G7edk+NBXvxO/M8fLN8AH37VD+B0SyPrAB39fIfLT
/6gOPqjc1kG+uq2l4MOK7gTkcaqR9uHQwo3Ia/VgGnxoT01Evi2W0z4wGnOQ
/xPL2+DDR/k/sS/3Zr2AD/dUzmOf4mO94EMutRL7x83whQ/cqC/Yz2rzeviw
SbEZ+7ytKgU+sPM+YN/XbbkHH3r6StEP3oWr4MPIqzH0R+SZUPjQulkRfdPA
MYMPMw6SyH2u9SB8uPlqFXJ/Oe8v+FAcykfupQfWw4eail3I/cvVtA+MfZuR
+zAPXfiw8p01cm8hQ/uwbvxX5N55L+3DgZYi5P51Ri18cKsKQe4LKkLgQ6mK
pII494xpLfgw/+Yocu/5C+3DliAWcq8mSfvQ0yiF3HcV0z7IF5gj95Hse/Ch
2zwduddnj8MHa5Y/cu+WQvvwD678N7s=
      "], {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 7}, {3, 6}, {3, 13}, {4, 5}, {4, 
         10}, {5, 9}, {5, 19}, {6, 12}, {6, 25}, {7, 8}, {7, 16}, {8, 15}, {8,
          31}, {9, 18}, {9, 37}, {10, 11}, {10, 22}, {11, 21}, {11, 43}, {12, 
         24}, {12, 49}, {13, 14}, {13, 28}, {14, 27}, {14, 55}, {15, 30}, {15,
          61}, {16, 17}, {16, 34}, {17, 33}, {17, 67}, {18, 36}, {18, 73}, {
         19, 20}, {19, 40}, {20, 39}, {20, 79}, {21, 42}, {21, 85}, {22, 
         23}, {22, 46}, {23, 45}, {23, 91}, {24, 48}, {24, 97}, {25, 26}, {25,
          52}, {26, 51}, {26, 103}, {27, 54}, {27, 109}, {28, 29}, {28, 58}, {
         29, 57}, {29, 115}, {30, 60}, {30, 121}, {31, 32}, {31, 64}, {32, 
         63}, {32, 127}, {33, 66}, {33, 133}, {34, 35}, {34, 70}, {35, 69}, {
         35, 139}, {36, 72}, {36, 145}, {37, 38}, {37, 76}, {38, 75}, {38, 
         151}, {39, 78}, {39, 157}, {40, 41}, {40, 82}, {41, 81}, {41, 163}, {
         42, 84}, {42, 169}, {43, 44}, {43, 88}, {44, 87}, {44, 175}, {45, 
         90}, {45, 181}, {46, 47}, {46, 94}, {47, 93}, {47, 187}, {48, 96}, {
         48, 192}, {49, 50}, {49, 100}, {50, 99}, {50, 194}, {51, 102}, {51, 
         196}, {52, 53}, {52, 106}, {53, 105}, {53, 198}, {54, 108}, {54, 
         200}, {55, 56}, {55, 112}, {56, 111}, {56, 202}, {57, 114}, {57, 
         204}, {58, 59}, {58, 118}, {59, 117}, {59, 206}, {60, 120}, {60, 
         208}, {61, 62}, {61, 124}, {62, 123}, {62, 210}, {63, 126}, {63, 
         212}, {64, 65}, {64, 130}, {65, 129}, {65, 214}, {66, 132}, {66, 
         216}, {67, 68}, {67, 136}, {68, 135}, {68, 218}, {69, 138}, {69, 
         220}, {70, 71}, {70, 142}, {71, 141}, {71, 222}, {72, 144}, {72, 
         224}, {73, 74}, {73, 148}, {74, 147}, {74, 226}, {75, 150}, {75, 
         228}, {76, 77}, {76, 154}, {77, 153}, {77, 230}, {78, 156}, {78, 
         232}, {79, 80}, {79, 160}, {80, 159}, {80, 234}, {81, 162}, {81, 
         236}, {82, 83}, {82, 166}, {83, 165}, {83, 238}, {84, 168}, {84, 
         240}, {85, 86}, {85, 172}, {86, 171}, {86, 242}, {87, 174}, {87, 
         244}, {88, 89}, {88, 178}, {89, 177}, {89, 246}, {90, 180}, {90, 
         248}, {91, 92}, {91, 184}, {92, 183}, {92, 250}, {93, 186}, {93, 
         252}, {94, 95}, {94, 190}, {95, 189}, {95, 254}, {97, 98}, {97, 
         193}, {100, 101}, {100, 195}, {103, 104}, {103, 197}, {106, 107}, {
         106, 199}, {109, 110}, {109, 201}, {112, 113}, {112, 203}, {115, 
         116}, {115, 205}, {118, 119}, {118, 207}, {121, 122}, {121, 209}, {
         124, 125}, {124, 211}, {127, 128}, {127, 213}, {130, 131}, {130, 
         215}, {133, 134}, {133, 217}, {136, 137}, {136, 219}, {139, 140}, {
         139, 221}, {142, 143}, {142, 223}, {145, 146}, {145, 225}, {148, 
         149}, {148, 227}, {151, 152}, {151, 229}, {154, 155}, {154, 231}, {
         157, 158}, {157, 233}, {160, 161}, {160, 235}, {163, 164}, {163, 
         237}, {166, 167}, {166, 239}, {169, 170}, {169, 241}, {172, 173}, {
         172, 243}, {175, 176}, {175, 245}, {178, 179}, {178, 247}, {181, 
         182}, {181, 249}, {184, 185}, {184, 251}, {187, 188}, {187, 253}, {
         190, 191}, {190, 255}}]}, 
       {RGBColor[0, 0, 0.7], 
        PointBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
         35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
         52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
         69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
         86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
         102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115,
          116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 
         129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142,
          143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 
         156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169,
          170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 
         183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
          197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 
         210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
          224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 
         237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250,
          251, 252, 253, 254, 255}]}}],
     Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw9lQs4lHkbxienSoUxM5LYTVql0sEmZeP9R4WUZLVKxC6mVnKINoeUIsdU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       "]]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[GraphicsComplexBox[CompressedData["
1:eJw1lgk4lXkbxo9d1sM59qVCamRLwtcy7/9jKkplS5QlnOGMGoQW39jSMlqU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      "], {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 7}, {3, 6}, {3, 13}, {4, 5}, {4, 
         10}, {5, 9}, {5, 19}, {6, 12}, {6, 25}, {7, 8}, {7, 16}, {8, 15}, {8,
          31}, {9, 18}, {9, 37}, {10, 11}, {10, 22}, {11, 21}, {11, 43}, {12, 
         24}, {12, 49}, {13, 14}, {13, 28}, {14, 27}, {14, 55}, {15, 30}, {15,
          61}, {16, 17}, {16, 34}, {17, 33}, {17, 67}, {18, 36}, {18, 73}, {
         19, 20}, {19, 40}, {20, 39}, {20, 79}, {21, 42}, {21, 85}, {22, 
         23}, {22, 46}, {23, 45}, {23, 91}, {24, 48}, {24, 97}, {25, 26}, {25,
          52}, {26, 51}, {26, 103}, {27, 54}, {27, 109}, {28, 29}, {28, 58}, {
         29, 57}, {29, 115}, {30, 60}, {30, 121}, {31, 32}, {31, 64}, {32, 
         63}, {32, 127}, {33, 66}, {33, 133}, {34, 35}, {34, 70}, {35, 69}, {
         35, 139}, {36, 72}, {36, 145}, {37, 38}, {37, 76}, {38, 75}, {38, 
         151}, {39, 78}, {39, 157}, {40, 41}, {40, 82}, {41, 81}, {41, 163}, {
         42, 84}, {42, 169}, {43, 44}, {43, 88}, {44, 87}, {44, 175}, {45, 
         90}, {45, 181}, {46, 47}, {46, 94}, {47, 93}, {47, 187}, {48, 96}, {
         48, 192}, {49, 50}, {49, 100}, {50, 99}, {50, 194}, {51, 102}, {51, 
         196}, {52, 53}, {52, 106}, {53, 105}, {53, 198}, {54, 108}, {54, 
         200}, {55, 56}, {55, 112}, {56, 111}, {56, 202}, {57, 114}, {57, 
         204}, {58, 59}, {58, 118}, {59, 117}, {59, 206}, {60, 120}, {60, 
         208}, {61, 62}, {61, 124}, {62, 123}, {62, 210}, {63, 126}, {63, 
         212}, {64, 65}, {64, 130}, {65, 129}, {65, 214}, {66, 132}, {66, 
         216}, {67, 68}, {67, 136}, {68, 135}, {68, 218}, {69, 138}, {69, 
         220}, {70, 71}, {70, 142}, {71, 141}, {71, 222}, {72, 144}, {72, 
         224}, {73, 74}, {73, 148}, {74, 147}, {74, 226}, {75, 150}, {75, 
         228}, {76, 77}, {76, 154}, {77, 153}, {77, 230}, {78, 156}, {78, 
         232}, {79, 80}, {79, 160}, {80, 159}, {80, 234}, {81, 162}, {81, 
         236}, {82, 83}, {82, 166}, {83, 165}, {83, 238}, {84, 168}, {84, 
         240}, {85, 86}, {85, 172}, {86, 171}, {86, 242}, {87, 174}, {87, 
         244}, {88, 89}, {88, 178}, {89, 177}, {89, 246}, {90, 180}, {90, 
         248}, {91, 92}, {91, 184}, {92, 183}, {92, 250}, {93, 186}, {93, 
         252}, {94, 95}, {94, 190}, {95, 189}, {95, 254}, {97, 98}, {97, 
         193}, {100, 101}, {100, 195}, {103, 104}, {103, 197}, {106, 107}, {
         106, 199}, {109, 110}, {109, 201}, {112, 113}, {112, 203}, {115, 
         116}, {115, 205}, {118, 119}, {118, 207}, {121, 122}, {121, 209}, {
         124, 125}, {124, 211}, {127, 128}, {127, 213}, {130, 131}, {130, 
         215}, {133, 134}, {133, 217}, {136, 137}, {136, 219}, {139, 140}, {
         139, 221}, {142, 143}, {142, 223}, {145, 146}, {145, 225}, {148, 
         149}, {148, 227}, {151, 152}, {151, 229}, {154, 155}, {154, 231}, {
         157, 158}, {157, 233}, {160, 161}, {160, 235}, {163, 164}, {163, 
         237}, {166, 167}, {166, 239}, {169, 170}, {169, 241}, {172, 173}, {
         172, 243}, {175, 176}, {175, 245}, {178, 179}, {178, 247}, {181, 
         182}, {181, 249}, {184, 185}, {184, 251}, {187, 188}, {187, 253}, {
         190, 191}, {190, 255}}]}, 
       {RGBColor[0, 0, 0.7], 
        PointBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
         35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
         52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
         69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
         86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
         102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115,
          116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 
         129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142,
          143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 
         156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169,
          170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 
         183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
          197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 
         210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
          224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 
         237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250,
          251, 252, 253, 254, 255}]}}],
     Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw1lgk4lXkbxo9d1sM59qVCamRLwtcy7/9jKkplS5QlnOGMGoQW39jSMlqU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       "]]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[GraphicsComplexBox[CompressedData["
1:eJw1lQk4lXkbxg/T1DkpIVu27A6mCSkp03lUxlKfQacY2SoqmiwRRkRZRzKH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      "], {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 7}, {3, 6}, {3, 13}, {4, 5}, {4, 
         10}, {5, 9}, {5, 19}, {6, 12}, {6, 25}, {7, 8}, {7, 16}, {8, 15}, {8,
          31}, {9, 18}, {9, 37}, {10, 11}, {10, 22}, {11, 21}, {11, 43}, {12, 
         24}, {12, 49}, {13, 14}, {13, 28}, {14, 27}, {14, 55}, {15, 30}, {15,
          61}, {16, 17}, {16, 34}, {17, 33}, {17, 67}, {18, 36}, {18, 73}, {
         19, 20}, {19, 40}, {20, 39}, {20, 79}, {21, 42}, {21, 85}, {22, 
         23}, {22, 46}, {23, 45}, {23, 91}, {24, 48}, {24, 97}, {25, 26}, {25,
          52}, {26, 51}, {26, 103}, {27, 54}, {27, 109}, {28, 29}, {28, 58}, {
         29, 57}, {29, 115}, {30, 60}, {30, 121}, {31, 32}, {31, 64}, {32, 
         63}, {32, 127}, {33, 66}, {33, 133}, {34, 35}, {34, 70}, {35, 69}, {
         35, 139}, {36, 72}, {36, 145}, {37, 38}, {37, 76}, {38, 75}, {38, 
         151}, {39, 78}, {39, 157}, {40, 41}, {40, 82}, {41, 81}, {41, 163}, {
         42, 84}, {42, 169}, {43, 44}, {43, 88}, {44, 87}, {44, 175}, {45, 
         90}, {45, 181}, {46, 47}, {46, 94}, {47, 93}, {47, 187}, {48, 96}, {
         48, 192}, {49, 50}, {49, 100}, {50, 99}, {50, 194}, {51, 102}, {51, 
         196}, {52, 53}, {52, 106}, {53, 105}, {53, 198}, {54, 108}, {54, 
         200}, {55, 56}, {55, 112}, {56, 111}, {56, 202}, {57, 114}, {57, 
         204}, {58, 59}, {58, 118}, {59, 117}, {59, 206}, {60, 120}, {60, 
         208}, {61, 62}, {61, 124}, {62, 123}, {62, 210}, {63, 126}, {63, 
         212}, {64, 65}, {64, 130}, {65, 129}, {65, 214}, {66, 132}, {66, 
         216}, {67, 68}, {67, 136}, {68, 135}, {68, 218}, {69, 138}, {69, 
         220}, {70, 71}, {70, 142}, {71, 141}, {71, 222}, {72, 144}, {72, 
         224}, {73, 74}, {73, 148}, {74, 147}, {74, 226}, {75, 150}, {75, 
         228}, {76, 77}, {76, 154}, {77, 153}, {77, 230}, {78, 156}, {78, 
         232}, {79, 80}, {79, 160}, {80, 159}, {80, 234}, {81, 162}, {81, 
         236}, {82, 83}, {82, 166}, {83, 165}, {83, 238}, {84, 168}, {84, 
         240}, {85, 86}, {85, 172}, {86, 171}, {86, 242}, {87, 174}, {87, 
         244}, {88, 89}, {88, 178}, {89, 177}, {89, 246}, {90, 180}, {90, 
         248}, {91, 92}, {91, 184}, {92, 183}, {92, 250}, {93, 186}, {93, 
         252}, {94, 95}, {94, 190}, {95, 189}, {95, 254}, {97, 98}, {97, 
         193}, {100, 101}, {100, 195}, {103, 104}, {103, 197}, {106, 107}, {
         106, 199}, {109, 110}, {109, 201}, {112, 113}, {112, 203}, {115, 
         116}, {115, 205}, {118, 119}, {118, 207}, {121, 122}, {121, 209}, {
         124, 125}, {124, 211}, {127, 128}, {127, 213}, {130, 131}, {130, 
         215}, {133, 134}, {133, 217}, {136, 137}, {136, 219}, {139, 140}, {
         139, 221}, {142, 143}, {142, 223}, {145, 146}, {145, 225}, {148, 
         149}, {148, 227}, {151, 152}, {151, 229}, {154, 155}, {154, 231}, {
         157, 158}, {157, 233}, {160, 161}, {160, 235}, {163, 164}, {163, 
         237}, {166, 167}, {166, 239}, {169, 170}, {169, 241}, {172, 173}, {
         172, 243}, {175, 176}, {175, 245}, {178, 179}, {178, 247}, {181, 
         182}, {181, 249}, {184, 185}, {184, 251}, {187, 188}, {187, 253}, {
         190, 191}, {190, 255}}]}, 
       {RGBColor[0, 0, 0.7], 
        PointBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
         35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
         52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
         69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
         86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
         102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115,
          116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 
         129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142,
          143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 
         156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169,
          170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 
         183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
          197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 
         210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
          224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 
         237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250,
          251, 252, 253, 254, 255}]}}],
     Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw1lQk4lXkbxg/T1DkpIVu27A6mCSkp03lUxlKfQacY2SoqmiwRRkRZRzKH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       "]]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[GraphicsComplexBox[CompressedData["
1:eJw1lQk81PkfxhXZEmm7RDpEsSm2Ezk+KspGba4J2Wjk7rCV6BCd5FqFdpQc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      "], {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 7}, {3, 6}, {3, 13}, {4, 5}, {4, 
         10}, {5, 9}, {5, 19}, {6, 12}, {6, 25}, {7, 8}, {7, 16}, {8, 15}, {8,
          31}, {9, 18}, {9, 37}, {10, 11}, {10, 22}, {11, 21}, {11, 43}, {12, 
         24}, {12, 49}, {13, 14}, {13, 28}, {14, 27}, {14, 55}, {15, 30}, {15,
          61}, {16, 17}, {16, 34}, {17, 33}, {17, 67}, {18, 36}, {18, 73}, {
         19, 20}, {19, 40}, {20, 39}, {20, 79}, {21, 42}, {21, 85}, {22, 
         23}, {22, 46}, {23, 45}, {23, 91}, {24, 48}, {24, 97}, {25, 26}, {25,
          52}, {26, 51}, {26, 103}, {27, 54}, {27, 109}, {28, 29}, {28, 58}, {
         29, 57}, {29, 115}, {30, 60}, {30, 121}, {31, 32}, {31, 64}, {32, 
         63}, {32, 127}, {33, 66}, {33, 133}, {34, 35}, {34, 70}, {35, 69}, {
         35, 139}, {36, 72}, {36, 145}, {37, 38}, {37, 76}, {38, 75}, {38, 
         151}, {39, 78}, {39, 157}, {40, 41}, {40, 82}, {41, 81}, {41, 163}, {
         42, 84}, {42, 169}, {43, 44}, {43, 88}, {44, 87}, {44, 175}, {45, 
         90}, {45, 181}, {46, 47}, {46, 94}, {47, 93}, {47, 187}, {48, 96}, {
         48, 192}, {49, 50}, {49, 100}, {50, 99}, {50, 194}, {51, 102}, {51, 
         196}, {52, 53}, {52, 106}, {53, 105}, {53, 198}, {54, 108}, {54, 
         200}, {55, 56}, {55, 112}, {56, 111}, {56, 202}, {57, 114}, {57, 
         204}, {58, 59}, {58, 118}, {59, 117}, {59, 206}, {60, 120}, {60, 
         208}, {61, 62}, {61, 124}, {62, 123}, {62, 210}, {63, 126}, {63, 
         212}, {64, 65}, {64, 130}, {65, 129}, {65, 214}, {66, 132}, {66, 
         216}, {67, 68}, {67, 136}, {68, 135}, {68, 218}, {69, 138}, {69, 
         220}, {70, 71}, {70, 142}, {71, 141}, {71, 222}, {72, 144}, {72, 
         224}, {73, 74}, {73, 148}, {74, 147}, {74, 226}, {75, 150}, {75, 
         228}, {76, 77}, {76, 154}, {77, 153}, {77, 230}, {78, 156}, {78, 
         232}, {79, 80}, {79, 160}, {80, 159}, {80, 234}, {81, 162}, {81, 
         236}, {82, 83}, {82, 166}, {83, 165}, {83, 238}, {84, 168}, {84, 
         240}, {85, 86}, {85, 172}, {86, 171}, {86, 242}, {87, 174}, {87, 
         244}, {88, 89}, {88, 178}, {89, 177}, {89, 246}, {90, 180}, {90, 
         248}, {91, 92}, {91, 184}, {92, 183}, {92, 250}, {93, 186}, {93, 
         252}, {94, 95}, {94, 190}, {95, 189}, {95, 254}, {97, 98}, {97, 
         193}, {100, 101}, {100, 195}, {103, 104}, {103, 197}, {106, 107}, {
         106, 199}, {109, 110}, {109, 201}, {112, 113}, {112, 203}, {115, 
         116}, {115, 205}, {118, 119}, {118, 207}, {121, 122}, {121, 209}, {
         124, 125}, {124, 211}, {127, 128}, {127, 213}, {130, 131}, {130, 
         215}, {133, 134}, {133, 217}, {136, 137}, {136, 219}, {139, 140}, {
         139, 221}, {142, 143}, {142, 223}, {145, 146}, {145, 225}, {148, 
         149}, {148, 227}, {151, 152}, {151, 229}, {154, 155}, {154, 231}, {
         157, 158}, {157, 233}, {160, 161}, {160, 235}, {163, 164}, {163, 
         237}, {166, 167}, {166, 239}, {169, 170}, {169, 241}, {172, 173}, {
         172, 243}, {175, 176}, {175, 245}, {178, 179}, {178, 247}, {181, 
         182}, {181, 249}, {184, 185}, {184, 251}, {187, 188}, {187, 253}, {
         190, 191}, {190, 255}}]}, 
       {RGBColor[0, 0, 0.7], 
        PointBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
         35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
         52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
         69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
         86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
         102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115,
          116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 
         129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142,
          143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 
         156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169,
          170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 
         183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
          197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 
         210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
          224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 
         237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250,
          251, 252, 253, 254, 255}]}}],
     Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw1lQk81PkfxhXZEmm7RDpEsSm2Ezk+KspGba4J2Wjk7rCV6BCd5FqFdpQc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       "]]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[GraphicsComplexBox[CompressedData["
1:eJw1lgs4VPkfxic0LiFylzRRVpLcKlo5P7KZ0gVFwkZiF3+XCVtq3ULaFEqt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      "], {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 7}, {3, 6}, {3, 13}, {4, 5}, {4, 
         10}, {5, 9}, {5, 19}, {6, 12}, {6, 25}, {7, 8}, {7, 16}, {8, 15}, {8,
          31}, {9, 18}, {9, 37}, {10, 11}, {10, 22}, {11, 21}, {11, 43}, {12, 
         24}, {12, 49}, {13, 14}, {13, 28}, {14, 27}, {14, 55}, {15, 30}, {15,
          61}, {16, 17}, {16, 34}, {17, 33}, {17, 67}, {18, 36}, {18, 73}, {
         19, 20}, {19, 40}, {20, 39}, {20, 79}, {21, 42}, {21, 85}, {22, 
         23}, {22, 46}, {23, 45}, {23, 91}, {24, 48}, {24, 97}, {25, 26}, {25,
          52}, {26, 51}, {26, 103}, {27, 54}, {27, 109}, {28, 29}, {28, 58}, {
         29, 57}, {29, 115}, {30, 60}, {30, 121}, {31, 32}, {31, 64}, {32, 
         63}, {32, 127}, {33, 66}, {33, 133}, {34, 35}, {34, 70}, {35, 69}, {
         35, 139}, {36, 72}, {36, 145}, {37, 38}, {37, 76}, {38, 75}, {38, 
         151}, {39, 78}, {39, 157}, {40, 41}, {40, 82}, {41, 81}, {41, 163}, {
         42, 84}, {42, 169}, {43, 44}, {43, 88}, {44, 87}, {44, 175}, {45, 
         90}, {45, 181}, {46, 47}, {46, 94}, {47, 93}, {47, 187}, {48, 96}, {
         48, 192}, {49, 50}, {49, 100}, {50, 99}, {50, 194}, {51, 102}, {51, 
         196}, {52, 53}, {52, 106}, {53, 105}, {53, 198}, {54, 108}, {54, 
         200}, {55, 56}, {55, 112}, {56, 111}, {56, 202}, {57, 114}, {57, 
         204}, {58, 59}, {58, 118}, {59, 117}, {59, 206}, {60, 120}, {60, 
         208}, {61, 62}, {61, 124}, {62, 123}, {62, 210}, {63, 126}, {63, 
         212}, {64, 65}, {64, 130}, {65, 129}, {65, 214}, {66, 132}, {66, 
         216}, {67, 68}, {67, 136}, {68, 135}, {68, 218}, {69, 138}, {69, 
         220}, {70, 71}, {70, 142}, {71, 141}, {71, 222}, {72, 144}, {72, 
         224}, {73, 74}, {73, 148}, {74, 147}, {74, 226}, {75, 150}, {75, 
         228}, {76, 77}, {76, 154}, {77, 153}, {77, 230}, {78, 156}, {78, 
         232}, {79, 80}, {79, 160}, {80, 159}, {80, 234}, {81, 162}, {81, 
         236}, {82, 83}, {82, 166}, {83, 165}, {83, 238}, {84, 168}, {84, 
         240}, {85, 86}, {85, 172}, {86, 171}, {86, 242}, {87, 174}, {87, 
         244}, {88, 89}, {88, 178}, {89, 177}, {89, 246}, {90, 180}, {90, 
         248}, {91, 92}, {91, 184}, {92, 183}, {92, 250}, {93, 186}, {93, 
         252}, {94, 95}, {94, 190}, {95, 189}, {95, 254}, {97, 98}, {97, 
         193}, {100, 101}, {100, 195}, {103, 104}, {103, 197}, {106, 107}, {
         106, 199}, {109, 110}, {109, 201}, {112, 113}, {112, 203}, {115, 
         116}, {115, 205}, {118, 119}, {118, 207}, {121, 122}, {121, 209}, {
         124, 125}, {124, 211}, {127, 128}, {127, 213}, {130, 131}, {130, 
         215}, {133, 134}, {133, 217}, {136, 137}, {136, 219}, {139, 140}, {
         139, 221}, {142, 143}, {142, 223}, {145, 146}, {145, 225}, {148, 
         149}, {148, 227}, {151, 152}, {151, 229}, {154, 155}, {154, 231}, {
         157, 158}, {157, 233}, {160, 161}, {160, 235}, {163, 164}, {163, 
         237}, {166, 167}, {166, 239}, {169, 170}, {169, 241}, {172, 173}, {
         172, 243}, {175, 176}, {175, 245}, {178, 179}, {178, 247}, {181, 
         182}, {181, 249}, {184, 185}, {184, 251}, {187, 188}, {187, 253}, {
         190, 191}, {190, 255}}]}, 
       {RGBColor[0, 0, 0.7], 
        PointBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
         35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
         52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
         69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
         86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
         102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115,
          116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 
         129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142,
          143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 
         156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169,
          170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 
         183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
          197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 
         210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
          224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 
         237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250,
          251, 252, 253, 254, 255}]}}],
     Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw1lgs4VPkfxic0LiFylzRRVpLcKlo5P7KZ0gVFwkZiF3+XCVtq3ULaFEqt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       "]]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[GraphicsComplexBox[CompressedData["
1:eJw9lgs4lHkbxidbTsn5TAypdGI6Kqn3j1hUUsk56WAWpZA2zaJBlNYiFLnC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      "], {
       {RGBColor[0.5, 0., 0.], 
        LineBox[{{1, 2}, {1, 4}, {2, 3}, {2, 7}, {3, 6}, {3, 13}, {4, 5}, {4, 
         10}, {5, 9}, {5, 19}, {6, 12}, {6, 25}, {7, 8}, {7, 16}, {8, 15}, {8,
          31}, {9, 18}, {9, 37}, {10, 11}, {10, 22}, {11, 21}, {11, 43}, {12, 
         24}, {12, 49}, {13, 14}, {13, 28}, {14, 27}, {14, 55}, {15, 30}, {15,
          61}, {16, 17}, {16, 34}, {17, 33}, {17, 67}, {18, 36}, {18, 73}, {
         19, 20}, {19, 40}, {20, 39}, {20, 79}, {21, 42}, {21, 85}, {22, 
         23}, {22, 46}, {23, 45}, {23, 91}, {24, 48}, {24, 97}, {25, 26}, {25,
          52}, {26, 51}, {26, 103}, {27, 54}, {27, 109}, {28, 29}, {28, 58}, {
         29, 57}, {29, 115}, {30, 60}, {30, 121}, {31, 32}, {31, 64}, {32, 
         63}, {32, 127}, {33, 66}, {33, 133}, {34, 35}, {34, 70}, {35, 69}, {
         35, 139}, {36, 72}, {36, 145}, {37, 38}, {37, 76}, {38, 75}, {38, 
         151}, {39, 78}, {39, 157}, {40, 41}, {40, 82}, {41, 81}, {41, 163}, {
         42, 84}, {42, 169}, {43, 44}, {43, 88}, {44, 87}, {44, 175}, {45, 
         90}, {45, 181}, {46, 47}, {46, 94}, {47, 93}, {47, 187}, {48, 96}, {
         48, 192}, {49, 50}, {49, 100}, {50, 99}, {50, 194}, {51, 102}, {51, 
         196}, {52, 53}, {52, 106}, {53, 105}, {53, 198}, {54, 108}, {54, 
         200}, {55, 56}, {55, 112}, {56, 111}, {56, 202}, {57, 114}, {57, 
         204}, {58, 59}, {58, 118}, {59, 117}, {59, 206}, {60, 120}, {60, 
         208}, {61, 62}, {61, 124}, {62, 123}, {62, 210}, {63, 126}, {63, 
         212}, {64, 65}, {64, 130}, {65, 129}, {65, 214}, {66, 132}, {66, 
         216}, {67, 68}, {67, 136}, {68, 135}, {68, 218}, {69, 138}, {69, 
         220}, {70, 71}, {70, 142}, {71, 141}, {71, 222}, {72, 144}, {72, 
         224}, {73, 74}, {73, 148}, {74, 147}, {74, 226}, {75, 150}, {75, 
         228}, {76, 77}, {76, 154}, {77, 153}, {77, 230}, {78, 156}, {78, 
         232}, {79, 80}, {79, 160}, {80, 159}, {80, 234}, {81, 162}, {81, 
         236}, {82, 83}, {82, 166}, {83, 165}, {83, 238}, {84, 168}, {84, 
         240}, {85, 86}, {85, 172}, {86, 171}, {86, 242}, {87, 174}, {87, 
         244}, {88, 89}, {88, 178}, {89, 177}, {89, 246}, {90, 180}, {90, 
         248}, {91, 92}, {91, 184}, {92, 183}, {92, 250}, {93, 186}, {93, 
         252}, {94, 95}, {94, 190}, {95, 189}, {95, 254}, {97, 98}, {97, 
         193}, {100, 101}, {100, 195}, {103, 104}, {103, 197}, {106, 107}, {
         106, 199}, {109, 110}, {109, 201}, {112, 113}, {112, 203}, {115, 
         116}, {115, 205}, {118, 119}, {118, 207}, {121, 122}, {121, 209}, {
         124, 125}, {124, 211}, {127, 128}, {127, 213}, {130, 131}, {130, 
         215}, {133, 134}, {133, 217}, {136, 137}, {136, 219}, {139, 140}, {
         139, 221}, {142, 143}, {142, 223}, {145, 146}, {145, 225}, {148, 
         149}, {148, 227}, {151, 152}, {151, 229}, {154, 155}, {154, 231}, {
         157, 158}, {157, 233}, {160, 161}, {160, 235}, {163, 164}, {163, 
         237}, {166, 167}, {166, 239}, {169, 170}, {169, 241}, {172, 173}, {
         172, 243}, {175, 176}, {175, 245}, {178, 179}, {178, 247}, {181, 
         182}, {181, 249}, {184, 185}, {184, 251}, {187, 188}, {187, 253}, {
         190, 191}, {190, 255}}]}, 
       {RGBColor[0, 0, 0.7], 
        PointBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
         18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
         35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
         52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
         69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
         86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
         102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115,
          116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 
         129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142,
          143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 
         156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169,
          170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 
         183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196,
          197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 
         210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
          224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 
         237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250,
          251, 252, 253, 254, 255}]}}],
     Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJw9lgs4lHkbxidbTsn5TAypdGI6Kqn3j1hUUsk56WAWpZA2zaJBlNYiFLnC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       "]]& ],
    AspectRatio->Automatic,
    FrameTicks->None,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{491, 314},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->79242243]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LayeredGraphPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LayeredGraphPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TreeForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TreeForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Level",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Level"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 ButtonBox["Introduction to Graph Drawing in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GraphDrawingIntroduction"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GraphDrawingIntroduction"],
  FontSlant->"Italic"],
 ButtonBox[" ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GraphDrawingIntroduction"]
}], "Tutorials",
 CellID->25850],

Cell[TextData[ButtonBox["Tree Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TreeDrawing"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with TreePlot",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=TreePlot"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Computational Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalSystemsAndDiscovery"]], "MoreAbout",
 CellID->222591370],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->418779056],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->213997328],

Cell[TextData[ButtonBox["New in 6.0: Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataVisualization"]], "MoreAbout",
 CellID->433186417],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->434180968],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->38320871]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TreePlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 45.8653246}", "context" -> "System`", 
    "keywords" -> {
     "tree layout", "tree drawing", "graph drawing", "tree in graph", 
      "recursive drawing", "draw a forrest of trees", "spanning tree", 
      "genealogy tree", "family tree", "expression tree", "syntax tree", 
      "decision tree"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TreePlot[{v i1 -> v j1, v i2 -> v j2, ...}] generates a tree plot of the \
graph in which vertex v_ik is connected to vertex v_jk. TreePlot[{{v i1 -> v \
j1, lbl_1}, ...}] associates labels lbl_k with edges in the graph. \
TreePlot[g, pos] places roots of trees in the plot at position pos. \
TreePlot[g, pos, v_k] uses vertex v_k as the root node in the tree plot.", 
    "synonyms" -> {"tree plot"}, "title" -> "TreePlot", "type" -> "Symbol", 
    "uri" -> "ref/TreePlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[24626, 803, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->107655429]},
 "b:0.1"->{
  Cell[67813, 2056, 698, 22, 70, "Input",
   CellTags->"b:0.1",
   CellID->1209134277],
  Cell[68514, 2080, 16566, 429, 70, "Output",
   CellTags->"b:0.1",
   CellID->950036013]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 663496, 16848},
 {"b:0.1", 663629, 16852}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3148, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3771, 97, 1573, 37, 70, "ObjectNameGrid"],
Cell[5347, 136, 3610, 114, 70, "Usage",
 CellID->18997]
}, Open  ]],
Cell[CellGroupData[{
Cell[8994, 255, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9472, 272, 424, 14, 70, "Notes",
 CellID->362328099],
Cell[9899, 288, 356, 12, 70, "Notes",
 CellID->184029240],
Cell[10258, 302, 304, 10, 70, "Notes",
 CellID->229489000],
Cell[10565, 314, 1168, 46, 70, "Notes",
 CellID->443019707],
Cell[11736, 362, 321, 13, 70, "Notes",
 CellID->174694386],
Cell[12060, 377, 632, 23, 70, "Notes",
 CellID->69175411],
Cell[12695, 402, 362, 12, 70, "Notes",
 CellID->77467358],
Cell[13060, 416, 4359, 114, 70, "3ColumnTableMod",
 CellID->353462848],
Cell[17422, 532, 503, 17, 70, "Notes",
 CellID->16670666],
Cell[17928, 551, 778, 28, 70, "Notes",
 CellID->762729751],
Cell[18709, 581, 816, 28, 70, "Notes",
 CellID->442256812],
Cell[19528, 611, 859, 31, 70, "Notes",
 CellID->183388779],
Cell[20390, 644, 1550, 57, 70, "Notes",
 CellID->144575570],
Cell[21943, 703, 756, 23, 70, "Notes",
 CellID->100047542],
Cell[22702, 728, 266, 8, 70, "Notes",
 CellID->106749993],
Cell[22971, 738, 175, 4, 70, "Notes",
 CellID->70117131],
Cell[23149, 744, 437, 15, 70, "Notes",
 CellID->122404946],
Cell[23589, 761, 281, 11, 70, "Notes",
 CellID->3967714],
Cell[23873, 774, 716, 24, 70, "Notes",
 CellID->68183324]
}, Closed]],
Cell[CellGroupData[{
Cell[24626, 803, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->107655429],
Cell[CellGroupData[{
Cell[25011, 817, 146, 5, 70, "ExampleSection",
 CellID->6633876],
Cell[25160, 824, 56, 1, 70, "ExampleText",
 CellID->1489454305],
Cell[CellGroupData[{
Cell[25241, 829, 418, 12, 28, "Input",
 CellID->168190180],
Cell[25662, 843, 1181, 25, 111, "Output",
 CellID->19786609]
}, Open  ]],
Cell[26858, 871, 125, 3, 70, "ExampleDelimiter",
 CellID->940541746],
Cell[26986, 876, 68, 1, 70, "ExampleText",
 CellID->1978791016],
Cell[CellGroupData[{
Cell[27079, 881, 494, 14, 70, "Input",
 CellID->12016927],
Cell[27576, 897, 1885, 55, 70, "Output",
 CellID->414914585]
}, Open  ]],
Cell[29476, 955, 124, 3, 70, "ExampleDelimiter",
 CellID->32707144],
Cell[29603, 960, 65, 1, 70, "ExampleText",
 CellID->367941274],
Cell[CellGroupData[{
Cell[29693, 965, 496, 14, 28, "Input",
 CellID->738297439],
Cell[30192, 981, 2281, 41, 115, "Output",
 Evaluatable->False,
 CellID->217238232]
}, Open  ]],
Cell[32488, 1025, 125, 3, 70, "ExampleDelimiter",
 CellID->628343972],
Cell[32616, 1030, 60, 1, 70, "ExampleText",
 CellID->270550211],
Cell[CellGroupData[{
Cell[32701, 1035, 488, 14, 70, "Input",
 CellID->1965963005],
Cell[33192, 1051, 2240, 66, 70, "Output",
 CellID->1197661911]
}, Open  ]],
Cell[35447, 1120, 125, 3, 70, "ExampleDelimiter",
 CellID->184183475],
Cell[35575, 1125, 104, 2, 70, "ExampleText",
 CellID->388077390],
Cell[CellGroupData[{
Cell[35704, 1131, 530, 16, 70, "Input",
 CellID->404507675],
Cell[36237, 1149, 2377, 67, 70, "Output",
 CellID->239196217]
}, Open  ]],
Cell[38629, 1219, 125, 3, 70, "ExampleDelimiter",
 CellID->276082913],
Cell[38757, 1224, 66, 1, 70, "ExampleText",
 CellID->1645047370],
Cell[CellGroupData[{
Cell[38848, 1229, 716, 21, 70, "Input",
 CellID->807222073],
Cell[39567, 1252, 4582, 109, 239, "Output",
 CellID->197917692]
}, Open  ]],
Cell[44164, 1364, 125, 3, 70, "ExampleDelimiter",
 CellID->830148031],
Cell[44292, 1369, 136, 4, 70, "ExampleText",
 CellID->1258500244],
Cell[CellGroupData[{
Cell[44453, 1377, 419, 12, 70, "Input",
 CellID->1882563794],
Cell[44875, 1391, 4176, 87, 70, "Output",
 CellID->208227863]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49100, 1484, 222, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[CellGroupData[{
Cell[49347, 1495, 240, 7, 70, "ExampleSubsection",
 CellID->369255627],
Cell[49590, 1504, 79, 1, 70, "ExampleText",
 CellID->1096410170],
Cell[CellGroupData[{
Cell[49694, 1509, 374, 11, 70, "Input",
 CellID->430275],
Cell[50071, 1522, 1640, 50, 70, "Output",
 CellID->1691417158]
}, Open  ]],
Cell[51726, 1575, 124, 3, 70, "ExampleDelimiter",
 CellID->56963074],
Cell[51853, 1580, 91, 1, 70, "ExampleText",
 CellID->155380432],
Cell[CellGroupData[{
Cell[51969, 1585, 458, 14, 70, "Input",
 CellID->273676337],
Cell[52430, 1601, 1279, 34, 149, "Output",
 CellID->108931975]
}, Open  ]],
Cell[53724, 1638, 126, 3, 70, "ExampleDelimiter",
 CellID->1640804889],
Cell[53853, 1643, 93, 1, 70, "ExampleText",
 CellID->1544973088],
Cell[CellGroupData[{
Cell[53971, 1648, 483, 16, 70, "Input",
 CellID->1430216091],
Cell[54457, 1666, 1086, 35, 70, "Output",
 CellID->940482128]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[55592, 1707, 232, 7, 70, "ExampleSubsection",
 CellID->4212966],
Cell[55827, 1716, 70, 1, 70, "ExampleText",
 CellID->124062807],
Cell[CellGroupData[{
Cell[55922, 1721, 365, 11, 70, "Input",
 CellID->1524298092],
Cell[56290, 1734, 1717, 50, 70, "Output",
 CellID->1228283265]
}, Open  ]],
Cell[58022, 1787, 126, 3, 70, "ExampleDelimiter",
 CellID->1093274895],
Cell[58151, 1792, 62, 1, 70, "ExampleText",
 CellID->250888577],
Cell[CellGroupData[{
Cell[58238, 1797, 497, 14, 70, "Input",
 CellID->1908060239],
Cell[58738, 1813, 3653, 64, 70, "Output",
 Evaluatable->False,
 CellID->187916918]
}, Open  ]],
Cell[62406, 1880, 126, 3, 70, "ExampleDelimiter",
 CellID->1301177980],
Cell[62535, 1885, 80, 1, 70, "ExampleText",
 CellID->956609091],
Cell[CellGroupData[{
Cell[62640, 1890, 551, 15, 70, "Input",
 CellID->417724249],
Cell[63194, 1907, 1481, 46, 70, "Output",
 CellID->1790119196]
}, Open  ]],
Cell[64690, 1956, 125, 3, 70, "ExampleDelimiter",
 CellID->622455388],
Cell[64818, 1961, 64, 1, 70, "ExampleText",
 CellID->1768796684],
Cell[CellGroupData[{
Cell[64907, 1966, 607, 16, 70, "Input",
 CellID->1049937125],
Cell[65517, 1984, 2029, 58, 70, "Output",
 CellID->1177124423]
}, Open  ]],
Cell[67561, 2045, 125, 3, 70, "ExampleDelimiter",
 CellID->996109397],
Cell[67689, 2050, 99, 2, 70, "ExampleText",
 CellID->2995],
Cell[CellGroupData[{
Cell[67813, 2056, 698, 22, 70, "Input",
 CellTags->"b:0.1",
 CellID->1209134277],
Cell[68514, 2080, 16566, 429, 70, "Output",
 CellTags->"b:0.1",
 CellID->950036013]
}, Open  ]],
Cell[85095, 2512, 125, 3, 70, "ExampleDelimiter",
 CellID->739766316],
Cell[85223, 2517, 121, 3, 70, "ExampleText",
 CellID->1632065829],
Cell[CellGroupData[{
Cell[85369, 2524, 420, 13, 70, "Input",
 CellID->693558391],
Cell[85792, 2539, 11815, 198, 70, "Output",
 Evaluatable->False,
 CellID->238107355]
}, Open  ]],
Cell[97622, 2740, 126, 3, 70, "ExampleDelimiter",
 CellID->1529467861],
Cell[97751, 2745, 87, 1, 70, "ExampleText",
 CellID->1551442486],
Cell[CellGroupData[{
Cell[97863, 2750, 1096, 30, 70, "Input",
 CellID->1155268122],
Cell[98962, 2782, 15373, 404, 70, "Output",
 CellID->210182402]
}, Open  ]],
Cell[114350, 3189, 123, 3, 70, "ExampleDelimiter",
 CellID->8888429],
Cell[114476, 3194, 83, 1, 70, "ExampleText",
 CellID->455833000],
Cell[CellGroupData[{
Cell[114584, 3199, 418, 12, 70, "Input",
 CellID->119821187],
Cell[115005, 3213, 1935, 56, 70, "Output",
 CellID->252804765]
}, Open  ]],
Cell[116955, 3272, 1968, 57, 70, "Input",
 CellID->907421761]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[118972, 3335, 223, 7, 70, "ExampleSection",
 CellID->463608210],
Cell[CellGroupData[{
Cell[119220, 3346, 232, 7, 70, "ExampleSubsection",
 CellID->900310349],
Cell[119455, 3355, 128, 3, 70, "ExampleText",
 CellID->1707013097],
Cell[119586, 3360, 396, 13, 70, "Input",
 CellID->1173269234],
Cell[CellGroupData[{
Cell[120007, 3377, 105, 3, 70, "Input",
 CellID->2111380344],
Cell[120115, 3382, 10769, 293, 70, "Output",
 CellID->1325483815]
}, Open  ]],
Cell[130899, 3678, 125, 3, 70, "ExampleDelimiter",
 CellID->478547557],
Cell[131027, 3683, 147, 4, 70, "ExampleText",
 CellID->59975126],
Cell[CellGroupData[{
Cell[131199, 3691, 488, 14, 70, "Input",
 CellID->1346485848],
Cell[131690, 3707, 2555, 62, 70, "Output",
 CellID->2104589148]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[134294, 3775, 234, 7, 70, "ExampleSubsection",
 CellID->203839123],
Cell[134531, 3784, 72, 1, 70, "ExampleText",
 CellID->2036916947],
Cell[CellGroupData[{
Cell[134628, 3789, 437, 12, 70, "Input",
 CellID->1851389954],
Cell[135068, 3803, 1484, 45, 70, "Output",
 CellID->387529401]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[136601, 3854, 233, 7, 70, "ExampleSubsection",
 CellID->238189510],
Cell[136837, 3863, 76, 1, 70, "ExampleText",
 CellID->825767658],
Cell[CellGroupData[{
Cell[136938, 3868, 491, 15, 70, "Input",
 CellID->612297678],
Cell[137432, 3885, 2279, 66, 70, "Output",
 CellID->2046198038]
}, Open  ]],
Cell[139726, 3954, 126, 3, 70, "ExampleDelimiter",
 CellID->1515268568],
Cell[139855, 3959, 80, 1, 70, "ExampleText",
 CellID->384406038],
Cell[CellGroupData[{
Cell[139960, 3964, 580, 17, 70, "Input",
 CellID->349905032],
Cell[140543, 3983, 2015, 60, 70, "Output",
 CellID->1014724403]
}, Open  ]],
Cell[142573, 4046, 126, 3, 70, "ExampleDelimiter",
 CellID->2141000564],
Cell[142702, 4051, 103, 2, 70, "ExampleText",
 CellID->2014701195],
Cell[CellGroupData[{
Cell[142830, 4057, 574, 17, 70, "Input",
 CellID->682974758],
Cell[143407, 4076, 2407, 70, 70, "Output",
 CellID->1052846637]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[145863, 4152, 241, 7, 70, "ExampleSubsection",
 CellID->65693485],
Cell[146107, 4161, 79, 1, 70, "ExampleText",
 CellID->170649085],
Cell[CellGroupData[{
Cell[146211, 4166, 655, 19, 70, "Input",
 CellID->474579552],
Cell[146869, 4187, 4867, 100, 70, "Output",
 CellID->138669109]
}, Open  ]],
Cell[151751, 4290, 125, 3, 70, "ExampleDelimiter",
 CellID->141508825],
Cell[151879, 4295, 94, 1, 70, "ExampleText",
 CellID->2122510440],
Cell[CellGroupData[{
Cell[151998, 4300, 1044, 30, 70, "Input",
 CellID->1956840094],
Cell[153045, 4332, 4990, 106, 70, "Output",
 CellID->644227865]
}, Open  ]],
Cell[158050, 4441, 125, 3, 70, "ExampleDelimiter",
 CellID->420690581],
Cell[158178, 4446, 68, 1, 70, "ExampleText",
 CellID->293080936],
Cell[CellGroupData[{
Cell[158271, 4451, 558, 20, 70, "Input",
 CellID->874236904],
Cell[158832, 4473, 296, 9, 201, "Output",
 CellID->172613196]
}, Open  ]],
Cell[CellGroupData[{
Cell[159165, 4487, 889, 27, 70, "Input",
 CellID->183329943],
Cell[160057, 4516, 6824, 150, 70, "Output",
 CellID->633509661]
}, Open  ]],
Cell[166896, 4669, 125, 3, 70, "ExampleDelimiter",
 CellID->332586483],
Cell[167024, 4674, 61, 1, 70, "ExampleText",
 CellID->26472224],
Cell[CellGroupData[{
Cell[167110, 4679, 308, 9, 70, "Input",
 CellID->1020060192],
Cell[167421, 4690, 1996, 63, 70, "Output",
 CellID->1405805230]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[169466, 4759, 238, 7, 70, "ExampleSubsection",
 CellID->230110335],
Cell[169707, 4768, 99, 1, 70, "ExampleText",
 CellID->1920904431],
Cell[CellGroupData[{
Cell[169831, 4773, 500, 15, 70, "Input",
 CellID->269954683],
Cell[170334, 4790, 1639, 50, 70, "Output",
 CellID->706441802]
}, Open  ]],
Cell[171988, 4843, 124, 3, 70, "ExampleDelimiter",
 CellID->25972127],
Cell[172115, 4848, 85, 1, 70, "ExampleText",
 CellID->324456243],
Cell[CellGroupData[{
Cell[172225, 4853, 768, 26, 70, "Input",
 CellID->157182503],
Cell[172996, 4881, 12734, 204, 201, "Output",
 CellID->131380172]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[185779, 5091, 235, 7, 70, "ExampleSubsection",
 CellID->100942717],
Cell[186017, 5100, 98, 1, 70, "ExampleText",
 CellID->1029865650],
Cell[CellGroupData[{
Cell[186140, 5105, 852, 25, 70, "Input",
 CellID->40554687],
Cell[186995, 5132, 14350, 308, 70, "Output",
 CellID->1008867074]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[201394, 5446, 233, 7, 70, "ExampleSubsection",
 CellID->47225018],
Cell[201630, 5455, 100, 1, 70, "ExampleText",
 CellID->1302252890],
Cell[CellGroupData[{
Cell[201755, 5460, 1096, 29, 70, "Input",
 CellID->47617879],
Cell[202854, 5491, 153288, 3918, 70, "Output",
 CellID->1871102719]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[356191, 9415, 236, 7, 70, "ExampleSubsection",
 CellID->44888674],
Cell[356430, 9424, 232, 8, 70, "ExampleText",
 CellID->1808033363],
Cell[CellGroupData[{
Cell[356687, 9436, 856, 25, 70, "Input",
 CellID->500288768],
Cell[357546, 9463, 5986, 173, 70, "Output",
 CellID->1049022900]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[363581, 9642, 230, 7, 70, "ExampleSubsection",
 CellID->179618439],
Cell[363814, 9651, 84, 1, 70, "ExampleText",
 CellID->1676190373],
Cell[CellGroupData[{
Cell[363923, 9656, 884, 25, 70, "Input",
 CellID->14566157],
Cell[364810, 9683, 7612, 216, 70, "Output",
 CellID->676210195]
}, Open  ]],
Cell[372437, 9902, 125, 3, 70, "ExampleDelimiter",
 CellID->297939305],
Cell[372565, 9907, 383, 12, 70, "ExampleText",
 CellID->580503372],
Cell[CellGroupData[{
Cell[372973, 9923, 878, 26, 70, "Input",
 CellID->317015018],
Cell[373854, 9951, 1710, 37, 157, "Output",
 CellID->1665415811]
}, Open  ]],
Cell[375579, 9991, 125, 3, 70, "ExampleDelimiter",
 CellID->414909817],
Cell[375707, 9996, 378, 12, 70, "ExampleText",
 CellID->88626299],
Cell[CellGroupData[{
Cell[376110, 10012, 847, 25, 70, "Input",
 CellID->238367270],
Cell[376960, 10039, 2749, 75, 70, "Output",
 CellID->940432148]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[379758, 10120, 233, 7, 70, "ExampleSubsection",
 CellID->91275691],
Cell[379994, 10129, 93, 1, 70, "ExampleText",
 CellID->1053407179],
Cell[CellGroupData[{
Cell[380112, 10134, 647, 20, 70, "Input",
 CellID->375686493],
Cell[380762, 10156, 8169, 185, 70, "Output",
 CellID->155313840]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[388980, 10347, 234, 7, 70, "ExampleSubsection",
 CellID->24443973],
Cell[389217, 10356, 63, 1, 70, "ExampleText",
 CellID->1001631834],
Cell[CellGroupData[{
Cell[389305, 10361, 455, 13, 70, "Input",
 CellID->1042589918],
Cell[389763, 10376, 2077, 51, 168, "Output",
 CellID->907922855]
}, Open  ]],
Cell[391855, 10430, 125, 3, 70, "ExampleDelimiter",
 CellID->291462997],
Cell[391983, 10435, 78, 1, 70, "ExampleText",
 CellID->73764302],
Cell[CellGroupData[{
Cell[392086, 10440, 457, 13, 70, "Input",
 CellID->655204029],
Cell[392546, 10455, 1720, 52, 70, "Output",
 CellID->1845611119]
}, Open  ]],
Cell[394281, 10510, 125, 3, 70, "ExampleDelimiter",
 CellID->268593998],
Cell[394409, 10515, 104, 2, 70, "ExampleText",
 CellID->1953868534],
Cell[CellGroupData[{
Cell[394538, 10521, 458, 13, 70, "Input",
 CellID->69684929],
Cell[394999, 10536, 1720, 52, 70, "Output",
 CellID->1873360300]
}, Open  ]],
Cell[396734, 10591, 123, 3, 70, "ExampleDelimiter",
 CellID->8973542],
Cell[396860, 10596, 95, 1, 70, "ExampleText",
 CellID->1197125759],
Cell[CellGroupData[{
Cell[396980, 10601, 453, 13, 70, "Input",
 CellID->406910921],
Cell[397436, 10616, 2735, 79, 70, "Output",
 CellID->322450815]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[400220, 10701, 241, 7, 70, "ExampleSubsection",
 CellID->74973014],
Cell[400464, 10710, 85, 1, 70, "ExampleText",
 CellID->49039736],
Cell[CellGroupData[{
Cell[400574, 10715, 810, 25, 70, "Input",
 CellID->930075907],
Cell[401387, 10742, 1381, 38, 143, "Output",
 CellID->1801603638]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[402817, 10786, 243, 7, 70, "ExampleSubsection",
 CellID->82661052],
Cell[403063, 10795, 61, 1, 70, "ExampleText",
 CellID->1148726976],
Cell[CellGroupData[{
Cell[403149, 10800, 431, 13, 70, "Input",
 CellID->1976145425],
Cell[403583, 10815, 8833, 149, 70, "Output",
 Evaluatable->False,
 CellID->64398702]
}, Open  ]],
Cell[412431, 10967, 126, 3, 70, "ExampleDelimiter",
 CellID->1647530537],
Cell[412560, 10972, 87, 1, 70, "ExampleText",
 CellID->2039050761],
Cell[412650, 10975, 2466, 43, 70, "Input",
 CellID->876584969],
Cell[CellGroupData[{
Cell[415141, 11022, 661, 19, 70, "Input",
 CellID->280649582],
Cell[415805, 11043, 15609, 260, 70, "Output",
 Evaluatable->False,
 CellID->256439430]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[431475, 11310, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[431705, 11319, 83, 1, 70, "ExampleText",
 CellID->35668815],
Cell[CellGroupData[{
Cell[431813, 11324, 425, 14, 70, "Input",
 CellID->92411642],
Cell[432241, 11340, 750, 21, 54, "Output",
 CellID->305873591]
}, Open  ]],
Cell[433006, 11364, 71, 1, 70, "ExampleText",
 CellID->249847445],
Cell[CellGroupData[{
Cell[433102, 11369, 350, 12, 70, "Input",
 CellID->684034572],
Cell[433455, 11383, 17091, 459, 70, "Output",
 CellID->251885608]
}, Open  ]],
Cell[450561, 11845, 125, 3, 70, "ExampleDelimiter",
 CellID->190033263],
Cell[450689, 11850, 61, 1, 70, "ExampleText",
 CellID->417731522],
Cell[450753, 11853, 1106, 36, 70, "Input",
 CellID->212432726],
Cell[CellGroupData[{
Cell[451884, 11893, 190, 6, 70, "Input",
 CellID->138891],
Cell[452077, 11901, 8454, 233, 70, "Output",
 CellID->500402523]
}, Open  ]],
Cell[460546, 12137, 125, 3, 70, "ExampleDelimiter",
 CellID->113617842],
Cell[460674, 12142, 74, 1, 70, "ExampleText",
 CellID->29497398],
Cell[CellGroupData[{
Cell[460773, 12147, 345, 10, 70, "Input",
 CellID->41905187],
Cell[461121, 12159, 6816, 188, 70, "Output",
 CellID->587340453]
}, Open  ]],
Cell[467952, 12350, 122, 3, 70, "ExampleDelimiter",
 CellID->943217],
Cell[468077, 12355, 85, 1, 70, "ExampleText",
 CellID->46269310],
Cell[CellGroupData[{
Cell[468187, 12360, 706, 22, 70, "Input",
 CellID->300061220],
Cell[468896, 12384, 26404, 862, 70, "Output",
 CellID->132571779]
}, Open  ]],
Cell[495315, 13249, 126, 3, 70, "ExampleDelimiter",
 CellID->1604511784],
Cell[495444, 13254, 100, 1, 70, "ExampleText",
 CellID->1746063565],
Cell[CellGroupData[{
Cell[495569, 13259, 532, 17, 70, "Input",
 CellID->759610285],
Cell[496104, 13278, 7545, 128, 70, "Output",
 Evaluatable->False,
 CellID->333983456]
}, Open  ]],
Cell[503664, 13409, 125, 3, 70, "ExampleDelimiter",
 CellID->842478017],
Cell[503792, 13414, 99, 1, 70, "ExampleText",
 CellID->1696081216],
Cell[CellGroupData[{
Cell[503916, 13419, 489, 16, 70, "Input",
 CellID->856391230],
Cell[504408, 13437, 12802, 364, 70, "Output",
 CellID->563443096]
}, Open  ]],
Cell[517225, 13804, 125, 3, 70, "ExampleDelimiter",
 CellID->581457596],
Cell[517353, 13809, 99, 1, 70, "ExampleText",
 CellID->1522827744],
Cell[CellGroupData[{
Cell[517477, 13814, 584, 19, 70, "Input",
 CellID->2050629870],
Cell[518064, 13835, 15211, 249, 246, "Output",
 CellID->287215605]
}, Open  ]],
Cell[533290, 14087, 126, 3, 70, "ExampleDelimiter",
 CellID->1514008187],
Cell[533419, 14092, 100, 1, 70, "ExampleText",
 CellID->1238314478],
Cell[CellGroupData[{
Cell[533544, 14097, 522, 18, 70, "Input",
 CellID->1448658424],
Cell[534069, 14117, 9486, 313, 70, "Output",
 CellID->342802775]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[543604, 14436, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[543845, 14445, 250, 8, 70, "ExampleText",
 CellID->42741813],
Cell[CellGroupData[{
Cell[544120, 14457, 805, 23, 70, "Input",
 CellID->1047607103],
Cell[544928, 14482, 4494, 107, 189, "Output",
 CellID->1153758716]
}, Open  ]],
Cell[549437, 14592, 126, 3, 70, "ExampleDelimiter",
 CellID->1170669461],
Cell[549566, 14597, 361, 13, 70, "ExampleText",
 CellID->1408649024],
Cell[549930, 14612, 1432, 36, 70, "Input",
 CellID->219311158],
Cell[CellGroupData[{
Cell[551387, 14652, 192, 6, 70, "Input",
 CellID->1935028127],
Cell[551582, 14660, 10375, 261, 70, "Output",
 CellID->1897544943]
}, Open  ]],
Cell[561972, 14924, 125, 3, 70, "ExampleDelimiter",
 CellID->781685086],
Cell[562100, 14929, 349, 13, 70, "ExampleText",
 CellID->1865416085],
Cell[CellGroupData[{
Cell[562474, 14946, 254, 8, 70, "Input",
 CellID->1254585860],
Cell[562731, 14956, 486, 17, 36, "Output",
 CellID->1792143536]
}, Open  ]],
Cell[CellGroupData[{
Cell[563254, 14978, 191, 6, 70, "Input",
 CellID->1133133760],
Cell[563448, 14986, 5369, 92, 70, "Output",
 Evaluatable->False,
 CellID->141903805]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[568866, 15084, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[569100, 15093, 82, 1, 70, "ExampleText",
 CellID->259535291],
Cell[CellGroupData[{
Cell[569207, 15098, 454, 13, 70, "Input",
 CellID->500618139],
Cell[569664, 15113, 1350, 34, 97, "Output",
 CellID->516362428]
}, Open  ]],
Cell[571029, 15150, 356, 13, 70, "ExampleText",
 CellID->56994867],
Cell[CellGroupData[{
Cell[571410, 15167, 462, 13, 70, "Input",
 CellID->175008072],
Cell[571875, 15182, 2692, 48, 70, "Output",
 Evaluatable->False,
 CellID->192399764]
}, Open  ]],
Cell[CellGroupData[{
Cell[574604, 15235, 455, 13, 70, "Input",
 CellID->227487619],
Cell[575062, 15250, 1423, 36, 121, "Output",
 CellID->903351210]
}, Open  ]],
Cell[576500, 15289, 126, 3, 70, "ExampleDelimiter",
 CellID->2085888102],
Cell[576629, 15294, 239, 7, 70, "ExampleText",
 CellID->216671225],
Cell[CellGroupData[{
Cell[576893, 15305, 342, 10, 70, "Input",
 CellID->1351880948],
Cell[577238, 15317, 1147, 30, 121, "Output",
 CellID->2055512166]
}, Open  ]],
Cell[578400, 15350, 118, 3, 70, "ExampleText",
 CellID->266469226],
Cell[CellGroupData[{
Cell[578543, 15357, 362, 10, 70, "Input",
 CellID->44242984],
Cell[578908, 15369, 793, 17, 70, "Output",
 Evaluatable->False,
 CellID->145352398]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[579750, 15392, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[579981, 15401, 96, 1, 70, "ExampleText",
 CellID->109185977],
Cell[CellGroupData[{
Cell[580102, 15406, 894, 29, 70, "Input",
 CellID->577069777],
Cell[580999, 15437, 76618, 1216, 335, "Output",
 CellID->79242243]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[657678, 16660, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[657997, 16671, 957, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[658991, 16711, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[659312, 16722, 410, 12, 70, "Tutorials",
 CellID->25850],
Cell[659725, 16736, 138, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[659900, 16744, 305, 8, 70, "RelatedLinksSection"],
Cell[660208, 16754, 361, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[660606, 16771, 299, 8, 70, "MoreAboutSection"],
Cell[660908, 16781, 165, 3, 70, "MoreAbout",
 CellID->222591370],
Cell[661076, 16786, 147, 3, 70, "MoreAbout",
 CellID->418779056],
Cell[661226, 16791, 151, 3, 70, "MoreAbout",
 CellID->213997328],
Cell[661380, 16796, 166, 3, 70, "MoreAbout",
 CellID->433186417],
Cell[661549, 16801, 179, 3, 70, "MoreAbout",
 CellID->434180968],
Cell[661731, 16806, 178, 3, 70, "MoreAbout",
 CellID->38320871]
}, Open  ]],
Cell[661924, 16812, 27, 0, 70, "History"],
Cell[661954, 16814, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

