(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12014,        437]
NotebookOptionsPosition[      8732,        327]
NotebookOutlinePosition[     10509,        380]
CellTagsIndexPosition[     10398,        374]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Trigonometric Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TrigonometricExpressions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Trigonometric Expressions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FactorList" :> 
          Documentation`HelpLookup["paclet:ref/FactorList"], "TrigFactor" :> 
          Documentation`HelpLookup["paclet:ref/TrigFactor"], "TrigToExp" :> 
          Documentation`HelpLookup["paclet:ref/TrigToExp"], "TrigReduce" :> 
          Documentation`HelpLookup["paclet:ref/TrigReduce"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FactorList\"\>", 
       2->"\<\"TrigFactor\"\>", 3->"\<\"TrigToExp\"\>", 
       4->"\<\"TrigReduce\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TrigFactorList", "ObjectName",
 CellID->810],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TrigFactorList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TrigFactorList"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]factors trigonometric functions in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", yielding a list of lists containing trigonometric monomials and \
exponents. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22705]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigFactorList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigFactorList"]], "InlineFormula"],
 " tries to give results in terms of powers of ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Sinh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sinh"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Cosh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cosh"]], "InlineFormula"],
 ", explicitly decomposing functions like ",
 Cell[BoxData[
  ButtonBox["Tan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tan"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19797]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->353283076],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->31547529],

Cell["Give a list of factors of a trigonometric expression:", "ExampleText",
 CellID->22219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactorList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], "+", 
   RowBox[{
    RowBox[{"Tan", "[", "x", "]"}], "^", "2"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[1]:=",
 CellID->9818],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", 
      RowBox[{"Cos", "[", 
       RowBox[{"2", " ", "x"}], "]"}]}], ",", "1"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{359, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[1]=",
 CellID->23252264]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->206162104],

Cell["\<\
Give a list of factors of a hyperbolic trigonometric expression:\
\>", "ExampleText",
 CellID->5827197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactorList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cosh", "[", "x", "]"}], "^", "2"}], "-", 
   RowBox[{
    RowBox[{"Cosh", "[", "x", "]"}], "^", "4"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[1]:=",
 CellID->36375741],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sinh", "[", "x", "]"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cosh", "[", "x", "]"}], ",", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{250, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[1]=",
 CellID->141324407]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14833],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FactorList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FactorList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigFactor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigFactor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigReduce"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20618]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15918],

Cell[TextData[ButtonBox["Trigonometric Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TrigonometricExpressions"]], "Tutorials",
 CellID->13316]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TrigFactorList - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 52.8811292}", "context" -> "System`", 
    "keywords" -> {
     "trigonometric factorization", "hyperbolic factorization", 
      "factorization"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TrigFactorList[expr] factors trigonometric functions in expr, yielding a \
list of lists containing trigonometric monomials and exponents. ", 
    "synonyms" -> {"trig factor list"}, "title" -> "TrigFactorList", "type" -> 
    "Symbol", "uri" -> "ref/TrigFactorList"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4232, 144, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->353283076]},
 "CellTags"->{
  Cell[4884, 170, 263, 9, 28, "Input",
   CellTags->"CellTags",
   CellID->9818],
  Cell[5150, 181, 640, 24, 36, "Output",
   CellTags->"CellTags",
   CellID->23252264],
  Cell[6071, 220, 269, 9, 70, "Input",
   CellTags->"CellTags",
   CellID->36375741],
  Cell[6343, 231, 473, 17, 36, "Output",
   CellTags->"CellTags",
   CellID->141324407]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9894, 354},
 {"CellTags", 10029, 358}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1507, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2130, 63, 50, 1, 70, "ObjectName",
 CellID->810],
Cell[2183, 66, 648, 19, 70, "Usage",
 CellID->22705]
}, Open  ]],
Cell[CellGroupData[{
Cell[2868, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3346, 107, 849, 32, 70, "Notes",
 CellID->19797]
}, Closed]],
Cell[CellGroupData[{
Cell[4232, 144, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->353283076],
Cell[CellGroupData[{
Cell[4617, 158, 147, 5, 70, "ExampleSection",
 CellID->31547529],
Cell[4767, 165, 92, 1, 70, "ExampleText",
 CellID->22219],
Cell[CellGroupData[{
Cell[4884, 170, 263, 9, 28, "Input",
 CellTags->"CellTags",
 CellID->9818],
Cell[5150, 181, 640, 24, 36, "Output",
 CellTags->"CellTags",
 CellID->23252264]
}, Open  ]],
Cell[5805, 208, 125, 3, 70, "ExampleDelimiter",
 CellID->206162104],
Cell[5933, 213, 113, 3, 70, "ExampleText",
 CellID->5827197],
Cell[CellGroupData[{
Cell[6071, 220, 269, 9, 70, "Input",
 CellTags->"CellTags",
 CellID->36375741],
Cell[6343, 231, 473, 17, 36, "Output",
 CellTags->"CellTags",
 CellID->141324407]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6877, 255, 311, 9, 70, "SeeAlsoSection",
 CellID->14833],
Cell[7191, 266, 955, 35, 70, "SeeAlso",
 CellID->20618]
}, Open  ]],
Cell[CellGroupData[{
Cell[8183, 306, 314, 9, 70, "TutorialsSection",
 CellID->15918],
Cell[8500, 317, 160, 3, 70, "Tutorials",
 CellID->13316]
}, Open  ]],
Cell[8675, 323, 27, 0, 70, "History"],
Cell[8705, 325, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

