(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31506,       1091]
NotebookOptionsPosition[     25613,        883]
NotebookOutlinePosition[     27161,        929]
CellTagsIndexPosition[     27049,        923]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Expressions into Different Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingExpressionsIntoDifferentForms"], 
          "Trigonometric Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TrigonometricExpressions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Putting Expressions into Different Forms\"\>", 
       2->"\<\"Trigonometric Expressions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ExpToTrig" :> Documentation`HelpLookup["paclet:ref/ExpToTrig"],
           "TrigReduce" :> Documentation`HelpLookup["paclet:ref/TrigReduce"], 
          "ComplexExpand" :> 
          Documentation`HelpLookup["paclet:ref/ComplexExpand"], 
          "FunctionExpand" :> 
          Documentation`HelpLookup["paclet:ref/FunctionExpand"], "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"], "TrigFactor" :> 
          Documentation`HelpLookup["paclet:ref/TrigFactor"], "TrigFactorList" :> 
          Documentation`HelpLookup["paclet:ref/TrigFactorList"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ExpToTrig\"\>", 
       2->"\<\"TrigReduce\"\>", 3->"\<\"ComplexExpand\"\>", 
       4->"\<\"FunctionExpand\"\>", 5->"\<\"TrigExpand\"\>", 
       6->"\<\"TrigFactor\"\>", 
       7->"\<\"TrigFactorList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Transformations" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicTransformations"], 
          "Complex Numbers" :> 
          Documentation`HelpLookup["paclet:guide/ComplexNumbers"], 
          "Hyperbolic Functions" :> 
          Documentation`HelpLookup["paclet:guide/HyperbolicFunctions"], 
          "Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Transformations\"\>", 2->"\<\"Complex Numbers\"\>", 
       3->"\<\"Hyperbolic Functions\"\>", 
       4->"\<\"Trigonometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["TrigToExp", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TrigToExp",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TrigToExp"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]converts trigonometric functions in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to exponentials. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21827]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigToExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigToExp"]], "InlineFormula"],
 " operates on both circular and hyperbolic functions, and their inverses. "
}], "Notes",
 CellID->4403],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigToExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigToExp"]], "InlineFormula"],
 " automatically threads over lists, as well as equations, inequalities and \
logic functions."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->82730543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->447663529],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->677504763],

Cell["\<\
Convert from trigonometric functions to complex exponentials:\
\>", "ExampleText",
 CellID->12359],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"Cos", "[", "x", "]"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[1]:=",
 CellID->1539],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]], "2"], "+", 
  FractionBox[
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", "x"}]], "2"]}]], "Output",
 ImageSize->{69, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[1]=",
 CellID->162915346]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25383],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigToExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigToExp"]], "InlineFormula"],
 " works with hyperbolic functions:"
}], "ExampleText",
 CellID->30442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"Tanh", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1979],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "x"}]]}], "+", 
   SuperscriptBox["\[ExponentialE]", "x"]}], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "x"}]], "+", 
   SuperscriptBox["\[ExponentialE]", "x"]}]]], "Output",
 ImageSize->{59, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->379018673]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"ArcTanh", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25780],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "-", "x"}], "]"}]}], "+", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}]}]}]], "Output",
 ImageSize->{176, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->712201736]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"ArcSin", "[", "I", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15794],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  RowBox[{"Log", "[", 
   RowBox[{"1", "+", 
    SqrtBox["2"]}], "]"}]}]], "Output",
 ImageSize->{94, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13781858]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1961],

Cell["\<\
Rewrite compositions of trigonometric and inverse trigonometric functions:\
\>", "ExampleText",
 CellID->453382805],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"Sin", "[", 
   RowBox[{"5", " ", 
    RowBox[{"ArcSin", "[", "x", "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216025088],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
  RowBox[{"(", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "x"}], "+", 
        SqrtBox[
         RowBox[{"1", "-", 
          SuperscriptBox["x", "2"]}]]}], ")"}], "5"]], "-", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[ImaginaryI]", " ", "x"}], "+", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]]}], ")"}], "5"]}], ")"}]}]], "Output",
 ImageSize->{263, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->92537304]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->448787249],

Cell[BoxData[
 RowBox[{"x", " ", 
  RowBox[{"(", 
   RowBox[{"5", "-", 
    RowBox[{"20", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["x", "4"]}]}], ")"}]}]], "Output",
 ImageSize->{120, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->93400181]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->181296058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigReduce", "[", 
  RowBox[{"%", "/.", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7083142],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"5", " ", "\[Theta]"}], "]"}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->591057412]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->544758567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "t", "]"}], "+", 
       RowBox[{
        SuperscriptBox["\[Omega]", "2"], 
        RowBox[{"y", "[", "t", "]"}]}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", 
      RowBox[{"I", " ", "\[Omega]"}]}]}], "}"}], ",", 
   RowBox[{"y", "[", "t", "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114035183],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "t", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"t", " ", "\[Omega]"}], "]"}], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"t", " ", "\[Omega]"}], "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{204, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169107268]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->153179970],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "t", "]"}], "\[Rule]", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "t", " ", "\[Omega]"}]]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{103, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->658074786]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16397],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigToExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigToExp"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists, equations, inequalities and logic \
functions:"
}], "ExampleText",
 CellID->639922602],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], "<", "x", "<", 
   RowBox[{"Tan", "[", "x", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->51008356],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "x"}]]}]}], "<", "x", "<", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]], "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "x"}]]}], ")"}]}], 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]], "+", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "x"}]]}]]}]], "Output",
 ImageSize->{232, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9068100]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", 
   RowBox[{"Pi", "/", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->355278567],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "x"}]]}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "x"}]]}]}], "\[Equal]", 
  FractionBox["\[Pi]", "3"]}]], "Output",
 ImageSize->{140, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->751784356]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->366937303],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigToExp",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigToExp"]], "InlineFormula"],
 " is an inverse of ",
 Cell[BoxData[
  ButtonBox["ExpToTrig",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpToTrig"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->420765924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ExpToTrig", "[", 
    RowBox[{"Exp", "[", 
     RowBox[{"I", " ", "x"}], "]"}], "]"}], ",", 
   RowBox[{"ExpToTrig", "[", 
    RowBox[{"Log", "[", 
     RowBox[{"z", "+", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["z", "2"], "+", "1"}]]}], "]"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->384627932],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "+", 
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"ArcSinh", "[", "z", "]"}]}], "}"}]], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15354676]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17124814],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", "x"}]], ",", 
   RowBox[{"Log", "[", 
    RowBox[{"z", "+", 
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox["z", "2"]}]]}], "]"}]}], "}"}]], "Output",
 ImageSize->{155, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->58458276]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5393],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpToTrig",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpToTrig"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FunctionExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FunctionExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigFactor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigFactor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigFactorList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigFactorList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6257]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18955],

Cell[TextData[ButtonBox["Putting Expressions into Different Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PuttingExpressionsIntoDifferentForms"]], "Tutorials",
 CellID->15739],

Cell[TextData[ButtonBox["Trigonometric Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TrigonometricExpressions"]], "Tutorials",
 CellID->7540]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->271168400],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "MoreAbout",
 CellID->453096811],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComplexNumbers"]], "MoreAbout",
 CellID->2483213],

Cell[TextData[ButtonBox["Hyperbolic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HyperbolicFunctions"]], "MoreAbout",
 CellID->44608536],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->213997788]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TrigToExp - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 54.6311740}", "context" -> "System`", 
    "keywords" -> {
     "circular functions", "conversion", "Euler's formula", 
      "hyperbolic functions", "trigonometric functions"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TrigToExp[expr] converts trigonometric functions in expr to \
exponentials. ", "synonyms" -> {"trig to exp"}, "title" -> "TrigToExp", 
    "type" -> "Symbol", "uri" -> "ref/TrigToExp"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9715, 245, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->447663529]},
 "CellTags"->{
  Cell[10384, 273, 153, 5, 28, "Input",
   CellTags->"CellTags",
   CellID->1539],
  Cell[10540, 280, 418, 14, 55, "Output",
   CellTags->"CellTags",
   CellID->162915346]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26717, 909},
 {"CellTags", 26852, 913}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3128, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3751, 95, 4193, 83, 70, "ObjectNameGrid"],
Cell[7947, 180, 578, 18, 70, "Usage",
 CellID->21827]
}, Open  ]],
Cell[CellGroupData[{
Cell[8562, 203, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9040, 220, 241, 7, 70, "Notes",
 CellID->4403],
Cell[9284, 229, 394, 11, 70, "Notes",
 CellID->82730543]
}, Closed]],
Cell[CellGroupData[{
Cell[9715, 245, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->447663529],
Cell[CellGroupData[{
Cell[10100, 259, 148, 5, 70, "ExampleSection",
 CellID->677504763],
Cell[10251, 266, 108, 3, 70, "ExampleText",
 CellID->12359],
Cell[CellGroupData[{
Cell[10384, 273, 153, 5, 28, "Input",
 CellTags->"CellTags",
 CellID->1539],
Cell[10540, 280, 418, 14, 55, "Output",
 CellTags->"CellTags",
 CellID->162915346]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11007, 300, 216, 7, 70, "ExampleSection",
 CellID->25383],
Cell[11226, 309, 208, 7, 70, "ExampleText",
 CellID->30442],
Cell[CellGroupData[{
Cell[11459, 320, 131, 4, 70, "Input",
 CellID->1979],
Cell[11593, 326, 441, 15, 52, "Output",
 CellID->379018673]
}, Open  ]],
Cell[12049, 344, 120, 3, 70, "ExampleDelimiter",
 CellID->8889],
Cell[CellGroupData[{
Cell[12194, 351, 135, 4, 70, "Input",
 CellID->25780],
Cell[12332, 357, 403, 15, 51, "Output",
 CellID->712201736]
}, Open  ]],
Cell[12750, 375, 120, 3, 70, "ExampleDelimiter",
 CellID->4783],
Cell[CellGroupData[{
Cell[12895, 382, 134, 4, 70, "Input",
 CellID->15794],
Cell[13032, 388, 259, 9, 43, "Output",
 CellID->13781858]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13340, 403, 222, 7, 70, "ExampleSection",
 CellID->1961],
Cell[13565, 412, 125, 3, 70, "ExampleText",
 CellID->453382805],
Cell[CellGroupData[{
Cell[13715, 419, 194, 6, 70, "Input",
 CellID->216025088],
Cell[13912, 427, 692, 24, 88, "Output",
 CellID->92537304]
}, Open  ]],
Cell[CellGroupData[{
Cell[14641, 456, 108, 3, 70, "Input",
 CellID->448787249],
Cell[14752, 461, 343, 12, 39, "Output",
 CellID->93400181]
}, Open  ]],
Cell[15110, 476, 49, 1, 70, "ExampleText",
 CellID->181296058],
Cell[CellGroupData[{
Cell[15184, 481, 197, 6, 70, "Input",
 CellID->7083142],
Cell[15384, 489, 217, 7, 36, "Output",
 CellID->591057412]
}, Open  ]],
Cell[15616, 499, 125, 3, 70, "ExampleDelimiter",
 CellID->544758567],
Cell[CellGroupData[{
Cell[15766, 506, 622, 20, 70, "Input",
 CellID->114035183],
Cell[16391, 528, 463, 15, 36, "Output",
 CellID->169107268]
}, Open  ]],
Cell[CellGroupData[{
Cell[16891, 548, 105, 3, 70, "Input",
 CellID->153179970],
Cell[16999, 553, 362, 12, 41, "Output",
 CellID->658074786]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17410, 571, 233, 7, 70, "ExampleSection",
 CellID->16397],
Cell[17646, 580, 267, 8, 70, "ExampleText",
 CellID->639922602],
Cell[CellGroupData[{
Cell[17938, 592, 199, 6, 70, "Input",
 CellID->51008356],
Cell[18140, 600, 1026, 31, 59, "Output",
 CellID->9068100]
}, Open  ]],
Cell[CellGroupData[{
Cell[19203, 636, 191, 6, 70, "Input",
 CellID->355278567],
Cell[19397, 644, 552, 17, 51, "Output",
 CellID->751784356]
}, Open  ]],
Cell[19964, 664, 125, 3, 70, "ExampleDelimiter",
 CellID->366937303],
Cell[20092, 669, 324, 12, 70, "ExampleText",
 CellID->420765924],
Cell[CellGroupData[{
Cell[20441, 685, 382, 14, 70, "Input",
 CellID->384627932],
Cell[20826, 701, 364, 12, 36, "Output",
 CellID->15354676]
}, Open  ]],
Cell[CellGroupData[{
Cell[21227, 718, 104, 3, 70, "Input",
 CellID->17124814],
Cell[21334, 723, 406, 14, 48, "Output",
 CellID->58458276]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21801, 744, 310, 9, 70, "SeeAlsoSection",
 CellID->5393],
Cell[22114, 755, 1723, 62, 70, "SeeAlso",
 CellID->6257]
}, Open  ]],
Cell[CellGroupData[{
Cell[23874, 822, 314, 9, 70, "TutorialsSection",
 CellID->18955],
Cell[24191, 833, 190, 4, 70, "Tutorials",
 CellID->15739],
Cell[24384, 839, 159, 3, 70, "Tutorials",
 CellID->7540]
}, Open  ]],
Cell[CellGroupData[{
Cell[24580, 847, 319, 9, 70, "MoreAboutSection",
 CellID->271168400],
Cell[24902, 858, 161, 3, 70, "MoreAbout",
 CellID->453096811],
Cell[25066, 863, 139, 3, 70, "MoreAbout",
 CellID->2483213],
Cell[25208, 868, 150, 3, 70, "MoreAbout",
 CellID->44608536],
Cell[25361, 873, 157, 3, 70, "MoreAbout",
 CellID->213997788]
}, Open  ]],
Cell[25533, 879, 50, 0, 70, "History"],
Cell[25586, 881, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

