(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22291,        851]
NotebookOptionsPosition[     16669,        657]
NotebookOutlinePosition[     17936,        694]
CellTagsIndexPosition[     17851,        689]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Equations" :> 
          Documentation`HelpLookup["paclet:tutorial/Equations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Equations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"False" :> Documentation`HelpLookup["paclet:ref/False"], 
          "TrueQ" :> Documentation`HelpLookup["paclet:ref/TrueQ"], "Boole" :> 
          Documentation`HelpLookup["paclet:ref/Boole"], "If" :> 
          Documentation`HelpLookup["paclet:ref/If"], "Booleans" :> 
          Documentation`HelpLookup["paclet:ref/Booleans"], "ForAll" :> 
          Documentation`HelpLookup["paclet:ref/ForAll"], "Automatic" :> 
          Documentation`HelpLookup["paclet:ref/Automatic"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"False\"\>", 2->"\<\"TrueQ\"\>", 
       3->"\<\"Boole\"\>", 4->"\<\"If\"\>", 5->"\<\"Booleans\"\>", 
       6->"\<\"ForAll\"\>", 7->"\<\"Automatic\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"], 
          "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Logic & Boolean Algebra\"\>",
        2->"\<\"Numerical Functions\"\>", 
       3->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["True", "ObjectName",
 CellID->28222],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     "\[LineSeparator]is the symbol for the Boolean value true. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30815]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->313863052],

Cell["Evaluate a Boolean expression:", "ExampleText",
 CellID->164430630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Implies", "[", 
  RowBox[{
   RowBox[{"Not", "[", "True", "]"}], ",", 
   RowBox[{"True", "&&", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21340764],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->161429991]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->448422820],

Cell["Use a conditional:", "ExampleText",
 CellID->156302607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{"True", ",", "a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49745004],

Cell[BoxData["a"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3345742]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30787888],

Cell["Test a structural property:", "ExampleText",
 CellID->939752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixQ", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65950149],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->384232320]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19683815],

Cell["Test a mathematical property:", "ExampleText",
 CellID->186793146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", "E", "]"}], ">", 
  RowBox[{"Cos", "[", "E", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->774552658],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->115973087]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->486111416],

Cell["The symbol for the Boolean value false:", "ExampleText",
 CellID->412067263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Not", "[", "True", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42815367],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->287493206]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->291613303],

Cell["Truth table for a Boolean function:", "ExampleText",
 CellID->69679226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Outer", "[", 
   RowBox[{"Xor", ",", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}], "]"}], "//", "Grid"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->95768180],

Cell[BoxData[
 TagBox[GridBox[{
    {"False", "True"},
    {"True", "False"}
   }],
  "Grid"]], "Output",
 ImageSize->{82, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114825664]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120928372],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Boole",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Boole"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellID->58299015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Boole", "/@", 
  RowBox[{"{", 
   RowBox[{"True", ",", "False"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->153856634],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18216969]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->222819089],

Cell["This equality is not resolved automatically:", "ExampleText",
 CellID->176636187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], "+", 
    RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}], "==", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"5", "+", 
     RowBox[{"2", 
      RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}], "/", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->238517545],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"]}], "]"}], "\[Equal]", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"5", "+", 
     RowBox[{"2", " ", 
      SqrtBox["6"]}]}], "]"}]}]}]], "Output",
 ImageSize->{219, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16409605]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to find its truth value:"
}], "ExampleText",
 CellID->144318281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->334328105],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->481334373]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->417566394],

Cell["A fully quantified expression:", "ExampleText",
 CellID->622689182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ForAll", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"x", "<", "y"}], ",", 
   RowBox[{"Exists", "[", 
    RowBox[{"z", ",", 
     RowBox[{"x", "<", "z", "<", "y"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->521857631],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[ForAll]", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", 
    RowBox[{"x", "<", "y"}]}]], 
  RowBox[{"(", 
   RowBox[{
    SubscriptBox["\[Exists]", "z"], 
    RowBox[{"x", "<", "z", "<", "y"}]}], ")"}]}]], "Output",
 ImageSize->{139, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->719302821]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " to find its truth value:"
}], "ExampleText",
 CellID->853938565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216212838],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->164141952]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->294889234],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " to find truth values of expressions under specified assumptions:"
}], "ExampleText",
 CellID->739978796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "^", "n"}], "]"}], ",", "Reals"}], "]"}], ",", 
   RowBox[{
    RowBox[{"Element", "[", 
     RowBox[{"x", ",", "Reals"}], "]"}], "&&", 
    RowBox[{"Element", "[", 
     RowBox[{"n", ",", "Integers"}], "]"}], "&&", 
    RowBox[{"n", ">", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->50825397],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98174689]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9297],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrueQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrueQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Boole",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Boole"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["If",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/If"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Booleans",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Booleans"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ForAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ForAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8091]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10860],

Cell[TextData[ButtonBox["Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Equations"]], "Tutorials",
 CellID->21989]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
True"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->247702836],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->199483968],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->867341137]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"True - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 58.8969082}", "context" -> "System`", 
    "keywords" -> {
     "Boolean", "truth value", "logical value", "Boolean algebra", 
      "switching algebra", "propositional logic"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "True is the symbol for the Boolean value true. ", "synonyms" -> {}, 
    "title" -> "True", "type" -> "Symbol", "uri" -> "ref/True"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3657, 105, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17716, 682}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2535, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3158, 84, 42, 1, 70, "ObjectName",
 CellID->28222],
Cell[3203, 87, 417, 13, 70, "Usage",
 CellID->30815]
}, Open  ]],
Cell[CellGroupData[{
Cell[3657, 105, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4034, 119, 148, 5, 70, "ExampleSection",
 CellID->313863052],
Cell[4185, 126, 73, 1, 70, "ExampleText",
 CellID->164430630],
Cell[CellGroupData[{
Cell[4283, 131, 190, 6, 28, "Input",
 CellID->21340764],
Cell[4476, 139, 161, 5, 36, "Output",
 CellID->161429991]
}, Open  ]],
Cell[4652, 147, 125, 3, 70, "ExampleDelimiter",
 CellID->448422820],
Cell[4780, 152, 61, 1, 70, "ExampleText",
 CellID->156302607],
Cell[CellGroupData[{
Cell[4866, 157, 133, 4, 28, "Input",
 CellID->49745004],
Cell[5002, 163, 156, 5, 36, "Output",
 CellID->3345742]
}, Open  ]],
Cell[5173, 171, 124, 3, 70, "ExampleDelimiter",
 CellID->30787888],
Cell[5300, 176, 67, 1, 70, "ExampleText",
 CellID->939752],
Cell[CellGroupData[{
Cell[5392, 181, 271, 9, 70, "Input",
 CellID->65950149],
Cell[5666, 192, 161, 5, 36, "Output",
 CellID->384232320]
}, Open  ]],
Cell[5842, 200, 124, 3, 70, "ExampleDelimiter",
 CellID->19683815],
Cell[5969, 205, 72, 1, 70, "ExampleText",
 CellID->186793146],
Cell[CellGroupData[{
Cell[6066, 210, 152, 5, 70, "Input",
 CellID->774552658],
Cell[6221, 217, 161, 5, 36, "Output",
 CellID->115973087]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6431, 228, 237, 7, 70, "ExampleSection",
 CellID->486111416],
Cell[6671, 237, 82, 1, 70, "ExampleText",
 CellID->412067263],
Cell[CellGroupData[{
Cell[6778, 242, 101, 3, 70, "Input",
 CellID->42815367],
Cell[6882, 247, 162, 5, 36, "Output",
 CellID->287493206]
}, Open  ]],
Cell[7059, 255, 125, 3, 70, "ExampleDelimiter",
 CellID->291613303],
Cell[7187, 260, 77, 1, 70, "ExampleText",
 CellID->69679226],
Cell[CellGroupData[{
Cell[7289, 265, 281, 10, 70, "Input",
 CellID->95768180],
Cell[7573, 277, 235, 10, 48, "Output",
 CellID->114825664]
}, Open  ]],
Cell[7823, 290, 125, 3, 70, "ExampleDelimiter",
 CellID->120928372],
Cell[7951, 295, 189, 8, 70, "ExampleText",
 CellID->58299015],
Cell[CellGroupData[{
Cell[8165, 307, 151, 5, 70, "Input",
 CellID->153856634],
Cell[8319, 314, 202, 7, 36, "Output",
 CellID->18216969]
}, Open  ]],
Cell[8536, 324, 125, 3, 70, "ExampleDelimiter",
 CellID->222819089],
Cell[8664, 329, 87, 1, 70, "ExampleText",
 CellID->176636187],
Cell[CellGroupData[{
Cell[8776, 334, 348, 12, 70, "Input",
 CellID->238517545],
Cell[9127, 348, 412, 16, 51, "Output",
 CellID->16409605]
}, Open  ]],
Cell[9554, 367, 219, 8, 70, "ExampleText",
 CellID->144318281],
Cell[CellGroupData[{
Cell[9798, 379, 108, 3, 70, "Input",
 CellID->334328105],
Cell[9909, 384, 161, 5, 36, "Output",
 CellID->481334373]
}, Open  ]],
Cell[10085, 392, 125, 3, 70, "ExampleDelimiter",
 CellID->417566394],
Cell[10213, 397, 73, 1, 70, "ExampleText",
 CellID->622689182],
Cell[CellGroupData[{
Cell[10311, 402, 303, 10, 70, "Input",
 CellID->521857631],
Cell[10617, 414, 415, 15, 38, "Output",
 CellID->719302821]
}, Open  ]],
Cell[11047, 432, 209, 8, 70, "ExampleText",
 CellID->853938565],
Cell[CellGroupData[{
Cell[11281, 444, 103, 3, 70, "Input",
 CellID->216212838],
Cell[11387, 449, 161, 5, 36, "Output",
 CellID->164141952]
}, Open  ]],
Cell[11563, 457, 125, 3, 70, "ExampleDelimiter",
 CellID->294889234],
Cell[11691, 462, 247, 8, 70, "ExampleText",
 CellID->739978796],
Cell[CellGroupData[{
Cell[11963, 474, 444, 14, 70, "Input",
 CellID->50825397],
Cell[12410, 490, 160, 5, 36, "Output",
 CellID->98174689]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12631, 502, 310, 9, 70, "SeeAlsoSection",
 CellID->9297],
Cell[12944, 513, 1643, 62, 70, "SeeAlso",
 CellID->8091]
}, Open  ]],
Cell[CellGroupData[{
Cell[14624, 580, 314, 9, 70, "TutorialsSection",
 CellID->10860],
Cell[14941, 591, 129, 3, 70, "Tutorials",
 CellID->21989]
}, Open  ]],
Cell[CellGroupData[{
Cell[15107, 599, 305, 8, 70, "RelatedLinksSection"],
Cell[15415, 609, 382, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15834, 627, 299, 8, 70, "MoreAboutSection"],
Cell[16136, 637, 157, 3, 70, "MoreAbout",
 CellID->247702836],
Cell[16296, 642, 149, 3, 70, "MoreAbout",
 CellID->199483968],
Cell[16448, 647, 149, 3, 70, "MoreAbout",
 CellID->867341137]
}, Open  ]],
Cell[16612, 653, 27, 0, 70, "History"],
Cell[16642, 655, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

