(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13093,        484]
NotebookOptionsPosition[     10074,        382]
NotebookOutlinePosition[     11321,        418]
CellTagsIndexPosition[     11236,        413]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conditionals" :> 
          Documentation`HelpLookup["paclet:tutorial/Conditionals"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Conditionals\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"If" :> Documentation`HelpLookup["paclet:ref/If"], "Condition" :> 
          Documentation`HelpLookup["paclet:ref/Condition"], "SameQ" :> 
          Documentation`HelpLookup["paclet:ref/SameQ"], "Boole" :> 
          Documentation`HelpLookup["paclet:ref/Boole"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"If\"\>", 2->"\<\"Condition\"\>", 
       3->"\<\"SameQ\"\>", 4->"\<\"Boole\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Testing Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TrueQ", "ObjectName",
 CellID->18413],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TrueQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TrueQ"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ", and yields ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30880]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["TrueQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrueQ"]], "InlineFormula"],
 " to \[OpenCurlyDoubleQuote]assume\[CloseCurlyDoubleQuote] that a test fails \
when its outcome is not clear. "
}], "Notes",
 CellID->31306],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["TrueQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrueQ"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["If",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/If"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], ",", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], ",", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18847]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->316522924],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->305873921],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrueQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrueQ"]], "InlineFormula"],
 " will return ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " only if the input is explicitly ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->49581741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrueQ", "[", "True", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->188695347],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->330002638]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrueQ", "[", "False", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->374261537],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->47622786]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrueQ", "[", "x", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->65418900],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->219795882]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23500],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["If",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/If"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Condition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Condition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SameQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SameQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Boole",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Boole"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6377]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4806],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Conditionals"]], "Tutorials",
 CellID->21452]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
TrueQ"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->18680027]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TrueQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 59.1781654}", "context" -> "System`", 
    "keywords" -> {"test for truth", "truth predicate", "boolean cast"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "TrueQ[expr] yields True if expr is True, and yields False otherwise. ", 
    "synonyms" -> {"true q"}, "title" -> "TrueQ", "type" -> "Symbol", "uri" -> 
    "ref/TrueQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5120, 175, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->316522924]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11093, 406}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1956, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2579, 75, 43, 1, 70, "ObjectName",
 CellID->18413],
Cell[2625, 78, 966, 33, 70, "Usage",
 CellID->30880]
}, Open  ]],
Cell[CellGroupData[{
Cell[3628, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4106, 133, 287, 9, 70, "Notes",
 CellID->31306],
Cell[4396, 144, 687, 26, 70, "Notes",
 CellID->18847]
}, Closed]],
Cell[CellGroupData[{
Cell[5120, 175, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->316522924],
Cell[CellGroupData[{
Cell[5505, 189, 148, 5, 70, "ExampleSection",
 CellID->305873921],
Cell[5656, 196, 449, 17, 70, "ExampleText",
 CellID->49581741],
Cell[CellGroupData[{
Cell[6130, 217, 104, 3, 28, "Input",
 CellID->188695347],
Cell[6237, 222, 161, 5, 36, "Output",
 CellID->330002638]
}, Open  ]],
Cell[CellGroupData[{
Cell[6435, 232, 105, 3, 28, "Input",
 CellID->374261537],
Cell[6543, 237, 161, 5, 36, "Output",
 CellID->47622786]
}, Open  ]],
Cell[CellGroupData[{
Cell[6741, 247, 100, 3, 28, "Input",
 CellID->65418900],
Cell[6844, 252, 162, 5, 36, "Output",
 CellID->219795882]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7067, 264, 311, 9, 70, "SeeAlsoSection",
 CellID->23500],
Cell[7381, 275, 918, 35, 70, "SeeAlso",
 CellID->6377]
}, Open  ]],
Cell[CellGroupData[{
Cell[8336, 315, 313, 9, 70, "TutorialsSection",
 CellID->4806],
Cell[8652, 326, 135, 3, 70, "Tutorials",
 CellID->21452]
}, Open  ]],
Cell[CellGroupData[{
Cell[8824, 334, 305, 8, 70, "RelatedLinksSection"],
Cell[9132, 344, 383, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9552, 362, 299, 8, 70, "MoreAboutSection"],
Cell[9854, 372, 148, 3, 70, "MoreAbout",
 CellID->18680027]
}, Open  ]],
Cell[10017, 378, 27, 0, 70, "History"],
Cell[10047, 380, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

