(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14526,        512]
NotebookOptionsPosition[     11684,        418]
NotebookOutlinePosition[     13003,        456]
CellTagsIndexPosition[     12918,        451]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Compress" :> Documentation`HelpLookup["paclet:ref/Compress"], 
          "ByteCount" :> Documentation`HelpLookup["paclet:ref/ByteCount"], 
          "ImportString" :> 
          Documentation`HelpLookup["paclet:ref/ImportString"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Compress\"\>", 
       2->"\<\"ByteCount\"\>", 3->"\<\"ImportString\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binary Data" :> 
          Documentation`HelpLookup["paclet:guide/BinaryData"], 
          "Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Binary Data\"\>", 
       2->"\<\"Memory Measurement & Optimization\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Uncompress", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Uncompress",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Uncompress"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]recovers an expression from a compressed string \
representation generated by ",
     Cell[BoxData[
      ButtonBox["Compress",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Compress"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->183694549],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Compress",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compress"]], "InlineFormula"],
 " a general expression: "
}], "ExampleText",
 CellID->194484706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e", "=", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"x", "^", "x"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->460679969],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "x"}]]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], 
       SuperscriptBox["x", "2"]]}], "+", 
     FractionBox["2", "x"]}], ")"}], " ", 
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}]]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Log", "[", "x", "]"}]}], ")"}], "2"]}], "+", 
  RowBox[{
   SuperscriptBox["x", "x"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Log", "[", "x", "]"}]}], ")"}], "4"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"Log", "[", "x", "]"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], "x"], "+", 
     RowBox[{"Log", "[", "x", "]"}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], "x"], "+", 
      RowBox[{"Log", "[", "x", "]"}]}], ")"}], "2"]}]}]], "Output",
 ImageSize->{422, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149136640]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Compress", "[", " ", "e", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1450575508],

Cell[BoxData["\<\"1:eJxTTMoPSmNjYGAoZgESATmlxWlMIB4rkAjJzE0tzgRxEWIB+\
eWpRcWMQFYF\\nRBCmLfPf////kSXgJqCqS2NGNR6o6z+aSf+xmIRkL9gmol2JZAF+9yPZiuZE\\\
nZiJDAKe70dSBlKSBiGKQyT756VCXovoBKezQrKXEDpCCNBbyYhjdf4QsQ4t4\\\
nfKmCYJyDYxGXFfiDi7xYoolzwUENAH/wxz8=\"\>"], "Output",
 ImageSize->{438, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10203168]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Uncompress",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Uncompress"]], "InlineFormula"],
 " it: "
}], "ExampleText",
 CellID->109488768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Uncompress", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1958890648],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "x"}]]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], 
       SuperscriptBox["x", "2"]]}], "+", 
     FractionBox["2", "x"]}], ")"}], " ", 
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}]]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Log", "[", "x", "]"}]}], ")"}], "2"]}], "+", 
  RowBox[{
   SuperscriptBox["x", "x"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Log", "[", "x", "]"}]}], ")"}], "4"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"Log", "[", "x", "]"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], "x"], "+", 
     RowBox[{"Log", "[", "x", "]"}]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "x"}], "x"], "+", 
      RowBox[{"Log", "[", "x", "]"}]}], ")"}], "2"]}]}]], "Output",
 ImageSize->{422, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->53278463]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "\[Equal]", "e"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->580165366],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->24089726]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Compress",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Compress"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ByteCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ByteCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ImportString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ImportString"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Binary Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BinaryData"]], "MoreAbout",
 CellID->221390673],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->36981840]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Uncompress - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 7.1314940}", "context" -> "System`", 
    "keywords" -> {
     "compress", "data compression", "expression compression", 
      "tree compression"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Uncompress[\"string\"] recovers an expression from a compressed string \
representation generated by Compress.", "synonyms" -> {}, "title" -> 
    "Uncompress", "type" -> "Symbol", "uri" -> "ref/Uncompress"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4485, 130, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12783, 444}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1553, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2176, 65, 1575, 37, 70, "ObjectNameGrid"],
Cell[3754, 104, 694, 21, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4485, 130, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4862, 144, 148, 5, 70, "ExampleSection",
 CellID->183694549],
Cell[5013, 151, 200, 7, 70, "ExampleText",
 CellID->194484706],
Cell[CellGroupData[{
Cell[5238, 162, 220, 8, 28, "Input",
 CellID->460679969],
Cell[5461, 172, 1614, 60, 83, "Output",
 CellID->149136640]
}, Open  ]],
Cell[CellGroupData[{
Cell[7112, 237, 110, 3, 28, "Input",
 CellID->1450575508],
Cell[7225, 242, 398, 8, 88, "Output",
 CellID->10203168]
}, Open  ]],
Cell[7638, 253, 186, 7, 70, "ExampleText",
 CellID->109488768],
Cell[CellGroupData[{
Cell[7849, 264, 107, 3, 70, "Input",
 CellID->1958890648],
Cell[7959, 269, 1613, 60, 83, "Output",
 CellID->53278463]
}, Open  ]],
Cell[CellGroupData[{
Cell[9609, 334, 99, 3, 70, "Input",
 CellID->580165366],
Cell[9711, 339, 160, 5, 36, "Output",
 CellID->24089726]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9932, 351, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[10251, 362, 710, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[10998, 393, 299, 8, 70, "MoreAboutSection"],
Cell[11300, 403, 133, 3, 70, "MoreAbout",
 CellID->221390673],
Cell[11436, 408, 176, 3, 70, "MoreAbout",
 CellID->36981840]
}, Open  ]],
Cell[11627, 414, 27, 0, 70, "History"],
Cell[11657, 416, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

