(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11633,        459]
NotebookOptionsPosition[      8050,        335]
NotebookOutlinePosition[      9378,        373]
CellTagsIndexPosition[      9294,        368]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"$MinNumber" :> 
         Documentation`HelpLookup["paclet:ref/$MinNumber"], "Overflow" :> 
         Documentation`HelpLookup["paclet:ref/Overflow"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"$MinNumber\"\>", 
      2->"\<\"Overflow\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Underflow", "ObjectName",
 CellID->29721],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Underflow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Underflow"], "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a number too small to represent explicitly \
on your computer system."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16016]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->235437],

Cell[CellGroupData[{

Cell[BoxData["$MinNumber"], "Input",
 CellLabel->"In[1]:=",
 CellID->335705389],

Cell[BoxData["5.2077239409589238546156053328`15.954589770191005*^-646456888"],\
 "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81624063]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/", "2"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->494169793],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"unfl\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Underflow occurred in \
computation.\\\\\\\"\\\", \\\"MSG\\\"]\\) \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet://Messages/General/unfl\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->214399957],

Cell[BoxData[
 RowBox[{"Underflow", "[", "]"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->438766468]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9859],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Underflow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Underflow"], "[", "]"}]], "InlineFormula"],
 " plus any approximate number gives that number:"
}], "ExampleText",
 CellID->743954797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Underflow", "[", "]"}], "+", "1."}]], "Input",
 CellLabel->"In[1]:=",
 CellID->117767187],

Cell[BoxData["1.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32389985]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10963],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Underflow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Underflow"], "[", "]"}]], "InlineFormula"],
 " is considered a ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " number:"
}], "ExampleText",
 CellID->35652809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberQ", "[", 
  RowBox[{"Underflow", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->130587875],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->350253013]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{"Underflow", "[", "]"}], ",", "_Real"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->453285862],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15567042]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83935739],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Underflow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Underflow"], "[", "]"}]], "InlineFormula"],
 " has a smaller magnitude than any explicit number:"
}], "ExampleText",
 CellID->770910811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Underflow", "[", "]"}], "<", "$MinNumber"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->175127263],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->666161855]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3989274],

Cell[TextData[{
 "The reciprocal of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Underflow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Underflow"], "[", "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Overflow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overflow"], "[", "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->123148061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"Underflow", "[", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->569339564],

Cell[BoxData[
 RowBox[{"Overflow", "[", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84001826]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2608],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MinNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MinNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Overflow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Overflow"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19974]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Underflow - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 7.7408846}", "context" -> "System`", 
    "keywords" -> {
     "underflow ", "underflowing computation", "NaN", "not a number", 
      "representable numbers", "range of numbers"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Underflow[] represents a number too small to represent explicitly on \
your computer system.", "synonyms" -> {}, "title" -> "Underflow", "type" -> 
    "Symbol", "uri" -> "ref/Underflow"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1873, 66, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9160, 361}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 667, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1290, 43, 47, 1, 70, "ObjectName",
 CellID->29721],
Cell[1340, 46, 496, 15, 70, "Usage",
 CellID->16016]
}, Open  ]],
Cell[CellGroupData[{
Cell[1873, 66, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[2250, 80, 145, 5, 70, "ExampleSection",
 CellID->235437],
Cell[CellGroupData[{
Cell[2420, 89, 79, 2, 28, "Input",
 CellID->335705389],
Cell[2502, 93, 220, 6, 36, "Output",
 CellID->81624063]
}, Open  ]],
Cell[CellGroupData[{
Cell[2759, 104, 92, 3, 70, "Input",
 CellID->494169793],
Cell[2854, 109, 381, 8, 19, "Message",
 CellID->214399957],
Cell[3238, 119, 188, 6, 36, "Output",
 CellID->438766468]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3475, 131, 215, 7, 70, "ExampleSection",
 CellID->9859],
Cell[3693, 140, 252, 8, 70, "ExampleText",
 CellID->743954797],
Cell[CellGroupData[{
Cell[3970, 152, 124, 4, 70, "Input",
 CellID->117767187],
Cell[4097, 158, 159, 5, 36, "Output",
 CellID->32389985]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[4305, 169, 233, 7, 70, "ExampleSection",
 CellID->10963],
Cell[4541, 178, 345, 13, 70, "ExampleText",
 CellID->35652809],
Cell[CellGroupData[{
Cell[4911, 195, 134, 4, 70, "Input",
 CellID->130587875],
Cell[5048, 201, 161, 5, 36, "Output",
 CellID->350253013]
}, Open  ]],
Cell[CellGroupData[{
Cell[5246, 211, 161, 5, 70, "Input",
 CellID->453285862],
Cell[5410, 218, 160, 5, 36, "Output",
 CellID->15567042]
}, Open  ]],
Cell[5585, 226, 124, 3, 70, "ExampleDelimiter",
 CellID->83935739],
Cell[5712, 231, 255, 8, 70, "ExampleText",
 CellID->770910811],
Cell[CellGroupData[{
Cell[5992, 243, 132, 4, 70, "Input",
 CellID->175127263],
Cell[6127, 249, 161, 5, 36, "Output",
 CellID->666161855]
}, Open  ]],
Cell[6303, 257, 123, 3, 70, "ExampleDelimiter",
 CellID->3989274],
Cell[6429, 262, 383, 15, 70, "ExampleText",
 CellID->123148061],
Cell[CellGroupData[{
Cell[6837, 281, 123, 4, 70, "Input",
 CellID->569339564],
Cell[6963, 287, 186, 6, 36, "Output",
 CellID->84001826]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7210, 300, 310, 9, 70, "SeeAlsoSection",
 CellID->2608],
Cell[7523, 311, 455, 17, 70, "SeeAlso",
 CellID->19974]
}, Open  ]],
Cell[7993, 331, 27, 0, 70, "History"],
Cell[8023, 333, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

