(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14791,        546]
NotebookOptionsPosition[     11607,        438]
NotebookOutlinePosition[     12835,        474]
CellTagsIndexPosition[     12750,        469]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operators without Built\[Hyphen]in Meanings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OperatorsWithoutBuiltInMeanings"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Operators without Built\[Hyphen]in Meanings\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Subsuperscript" :> 
          Documentation`HelpLookup["paclet:ref/Subsuperscript"], "Grid" :> 
          Documentation`HelpLookup["paclet:ref/Grid"], "Column" :> 
          Documentation`HelpLookup["paclet:ref/Column"], "UnderoverscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/UnderoverscriptBox"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Subsuperscript\"\>", 
       2->"\<\"Grid\"\>", 3->"\<\"Column\"\>", 
       4->"\<\"UnderoverscriptBox\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Notational Forms" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicNotationalForms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Symbolic Notational Forms\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Underoverscript", "ObjectName",
 CellID->18968],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Underoverscript",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Underoverscript"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is an object that formats as ",
     Cell[BoxData[
      UnderoverscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["y", "TI"], 
       StyleBox["z", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31926]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In a notebook an underoverscript can be created by using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["+", "KeyEvent"],
 " to move to the underscript, then ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 " to move to the overscript. ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " moves out of the underscript or overscript position. "
}], "Notes",
 CellID->24017],

Cell[TextData[{
 "Input of the form ",
 Cell[BoxData[
  UnderoverscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["y", "TI"], 
   StyleBox["z", "TI"]]], "InlineFormula"],
 " in a notebook is interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Underoverscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Underoverscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8785],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Underoverscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Underoverscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " formats as ",
 Cell[BoxData[
  UnderoverscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["y", "TI"], 
   StyleBox["z", "TI"]]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25932],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Underoverscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Underoverscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 " formats literally as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Underoverscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Underoverscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21270]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->428043755],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->251347907],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Underoverscript", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88457113],

Cell[BoxData[
 UnderoverscriptBox["x", "y", "z"]], "Output",
 ImageSize->{11, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4298525]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->73149767],

Cell[TextData[{
 "Type ",
 StyleBox["x", "InlineCode"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["&", "KeyEvent"],
 " ",
 StyleBox["z", "InlineCode"],
 " ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["%", "KeyEvent"],
 " ",
 StyleBox["y", "InlineCode"],
 " to enter directly:"
}], "ExampleText",
 CellID->278185983],

Cell[CellGroupData[{

Cell[BoxData[
 UnderoverscriptBox["x", "y", "z"]], "Input",
 CellLabel->"In[1]:=",
 CellID->162649910],

Cell[BoxData[
 UnderoverscriptBox["x", "y", "z"]], "Output",
 ImageSize->{11, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->569991923]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->362293325],

Cell[TextData[{
 "The baseline is that of ",
 Cell[BoxData["x"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->24768643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Underoverscript", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
   RowBox[{"x", "+", "y"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->391902884],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   UnderoverscriptBox["x", "y", "z"], ",", 
   RowBox[{"x", "+", "y"}]}], "}"}]], "Output",
 ImageSize->{63, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->61164242]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18536],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subsuperscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsuperscript"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Grid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Column",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Column"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnderoverscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnderoverscriptBox"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3461]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27894],

Cell[TextData[ButtonBox["Operators without Built\[Hyphen]in Meanings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OperatorsWithoutBuiltInMeanings"]], "Tutorials",\

 CellID->28615]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Symbolic Notational Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicNotationalForms"]], "MoreAbout",
 CellID->134105806]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Underoverscript - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 9.0690436}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Underoverscript[x, y, z] is an object that formats as \
UnderoverscriptBox[x, y, z]. ", "synonyms" -> {}, "title" -> 
    "Underoverscript", "type" -> "Symbol", "uri" -> "ref/Underoverscript"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6640, 230, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->428043755]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12607, 462}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2161, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2784, 80, 53, 1, 70, "ObjectName",
 CellID->18968],
Cell[2840, 83, 736, 24, 70, "Usage",
 CellID->31926]
}, Open  ]],
Cell[CellGroupData[{
Cell[3613, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4091, 129, 528, 15, 70, "Notes",
 CellID->24017],
Cell[4622, 146, 502, 19, 70, "Notes",
 CellID->8785],
Cell[5127, 167, 738, 28, 70, "Notes",
 CellID->25932],
Cell[5868, 197, 735, 28, 70, "Notes",
 CellID->21270]
}, Closed]],
Cell[CellGroupData[{
Cell[6640, 230, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->428043755],
Cell[CellGroupData[{
Cell[7025, 244, 148, 5, 70, "ExampleSection",
 CellID->251347907],
Cell[CellGroupData[{
Cell[7198, 253, 143, 4, 28, "Input",
 CellID->88457113],
Cell[7344, 259, 188, 6, 48, "Output",
 CellID->4298525]
}, Open  ]],
Cell[7547, 268, 124, 3, 70, "ExampleDelimiter",
 CellID->73149767],
Cell[7674, 273, 393, 17, 70, "ExampleText",
 CellID->278185983],
Cell[CellGroupData[{
Cell[8092, 294, 102, 3, 39, "Input",
 CellID->162649910],
Cell[8197, 299, 190, 6, 48, "Output",
 CellID->569991923]
}, Open  ]],
Cell[8402, 308, 125, 3, 70, "ExampleDelimiter",
 CellID->362293325],
Cell[8530, 313, 125, 5, 70, "ExampleText",
 CellID->24768643],
Cell[CellGroupData[{
Cell[8680, 322, 217, 7, 70, "Input",
 CellID->391902884],
Cell[8900, 331, 260, 9, 48, "Output",
 CellID->61164242]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9221, 347, 311, 9, 70, "SeeAlsoSection",
 CellID->18536],
Cell[9535, 358, 960, 35, 70, "SeeAlso",
 CellID->3461]
}, Open  ]],
Cell[CellGroupData[{
Cell[10532, 398, 314, 9, 70, "TutorialsSection",
 CellID->27894],
Cell[10849, 409, 187, 4, 70, "Tutorials",
 CellID->28615]
}, Open  ]],
Cell[CellGroupData[{
Cell[11073, 418, 299, 8, 70, "MoreAboutSection"],
Cell[11375, 428, 160, 3, 70, "MoreAbout",
 CellID->134105806]
}, Open  ]],
Cell[11550, 434, 27, 0, 70, "History"],
Cell[11580, 436, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

