(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25105,        847]
NotebookOptionsPosition[     21053,        711]
NotebookOutlinePosition[     22369,        748]
CellTagsIndexPosition[     22284,        743]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Representing Textual Forms by Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RepresentingTextualFormsByBoxes"], 
          "String Representation of Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StringRepresentationOfBoxes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Representing Textual Forms by Boxes\"\>", 
       2->"\<\"String Representation of Boxes\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Underscript" :> 
          Documentation`HelpLookup["paclet:ref/Underscript"], "OverscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/OverscriptBox"], 
          "UnderoverscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/UnderoverscriptBox"], 
          "SubscriptBox" :> 
          Documentation`HelpLookup["paclet:ref/SubscriptBox"], "GridBox" :> 
          Documentation`HelpLookup["paclet:ref/GridBox"], 
          "ScriptSizeMultipliers" :> 
          Documentation`HelpLookup["paclet:ref/ScriptSizeMultipliers"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Underscript\"\>", 
       2->"\<\"OverscriptBox\"\>", 3->"\<\"UnderoverscriptBox\"\>", 
       4->"\<\"SubscriptBox\"\>", 5->"\<\"GridBox\"\>", 
       6->"\<\"ScriptSizeMultipliers\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Structure" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookStructure"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Structure\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["UnderscriptBox", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["UnderscriptBox",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/UnderscriptBox"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is the low\[Hyphen]level box representation for ",
     Cell[BoxData[
      UnderscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["y", "TI"]]], "InlineFormula"],
     " in notebook expressions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13947]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["UnderscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnderscriptBox"]], "InlineFormula"],
 " is the low-level representation of ",
 Cell[BoxData[
  ButtonBox["Underscript",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Underscript"]], "InlineFormula"],
 ". Except for low-level notebook expression manipulation, ",
 Cell[BoxData[
  ButtonBox["UnderscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnderscriptBox"]], "InlineFormula"],
 " should not need to be used directly."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->6361],

Cell[TextData[{
 "Inside ",
 Cell["\\(\[Ellipsis]\\)", "InlineFormula"],
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["UnderscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnderscriptBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " can be input as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\\+", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->28928],

Cell[TextData[{
 "In a notebook, an ",
 Cell[BoxData[
  ButtonBox["UnderscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnderscriptBox"]], "InlineFormula"],
 " can be created using ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["+", "KeyEvent"],
 ". ",
 StyleBox["Ctrl", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Space", "KeyEvent"],
 " moves out of the underscript position. "
}], "Notes",
 CellID->3959],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["UnderscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnderscriptBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " is interpreted on input as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Underscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Underscript"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4415],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["UnderscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnderscriptBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", "\"\<_\>\""}], "]"}]], "InlineFormula"],
 " is interpreted as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["UnderBar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnderBar"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  UnderscriptBox[
   StyleBox["x", "TI"], "_"]], "InlineFormula"],
 ". The input form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\\&", 
   RowBox[{"\\%", "-"}]}]], "InlineFormula"],
 " can be used. "
}], "Notes",
 CellID->16016],

Cell[TextData[{
 "The baseline of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["UnderscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnderscriptBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " is taken to be the baseline of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["UnderscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnderscriptBox"], "[", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
 " is usually output with ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " in a smaller font than ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31466],

Cell[TextData[{
 "With the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LimitsPositioning",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LimitsPositioning"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " is placed in an underscript position when the whole ",
 Cell[BoxData[
  ButtonBox["UnderscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnderscriptBox"]], "InlineFormula"],
 " is displayed large, and in a subscript position when it is displayed \
smaller. "
}], "Notes",
 CellID->14662],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", explicit ",
 Cell[BoxData[
  ButtonBox["UnderscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnderscriptBox"]], "InlineFormula"],
 " objects are output literally. You can use ",
 Cell[BoxData[
  ButtonBox["DisplayForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayForm"]], "InlineFormula"],
 " to see the display form of such objects. "
}], "Notes",
 CellID->27292]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->321277660],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->263879559],

Cell["Display a letter with an underscript:", "ExampleText",
 CellID->110280404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UnderscriptBox", "[", 
   RowBox[{"\"\<x\>\"", ",", "\"\<0\>\""}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177567825],

Cell[BoxData[
 TagBox[
  UnderscriptBox["x", "0"],
  DisplayForm]], "Output",
 ImageSize->{11, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->185636134]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->292428007],

Cell[TextData[{
 "An ",
 Cell[BoxData[
  ButtonBox["UnderscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnderscriptBox"]], "InlineFormula"],
 " form is typically interpreted as an ",
 Cell[BoxData[
  ButtonBox["Underscript",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Underscript"]], "InlineFormula"],
 " expression:"
}], "ExampleText",
 CellID->449017820],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{
   RowBox[{"UnderscriptBox", "[", 
    RowBox[{"\"\<x\>\"", ",", "\"\<0\>\""}], "]"}], ",", "StandardForm"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27669645],

Cell[BoxData[
 UnderscriptBox["x", "0"]], "Output",
 ImageSize->{11, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136542216]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FullForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25362379],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Underscript", "[", 
    RowBox[{"x", ",", "0"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->526402016]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->243599250],

Cell[TextData[{
 "The standard formatting for ",
 Cell[BoxData[
  ButtonBox["Underscript",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Underscript"]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["UnderscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnderscriptBox"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->85956211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToBoxes", "[", 
   RowBox[{
    RowBox[{"Underscript", "[", 
     RowBox[{"x", ",", "0"}], "]"}], ",", "StandardForm"}], "]"}], "//", 
  "FullForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35539747],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"UnderscriptBox", "[", 
    RowBox[{"\"\<x\>\"", ",", "\"\<0\>\""}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{170, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->98230245]
}, Open  ]],

Cell["The formatted result looks like this:", "ExampleText",
 CellID->108907752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Underscript", "[", 
  RowBox[{"x", ",", "0"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14089127],

Cell[BoxData[
 UnderscriptBox["x", "0"]], "Output",
 ImageSize->{11, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->135103628]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31188],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Underscript",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Underscript"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OverscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OverscriptBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnderoverscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnderoverscriptBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SubscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubscriptBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GridBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GridBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScriptSizeMultipliers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScriptSizeMultipliers"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30073]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26058],

Cell[TextData[ButtonBox["Representing Textual Forms by Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepresentingTextualFormsByBoxes"]], "Tutorials",\

 CellID->2398],

Cell[TextData[ButtonBox["String Representation of Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringRepresentationOfBoxes"]], "Tutorials",
 CellID->187054374]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookStructure"]], "MoreAbout",
 CellID->161892295]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"UnderscriptBox - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 9.3034246}", "context" -> "System`", 
    "keywords" -> {"below", "underneath", "underscript"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "UnderscriptBox[x, y] is the low-level box representation for \
UnderscriptBox[\"x\", \"y\"] in notebook expressions. ", 
    "synonyms" -> {"underscript box"}, "title" -> "UnderscriptBox", "type" -> 
    "Symbol", "uri" -> "ref/UnderscriptBox"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13802, 417, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->321277660]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22140, 736}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2655, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3278, 89, 4198, 83, 70, "ObjectNameGrid"],
Cell[7479, 174, 709, 22, 70, "Usage",
 CellID->13947]
}, Open  ]],
Cell[CellGroupData[{
Cell[8225, 201, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8703, 218, 704, 20, 70, "Notes",
 CellID->6361],
Cell[9410, 240, 465, 19, 70, "Notes",
 CellID->28928],
Cell[9878, 261, 471, 16, 70, "Notes",
 CellID->3959],
Cell[10352, 279, 674, 26, 70, "Notes",
 CellID->4415],
Cell[11029, 307, 688, 26, 70, "Notes",
 CellID->16016],
Cell[11720, 335, 390, 15, 70, "Notes",
 CellID->15],
Cell[12113, 352, 450, 17, 70, "Notes",
 CellID->31466],
Cell[12566, 371, 651, 21, 70, "Notes",
 CellID->14662],
Cell[13220, 394, 545, 18, 70, "Notes",
 CellID->27292]
}, Closed]],
Cell[CellGroupData[{
Cell[13802, 417, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->321277660],
Cell[CellGroupData[{
Cell[14187, 431, 148, 5, 70, "ExampleSection",
 CellID->263879559],
Cell[14338, 438, 80, 1, 70, "ExampleText",
 CellID->110280404],
Cell[CellGroupData[{
Cell[14443, 443, 187, 6, 28, "Input",
 CellID->177567825],
Cell[14633, 451, 220, 8, 58, "Output",
 CellID->185636134]
}, Open  ]],
Cell[14868, 462, 125, 3, 70, "ExampleDelimiter",
 CellID->292428007],
Cell[14996, 467, 376, 13, 70, "ExampleText",
 CellID->449017820],
Cell[CellGroupData[{
Cell[15397, 484, 227, 7, 70, "Input",
 CellID->27669645],
Cell[15627, 493, 181, 6, 44, "Output",
 CellID->136542216]
}, Open  ]],
Cell[CellGroupData[{
Cell[15845, 504, 99, 3, 70, "Input",
 CellID->25362379],
Cell[15947, 509, 354, 13, 50, "Output",
 CellID->526402016]
}, Open  ]],
Cell[16316, 525, 125, 3, 70, "ExampleDelimiter",
 CellID->243599250],
Cell[16444, 530, 359, 13, 70, "ExampleText",
 CellID->85956211],
Cell[CellGroupData[{
Cell[16828, 547, 237, 8, 70, "Input",
 CellID->35539747],
Cell[17068, 557, 372, 13, 50, "Output",
 CellID->98230245]
}, Open  ]],
Cell[17455, 573, 80, 1, 70, "ExampleText",
 CellID->108907752],
Cell[CellGroupData[{
Cell[17560, 578, 129, 4, 70, "Input",
 CellID->14089127],
Cell[17692, 584, 181, 6, 44, "Output",
 CellID->135103628]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17934, 597, 311, 9, 70, "SeeAlsoSection",
 CellID->31188],
Cell[18248, 608, 1499, 53, 70, "SeeAlso",
 CellID->30073]
}, Open  ]],
Cell[CellGroupData[{
Cell[19784, 666, 314, 9, 70, "TutorialsSection",
 CellID->26058],
Cell[20101, 677, 178, 4, 70, "Tutorials",
 CellID->2398],
Cell[20282, 683, 172, 3, 70, "Tutorials",
 CellID->187054374]
}, Open  ]],
Cell[CellGroupData[{
Cell[20491, 691, 299, 8, 70, "MoreAboutSection"],
Cell[20793, 701, 165, 3, 70, "MoreAbout",
 CellID->161892295]
}, Open  ]],
Cell[20973, 707, 50, 0, 70, "History"],
Cell[21026, 709, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

