(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     50709,       2034]
NotebookOptionsPosition[     38310,       1594]
NotebookOutlinePosition[     39602,       1631]
CellTagsIndexPosition[     39516,       1626]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Relational and Logical Operators" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RelationalAndLogicalOperators"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Relational and Logical Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Equal" :> Documentation`HelpLookup["paclet:ref/Equal"], 
          "UnsameQ" :> Documentation`HelpLookup["paclet:ref/UnsameQ"], 
          "Order" :> Documentation`HelpLookup["paclet:ref/Order"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Equal\"\>", 2->"\<\"UnsameQ\"\>", 
       3->"\<\"Order\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Inequalities" :> 
          Documentation`HelpLookup["paclet:guide/Inequalities"], 
          "Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Inequalities\"\>", 
       2->"\<\"Logic & Boolean Algebra\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Unequal ",
 StyleBox["(!=, \[NotEqual])", "OperatorCharacter"]
}], "ObjectName",
 CellID->3023],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], "!=", 
       StyleBox["rhs", "TI"]}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], "\[NotEqual]", 
       StyleBox["rhs", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]",
     "returns ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " are identical. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19251]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "\[NotEqual]", "y"}], TraditionalForm]], "InlineMath"],
 " can be entered as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], 
   ButtonBox[
    RowBox[{"\[Backslash]", 
     RowBox[{"[", "NotEqual", "]"}]}],
    BaseStyle->"Link",
    ButtonData->"paclet:ref/character/NotEqual"], 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]!=\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->1578],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "\[NotEqual]", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " if ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["rhs", "TI"]], "InlineFormula"],
 " are determined to be unequal by comparisons between numbers or other raw \
data, such as strings. "
}], "Notes",
 CellID->398],

Cell["\<\
Approximate numbers are considered unequal if they differ beyond their last \
two decimal digits. \
\>", "Notes",
 CellID->886],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["e", "1"], "\[NotEqual]", 
    SubscriptBox["e", "2"], "\[NotEqual]", 
    SubscriptBox["e", "3"], "\[NotEqual]", "\[Ellipsis]"}], TraditionalForm]],
   "InlineMath"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " only if none of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are equal. ",
 Cell[BoxData[
  RowBox[{"2", "\[NotEqual]", "3", "\[NotEqual]", 
   RowBox[{"2", "\[LongRightArrow]", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"]}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30388],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "TI"], "\[NotEqual]", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " represents a symbolic condition that can be generated and manipulated by \
functions like ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29321],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Unequal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unequal"], "[", 
   StyleBox["e", "TI"], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32011],

Cell[TextData[{
 "For exact numeric quantities, ",
 Cell[BoxData[
  ButtonBox["Unequal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unequal"]], "InlineFormula"],
 " internally uses numerical approximations to establish inequality. This \
process can be affected by the setting of the global variable ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10100],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Unequal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unequal"]], "InlineFormula"],
 " is printed using ",
 Cell[BoxData["\[NotEqual]"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16028]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->376228561],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->143529634],

Cell[TextData[{
 "Returns ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " if elements are guaranteed unequal, otherwise stays unevaluated:"
}], "ExampleText",
 CellID->41214196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "\[NotEqual]", " ", "b"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->397152620],

Cell[BoxData[
 RowBox[{"a", "\[NotEqual]", "b"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->280341965]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->650165687],

Cell[TextData[{
 "Enter as ",
 Cell[BoxData["!="], "InlineCode"],
 " or as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]!=\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 ":"
}], "ExampleText",
 CellID->128762337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "\[NotEqual]", "2"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->82581679],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->229561265]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->142508816],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Numeric Inequations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->542357724],

Cell["Test unequality of numbers:", "ExampleText",
 CellID->234143528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"3", "/", "2"}], "\[NotEqual]", 
  RowBox[{"5", "/", "3"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->241292235],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->96950255]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4163503],

Cell["\<\
Approximate numbers that differ in at most their last eight binary digits are \
considered equal:\
\>", "ExampleText",
 CellID->580861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.", "\[NotEqual]", " ", 
  RowBox[{"1.", "+", 
   RowBox[{
    RowBox[{"2", "^", "7"}], " ", 
    RowBox[{"10", "^", 
     RowBox[{"-", "16"}]}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37738947],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->904910655]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1.", "\[NotEqual]", " ", 
  RowBox[{"1.", "+", 
   RowBox[{
    RowBox[{"2", "^", "8"}], " ", 
    RowBox[{"10", "^", 
     RowBox[{"-", "16"}]}]}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->525645198],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->64596125]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->106392735],

Cell["\<\
Compare an exact numeric expression and an approximate number:\
\>", "ExampleText",
 CellID->427000590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"Pi", ",", "20"}], "]"}], "\[NotEqual]", "Pi"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315310371],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51828234]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"Pi", ",", "20"}], "]"}], "\[NotEqual]", 
  RowBox[{"Pi", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"2", "^", "8"}], " ", 
      RowBox[{"10", "^", 
       RowBox[{"-", "20"}]}]}]}], ")"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->331846797],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->219620812]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->641060601],

Cell["\<\
Compare two exact numeric expressions; a numeric test may suffice to prove \
unequality:\
\>", "ExampleText",
 CellID->128181167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Pi", "^", "E"}], "\[NotEqual]", 
  RowBox[{"E", "^", "Pi"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->398884990],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->133088926]
}, Open  ]],

Cell["Proving equality requires symbolic methods:", "ExampleText",
 CellID->207797078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "\[NotEqual]", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"5", "+", 
    RowBox[{"2", 
     RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->142094998],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->385991702]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->541739225],

Cell[TextData[{
 "Symbolic methods used by ",
 Cell[BoxData["Unqual"], "InlineFormula"],
 " are insufficient to prove this ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->135341977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "\[NotEqual]", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "4"}], "-", 
      RowBox[{"10", 
       RowBox[{"#", "^", "2"}]}], "+", "1"}], "&"}], ",", "4"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180221533],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}], "\[NotEqual]", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}]], "Output",
 ImageSize->{238, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->540891697]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " to decide whether two algebraic numbers are unequal:"
}], "ExampleText",
 CellID->299920545],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->195979928],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->42964794]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->442793288],

Cell[TextData[{
 "Numeric methods used by ",
 Cell[BoxData["Unqual"], "InlineFormula"],
 " do not use sufficient precision to prove this unequality:"
}], "ExampleText",
 CellID->192423184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], "+", 
   RowBox[{"Sqrt", "[", "3", "]"}]}], "\[NotEqual]", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "4"}], "-", 
       RowBox[{"10", 
        RowBox[{"#", "^", "2"}]}], "+", "1"}], "&"}], ",", "4"}], "]"}], "+", 
   
   RowBox[{"10", "^", 
    RowBox[{"-", "100"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1546846],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}], "\[NotEqual]", 
  RowBox[{
   RowBox[{
   "1", "/", 
    "1000000000000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000"}], "+", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]}]}]], "Output",
 ImageSize->{557, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->282067716]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " proves that the two algebraic numbers are not equal:"
}], "ExampleText",
 CellID->384720156],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->476886642],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->474883134]
}, Open  ]],

Cell[TextData[{
 "Increasing ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " may also allow to prove unequality:"
}], "ExampleText",
 CellID->321641904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "100"}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "\[NotEqual]", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"#", "^", "4"}], "-", 
         RowBox[{"10", 
          RowBox[{"#", "^", "2"}]}], "+", "1"}], "&"}], ",", "4"}], "]"}], 
     "+", 
     RowBox[{"10", "^", 
      RowBox[{"-", "100"}]}]}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1018235179],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->53412918]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Symbolic Inequations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->187826453],

Cell[TextData[{
 "This symbolic unequality is always ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->152622296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "\[NotEqual]", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148403671],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->404181852]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->274557276],

Cell[TextData[{
 Cell[BoxData["Unqual"], "InlineFormula"],
 " does not automatically prove this unequality:"
}], "ExampleText",
 CellID->178777735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], "^", "2"}], "-", 
   RowBox[{"x", "^", "2"}], "-", 
   RowBox[{"2", "x"}]}], "\[NotEqual]", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150821115],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", "x"}], "-", 
   SuperscriptBox["x", "2"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "2"]}], "\[NotEqual]", "0"}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->370673300]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " to prove it:"
}], "ExampleText",
 CellID->21217920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->128820129],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->576001312]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13348445],

Cell["Compare more than two expressions:", "ExampleText",
 CellID->220377043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"3", "\[NotEqual]", " ", "4", "\[NotEqual]", "5"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213227638],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24099146]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "\[NotEqual]", "y", "\[NotEqual]", "z", "\[NotEqual]", 
  "t"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->534296793],

Cell[BoxData[
 RowBox[{"x", "\[NotEqual]", "y", "\[NotEqual]", "z", "\[NotEqual]", 
  "t"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1515993]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29051742],

Cell["Compare lists:", "ExampleText",
 CellID->503856903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}], "\[NotEqual]", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->632197901],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112027519]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "\[NotEqual]", 
  RowBox[{"{", 
   RowBox[{"d", ",", "e"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3372],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->64274530]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->627476549],

Cell["Compare strings:", "ExampleText",
 CellID->51853218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<abc\>\"", "\[NotEqual]", "\"\<ABC\>\""}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27021],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22151708]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->76839780],

Cell[TextData[{
 "The negation of two-argument ",
 Cell[BoxData[
  ButtonBox["Unequal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unequal"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14000026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Not", "[", 
  RowBox[{"x", "\[NotEqual]", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->785552779],

Cell[BoxData[
 RowBox[{"x", "\[Equal]", "y"}]], "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81127830]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->85848563],

Cell[TextData[{
 "The negation of three-argument ",
 Cell[BoxData[
  ButtonBox["Unequal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unequal"]], "InlineFormula"],
 " does not simplify automatically:"
}], "ExampleText",
 CellID->179461278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Not", "[", 
  RowBox[{"x", "\[NotEqual]", "y", "\[NotEqual]", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->900203775],

Cell[BoxData[
 RowBox[{"!", 
  RowBox[{"x", "\[NotEqual]", "y", "\[NotEqual]", "z"}]}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->136260768]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LogicalExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogicalExpand"]], "InlineFormula"],
 " to express it in terms of two-argument ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->103307650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->602057068],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "\[Equal]", "x"}], "||", 
  RowBox[{"z", "\[Equal]", "x"}], "||", 
  RowBox[{"z", "\[Equal]", "y"}]}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->417557039]
}, Open  ]],

Cell[TextData[{
 "The negation of three argument ",
 Cell[BoxData[
  ButtonBox["Unequal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unequal"]], "InlineFormula"],
 " is not equivalent to three-argument ",
 Cell[BoxData[
  ButtonBox["Equal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Equal"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22272967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogicalExpand", "[", 
  RowBox[{"x", "==", "y", "==", "z"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->41719149],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "\[Equal]", "x"}], "&&", 
  RowBox[{"z", "\[Equal]", "x"}]}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->254175879]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->316001907],

Cell[TextData[{
 Cell[BoxData["Unqual"], "InlineFormula"],
 " test mathematical unequality of objects represented by expressions:"
}], "ExampleText",
 CellID->168215740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[NotEqual]", "x"}], ",", 
   RowBox[{"x", "\[NotEqual]", "y"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "\[NotEqual]", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"5", "+", 
      RowBox[{"2", 
       RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}]}], ",", 
   RowBox[{"Pi", "\[NotEqual]", 
    RowBox[{"N", "[", "Pi", "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->284729538],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", 
   RowBox[{"x", "\[NotEqual]", "y"}], ",", "False", ",", "False"}], 
  "}"}]], "Output",
 ImageSize->{185, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->401144143]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["UnsameQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnsameQ"]], "InlineFormula"],
 " tests syntactic unequality of expressions:"
}], "ExampleText",
 CellID->29005565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "=!=", "x"}], ",", 
   RowBox[{"x", "=!=", "y"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "=!=", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"5", "+", 
      RowBox[{"2", 
       RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}]}], ",", 
   RowBox[{"Pi", "=!=", 
    RowBox[{"N", "[", "Pi", "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->328203001],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->171689277]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->279681439],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["Unequal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unequal"]], "InlineFormula"],
 " cannot decide whether two numeric expressions are equal it returns \
unchanged:"
}], "ExampleText",
 CellID->294478095],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"Log", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{"5", "+", 
      RowBox[{"2", 
       RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}], "/", "2"}]}], 
  ";"}], "\n", 
 RowBox[{"a", "\[NotEqual]", "b"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->174240470],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"]}], "]"}], "\[NotEqual]", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"5", "+", 
     RowBox[{"2", " ", 
      SqrtBox["6"]}]}], "]"}]}]}]], "Output",
 ImageSize->{216, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26014745]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " uses exact symbolic transformations to disprove the unequality:"
}], "ExampleText",
 CellID->631563206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"a", "\[NotEqual]", "b"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106030961],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->423775818]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PossibleZeroQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PossibleZeroQ"]], "InlineFormula"],
 " uses numeric and symbolic heuristics to decide whether an expression is \
zero:"
}], "ExampleText",
 CellID->157871522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PossibleZeroQ", "[", 
  RowBox[{"a", "-", "b"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->13995468],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->73703785]
}, Open  ]],

Cell[TextData[{
 "Numeric methods used by ",
 Cell[BoxData[
  ButtonBox["PossibleZeroQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PossibleZeroQ"]], "InlineFormula"],
 " may incorrectly decide that a number is zero:"
}], "ExampleText",
 CellID->361325790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PossibleZeroQ", "[", 
  RowBox[{"a", "-", "b", "+", 
   RowBox[{"10", "^", 
    RowBox[{"-", "100"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->70253842],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->165407067]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->464709557],

Cell["\<\
Unequality for machine precision approximate numbers can be subtle: \
\>", "ExampleText",
 CellID->61699174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.00006", "-", "2.00005"}], "\[NotEqual]", "0.00001"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107589248],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->293978937]
}, Open  ]],

Cell["The extra digits disrupt equality:", "ExampleText",
 CellID->454896623],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.00006", "-", "2.00005"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->385657575],

Cell["0.000010000000000065512", "Output",
 ImageSize->{161, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->354410719]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->678662024],

Cell["\<\
Arbitrary precision approximate numbers do not have this problem:\
\>", "ExampleText",
 CellID->29032653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.00006`16", "-", "2.00005`16"}], "\[NotEqual]", 
  "0.00001`16"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108479341],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->374990560]
}, Open  ]],

Cell[TextData[{
 "Thanks to automatic precision tracking ",
 Cell[BoxData[
  ButtonBox["Unequal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unequal"]], "InlineFormula"],
 " knows to look only at the first ten digits:"
}], "ExampleText",
 CellID->446345418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", 
  RowBox[{"2.00006`16", "-", "2.00005`16"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->501825511],

Cell[BoxData["10.397928065738002`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->375837034]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->476721982],

Cell["\<\
In this case, the unequality test for machine numbers gives the expected \
result:\
\>", "ExampleText",
 CellID->693243942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.6", "-", "2.5"}], "\[NotEqual]", "0.1"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->544352754],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10992345]
}, Open  ]],

Cell[TextData[{
 "The extra digits in this case are ignored by ",
 Cell[BoxData[
  ButtonBox["Unequal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unequal"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->153335021],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"2.6", "-", "2.5"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->551042265],

Cell["0.10000000000000009", "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->208546260]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12953],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Equal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Equal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnsameQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnsameQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Order",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Order"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12059]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6509],

Cell[TextData[ButtonBox["Relational and Logical Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RelationalAndLogicalOperators"]], "Tutorials",
 CellID->15822]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->2089066],

Cell[TextData[ButtonBox["Inequalities",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Inequalities"]], "MoreAbout",
 CellID->13221541],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->154127445]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Unequal (!=, \[NotEqual]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 15.1473242}", "context" -> "System`", 
    "keywords" -> {
     "inequality", "not-equal", "not equal", "unequal", "inequation"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "lhs != rhs or lhs != rhs returns False if lhs and rhs are identical. ", 
    "synonyms" -> {"!=", "~="}, "title" -> "Unequal", "type" -> "Symbol", 
    "uri" -> "ref/Unequal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8047, 291, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->376228561]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 39373, 1619}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2074, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2697, 77, 113, 4, 70, "ObjectName",
 CellID->3023],
Cell[2813, 83, 846, 30, 70, "Usage",
 CellID->19251]
}, Open  ]],
Cell[CellGroupData[{
Cell[3696, 118, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4174, 135, 687, 26, 70, "Notes",
 CellID->1578],
Cell[4864, 163, 522, 19, 70, "Notes",
 CellID->398],
Cell[5389, 184, 137, 4, 70, "Notes",
 CellID->886],
Cell[5529, 190, 751, 27, 70, "Notes",
 CellID->30388],
Cell[6283, 219, 515, 18, 70, "Notes",
 CellID->29321],
Cell[6801, 239, 341, 14, 70, "Notes",
 CellID->32011],
Cell[7145, 255, 482, 14, 70, "Notes",
 CellID->10100],
Cell[7630, 271, 380, 15, 70, "Notes",
 CellID->16028]
}, Closed]],
Cell[CellGroupData[{
Cell[8047, 291, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->376228561],
Cell[CellGroupData[{
Cell[8432, 305, 148, 5, 70, "ExampleSection",
 CellID->143529634],
Cell[8583, 312, 246, 8, 70, "ExampleText",
 CellID->41214196],
Cell[CellGroupData[{
Cell[8854, 324, 107, 3, 28, "Input",
 CellID->397152620],
Cell[8964, 329, 190, 6, 36, "Output",
 CellID->280341965]
}, Open  ]],
Cell[9169, 338, 125, 3, 70, "ExampleDelimiter",
 CellID->650165687],
Cell[9297, 343, 236, 9, 70, "ExampleText",
 CellID->128762337],
Cell[CellGroupData[{
Cell[9558, 356, 101, 3, 70, "Input",
 CellID->82581679],
Cell[9662, 361, 161, 5, 36, "Output",
 CellID->229561265]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9872, 372, 221, 7, 70, "ExampleSection",
 CellID->142508816],
Cell[CellGroupData[{
Cell[10118, 383, 240, 7, 70, "ExampleSubsection",
 CellID->542357724],
Cell[10361, 392, 70, 1, 70, "ExampleText",
 CellID->234143528],
Cell[CellGroupData[{
Cell[10456, 397, 148, 5, 70, "Input",
 CellID->241292235],
Cell[10607, 404, 160, 5, 36, "Output",
 CellID->96950255]
}, Open  ]],
Cell[10782, 412, 123, 3, 70, "ExampleDelimiter",
 CellID->4163503],
Cell[10908, 417, 145, 4, 70, "ExampleText",
 CellID->580861],
Cell[CellGroupData[{
Cell[11078, 425, 228, 8, 70, "Input",
 CellID->37738947],
Cell[11309, 435, 162, 5, 36, "Output",
 CellID->904910655]
}, Open  ]],
Cell[CellGroupData[{
Cell[11508, 445, 229, 8, 70, "Input",
 CellID->525645198],
Cell[11740, 455, 160, 5, 36, "Output",
 CellID->64596125]
}, Open  ]],
Cell[11915, 463, 125, 3, 70, "ExampleDelimiter",
 CellID->106392735],
Cell[12043, 468, 113, 3, 70, "ExampleText",
 CellID->427000590],
Cell[CellGroupData[{
Cell[12181, 475, 157, 5, 70, "Input",
 CellID->315310371],
Cell[12341, 482, 161, 5, 36, "Output",
 CellID->51828234]
}, Open  ]],
Cell[CellGroupData[{
Cell[12539, 492, 329, 12, 70, "Input",
 CellID->331846797],
Cell[12871, 506, 161, 5, 36, "Output",
 CellID->219620812]
}, Open  ]],
Cell[13047, 514, 125, 3, 70, "ExampleDelimiter",
 CellID->641060601],
Cell[13175, 519, 139, 4, 70, "ExampleText",
 CellID->128181167],
Cell[CellGroupData[{
Cell[13339, 527, 150, 5, 70, "Input",
 CellID->398884990],
Cell[13492, 534, 161, 5, 36, "Output",
 CellID->133088926]
}, Open  ]],
Cell[13668, 542, 86, 1, 70, "ExampleText",
 CellID->207797078],
Cell[CellGroupData[{
Cell[13779, 547, 298, 10, 70, "Input",
 CellID->142094998],
Cell[14080, 559, 162, 5, 36, "Output",
 CellID->385991702]
}, Open  ]],
Cell[14257, 567, 125, 3, 70, "ExampleDelimiter",
 CellID->541739225],
Cell[14385, 572, 282, 10, 70, "ExampleText",
 CellID->135341977],
Cell[CellGroupData[{
Cell[14692, 586, 382, 14, 70, "Input",
 CellID->180221533],
Cell[15077, 602, 438, 16, 41, "Output",
 CellID->540891697]
}, Open  ]],
Cell[15530, 621, 243, 8, 70, "ExampleText",
 CellID->299920545],
Cell[CellGroupData[{
Cell[15798, 633, 106, 3, 70, "Input",
 CellID->195979928],
Cell[15907, 638, 161, 5, 36, "Output",
 CellID->42964794]
}, Open  ]],
Cell[16083, 646, 125, 3, 70, "ExampleDelimiter",
 CellID->442793288],
Cell[16211, 651, 188, 5, 70, "ExampleText",
 CellID->192423184],
Cell[CellGroupData[{
Cell[16424, 660, 457, 17, 70, "Input",
 CellID->1546846],
Cell[16884, 679, 603, 21, 75, "Output",
 CellID->282067716]
}, Open  ]],
Cell[17502, 703, 234, 7, 70, "ExampleText",
 CellID->384720156],
Cell[CellGroupData[{
Cell[17761, 714, 106, 3, 70, "Input",
 CellID->476886642],
Cell[17870, 719, 161, 5, 36, "Output",
 CellID->474883134]
}, Open  ]],
Cell[18046, 727, 249, 8, 70, "ExampleText",
 CellID->321641904],
Cell[CellGroupData[{
Cell[18320, 739, 612, 21, 70, "Input",
 CellID->1018235179],
Cell[18935, 762, 160, 5, 36, "Output",
 CellID->53412918]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19144, 773, 241, 7, 70, "ExampleSubsection",
 CellID->187826453],
Cell[19388, 782, 212, 8, 70, "ExampleText",
 CellID->152622296],
Cell[CellGroupData[{
Cell[19625, 794, 102, 3, 70, "Input",
 CellID->148403671],
Cell[19730, 799, 162, 5, 36, "Output",
 CellID->404181852]
}, Open  ]],
Cell[19907, 807, 125, 3, 70, "ExampleDelimiter",
 CellID->274557276],
Cell[20035, 812, 147, 4, 70, "ExampleText",
 CellID->178777735],
Cell[CellGroupData[{
Cell[20207, 820, 253, 9, 70, "Input",
 CellID->150821115],
Cell[20463, 831, 369, 13, 36, "Output",
 CellID->370673300]
}, Open  ]],
Cell[20847, 847, 194, 8, 70, "ExampleText",
 CellID->21217920],
Cell[CellGroupData[{
Cell[21066, 859, 102, 3, 70, "Input",
 CellID->128820129],
Cell[21171, 864, 161, 5, 36, "Output",
 CellID->576001312]
}, Open  ]],
Cell[21347, 872, 124, 3, 70, "ExampleDelimiter",
 CellID->13348445],
Cell[21474, 877, 77, 1, 70, "ExampleText",
 CellID->220377043],
Cell[CellGroupData[{
Cell[21576, 882, 127, 3, 70, "Input",
 CellID->213227638],
Cell[21706, 887, 160, 5, 36, "Output",
 CellID->24099146]
}, Open  ]],
Cell[CellGroupData[{
Cell[21903, 897, 145, 4, 70, "Input",
 CellID->534296793],
Cell[22051, 903, 231, 7, 36, "Output",
 CellID->1515993]
}, Open  ]],
Cell[22297, 913, 124, 3, 70, "ExampleDelimiter",
 CellID->29051742],
Cell[22424, 918, 57, 1, 70, "ExampleText",
 CellID->503856903],
Cell[CellGroupData[{
Cell[22506, 923, 196, 7, 70, "Input",
 CellID->632197901],
Cell[22705, 932, 162, 5, 36, "Output",
 CellID->112027519]
}, Open  ]],
Cell[CellGroupData[{
Cell[22904, 942, 201, 7, 70, "Input",
 CellID->3372],
Cell[23108, 951, 160, 5, 36, "Output",
 CellID->64274530]
}, Open  ]],
Cell[23283, 959, 125, 3, 70, "ExampleDelimiter",
 CellID->627476549],
Cell[23411, 964, 58, 1, 70, "ExampleText",
 CellID->51853218],
Cell[CellGroupData[{
Cell[23494, 969, 118, 3, 70, "Input",
 CellID->27021],
Cell[23615, 974, 160, 5, 36, "Output",
 CellID->22151708]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[23836, 986, 236, 7, 70, "ExampleSection",
 CellID->76839780],
Cell[24075, 995, 331, 13, 70, "ExampleText",
 CellID->14000026],
Cell[CellGroupData[{
Cell[24431, 1012, 132, 4, 70, "Input",
 CellID->785552779],
Cell[24566, 1018, 186, 6, 36, "Output",
 CellID->81127830]
}, Open  ]],
Cell[24767, 1027, 124, 3, 70, "ExampleDelimiter",
 CellID->85848563],
Cell[24894, 1032, 244, 8, 70, "ExampleText",
 CellID->179461278],
Cell[CellGroupData[{
Cell[25163, 1044, 152, 4, 70, "Input",
 CellID->900203775],
Cell[25318, 1050, 228, 7, 36, "Output",
 CellID->136260768]
}, Open  ]],
Cell[25561, 1060, 355, 13, 70, "ExampleText",
 CellID->103307650],
Cell[CellGroupData[{
Cell[25941, 1077, 109, 3, 70, "Input",
 CellID->602057068],
Cell[26053, 1082, 283, 9, 36, "Output",
 CellID->417557039]
}, Open  ]],
Cell[26351, 1094, 366, 13, 70, "ExampleText",
 CellID->22272967],
Cell[CellGroupData[{
Cell[26742, 1111, 143, 4, 70, "Input",
 CellID->41719149],
Cell[26888, 1117, 241, 8, 36, "Output",
 CellID->254175879]
}, Open  ]],
Cell[27144, 1128, 125, 3, 70, "ExampleDelimiter",
 CellID->316001907],
Cell[27272, 1133, 169, 4, 70, "ExampleText",
 CellID->168215740],
Cell[CellGroupData[{
Cell[27466, 1141, 513, 16, 70, "Input",
 CellID->284729538],
Cell[27982, 1159, 273, 9, 36, "Output",
 CellID->401144143]
}, Open  ]],
Cell[28270, 1171, 217, 7, 70, "ExampleText",
 CellID->29005565],
Cell[CellGroupData[{
Cell[28512, 1182, 481, 16, 70, "Input",
 CellID->328203001],
Cell[28996, 1200, 237, 7, 36, "Output",
 CellID->171689277]
}, Open  ]],
Cell[29248, 1210, 125, 3, 70, "ExampleDelimiter",
 CellID->279681439],
Cell[29376, 1215, 265, 9, 70, "ExampleText",
 CellID->294478095],
Cell[CellGroupData[{
Cell[29666, 1228, 473, 17, 70, "Input",
 CellID->174240470],
Cell[30142, 1247, 415, 16, 51, "Output",
 CellID->26014745]
}, Open  ]],
Cell[30572, 1266, 249, 7, 70, "ExampleText",
 CellID->631563206],
Cell[CellGroupData[{
Cell[30846, 1277, 141, 4, 70, "Input",
 CellID->106030961],
Cell[30990, 1283, 162, 5, 36, "Output",
 CellID->423775818]
}, Open  ]],
Cell[31167, 1291, 267, 8, 70, "ExampleText",
 CellID->157871522],
Cell[CellGroupData[{
Cell[31459, 1303, 131, 4, 70, "Input",
 CellID->13995468],
Cell[31593, 1309, 160, 5, 36, "Output",
 CellID->73703785]
}, Open  ]],
Cell[31768, 1317, 262, 8, 70, "ExampleText",
 CellID->361325790],
Cell[CellGroupData[{
Cell[32055, 1329, 188, 6, 70, "Input",
 CellID->70253842],
Cell[32246, 1337, 161, 5, 36, "Output",
 CellID->165407067]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32456, 1348, 230, 7, 70, "ExampleSection",
 CellID->464709557],
Cell[32689, 1357, 118, 3, 70, "ExampleText",
 CellID->61699174],
Cell[CellGroupData[{
Cell[32832, 1364, 143, 4, 70, "Input",
 CellID->107589248],
Cell[32978, 1370, 161, 5, 36, "Output",
 CellID->293978937]
}, Open  ]],
Cell[33154, 1378, 77, 1, 70, "ExampleText",
 CellID->454896623],
Cell[CellGroupData[{
Cell[33256, 1383, 136, 4, 70, "Input",
 CellID->385657575],
Cell[33395, 1389, 183, 5, 50, "Output",
 CellID->354410719]
}, Open  ]],
Cell[33593, 1397, 125, 3, 70, "ExampleDelimiter",
 CellID->678662024],
Cell[33721, 1402, 115, 3, 70, "ExampleText",
 CellID->29032653],
Cell[CellGroupData[{
Cell[33861, 1409, 155, 5, 70, "Input",
 CellID->108479341],
Cell[34019, 1416, 162, 5, 36, "Output",
 CellID->374990560]
}, Open  ]],
Cell[34196, 1424, 263, 8, 70, "ExampleText",
 CellID->446345418],
Cell[CellGroupData[{
Cell[34484, 1436, 146, 4, 70, "Input",
 CellID->501825511],
Cell[34633, 1442, 176, 5, 36, "Output",
 CellID->375837034]
}, Open  ]],
Cell[34824, 1450, 125, 3, 70, "ExampleDelimiter",
 CellID->476721982],
Cell[34952, 1455, 133, 4, 70, "ExampleText",
 CellID->693243942],
Cell[CellGroupData[{
Cell[35110, 1463, 131, 4, 70, "Input",
 CellID->544352754],
Cell[35244, 1469, 161, 5, 36, "Output",
 CellID->10992345]
}, Open  ]],
Cell[35420, 1477, 226, 8, 70, "ExampleText",
 CellID->153335021],
Cell[CellGroupData[{
Cell[35671, 1489, 128, 4, 70, "Input",
 CellID->551042265],
Cell[35802, 1495, 179, 5, 50, "Output",
 CellID->208546260]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36042, 1507, 311, 9, 70, "SeeAlsoSection",
 CellID->12953],
Cell[36356, 1518, 682, 26, 70, "SeeAlso",
 CellID->12059]
}, Open  ]],
Cell[CellGroupData[{
Cell[37075, 1549, 313, 9, 70, "TutorialsSection",
 CellID->6509],
Cell[37391, 1560, 172, 3, 70, "Tutorials",
 CellID->15822]
}, Open  ]],
Cell[CellGroupData[{
Cell[37600, 1568, 317, 9, 70, "MoreAboutSection",
 CellID->2089066],
Cell[37920, 1579, 135, 3, 70, "MoreAbout",
 CellID->13221541],
Cell[38058, 1584, 157, 3, 70, "MoreAbout",
 CellID->154127445]
}, Open  ]],
Cell[38230, 1590, 50, 0, 70, "History"],
Cell[38283, 1592, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

